/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.elasticsearch.bootstrap.Elasticsearch;
import org.elasticsearch.cli.MockTerminal;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

abstract class ESElasticsearchCliTestCase
extends ESTestCase {
    ESElasticsearchCliTestCase() {
    }

    void runTest(int expectedStatus, boolean expectedInit, Consumer<String> outputConsumer, final InitConsumer initConsumer, String ... args) throws Exception {
        MockTerminal terminal = new MockTerminal();
        final Path home = ESElasticsearchCliTestCase.createTempDir();
        try {
            final AtomicBoolean init = new AtomicBoolean();
            int status = Elasticsearch.main((String[])args, (Elasticsearch)new Elasticsearch(){

                protected Environment createEnv(Terminal terminal, Map<String, String> settings) {
                    Settings realSettings = Settings.builder().put(new Object[]{"path.home", home}).put(settings).build();
                    return new Environment(realSettings);
                }

                void init(boolean daemonize, Path pidFile, boolean quiet, Environment initialEnv) {
                    init.set(true);
                    initConsumer.accept(!daemonize, pidFile, quiet, initialEnv);
                }

                protected boolean addShutdownHook() {
                    return false;
                }
            }, (Terminal)terminal);
            ESElasticsearchCliTestCase.assertThat((Object)status, (Matcher)CoreMatchers.equalTo((Object)expectedStatus));
            ESElasticsearchCliTestCase.assertThat((Object)init.get(), (Matcher)CoreMatchers.equalTo((Object)expectedInit));
            outputConsumer.accept(terminal.getOutput());
        }
        catch (Exception e) {
            this.logger.info(terminal.getOutput());
            throw e;
        }
    }

    static interface InitConsumer {
        public void accept(boolean var1, Path var2, boolean var3, Environment var4);
    }
}

