/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xcontent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import shadow.org.elasticsearch.xcontent.DeprecationHandler;
import shadow.org.elasticsearch.xcontent.XContentLocation;

public class ParseField {
    private final String name;
    private final String[] deprecatedNames;
    private String allReplacedWith = null;
    private final String[] allNames;
    private boolean fullyDeprecated = false;
    private static final String[] EMPTY = new String[0];

    public ParseField(String name, String ... deprecatedNames) {
        this.name = name;
        if (deprecatedNames == null || deprecatedNames.length == 0) {
            this.deprecatedNames = EMPTY;
        } else {
            HashSet set = new HashSet();
            Collections.addAll(set, deprecatedNames);
            this.deprecatedNames = set.toArray(new String[set.size()]);
        }
        HashSet<String> names = new HashSet<String>();
        names.add(name);
        Collections.addAll(names, this.deprecatedNames);
        this.allNames = names.toArray(new String[names.size()]);
    }

    public String getPreferredName() {
        return this.name;
    }

    public String[] getAllNamesIncludedDeprecated() {
        return this.allNames;
    }

    public ParseField withDeprecation(String ... deprecatedNamesOverride) {
        return new ParseField(this.name, deprecatedNamesOverride);
    }

    public ParseField withAllDeprecated(String allReplacedWithOverride) {
        ParseField parseField = this.withDeprecation(this.getAllNamesIncludedDeprecated());
        parseField.allReplacedWith = allReplacedWithOverride;
        return parseField;
    }

    public ParseField withAllDeprecated() {
        ParseField parseField = this.withDeprecation(this.getAllNamesIncludedDeprecated());
        parseField.fullyDeprecated = true;
        return parseField;
    }

    public boolean match(String fieldName, DeprecationHandler deprecationHandler) {
        return this.match(null, () -> XContentLocation.UNKNOWN, fieldName, deprecationHandler);
    }

    public boolean match(String parserName, Supplier<XContentLocation> location, String fieldName, DeprecationHandler deprecationHandler) {
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        if (!this.fullyDeprecated && this.allReplacedWith == null && fieldName.equals(this.name)) {
            return true;
        }
        for (String depName : this.deprecatedNames) {
            if (!fieldName.equals(depName)) continue;
            if (this.fullyDeprecated) {
                deprecationHandler.usedDeprecatedField(parserName, location, fieldName);
            } else if (this.allReplacedWith == null) {
                deprecationHandler.usedDeprecatedName(parserName, location, fieldName, this.name);
            } else {
                deprecationHandler.usedDeprecatedField(parserName, location, fieldName, this.allReplacedWith);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public String getAllReplacedWith() {
        return this.allReplacedWith;
    }

    public String[] getDeprecatedNames() {
        return this.deprecatedNames;
    }

    public static class CommonFields {
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField MISSING = new ParseField("missing", new String[0]);
        public static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
    }
}

