/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains static utilities for creating mutable and immutable collection factories.
 *
 * @see org.eclipse.collections.impl.factory.Lists for creating Lists
 * @see org.eclipse.collections.impl.factory.Sets for creating Sets
 * @see org.eclipse.collections.impl.factory.SortedSets for creating SortedSets
 * @see org.eclipse.collections.impl.factory.Bags for creating Bags
 * @see org.eclipse.collections.impl.factory.Stacks for creating Stacks
 * @see org.eclipse.collections.impl.factory.Maps for creating Maps
 * @see org.eclipse.collections.impl.factory.SortedMaps for creating SortedMaps
 * @see org.eclipse.collections.impl.factory.BiMaps for creating BiMaps
 * @see org.eclipse.collections.impl.factory.Multimaps for creating Multimaps
 * @see org.eclipse.collections.impl.factory.HashingStrategySets for creating Sets with HashingStrategy
 * @see org.eclipse.collections.impl.factory.HashingStrategyMaps for creating Maps with HashingStrategy
 * @see org.eclipse.collections.impl.factory.Iterables for static import friendly shortcuts for creating Lists, Sets, Bags and Maps
 */
package org.eclipse.collections.impl.factory;
