/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.parameter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.report.context.ScalarParameterBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ScalarParameterFragment
extends BirtBaseFragment {
    protected ParameterDefinition parameter = null;

    protected ScalarParameterFragment(ParameterDefinition parameter) {
        this.parameter = parameter;
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        assert (this.parameter != null);
        ScalarParameterBean parameterBean = new ScalarParameterBean(this.parameter);
        attrBean.setParameterBean(parameterBean);
        Locale locale = attrBean.getLocale();
        boolean isDesigner = attrBean.isDesigner();
        try {
            ScalarParameterFragment.prepareParameterBean(attrBean.getReportDesignHandle(request), this.getReportService(), request, parameterBean, this.parameter, locale, isDesigner);
            this.prepareParameterBean(request, this.getReportService(), parameterBean, locale, attrBean.getTimeZone());
        }
        catch (ReportServiceException e) {
            e.printStackTrace();
        }
    }

    protected String doPostService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String className = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        return this.JSPRootPath + "/pages/parameter/" + className + ".jsp";
    }

    public static void prepareParameterBean(IViewerReportDesignHandle designHandle, IViewerReportService service, HttpServletRequest request, ScalarParameterBean parameterBean, ParameterDefinition parameter, Locale locale, boolean isDesigner) throws ReportServiceException {
        Object param;
        HashMap params;
        Object value;
        Map defaultValues;
        Object defaultValue;
        Map displayTexts;
        String displayName = parameter.getPromptText();
        displayName = displayName == null || displayName.length() <= 0 ? parameter.getDisplayName() : displayName;
        displayName = displayName == null || displayName.length() <= 0 ? parameter.getName() : displayName;
        displayName = ParameterAccessor.htmlEncode(displayName);
        parameterBean.setDisplayName(displayName);
        parameterBean.setRequired(parameter.isRequired());
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        if (attrBean.getParametersAsString() != null) {
            Object paramObj = attrBean.getParametersAsString().get(parameterBean.getName());
            if (paramObj instanceof List) {
                parameterBean.setValueList((List)paramObj);
            } else {
                parameterBean.setValue((String)paramObj);
            }
        }
        if ((displayTexts = attrBean.getDisplayTexts()).containsKey(parameterBean.getName())) {
            parameterBean.setDisplayTextInReq(true);
            parameterBean.setDisplayText(DataUtil.getString(displayTexts.get(parameterBean.getName())));
        }
        if ((defaultValue = (defaultValues = attrBean.getDefaultValues()).get(parameter.getName())) != null) {
            if (defaultValue instanceof Object[]) {
                Object[] paramDefaultValues = (Object[])defaultValue;
                ArrayList<String> convertedDefaultValues = new ArrayList<String>(paramDefaultValues.length);
                for (int i = 0; i < paramDefaultValues.length; ++i) {
                    value = paramDefaultValues[i];
                    convertedDefaultValues.add(DataUtil.getDisplayValue(value, attrBean.getTimeZone()));
                }
                parameterBean.setDefaultValues(convertedDefaultValues);
            } else {
                parameterBean.setDefaultValue(DataUtil.getDisplayValue(defaultValue, attrBean.getTimeZone()));
            }
            parameterBean.setDefaultDisplayText(DataUtil.getDisplayValue(null, parameter.getPattern(), defaultValue, locale, attrBean.getTimeZone()));
        }
        if ((params = attrBean.getParameters()) != null && params.containsKey(parameter.getName()) && (param = params.get(parameter.getName())) != null) {
            Object displayTextObj = null;
            if (param instanceof Object[]) {
                Object[] values = (Object[])param;
                ArrayList<String> paramList = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    String value2 = DataUtil.getDisplayValue(values[i], attrBean.getTimeZone());
                    paramList.add(value2);
                }
                parameterBean.setValueList(paramList);
                if (values.length > 0) {
                    displayTextObj = values[0];
                }
            } else {
                displayTextObj = param;
                value = DataUtil.getDisplayValue(param, attrBean.getTimeZone());
                parameterBean.setValue((String)value);
            }
            if (!displayTexts.containsKey(parameterBean.getName())) {
                parameterBean.setDisplayTextInReq(false);
                String displayText = DataUtil.getDisplayValue(null, parameter.getPattern(), displayTextObj, locale, attrBean.getTimeZone());
                parameterBean.setDisplayText(displayText);
            }
        }
    }

    protected void prepareParameterBean(HttpServletRequest request, IViewerReportService service, ScalarParameterBean parameterBean, Locale locale, TimeZone timeZone) throws ReportServiceException {
    }
}

