/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.dev;

import com.github.kevinsawicki.http.HttpRequest;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class UploadMojo
extends AbstractMojo {
    private MavenSession session;
    private File sonarHome;
    private URL sonarUrl;

    public void execute() throws MojoExecutionException {
        this.checkSonarHome();
        boolean deployed = false;
        for (MavenProject module : this.session.getSortedProjects()) {
            if (!"sonar-plugin".equals(module.getPackaging())) continue;
            this.copyJar(module);
            deployed = true;
        }
        if (deployed) {
            this.restartServer();
        } else {
            this.getLog().info((CharSequence)"No plugins to be uploaded");
        }
    }

    private void checkSonarHome() throws MojoExecutionException {
        if (!this.sonarHome.isDirectory() && !this.sonarHome.exists()) {
            throw new MojoExecutionException("Server home directory does not exist: " + this.sonarHome.getAbsolutePath());
        }
        File confFile = new File(this.sonarHome, "conf/sonar.properties");
        if (!confFile.isFile() && !confFile.exists()) {
            throw new MojoExecutionException("Not a valid server home directory: " + this.sonarHome.getAbsolutePath());
        }
    }

    private void copyJar(MavenProject module) throws MojoExecutionException {
        File buildDir = new File(module.getBuild().getDirectory());
        File jar = new File(buildDir, module.getBuild().getFinalName() + ".jar");
        if (!jar.exists()) {
            throw new MojoExecutionException("Plugin artifact does not exist for module " + module.getArtifactId() + ": " + jar.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Copying " + jar.getAbsolutePath()));
        File downloadsDir = new File(this.sonarHome, "extensions/downloads");
        downloadsDir.mkdir();
        try {
            FileUtils.copyFileToDirectory((File)jar, (File)downloadsDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Fail to copy %s to %s", jar.getAbsolutePath(), downloadsDir), (Exception)e);
        }
    }

    private void restartServer() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Restarting server");
        try {
            HttpRequest request = HttpRequest.post((URL)new URL(this.sonarUrl, "/api/system/restart"));
            if (!request.noContent()) {
                throw new MojoExecutionException("Fail to restart server " + this.sonarUrl + ": " + request.message());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL", (Exception)e);
        }
        this.getLog().info((CharSequence)"Server restarted");
    }
}

