/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:tomcat-maven-plugin:1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Tomcat Maven Plugin", 0);
        this.append(sb, "The Tomcat Maven Plugin provides goals to manipulate WAR projects within the Tomcat servlet container.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 18 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "tomcat:deploy", 0);
            this.append(sb, "Deploy a WAR to Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: war)", 2);
                this.append(sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The Tomcat webapp tag name to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "warFile", 2);
                this.append(sb, "The path of the WAR file to deploy.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy-only".equals(this.goal)) {
            this.append(sb, "tomcat:deploy-only", 0);
            this.append(sb, "Deploy a WAR to Tomcat witjout forking the package lifecycle", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: war)", 2);
                this.append(sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The Tomcat webapp tag name to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "warFile", 2);
                this.append(sb, "The path of the WAR file to deploy.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "exploded".equals(this.goal)) {
            this.append(sb, "tomcat:exploded", 0);
            this.append(sb, "Deploy an exploded WAR to Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: war)", 2);
                this.append(sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The Tomcat webapp tag name to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "warDirectory", 2);
                this.append(sb, "The path of the exploded WAR directory to deploy.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "tomcat:help", 0);
            this.append(sb, "Display help information on tomcat-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0tomcat:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "info".equals(this.goal)) {
            this.append(sb, "tomcat:info", 0);
            this.append(sb, "Lists information about the Tomcat version, OS, and JVM properties.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "inplace".equals(this.goal)) {
            this.append(sb, "tomcat:inplace", 0);
            this.append(sb, "Deploy a WAR in-place to Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: war)", 2);
                this.append(sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The Tomcat webapp tag name to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceDirectory", 2);
                this.append(sb, "The path of the inplace WAR directory to deploy.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list".equals(this.goal)) {
            this.append(sb, "tomcat:list", 0);
            this.append(sb, "Lists all the currently deployed web applications in Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "redeploy".equals(this.goal)) {
            this.append(sb, "tomcat:redeploy", 0);
            this.append(sb, "Redeploy a WAR in Tomcat. Deploy with forcing update flag to true", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: war)", 2);
                this.append(sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The Tomcat webapp tag name to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "warFile", 2);
                this.append(sb, "The path of the WAR file to deploy.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "reload".equals(this.goal)) {
            this.append(sb, "tomcat:reload", 0);
            this.append(sb, "Reload a WAR in Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "resources".equals(this.goal)) {
            this.append(sb, "tomcat:resources", 0);
            this.append(sb, "Lists JNDI resources in Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "type", 2);
                this.append(sb, "The class name of the resources to list, or null for all.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "roles".equals(this.goal)) {
            this.append(sb, "tomcat:roles", 0);
            this.append(sb, "Lists security roles in Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "tomcat:run", 0);
            this.append(sb, "Runs the current project as a dynamic web application using an embedded Tomcat server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addContextWarDependencies (Default: false)", 2);
                this.append(sb, "Will create a tomcat context for each dependencies of war type. To preserve backward compatibility it's false by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2);
                this.append(sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDir", 2);
                this.append(sb, "The classes directory for the web application being run.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationDir", 2);
                this.append(sb, "The directory to create the Tomcat server configuration under.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "delegate (Default: true)", 2);
                this.append(sb, "Set the 'follow standard delegation model' flag used to configure our ClassLoader.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpsPort (Default: 0)", 2);
                this.append(sb, "The https port to run the Tomcat server on. By default it's 0 this means won't be started. The https connector will be started only for value > 0.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port to run the Tomcat server on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml", 2);
                this.append(sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the Tomcat Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatWebXml", 2);
                this.append(sb, "overriding the providing web.xml to run tomcat", 3);
                this.append(sb, "", 0);
                this.append(sb, "uriEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The character encoding to use for decoding URIs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSeparateTomcatClassLoader (Default: false)", 2);
                this.append(sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceDirectory", 2);
                this.append(sb, "The web resources directory for the web application being run.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-war".equals(this.goal)) {
            this.append(sb, "tomcat:run-war", 0);
            this.append(sb, "Runs the current project as a packaged web application using an embedded Tomcat server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addContextWarDependencies (Default: false)", 2);
                this.append(sb, "Will create a tomcat context for each dependencies of war type. To preserve backward compatibility it's false by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2);
                this.append(sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationDir", 2);
                this.append(sb, "The directory to create the Tomcat server configuration under.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpsPort (Default: 0)", 2);
                this.append(sb, "The https port to run the Tomcat server on. By default it's 0 this means won't be started. The https connector will be started only for value > 0.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port to run the Tomcat server on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml", 2);
                this.append(sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the Tomcat Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatWebXml", 2);
                this.append(sb, "overriding the providing web.xml to run tomcat", 3);
                this.append(sb, "", 0);
                this.append(sb, "uriEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The character encoding to use for decoding URIs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSeparateTomcatClassLoader (Default: false)", 2);
                this.append(sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warDirectory", 2);
                this.append(sb, "The path of the exploded WAR directory to run.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-war-only".equals(this.goal)) {
            this.append(sb, "tomcat:run-war-only", 0);
            this.append(sb, "Runs the current project as a packaged web application using an embedded Tomcat server without forking the package cycle.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addContextWarDependencies (Default: false)", 2);
                this.append(sb, "Will create a tomcat context for each dependencies of war type. To preserve backward compatibility it's false by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2);
                this.append(sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationDir", 2);
                this.append(sb, "The directory to create the Tomcat server configuration under.", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpsPort (Default: 0)", 2);
                this.append(sb, "The https port to run the Tomcat server on. By default it's 0 this means won't be started. The https connector will be started only for value > 0.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port to run the Tomcat server on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml", 2);
                this.append(sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the Tomcat Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatWebXml", 2);
                this.append(sb, "overriding the providing web.xml to run tomcat", 3);
                this.append(sb, "", 0);
                this.append(sb, "uriEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The character encoding to use for decoding URIs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSeparateTomcatClassLoader (Default: false)", 2);
                this.append(sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warDirectory", 2);
                this.append(sb, "The path of the exploded WAR directory to run.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sessions".equals(this.goal)) {
            this.append(sb, "tomcat:sessions", 0);
            this.append(sb, "Lists session information for a WAR in Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start".equals(this.goal)) {
            this.append(sb, "tomcat:start", 0);
            this.append(sb, "Start a WAR in Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop".equals(this.goal)) {
            this.append(sb, "tomcat:stop", 0);
            this.append(sb, "Stop a WAR in Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "undeploy".equals(this.goal)) {
            this.append(sb, "tomcat:undeploy", 0);
            this.append(sb, "Undeploy a WAR from Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Whether to fail the build if the web application cannot be undeployed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

