/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cassandraunit.dataset.ClassPathDataSet;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.FileDataSet;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.KeyspaceModel;

public class MultiSourceDataSet
implements DataSet {
    private final List<DataSet> dataSets = new ArrayList<DataSet>();
    private final List<ColumnFamilyModel> mergedColumnFamilies = new ArrayList<ColumnFamilyModel>();

    public static MultiSourceDataSet fromClassPath(String ... classpathFileNames) {
        List<DataSet> ds = MultiSourceDataSet.buildDataSetList(classpathFileNames);
        for (String fileName : classpathFileNames) {
            ds.add(new ClassPathDataSet(fileName));
        }
        return new MultiSourceDataSet(ds);
    }

    public static MultiSourceDataSet fromFiles(String ... fileNames) {
        List<DataSet> ds = MultiSourceDataSet.buildDataSetList(fileNames);
        for (String fileName : fileNames) {
            ds.add(new FileDataSet(fileName));
        }
        return new MultiSourceDataSet(ds);
    }

    private static List<DataSet> buildDataSetList(String ... fileNames) {
        if (fileNames == null) {
            throw new ParseException("A non-null list of filenames must be supplied");
        }
        return new ArrayList<DataSet>(fileNames.length);
    }

    private MultiSourceDataSet(List<DataSet> dataSets) {
        String keyspaceName = "";
        for (DataSet dataSet : dataSets) {
            if (keyspaceName.isEmpty()) {
                keyspaceName = dataSet.getKeyspace().getName();
            } else {
                this.checkForInconsistentKeyspaceNames(keyspaceName, dataSet);
            }
            this.checkForDuplicateColumnFamilies(dataSet);
            this.mergedColumnFamilies.addAll(dataSet.getColumnFamilies());
            this.dataSets.add(dataSet);
        }
    }

    private final void checkForInconsistentKeyspaceNames(String keyspaceName, DataSet dataSet) {
        if (!keyspaceName.equals(dataSet.getKeyspace().getName())) {
            throw new ParseException(new IllegalArgumentException("Only one keyspace name is supported: was expecting " + keyspaceName + " but found " + dataSet.getKeyspace().getName()));
        }
    }

    private final void checkForDuplicateColumnFamilies(DataSet mergeCandidate) {
        Set<String> intersection = MultiSourceDataSet.getColumnFamilyNames(this.mergedColumnFamilies);
        Set<String> candidateColumnFamilyNames = MultiSourceDataSet.getColumnFamilyNames(mergeCandidate.getColumnFamilies());
        intersection.retainAll(candidateColumnFamilyNames);
        if (!intersection.isEmpty()) {
            throw new ParseException("Duplicate Column Family name(s) found while checking whether datasets can be merged:" + intersection);
        }
    }

    private static final Set<String> getColumnFamilyNames(List<ColumnFamilyModel> columnFamilies) {
        HashSet<String> names = new HashSet<String>();
        for (ColumnFamilyModel cfm : columnFamilies) {
            names.add(cfm.getName());
        }
        return names;
    }

    @Override
    public KeyspaceModel getKeyspace() {
        return this.dataSets.get(0).getKeyspace();
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        return this.mergedColumnFamilies;
    }
}

