/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.DataSetFileExtensionEnum;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.json.FileJsonDataSet;
import org.cassandraunit.dataset.xml.FileXmlDataSet;
import org.cassandraunit.dataset.yaml.FileYamlDataSet;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.KeyspaceModel;

public class FileDataSet
implements DataSet {
    DataSet dataSet = null;

    public FileDataSet(String dataSetLocation) {
        DataSetFileExtensionEnum dataSetExtensionEnum = this.getDataSetExtension(dataSetLocation);
        switch (dataSetExtensionEnum) {
            case xml: {
                this.dataSet = new FileXmlDataSet(dataSetLocation);
                break;
            }
            case json: {
                this.dataSet = new FileJsonDataSet(dataSetLocation);
                break;
            }
            case yaml: {
                this.dataSet = new FileYamlDataSet(dataSetLocation);
                break;
            }
            default: {
                throw new ParseException("dataSet file extension must be one of .xml, .json, .yaml");
            }
        }
    }

    private DataSetFileExtensionEnum getDataSetExtension(String dataSetLocation) {
        String extension = StringUtils.substringAfterLast((String)dataSetLocation, (String)".");
        if (extension == null || extension.isEmpty()) {
            throw new ParseException("dataSet file extension must be one of .xml, .json, .yaml");
        }
        return DataSetFileExtensionEnum.valueOf(extension);
    }

    @Override
    public KeyspaceModel getKeyspace() {
        return this.dataSet.getKeyspace();
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        return this.dataSet.getColumnFamilies();
    }
}

