/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.fasterxml.uuid;

import camundajar.impl.com.fasterxml.uuid.EthernetAddress;
import camundajar.impl.com.fasterxml.uuid.Generators;
import camundajar.impl.com.fasterxml.uuid.NoArgGenerator;
import camundajar.impl.com.fasterxml.uuid.StringArgGenerator;
import camundajar.impl.com.fasterxml.uuid.impl.NameBasedGenerator;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class Jug {
    protected static final HashMap<String, String> TYPES = new HashMap();
    protected static final HashMap<String, String> OPTIONS;

    protected static void printUsage() {
        String clsName = Jug.class.getName();
        System.err.println("Usage: java " + clsName + " [options] type");
        System.err.println("Where options are:");
        System.err.println("  --count / -c <number>: will generate <number> UUIDs (default: 1)");
        System.err.println("  --ethernet-address / -e <ether-address>: defines the ethernet address");
        System.err.println("    (in xx:xx:xx:xx:xx:xx notation, usually obtained using 'ifconfig' etc)");
        System.err.println("    to use with time-based UUID generation");
        System.err.println("  --help / -h: lists the usage (ie. what you see now)");
        System.err.println("  --name / -n: specifies");
        System.err.println("     o name for name-based UUID generation");
        System.err.println("     o 'information' part of tag-URI for tag-URI UUID generation");
        System.err.println("  --namespace / -s: specifies");
        System.err.println("    o the namespace (DNS or URL) for name-based UUID generation");
        System.err.println("    o 'authority' part of tag-URI for tag-URI UUID generation;");
        System.err.println("        (fully-qualified domain name, email address)");
        System.err.println("  --performance / -p: measure time it takes to generate UUID(s).");
        System.err.println("    [note that UUIDs are not printed out unless 'verbose' is also specified]");
        System.err.println("  --verbose / -v: lists additional information about UUID generation\n    (by default only UUIDs are printed out (to make it usable in scripts)");
        System.err.println("And type is one of:");
        System.err.println("  time-based / t: generate UUID based on current time and optional\n    location information (defined with -e option)");
        System.err.println("  random-based / r: generate UUID based on the default secure random number generator");
        System.err.println("  name-based / n: generate UUID based on MD5 hash of given String ('name')");
        System.err.println("  reordered-time-based / o: generate UUID based on current time and optional\n    location information (defined with -e option)");
        System.err.println("  epoch-based / e: generate UUID based on current time (as 'epoch') and random number");
    }

    private static void printMap(Map<String, String> m, PrintStream out, boolean option) {
        int i = 0;
        int len = m.size();
        for (Map.Entry<String, String> en : m.entrySet()) {
            if (++i > 1) {
                if (i < len) {
                    out.print(", ");
                } else {
                    out.print(" and ");
                }
            }
            if (option) {
                out.print("--");
            }
            out.print(en.getKey());
            out.print(" (");
            if (option) {
                out.print("-");
            }
            out.print(en.getValue());
            out.print(")");
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Jug.printUsage();
            return;
        }
        int count = args.length;
        String type = args[count - 1];
        boolean verbose = false;
        int genCount = 1;
        String name = null;
        String nameSpace = null;
        EthernetAddress addr = null;
        boolean performance = false;
        --count;
        String tmp = TYPES.get(type);
        if (tmp == null) {
            if (!TYPES.containsValue(type)) {
                System.err.println("Unrecognized UUID generation type '" + type + "'; currently available ones are:");
                Jug.printMap(TYPES, System.err, false);
                System.err.println();
                System.exit(1);
            }
        } else {
            type = tmp;
        }
        NoArgGenerator noArgGenerator = null;
        NameBasedGenerator nameArgGenerator = null;
        for (int i = 0; i < count; ++i) {
            String opt = args[i];
            if (opt.length() == 0 || opt.charAt(0) != '-') {
                System.err.println("Unrecognized option '" + opt + "' (missing leading hyphen?), exiting.");
                System.exit(1);
            }
            char option = '\u0000';
            if (opt.startsWith("--")) {
                String o = OPTIONS.get(opt.substring(2));
                if (o != null) {
                    option = o.charAt(0);
                }
            } else if (OPTIONS.containsValue(opt.substring(1))) {
                option = opt.charAt(1);
            }
            if (option == '\u0000') {
                System.err.println("Unrecognized option '" + opt + "'; exiting.");
                System.err.print("[options currently available are: ");
                Jug.printMap(OPTIONS, System.err, true);
                System.err.println("]");
                System.exit(1);
            }
            try {
                switch (option) {
                    case 'c': {
                        String next = args[++i];
                        try {
                            genCount = Integer.parseInt(next);
                        }
                        catch (NumberFormatException nex) {
                            System.err.println("Invalid number argument for option '" + opt + "', exiting.");
                            System.exit(1);
                        }
                        if (genCount >= 1) break;
                        System.err.println("Invalid number argument for option '" + opt + "'; negative numbers not allowed, ignoring (defaults to 1).");
                        break;
                    }
                    case 'e': {
                        String next = args[++i];
                        try {
                            addr = EthernetAddress.valueOf(next);
                        }
                        catch (NumberFormatException nex) {
                            System.err.println("Invalid ethernet address for option '" + opt + "', error: " + nex.toString());
                            System.exit(1);
                        }
                        break;
                    }
                    case 'h': {
                        Jug.printUsage();
                        return;
                    }
                    case 'n': {
                        name = args[++i];
                        break;
                    }
                    case 'p': {
                        performance = true;
                        break;
                    }
                    case 's': {
                        nameSpace = args[++i];
                        break;
                    }
                    case 'v': {
                        verbose = true;
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                System.err.println("Missing argument for option '" + opt + "', exiting.");
                System.exit(1);
            }
        }
        char typeC = type.charAt(0);
        UUID nsUUID = null;
        boolean usesRnd = false;
        switch (typeC) {
            case 'o': 
            case 't': {
                usesRnd = true;
                if (addr == null) {
                    if (verbose) {
                        System.out.print("(no address specified, generating dummy address: ");
                    }
                    addr = EthernetAddress.constructMulticastAddress(new Random(System.currentTimeMillis()));
                    if (verbose) {
                        System.out.print(addr.toString());
                        System.out.println(")");
                    }
                }
                noArgGenerator = typeC == 't' ? Generators.timeBasedGenerator(addr) : Generators.timeBasedReorderedGenerator(addr);
                break;
            }
            case 'r': {
                usesRnd = true;
                SecureRandom r = new SecureRandom();
                if (verbose) {
                    System.out.print("(using secure random generator, info = '" + r.getProvider().getInfo() + "')");
                }
                noArgGenerator = Generators.randomBasedGenerator(r);
                break;
            }
            case 'e': {
                usesRnd = true;
                SecureRandom r = new SecureRandom();
                if (verbose) {
                    System.out.print("(using secure random generator, info = '" + r.getProvider().getInfo() + "')");
                }
                noArgGenerator = Generators.timeBasedEpochGenerator(r);
                break;
            }
            case 'm': {
                usesRnd = true;
                SecureRandom r = new SecureRandom();
                if (verbose) {
                    System.out.print("(using secure random generator, info = '" + r.getProvider().getInfo() + "')");
                }
                noArgGenerator = Generators.timeBasedEpochRandomGenerator(r);
                break;
            }
            case 'n': {
                if (nameSpace == null) {
                    System.err.println("--name-space (-s) - argument missing when using method that requires it, exiting.");
                    System.exit(1);
                }
                if (name == null) {
                    System.err.println("--name (-n) - argument missing when using method that requires it, exiting.");
                    System.exit(1);
                }
                if (typeC == 'n') {
                    String orig = nameSpace;
                    if ((nameSpace = nameSpace.toLowerCase()).equals("url")) {
                        nsUUID = NameBasedGenerator.NAMESPACE_URL;
                    } else if (nameSpace.equals("dns")) {
                        nsUUID = NameBasedGenerator.NAMESPACE_DNS;
                    } else {
                        System.err.println("Unrecognized namespace '" + orig + "'; only DNS and URL allowed for name-based generation.");
                        System.exit(1);
                    }
                }
                nameArgGenerator = Generators.nameBasedGenerator(nsUUID);
            }
        }
        if (verbose) {
            System.out.println();
        }
        long now = 0L;
        if (performance) {
            if (usesRnd) {
                if (verbose) {
                    System.out.println("(initializing random number generator before UUID generation so that performance measurements are not skewed due to one-time init costs)");
                }
                noArgGenerator.generate();
                if (verbose) {
                    System.out.println("(random number generator initialized ok)");
                }
            }
            now = System.currentTimeMillis();
        }
        for (int i = 0; i < genCount; ++i) {
            UUID uuid;
            UUID uUID = uuid = nameArgGenerator == null ? noArgGenerator.generate() : ((StringArgGenerator)nameArgGenerator).generate(name);
            if (verbose) {
                System.out.print("UUID: ");
            }
            if (performance && !verbose) continue;
            System.out.println(uuid.toString());
        }
        if (verbose) {
            System.out.println("Done.");
        }
        if (performance) {
            now = System.currentTimeMillis() - now;
            long avg = (now * 10L + (long)(genCount / 2)) / (long)genCount;
            System.out.println("Performance: took " + now + " milliseconds to generate (and print out) " + genCount + " UUIDs; average being " + avg / 10L + "." + avg % 10L + " msec.");
        }
    }

    static {
        TYPES.put("time-based", "t");
        TYPES.put("random-based", "r");
        TYPES.put("name-based", "n");
        TYPES.put("reordered-time-based", "o");
        TYPES.put("epoch-time-based", "e");
        TYPES.put("random-epoch-time-based", "m");
        OPTIONS = new HashMap();
        OPTIONS.put("count", "c");
        OPTIONS.put("ethernet-address", "e");
        OPTIONS.put("help", "h");
        OPTIONS.put("namespace", "s");
        OPTIONS.put("name", "n");
        OPTIONS.put("performance", "p");
        OPTIONS.put("verbose", "v");
    }
}

