/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.type;

import org.camunda.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class LongDataTypeTransformer
implements DmnDataTypeTransformer {
    @Override
    public TypedValue transform(Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            long longValue = this.transformNumber((Number)value);
            return Variables.longValue((Long)longValue);
        }
        if (value instanceof String) {
            long longValue = this.transformString((String)value);
            return Variables.longValue((Long)longValue);
        }
        throw new IllegalArgumentException();
    }

    protected long transformNumber(Number value) {
        if (this.isLong(value)) {
            return value.longValue();
        }
        throw new IllegalArgumentException();
    }

    protected boolean isLong(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((long)doubleValue);
    }

    protected long transformString(String value) {
        return Long.parseLong(value);
    }
}

