/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionRequirementsGraph;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnDecisionContext;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionImpl;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableResultImpl;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.commons.utils.EnsureUtil;

public class DefaultDmnEngine
implements DmnEngine {
    protected static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected DefaultDmnEngineConfiguration dmnEngineConfiguration;
    protected DmnTransformer transformer;

    public DefaultDmnEngine(DefaultDmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        this.transformer = dmnEngineConfiguration.getTransformer();
    }

    @Override
    public DmnEngineConfiguration getConfiguration() {
        return this.dmnEngineConfiguration;
    }

    @Override
    public List<DmnDecision> parseDecisions(InputStream inputStream) {
        EnsureUtil.ensureNotNull((String)"inputStream", (Object)inputStream);
        return this.transformer.createTransform().modelInstance(inputStream).transformDecisions();
    }

    @Override
    public List<DmnDecision> parseDecisions(DmnModelInstance dmnModelInstance) {
        EnsureUtil.ensureNotNull((String)"dmnModelInstance", (Object)dmnModelInstance);
        return this.transformer.createTransform().modelInstance(dmnModelInstance).transformDecisions();
    }

    @Override
    public DmnDecision parseDecision(String decisionKey, InputStream inputStream) {
        EnsureUtil.ensureNotNull((String)"decisionKey", (Object)decisionKey);
        List<DmnDecision> decisions = this.parseDecisions(inputStream);
        for (DmnDecision decision : decisions) {
            if (!decisionKey.equals(decision.getKey())) continue;
            return decision;
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }

    @Override
    public DmnDecision parseDecision(String decisionKey, DmnModelInstance dmnModelInstance) {
        EnsureUtil.ensureNotNull((String)"decisionKey", (Object)decisionKey);
        List<DmnDecision> decisions = this.parseDecisions(dmnModelInstance);
        for (DmnDecision decision : decisions) {
            if (!decisionKey.equals(decision.getKey())) continue;
            return decision;
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }

    @Override
    public DmnDecisionRequirementsGraph parseDecisionRequirementsGraph(InputStream inputStream) {
        EnsureUtil.ensureNotNull((String)"inputStream", (Object)inputStream);
        return this.transformer.createTransform().modelInstance(inputStream).transformDecisionRequirementsGraph();
    }

    @Override
    public DmnDecisionRequirementsGraph parseDecisionRequirementsGraph(DmnModelInstance dmnModelInstance) {
        EnsureUtil.ensureNotNull((String)"dmnModelInstance", (Object)dmnModelInstance);
        return this.transformer.createTransform().modelInstance(dmnModelInstance).transformDecisionRequirementsGraph();
    }

    @Override
    public DmnDecisionTableResult evaluateDecisionTable(DmnDecision decision, Map<String, Object> variables) {
        EnsureUtil.ensureNotNull((String)"decision", (Object)decision);
        EnsureUtil.ensureNotNull((String)"variables", variables);
        return this.evaluateDecisionTable(decision, Variables.fromMap(variables).asVariableContext());
    }

    @Override
    public DmnDecisionTableResult evaluateDecisionTable(DmnDecision decision, VariableContext variableContext) {
        EnsureUtil.ensureNotNull((String)"decision", (Object)decision);
        EnsureUtil.ensureNotNull((String)"variableContext", (Object)variableContext);
        if (decision instanceof DmnDecisionImpl && decision.isDecisionTable()) {
            DefaultDmnDecisionContext decisionContext = new DefaultDmnDecisionContext(this.dmnEngineConfiguration);
            DmnDecisionResult decisionResult = decisionContext.evaluateDecision(decision, variableContext);
            return DmnDecisionTableResultImpl.wrap(decisionResult);
        }
        throw LOG.decisionIsNotADecisionTable(decision);
    }

    @Override
    public DmnDecisionTableResult evaluateDecisionTable(String decisionKey, InputStream inputStream, Map<String, Object> variables) {
        EnsureUtil.ensureNotNull((String)"variables", variables);
        return this.evaluateDecisionTable(decisionKey, inputStream, Variables.fromMap(variables).asVariableContext());
    }

    @Override
    public DmnDecisionTableResult evaluateDecisionTable(String decisionKey, InputStream inputStream, VariableContext variableContext) {
        EnsureUtil.ensureNotNull((String)"decisionKey", (Object)decisionKey);
        List<DmnDecision> decisions = this.parseDecisions(inputStream);
        for (DmnDecision decision : decisions) {
            if (!decisionKey.equals(decision.getKey())) continue;
            return this.evaluateDecisionTable(decision, variableContext);
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }

    @Override
    public DmnDecisionTableResult evaluateDecisionTable(String decisionKey, DmnModelInstance dmnModelInstance, Map<String, Object> variables) {
        EnsureUtil.ensureNotNull((String)"variables", variables);
        return this.evaluateDecisionTable(decisionKey, dmnModelInstance, Variables.fromMap(variables).asVariableContext());
    }

    @Override
    public DmnDecisionTableResult evaluateDecisionTable(String decisionKey, DmnModelInstance dmnModelInstance, VariableContext variableContext) {
        EnsureUtil.ensureNotNull((String)"decisionKey", (Object)decisionKey);
        List<DmnDecision> decisions = this.parseDecisions(dmnModelInstance);
        for (DmnDecision decision : decisions) {
            if (!decisionKey.equals(decision.getKey())) continue;
            return this.evaluateDecisionTable(decision, variableContext);
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }

    @Override
    public DmnDecisionResult evaluateDecision(DmnDecision decision, Map<String, Object> variables) {
        EnsureUtil.ensureNotNull((String)"decision", (Object)decision);
        EnsureUtil.ensureNotNull((String)"variables", variables);
        return this.evaluateDecision(decision, Variables.fromMap(variables).asVariableContext());
    }

    @Override
    public DmnDecisionResult evaluateDecision(DmnDecision decision, VariableContext variableContext) {
        EnsureUtil.ensureNotNull((String)"decision", (Object)decision);
        EnsureUtil.ensureNotNull((String)"variableContext", (Object)variableContext);
        if (decision instanceof DmnDecisionImpl) {
            DefaultDmnDecisionContext decisionContext = new DefaultDmnDecisionContext(this.dmnEngineConfiguration);
            return decisionContext.evaluateDecision(decision, variableContext);
        }
        throw LOG.decisionTypeNotSupported(decision);
    }

    @Override
    public DmnDecisionResult evaluateDecision(String decisionKey, InputStream inputStream, Map<String, Object> variables) {
        EnsureUtil.ensureNotNull((String)"variables", variables);
        return this.evaluateDecision(decisionKey, inputStream, Variables.fromMap(variables).asVariableContext());
    }

    @Override
    public DmnDecisionResult evaluateDecision(String decisionKey, InputStream inputStream, VariableContext variableContext) {
        EnsureUtil.ensureNotNull((String)"decisionKey", (Object)decisionKey);
        List<DmnDecision> decisions = this.parseDecisions(inputStream);
        for (DmnDecision decision : decisions) {
            if (!decisionKey.equals(decision.getKey())) continue;
            return this.evaluateDecision(decision, variableContext);
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }

    @Override
    public DmnDecisionResult evaluateDecision(String decisionKey, DmnModelInstance dmnModelInstance, Map<String, Object> variables) {
        EnsureUtil.ensureNotNull((String)"variables", variables);
        return this.evaluateDecision(decisionKey, dmnModelInstance, Variables.fromMap(variables).asVariableContext());
    }

    @Override
    public DmnDecisionResult evaluateDecision(String decisionKey, DmnModelInstance dmnModelInstance, VariableContext variableContext) {
        EnsureUtil.ensureNotNull((String)"decisionKey", (Object)decisionKey);
        List<DmnDecision> decisions = this.parseDecisions(dmnModelInstance);
        for (DmnDecision decision : decisions) {
            if (!decisionKey.equals(decision.getKey())) continue;
            return this.evaluateDecision(decision, variableContext);
        }
        throw LOG.unableToFindDecisionWithKey(decisionKey);
    }
}

