/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;
    protected String taskId;

    public DeleteAttachmentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public DeleteAttachmentCmd(String taskId, String attachmentId) {
        this.taskId = taskId;
        this.attachmentId = attachmentId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        TaskEntity task;
        AttachmentEntity attachment = null;
        if (this.taskId != null && !this.taskId.isBlank()) {
            attachment = (AttachmentEntity)commandContext.getAttachmentManager().findAttachmentByTaskIdAndAttachmentId(this.taskId, this.attachmentId);
            EnsureUtil.ensureNotNull("No attachment exists for task id '" + this.taskId + " and attachmentId '" + this.attachmentId + "'.", "attachment", (Object)attachment);
        } else {
            attachment = commandContext.getDbEntityManager().selectById(AttachmentEntity.class, this.attachmentId);
            EnsureUtil.ensureNotNull("No attachment exists with attachmentId '" + this.attachmentId + "'.", "attachment", (Object)attachment);
        }
        commandContext.getDbEntityManager().delete(attachment);
        if (attachment.getContentId() != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(attachment.getContentId());
        }
        if (attachment.getTaskId() != null && !attachment.getTaskId().isBlank() && (task = commandContext.getTaskManager().findTaskById(attachment.getTaskId())) != null) {
            PropertyChange propertyChange = new PropertyChange("name", null, attachment.getName());
            commandContext.getOperationLogManager().logAttachmentOperation("DeleteAttachment", task, propertyChange);
            task.triggerUpdateEvent();
        }
        return null;
    }
}

