/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment.jobexecutor;

import java.util.Map;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedJobExecutor;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.container.impl.metadata.spi.JobAcquisitionXml;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.RuntimeContainerJobExecutor;

public class StartJobAcquisitionStep
extends DeploymentOperationStep {
    protected static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected final JobAcquisitionXml jobAcquisitionXml;

    public StartJobAcquisitionStep(JobAcquisitionXml jobAcquisitionXml) {
        this.jobAcquisitionXml = jobAcquisitionXml;
    }

    @Override
    public String getName() {
        return "Start job acquisition '" + this.jobAcquisitionXml.getName() + "'";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ClassLoader configurationClassloader = null;
        configurationClassloader = processApplication != null ? processApplication.getProcessApplicationClassloader() : ProcessEngineConfiguration.class.getClassLoader();
        String configurationClassName = this.jobAcquisitionXml.getJobExecutorClassName();
        if (configurationClassName == null || configurationClassName.isEmpty()) {
            configurationClassName = RuntimeContainerJobExecutor.class.getName();
        }
        Class<? extends JobExecutor> jobExecutorClass = this.loadJobExecutorClass(configurationClassloader, configurationClassName);
        JobExecutor jobExecutor = this.instantiateJobExecutor(jobExecutorClass);
        Map<String, String> properties = this.jobAcquisitionXml.getProperties();
        PropertyHelper.applyProperties(jobExecutor, properties);
        JmxManagedJobExecutor jmxManagedJobExecutor = new JmxManagedJobExecutor(jobExecutor);
        serviceContainer.startService(ServiceTypes.JOB_EXECUTOR, this.jobAcquisitionXml.getName(), jmxManagedJobExecutor);
    }

    protected JobExecutor instantiateJobExecutor(Class<? extends JobExecutor> configurationClass) {
        try {
            return configurationClass.newInstance();
        }
        catch (Exception e) {
            throw LOG.couldNotInstantiateJobExecutorClass(e);
        }
    }

    protected Class<? extends JobExecutor> loadJobExecutorClass(ClassLoader processApplicationClassloader, String jobExecutorClassname) {
        try {
            return processApplicationClassloader.loadClass(jobExecutorClassname);
        }
        catch (ClassNotFoundException e) {
            throw LOG.couldNotLoadJobExecutorClass(e);
        }
    }
}

