/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.EventType;
import org.cache2k.jcache.provider.event.EntryEvent;
import org.cache2k.jcache.provider.event.EventHandlingImpl;
import org.cache2k.jcache.provider.event.Listener;

public class AsyncDispatcher<K, V> {
    private static final int KEY_LOCKS_MASK = 2 << 31 - Integer.numberOfLeadingZeros(Runtime.getRuntime().availableProcessors()) - 1;
    private static final Object[] KEY_LOCKS = new Object[KEY_LOCKS_MASK + 1];
    private final Executor executor;
    private final Map<K, Queue<EntryEvent<K, V>>> keyQueue = new ConcurrentHashMap<K, Queue<EntryEvent<K, V>>>();
    private final Map<EventType, List<Listener<K, V>>> asyncListenerByType = new HashMap<EventType, List<Listener<K, V>>>();

    static Object getLockObject(Object key) {
        return KEY_LOCKS[key.hashCode() & KEY_LOCKS_MASK];
    }

    public AsyncDispatcher(Executor executor) {
        for (EventType t : EventType.values()) {
            this.asyncListenerByType.put(t, new CopyOnWriteArrayList());
        }
        this.executor = executor;
    }

    void addAsyncListener(Listener<K, V> l) {
        this.asyncListenerByType.get(l.getEventType()).add(l);
    }

    boolean removeAsyncListener(CacheEntryListenerConfiguration<K, V> cfg) {
        boolean found = false;
        for (EventType t : EventType.values()) {
            found |= EventHandlingImpl.removeCfgMatch(cfg, this.asyncListenerByType.get(t));
        }
        return found;
    }

    void collectListeners(Collection<Listener<K, V>> l) {
        for (EventType t : EventType.values()) {
            l.addAll((Collection)this.asyncListenerByType.get(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverAsyncEvent(EntryEvent<K, V> event) {
        if (this.asyncListenerByType.get(event.getEventType()).isEmpty()) {
            return;
        }
        ArrayList<Listener<K, V>> listeners = new ArrayList<Listener<K, V>>((Collection)this.asyncListenerByType.get(event.getEventType()));
        if (listeners.isEmpty()) {
            return;
        }
        K key = event.getKey();
        Object object = AsyncDispatcher.getLockObject(key);
        synchronized (object) {
            Queue<EntryEvent<K, V>> q = this.keyQueue.get(key);
            if (q != null) {
                q.add(event);
                return;
            }
            q = new LinkedList<EntryEvent<K, V>>();
            this.keyQueue.put(key, q);
        }
        this.runAllListenersInParallel(event, listeners);
    }

    void runAllListenersInParallel(final EntryEvent<K, V> event, List<Listener<K, V>> listeners) {
        final AtomicInteger countDown = new AtomicInteger(listeners.size());
        for (final Listener<K, V> l : listeners) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        l.fire(event);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    int done = countDown.decrementAndGet();
                    if (done == 0) {
                        AsyncDispatcher.this.runMoreOnKeyQueueOrStop(event.getKey());
                    }
                }
            };
            this.executor.execute(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runMoreOnKeyQueueOrStop(K key) {
        EntryEvent<K, V> event;
        Object object = AsyncDispatcher.getLockObject(key);
        synchronized (object) {
            Queue<EntryEvent<K, V>> q = this.keyQueue.get(key);
            if (q.isEmpty()) {
                this.keyQueue.remove(key);
                return;
            }
            event = q.remove();
        }
        ArrayList<Listener<K, V>> listeners = new ArrayList<Listener<K, V>>((Collection)this.asyncListenerByType.get(event.getEventType()));
        if (listeners.isEmpty()) {
            this.runMoreOnKeyQueueOrStop(key);
            return;
        }
        this.runAllListenersInParallel(event, listeners);
    }

    static {
        for (int i = 0; i < KEY_LOCKS.length; ++i) {
            AsyncDispatcher.KEY_LOCKS[i] = new Object();
        }
    }
}

