/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.jcache.provider.JCacheAdapter;
import org.cache2k.operation.CacheControl;
import org.cache2k.operation.TimeReference;
import org.cache2k.processor.MutableCacheEntry;

public class TouchyJCacheAdapter<K, V>
implements javax.cache.Cache<K, V> {
    Cache<K, V> c2kCache;
    JCacheAdapter<K, V> cache;
    ExpiryPolicy expiryPolicy;
    TimeReference clock;

    public TouchyJCacheAdapter(JCacheAdapter<K, V> cache, ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
        this.cache = cache;
        this.c2kCache = cache.cache;
        this.clock = CacheControl.of(this.c2kCache).getTimeReference();
    }

    public V get(K key) {
        return this.returnValue(key, this.cache.get(key));
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        Map<K, V> map = this.cache.getAll(keys);
        if (map.isEmpty()) {
            return map;
        }
        javax.cache.expiry.Duration d = this.expiryPolicy.getExpiryForAccess();
        if (d != null) {
            long ticks = TouchyJCacheAdapter.durationToTicks(this.clock, 0L, d);
            this.c2kCache.invokeAll(map.keySet(), entry -> entry.setExpiryTime(ticks));
        }
        return map;
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.cache.loadAll(keys, replaceExistingValues, completionListener);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public V getAndPut(K key, V value) {
        this.checkClosed();
        return this.cache.getAndPut(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.cache.putAll(map);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.cache.putIfAbsent(key, value);
    }

    public boolean remove(K key) {
        return this.cache.remove(key);
    }

    public boolean remove(K key, final V oldValue) {
        this.checkClosed();
        this.checkNullValue(oldValue);
        if (key == null) {
            throw new NullPointerException();
        }
        org.cache2k.processor.EntryProcessor ep = new org.cache2k.processor.EntryProcessor<K, V, Boolean>(){

            public Boolean process(MutableCacheEntry<K, V> e) {
                if (!e.exists()) {
                    return false;
                }
                Object existingValue = e.getValue();
                if (existingValue.equals(oldValue)) {
                    e.remove();
                    return true;
                }
                javax.cache.expiry.Duration d = TouchyJCacheAdapter.this.expiryPolicy.getExpiryForAccess();
                if (d != null) {
                    e.setExpiryTime(TouchyJCacheAdapter.durationToTicks(TouchyJCacheAdapter.this.clock, 0L, d));
                }
                return false;
            }
        };
        return (Boolean)this.c2kCache.invoke(key, ep);
    }

    public V getAndRemove(K key) {
        return this.cache.getAndRemove(key);
    }

    public boolean replace(K key, final V oldValue, final V newValue) {
        this.checkClosed();
        this.checkNullValue(newValue);
        this.checkNullValue(oldValue);
        return (Boolean)this.c2kCache.invoke(key, new org.cache2k.processor.EntryProcessor<K, V, Boolean>(){

            public Boolean process(MutableCacheEntry<K, V> e) {
                if (e.exists()) {
                    if (oldValue.equals(e.getValue())) {
                        e.setValue(newValue);
                        return true;
                    }
                    javax.cache.expiry.Duration d = TouchyJCacheAdapter.this.expiryPolicy.getExpiryForAccess();
                    if (d != null) {
                        e.setExpiryTime(TouchyJCacheAdapter.durationToTicks(TouchyJCacheAdapter.this.clock, 0L, d));
                    }
                }
                return false;
            }
        });
    }

    public boolean replace(K key, V value) {
        this.checkClosed();
        this.checkNullValue(value);
        return this.c2kCache.replace(key, value);
    }

    public V getAndReplace(K key, V value) {
        return this.cache.getAndReplace(key, value);
    }

    public void removeAll(Set<? extends K> keys) {
        this.cache.removeAll(keys);
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    public void clear() {
        this.cache.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return this.cache.getConfiguration(clazz);
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        return this.cache.invoke(key, this.wrapEntryProcessor(entryProcessor), arguments);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        return this.cache.invokeAll(keys, this.wrapEntryProcessor(entryProcessor), arguments);
    }

    public String getName() {
        return this.cache.getName();
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public void close() {
        this.cache.close();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.c2kCache.requestInterface(clazz);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        this.cache.registerCacheEntryListener(cfg);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cfg) {
        this.cache.deregisterCacheEntryListener(cfg);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        final Iterator<Cache.Entry<K, V>> it = this.cache.iterator();
        return new Iterator<Cache.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                Cache.Entry e = (Cache.Entry)it.next();
                return TouchyJCacheAdapter.this.returnEntry(e);
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    private <T> EntryProcessor<K, V, T> wrapEntryProcessor(final EntryProcessor<K, V, T> ep) {
        if (ep == null) {
            throw new NullPointerException("processor is null");
        }
        return new EntryProcessor<K, V, T>(){

            public T process(MutableEntry<K, V> e0, Object ... args) throws EntryProcessorException {
                javax.cache.expiry.Duration d;
                WrappedMutableEntry wrappedEntry = new WrappedMutableEntry(e0);
                Object result = ep.process(wrappedEntry, args);
                if (wrappedEntry.isAccessed() && (d = TouchyJCacheAdapter.this.expiryPolicy.getExpiryForAccess()) != null) {
                    long ticks = TouchyJCacheAdapter.durationToTicks(TouchyJCacheAdapter.this.clock, 0L, d);
                    ((JCacheAdapter.MutableEntryAdapter)e0).setExpiryTime(ticks);
                }
                return result;
            }
        };
    }

    private Cache.Entry<K, V> returnEntry(Cache.Entry<K, V> e) {
        this.touchEntry(e.getKey());
        return e;
    }

    private V returnValue(K key, V value) {
        if (value == null) {
            return null;
        }
        this.touchEntry(key);
        return value;
    }

    private void touchEntry(K key) {
        javax.cache.expiry.Duration d = this.expiryPolicy.getExpiryForAccess();
        if (d != null) {
            this.c2kCache.expireAt(key, TouchyJCacheAdapter.durationToTicks(this.clock, 0L, d));
        }
    }

    private void checkClosed() {
        this.cache.checkClosed();
    }

    private void checkNullValue(V value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "!" + this.cache.toString();
    }

    private static long durationToTicks(TimeReference clock, long nowTicks, javax.cache.expiry.Duration d) {
        if (d.equals((Object)javax.cache.expiry.Duration.ETERNAL)) {
            return Long.MAX_VALUE;
        }
        if (d.equals((Object)javax.cache.expiry.Duration.ZERO)) {
            return 0L;
        }
        if (nowTicks == 0L) {
            nowTicks = clock.ticks();
        }
        return nowTicks + clock.toTicks(Duration.ofMillis(d.getTimeUnit().toMillis(d.getDurationAmount())));
    }

    public static class ExpiryPolicyAdapter<K, V>
    implements org.cache2k.expiry.ExpiryPolicy<K, V>,
    Closeable {
        private final ExpiryPolicy policy;

        public ExpiryPolicyAdapter(ExpiryPolicy policy) {
            this.policy = policy;
        }

        public long calculateExpiryTime(K key, V value, long startTime, CacheEntry<K, V> currentEntry) {
            if (value == null) {
                return 0L;
            }
            javax.cache.expiry.Duration d = currentEntry == null || currentEntry.getException() != null ? this.policy.getExpiryForCreation() : this.policy.getExpiryForUpdate();
            if (d == null) {
                return -1L;
            }
            return TouchyJCacheAdapter.durationToTicks(TimeReference.DEFAULT, startTime, d);
        }

        @Override
        public void close() throws IOException {
            if (this.policy instanceof Closeable) {
                ((Closeable)this.policy).close();
            }
        }
    }

    static class WrappedMutableEntry<K, V>
    implements MutableEntry<K, V> {
        private MutableEntry<K, V> entry;
        private boolean accessed = false;
        private boolean written = false;

        public WrappedMutableEntry(MutableEntry<K, V> entry) {
            this.entry = entry;
        }

        public boolean isAccessed() {
            return this.accessed & !this.written;
        }

        public boolean exists() {
            return this.entry.exists();
        }

        public void remove() {
            this.written = true;
            this.entry.remove();
        }

        public V getValue() {
            if (this.exists()) {
                this.accessed = !this.written;
            }
            return (V)this.entry.getValue();
        }

        public void setValue(V value) {
            this.written = true;
            this.entry.setValue(value);
        }

        public K getKey() {
            return (K)this.entry.getKey();
        }

        public <T> T unwrap(Class<T> clazz) {
            return (T)this.entry.unwrap(clazz);
        }
    }
}

