/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.lang.management.ManagementFactory;
import java.util.concurrent.CompletableFuture;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.cache2k.Cache;
import org.cache2k.annotation.Nullable;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.jcache.provider.JCacheAdapter;
import org.cache2k.jcache.provider.JCacheJmxCacheMXBean;
import org.cache2k.jcache.provider.JCacheJmxStatisticsMXBean;

public class JCacheJmxSupport
implements CacheClosedListener {
    private static final MBeanServer PLATFORM_SERVER = ManagementFactory.getPlatformMBeanServer();
    public static final JCacheJmxSupport SINGLETON = new JCacheJmxSupport();

    private JCacheJmxSupport() {
    }

    @Nullable
    public CompletableFuture<Void> onCacheClosed(Cache cache) {
        this.disableStatistics(cache);
        this.disableJmx(cache);
        return null;
    }

    public void enableStatistics(JCacheAdapter c) {
        MBeanServer mbs = PLATFORM_SERVER;
        String name = this.createStatisticsObjectName((Cache)c.cache);
        try {
            mbs.registerMBean(new JCacheJmxStatisticsMXBean(c), new ObjectName(name));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error registering JMX bean, name='" + name + "'", e);
        }
    }

    public void disableStatistics(Cache c) {
        MBeanServer mbs = PLATFORM_SERVER;
        String name = this.createStatisticsObjectName(c);
        try {
            mbs.unregisterMBean(new ObjectName(name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Error unregister JMX bean, name='" + name + "'", e);
        }
    }

    public void enableJmx(Cache c, javax.cache.Cache ca) {
        MBeanServer mbs = PLATFORM_SERVER;
        String name = this.createJmxObjectName(c);
        try {
            mbs.registerMBean(new JCacheJmxCacheMXBean(ca), new ObjectName(name));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error register JMX bean, name='" + name + "'", e);
        }
    }

    public void disableJmx(Cache c) {
        MBeanServer mbs = PLATFORM_SERVER;
        String name = this.createJmxObjectName(c);
        try {
            mbs.unregisterMBean(new ObjectName(name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Error unregister JMX bean, name='" + name + "'", e);
        }
    }

    public String createStatisticsObjectName(Cache cache) {
        return "javax.cache:type=CacheStatistics,CacheManager=" + JCacheJmxSupport.sanitizeName(cache.getCacheManager().getName()) + ",Cache=" + JCacheJmxSupport.sanitizeName(cache.getName());
    }

    public String createJmxObjectName(Cache cache) {
        return "javax.cache:type=CacheConfiguration,CacheManager=" + JCacheJmxSupport.sanitizeName(cache.getCacheManager().getName()) + ",Cache=" + JCacheJmxSupport.sanitizeName(cache.getName());
    }

    public static String sanitizeName(String string) {
        return string == null ? "" : string.replaceAll(":|=|\n|,", ".");
    }
}

