/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.cache2k.CacheEntry;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.config.CacheType;
import org.cache2k.config.CustomizationReferenceSupplier;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.InternalCache2kBuilder;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.jcache.ExtendedConfiguration;
import org.cache2k.jcache.ExtendedMutableConfiguration;
import org.cache2k.jcache.JCacheConfig;
import org.cache2k.jcache.provider.JCacheAdapter;
import org.cache2k.jcache.provider.JCacheJmxSupport;
import org.cache2k.jcache.provider.JCacheManagerAdapter;
import org.cache2k.jcache.provider.TouchyJCacheAdapter;
import org.cache2k.jcache.provider.event.EventHandling;
import org.cache2k.jcache.provider.event.EventHandlingImpl;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.CopyCacheProxy;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.ObjectTransformer;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.RuntimeCopyTransformer;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.SimpleObjectCopyFactory;

public class JCacheBuilder<K, V> {
    private final String name;
    private final JCacheManagerAdapter manager;
    private boolean cache2kConfigurationWasProvided = false;
    private CompleteConfiguration<K, V> config;
    private Cache2kConfig<K, V> cache2kConfig;
    private JCacheConfig extraConfiguration = JCACHE_DEFAULTS;
    private CacheType<K> keyType;
    private CacheType<V> valueType;
    private ExpiryPolicy expiryPolicy;
    private Cache<K, V> createdCache;
    private EventHandling<K, V> eventHandling;
    private boolean needsTouchyWrapper;
    private static final JCacheConfig JCACHE_DEFAULTS = new JCacheConfig().builder().copyAlwaysIfRequested(true).supportOnlineListenerAttachment(true).config();
    private static final JCacheConfig CACHE2K_DEFAULTS = new JCacheConfig().builder().copyAlwaysIfRequested(false).supportOnlineListenerAttachment(false).config();

    public JCacheBuilder(String name, JCacheManagerAdapter manager) {
        this.name = name;
        this.manager = manager;
    }

    public void setConfiguration(Configuration<K, V> cfg) {
        if (cfg instanceof CompleteConfiguration) {
            this.config = (CompleteConfiguration)cfg;
            if (cfg instanceof ExtendedConfiguration) {
                this.cache2kConfig = ((ExtendedConfiguration)cfg).getCache2kConfiguration();
                if (this.cache2kConfig != null) {
                    if (this.cache2kConfig.getName() != null && !this.cache2kConfig.getName().equals(this.name)) {
                        throw new IllegalArgumentException("cache name mismatch.");
                    }
                    this.cache2kConfigurationWasProvided = true;
                }
            }
        } else {
            MutableConfiguration cfgCopy = new MutableConfiguration();
            cfgCopy.setTypes(cfg.getKeyType(), cfg.getValueType());
            cfgCopy.setStoreByValue(cfg.isStoreByValue());
            this.config = cfgCopy;
        }
        if (this.cache2kConfig == null) {
            this.cache2kConfig = CacheManagerImpl.PROVIDER.getDefaultConfig(this.manager.getCache2kManager());
            if (cfg instanceof ExtendedMutableConfiguration) {
                ((ExtendedMutableConfiguration)cfg).setCache2kConfiguration(this.cache2kConfig);
            }
        }
        this.cache2kConfig.setName(this.name);
        Cache2kCoreProviderImpl.CACHE_CONFIGURATION_PROVIDER.augmentConfig(this.manager.getCache2kManager(), this.cache2kConfig);
        this.cache2kConfigurationWasProvided |= this.cache2kConfig.isExternalConfigurationPresent();
        if (this.cache2kConfigurationWasProvided) {
            this.extraConfiguration = CACHE2K_DEFAULTS;
            JCacheConfig extraConfigurationSpecified = (JCacheConfig)this.cache2kConfig.getSections().getSection(JCacheConfig.class);
            if (extraConfigurationSpecified != null) {
                this.extraConfiguration = extraConfigurationSpecified;
            }
        }
    }

    public Cache<K, V> build() {
        this.setupTypes();
        this.setupDefaults();
        this.setupExceptionPropagator();
        this.setupCacheThrough();
        this.setupExpiryPolicy();
        this.setupEventHandling();
        this.cache2kConfig.getLifecycleListeners().add(new CustomizationReferenceSupplier((Object)JCacheJmxSupport.SINGLETON));
        this.buildAdapterCache();
        this.wrapForExpiryPolicy();
        this.wrapIfCopyIsNeeded();
        return this.createdCache;
    }

    public boolean isStatisticsEnabled() {
        return this.config.isStatisticsEnabled() || this.extraConfiguration.isEnableStatistics();
    }

    public boolean isManagementEnabled() {
        return this.config.isManagementEnabled() || this.extraConfiguration.isEnableManagement();
    }

    JCacheConfig getExtraConfiguration() {
        return this.extraConfiguration;
    }

    private void setupTypes() {
        if (!this.cache2kConfigurationWasProvided || this.cache2kConfig.getKeyType() == null) {
            this.cache2kConfig.setKeyType(CacheType.of((Class)this.config.getKeyType()));
        }
        if (!this.cache2kConfigurationWasProvided || this.cache2kConfig.getValueType() == null) {
            this.cache2kConfig.setValueType(CacheType.of((Class)this.config.getValueType()));
        }
        this.keyType = this.cache2kConfig.getKeyType();
        this.valueType = this.cache2kConfig.getValueType();
        if (!this.config.getKeyType().equals(Object.class) && !this.config.getKeyType().equals(this.keyType.getType())) {
            throw new IllegalArgumentException("Key type mismatch between JCache and cache2k configuration");
        }
        if (!this.config.getValueType().equals(Object.class) && !this.config.getValueType().equals(this.valueType.getType())) {
            throw new IllegalArgumentException("Value type mismatch between JCache and cache2k configuration");
        }
    }

    private void setupDefaults() {
        if (!this.cache2kConfigurationWasProvided) {
            this.cache2kConfig.setSharpExpiry(true);
        }
    }

    private void setupExceptionPropagator() {
        if (this.cache2kConfig.getExceptionPropagator() != null) {
            return;
        }
        this.cache2kConfig.setExceptionPropagator((CustomizationSupplier)new CustomizationReferenceSupplier(loadExceptionInfo -> new CacheLoaderException("propagate previous loader exception", loadExceptionInfo.getException())));
    }

    private void setupCacheThrough() {
        if (this.config.getCacheLoaderFactory() != null) {
            final CacheLoader clf = (CacheLoader)this.config.getCacheLoaderFactory().create();
            this.cache2kConfig.setAdvancedLoader((CustomizationSupplier)new CustomizationReferenceSupplier((Object)new CloseableLoader(){

                @Override
                public void close() throws Exception {
                    if (clf instanceof Closeable) {
                        ((Closeable)clf).close();
                    }
                }

                public V load(K key, long startTime, CacheEntry<K, V> currentEntry) {
                    return clf.load(key);
                }
            }));
        }
        if (this.config.getCacheWriterFactory() != null) {
            final javax.cache.integration.CacheWriter cw = (javax.cache.integration.CacheWriter)this.config.getCacheWriterFactory().create();
            this.cache2kConfig.setWriter((CustomizationSupplier)new CustomizationReferenceSupplier((Object)new CloseableWriter(){

                public void write(final K key, final V value) {
                    Cache.Entry ce = new Cache.Entry<K, V>(){

                        public K getKey() {
                            return key;
                        }

                        public V getValue() {
                            return value;
                        }

                        public <T> T unwrap(Class<T> clazz) {
                            throw new UnsupportedOperationException("unwrap entry not supported");
                        }
                    };
                    cw.write(ce);
                }

                public void delete(Object key) {
                    cw.delete(key);
                }

                @Override
                public void close() throws IOException {
                    if (cw instanceof Closeable) {
                        ((Closeable)cw).close();
                    }
                }
            }));
        }
    }

    private void setupExpiryPolicy() {
        if (this.cache2kConfig.getExpiryPolicy() != null) {
            return;
        }
        if (this.config.getExpiryPolicyFactory() != null) {
            this.expiryPolicy = (ExpiryPolicy)this.config.getExpiryPolicyFactory().create();
        }
        if (this.expiryPolicy == null || this.expiryPolicy instanceof EternalExpiryPolicy) {
            this.cache2kConfig.setExpiryPolicy((CustomizationSupplier)new CustomizationReferenceSupplier((Object)new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                public long calculateExpiryTime(K key, V value, long startTime, CacheEntry<K, V> currentEntry) {
                    if (value == null) {
                        return 0L;
                    }
                    return Long.MAX_VALUE;
                }
            }));
            return;
        }
        if (this.expiryPolicy instanceof ModifiedExpiryPolicy) {
            Duration d = this.expiryPolicy.getExpiryForCreation();
            final long millisDuration = d.getTimeUnit().toMillis(d.getDurationAmount());
            if (millisDuration == 0L) {
                this.cache2kConfig.setExpiryPolicy((CustomizationSupplier)new CustomizationReferenceSupplier((Object)new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                    public long calculateExpiryTime(K key, V value, long startTime, CacheEntry<K, V> currentEntry) {
                        return 0L;
                    }
                }));
                return;
            }
            this.cache2kConfig.setExpiryPolicy((CustomizationSupplier)new CustomizationReferenceSupplier((Object)new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                public long calculateExpiryTime(K key, V value, long startTime, CacheEntry<K, V> currentEntry) {
                    if (value == null) {
                        return 0L;
                    }
                    return startTime + millisDuration;
                }
            }));
            return;
        }
        if (this.expiryPolicy instanceof CreatedExpiryPolicy) {
            this.cache2kConfig.setExpireAfterWrite(Cache2kConfig.EXPIRY_ETERNAL);
            Duration d = this.expiryPolicy.getExpiryForCreation();
            final long millisDuration = d.getTimeUnit().toMillis(d.getDurationAmount());
            if (millisDuration == 0L) {
                this.cache2kConfig.setExpiryPolicy((CustomizationSupplier)new CustomizationReferenceSupplier((Object)new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                    public long calculateExpiryTime(K key, V value, long startTime, CacheEntry<K, V> currentEntry) {
                        return 0L;
                    }
                }));
                return;
            }
            this.cache2kConfig.setExpiryPolicy((CustomizationSupplier)new CustomizationReferenceSupplier((Object)new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                public long calculateExpiryTime(K key, V value, long startTime, CacheEntry<K, V> currentEntry) {
                    if (value == null) {
                        return 0L;
                    }
                    if (currentEntry == null) {
                        return startTime + millisDuration;
                    }
                    return -1L;
                }
            }));
            return;
        }
        this.needsTouchyWrapper = true;
        this.cache2kConfig.setExpiryPolicy((CustomizationSupplier)new CustomizationReferenceSupplier(new TouchyJCacheAdapter.ExpiryPolicyAdapter(this.expiryPolicy)));
    }

    private void setupEventHandling() {
        if (!(this.config.getCacheEntryListenerConfigurations() != null && this.config.getCacheEntryListenerConfigurations().iterator().hasNext() || this.extraConfiguration.isSupportOnlineListenerAttachment())) {
            this.eventHandling = EventHandling.DISABLED;
            return;
        }
        EventHandlingImpl<K, V> eventHandling = new EventHandlingImpl<K, V>(this.manager, Executors.newCachedThreadPool());
        eventHandling.addInternalListenersToCache2kConfiguration(this.cache2kConfig);
        for (CacheEntryListenerConfiguration cfg : this.config.getCacheEntryListenerConfigurations()) {
            eventHandling.registerListener(cfg);
        }
        this.eventHandling = eventHandling;
        this.cache2kConfig.getLifecycleListeners().add(new CustomizationReferenceSupplier(eventHandling));
    }

    private void buildAdapterCache() {
        this.createdCache = new JCacheAdapter<K, V>(this.manager, new InternalCache2kBuilder(this.cache2kConfig, this.manager.getCache2kManager()).buildWithoutExternalConfig(), this.keyType.getType(), this.valueType.getType(), this.config.isStoreByValue(), this.config.isReadThrough() || this.extraConfiguration.isEnableReadThrough(), this.config.getCacheLoaderFactory() != null || this.cache2kConfig.getLoader() != null || this.cache2kConfig.getAdvancedLoader() != null || this.cache2kConfig.getAsyncLoader() != null, this.eventHandling);
    }

    private void wrapForExpiryPolicy() {
        if (this.needsTouchyWrapper) {
            this.createdCache = new TouchyJCacheAdapter((JCacheAdapter)this.createdCache, this.expiryPolicy);
        }
    }

    private void wrapIfCopyIsNeeded() {
        if (this.extraConfiguration.isCopyAlwaysIfRequested() && this.config.isStoreByValue()) {
            ObjectTransformer<K, K> keyTransformer = this.createCopyTransformer(this.keyType);
            ObjectTransformer<V, V> valueTransformer = this.createCopyTransformer(this.valueType);
            this.createdCache = new CopyCacheProxy<K, V>(this.createdCache, keyTransformer, valueTransformer);
        }
    }

    private <T> ObjectTransformer<T, T> createCopyTransformer(CacheType<T> type) {
        SimpleObjectCopyFactory f = new SimpleObjectCopyFactory();
        RuntimeCopyTransformer keyTransformer = f.createCopyTransformer(type.getType(), this.manager.getClassLoader());
        if (keyTransformer == null) {
            keyTransformer = new RuntimeCopyTransformer(this.manager.getClassLoader());
        }
        return keyTransformer;
    }

    abstract class CloseableWriter
    implements CacheWriter<K, V>,
    AutoCloseable {
        CloseableWriter() {
        }
    }

    abstract class CloseableLoader
    implements AdvancedCacheLoader<K, V>,
    AutoCloseable {
        CloseableLoader() {
        }
    }
}

