/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import org.bytedeco.javacpp.cvkernels;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_calib3d;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.ImageTransformer;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.ProjectiveDevice;
import org.bytedeco.javacv.cvkernels;

public class ProjectiveTransformer
implements ImageTransformer {
    protected static ThreadLocal<opencv_core.CvMat> H3x3 = opencv_core.CvMat.createThreadLocal((int)3, (int)3);
    protected static ThreadLocal<opencv_core.CvMat> pts4x1 = opencv_core.CvMat.createThreadLocal((int)4, (int)1, (int)6, (int)2);
    protected opencv_core.CvMat K1 = null;
    protected opencv_core.CvMat K2 = null;
    protected opencv_core.CvMat invK1 = null;
    protected opencv_core.CvMat invK2 = null;
    protected opencv_core.CvMat R = null;
    protected opencv_core.CvMat t = null;
    protected opencv_core.CvMat n = null;
    protected double[] referencePoints1 = null;
    protected double[] referencePoints2 = null;
    protected opencv_core.CvScalar fillColor = opencv_core.cvScalar((double)0.0, (double)0.0, (double)0.0, (double)1.0);
    protected cvkernels.KernelData kernelData = null;
    protected opencv_core.CvMat[] H = null;

    public ProjectiveTransformer() {
        this(null, null, null, null, null, new double[0], null);
    }

    public ProjectiveTransformer(double[] referencePoints) {
        this(null, null, null, null, null, referencePoints, null);
    }

    public ProjectiveTransformer(ProjectiveDevice d1, ProjectiveDevice d2, opencv_core.CvMat n, double[] referencePoints1, double[] referencePoints2) {
        this(d1.cameraMatrix, d2.cameraMatrix, d2.R, d2.T, n, referencePoints1, referencePoints2);
    }

    public ProjectiveTransformer(opencv_core.CvMat K1, opencv_core.CvMat K2, opencv_core.CvMat R, opencv_core.CvMat t, opencv_core.CvMat n, double[] referencePoints1, double[] referencePoints2) {
        this.K1 = K1 == null ? null : K1.clone();
        this.K2 = K2 == null ? null : K2.clone();
        this.invK1 = K1 == null ? null : K1.clone();
        opencv_core.CvMat cvMat = this.invK2 = K2 == null ? null : K2.clone();
        if (K1 != null) {
            opencv_core.cvInvert((opencv_core.CvArr)K1, (opencv_core.CvArr)this.invK1);
        }
        if (K2 != null) {
            opencv_core.cvInvert((opencv_core.CvArr)K2, (opencv_core.CvArr)this.invK2);
        }
        this.R = R == null ? null : R.clone();
        this.t = t == null ? null : t.clone();
        this.n = n == null ? null : n.clone();
        this.referencePoints1 = referencePoints1 == null ? null : (double[])referencePoints1.clone();
        this.referencePoints2 = referencePoints2 == null ? null : (double[])referencePoints2.clone();
    }

    public opencv_core.CvScalar getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(opencv_core.CvScalar fillColor) {
        this.fillColor = fillColor;
    }

    public double[] getReferencePoints1() {
        return this.referencePoints1;
    }

    public double[] getReferencePoints2() {
        return this.referencePoints2;
    }

    public opencv_core.CvMat getK1() {
        return this.K1;
    }

    public opencv_core.CvMat getK2() {
        return this.K2;
    }

    public opencv_core.CvMat getInvK1() {
        return this.invK1;
    }

    public opencv_core.CvMat getInvK2() {
        return this.invK2;
    }

    public opencv_core.CvMat getR() {
        return this.R;
    }

    public opencv_core.CvMat getT() {
        return this.t;
    }

    public opencv_core.CvMat getN() {
        return this.n;
    }

    protected void prepareHomography(opencv_core.CvMat H, int pyramidLevel, Parameters p, boolean inverse) {
        if (this.K2 != null && this.invK1 != null && this.R != null && this.t != null && p.fakeIdentity) {
            opencv_core.cvSetIdentity((opencv_core.CvArr)H);
            return;
        }
        if (inverse) {
            H.put(p.getH());
        } else {
            opencv_core.cvInvert((opencv_core.CvArr)p.getH(), (opencv_core.CvArr)H);
        }
        if (pyramidLevel > 0) {
            int scale = 1 << pyramidLevel;
            H.put(2, H.get(2) / (double)scale);
            H.put(5, H.get(5) / (double)scale);
            H.put(6, H.get(6) * (double)scale);
            H.put(7, H.get(7) * (double)scale);
        }
    }

    public void transform(opencv_core.IplImage srcImage, opencv_core.IplImage dstImage, opencv_core.CvRect roi, int pyramidLevel, ImageTransformer.Parameters parameters, boolean inverse) {
        Parameters p = (Parameters)parameters;
        if (this.K2 != null && this.invK1 != null && this.R != null && this.t != null && p.fakeIdentity) {
            if (srcImage != dstImage) {
                opencv_core.cvCopy((opencv_core.CvArr)srcImage, (opencv_core.CvArr)dstImage);
            }
            return;
        }
        opencv_core.CvMat H = H3x3.get();
        this.prepareHomography(H, pyramidLevel, p, true);
        if (roi != null && (roi.x() != 0 || roi.y() != 0)) {
            int x = roi.x();
            int y = roi.y();
            if (inverse) {
                H.put(2, H.get(0) * (double)x + H.get(1) * (double)y + H.get(2));
                H.put(5, H.get(3) * (double)x + H.get(4) * (double)y + H.get(5));
                H.put(8, H.get(6) * (double)x + H.get(7) * (double)y + H.get(8));
            } else {
                H.put(0, H.get(0) - (double)x * H.get(6));
                H.put(1, H.get(1) - (double)x * H.get(7));
                H.put(2, H.get(2) - (double)x * H.get(8));
                H.put(3, H.get(3) - (double)y * H.get(6));
                H.put(4, H.get(4) - (double)y * H.get(7));
                H.put(5, H.get(5) - (double)y * H.get(8));
            }
        }
        dstImage.origin(srcImage.origin());
        if (roi == null) {
            opencv_core.cvResetImageROI((opencv_core.IplImage)dstImage);
        } else {
            opencv_core.cvSetImageROI((opencv_core.IplImage)dstImage, (opencv_core.CvRect)roi);
        }
        opencv_imgproc.cvWarpPerspective((opencv_core.CvArr)srcImage, (opencv_core.CvArr)dstImage, (opencv_core.CvMat)H, (int)(9 | (inverse ? 16 : 0)), (opencv_core.CvScalar)this.getFillColor());
    }

    @Override
    public void transform(opencv_core.CvMat srcPts, opencv_core.CvMat dstPts, ImageTransformer.Parameters parameters, boolean inverse) {
        opencv_core.CvMat H;
        Parameters p = (Parameters)parameters;
        if (inverse) {
            H = H3x3.get();
            opencv_core.cvInvert((opencv_core.CvArr)p.getH(), (opencv_core.CvArr)H);
        } else {
            H = p.getH();
        }
        opencv_core.cvPerspectiveTransform((opencv_core.CvArr)srcPts, (opencv_core.CvArr)dstPts, (opencv_core.CvMat)H);
    }

    @Override
    public void transform(ImageTransformer.Data[] data, opencv_core.CvRect roi, ImageTransformer.Parameters[] parameters, boolean[] inverses) {
        int i;
        assert (data.length == parameters.length);
        if (this.kernelData == null || this.kernelData.capacity() < data.length) {
            this.kernelData = new cvkernels.KernelData(data.length);
        }
        if (this.H == null || this.H.length < data.length) {
            this.H = new opencv_core.CvMat[data.length];
            for (i = 0; i < this.H.length; ++i) {
                this.H[i] = opencv_core.CvMat.create((int)3, (int)3);
            }
        }
        for (i = 0; i < data.length; ++i) {
            this.kernelData.position(i);
            this.kernelData.srcImg(data[i].srcImg);
            this.kernelData.srcImg2(null);
            this.kernelData.subImg(data[i].subImg);
            this.kernelData.srcDotImg(data[i].srcDotImg);
            this.kernelData.mask(data[i].mask);
            this.kernelData.zeroThreshold(data[i].zeroThreshold);
            this.kernelData.outlierThreshold(data[i].outlierThreshold);
            this.prepareHomography(this.H[i], data[i].pyramidLevel, (Parameters)parameters[i], inverses == null ? false : inverses[i]);
            this.kernelData.H1(this.H[i]);
            this.kernelData.H2(null);
            this.kernelData.X(null);
            this.kernelData.transImg(data[i].transImg);
            this.kernelData.dstImg(data[i].dstImg);
            this.kernelData.dstDstDot(data[i].dstDstDot);
        }
        int fullCapacity = this.kernelData.capacity();
        this.kernelData.capacity(data.length);
        cvkernels.multiWarpColorTransform(this.kernelData, roi, this.getFillColor());
        this.kernelData.capacity(fullCapacity);
        for (int i2 = 0; i2 < data.length; ++i2) {
            this.kernelData.position(i2);
            data[i2].dstCount = this.kernelData.dstCount();
            data[i2].dstCountZero = this.kernelData.dstCountZero();
            data[i2].dstCountOutlier = this.kernelData.dstCountOutlier();
            data[i2].srcDstDot = this.kernelData.srcDstDot();
        }
    }

    @Override
    public Parameters createParameters() {
        return new Parameters();
    }

    public class Parameters
    implements ImageTransformer.Parameters {
        protected double[] projectiveParameters = null;
        private opencv_core.CvMat H = opencv_core.CvMat.create((int)3, (int)3);
        private opencv_core.CvMat n2 = null;
        private opencv_core.CvMat R2 = null;
        private opencv_core.CvMat t2 = null;
        private double constraintError = 0.0;
        private boolean updateNeeded = true;
        protected boolean fakeIdentity = false;

        protected Parameters() {
            this.reset(false);
        }

        public boolean isUpdateNeeded() {
            return this.updateNeeded;
        }

        public void setUpdateNeeded(boolean updateNeeded) {
            this.updateNeeded = updateNeeded;
        }

        @Override
        public int size() {
            return this.projectiveParameters.length;
        }

        @Override
        public double[] get() {
            double[] p = new double[this.size()];
            for (int i = 0; i < p.length; ++i) {
                p[i] = this.get(i);
            }
            return p;
        }

        @Override
        public double get(int i) {
            return this.projectiveParameters[i];
        }

        @Override
        public void set(double ... p) {
            for (int i = 0; i < p.length; ++i) {
                this.set(i, p[i]);
            }
        }

        @Override
        public void set(int i, double p) {
            if (this.projectiveParameters[i] != p) {
                this.projectiveParameters[i] = p;
                this.setUpdateNeeded(true);
            }
        }

        @Override
        public void set(ImageTransformer.Parameters p) {
            this.set(p.get());
            this.fakeIdentity = ((Parameters)p).fakeIdentity;
        }

        @Override
        public void reset(boolean asIdentity) {
            this.setUpdateNeeded(true);
            if (ProjectiveTransformer.this.referencePoints1 != null && (ProjectiveTransformer.this.referencePoints1.length == 0 || ProjectiveTransformer.this.referencePoints1.length == 8)) {
                this.projectiveParameters = ProjectiveTransformer.this.referencePoints1.length == 0 ? new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0} : (double[])ProjectiveTransformer.this.referencePoints1.clone();
            } else if (ProjectiveTransformer.this.K2 != null && ProjectiveTransformer.this.invK1 != null) {
                this.projectiveParameters = ProjectiveTransformer.this.R != null && ProjectiveTransformer.this.t != null ? new double[]{ProjectiveTransformer.this.referencePoints1[0], ProjectiveTransformer.this.referencePoints1[2], ProjectiveTransformer.this.referencePoints1[4]} : (ProjectiveTransformer.this.n != null ? new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0} : new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
            }
        }

        @Override
        public double getConstraintError() {
            this.update();
            return this.constraintError;
        }

        public void set(opencv_core.CvMat setH, boolean inverse) {
            if (this.projectiveParameters.length == 8 && ProjectiveTransformer.this.referencePoints1 != null) {
                if (inverse) {
                    opencv_core.cvInvert((opencv_core.CvArr)setH, (opencv_core.CvArr)this.H);
                } else if (setH != this.H) {
                    opencv_core.cvCopy((opencv_core.CvArr)setH, (opencv_core.CvArr)this.H);
                }
                if (ProjectiveTransformer.this.referencePoints1.length == 0) {
                    for (int i = 0; i < 8; ++i) {
                        this.projectiveParameters[i] = this.H.get(i) / this.H.get(8);
                    }
                } else {
                    opencv_core.CvMat pts = pts4x1.get().put(ProjectiveTransformer.this.referencePoints1);
                    opencv_core.cvPerspectiveTransform((opencv_core.CvArr)pts, (opencv_core.CvArr)pts, (opencv_core.CvMat)this.H);
                    pts.get(this.projectiveParameters);
                }
            } else {
                throw new UnsupportedOperationException("Set homography operation not supported.");
            }
            this.setUpdateNeeded(true);
        }

        @Override
        public void compose(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            Parameters pp1 = (Parameters)p1;
            Parameters pp2 = (Parameters)p2;
            if (ProjectiveTransformer.this.K2 != null && ProjectiveTransformer.this.invK1 != null && ProjectiveTransformer.this.R != null && ProjectiveTransformer.this.t != null && pp1.fakeIdentity) {
                return;
            }
            this.compose(pp1.getH(), inverse1, pp2.getH(), inverse2);
        }

        public void compose(opencv_core.CvMat H1, boolean inverse1, opencv_core.CvMat H2, boolean inverse2) {
            if (inverse1 && inverse2) {
                opencv_core.cvMatMul((opencv_core.CvArr)H2, (opencv_core.CvArr)H1, (opencv_core.CvArr)this.H);
                opencv_core.cvInvert((opencv_core.CvArr)this.H, (opencv_core.CvArr)this.H);
            } else if (inverse1) {
                opencv_core.cvInvert((opencv_core.CvArr)H1, (opencv_core.CvArr)this.H);
                opencv_core.cvMatMul((opencv_core.CvArr)this.H, (opencv_core.CvArr)H2, (opencv_core.CvArr)this.H);
            } else if (inverse2) {
                opencv_core.cvInvert((opencv_core.CvArr)H2, (opencv_core.CvArr)this.H);
                opencv_core.cvMatMul((opencv_core.CvArr)H1, (opencv_core.CvArr)this.H, (opencv_core.CvArr)this.H);
            } else {
                opencv_core.cvMatMul((opencv_core.CvArr)H1, (opencv_core.CvArr)H2, (opencv_core.CvArr)this.H);
            }
            this.set(this.H, false);
        }

        public opencv_core.CvMat getH() {
            this.update();
            return this.H;
        }

        public opencv_core.CvMat getN() {
            this.update();
            return this.n2;
        }

        public opencv_core.CvMat getR() {
            this.update();
            return this.R2;
        }

        public opencv_core.CvMat getT() {
            this.update();
            return this.t2;
        }

        protected void update() {
            if (!this.isUpdateNeeded()) {
                return;
            }
            if (ProjectiveTransformer.this.referencePoints1 != null && (ProjectiveTransformer.this.referencePoints1.length == 0 || ProjectiveTransformer.this.referencePoints1.length == 8)) {
                if (ProjectiveTransformer.this.referencePoints1.length == 0) {
                    this.H.put(0, this.projectiveParameters, 0, 8);
                    this.H.put(8, 1.0);
                } else {
                    JavaCV.getPerspectiveTransform(ProjectiveTransformer.this.referencePoints1, this.projectiveParameters, this.H);
                }
            } else if (ProjectiveTransformer.this.K2 != null && ProjectiveTransformer.this.invK1 != null) {
                if (ProjectiveTransformer.this.R != null && ProjectiveTransformer.this.t != null) {
                    double[] src = ProjectiveTransformer.this.referencePoints2;
                    double[] dst = new double[]{this.projectiveParameters[0], ProjectiveTransformer.this.referencePoints1[1], this.projectiveParameters[1], ProjectiveTransformer.this.referencePoints1[3], this.projectiveParameters[2], ProjectiveTransformer.this.referencePoints1[5]};
                    if (this.R2 == null) {
                        this.R2 = opencv_core.CvMat.create((int)3, (int)3);
                    }
                    if (this.t2 == null) {
                        this.t2 = opencv_core.CvMat.create((int)3, (int)1);
                    }
                    opencv_core.cvTranspose((opencv_core.CvArr)ProjectiveTransformer.this.R, (opencv_core.CvArr)this.R2);
                    opencv_core.cvGEMM((opencv_core.CvArr)this.R2, (opencv_core.CvArr)ProjectiveTransformer.this.t, (double)-1.0, null, (double)0.0, (opencv_core.CvArr)this.t2, (int)0);
                    JavaCV.getPerspectiveTransform(src, dst, ProjectiveTransformer.this.invK2, ProjectiveTransformer.this.K1, this.R2, this.t2, this.H);
                } else {
                    if (ProjectiveTransformer.this.n != null) {
                        this.n2 = ProjectiveTransformer.this.n;
                    } else {
                        if (this.n2 == null) {
                            this.n2 = opencv_core.CvMat.create((int)3, (int)1);
                        }
                        this.n2.put(0, this.projectiveParameters, 8, 3);
                    }
                    if (this.R2 == null) {
                        this.R2 = opencv_core.CvMat.create((int)3, (int)3);
                    }
                    if (this.t2 == null) {
                        this.t2 = opencv_core.CvMat.create((int)3, (int)1);
                    }
                    this.t2.put(0, this.projectiveParameters, 0, 3);
                    opencv_calib3d.cvRodrigues2((opencv_core.CvMat)this.t2, (opencv_core.CvMat)this.R2, null);
                    this.t2.put(0, this.projectiveParameters, 3, 3);
                    opencv_core.cvGEMM((opencv_core.CvArr)this.t2, (opencv_core.CvArr)this.n2, (double)-1.0, (opencv_core.CvArr)this.R2, (double)1.0, (opencv_core.CvArr)this.H, (int)2);
                }
            }
            this.setUpdateNeeded(false);
        }

        @Override
        public boolean preoptimize() {
            return false;
        }

        @Override
        public double[] getSubspace() {
            return null;
        }

        @Override
        public void setSubspace(double ... p) {
        }

        @Override
        public Parameters clone() {
            Parameters p = new Parameters();
            p.set(this);
            return p;
        }

        public String toString() {
            String s = "[";
            double[] p = this.get();
            for (int i = 0; i < p.length; ++i) {
                s = s + (float)p[i];
                if (i >= p.length - 1) continue;
                s = s + ", ";
            }
            s = s + "]";
            return s;
        }
    }
}

