// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.global;

import org.bytedeco.ffmpeg.avutil.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class avutil extends org.bytedeco.ffmpeg.presets.avutil {
    static { Loader.load(); }

// Parsed from <libavutil/avutil.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_AVUTIL_H
// #define AVUTIL_AVUTIL_H

/**
 * \file
 * \ingroup lavu
 * Convenience header that includes \ref lavu "libavutil"'s core.
 */

/**
 * \mainpage
 *
 * \section ffmpeg_intro Introduction
 *
 * This document describes the usage of the different libraries
 * provided by FFmpeg.
 *
 * \li \ref libavc "libavcodec" encoding/decoding library
 * \li \ref lavfi "libavfilter" graph-based frame editing library
 * \li \ref libavf "libavformat" I/O and muxing/demuxing library
 * \li \ref lavd "libavdevice" special devices muxing/demuxing library
 * \li \ref lavu "libavutil" common utility library
 * \li \ref lswr "libswresample" audio resampling, format conversion and mixing
 * \li \ref lpp  "libpostproc" post processing library
 * \li \ref libsws "libswscale" color conversion and scaling library
 *
 * \section ffmpeg_versioning Versioning and compatibility
 *
 * Each of the FFmpeg libraries contains a version.h header, which defines a
 * major, minor and micro version number with the
 * <em>LIBRARYNAME_VERSION_{MAJOR,MINOR,MICRO}</em> macros. The major version
 * number is incremented with backward incompatible changes - e.g. removing
 * parts of the public API, reordering public struct members, etc. The minor
 * version number is incremented for backward compatible API changes or major
 * new features - e.g. adding a new public function or a new decoder. The micro
 * version number is incremented for smaller changes that a calling program
 * might still want to check for - e.g. changing behavior in a previously
 * unspecified situation.
 *
 * FFmpeg guarantees backward API and ABI compatibility for each library as long
 * as its major version number is unchanged. This means that no public symbols
 * will be removed or renamed. Types and names of the public struct members and
 * values of public macros and enums will remain the same (unless they were
 * explicitly declared as not part of the public API). Documented behavior will
 * not change.
 *
 * In other words, any correct program that works with a given FFmpeg snapshot
 * should work just as well without any changes with any later snapshot with the
 * same major versions. This applies to both rebuilding the program against new
 * FFmpeg versions or to replacing the dynamic FFmpeg libraries that a program
 * links against.
 *
 * However, new public symbols may be added and new members may be appended to
 * public structs whose size is not part of public ABI (most public structs in
 * FFmpeg). New macros and enum values may be added. Behavior in undocumented
 * situations may change slightly (and be documented). All those are accompanied
 * by an entry in doc/APIchanges and incrementing either the minor or micro
 * version number.
 */

/**
 * \defgroup lavu libavutil
 * Common code shared across all FFmpeg libraries.
 *
 * \note
 * libavutil is designed to be modular. In most cases, in order to use the
 * functions provided by one component of libavutil you must explicitly include
 * the specific header containing that feature. If you are only using
 * media-related components, you could simply include libavutil/avutil.h, which
 * brings in most of the "core" components.
 *
 * \{
 *
 * \defgroup lavu_crypto Crypto and Hashing
 *
 * \{
 * \}
 *
 * \defgroup lavu_math Mathematics
 * \{
 *
 * \}
 *
 * \defgroup lavu_string String Manipulation
 *
 * \{
 *
 * \}
 *
 * \defgroup lavu_mem Memory Management
 *
 * \{
 *
 * \}
 *
 * \defgroup lavu_data Data Structures
 * \{
 *
 * \}
 *
 * \defgroup lavu_video Video related
 *
 * \{
 *
 * \}
 *
 * \defgroup lavu_audio Audio related
 *
 * \{
 *
 * \}
 *
 * \defgroup lavu_error Error Codes
 *
 * \{
 *
 * \}
 *
 * \defgroup lavu_log Logging Facility
 *
 * \{
 *
 * \}
 *
 * \defgroup lavu_misc Other
 *
 * \{
 *
 * \defgroup preproc_misc Preprocessor String Macros
 *
 * \{
 *
 * \}
 *
 * \defgroup version_utils Library Version Macros
 *
 * \{
 *
 * \}
 */


/**
 * \addtogroup lavu_ver
 * \{
 */

/**
 * Return the LIBAVUTIL_VERSION_INT constant.
 */
@NoException public static native @Cast("unsigned") int avutil_version();

/**
 * Return an informative version string. This usually is the actual release
 * version number or a git commit description. This string has no fixed format
 * and can change any time. It should never be parsed by code.
 */
@NoException public static native @Cast("const char*") BytePointer av_version_info();

/**
 * Return the libavutil build-time configuration.
 */
@NoException public static native @Cast("const char*") BytePointer avutil_configuration();

/**
 * Return the libavutil license.
 */
@NoException public static native @Cast("const char*") BytePointer avutil_license();

/**
 * \}
 */

/**
 * \addtogroup lavu_media Media Type
 * \brief Media Type
 */

/** enum AVMediaType */
public static final int
    /** Usually treated as AVMEDIA_TYPE_DATA */
    AVMEDIA_TYPE_UNKNOWN = -1,
    AVMEDIA_TYPE_VIDEO = 0,
    AVMEDIA_TYPE_AUDIO = 1,
    /** Opaque data information usually continuous */
    AVMEDIA_TYPE_DATA = 2,
    AVMEDIA_TYPE_SUBTITLE = 3,
    /** Opaque data information usually sparse */
    AVMEDIA_TYPE_ATTACHMENT = 4,
    AVMEDIA_TYPE_NB = 5;

/**
 * Return a string describing the media_type enum, NULL if media_type
 * is unknown.
 */
@NoException public static native @Cast("const char*") BytePointer av_get_media_type_string(@Cast("AVMediaType") int media_type);

/**
 * \defgroup lavu_const Constants
 * \{
 *
 * \defgroup lavu_enc Encoding specific
 *
 * \note those definition should move to avcodec
 * \{
 */

public static final int FF_LAMBDA_SHIFT = 7;
public static final int FF_LAMBDA_SCALE = (1<<FF_LAMBDA_SHIFT);
/** factor to convert from H.263 QP to lambda */
public static final int FF_QP2LAMBDA = 118;
public static final int FF_LAMBDA_MAX = (256*128-1);

public static final int FF_QUALITY_SCALE = FF_LAMBDA_SCALE; //FIXME maybe remove

/**
 * \}
 * \defgroup lavu_time Timestamp specific
 *
 * FFmpeg internal timebase and timestamp definitions
 *
 * \{
 */

/**
 * \brief Undefined timestamp value
 *
 * Usually reported by demuxer that work on containers that do not provide
 * either pts or dts.
 */

public static native @MemberGetter @Cast("int64_t") long AV_NOPTS_VALUE();
public static final long AV_NOPTS_VALUE = AV_NOPTS_VALUE();

/**
 * Internal time base represented as integer
 */

public static final int AV_TIME_BASE =            1000000;

/**
 * Internal time base represented as fractional value
 */

// #define AV_TIME_BASE_Q          (AVRational){1, AV_TIME_BASE}

/**
 * \}
 * \}
 * \defgroup lavu_picture Image related
 *
 * AVPicture types, pixel formats and basic image planes manipulation.
 *
 * \{
 */

/** enum AVPictureType */
public static final int
    /** Undefined */
    AV_PICTURE_TYPE_NONE = 0,
    /** Intra */
    AV_PICTURE_TYPE_I = 1,
    /** Predicted */
    AV_PICTURE_TYPE_P = 2,
    /** Bi-dir predicted */
    AV_PICTURE_TYPE_B = 3,
    /** S(GMC)-VOP MPEG-4 */
    AV_PICTURE_TYPE_S = 4,
    /** Switching Intra */
    AV_PICTURE_TYPE_SI = 5,
    /** Switching Predicted */
    AV_PICTURE_TYPE_SP = 6,
    /** BI type */
    AV_PICTURE_TYPE_BI = 7;

/**
 * Return a single letter to describe the given picture type
 * pict_type.
 *
 * @param pict_type [in] the picture type @return a single character
 * representing the picture type, '?' if pict_type is unknown
 */
@NoException public static native @Cast("char") byte av_get_picture_type_char(@Cast("AVPictureType") int pict_type);

/**
 * \}
 */

// #include "common.h"
// #include "error.h"
// #include "rational.h"
// #include "version.h"
// #include "macros.h"
// #include "mathematics.h"
// #include "log.h"
// #include "pixfmt.h"

/**
 * Return x default pointer in case p is NULL.
 */
@NoException public static native Pointer av_x_if_null(@Const Pointer p, @Const Pointer x);

/**
 * Compute the length of an integer list.
 *
 * @param elsize  size in bytes of each list element (only 1, 2, 4 or 8)
 * @param term    list terminator (usually 0 or -1)
 * @param list    pointer to the list
 * @return  length of the list, in elements, not counting the terminator
 */
@NoException public static native @Cast("unsigned") int av_int_list_length_for_size(@Cast("unsigned") int elsize,
                                     @Const Pointer list, @Cast("uint64_t") long term);

/**
 * Compute the length of an integer list.
 *
 * @param term  list terminator (usually 0 or -1)
 * @param list  pointer to the list
 * @return  length of the list, in elements, not counting the terminator
 */
// #define av_int_list_length(list, term)
//     av_int_list_length_for_size(sizeof(*(list)), list, term)

/**
 * Open a file using a UTF-8 filename.
 * The API of this function matches POSIX fopen(), errors are returned through
 * errno.
 */
@NoException public static native @Cast("FILE*") Pointer av_fopen_utf8(@Cast("const char*") BytePointer path, @Cast("const char*") BytePointer mode);
@NoException public static native @Cast("FILE*") Pointer av_fopen_utf8(String path, String mode);

/**
 * Return the fractional representation of the internal time base.
 */
@NoException public static native @ByVal AVRational av_get_time_base_q();

public static final int AV_FOURCC_MAX_STRING_SIZE = 32;

// #define av_fourcc2str(fourcc) av_fourcc_make_string((char[AV_FOURCC_MAX_STRING_SIZE]){0}, fourcc)

/**
 * Fill the provided buffer with a string containing a FourCC (four-character
 * code) representation.
 *
 * @param buf    a buffer with size in bytes of at least AV_FOURCC_MAX_STRING_SIZE
 * @param fourcc the fourcc to represent
 * @return the buffer in input
 */
@NoException public static native @Cast("char*") BytePointer av_fourcc_make_string(@Cast("char*") BytePointer buf, @Cast("uint32_t") int fourcc);
@NoException public static native @Cast("char*") ByteBuffer av_fourcc_make_string(@Cast("char*") ByteBuffer buf, @Cast("uint32_t") int fourcc);
@NoException public static native @Cast("char*") byte[] av_fourcc_make_string(@Cast("char*") byte[] buf, @Cast("uint32_t") int fourcc);

/**
 * \}
 * \}
 */

// #endif /* AVUTIL_AVUTIL_H */


// Parsed from <libavutil/error.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * error code definitions
 */

// #ifndef AVUTIL_ERROR_H
// #define AVUTIL_ERROR_H

// #include <errno.h>
// #include <stddef.h>

/**
 * \addtogroup lavu_error
 *
 * \{
 */


/* error handling */
// #if EDOM > 0
/** Returns a negative error code from a POSIX error code, to return from library functions. */
// #define AVERROR(e) (-(e))
/** Returns a POSIX error code from a library function error return value. */
// #define AVUNERROR(e) (-(e))
// #else
/* Some platforms have E* and errno already negated. */
// #define AVERROR(e) (e)
// #define AVUNERROR(e) (e)
// #endif

// #define FFERRTAG(a, b, c, d) (-(int)MKTAG(a, b, c, d))

/** Bitstream filter not found */
public static native @MemberGetter int AVERROR_BSF_NOT_FOUND();
public static final int AVERROR_BSF_NOT_FOUND = AVERROR_BSF_NOT_FOUND();
/** Internal bug, also see AVERROR_BUG2 */
public static native @MemberGetter int AVERROR_BUG();
public static final int AVERROR_BUG = AVERROR_BUG();
/** Buffer too small */
public static native @MemberGetter int AVERROR_BUFFER_TOO_SMALL();
public static final int AVERROR_BUFFER_TOO_SMALL = AVERROR_BUFFER_TOO_SMALL();
/** Decoder not found */
public static native @MemberGetter int AVERROR_DECODER_NOT_FOUND();
public static final int AVERROR_DECODER_NOT_FOUND = AVERROR_DECODER_NOT_FOUND();
/** Demuxer not found */
public static native @MemberGetter int AVERROR_DEMUXER_NOT_FOUND();
public static final int AVERROR_DEMUXER_NOT_FOUND = AVERROR_DEMUXER_NOT_FOUND();
/** Encoder not found */
public static native @MemberGetter int AVERROR_ENCODER_NOT_FOUND();
public static final int AVERROR_ENCODER_NOT_FOUND = AVERROR_ENCODER_NOT_FOUND();
/** End of file */
public static native @MemberGetter int AVERROR_EOF();
public static final int AVERROR_EOF = AVERROR_EOF();
/** Immediate exit was requested; the called function should not be restarted */
public static native @MemberGetter int AVERROR_EXIT();
public static final int AVERROR_EXIT = AVERROR_EXIT();
/** Generic error in an external library */
public static native @MemberGetter int AVERROR_EXTERNAL();
public static final int AVERROR_EXTERNAL = AVERROR_EXTERNAL();
/** Filter not found */
public static native @MemberGetter int AVERROR_FILTER_NOT_FOUND();
public static final int AVERROR_FILTER_NOT_FOUND = AVERROR_FILTER_NOT_FOUND();
/** Invalid data found when processing input */
public static native @MemberGetter int AVERROR_INVALIDDATA();
public static final int AVERROR_INVALIDDATA = AVERROR_INVALIDDATA();
/** Muxer not found */
public static native @MemberGetter int AVERROR_MUXER_NOT_FOUND();
public static final int AVERROR_MUXER_NOT_FOUND = AVERROR_MUXER_NOT_FOUND();
/** Option not found */
public static native @MemberGetter int AVERROR_OPTION_NOT_FOUND();
public static final int AVERROR_OPTION_NOT_FOUND = AVERROR_OPTION_NOT_FOUND();
/** Not yet implemented in FFmpeg, patches welcome */
public static native @MemberGetter int AVERROR_PATCHWELCOME();
public static final int AVERROR_PATCHWELCOME = AVERROR_PATCHWELCOME();
/** Protocol not found */
public static native @MemberGetter int AVERROR_PROTOCOL_NOT_FOUND();
public static final int AVERROR_PROTOCOL_NOT_FOUND = AVERROR_PROTOCOL_NOT_FOUND();

/** Stream not found */
public static native @MemberGetter int AVERROR_STREAM_NOT_FOUND();
public static final int AVERROR_STREAM_NOT_FOUND = AVERROR_STREAM_NOT_FOUND();
/**
 * This is semantically identical to AVERROR_BUG
 * it has been introduced in Libav after our AVERROR_BUG and with a modified value.
 */
public static native @MemberGetter int AVERROR_BUG2();
public static final int AVERROR_BUG2 = AVERROR_BUG2();
/** Unknown error, typically from an external library */
public static native @MemberGetter int AVERROR_UNKNOWN();
public static final int AVERROR_UNKNOWN = AVERROR_UNKNOWN();
/** Requested feature is flagged experimental. Set strict_std_compliance if you really want to use it. */
public static final int AVERROR_EXPERIMENTAL =       (-0x2bb2afa8);
/** Input changed between calls. Reconfiguration is required. (can be OR-ed with AVERROR_OUTPUT_CHANGED) */
public static final int AVERROR_INPUT_CHANGED =      (-0x636e6701);
/** Output changed between calls. Reconfiguration is required. (can be OR-ed with AVERROR_INPUT_CHANGED) */
public static final int AVERROR_OUTPUT_CHANGED =     (-0x636e6702);
/* HTTP & RTSP errors */
public static native @MemberGetter int AVERROR_HTTP_BAD_REQUEST();
public static final int AVERROR_HTTP_BAD_REQUEST = AVERROR_HTTP_BAD_REQUEST();
public static native @MemberGetter int AVERROR_HTTP_UNAUTHORIZED();
public static final int AVERROR_HTTP_UNAUTHORIZED = AVERROR_HTTP_UNAUTHORIZED();
public static native @MemberGetter int AVERROR_HTTP_FORBIDDEN();
public static final int AVERROR_HTTP_FORBIDDEN = AVERROR_HTTP_FORBIDDEN();
public static native @MemberGetter int AVERROR_HTTP_NOT_FOUND();
public static final int AVERROR_HTTP_NOT_FOUND = AVERROR_HTTP_NOT_FOUND();
public static native @MemberGetter int AVERROR_HTTP_OTHER_4XX();
public static final int AVERROR_HTTP_OTHER_4XX = AVERROR_HTTP_OTHER_4XX();
public static native @MemberGetter int AVERROR_HTTP_SERVER_ERROR();
public static final int AVERROR_HTTP_SERVER_ERROR = AVERROR_HTTP_SERVER_ERROR();

public static final int AV_ERROR_MAX_STRING_SIZE = 64;

/**
 * Put a description of the AVERROR code errnum in errbuf.
 * In case of failure the global variable errno is set to indicate the
 * error. Even in case of failure av_strerror() will print a generic
 * error message indicating the errnum provided to errbuf.
 *
 * @param errnum      error code to describe
 * @param errbuf      buffer to which description is written
 * @param errbuf_size the size in bytes of errbuf
 * @return 0 on success, a negative value if a description for errnum
 * cannot be found
 */
@NoException public static native int av_strerror(int errnum, @Cast("char*") BytePointer errbuf, @Cast("size_t") long errbuf_size);
@NoException public static native int av_strerror(int errnum, @Cast("char*") ByteBuffer errbuf, @Cast("size_t") long errbuf_size);
@NoException public static native int av_strerror(int errnum, @Cast("char*") byte[] errbuf, @Cast("size_t") long errbuf_size);

/**
 * Fill the provided buffer with a string containing an error string
 * corresponding to the AVERROR code errnum.
 *
 * @param errbuf         a buffer
 * @param errbuf_size    size in bytes of errbuf
 * @param errnum         error code to describe
 * @return the buffer in input, filled with the error description
 * @see av_strerror()
 */
@NoException public static native @Cast("char*") BytePointer av_make_error_string(@Cast("char*") BytePointer errbuf, @Cast("size_t") long errbuf_size, int errnum);
@NoException public static native @Cast("char*") ByteBuffer av_make_error_string(@Cast("char*") ByteBuffer errbuf, @Cast("size_t") long errbuf_size, int errnum);
@NoException public static native @Cast("char*") byte[] av_make_error_string(@Cast("char*") byte[] errbuf, @Cast("size_t") long errbuf_size, int errnum);

/**
 * Convenience macro, the return value should be used only directly in
 * function arguments but never stand-alone.
 */
// #define av_err2str(errnum)
//     av_make_error_string((char[AV_ERROR_MAX_STRING_SIZE]){0}, AV_ERROR_MAX_STRING_SIZE, errnum)

/**
 * \}
 */

// #endif /* AVUTIL_ERROR_H */


// Parsed from <libavutil/mem.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_mem
 * Memory handling functions
 */

// #ifndef AVUTIL_MEM_H
// #define AVUTIL_MEM_H

// #include <limits.h>
// #include <stdint.h>

// #include "attributes.h"
// #include "error.h"
// #include "avutil.h"

/**
 * \addtogroup lavu_mem
 * Utilities for manipulating memory.
 *
 * FFmpeg has several applications of memory that are not required of a typical
 * program. For example, the computing-heavy components like video decoding and
 * encoding can be sped up significantly through the use of aligned memory.
 *
 * However, for each of FFmpeg's applications of memory, there might not be a
 * recognized or standardized API for that specific use. Memory alignment, for
 * instance, varies wildly depending on operating systems, architectures, and
 * compilers. Hence, this component of \ref libavutil is created to make
 * dealing with memory consistently possible on all platforms.
 *
 * \{
 *
 * \defgroup lavu_mem_macros Alignment Macros
 * Helper macros for declaring aligned variables.
 * \{
 */

/**
 * \def DECLARE_ALIGNED(n,t,v)
 * Declare a variable that is aligned in memory.
 *
 * <pre>{@code {.c}
 * DECLARE_ALIGNED(16, uint16_t, aligned_int) = 42;
 * DECLARE_ALIGNED(32, uint8_t, aligned_array)[128];
 *
 * // The default-alignment equivalent would be
 * uint16_t aligned_int = 42;
 * uint8_t aligned_array[128];
 * }</pre>
 *
 * @param n Minimum alignment in bytes
 * @param t Type of the variable (or array element)
 * @param v Name of the variable
 */

/**
 * \def DECLARE_ASM_ALIGNED(n,t,v)
 * Declare an aligned variable appropriate for use in inline assembly code.
 *
 * <pre>{@code {.c}
 * DECLARE_ASM_ALIGNED(16, uint64_t, pw_08) = UINT64_C(0x0008000800080008);
 * }</pre>
 *
 * @param n Minimum alignment in bytes
 * @param t Type of the variable (or array element)
 * @param v Name of the variable
 */

/**
 * \def DECLARE_ASM_CONST(n,t,v)
 * Declare a static constant aligned variable appropriate for use in inline
 * assembly code.
 *
 * <pre>{@code {.c}
 * DECLARE_ASM_CONST(16, uint64_t, pw_08) = UINT64_C(0x0008000800080008);
 * }</pre>
 *
 * @param n Minimum alignment in bytes
 * @param t Type of the variable (or array element)
 * @param v Name of the variable
 */

// #if defined(__INTEL_COMPILER) && __INTEL_COMPILER < 1110 || defined(__SUNPRO_C)
//     #define DECLARE_ALIGNED(n,t,v)      t __attribute__ ((aligned (n))) v
//     #define DECLARE_ASM_ALIGNED(n,t,v)  t __attribute__ ((aligned (n))) v
//     #define DECLARE_ASM_CONST(n,t,v)    const t __attribute__ ((aligned (n))) v
// #elif defined(__DJGPP__)
//     #define DECLARE_ALIGNED(n,t,v)      t __attribute__ ((aligned (FFMIN(n, 16)))) v
//     #define DECLARE_ASM_ALIGNED(n,t,v)  t av_used __attribute__ ((aligned (FFMIN(n, 16)))) v
//     #define DECLARE_ASM_CONST(n,t,v)    static const t av_used __attribute__ ((aligned (FFMIN(n, 16)))) v
// #elif defined(__GNUC__) || defined(__clang__)
//     #define DECLARE_ALIGNED(n,t,v)      t __attribute__ ((aligned (n))) v
//     #define DECLARE_ASM_ALIGNED(n,t,v)  t av_used __attribute__ ((aligned (n))) v
//     #define DECLARE_ASM_CONST(n,t,v)    static const t av_used __attribute__ ((aligned (n))) v
// #elif defined(_MSC_VER)
//     #define DECLARE_ALIGNED(n,t,v)      __declspec(align(n)) t v
//     #define DECLARE_ASM_ALIGNED(n,t,v)  __declspec(align(n)) t v
//     #define DECLARE_ASM_CONST(n,t,v)    __declspec(align(n)) static const t v
// #else
//     #define DECLARE_ALIGNED(n,t,v)      t v
//     #define DECLARE_ASM_ALIGNED(n,t,v)  t v
//     #define DECLARE_ASM_CONST(n,t,v)    static const t v
// #endif

/**
 * \}
 */

/**
 * \defgroup lavu_mem_attrs Function Attributes
 * Function attributes applicable to memory handling functions.
 *
 * These function attributes can help compilers emit more useful warnings, or
 * generate better code.
 * \{
 */

/**
 * \def av_malloc_attrib
 * Function attribute denoting a malloc-like function.
 *
 * @see <a href="https://gcc.gnu.org/onlinedocs/gcc/Common-Function-Attributes.html#index-g_t_0040code_007bmalloc_007d-function-attribute-3251">Function attribute {@code malloc} in GCC's documentation</a>
 */

// #if AV_GCC_VERSION_AT_LEAST(3,1)
//     #define av_malloc_attrib __attribute__((__malloc__))
// #else
//     #define av_malloc_attrib
// #endif

/**
 * \def av_alloc_size(...)
 * Function attribute used on a function that allocates memory, whose size is
 * given by the specified parameter(s).
 *
 * <pre>{@code {.c}
 * void *av_malloc(size_t size) av_alloc_size(1);
 * void *av_calloc(size_t nmemb, size_t size) av_alloc_size(1, 2);
 * }</pre>
 *
 * @param ... One or two parameter indexes, separated by a comma
 *
 * @see <a href="https://gcc.gnu.org/onlinedocs/gcc/Common-Function-Attributes.html#index-g_t_0040code_007balloc_005fsize_007d-function-attribute-3220">Function attribute {@code alloc_size} in GCC's documentation</a>
 */

// #if AV_GCC_VERSION_AT_LEAST(4,3)
//     #define av_alloc_size(...) __attribute__((alloc_size(__VA_ARGS__)))
// #else
//     #define av_alloc_size(...)
// #endif

/**
 * \}
 */

/**
 * \defgroup lavu_mem_funcs Heap Management
 * Functions responsible for allocating, freeing, and copying memory.
 *
 * All memory allocation functions have a built-in upper limit of {@code INT_MAX}
 * bytes. This may be changed with av_max_alloc(), although exercise extreme
 * caution when doing so.
 *
 * \{
 */

/**
 * Allocate a memory block with alignment suitable for all memory accesses
 * (including vectors if available on the CPU).
 *
 * @param size Size in bytes for the memory block to be allocated
 * @return Pointer to the allocated block, or {@code NULL} if the block cannot
 *         be allocated
 * @see av_mallocz()
 */
@NoException public static native Pointer av_malloc(@Cast("size_t") long size);

/**
 * Allocate a memory block with alignment suitable for all memory accesses
 * (including vectors if available on the CPU) and zero all the bytes of the
 * block.
 *
 * @param size Size in bytes for the memory block to be allocated
 * @return Pointer to the allocated block, or {@code NULL} if it cannot be allocated
 * @see av_malloc()
 */
@NoException public static native Pointer av_mallocz(@Cast("size_t") long size);

/**
 * Allocate a memory block for an array with av_malloc().
 *
 * The allocated memory will have size {@code size * nmemb} bytes.
 *
 * @param nmemb Number of element
 * @param size  Size of a single element
 * @return Pointer to the allocated block, or {@code NULL} if the block cannot
 *         be allocated
 * @see av_malloc()
 */
@NoException public static native Pointer av_malloc_array(@Cast("size_t") long nmemb, @Cast("size_t") long size);

/**
 * Allocate a memory block for an array with av_mallocz().
 *
 * The allocated memory will have size {@code size * nmemb} bytes.
 *
 * @param nmemb Number of elements
 * @param size  Size of the single element
 * @return Pointer to the allocated block, or {@code NULL} if the block cannot
 *         be allocated
 *
 * @see av_mallocz()
 * @see av_malloc_array()
 */
@NoException public static native Pointer av_mallocz_array(@Cast("size_t") long nmemb, @Cast("size_t") long size);

/**
 * Non-inlined equivalent of av_mallocz_array().
 *
 * Created for symmetry with the calloc() C function.
 */
@NoException public static native Pointer av_calloc(@Cast("size_t") long nmemb, @Cast("size_t") long size);

/**
 * Allocate, reallocate, or free a block of memory.
 *
 * If {@code ptr} is {@code NULL} and {@code size} > 0, allocate a new block. If {@code size} is
 * zero, free the memory block pointed to by {@code ptr}. Otherwise, expand or
 * shrink that block of memory according to {@code size}.
 *
 * @param ptr  Pointer to a memory block already allocated with
 *             av_realloc() or {@code NULL}
 * @param size Size in bytes of the memory block to be allocated or
 *             reallocated
 *
 * @return Pointer to a newly-reallocated block or {@code NULL} if the block
 *         cannot be reallocated or the function is used to free the memory block
 *
 * \warning Unlike av_malloc(), the returned pointer is not guaranteed to be
 *          correctly aligned.
 * @see av_fast_realloc()
 * @see av_reallocp()
 */
@NoException public static native Pointer av_realloc(Pointer ptr, @Cast("size_t") long size);

/**
 * Allocate, reallocate, or free a block of memory through a pointer to a
 * pointer.
 *
 * If {@code *ptr} is {@code NULL} and {@code size} > 0, allocate a new block. If {@code size} is
 * zero, free the memory block pointed to by {@code *ptr}. Otherwise, expand or
 * shrink that block of memory according to {@code size}.
 *
 * @param ptr [in,out]  Pointer to a pointer to a memory block already allocated
 *                     with av_realloc(), or a pointer to {@code NULL}. The pointer
 *                     is updated on success, or freed on failure.
 * @param size [in] Size in bytes for the memory block to be allocated or
 *                     reallocated
 *
 * @return Zero on success, an AVERROR error code on failure
 *
 * \warning Unlike av_malloc(), the allocated memory is not guaranteed to be
 *          correctly aligned.
 */
@NoException public static native int av_reallocp(Pointer ptr, @Cast("size_t") long size);

/**
 * Allocate, reallocate, or free a block of memory.
 *
 * This function does the same thing as av_realloc(), except:
 * - It takes two size arguments and allocates {@code nelem * elsize} bytes,
 *   after checking the result of the multiplication for integer overflow.
 * - It frees the input block in case of failure, thus avoiding the memory
 *   leak with the classic
 *   <pre>{@code {.c}
 *   buf = realloc(buf);
 *   if (!buf)
 *       return -1;
 *   }</pre>
 *   pattern.
 */
@NoException public static native Pointer av_realloc_f(Pointer ptr, @Cast("size_t") long nelem, @Cast("size_t") long elsize);

/**
 * Allocate, reallocate, or free an array.
 *
 * If {@code ptr} is {@code NULL} and {@code nmemb} > 0, allocate a new block. If
 * {@code nmemb} is zero, free the memory block pointed to by {@code ptr}.
 *
 * @param ptr   Pointer to a memory block already allocated with
 *              av_realloc() or {@code NULL}
 * @param nmemb Number of elements in the array
 * @param size  Size of the single element of the array
 *
 * @return Pointer to a newly-reallocated block or NULL if the block
 *         cannot be reallocated or the function is used to free the memory block
 *
 * \warning Unlike av_malloc(), the allocated memory is not guaranteed to be
 *          correctly aligned.
 * @see av_reallocp_array()
 */
@NoException public static native Pointer av_realloc_array(Pointer ptr, @Cast("size_t") long nmemb, @Cast("size_t") long size);

/**
 * Allocate, reallocate, or free an array through a pointer to a pointer.
 *
 * If {@code *ptr} is {@code NULL} and {@code nmemb} > 0, allocate a new block. If {@code nmemb} is
 * zero, free the memory block pointed to by {@code *ptr}.
 *
 * @param ptr [in,out]   Pointer to a pointer to a memory block already
 *                      allocated with av_realloc(), or a pointer to {@code NULL}.
 *                      The pointer is updated on success, or freed on failure.
 * @param nmemb [in] Number of elements
 * @param size [in]  Size of the single element
 *
 * @return Zero on success, an AVERROR error code on failure
 *
 * \warning Unlike av_malloc(), the allocated memory is not guaranteed to be
 *          correctly aligned.
 */
@NoException public static native int av_reallocp_array(Pointer ptr, @Cast("size_t") long nmemb, @Cast("size_t") long size);

/**
 * Reallocate the given buffer if it is not large enough, otherwise do nothing.
 *
 * If the given buffer is {@code NULL}, then a new uninitialized buffer is allocated.
 *
 * If the given buffer is not large enough, and reallocation fails, {@code NULL} is
 * returned and {@code *size} is set to 0, but the original buffer is not changed or
 * freed.
 *
 * A typical use pattern follows:
 *
 * <pre>{@code {.c}
 * uint8_t *buf = ...;
 * uint8_t *new_buf = av_fast_realloc(buf, &current_size, size_needed);
 * if (!new_buf) {
 *     // Allocation failed; clean up original buffer
 *     av_freep(&buf);
 *     return AVERROR(ENOMEM);
 * }
 * }</pre>
 *
 * @param ptr [in,out]      Already allocated buffer, or {@code NULL}
 * @param size [in,out]     Pointer to the size of buffer {@code ptr}. {@code *size} is
 *                         updated to the new allocated size, in particular 0
 *                         in case of failure.
 * @param min_size [in] Desired minimal size of buffer {@code ptr}
 * @return {@code ptr} if the buffer is large enough, a pointer to newly reallocated
 *         buffer if the buffer was not large enough, or {@code NULL} in case of
 *         error
 * @see av_realloc()
 * @see av_fast_malloc()
 */
@NoException public static native Pointer av_fast_realloc(Pointer ptr, @Cast("unsigned int*") IntPointer size, @Cast("size_t") long min_size);
@NoException public static native Pointer av_fast_realloc(Pointer ptr, @Cast("unsigned int*") IntBuffer size, @Cast("size_t") long min_size);
@NoException public static native Pointer av_fast_realloc(Pointer ptr, @Cast("unsigned int*") int[] size, @Cast("size_t") long min_size);

/**
 * Allocate a buffer, reusing the given one if large enough.
 *
 * Contrary to av_fast_realloc(), the current buffer contents might not be
 * preserved and on error the old buffer is freed, thus no special handling to
 * avoid memleaks is necessary.
 *
 * {@code *ptr} is allowed to be {@code NULL}, in which case allocation always happens if
 * {@code size_needed} is greater than 0.
 *
 * <pre>{@code {.c}
 * uint8_t *buf = ...;
 * av_fast_malloc(&buf, &current_size, size_needed);
 * if (!buf) {
 *     // Allocation failed; buf already freed
 *     return AVERROR(ENOMEM);
 * }
 * }</pre>
 *
 * @param ptr [in,out]      Pointer to pointer to an already allocated buffer.
 *                         {@code *ptr} will be overwritten with pointer to new
 *                         buffer on success or {@code NULL} on failure
 * @param size [in,out]     Pointer to the size of buffer {@code *ptr}. {@code *size} is
 *                         updated to the new allocated size, in particular 0
 *                         in case of failure.
 * @param min_size [in] Desired minimal size of buffer {@code *ptr}
 * @see av_realloc()
 * @see av_fast_mallocz()
 */
@NoException public static native void av_fast_malloc(Pointer ptr, @Cast("unsigned int*") IntPointer size, @Cast("size_t") long min_size);
@NoException public static native void av_fast_malloc(Pointer ptr, @Cast("unsigned int*") IntBuffer size, @Cast("size_t") long min_size);
@NoException public static native void av_fast_malloc(Pointer ptr, @Cast("unsigned int*") int[] size, @Cast("size_t") long min_size);

/**
 * Allocate and clear a buffer, reusing the given one if large enough.
 *
 * Like av_fast_malloc(), but all newly allocated space is initially cleared.
 * Reused buffer is not cleared.
 *
 * {@code *ptr} is allowed to be {@code NULL}, in which case allocation always happens if
 * {@code size_needed} is greater than 0.
 *
 * @param ptr [in,out]      Pointer to pointer to an already allocated buffer.
 *                         {@code *ptr} will be overwritten with pointer to new
 *                         buffer on success or {@code NULL} on failure
 * @param size [in,out]     Pointer to the size of buffer {@code *ptr}. {@code *size} is
 *                         updated to the new allocated size, in particular 0
 *                         in case of failure.
 * @param min_size [in] Desired minimal size of buffer {@code *ptr}
 * @see av_fast_malloc()
 */
@NoException public static native void av_fast_mallocz(Pointer ptr, @Cast("unsigned int*") IntPointer size, @Cast("size_t") long min_size);
@NoException public static native void av_fast_mallocz(Pointer ptr, @Cast("unsigned int*") IntBuffer size, @Cast("size_t") long min_size);
@NoException public static native void av_fast_mallocz(Pointer ptr, @Cast("unsigned int*") int[] size, @Cast("size_t") long min_size);

/**
 * Free a memory block which has been allocated with a function of av_malloc()
 * or av_realloc() family.
 *
 * @param ptr Pointer to the memory block which should be freed.
 *
 * \note {@code ptr = NULL} is explicitly allowed.
 * \note It is recommended that you use av_freep() instead, to prevent leaving
 *       behind dangling pointers.
 * @see av_freep()
 */
@NoException public static native void av_free(Pointer ptr);

/**
 * Free a memory block which has been allocated with a function of av_malloc()
 * or av_realloc() family, and set the pointer pointing to it to {@code NULL}.
 *
 * <pre>{@code {.c}
 * uint8_t *buf = av_malloc(16);
 * av_free(buf);
 * // buf now contains a dangling pointer to freed memory, and accidental
 * // dereference of buf will result in a use-after-free, which may be a
 * // security risk.
 *
 * uint8_t *buf = av_malloc(16);
 * av_freep(&buf);
 * // buf is now NULL, and accidental dereference will only result in a
 * // NULL-pointer dereference.
 * }</pre>
 *
 * @param ptr Pointer to the pointer to the memory block which should be freed
 * \note {@code *ptr = NULL} is safe and leads to no action.
 * @see av_free()
 */
@NoException public static native void av_freep(Pointer ptr);

/**
 * Duplicate a string.
 *
 * @param s String to be duplicated
 * @return Pointer to a newly-allocated string containing a
 *         copy of {@code s} or {@code NULL} if the string cannot be allocated
 * @see av_strndup()
 */
@NoException public static native @Cast("char*") BytePointer av_strdup(@Cast("const char*") BytePointer s);
@NoException public static native @Cast("char*") ByteBuffer av_strdup(String s);

/**
 * Duplicate a substring of a string.
 *
 * @param s   String to be duplicated
 * @param len Maximum length of the resulting string (not counting the
 *            terminating byte)
 * @return Pointer to a newly-allocated string containing a
 *         substring of {@code s} or {@code NULL} if the string cannot be allocated
 */
@NoException public static native @Cast("char*") BytePointer av_strndup(@Cast("const char*") BytePointer s, @Cast("size_t") long len);
@NoException public static native @Cast("char*") ByteBuffer av_strndup(String s, @Cast("size_t") long len);

/**
 * Duplicate a buffer with av_malloc().
 *
 * @param p    Buffer to be duplicated
 * @param size Size in bytes of the buffer copied
 * @return Pointer to a newly allocated buffer containing a
 *         copy of {@code p} or {@code NULL} if the buffer cannot be allocated
 */
@NoException public static native Pointer av_memdup(@Const Pointer p, @Cast("size_t") long size);

/**
 * Overlapping memcpy() implementation.
 *
 * @param dst  Destination buffer
 * @param back Number of bytes back to start copying (i.e. the initial size of
 *             the overlapping window); must be > 0
 * @param cnt  Number of bytes to copy; must be >= 0
 *
 * \note {@code cnt > back} is valid, this will copy the bytes we just copied,
 *       thus creating a repeating pattern with a period length of {@code back}.
 */
@NoException public static native void av_memcpy_backptr(@Cast("uint8_t*") BytePointer dst, int back, int cnt);
@NoException public static native void av_memcpy_backptr(@Cast("uint8_t*") ByteBuffer dst, int back, int cnt);
@NoException public static native void av_memcpy_backptr(@Cast("uint8_t*") byte[] dst, int back, int cnt);

/**
 * \}
 */

/**
 * \defgroup lavu_mem_dynarray Dynamic Array
 *
 * Utilities to make an array grow when needed.
 *
 * Sometimes, the programmer would want to have an array that can grow when
 * needed. The libavutil dynamic array utilities fill that need.
 *
 * libavutil supports two systems of appending elements onto a dynamically
 * allocated array, the first one storing the pointer to the value in the
 * array, and the second storing the value directly. In both systems, the
 * caller is responsible for maintaining a variable containing the length of
 * the array, as well as freeing of the array after use.
 *
 * The first system stores pointers to values in a block of dynamically
 * allocated memory. Since only pointers are stored, the function does not need
 * to know the size of the type. Both av_dynarray_add() and
 * av_dynarray_add_nofree() implement this system.
 *
 * <pre>{@code
 * type **array = NULL; //< an array of pointers to values
 * int    nb    = 0;    //< a variable to keep track of the length of the array
 *
 * type to_be_added  = ...;
 * type to_be_added2 = ...;
 *
 * av_dynarray_add(&array, &nb, &to_be_added);
 * if (nb == 0)
 *     return AVERROR(ENOMEM);
 *
 * av_dynarray_add(&array, &nb, &to_be_added2);
 * if (nb == 0)
 *     return AVERROR(ENOMEM);
 *
 * // Now:
 * //  nb           == 2
 * // &to_be_added  == array[0]
 * // &to_be_added2 == array[1]
 *
 * av_freep(&array);
 * }</pre>
 *
 * The second system stores the value directly in a block of memory. As a
 * result, the function has to know the size of the type. av_dynarray2_add()
 * implements this mechanism.
 *
 * <pre>{@code
 * type *array = NULL; //< an array of values
 * int   nb    = 0;    //< a variable to keep track of the length of the array
 *
 * type to_be_added  = ...;
 * type to_be_added2 = ...;
 *
 * type *addr = av_dynarray2_add((void **)&array, &nb, sizeof(*array), NULL);
 * if (!addr)
 *     return AVERROR(ENOMEM);
 * memcpy(addr, &to_be_added, sizeof(to_be_added));
 *
 * // Shortcut of the above.
 * type *addr = av_dynarray2_add((void **)&array, &nb, sizeof(*array),
 *                               (const void *)&to_be_added2);
 * if (!addr)
 *     return AVERROR(ENOMEM);
 *
 * // Now:
 * //  nb           == 2
 * //  to_be_added  == array[0]
 * //  to_be_added2 == array[1]
 *
 * av_freep(&array);
 * }</pre>
 *
 * \{
 */

/**
 * Add the pointer to an element to a dynamic array.
 *
 * The array to grow is supposed to be an array of pointers to
 * structures, and the element to add must be a pointer to an already
 * allocated structure.
 *
 * The array is reallocated when its size reaches powers of 2.
 * Therefore, the amortized cost of adding an element is constant.
 *
 * In case of success, the pointer to the array is updated in order to
 * point to the new grown array, and the number pointed to by {@code nb_ptr}
 * is incremented.
 * In case of failure, the array is freed, {@code *tab_ptr} is set to {@code NULL} and
 * {@code *nb_ptr} is set to 0.
 *
 * @param tab_ptr [in,out] Pointer to the array to grow
 * @param nb_ptr [in,out]  Pointer to the number of elements in the array
 * @param elem [in]    Element to add
 * @see av_dynarray_add_nofree(), av_dynarray2_add()
 */
@NoException public static native void av_dynarray_add(Pointer tab_ptr, IntPointer nb_ptr, Pointer elem);
@NoException public static native void av_dynarray_add(Pointer tab_ptr, IntBuffer nb_ptr, Pointer elem);
@NoException public static native void av_dynarray_add(Pointer tab_ptr, int[] nb_ptr, Pointer elem);

/**
 * Add an element to a dynamic array.
 *
 * Function has the same functionality as av_dynarray_add(),
 * but it doesn't free memory on fails. It returns error code
 * instead and leave current buffer untouched.
 *
 * @return >=0 on success, negative otherwise
 * @see av_dynarray_add(), av_dynarray2_add()
 */
@NoException public static native int av_dynarray_add_nofree(Pointer tab_ptr, IntPointer nb_ptr, Pointer elem);
@NoException public static native int av_dynarray_add_nofree(Pointer tab_ptr, IntBuffer nb_ptr, Pointer elem);
@NoException public static native int av_dynarray_add_nofree(Pointer tab_ptr, int[] nb_ptr, Pointer elem);

/**
 * Add an element of size {@code elem_size} to a dynamic array.
 *
 * The array is reallocated when its number of elements reaches powers of 2.
 * Therefore, the amortized cost of adding an element is constant.
 *
 * In case of success, the pointer to the array is updated in order to
 * point to the new grown array, and the number pointed to by {@code nb_ptr}
 * is incremented.
 * In case of failure, the array is freed, {@code *tab_ptr} is set to {@code NULL} and
 * {@code *nb_ptr} is set to 0.
 *
 * @param tab_ptr [in,out]   Pointer to the array to grow
 * @param nb_ptr [in,out]    Pointer to the number of elements in the array
 * @param elem_size [in] Size in bytes of an element in the array
 * @param elem_data [in] Pointer to the data of the element to add. If
 *                          {@code NULL}, the space of the newly added element is
 *                          allocated but left uninitialized.
 *
 * @return Pointer to the data of the element to copy in the newly allocated
 *         space
 * @see av_dynarray_add(), av_dynarray_add_nofree()
 */
@NoException public static native Pointer av_dynarray2_add(@Cast("void**") PointerPointer tab_ptr, IntPointer nb_ptr, @Cast("size_t") long elem_size,
                       @Cast("const uint8_t*") BytePointer elem_data);
@NoException public static native Pointer av_dynarray2_add(@Cast("void**") @ByPtrPtr Pointer tab_ptr, IntPointer nb_ptr, @Cast("size_t") long elem_size,
                       @Cast("const uint8_t*") BytePointer elem_data);
@NoException public static native Pointer av_dynarray2_add(@Cast("void**") @ByPtrPtr Pointer tab_ptr, IntBuffer nb_ptr, @Cast("size_t") long elem_size,
                       @Cast("const uint8_t*") ByteBuffer elem_data);
@NoException public static native Pointer av_dynarray2_add(@Cast("void**") @ByPtrPtr Pointer tab_ptr, int[] nb_ptr, @Cast("size_t") long elem_size,
                       @Cast("const uint8_t*") byte[] elem_data);

/**
 * \}
 */

/**
 * \defgroup lavu_mem_misc Miscellaneous Functions
 *
 * Other functions related to memory allocation.
 *
 * \{
 */

/**
 * Multiply two {@code size_t} values checking for overflow.
 *
 * @param a [in] ,b Operands of multiplication
 * @param r [out]   Pointer to the result of the operation
 * @return 0 on success, AVERROR(EINVAL) on overflow
 */
@NoException public static native int av_size_mult(@Cast("size_t") long a, @Cast("size_t") long b, @Cast("size_t*") SizeTPointer r);

/**
 * Set the maximum size that may be allocated in one block.
 *
 * The value specified with this function is effective for all libavutil's \ref
 * lavu_mem_funcs "heap management functions."
 *
 * By default, the max value is defined as {@code INT_MAX}.
 *
 * @param max Value to be set as the new maximum size
 *
 * \warning Exercise extreme caution when using this function. Don't touch
 *          this if you do not understand the full consequence of doing so.
 */
@NoException public static native void av_max_alloc(@Cast("size_t") long max);

/**
 * \}
 * \}
 */

// #endif /* AVUTIL_MEM_H */


// Parsed from <libavutil/time.h>

/*
 * Copyright (c) 2000-2003 Fabrice Bellard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_TIME_H
// #define AVUTIL_TIME_H

// #include <stdint.h>

/**
 * Get the current time in microseconds.
 */
@NoException public static native @Cast("int64_t") long av_gettime();

/**
 * Get the current time in microseconds since some unspecified starting point.
 * On platforms that support it, the time comes from a monotonic clock
 * This property makes this time source ideal for measuring relative time.
 * The returned values may not be monotonic on platforms where a monotonic
 * clock is not available.
 */
@NoException public static native @Cast("int64_t") long av_gettime_relative();

/**
 * Indicates with a boolean result if the av_gettime_relative() time source
 * is monotonic.
 */
@NoException public static native int av_gettime_relative_is_monotonic();

/**
 * Sleep for a period of time.  Although the duration is expressed in
 * microseconds, the actual delay may be rounded to the precision of the
 * system timer.
 *
 * @param  usec Number of microseconds to sleep.
 * @return zero on success or (negative) error code.
 */
@NoException public static native int av_usleep(@Cast("unsigned") int usec);

// #endif /* AVUTIL_TIME_H */


// Parsed from <libavutil/mathematics.h>

/*
 * copyright (c) 2005-2012 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \addtogroup lavu_math
 * Mathematical utilities for working with timestamp and time base.
 */

// #ifndef AVUTIL_MATHEMATICS_H
// #define AVUTIL_MATHEMATICS_H

// #include <stdint.h>
// #include <math.h>
// #include "attributes.h"
// #include "rational.h"
// #include "intfloat.h"

// #ifndef M_E
public static final double M_E =            2.7182818284590452354;   /* e */
// #endif
// #ifndef M_LN2
public static final double M_LN2 =          0.69314718055994530942;  /* log_e 2 */
// #endif
// #ifndef M_LN10
public static final double M_LN10 =         2.30258509299404568402;  /* log_e 10 */
// #endif
// #ifndef M_LOG2_10
public static final double M_LOG2_10 =      3.32192809488736234787;  /* log_2 10 */
// #endif
// #ifndef M_PHI
public static final double M_PHI =          1.61803398874989484820;   /* phi / golden ratio */
// #endif
// #ifndef M_PI
public static final double M_PI =           3.14159265358979323846;  /* pi */
// #endif
// #ifndef M_PI_2
public static final double M_PI_2 =         1.57079632679489661923;  /* pi/2 */
// #endif
// #ifndef M_SQRT1_2
public static final double M_SQRT1_2 =      0.70710678118654752440;  /* 1/sqrt(2) */
// #endif
// #ifndef M_SQRT2
public static final double M_SQRT2 =        1.41421356237309504880;  /* sqrt(2) */
// #endif
// #ifndef NAN
public static native @MemberGetter double NAN();
public static final double NAN = NAN();
// #endif
// #ifndef INFINITY
public static native @MemberGetter double INFINITY();
public static final double INFINITY = INFINITY();
// #endif

/**
 * \addtogroup lavu_math
 *
 * \{
 */

/**
 * Rounding methods.
 */
/** enum AVRounding */
public static final int
    /** Round toward zero. */
    AV_ROUND_ZERO     = 0,
    /** Round away from zero. */
    AV_ROUND_INF      = 1,
    /** Round toward -infinity. */
    AV_ROUND_DOWN     = 2,
    /** Round toward +infinity. */
    AV_ROUND_UP       = 3,
    /** Round to nearest and halfway cases away from zero. */
    AV_ROUND_NEAR_INF = 5,
    /**
     * Flag telling rescaling functions to pass {@code INT64_MIN}/{@code MAX} through
     * unchanged, avoiding special cases for #AV_NOPTS_VALUE.
     *
     * Unlike other values of the enumeration AVRounding, this value is a
     * bitmask that must be used in conjunction with another value of the
     * enumeration through a bitwise OR, in order to set behavior for normal
     * cases.
     *
     * <pre>{@code {.c}
     * av_rescale_rnd(3, 1, 2, AV_ROUND_UP | AV_ROUND_PASS_MINMAX);
     * // Rescaling 3:
     * //     Calculating 3 * 1 / 2
     * //     3 / 2 is rounded up to 2
     * //     => 2
     *
     * av_rescale_rnd(AV_NOPTS_VALUE, 1, 2, AV_ROUND_UP | AV_ROUND_PASS_MINMAX);
     * // Rescaling AV_NOPTS_VALUE:
     * //     AV_NOPTS_VALUE == INT64_MIN
     * //     AV_NOPTS_VALUE is passed through
     * //     => AV_NOPTS_VALUE
     * }</pre>
     */
    AV_ROUND_PASS_MINMAX = 8192;

/**
 * Compute the greatest common divisor of two integer operands.
 *
 * @param a,b Operands
 * @return GCD of a and b up to sign; if a >= 0 and b >= 0, return value is >= 0;
 * if a == 0 and b == 0, returns 0.
 */
@NoException public static native @Cast("int64_t") @Const long av_gcd(@Cast("int64_t") long a, @Cast("int64_t") long b);

/**
 * Rescale a 64-bit integer with rounding to nearest.
 *
 * The operation is mathematically equivalent to {@code a * b / c}, but writing that
 * directly can overflow.
 *
 * This function is equivalent to av_rescale_rnd() with #AV_ROUND_NEAR_INF.
 *
 * @see av_rescale_rnd(), av_rescale_q(), av_rescale_q_rnd()
 */
@NoException public static native @Cast("int64_t") @Const long av_rescale(@Cast("int64_t") long a, @Cast("int64_t") long b, @Cast("int64_t") long c);

/**
 * Rescale a 64-bit integer with specified rounding.
 *
 * The operation is mathematically equivalent to {@code a * b / c}, but writing that
 * directly can overflow, and does not support different rounding methods.
 *
 * @see av_rescale(), av_rescale_q(), av_rescale_q_rnd()
 */
@NoException public static native @Cast("int64_t") @Const long av_rescale_rnd(@Cast("int64_t") long a, @Cast("int64_t") long b, @Cast("int64_t") long c, @Cast("AVRounding") int rnd);

/**
 * Rescale a 64-bit integer by 2 rational numbers.
 *
 * The operation is mathematically equivalent to {@code a * bq / cq}.
 *
 * This function is equivalent to av_rescale_q_rnd() with #AV_ROUND_NEAR_INF.
 *
 * @see av_rescale(), av_rescale_rnd(), av_rescale_q_rnd()
 */
@NoException public static native @Cast("int64_t") @Const long av_rescale_q(@Cast("int64_t") long a, @ByVal AVRational bq, @ByVal AVRational cq);

/**
 * Rescale a 64-bit integer by 2 rational numbers with specified rounding.
 *
 * The operation is mathematically equivalent to {@code a * bq / cq}.
 *
 * @see av_rescale(), av_rescale_rnd(), av_rescale_q()
 */
@NoException public static native @Cast("int64_t") @Const long av_rescale_q_rnd(@Cast("int64_t") long a, @ByVal AVRational bq, @ByVal AVRational cq,
                         @Cast("AVRounding") int rnd);

/**
 * Compare two timestamps each in its own time base.
 *
 * @return One of the following values:
 *         - -1 if {@code ts_a} is before {@code ts_b}
 *         - 1 if {@code ts_a} is after {@code ts_b}
 *         - 0 if they represent the same position
 *
 * \warning
 * The result of the function is undefined if one of the timestamps is outside
 * the {@code int64_t} range when represented in the other's timebase.
 */
@NoException public static native int av_compare_ts(@Cast("int64_t") long ts_a, @ByVal AVRational tb_a, @Cast("int64_t") long ts_b, @ByVal AVRational tb_b);

/**
 * Compare the remainders of two integer operands divided by a common divisor.
 *
 * In other words, compare the least significant {@code log2(mod)} bits of integers
 * {@code a} and {@code b}.
 *
 * <pre>{@code {.c}
 * av_compare_mod(0x11, 0x02, 0x10) < 0 // since 0x11 % 0x10  (0x1) < 0x02 % 0x10  (0x2)
 * av_compare_mod(0x11, 0x02, 0x20) > 0 // since 0x11 % 0x20 (0x11) > 0x02 % 0x20 (0x02)
 * }</pre>
 *
 * @param a,b Operands
 * @param mod Divisor; must be a power of 2
 * @return
 *         - a negative value if {@code a % mod < b % mod}
 *         - a positive value if {@code a % mod > b % mod}
 *         - zero             if {@code a % mod == b % mod}
 */
@NoException public static native @Cast("int64_t") long av_compare_mod(@Cast("uint64_t") long a, @Cast("uint64_t") long b, @Cast("uint64_t") long mod);

/**
 * Rescale a timestamp while preserving known durations.
 *
 * This function is designed to be called per audio packet to scale the input
 * timestamp to a different time base. Compared to a simple av_rescale_q()
 * call, this function is robust against possible inconsistent frame durations.
 *
 * The {@code last} parameter is a state variable that must be preserved for all
 * subsequent calls for the same stream. For the first call, {@code *last} should be
 * initialized to #AV_NOPTS_VALUE.
 *
 * @param in_tb [in]    Input time base
 * @param in_ts [in]    Input timestamp
 * @param fs_tb [in]    Duration time base; typically this is finer-grained
 *                         (greater) than {@code in_tb} and {@code out_tb}
 * @param duration [in] Duration till the next call to this function (i.e.
 *                         duration of the current packet/frame)
 * @param last [in,out]     Pointer to a timestamp expressed in terms of
 *                         {@code fs_tb}, acting as a state variable
 * @param out_tb [in]   Output timebase
 * @return        Timestamp expressed in terms of {@code out_tb}
 *
 * \note In the context of this function, "duration" is in term of samples, not
 *       seconds.
 */
@NoException public static native @Cast("int64_t") long av_rescale_delta(@ByVal AVRational in_tb, @Cast("int64_t") long in_ts,  @ByVal AVRational fs_tb, int duration, @Cast("int64_t*") LongPointer last, @ByVal AVRational out_tb);
@NoException public static native @Cast("int64_t") long av_rescale_delta(@ByVal AVRational in_tb, @Cast("int64_t") long in_ts,  @ByVal AVRational fs_tb, int duration, @Cast("int64_t*") LongBuffer last, @ByVal AVRational out_tb);
@NoException public static native @Cast("int64_t") long av_rescale_delta(@ByVal AVRational in_tb, @Cast("int64_t") long in_ts,  @ByVal AVRational fs_tb, int duration, @Cast("int64_t*") long[] last, @ByVal AVRational out_tb);

/**
 * Add a value to a timestamp.
 *
 * This function guarantees that when the same value is repeatly added that
 * no accumulation of rounding errors occurs.
 *
 * @param ts [in]     Input timestamp
 * @param ts_tb [in]  Input timestamp time base
 * @param inc [in]    Value to be added
 * @param inc_tb [in] Time base of {@code inc}
 */
@NoException public static native @Cast("int64_t") long av_add_stable(@ByVal AVRational ts_tb, @Cast("int64_t") long ts, @ByVal AVRational inc_tb, @Cast("int64_t") long inc);


/**
 * \}
 */

// #endif /* AVUTIL_MATHEMATICS_H */


// Parsed from <libavutil/rational.h>

/*
 * rational numbers
 * Copyright (c) 2003 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_math_rational
 * Utilties for rational number calculation.
 * @author Michael Niedermayer <michaelni\gmx.at>
 */

// #ifndef AVUTIL_RATIONAL_H
// #define AVUTIL_RATIONAL_H

// #include <stdint.h>
// #include <limits.h>
// #include "attributes.h"
// Targeting ..\avutil\AVRational.java



/**
 * Create an AVRational.
 *
 * Useful for compilers that do not support compound literals.
 *
 * \note The return value is not reduced.
 * @see av_reduce()
 */
@NoException public static native @ByVal AVRational av_make_q(int num, int den);

/**
 * Compare two rationals.
 *
 * @param a First rational
 * @param b Second rational
 *
 * @return One of the following values:
 *         - 0 if {@code a == b}
 *         - 1 if {@code a > b}
 *         - -1 if {@code a < b}
 *         - {@code INT_MIN} if one of the values is of the form {@code 0 / 0}
 */
@NoException public static native int av_cmp_q(@ByVal AVRational a, @ByVal AVRational b);

/**
 * Convert an AVRational to a {@code double}.
 * @param a AVRational to convert
 * @return {@code a} in floating-point form
 * @see av_d2q()
 */
@NoException public static native double av_q2d(@ByVal AVRational a);

/**
 * Reduce a fraction.
 *
 * This is useful for framerate calculations.
 *
 * @param dst_num [out] Destination numerator
 * @param dst_den [out] Destination denominator
 * @param num [in] Source numerator
 * @param den [in] Source denominator
 * @param max [in] Maximum allowed values for {@code dst_num} & {@code dst_den}
 * @return 1 if the operation is exact, 0 otherwise
 */
@NoException public static native int av_reduce(IntPointer dst_num, IntPointer dst_den, @Cast("int64_t") long num, @Cast("int64_t") long den, @Cast("int64_t") long max);
@NoException public static native int av_reduce(IntBuffer dst_num, IntBuffer dst_den, @Cast("int64_t") long num, @Cast("int64_t") long den, @Cast("int64_t") long max);
@NoException public static native int av_reduce(int[] dst_num, int[] dst_den, @Cast("int64_t") long num, @Cast("int64_t") long den, @Cast("int64_t") long max);

/**
 * Multiply two rationals.
 * @param b First rational
 * @param c Second rational
 * @return b*c
 */
@NoException public static native @ByVal @Const AVRational av_mul_q(@ByVal AVRational b, @ByVal AVRational c);

/**
 * Divide one rational by another.
 * @param b First rational
 * @param c Second rational
 * @return b/c
 */
@NoException public static native @ByVal @Const AVRational av_div_q(@ByVal AVRational b, @ByVal AVRational c);

/**
 * Add two rationals.
 * @param b First rational
 * @param c Second rational
 * @return b+c
 */
@NoException public static native @ByVal @Const AVRational av_add_q(@ByVal AVRational b, @ByVal AVRational c);

/**
 * Subtract one rational from another.
 * @param b First rational
 * @param c Second rational
 * @return b-c
 */
@NoException public static native @ByVal @Const AVRational av_sub_q(@ByVal AVRational b, @ByVal AVRational c);

/**
 * Invert a rational.
 * @param q value
 * @return 1 / q
 */
@NoException public static native @ByVal AVRational av_inv_q(@ByVal AVRational q);

/**
 * Convert a double precision floating point number to a rational.
 *
 * In case of infinity, the returned value is expressed as {@code {1, 0}} or
 * {@code {-1, 0}} depending on the sign.
 *
 * @param d   {@code double} to convert
 * @param max Maximum allowed numerator and denominator
 * @return {@code d} in AVRational form
 * @see av_q2d()
 */
@NoException public static native @ByVal @Const AVRational av_d2q(double d, int max);

/**
 * Find which of the two rationals is closer to another rational.
 *
 * @param q     Rational to be compared against
 * @param q1,q2 Rationals to be tested
 * @return One of the following values:
 *         - 1 if {@code q1} is nearer to {@code q} than {@code q2}
 *         - -1 if {@code q2} is nearer to {@code q} than {@code q1}
 *         - 0 if they have the same distance
 */
@NoException public static native int av_nearer_q(@ByVal AVRational q, @ByVal AVRational q1, @ByVal AVRational q2);

/**
 * Find the value in a list of rationals nearest a given reference rational.
 *
 * @param q      Reference rational
 * @param q_list Array of rationals terminated by {@code {0, 0}}
 * @return Index of the nearest value found in the array
 */
@NoException public static native int av_find_nearest_q_idx(@ByVal AVRational q, @Const AVRational q_list);

/**
 * Convert an AVRational to a IEEE 32-bit {@code float} expressed in fixed-point
 * format.
 *
 * @param q Rational to be converted
 * @return Equivalent floating-point value, expressed as an unsigned 32-bit
 *         integer.
 * \note The returned value is platform-indepedant.
 */
@NoException public static native @Cast("uint32_t") int av_q2intfloat(@ByVal AVRational q);

/**
 * Return the best rational so that a and b are multiple of it.
 * If the resulting denominator is larger than max_den, return def.
 */
@NoException public static native @ByVal AVRational av_gcd_q(@ByVal AVRational a, @ByVal AVRational b, int max_den, @ByVal AVRational def);

/**
 * \}
 */

// #endif /* AVUTIL_RATIONAL_H */


// Parsed from <libavutil/log.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_LOG_H
// #define AVUTIL_LOG_H

// #include <stdarg.h>
// #include "avutil.h"
// #include "attributes.h"
// #include "version.h"

/** enum AVClassCategory */
public static final int
    AV_CLASS_CATEGORY_NA = 0,
    AV_CLASS_CATEGORY_INPUT = 1,
    AV_CLASS_CATEGORY_OUTPUT = 2,
    AV_CLASS_CATEGORY_MUXER = 3,
    AV_CLASS_CATEGORY_DEMUXER = 4,
    AV_CLASS_CATEGORY_ENCODER = 5,
    AV_CLASS_CATEGORY_DECODER = 6,
    AV_CLASS_CATEGORY_FILTER = 7,
    AV_CLASS_CATEGORY_BITSTREAM_FILTER = 8,
    AV_CLASS_CATEGORY_SWSCALER = 9,
    AV_CLASS_CATEGORY_SWRESAMPLER = 10,
    AV_CLASS_CATEGORY_DEVICE_VIDEO_OUTPUT = 40,
    AV_CLASS_CATEGORY_DEVICE_VIDEO_INPUT = 41,
    AV_CLASS_CATEGORY_DEVICE_AUDIO_OUTPUT = 42,
    AV_CLASS_CATEGORY_DEVICE_AUDIO_INPUT = 43,
    AV_CLASS_CATEGORY_DEVICE_OUTPUT = 44,
    AV_CLASS_CATEGORY_DEVICE_INPUT = 45,
    /** not part of ABI/API */
    AV_CLASS_CATEGORY_NB = 46;

// #define AV_IS_INPUT_DEVICE(category)
//     (((category) == AV_CLASS_CATEGORY_DEVICE_VIDEO_INPUT) ||
//      ((category) == AV_CLASS_CATEGORY_DEVICE_AUDIO_INPUT) ||
//      ((category) == AV_CLASS_CATEGORY_DEVICE_INPUT))

// #define AV_IS_OUTPUT_DEVICE(category)
//     (((category) == AV_CLASS_CATEGORY_DEVICE_VIDEO_OUTPUT) ||
//      ((category) == AV_CLASS_CATEGORY_DEVICE_AUDIO_OUTPUT) ||
//      ((category) == AV_CLASS_CATEGORY_DEVICE_OUTPUT))
// Targeting ..\avutil\AVClass.java



/**
 * \addtogroup lavu_log
 *
 * \{
 *
 * \defgroup lavu_log_constants Logging Constants
 *
 * \{
 */

/**
 * Print no output.
 */
public static final int AV_LOG_QUIET =    -8;

/**
 * Something went really wrong and we will crash now.
 */
public static final int AV_LOG_PANIC =     0;

/**
 * Something went wrong and recovery is not possible.
 * For example, no header was found for a format which depends
 * on headers or an illegal combination of parameters is used.
 */
public static final int AV_LOG_FATAL =     8;

/**
 * Something went wrong and cannot losslessly be recovered.
 * However, not all future data is affected.
 */
public static final int AV_LOG_ERROR =    16;

/**
 * Something somehow does not look correct. This may or may not
 * lead to problems. An example would be the use of '-vstrict -2'.
 */
public static final int AV_LOG_WARNING =  24;

/**
 * Standard information.
 */
public static final int AV_LOG_INFO =     32;

/**
 * Detailed information.
 */
public static final int AV_LOG_VERBOSE =  40;

/**
 * Stuff which is only useful for libav* developers.
 */
public static final int AV_LOG_DEBUG =    48;

/**
 * Extremely verbose debugging, useful for libav* development.
 */
public static final int AV_LOG_TRACE =    56;

public static final int AV_LOG_MAX_OFFSET = (AV_LOG_TRACE - AV_LOG_QUIET);

/**
 * \}
 */

/**
 * Sets additional colors for extended debugging sessions.
 * <pre>{@code
   av_log(ctx, AV_LOG_DEBUG|AV_LOG_C(134), "Message in purple\n");
   }</pre>
 * Requires 256color terminal support. Uses outside debugging is not
 * recommended.
 */
// #define AV_LOG_C(x) ((x) << 8)

/**
 * Send the specified message to the log if the level is less than or equal
 * to the current av_log_level. By default, all logging messages are sent to
 * stderr. This behavior can be altered by setting a different logging callback
 * function.
 * @see av_log_set_callback
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 *        pointer to an AVClass struct or NULL if general log.
 * @param level The importance level of the message expressed using a \ref
 *        lavu_log_constants "Logging Constant".
 * @param fmt The format string (printf-compatible) that specifies how
 *        subsequent arguments are converted to output.
 */
@NoException public static native void av_log(Pointer avcl, int level, @Cast("const char*") BytePointer fmt);
@NoException public static native void av_log(Pointer avcl, int level, String fmt);

/**
 * Send the specified message to the log once with the initial_level and then with
 * the subsequent_level. By default, all logging messages are sent to
 * stderr. This behavior can be altered by setting a different logging callback
 * function.
 * @see av_log
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 *        pointer to an AVClass struct or NULL if general log.
 * @param initial_level importance level of the message expressed using a \ref
 *        lavu_log_constants "Logging Constant" for the first occurance.
 * @param subsequent_level importance level of the message expressed using a \ref
 *        lavu_log_constants "Logging Constant" after the first occurance.
 * @param fmt The format string (printf-compatible) that specifies how
 *        subsequent arguments are converted to output.
 * @param state a variable to keep trak of if a message has already been printed
 *        this must be initialized to 0 before the first use. The same state
 *        must not be accessed by 2 Threads simultaneously.
 */
@NoException public static native void av_log_once(Pointer avcl, int initial_level, int subsequent_level, IntPointer state, @Cast("const char*") BytePointer fmt);
@NoException public static native void av_log_once(Pointer avcl, int initial_level, int subsequent_level, IntBuffer state, String fmt);
@NoException public static native void av_log_once(Pointer avcl, int initial_level, int subsequent_level, int[] state, @Cast("const char*") BytePointer fmt);
@NoException public static native void av_log_once(Pointer avcl, int initial_level, int subsequent_level, IntPointer state, String fmt);
@NoException public static native void av_log_once(Pointer avcl, int initial_level, int subsequent_level, IntBuffer state, @Cast("const char*") BytePointer fmt);
@NoException public static native void av_log_once(Pointer avcl, int initial_level, int subsequent_level, int[] state, String fmt);


/**
 * Send the specified message to the log if the level is less than or equal
 * to the current av_log_level. By default, all logging messages are sent to
 * stderr. This behavior can be altered by setting a different logging callback
 * function.
 * @see av_log_set_callback
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 *        pointer to an AVClass struct.
 * @param level The importance level of the message expressed using a \ref
 *        lavu_log_constants "Logging Constant".
 * @param fmt The format string (printf-compatible) that specifies how
 *        subsequent arguments are converted to output.
 * @param vl The arguments referenced by the format string.
 */
@NoException public static native void av_vlog(Pointer avcl, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl);
@NoException public static native void av_vlog(Pointer avcl, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl);

/**
 * Get the current log level
 *
 * @see lavu_log_constants
 *
 * @return Current log level
 */
@NoException public static native int av_log_get_level();

/**
 * Set the log level
 *
 * @see lavu_log_constants
 *
 * @param level Logging level
 */
@NoException public static native void av_log_set_level(int level);
// Targeting ..\avutil\Callback_Pointer_int_BytePointer_Pointer.java


@NoException public static native void av_log_set_callback(Callback_Pointer_int_BytePointer_Pointer callback);
// Targeting ..\avutil\Callback_Pointer_int_String_Pointer.java


@NoException public static native void av_log_set_callback(Callback_Pointer_int_String_Pointer callback);

/**
 * Default logging callback
 *
 * It prints the message to stderr, optionally colorizing it.
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 *        pointer to an AVClass struct.
 * @param level The importance level of the message expressed using a \ref
 *        lavu_log_constants "Logging Constant".
 * @param fmt The format string (printf-compatible) that specifies how
 *        subsequent arguments are converted to output.
 * @param vl The arguments referenced by the format string.
 */
@NoException public static native void av_log_default_callback(Pointer avcl, int level, @Cast("const char*") BytePointer fmt,
                             @ByVal @Cast("va_list*") Pointer vl);
@NoException public static native void av_log_default_callback(Pointer avcl, int level, String fmt,
                             @ByVal @Cast("va_list*") Pointer vl);

/**
 * Return the context name
 *
 * @param  ctx The AVClass context
 *
 * @return The AVClass class_name
 */
@NoException public static native @Cast("const char*") BytePointer av_default_item_name(Pointer ctx);
@NoException public static native @Cast("AVClassCategory") int av_default_get_category(Pointer ptr);

/**
 * Format a line of log the same way as the default callback.
 * @param line          buffer to receive the formatted line
 * @param line_size     size of the buffer
 * @param print_prefix  used to store whether the prefix must be printed;
 *                      must point to a persistent integer initially set to 1
 */
@NoException public static native void av_log_format_line(Pointer ptr, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") BytePointer line, int line_size, IntPointer print_prefix);
@NoException public static native void av_log_format_line(Pointer ptr, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") ByteBuffer line, int line_size, IntBuffer print_prefix);
@NoException public static native void av_log_format_line(Pointer ptr, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") byte[] line, int line_size, int[] print_prefix);
@NoException public static native void av_log_format_line(Pointer ptr, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") BytePointer line, int line_size, IntPointer print_prefix);
@NoException public static native void av_log_format_line(Pointer ptr, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") ByteBuffer line, int line_size, IntBuffer print_prefix);
@NoException public static native void av_log_format_line(Pointer ptr, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") byte[] line, int line_size, int[] print_prefix);

/**
 * Format a line of log the same way as the default callback.
 * @param line          buffer to receive the formatted line;
 *                      may be NULL if line_size is 0
 * @param line_size     size of the buffer; at most line_size-1 characters will
 *                      be written to the buffer, plus one null terminator
 * @param print_prefix  used to store whether the prefix must be printed;
 *                      must point to a persistent integer initially set to 1
 * @return Returns a negative value if an error occurred, otherwise returns
 *         the number of characters that would have been written for a
 *         sufficiently large buffer, not including the terminating null
 *         character. If the return value is not less than line_size, it means
 *         that the log message was truncated to fit the buffer.
 */
@NoException public static native int av_log_format_line2(Pointer ptr, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") BytePointer line, int line_size, IntPointer print_prefix);
@NoException public static native int av_log_format_line2(Pointer ptr, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") ByteBuffer line, int line_size, IntBuffer print_prefix);
@NoException public static native int av_log_format_line2(Pointer ptr, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") byte[] line, int line_size, int[] print_prefix);
@NoException public static native int av_log_format_line2(Pointer ptr, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") BytePointer line, int line_size, IntPointer print_prefix);
@NoException public static native int av_log_format_line2(Pointer ptr, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") ByteBuffer line, int line_size, IntBuffer print_prefix);
@NoException public static native int av_log_format_line2(Pointer ptr, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl,
                        @Cast("char*") byte[] line, int line_size, int[] print_prefix);

/**
 * Skip repeated messages, this requires the user app to use av_log() instead of
 * (f)printf as the 2 would otherwise interfere and lead to
 * "Last message repeated x times" messages below (f)printf messages with some
 * bad luck.
 * Also to receive the last, "last repeated" line if any, the user app must
 * call av_log(NULL, AV_LOG_QUIET, "%s", ""); at the end
 */
public static final int AV_LOG_SKIP_REPEATED = 1;

/**
 * Include the log severity in messages originating from codecs.
 *
 * Results in messages such as:
 * [rawvideo \ 0xDEADBEEF] [error] encode did not produce valid pts
 */
public static final int AV_LOG_PRINT_LEVEL = 2;

@NoException public static native void av_log_set_flags(int arg);
@NoException public static native int av_log_get_flags();

/**
 * \}
 */

// #endif /* AVUTIL_LOG_H */


// Parsed from <libavutil/buffer.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_buffer
 * refcounted data buffer API
 */

// #ifndef AVUTIL_BUFFER_H
// #define AVUTIL_BUFFER_H

// #include <stdint.h>
// Targeting ..\avutil\AVBuffer.java


// Targeting ..\avutil\AVBufferRef.java



/**
 * Allocate an AVBuffer of the given size using av_malloc().
 *
 * @return an AVBufferRef of given size or NULL when out of memory
 */
@NoException public static native AVBufferRef av_buffer_alloc(int size);

/**
 * Same as av_buffer_alloc(), except the returned buffer will be initialized
 * to zero.
 */
@NoException public static native AVBufferRef av_buffer_allocz(int size);

/**
 * Always treat the buffer as read-only, even when it has only one
 * reference.
 */
public static final int AV_BUFFER_FLAG_READONLY = (1 << 0);
// Targeting ..\avutil\Free_Pointer_BytePointer.java


@NoException public static native AVBufferRef av_buffer_create(@Cast("uint8_t*") BytePointer data, int size,
                              Free_Pointer_BytePointer _free,
                              Pointer opaque, int flags);
// Targeting ..\avutil\Free_Pointer_ByteBuffer.java


@NoException public static native AVBufferRef av_buffer_create(@Cast("uint8_t*") ByteBuffer data, int size,
                              Free_Pointer_ByteBuffer _free,
                              Pointer opaque, int flags);
// Targeting ..\avutil\Free_Pointer_byte__.java


@NoException public static native AVBufferRef av_buffer_create(@Cast("uint8_t*") byte[] data, int size,
                              Free_Pointer_byte__ _free,
                              Pointer opaque, int flags);

/**
 * Default free callback, which calls av_free() on the buffer data.
 * This function is meant to be passed to av_buffer_create(), not called
 * directly.
 */
@NoException public static native void av_buffer_default_free(Pointer opaque, @Cast("uint8_t*") BytePointer data);
@NoException public static native void av_buffer_default_free(Pointer opaque, @Cast("uint8_t*") ByteBuffer data);
@NoException public static native void av_buffer_default_free(Pointer opaque, @Cast("uint8_t*") byte[] data);

/**
 * Create a new reference to an AVBuffer.
 *
 * @return a new AVBufferRef referring to the same AVBuffer as buf or NULL on
 * failure.
 */
@NoException public static native AVBufferRef av_buffer_ref(AVBufferRef buf);

/**
 * Free a given reference and automatically free the buffer if there are no more
 * references to it.
 *
 * @param buf the reference to be freed. The pointer is set to NULL on return.
 */
@NoException public static native void av_buffer_unref(@Cast("AVBufferRef**") PointerPointer buf);
@NoException public static native void av_buffer_unref(@ByPtrPtr AVBufferRef buf);

/**
 * @return 1 if the caller may write to the data referred to by buf (which is
 * true if and only if buf is the only reference to the underlying AVBuffer).
 * Return 0 otherwise.
 * A positive answer is valid until av_buffer_ref() is called on buf.
 */
@NoException public static native int av_buffer_is_writable(@Const AVBufferRef buf);

/**
 * @return the opaque parameter set by av_buffer_create.
 */
@NoException public static native Pointer av_buffer_get_opaque(@Const AVBufferRef buf);

@NoException public static native int av_buffer_get_ref_count(@Const AVBufferRef buf);

/**
 * Create a writable reference from a given buffer reference, avoiding data copy
 * if possible.
 *
 * @param buf buffer reference to make writable. On success, buf is either left
 *            untouched, or it is unreferenced and a new writable AVBufferRef is
 *            written in its place. On failure, buf is left untouched.
 * @return 0 on success, a negative AVERROR on failure.
 */
@NoException public static native int av_buffer_make_writable(@Cast("AVBufferRef**") PointerPointer buf);
@NoException public static native int av_buffer_make_writable(@ByPtrPtr AVBufferRef buf);

/**
 * Reallocate a given buffer.
 *
 * @param buf  a buffer reference to reallocate. On success, buf will be
 *             unreferenced and a new reference with the required size will be
 *             written in its place. On failure buf will be left untouched. *buf
 *             may be NULL, then a new buffer is allocated.
 * @param size required new buffer size.
 * @return 0 on success, a negative AVERROR on failure.
 *
 * \note the buffer is actually reallocated with av_realloc() only if it was
 * initially allocated through av_buffer_realloc(NULL) and there is only one
 * reference to it (i.e. the one passed to this function). In all other cases
 * a new buffer is allocated and the data is copied.
 */
@NoException public static native int av_buffer_realloc(@Cast("AVBufferRef**") PointerPointer buf, int size);
@NoException public static native int av_buffer_realloc(@ByPtrPtr AVBufferRef buf, int size);
// Targeting ..\avutil\AVBufferPool.java


// Targeting ..\avutil\Alloc_int.java


@NoException public static native AVBufferPool av_buffer_pool_init(int size, Alloc_int alloc);
// Targeting ..\avutil\Alloc_Pointer_int.java


// Targeting ..\avutil\Pool_free_Pointer.java


@NoException public static native AVBufferPool av_buffer_pool_init2(int size, Pointer opaque,
                                   Alloc_Pointer_int alloc,
                                   Pool_free_Pointer pool_free);

/**
 * Mark the pool as being available for freeing. It will actually be freed only
 * once all the allocated buffers associated with the pool are released. Thus it
 * is safe to call this function while some of the allocated buffers are still
 * in use.
 *
 * @param pool pointer to the pool to be freed. It will be set to NULL.
 */
@NoException public static native void av_buffer_pool_uninit(@Cast("AVBufferPool**") PointerPointer pool);
@NoException public static native void av_buffer_pool_uninit(@ByPtrPtr AVBufferPool pool);

/**
 * Allocate a new AVBuffer, reusing an old buffer from the pool when available.
 * This function may be called simultaneously from multiple threads.
 *
 * @return a reference to the new buffer on success, NULL on error.
 */
@NoException public static native AVBufferRef av_buffer_pool_get(AVBufferPool pool);

/**
 * Query the original opaque parameter of an allocated buffer in the pool.
 *
 * @param ref a buffer reference to a buffer returned by av_buffer_pool_get.
 * @return the opaque parameter set by the buffer allocator function of the
 *         buffer pool.
 *
 * \note the opaque parameter of ref is used by the buffer pool implementation,
 * therefore you have to use this function to access the original opaque
 * parameter of an allocated buffer.
 */
@NoException public static native Pointer av_buffer_pool_buffer_get_opaque(AVBufferRef ref);

/**
 * \}
 */

// #endif /* AVUTIL_BUFFER_H */


// Parsed from <libavutil/pixfmt.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_PIXFMT_H
// #define AVUTIL_PIXFMT_H

/**
 * \file
 * pixel format definitions
 */

// #include "libavutil/avconfig.h"
// #include "version.h"

public static final int AVPALETTE_SIZE = 1024;
public static final int AVPALETTE_COUNT = 256;

/**
 * Pixel format.
 *
 * \note
 * AV_PIX_FMT_RGB32 is handled in an endian-specific manner. An RGBA
 * color is put together as:
 *  (A << 24) | (R << 16) | (G << 8) | B
 * This is stored as BGRA on little-endian CPU architectures and ARGB on
 * big-endian CPUs.
 *
 * \note
 * If the resolution is not a multiple of the chroma subsampling factor
 * then the chroma plane resolution must be rounded up.
 *
 * \par
 * When the pixel format is palettized RGB32 (AV_PIX_FMT_PAL8), the palettized
 * image data is stored in AVFrame.data[0]. The palette is transported in
 * AVFrame.data[1], is 1024 bytes long (256 4-byte entries) and is
 * formatted the same as in AV_PIX_FMT_RGB32 described above (i.e., it is
 * also endian-specific). Note also that the individual RGB32 palette
 * components stored in AVFrame.data[1] should be in the range 0..255.
 * This is important as many custom PAL8 video codecs that were designed
 * to run on the IBM VGA graphics adapter use 6-bit palette components.
 *
 * \par
 * For all the 8 bits per pixel formats, an RGB32 palette is in data[1] like
 * for pal8. This palette is filled in automatically by the function
 * allocating the picture.
 */
/** enum AVPixelFormat */
public static final int
    AV_PIX_FMT_NONE = -1,
    /** planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples) */
    AV_PIX_FMT_YUV420P = 0,
    /** packed YUV 4:2:2, 16bpp, Y0 Cb Y1 Cr */
    AV_PIX_FMT_YUYV422 = 1,
    /** packed RGB 8:8:8, 24bpp, RGBRGB... */
    AV_PIX_FMT_RGB24 = 2,
    /** packed RGB 8:8:8, 24bpp, BGRBGR... */
    AV_PIX_FMT_BGR24 = 3,
    /** planar YUV 4:2:2, 16bpp, (1 Cr & Cb sample per 2x1 Y samples) */
    AV_PIX_FMT_YUV422P = 4,
    /** planar YUV 4:4:4, 24bpp, (1 Cr & Cb sample per 1x1 Y samples) */
    AV_PIX_FMT_YUV444P = 5,
    /** planar YUV 4:1:0,  9bpp, (1 Cr & Cb sample per 4x4 Y samples) */
    AV_PIX_FMT_YUV410P = 6,
    /** planar YUV 4:1:1, 12bpp, (1 Cr & Cb sample per 4x1 Y samples) */
    AV_PIX_FMT_YUV411P = 7,
    /**        Y        ,  8bpp */
    AV_PIX_FMT_GRAY8 = 8,
    /**        Y        ,  1bpp, 0 is white, 1 is black, in each byte pixels are ordered from the msb to the lsb */
    AV_PIX_FMT_MONOWHITE = 9,
    /**        Y        ,  1bpp, 0 is black, 1 is white, in each byte pixels are ordered from the msb to the lsb */
    AV_PIX_FMT_MONOBLACK = 10,
    /** 8 bits with AV_PIX_FMT_RGB32 palette */
    AV_PIX_FMT_PAL8 = 11,
    /** planar YUV 4:2:0, 12bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV420P and setting color_range */
    AV_PIX_FMT_YUVJ420P = 12,
    /** planar YUV 4:2:2, 16bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV422P and setting color_range */
    AV_PIX_FMT_YUVJ422P = 13,
    /** planar YUV 4:4:4, 24bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV444P and setting color_range */
    AV_PIX_FMT_YUVJ444P = 14,
    /** packed YUV 4:2:2, 16bpp, Cb Y0 Cr Y1 */
    AV_PIX_FMT_UYVY422 = 15,
    /** packed YUV 4:1:1, 12bpp, Cb Y0 Y1 Cr Y2 Y3 */
    AV_PIX_FMT_UYYVYY411 = 16,
    /** packed RGB 3:3:2,  8bpp, (msb)2B 3G 3R(lsb) */
    AV_PIX_FMT_BGR8 = 17,
    /** packed RGB 1:2:1 bitstream,  4bpp, (msb)1B 2G 1R(lsb), a byte contains two pixels, the first pixel in the byte is the one composed by the 4 msb bits */
    AV_PIX_FMT_BGR4 = 18,
    /** packed RGB 1:2:1,  8bpp, (msb)1B 2G 1R(lsb) */
    AV_PIX_FMT_BGR4_BYTE = 19,
    /** packed RGB 3:3:2,  8bpp, (msb)2R 3G 3B(lsb) */
    AV_PIX_FMT_RGB8 = 20,
    /** packed RGB 1:2:1 bitstream,  4bpp, (msb)1R 2G 1B(lsb), a byte contains two pixels, the first pixel in the byte is the one composed by the 4 msb bits */
    AV_PIX_FMT_RGB4 = 21,
    /** packed RGB 1:2:1,  8bpp, (msb)1R 2G 1B(lsb) */
    AV_PIX_FMT_RGB4_BYTE = 22,
    /** planar YUV 4:2:0, 12bpp, 1 plane for Y and 1 plane for the UV components, which are interleaved (first byte U and the following byte V) */
    AV_PIX_FMT_NV12 = 23,
    /** as above, but U and V bytes are swapped */
    AV_PIX_FMT_NV21 = 24,

    /** packed ARGB 8:8:8:8, 32bpp, ARGBARGB... */
    AV_PIX_FMT_ARGB = 25,
    /** packed RGBA 8:8:8:8, 32bpp, RGBARGBA... */
    AV_PIX_FMT_RGBA = 26,
    /** packed ABGR 8:8:8:8, 32bpp, ABGRABGR... */
    AV_PIX_FMT_ABGR = 27,
    /** packed BGRA 8:8:8:8, 32bpp, BGRABGRA... */
    AV_PIX_FMT_BGRA = 28,

    /**        Y        , 16bpp, big-endian */
    AV_PIX_FMT_GRAY16BE = 29,
    /**        Y        , 16bpp, little-endian */
    AV_PIX_FMT_GRAY16LE = 30,
    /** planar YUV 4:4:0 (1 Cr & Cb sample per 1x2 Y samples) */
    AV_PIX_FMT_YUV440P = 31,
    /** planar YUV 4:4:0 full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV440P and setting color_range */
    AV_PIX_FMT_YUVJ440P = 32,
    /** planar YUV 4:2:0, 20bpp, (1 Cr & Cb sample per 2x2 Y & A samples) */
    AV_PIX_FMT_YUVA420P = 33,
    /** packed RGB 16:16:16, 48bpp, 16R, 16G, 16B, the 2-byte value for each R/G/B component is stored as big-endian */
    AV_PIX_FMT_RGB48BE = 34,
    /** packed RGB 16:16:16, 48bpp, 16R, 16G, 16B, the 2-byte value for each R/G/B component is stored as little-endian */
    AV_PIX_FMT_RGB48LE = 35,

    /** packed RGB 5:6:5, 16bpp, (msb)   5R 6G 5B(lsb), big-endian */
    AV_PIX_FMT_RGB565BE = 36,
    /** packed RGB 5:6:5, 16bpp, (msb)   5R 6G 5B(lsb), little-endian */
    AV_PIX_FMT_RGB565LE = 37,
    /** packed RGB 5:5:5, 16bpp, (msb)1X 5R 5G 5B(lsb), big-endian   , X=unused/undefined */
    AV_PIX_FMT_RGB555BE = 38,
    /** packed RGB 5:5:5, 16bpp, (msb)1X 5R 5G 5B(lsb), little-endian, X=unused/undefined */
    AV_PIX_FMT_RGB555LE = 39,

    /** packed BGR 5:6:5, 16bpp, (msb)   5B 6G 5R(lsb), big-endian */
    AV_PIX_FMT_BGR565BE = 40,
    /** packed BGR 5:6:5, 16bpp, (msb)   5B 6G 5R(lsb), little-endian */
    AV_PIX_FMT_BGR565LE = 41,
    /** packed BGR 5:5:5, 16bpp, (msb)1X 5B 5G 5R(lsb), big-endian   , X=unused/undefined */
    AV_PIX_FMT_BGR555BE = 42,
    /** packed BGR 5:5:5, 16bpp, (msb)1X 5B 5G 5R(lsb), little-endian, X=unused/undefined */
    AV_PIX_FMT_BGR555LE = 43,

// #if FF_API_VAAPI
    /** \name Deprecated pixel formats */
    /**\{*/
    /** HW acceleration through VA API at motion compensation entry-point, Picture.data[3] contains a vaapi_render_state struct which contains macroblocks as well as various fields extracted from headers */
    AV_PIX_FMT_VAAPI_MOCO = 44,
    /** HW acceleration through VA API at IDCT entry-point, Picture.data[3] contains a vaapi_render_state struct which contains fields extracted from headers */
    AV_PIX_FMT_VAAPI_IDCT = 45,
    /** HW decoding through VA API, Picture.data[3] contains a VASurfaceID */
    AV_PIX_FMT_VAAPI_VLD = 46,
    /**\}*/
    AV_PIX_FMT_VAAPI = AV_PIX_FMT_VAAPI_VLD,
// #else
// #endif

    /** planar YUV 4:2:0, 24bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian */
    AV_PIX_FMT_YUV420P16LE = AV_PIX_FMT_VAAPI_VLD + 1,
    /** planar YUV 4:2:0, 24bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian */
    AV_PIX_FMT_YUV420P16BE = AV_PIX_FMT_VAAPI_VLD + 2,
    /** planar YUV 4:2:2, 32bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian */
    AV_PIX_FMT_YUV422P16LE = AV_PIX_FMT_VAAPI_VLD + 3,
    /** planar YUV 4:2:2, 32bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian */
    AV_PIX_FMT_YUV422P16BE = AV_PIX_FMT_VAAPI_VLD + 4,
    /** planar YUV 4:4:4, 48bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian */
    AV_PIX_FMT_YUV444P16LE = AV_PIX_FMT_VAAPI_VLD + 5,
    /** planar YUV 4:4:4, 48bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian */
    AV_PIX_FMT_YUV444P16BE = AV_PIX_FMT_VAAPI_VLD + 6,
    /** HW decoding through DXVA2, Picture.data[3] contains a LPDIRECT3DSURFACE9 pointer */
    AV_PIX_FMT_DXVA2_VLD = AV_PIX_FMT_VAAPI_VLD + 7,

    /** packed RGB 4:4:4, 16bpp, (msb)4X 4R 4G 4B(lsb), little-endian, X=unused/undefined */
    AV_PIX_FMT_RGB444LE = AV_PIX_FMT_VAAPI_VLD + 8,
    /** packed RGB 4:4:4, 16bpp, (msb)4X 4R 4G 4B(lsb), big-endian,    X=unused/undefined */
    AV_PIX_FMT_RGB444BE = AV_PIX_FMT_VAAPI_VLD + 9,
    /** packed BGR 4:4:4, 16bpp, (msb)4X 4B 4G 4R(lsb), little-endian, X=unused/undefined */
    AV_PIX_FMT_BGR444LE = AV_PIX_FMT_VAAPI_VLD + 10,
    /** packed BGR 4:4:4, 16bpp, (msb)4X 4B 4G 4R(lsb), big-endian,    X=unused/undefined */
    AV_PIX_FMT_BGR444BE = AV_PIX_FMT_VAAPI_VLD + 11,
    /** 8 bits gray, 8 bits alpha */
    AV_PIX_FMT_YA8 = AV_PIX_FMT_VAAPI_VLD + 12,

    /** alias for AV_PIX_FMT_YA8 */
    AV_PIX_FMT_Y400A = AV_PIX_FMT_YA8,
    /** alias for AV_PIX_FMT_YA8 */
    AV_PIX_FMT_GRAY8A = AV_PIX_FMT_YA8,

    /** packed RGB 16:16:16, 48bpp, 16B, 16G, 16R, the 2-byte value for each R/G/B component is stored as big-endian */
    AV_PIX_FMT_BGR48BE = AV_PIX_FMT_YA8 + 1,
    /** packed RGB 16:16:16, 48bpp, 16B, 16G, 16R, the 2-byte value for each R/G/B component is stored as little-endian */
    AV_PIX_FMT_BGR48LE = AV_PIX_FMT_YA8 + 2,

    /**
     * The following 12 formats have the disadvantage of needing 1 format for each bit depth.
     * Notice that each 9/10 bits sample is stored in 16 bits with extra padding.
     * If you want to support multiple bit depths, then using AV_PIX_FMT_YUV420P16* with the bpp stored separately is better.
     */
    /** planar YUV 4:2:0, 13.5bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian */
    AV_PIX_FMT_YUV420P9BE = AV_PIX_FMT_YA8 + 3,
    /** planar YUV 4:2:0, 13.5bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian */
    AV_PIX_FMT_YUV420P9LE = AV_PIX_FMT_YA8 + 4,
    /** planar YUV 4:2:0, 15bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian */
    AV_PIX_FMT_YUV420P10BE = AV_PIX_FMT_YA8 + 5,
    /** planar YUV 4:2:0, 15bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian */
    AV_PIX_FMT_YUV420P10LE = AV_PIX_FMT_YA8 + 6,
    /** planar YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian */
    AV_PIX_FMT_YUV422P10BE = AV_PIX_FMT_YA8 + 7,
    /** planar YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian */
    AV_PIX_FMT_YUV422P10LE = AV_PIX_FMT_YA8 + 8,
    /** planar YUV 4:4:4, 27bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian */
    AV_PIX_FMT_YUV444P9BE = AV_PIX_FMT_YA8 + 9,
    /** planar YUV 4:4:4, 27bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian */
    AV_PIX_FMT_YUV444P9LE = AV_PIX_FMT_YA8 + 10,
    /** planar YUV 4:4:4, 30bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian */
    AV_PIX_FMT_YUV444P10BE = AV_PIX_FMT_YA8 + 11,
    /** planar YUV 4:4:4, 30bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian */
    AV_PIX_FMT_YUV444P10LE = AV_PIX_FMT_YA8 + 12,
    /** planar YUV 4:2:2, 18bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian */
    AV_PIX_FMT_YUV422P9BE = AV_PIX_FMT_YA8 + 13,
    /** planar YUV 4:2:2, 18bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian */
    AV_PIX_FMT_YUV422P9LE = AV_PIX_FMT_YA8 + 14,
    /** planar GBR 4:4:4 24bpp */
    AV_PIX_FMT_GBRP = AV_PIX_FMT_YA8 + 15,
    AV_PIX_FMT_GBR24P = AV_PIX_FMT_GBRP, // alias for #AV_PIX_FMT_GBRP
    /** planar GBR 4:4:4 27bpp, big-endian */
    AV_PIX_FMT_GBRP9BE = AV_PIX_FMT_GBRP + 1,
    /** planar GBR 4:4:4 27bpp, little-endian */
    AV_PIX_FMT_GBRP9LE = AV_PIX_FMT_GBRP + 2,
    /** planar GBR 4:4:4 30bpp, big-endian */
    AV_PIX_FMT_GBRP10BE = AV_PIX_FMT_GBRP + 3,
    /** planar GBR 4:4:4 30bpp, little-endian */
    AV_PIX_FMT_GBRP10LE = AV_PIX_FMT_GBRP + 4,
    /** planar GBR 4:4:4 48bpp, big-endian */
    AV_PIX_FMT_GBRP16BE = AV_PIX_FMT_GBRP + 5,
    /** planar GBR 4:4:4 48bpp, little-endian */
    AV_PIX_FMT_GBRP16LE = AV_PIX_FMT_GBRP + 6,
    /** planar YUV 4:2:2 24bpp, (1 Cr & Cb sample per 2x1 Y & A samples) */
    AV_PIX_FMT_YUVA422P = AV_PIX_FMT_GBRP + 7,
    /** planar YUV 4:4:4 32bpp, (1 Cr & Cb sample per 1x1 Y & A samples) */
    AV_PIX_FMT_YUVA444P = AV_PIX_FMT_GBRP + 8,
    /** planar YUV 4:2:0 22.5bpp, (1 Cr & Cb sample per 2x2 Y & A samples), big-endian */
    AV_PIX_FMT_YUVA420P9BE = AV_PIX_FMT_GBRP + 9,
    /** planar YUV 4:2:0 22.5bpp, (1 Cr & Cb sample per 2x2 Y & A samples), little-endian */
    AV_PIX_FMT_YUVA420P9LE = AV_PIX_FMT_GBRP + 10,
    /** planar YUV 4:2:2 27bpp, (1 Cr & Cb sample per 2x1 Y & A samples), big-endian */
    AV_PIX_FMT_YUVA422P9BE = AV_PIX_FMT_GBRP + 11,
    /** planar YUV 4:2:2 27bpp, (1 Cr & Cb sample per 2x1 Y & A samples), little-endian */
    AV_PIX_FMT_YUVA422P9LE = AV_PIX_FMT_GBRP + 12,
    /** planar YUV 4:4:4 36bpp, (1 Cr & Cb sample per 1x1 Y & A samples), big-endian */
    AV_PIX_FMT_YUVA444P9BE = AV_PIX_FMT_GBRP + 13,
    /** planar YUV 4:4:4 36bpp, (1 Cr & Cb sample per 1x1 Y & A samples), little-endian */
    AV_PIX_FMT_YUVA444P9LE = AV_PIX_FMT_GBRP + 14,
    /** planar YUV 4:2:0 25bpp, (1 Cr & Cb sample per 2x2 Y & A samples, big-endian) */
    AV_PIX_FMT_YUVA420P10BE = AV_PIX_FMT_GBRP + 15,
    /** planar YUV 4:2:0 25bpp, (1 Cr & Cb sample per 2x2 Y & A samples, little-endian) */
    AV_PIX_FMT_YUVA420P10LE = AV_PIX_FMT_GBRP + 16,
    /** planar YUV 4:2:2 30bpp, (1 Cr & Cb sample per 2x1 Y & A samples, big-endian) */
    AV_PIX_FMT_YUVA422P10BE = AV_PIX_FMT_GBRP + 17,
    /** planar YUV 4:2:2 30bpp, (1 Cr & Cb sample per 2x1 Y & A samples, little-endian) */
    AV_PIX_FMT_YUVA422P10LE = AV_PIX_FMT_GBRP + 18,
    /** planar YUV 4:4:4 40bpp, (1 Cr & Cb sample per 1x1 Y & A samples, big-endian) */
    AV_PIX_FMT_YUVA444P10BE = AV_PIX_FMT_GBRP + 19,
    /** planar YUV 4:4:4 40bpp, (1 Cr & Cb sample per 1x1 Y & A samples, little-endian) */
    AV_PIX_FMT_YUVA444P10LE = AV_PIX_FMT_GBRP + 20,
    /** planar YUV 4:2:0 40bpp, (1 Cr & Cb sample per 2x2 Y & A samples, big-endian) */
    AV_PIX_FMT_YUVA420P16BE = AV_PIX_FMT_GBRP + 21,
    /** planar YUV 4:2:0 40bpp, (1 Cr & Cb sample per 2x2 Y & A samples, little-endian) */
    AV_PIX_FMT_YUVA420P16LE = AV_PIX_FMT_GBRP + 22,
    /** planar YUV 4:2:2 48bpp, (1 Cr & Cb sample per 2x1 Y & A samples, big-endian) */
    AV_PIX_FMT_YUVA422P16BE = AV_PIX_FMT_GBRP + 23,
    /** planar YUV 4:2:2 48bpp, (1 Cr & Cb sample per 2x1 Y & A samples, little-endian) */
    AV_PIX_FMT_YUVA422P16LE = AV_PIX_FMT_GBRP + 24,
    /** planar YUV 4:4:4 64bpp, (1 Cr & Cb sample per 1x1 Y & A samples, big-endian) */
    AV_PIX_FMT_YUVA444P16BE = AV_PIX_FMT_GBRP + 25,
    /** planar YUV 4:4:4 64bpp, (1 Cr & Cb sample per 1x1 Y & A samples, little-endian) */
    AV_PIX_FMT_YUVA444P16LE = AV_PIX_FMT_GBRP + 26,

    /** HW acceleration through VDPAU, Picture.data[3] contains a VdpVideoSurface */
    AV_PIX_FMT_VDPAU = AV_PIX_FMT_GBRP + 27,

    /** packed XYZ 4:4:4, 36 bpp, (msb) 12X, 12Y, 12Z (lsb), the 2-byte value for each X/Y/Z is stored as little-endian, the 4 lower bits are set to 0 */
    AV_PIX_FMT_XYZ12LE = AV_PIX_FMT_GBRP + 28,
    /** packed XYZ 4:4:4, 36 bpp, (msb) 12X, 12Y, 12Z (lsb), the 2-byte value for each X/Y/Z is stored as big-endian, the 4 lower bits are set to 0 */
    AV_PIX_FMT_XYZ12BE = AV_PIX_FMT_GBRP + 29,
    /** interleaved chroma YUV 4:2:2, 16bpp, (1 Cr & Cb sample per 2x1 Y samples) */
    AV_PIX_FMT_NV16 = AV_PIX_FMT_GBRP + 30,
    /** interleaved chroma YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian */
    AV_PIX_FMT_NV20LE = AV_PIX_FMT_GBRP + 31,
    /** interleaved chroma YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian */
    AV_PIX_FMT_NV20BE = AV_PIX_FMT_GBRP + 32,

    /** packed RGBA 16:16:16:16, 64bpp, 16R, 16G, 16B, 16A, the 2-byte value for each R/G/B/A component is stored as big-endian */
    AV_PIX_FMT_RGBA64BE = AV_PIX_FMT_GBRP + 33,
    /** packed RGBA 16:16:16:16, 64bpp, 16R, 16G, 16B, 16A, the 2-byte value for each R/G/B/A component is stored as little-endian */
    AV_PIX_FMT_RGBA64LE = AV_PIX_FMT_GBRP + 34,
    /** packed RGBA 16:16:16:16, 64bpp, 16B, 16G, 16R, 16A, the 2-byte value for each R/G/B/A component is stored as big-endian */
    AV_PIX_FMT_BGRA64BE = AV_PIX_FMT_GBRP + 35,
    /** packed RGBA 16:16:16:16, 64bpp, 16B, 16G, 16R, 16A, the 2-byte value for each R/G/B/A component is stored as little-endian */
    AV_PIX_FMT_BGRA64LE = AV_PIX_FMT_GBRP + 36,

    /** packed YUV 4:2:2, 16bpp, Y0 Cr Y1 Cb */
    AV_PIX_FMT_YVYU422 = AV_PIX_FMT_GBRP + 37,

    /** 16 bits gray, 16 bits alpha (big-endian) */
    AV_PIX_FMT_YA16BE = AV_PIX_FMT_GBRP + 38,
    /** 16 bits gray, 16 bits alpha (little-endian) */
    AV_PIX_FMT_YA16LE = AV_PIX_FMT_GBRP + 39,

    /** planar GBRA 4:4:4:4 32bpp */
    AV_PIX_FMT_GBRAP = AV_PIX_FMT_GBRP + 40,
    /** planar GBRA 4:4:4:4 64bpp, big-endian */
    AV_PIX_FMT_GBRAP16BE = AV_PIX_FMT_GBRP + 41,
    /** planar GBRA 4:4:4:4 64bpp, little-endian */
    AV_PIX_FMT_GBRAP16LE = AV_PIX_FMT_GBRP + 42,
    /**
     *  HW acceleration through QSV, data[3] contains a pointer to the
     *  mfxFrameSurface1 structure.
     */
    AV_PIX_FMT_QSV = AV_PIX_FMT_GBRP + 43,
    /**
     * HW acceleration though MMAL, data[3] contains a pointer to the
     * MMAL_BUFFER_HEADER_T structure.
     */
    AV_PIX_FMT_MMAL = AV_PIX_FMT_GBRP + 44,

    /** HW decoding through Direct3D11 via old API, Picture.data[3] contains a ID3D11VideoDecoderOutputView pointer */
    AV_PIX_FMT_D3D11VA_VLD = AV_PIX_FMT_GBRP + 45,

    /**
     * HW acceleration through CUDA. data[i] contain CUdeviceptr pointers
     * exactly as for system memory frames.
     */
    AV_PIX_FMT_CUDA = AV_PIX_FMT_GBRP + 46,

    /** packed RGB 8:8:8, 32bpp, XRGBXRGB...   X=unused/undefined */
    AV_PIX_FMT_0RGB = AV_PIX_FMT_GBRP + 47,
    /** packed RGB 8:8:8, 32bpp, RGBXRGBX...   X=unused/undefined */
    AV_PIX_FMT_RGB0 = AV_PIX_FMT_GBRP + 48,
    /** packed BGR 8:8:8, 32bpp, XBGRXBGR...   X=unused/undefined */
    AV_PIX_FMT_0BGR = AV_PIX_FMT_GBRP + 49,
    /** packed BGR 8:8:8, 32bpp, BGRXBGRX...   X=unused/undefined */
    AV_PIX_FMT_BGR0 = AV_PIX_FMT_GBRP + 50,

    /** planar YUV 4:2:0,18bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian */
    AV_PIX_FMT_YUV420P12BE = AV_PIX_FMT_GBRP + 51,
    /** planar YUV 4:2:0,18bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian */
    AV_PIX_FMT_YUV420P12LE = AV_PIX_FMT_GBRP + 52,
    /** planar YUV 4:2:0,21bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian */
    AV_PIX_FMT_YUV420P14BE = AV_PIX_FMT_GBRP + 53,
    /** planar YUV 4:2:0,21bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian */
    AV_PIX_FMT_YUV420P14LE = AV_PIX_FMT_GBRP + 54,
    /** planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian */
    AV_PIX_FMT_YUV422P12BE = AV_PIX_FMT_GBRP + 55,
    /** planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian */
    AV_PIX_FMT_YUV422P12LE = AV_PIX_FMT_GBRP + 56,
    /** planar YUV 4:2:2,28bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian */
    AV_PIX_FMT_YUV422P14BE = AV_PIX_FMT_GBRP + 57,
    /** planar YUV 4:2:2,28bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian */
    AV_PIX_FMT_YUV422P14LE = AV_PIX_FMT_GBRP + 58,
    /** planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian */
    AV_PIX_FMT_YUV444P12BE = AV_PIX_FMT_GBRP + 59,
    /** planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian */
    AV_PIX_FMT_YUV444P12LE = AV_PIX_FMT_GBRP + 60,
    /** planar YUV 4:4:4,42bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian */
    AV_PIX_FMT_YUV444P14BE = AV_PIX_FMT_GBRP + 61,
    /** planar YUV 4:4:4,42bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian */
    AV_PIX_FMT_YUV444P14LE = AV_PIX_FMT_GBRP + 62,
    /** planar GBR 4:4:4 36bpp, big-endian */
    AV_PIX_FMT_GBRP12BE = AV_PIX_FMT_GBRP + 63,
    /** planar GBR 4:4:4 36bpp, little-endian */
    AV_PIX_FMT_GBRP12LE = AV_PIX_FMT_GBRP + 64,
    /** planar GBR 4:4:4 42bpp, big-endian */
    AV_PIX_FMT_GBRP14BE = AV_PIX_FMT_GBRP + 65,
    /** planar GBR 4:4:4 42bpp, little-endian */
    AV_PIX_FMT_GBRP14LE = AV_PIX_FMT_GBRP + 66,
    /** planar YUV 4:1:1, 12bpp, (1 Cr & Cb sample per 4x1 Y samples) full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV411P and setting color_range */
    AV_PIX_FMT_YUVJ411P = AV_PIX_FMT_GBRP + 67,

    /** bayer, BGBG..(odd line), GRGR..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_BGGR8 = AV_PIX_FMT_GBRP + 68,
    /** bayer, RGRG..(odd line), GBGB..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_RGGB8 = AV_PIX_FMT_GBRP + 69,
    /** bayer, GBGB..(odd line), RGRG..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_GBRG8 = AV_PIX_FMT_GBRP + 70,
    /** bayer, GRGR..(odd line), BGBG..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_GRBG8 = AV_PIX_FMT_GBRP + 71,
    /** bayer, BGBG..(odd line), GRGR..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_BGGR16LE = AV_PIX_FMT_GBRP + 72,
    /** bayer, BGBG..(odd line), GRGR..(even line), 16-bit samples, big-endian */
    AV_PIX_FMT_BAYER_BGGR16BE = AV_PIX_FMT_GBRP + 73,
    /** bayer, RGRG..(odd line), GBGB..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_RGGB16LE = AV_PIX_FMT_GBRP + 74,
    /** bayer, RGRG..(odd line), GBGB..(even line), 16-bit samples, big-endian */
    AV_PIX_FMT_BAYER_RGGB16BE = AV_PIX_FMT_GBRP + 75,
    /** bayer, GBGB..(odd line), RGRG..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_GBRG16LE = AV_PIX_FMT_GBRP + 76,
    /** bayer, GBGB..(odd line), RGRG..(even line), 16-bit samples, big-endian */
    AV_PIX_FMT_BAYER_GBRG16BE = AV_PIX_FMT_GBRP + 77,
    /** bayer, GRGR..(odd line), BGBG..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_GRBG16LE = AV_PIX_FMT_GBRP + 78,
    /** bayer, GRGR..(odd line), BGBG..(even line), 16-bit samples, big-endian */
    AV_PIX_FMT_BAYER_GRBG16BE = AV_PIX_FMT_GBRP + 79,

    /** XVideo Motion Acceleration via common packet passing */
    AV_PIX_FMT_XVMC = AV_PIX_FMT_GBRP + 80,

    /** planar YUV 4:4:0,20bpp, (1 Cr & Cb sample per 1x2 Y samples), little-endian */
    AV_PIX_FMT_YUV440P10LE = AV_PIX_FMT_GBRP + 81,
    /** planar YUV 4:4:0,20bpp, (1 Cr & Cb sample per 1x2 Y samples), big-endian */
    AV_PIX_FMT_YUV440P10BE = AV_PIX_FMT_GBRP + 82,
    /** planar YUV 4:4:0,24bpp, (1 Cr & Cb sample per 1x2 Y samples), little-endian */
    AV_PIX_FMT_YUV440P12LE = AV_PIX_FMT_GBRP + 83,
    /** planar YUV 4:4:0,24bpp, (1 Cr & Cb sample per 1x2 Y samples), big-endian */
    AV_PIX_FMT_YUV440P12BE = AV_PIX_FMT_GBRP + 84,
    /** packed AYUV 4:4:4,64bpp (1 Cr & Cb sample per 1x1 Y & A samples), little-endian */
    AV_PIX_FMT_AYUV64LE = AV_PIX_FMT_GBRP + 85,
    /** packed AYUV 4:4:4,64bpp (1 Cr & Cb sample per 1x1 Y & A samples), big-endian */
    AV_PIX_FMT_AYUV64BE = AV_PIX_FMT_GBRP + 86,

    /** hardware decoding through Videotoolbox */
    AV_PIX_FMT_VIDEOTOOLBOX = AV_PIX_FMT_GBRP + 87,

    /** like NV12, with 10bpp per component, data in the high bits, zeros in the low bits, little-endian */
    AV_PIX_FMT_P010LE = AV_PIX_FMT_GBRP + 88,
    /** like NV12, with 10bpp per component, data in the high bits, zeros in the low bits, big-endian */
    AV_PIX_FMT_P010BE = AV_PIX_FMT_GBRP + 89,

    /** planar GBR 4:4:4:4 48bpp, big-endian */
    AV_PIX_FMT_GBRAP12BE = AV_PIX_FMT_GBRP + 90,
    /** planar GBR 4:4:4:4 48bpp, little-endian */
    AV_PIX_FMT_GBRAP12LE = AV_PIX_FMT_GBRP + 91,

    /** planar GBR 4:4:4:4 40bpp, big-endian */
    AV_PIX_FMT_GBRAP10BE = AV_PIX_FMT_GBRP + 92,
    /** planar GBR 4:4:4:4 40bpp, little-endian */
    AV_PIX_FMT_GBRAP10LE = AV_PIX_FMT_GBRP + 93,

    /** hardware decoding through MediaCodec */
    AV_PIX_FMT_MEDIACODEC = AV_PIX_FMT_GBRP + 94,

    /**        Y        , 12bpp, big-endian */
    AV_PIX_FMT_GRAY12BE = AV_PIX_FMT_GBRP + 95,
    /**        Y        , 12bpp, little-endian */
    AV_PIX_FMT_GRAY12LE = AV_PIX_FMT_GBRP + 96,
    /**        Y        , 10bpp, big-endian */
    AV_PIX_FMT_GRAY10BE = AV_PIX_FMT_GBRP + 97,
    /**        Y        , 10bpp, little-endian */
    AV_PIX_FMT_GRAY10LE = AV_PIX_FMT_GBRP + 98,

    /** like NV12, with 16bpp per component, little-endian */
    AV_PIX_FMT_P016LE = AV_PIX_FMT_GBRP + 99,
    /** like NV12, with 16bpp per component, big-endian */
    AV_PIX_FMT_P016BE = AV_PIX_FMT_GBRP + 100,

    /**
     * Hardware surfaces for Direct3D11.
     *
     * This is preferred over the legacy AV_PIX_FMT_D3D11VA_VLD. The new D3D11
     * hwaccel API and filtering support AV_PIX_FMT_D3D11 only.
     *
     * data[0] contains a ID3D11Texture2D pointer, and data[1] contains the
     * texture array index of the frame as intptr_t if the ID3D11Texture2D is
     * an array texture (or always 0 if it's a normal texture).
     */
    AV_PIX_FMT_D3D11 = AV_PIX_FMT_GBRP + 101,

    /**        Y        , 9bpp, big-endian */
    AV_PIX_FMT_GRAY9BE = AV_PIX_FMT_GBRP + 102,
    /**        Y        , 9bpp, little-endian */
    AV_PIX_FMT_GRAY9LE = AV_PIX_FMT_GBRP + 103,

    /** IEEE-754 single precision planar GBR 4:4:4,     96bpp, big-endian */
    AV_PIX_FMT_GBRPF32BE = AV_PIX_FMT_GBRP + 104,
    /** IEEE-754 single precision planar GBR 4:4:4,     96bpp, little-endian */
    AV_PIX_FMT_GBRPF32LE = AV_PIX_FMT_GBRP + 105,
    /** IEEE-754 single precision planar GBRA 4:4:4:4, 128bpp, big-endian */
    AV_PIX_FMT_GBRAPF32BE = AV_PIX_FMT_GBRP + 106,
    /** IEEE-754 single precision planar GBRA 4:4:4:4, 128bpp, little-endian */
    AV_PIX_FMT_GBRAPF32LE = AV_PIX_FMT_GBRP + 107,

    /**
     * DRM-managed buffers exposed through PRIME buffer sharing.
     *
     * data[0] points to an AVDRMFrameDescriptor.
     */
    AV_PIX_FMT_DRM_PRIME = AV_PIX_FMT_GBRP + 108,
    /**
     * Hardware surfaces for OpenCL.
     *
     * data[i] contain 2D image objects (typed in C as cl_mem, used
     * in OpenCL as image2d_t) for each plane of the surface.
     */
    AV_PIX_FMT_OPENCL = AV_PIX_FMT_GBRP + 109,

    /**        Y        , 14bpp, big-endian */
    AV_PIX_FMT_GRAY14BE = AV_PIX_FMT_GBRP + 110,
    /**        Y        , 14bpp, little-endian */
    AV_PIX_FMT_GRAY14LE = AV_PIX_FMT_GBRP + 111,

    /** IEEE-754 single precision Y, 32bpp, big-endian */
    AV_PIX_FMT_GRAYF32BE = AV_PIX_FMT_GBRP + 112,
    /** IEEE-754 single precision Y, 32bpp, little-endian */
    AV_PIX_FMT_GRAYF32LE = AV_PIX_FMT_GBRP + 113,

    /** planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), 12b alpha, big-endian */
    AV_PIX_FMT_YUVA422P12BE = AV_PIX_FMT_GBRP + 114,
    /** planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), 12b alpha, little-endian */
    AV_PIX_FMT_YUVA422P12LE = AV_PIX_FMT_GBRP + 115,
    /** planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), 12b alpha, big-endian */
    AV_PIX_FMT_YUVA444P12BE = AV_PIX_FMT_GBRP + 116,
    /** planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), 12b alpha, little-endian */
    AV_PIX_FMT_YUVA444P12LE = AV_PIX_FMT_GBRP + 117,

    /** planar YUV 4:4:4, 24bpp, 1 plane for Y and 1 plane for the UV components, which are interleaved (first byte U and the following byte V) */
    AV_PIX_FMT_NV24 = AV_PIX_FMT_GBRP + 118,
    /** as above, but U and V bytes are swapped */
    AV_PIX_FMT_NV42 = AV_PIX_FMT_GBRP + 119,

    /**
     * Vulkan hardware images.
     *
     * data[0] points to an AVVkFrame
     */
    AV_PIX_FMT_VULKAN = AV_PIX_FMT_GBRP + 120,

    /** packed YUV 4:2:2 like YUYV422, 20bpp, data in the high bits, big-endian */
    AV_PIX_FMT_Y210BE = AV_PIX_FMT_GBRP + 121,
    /** packed YUV 4:2:2 like YUYV422, 20bpp, data in the high bits, little-endian */
    AV_PIX_FMT_Y210LE = AV_PIX_FMT_GBRP + 122,

    /** number of pixel formats, DO NOT USE THIS if you want to link with shared libav* because the number of formats might differ between versions */
    AV_PIX_FMT_NB = AV_PIX_FMT_GBRP + 123;

// #if AV_HAVE_BIGENDIAN
// #   define AV_PIX_FMT_NE(be, le) AV_PIX_FMT_##be
// #else
// #   define AV_PIX_FMT_NE(be, le) AV_PIX_FMT_##le
// #endif

public static native @MemberGetter int AV_PIX_FMT_RGB32();
public static final int AV_PIX_FMT_RGB32 = AV_PIX_FMT_RGB32();
public static native @MemberGetter int AV_PIX_FMT_RGB32_1();
public static final int AV_PIX_FMT_RGB32_1 = AV_PIX_FMT_RGB32_1();
public static native @MemberGetter int AV_PIX_FMT_BGR32();
public static final int AV_PIX_FMT_BGR32 = AV_PIX_FMT_BGR32();
public static native @MemberGetter int AV_PIX_FMT_BGR32_1();
public static final int AV_PIX_FMT_BGR32_1 = AV_PIX_FMT_BGR32_1();
public static native @MemberGetter int AV_PIX_FMT_0RGB32();
public static final int AV_PIX_FMT_0RGB32 = AV_PIX_FMT_0RGB32();
public static native @MemberGetter int AV_PIX_FMT_0BGR32();
public static final int AV_PIX_FMT_0BGR32 = AV_PIX_FMT_0BGR32();

public static native @MemberGetter int AV_PIX_FMT_GRAY9();
public static final int AV_PIX_FMT_GRAY9 = AV_PIX_FMT_GRAY9();
public static native @MemberGetter int AV_PIX_FMT_GRAY10();
public static final int AV_PIX_FMT_GRAY10 = AV_PIX_FMT_GRAY10();
public static native @MemberGetter int AV_PIX_FMT_GRAY12();
public static final int AV_PIX_FMT_GRAY12 = AV_PIX_FMT_GRAY12();
public static native @MemberGetter int AV_PIX_FMT_GRAY14();
public static final int AV_PIX_FMT_GRAY14 = AV_PIX_FMT_GRAY14();
public static native @MemberGetter int AV_PIX_FMT_GRAY16();
public static final int AV_PIX_FMT_GRAY16 = AV_PIX_FMT_GRAY16();
public static native @MemberGetter int AV_PIX_FMT_YA16();
public static final int AV_PIX_FMT_YA16 = AV_PIX_FMT_YA16();
public static native @MemberGetter int AV_PIX_FMT_RGB48();
public static final int AV_PIX_FMT_RGB48 = AV_PIX_FMT_RGB48();
public static native @MemberGetter int AV_PIX_FMT_RGB565();
public static final int AV_PIX_FMT_RGB565 = AV_PIX_FMT_RGB565();
public static native @MemberGetter int AV_PIX_FMT_RGB555();
public static final int AV_PIX_FMT_RGB555 = AV_PIX_FMT_RGB555();
public static native @MemberGetter int AV_PIX_FMT_RGB444();
public static final int AV_PIX_FMT_RGB444 = AV_PIX_FMT_RGB444();
public static native @MemberGetter int AV_PIX_FMT_RGBA64();
public static final int AV_PIX_FMT_RGBA64 = AV_PIX_FMT_RGBA64();
public static native @MemberGetter int AV_PIX_FMT_BGR48();
public static final int AV_PIX_FMT_BGR48 = AV_PIX_FMT_BGR48();
public static native @MemberGetter int AV_PIX_FMT_BGR565();
public static final int AV_PIX_FMT_BGR565 = AV_PIX_FMT_BGR565();
public static native @MemberGetter int AV_PIX_FMT_BGR555();
public static final int AV_PIX_FMT_BGR555 = AV_PIX_FMT_BGR555();
public static native @MemberGetter int AV_PIX_FMT_BGR444();
public static final int AV_PIX_FMT_BGR444 = AV_PIX_FMT_BGR444();
public static native @MemberGetter int AV_PIX_FMT_BGRA64();
public static final int AV_PIX_FMT_BGRA64 = AV_PIX_FMT_BGRA64();

public static native @MemberGetter int AV_PIX_FMT_YUV420P9();
public static final int AV_PIX_FMT_YUV420P9 = AV_PIX_FMT_YUV420P9();
public static native @MemberGetter int AV_PIX_FMT_YUV422P9();
public static final int AV_PIX_FMT_YUV422P9 = AV_PIX_FMT_YUV422P9();
public static native @MemberGetter int AV_PIX_FMT_YUV444P9();
public static final int AV_PIX_FMT_YUV444P9 = AV_PIX_FMT_YUV444P9();
public static native @MemberGetter int AV_PIX_FMT_YUV420P10();
public static final int AV_PIX_FMT_YUV420P10 = AV_PIX_FMT_YUV420P10();
public static native @MemberGetter int AV_PIX_FMT_YUV422P10();
public static final int AV_PIX_FMT_YUV422P10 = AV_PIX_FMT_YUV422P10();
public static native @MemberGetter int AV_PIX_FMT_YUV440P10();
public static final int AV_PIX_FMT_YUV440P10 = AV_PIX_FMT_YUV440P10();
public static native @MemberGetter int AV_PIX_FMT_YUV444P10();
public static final int AV_PIX_FMT_YUV444P10 = AV_PIX_FMT_YUV444P10();
public static native @MemberGetter int AV_PIX_FMT_YUV420P12();
public static final int AV_PIX_FMT_YUV420P12 = AV_PIX_FMT_YUV420P12();
public static native @MemberGetter int AV_PIX_FMT_YUV422P12();
public static final int AV_PIX_FMT_YUV422P12 = AV_PIX_FMT_YUV422P12();
public static native @MemberGetter int AV_PIX_FMT_YUV440P12();
public static final int AV_PIX_FMT_YUV440P12 = AV_PIX_FMT_YUV440P12();
public static native @MemberGetter int AV_PIX_FMT_YUV444P12();
public static final int AV_PIX_FMT_YUV444P12 = AV_PIX_FMT_YUV444P12();
public static native @MemberGetter int AV_PIX_FMT_YUV420P14();
public static final int AV_PIX_FMT_YUV420P14 = AV_PIX_FMT_YUV420P14();
public static native @MemberGetter int AV_PIX_FMT_YUV422P14();
public static final int AV_PIX_FMT_YUV422P14 = AV_PIX_FMT_YUV422P14();
public static native @MemberGetter int AV_PIX_FMT_YUV444P14();
public static final int AV_PIX_FMT_YUV444P14 = AV_PIX_FMT_YUV444P14();
public static native @MemberGetter int AV_PIX_FMT_YUV420P16();
public static final int AV_PIX_FMT_YUV420P16 = AV_PIX_FMT_YUV420P16();
public static native @MemberGetter int AV_PIX_FMT_YUV422P16();
public static final int AV_PIX_FMT_YUV422P16 = AV_PIX_FMT_YUV422P16();
public static native @MemberGetter int AV_PIX_FMT_YUV444P16();
public static final int AV_PIX_FMT_YUV444P16 = AV_PIX_FMT_YUV444P16();

public static native @MemberGetter int AV_PIX_FMT_GBRP9();
public static final int AV_PIX_FMT_GBRP9 = AV_PIX_FMT_GBRP9();
public static native @MemberGetter int AV_PIX_FMT_GBRP10();
public static final int AV_PIX_FMT_GBRP10 = AV_PIX_FMT_GBRP10();
public static native @MemberGetter int AV_PIX_FMT_GBRP12();
public static final int AV_PIX_FMT_GBRP12 = AV_PIX_FMT_GBRP12();
public static native @MemberGetter int AV_PIX_FMT_GBRP14();
public static final int AV_PIX_FMT_GBRP14 = AV_PIX_FMT_GBRP14();
public static native @MemberGetter int AV_PIX_FMT_GBRP16();
public static final int AV_PIX_FMT_GBRP16 = AV_PIX_FMT_GBRP16();
public static native @MemberGetter int AV_PIX_FMT_GBRAP10();
public static final int AV_PIX_FMT_GBRAP10 = AV_PIX_FMT_GBRAP10();
public static native @MemberGetter int AV_PIX_FMT_GBRAP12();
public static final int AV_PIX_FMT_GBRAP12 = AV_PIX_FMT_GBRAP12();
public static native @MemberGetter int AV_PIX_FMT_GBRAP16();
public static final int AV_PIX_FMT_GBRAP16 = AV_PIX_FMT_GBRAP16();

public static native @MemberGetter int AV_PIX_FMT_BAYER_BGGR16();
public static final int AV_PIX_FMT_BAYER_BGGR16 = AV_PIX_FMT_BAYER_BGGR16();
public static native @MemberGetter int AV_PIX_FMT_BAYER_RGGB16();
public static final int AV_PIX_FMT_BAYER_RGGB16 = AV_PIX_FMT_BAYER_RGGB16();
public static native @MemberGetter int AV_PIX_FMT_BAYER_GBRG16();
public static final int AV_PIX_FMT_BAYER_GBRG16 = AV_PIX_FMT_BAYER_GBRG16();
public static native @MemberGetter int AV_PIX_FMT_BAYER_GRBG16();
public static final int AV_PIX_FMT_BAYER_GRBG16 = AV_PIX_FMT_BAYER_GRBG16();

public static native @MemberGetter int AV_PIX_FMT_GBRPF32();
public static final int AV_PIX_FMT_GBRPF32 = AV_PIX_FMT_GBRPF32();
public static native @MemberGetter int AV_PIX_FMT_GBRAPF32();
public static final int AV_PIX_FMT_GBRAPF32 = AV_PIX_FMT_GBRAPF32();

public static native @MemberGetter int AV_PIX_FMT_GRAYF32();
public static final int AV_PIX_FMT_GRAYF32 = AV_PIX_FMT_GRAYF32();

public static native @MemberGetter int AV_PIX_FMT_YUVA420P9();
public static final int AV_PIX_FMT_YUVA420P9 = AV_PIX_FMT_YUVA420P9();
public static native @MemberGetter int AV_PIX_FMT_YUVA422P9();
public static final int AV_PIX_FMT_YUVA422P9 = AV_PIX_FMT_YUVA422P9();
public static native @MemberGetter int AV_PIX_FMT_YUVA444P9();
public static final int AV_PIX_FMT_YUVA444P9 = AV_PIX_FMT_YUVA444P9();
public static native @MemberGetter int AV_PIX_FMT_YUVA420P10();
public static final int AV_PIX_FMT_YUVA420P10 = AV_PIX_FMT_YUVA420P10();
public static native @MemberGetter int AV_PIX_FMT_YUVA422P10();
public static final int AV_PIX_FMT_YUVA422P10 = AV_PIX_FMT_YUVA422P10();
public static native @MemberGetter int AV_PIX_FMT_YUVA444P10();
public static final int AV_PIX_FMT_YUVA444P10 = AV_PIX_FMT_YUVA444P10();
public static native @MemberGetter int AV_PIX_FMT_YUVA422P12();
public static final int AV_PIX_FMT_YUVA422P12 = AV_PIX_FMT_YUVA422P12();
public static native @MemberGetter int AV_PIX_FMT_YUVA444P12();
public static final int AV_PIX_FMT_YUVA444P12 = AV_PIX_FMT_YUVA444P12();
public static native @MemberGetter int AV_PIX_FMT_YUVA420P16();
public static final int AV_PIX_FMT_YUVA420P16 = AV_PIX_FMT_YUVA420P16();
public static native @MemberGetter int AV_PIX_FMT_YUVA422P16();
public static final int AV_PIX_FMT_YUVA422P16 = AV_PIX_FMT_YUVA422P16();
public static native @MemberGetter int AV_PIX_FMT_YUVA444P16();
public static final int AV_PIX_FMT_YUVA444P16 = AV_PIX_FMT_YUVA444P16();

public static native @MemberGetter int AV_PIX_FMT_XYZ12();
public static final int AV_PIX_FMT_XYZ12 = AV_PIX_FMT_XYZ12();
public static native @MemberGetter int AV_PIX_FMT_NV20();
public static final int AV_PIX_FMT_NV20 = AV_PIX_FMT_NV20();
public static native @MemberGetter int AV_PIX_FMT_AYUV64();
public static final int AV_PIX_FMT_AYUV64 = AV_PIX_FMT_AYUV64();
public static native @MemberGetter int AV_PIX_FMT_P010();
public static final int AV_PIX_FMT_P010 = AV_PIX_FMT_P010();
public static native @MemberGetter int AV_PIX_FMT_P016();
public static final int AV_PIX_FMT_P016 = AV_PIX_FMT_P016();

public static native @MemberGetter int AV_PIX_FMT_Y210();
public static final int AV_PIX_FMT_Y210 = AV_PIX_FMT_Y210();

/**
  * Chromaticity coordinates of the source primaries.
  * These values match the ones defined by ISO/IEC 23001-8_2013 § 7.1.
  */
/** enum AVColorPrimaries */
public static final int
    AVCOL_PRI_RESERVED0   = 0,
    /** also ITU-R BT1361 / IEC 61966-2-4 / SMPTE RP177 Annex B */
    AVCOL_PRI_BT709       = 1,
    AVCOL_PRI_UNSPECIFIED = 2,
    AVCOL_PRI_RESERVED    = 3,
    /** also FCC Title 47 Code of Federal Regulations 73.682 (a)(20) */
    AVCOL_PRI_BT470M      = 4,

    /** also ITU-R BT601-6 625 / ITU-R BT1358 625 / ITU-R BT1700 625 PAL & SECAM */
    AVCOL_PRI_BT470BG     = 5,
    /** also ITU-R BT601-6 525 / ITU-R BT1358 525 / ITU-R BT1700 NTSC */
    AVCOL_PRI_SMPTE170M   = 6,
    /** functionally identical to above */
    AVCOL_PRI_SMPTE240M   = 7,
    /** colour filters using Illuminant C */
    AVCOL_PRI_FILM        = 8,
    /** ITU-R BT2020 */
    AVCOL_PRI_BT2020      = 9,
    /** SMPTE ST 428-1 (CIE 1931 XYZ) */
    AVCOL_PRI_SMPTE428    = 10,
    AVCOL_PRI_SMPTEST428_1 = AVCOL_PRI_SMPTE428,
    /** SMPTE ST 431-2 (2011) / DCI P3 */
    AVCOL_PRI_SMPTE431    = 11,
    /** SMPTE ST 432-1 (2010) / P3 D65 / Display P3 */
    AVCOL_PRI_SMPTE432    = 12,
    /** EBU Tech. 3213-E / JEDEC P22 phosphors */
    AVCOL_PRI_EBU3213     = 22,
    AVCOL_PRI_JEDEC_P22   = AVCOL_PRI_EBU3213,
    /** Not part of ABI */
    AVCOL_PRI_NB = AVCOL_PRI_EBU3213 + 1;

/**
 * Color Transfer Characteristic.
 * These values match the ones defined by ISO/IEC 23001-8_2013 § 7.2.
 */
/** enum AVColorTransferCharacteristic */
public static final int
    AVCOL_TRC_RESERVED0    = 0,
    /** also ITU-R BT1361 */
    AVCOL_TRC_BT709        = 1,
    AVCOL_TRC_UNSPECIFIED  = 2,
    AVCOL_TRC_RESERVED     = 3,
    /** also ITU-R BT470M / ITU-R BT1700 625 PAL & SECAM */
    AVCOL_TRC_GAMMA22      = 4,
    /** also ITU-R BT470BG */
    AVCOL_TRC_GAMMA28      = 5,
    /** also ITU-R BT601-6 525 or 625 / ITU-R BT1358 525 or 625 / ITU-R BT1700 NTSC */
    AVCOL_TRC_SMPTE170M    = 6,
    AVCOL_TRC_SMPTE240M    = 7,
    /** "Linear transfer characteristics" */
    AVCOL_TRC_LINEAR       = 8,
    /** "Logarithmic transfer characteristic (100:1 range)" */
    AVCOL_TRC_LOG          = 9,
    /** "Logarithmic transfer characteristic (100 * Sqrt(10) : 1 range)" */
    AVCOL_TRC_LOG_SQRT     = 10,
    /** IEC 61966-2-4 */
    AVCOL_TRC_IEC61966_2_4 = 11,
    /** ITU-R BT1361 Extended Colour Gamut */
    AVCOL_TRC_BT1361_ECG   = 12,
    /** IEC 61966-2-1 (sRGB or sYCC) */
    AVCOL_TRC_IEC61966_2_1 = 13,
    /** ITU-R BT2020 for 10-bit system */
    AVCOL_TRC_BT2020_10    = 14,
    /** ITU-R BT2020 for 12-bit system */
    AVCOL_TRC_BT2020_12    = 15,
    /** SMPTE ST 2084 for 10-, 12-, 14- and 16-bit systems */
    AVCOL_TRC_SMPTE2084    = 16,
    AVCOL_TRC_SMPTEST2084  = AVCOL_TRC_SMPTE2084,
    /** SMPTE ST 428-1 */
    AVCOL_TRC_SMPTE428     = 17,
    AVCOL_TRC_SMPTEST428_1 = AVCOL_TRC_SMPTE428,
    /** ARIB STD-B67, known as "Hybrid log-gamma" */
    AVCOL_TRC_ARIB_STD_B67 = 18,
    /** Not part of ABI */
    AVCOL_TRC_NB = 19;

/**
 * YUV colorspace type.
 * These values match the ones defined by ISO/IEC 23001-8_2013 § 7.3.
 */
/** enum AVColorSpace */
public static final int
    /** order of coefficients is actually GBR, also IEC 61966-2-1 (sRGB) */
    AVCOL_SPC_RGB         = 0,
    /** also ITU-R BT1361 / IEC 61966-2-4 xvYCC709 / SMPTE RP177 Annex B */
    AVCOL_SPC_BT709       = 1,
    AVCOL_SPC_UNSPECIFIED = 2,
    AVCOL_SPC_RESERVED    = 3,
    /** FCC Title 47 Code of Federal Regulations 73.682 (a)(20) */
    AVCOL_SPC_FCC         = 4,
    /** also ITU-R BT601-6 625 / ITU-R BT1358 625 / ITU-R BT1700 625 PAL & SECAM / IEC 61966-2-4 xvYCC601 */
    AVCOL_SPC_BT470BG     = 5,
    /** also ITU-R BT601-6 525 / ITU-R BT1358 525 / ITU-R BT1700 NTSC */
    AVCOL_SPC_SMPTE170M   = 6,
    /** functionally identical to above */
    AVCOL_SPC_SMPTE240M   = 7,
    /** Used by Dirac / VC-2 and H.264 FRext, see ITU-T SG16 */
    AVCOL_SPC_YCGCO       = 8,
    AVCOL_SPC_YCOCG       = AVCOL_SPC_YCGCO,
    /** ITU-R BT2020 non-constant luminance system */
    AVCOL_SPC_BT2020_NCL  = 9,
    /** ITU-R BT2020 constant luminance system */
    AVCOL_SPC_BT2020_CL   = 10,
    /** SMPTE 2085, Y'D'zD'x */
    AVCOL_SPC_SMPTE2085   = 11,
    /** Chromaticity-derived non-constant luminance system */
    AVCOL_SPC_CHROMA_DERIVED_NCL = 12,
    /** Chromaticity-derived constant luminance system */
    AVCOL_SPC_CHROMA_DERIVED_CL = 13,
    /** ITU-R BT.2100-0, ICtCp */
    AVCOL_SPC_ICTCP       = 14,
    /** Not part of ABI */
    AVCOL_SPC_NB = 15;

/**
 * MPEG vs JPEG YUV range.
 */
/** enum AVColorRange */
public static final int
    AVCOL_RANGE_UNSPECIFIED = 0,
    /** the normal 219*2^(n-8) "MPEG" YUV ranges */
    AVCOL_RANGE_MPEG        = 1,
    /** the normal     2^n-1   "JPEG" YUV ranges */
    AVCOL_RANGE_JPEG        = 2,
    /** Not part of ABI */
    AVCOL_RANGE_NB = 3;

/**
 * Location of chroma samples.
 *
 * Illustration showing the location of the first (top left) chroma sample of the
 * image, the left shows only luma, the right
 * shows the location of the chroma sample, the 2 could be imagined to overlay
 * each other but are drawn separately due to limitations of ASCII
 *
 *                1st 2nd       1st 2nd horizontal luma sample positions
 *                 v   v         v   v
 *                 ______        ______
 *1st luma line > |X   X ...    |3 4 X ...     X are luma samples,
 *                |             |1 2           1-6 are possible chroma positions
 *2nd luma line > |X   X ...    |5 6 X ...     0 is undefined/unknown position
 */
/** enum AVChromaLocation */
public static final int
    AVCHROMA_LOC_UNSPECIFIED = 0,
    /** MPEG-2/4 4:2:0, H.264 default for 4:2:0 */
    AVCHROMA_LOC_LEFT        = 1,
    /** MPEG-1 4:2:0, JPEG 4:2:0, H.263 4:2:0 */
    AVCHROMA_LOC_CENTER      = 2,
    /** ITU-R 601, SMPTE 274M 296M S314M(DV 4:1:1), mpeg2 4:2:2 */
    AVCHROMA_LOC_TOPLEFT     = 3,
    AVCHROMA_LOC_TOP         = 4,
    AVCHROMA_LOC_BOTTOMLEFT  = 5,
    AVCHROMA_LOC_BOTTOM      = 6,
    /** Not part of ABI */
    AVCHROMA_LOC_NB = 7;

// #endif /* AVUTIL_PIXFMT_H */


// Parsed from <libavutil/frame.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_frame
 * reference-counted frame API
 */

// #ifndef AVUTIL_FRAME_H
// #define AVUTIL_FRAME_H

// #include <stddef.h>
// #include <stdint.h>

// #include "avutil.h"
// #include "buffer.h"
// #include "dict.h"
// #include "rational.h"
// #include "samplefmt.h"
// #include "pixfmt.h"
// #include "version.h"


/**
 * \defgroup lavu_frame AVFrame
 * \ingroup lavu_data
 *
 * \{
 * AVFrame is an abstraction for reference-counted raw multimedia data.
 */

/** enum AVFrameSideDataType */
public static final int
    /**
     * The data is the AVPanScan struct defined in libavcodec.
     */
    AV_FRAME_DATA_PANSCAN = 0,
    /**
     * ATSC A53 Part 4 Closed Captions.
     * A53 CC bitstream is stored as uint8_t in AVFrameSideData.data.
     * The number of bytes of CC data is AVFrameSideData.size.
     */
    AV_FRAME_DATA_A53_CC = 1,
    /**
     * Stereoscopic 3d metadata.
     * The data is the AVStereo3D struct defined in libavutil/stereo3d.h.
     */
    AV_FRAME_DATA_STEREO3D = 2,
    /**
     * The data is the AVMatrixEncoding enum defined in libavutil/channel_layout.h.
     */
    AV_FRAME_DATA_MATRIXENCODING = 3,
    /**
     * Metadata relevant to a downmix procedure.
     * The data is the AVDownmixInfo struct defined in libavutil/downmix_info.h.
     */
    AV_FRAME_DATA_DOWNMIX_INFO = 4,
    /**
     * ReplayGain information in the form of the AVReplayGain struct.
     */
    AV_FRAME_DATA_REPLAYGAIN = 5,
    /**
     * This side data contains a 3x3 transformation matrix describing an affine
     * transformation that needs to be applied to the frame for correct
     * presentation.
     *
     * See libavutil/display.h for a detailed description of the data.
     */
    AV_FRAME_DATA_DISPLAYMATRIX = 6,
    /**
     * Active Format Description data consisting of a single byte as specified
     * in ETSI TS 101 154 using AVActiveFormatDescription enum.
     */
    AV_FRAME_DATA_AFD = 7,
    /**
     * Motion vectors exported by some codecs (on demand through the export_mvs
     * flag set in the libavcodec AVCodecContext flags2 option).
     * The data is the AVMotionVector struct defined in
     * libavutil/motion_vector.h.
     */
    AV_FRAME_DATA_MOTION_VECTORS = 8,
    /**
     * Recommmends skipping the specified number of samples. This is exported
     * only if the "skip_manual" AVOption is set in libavcodec.
     * This has the same format as AV_PKT_DATA_SKIP_SAMPLES.
     * <pre>{@code
     * u32le number of samples to skip from start of this packet
     * u32le number of samples to skip from end of this packet
     * u8    reason for start skip
     * u8    reason for end   skip (0=padding silence, 1=convergence)
     * }</pre>
     */
    AV_FRAME_DATA_SKIP_SAMPLES = 9,
    /**
     * This side data must be associated with an audio frame and corresponds to
     * enum AVAudioServiceType defined in avcodec.h.
     */
    AV_FRAME_DATA_AUDIO_SERVICE_TYPE = 10,
    /**
     * Mastering display metadata associated with a video frame. The payload is
     * an AVMasteringDisplayMetadata type and contains information about the
     * mastering display color volume.
     */
    AV_FRAME_DATA_MASTERING_DISPLAY_METADATA = 11,
    /**
     * The GOP timecode in 25 bit timecode format. Data format is 64-bit integer.
     * This is set on the first frame of a GOP that has a temporal reference of 0.
     */
    AV_FRAME_DATA_GOP_TIMECODE = 12,

    /**
     * The data represents the AVSphericalMapping structure defined in
     * libavutil/spherical.h.
     */
    AV_FRAME_DATA_SPHERICAL = 13,

    /**
     * Content light level (based on CTA-861.3). This payload contains data in
     * the form of the AVContentLightMetadata struct.
     */
    AV_FRAME_DATA_CONTENT_LIGHT_LEVEL = 14,

    /**
     * The data contains an ICC profile as an opaque octet buffer following the
     * format described by ISO 15076-1 with an optional name defined in the
     * metadata key entry "name".
     */
    AV_FRAME_DATA_ICC_PROFILE = 15,

// #if FF_API_FRAME_QP
    /**
     * Implementation-specific description of the format of AV_FRAME_QP_TABLE_DATA.
     * The contents of this side data are undocumented and internal; use
     * av_frame_set_qp_table() and av_frame_get_qp_table() to access this in a
     * meaningful way instead.
     */
    AV_FRAME_DATA_QP_TABLE_PROPERTIES = 16,

    /**
     * Raw QP table data. Its format is described by
     * AV_FRAME_DATA_QP_TABLE_PROPERTIES. Use av_frame_set_qp_table() and
     * av_frame_get_qp_table() to access this instead.
     */
    AV_FRAME_DATA_QP_TABLE_DATA = 17,
// #endif

    /**
     * Timecode which conforms to SMPTE ST 12-1. The data is an array of 4 uint32_t
     * where the first uint32_t describes how many (1-3) of the other timecodes are used.
     * The timecode format is described in the av_timecode_get_smpte_from_framenum()
     * function in libavutil/timecode.c.
     */
    AV_FRAME_DATA_S12M_TIMECODE = 18,

    /**
     * HDR dynamic metadata associated with a video frame. The payload is
     * an AVDynamicHDRPlus type and contains information for color
     * volume transform - application 4 of SMPTE 2094-40:2016 standard.
     */
    AV_FRAME_DATA_DYNAMIC_HDR_PLUS = 19,

    /**
     * Regions Of Interest, the data is an array of AVRegionOfInterest type, the number of
     * array element is implied by AVFrameSideData.size / AVRegionOfInterest.self_size.
     */
    AV_FRAME_DATA_REGIONS_OF_INTEREST = 20,

    /**
     * Encoding parameters for a video frame, as described by AVVideoEncParams.
     */
    AV_FRAME_DATA_VIDEO_ENC_PARAMS = 21;

/** enum AVActiveFormatDescription */
public static final int
    AV_AFD_SAME         = 8,
    AV_AFD_4_3          = 9,
    AV_AFD_16_9         = 10,
    AV_AFD_14_9         = 11,
    AV_AFD_4_3_SP_14_9  = 13,
    AV_AFD_16_9_SP_14_9 = 14,
    AV_AFD_SP_4_3       = 15;
// Targeting ..\avutil\AVFrameSideData.java


// Targeting ..\avutil\AVRegionOfInterest.java


// Targeting ..\avutil\AVFrame.java



// #if FF_API_FRAME_GET_SET
/**
 * Accessors for some AVFrame fields. These used to be provided for ABI
 * compatibility, and do not need to be used anymore.
 */
@NoException public static native @Cast("int64_t") @Deprecated long av_frame_get_best_effort_timestamp(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_best_effort_timestamp(AVFrame frame, @Cast("int64_t") long val);
@NoException public static native @Cast("int64_t") @Deprecated long av_frame_get_pkt_duration(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_pkt_duration(AVFrame frame, @Cast("int64_t") long val);
@NoException public static native @Cast("int64_t") @Deprecated long av_frame_get_pkt_pos(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_pkt_pos(AVFrame frame, @Cast("int64_t") long val);
@NoException public static native @Cast("int64_t") @Deprecated long av_frame_get_channel_layout(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_channel_layout(AVFrame frame, @Cast("int64_t") long val);
@NoException public static native @Deprecated int av_frame_get_channels(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_channels(AVFrame frame, int val);
@NoException public static native @Deprecated int av_frame_get_sample_rate(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_sample_rate(AVFrame frame, int val);
@NoException public static native @Deprecated AVDictionary av_frame_get_metadata(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_metadata(AVFrame frame, AVDictionary val);
@NoException public static native @Deprecated int av_frame_get_decode_error_flags(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_decode_error_flags(AVFrame frame, int val);
@NoException public static native @Deprecated int av_frame_get_pkt_size(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_pkt_size(AVFrame frame, int val);
// #if FF_API_FRAME_QP
@NoException public static native @Deprecated BytePointer av_frame_get_qp_table(AVFrame f, IntPointer stride, IntPointer type);
@NoException public static native @Deprecated ByteBuffer av_frame_get_qp_table(AVFrame f, IntBuffer stride, IntBuffer type);
@NoException public static native @Deprecated byte[] av_frame_get_qp_table(AVFrame f, int[] stride, int[] type);
@NoException public static native @Deprecated int av_frame_set_qp_table(AVFrame f, AVBufferRef buf, int stride, int type);
// #endif
@NoException public static native @Cast("AVColorSpace") @Deprecated int av_frame_get_colorspace(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_colorspace(AVFrame frame, @Cast("AVColorSpace") int val);
@NoException public static native @Cast("AVColorRange") @Deprecated int av_frame_get_color_range(@Const AVFrame frame);
@NoException public static native @Deprecated void av_frame_set_color_range(AVFrame frame, @Cast("AVColorRange") int val);
// #endif

/**
 * Get the name of a colorspace.
 * @return a static string identifying the colorspace; can be NULL.
 */
@NoException public static native @Cast("const char*") BytePointer av_get_colorspace_name(@Cast("AVColorSpace") int val);

/**
 * Allocate an AVFrame and set its fields to default values.  The resulting
 * struct must be freed using av_frame_free().
 *
 * @return An AVFrame filled with default values or NULL on failure.
 *
 * \note this only allocates the AVFrame itself, not the data buffers. Those
 * must be allocated through other means, e.g. with av_frame_get_buffer() or
 * manually.
 */
@NoException public static native AVFrame av_frame_alloc();

/**
 * Free the frame and any dynamically allocated objects in it,
 * e.g. extended_data. If the frame is reference counted, it will be
 * unreferenced first.
 *
 * @param frame frame to be freed. The pointer will be set to NULL.
 */
@NoException public static native void av_frame_free(@Cast("AVFrame**") PointerPointer frame);
@NoException public static native void av_frame_free(@ByPtrPtr AVFrame frame);

/**
 * Set up a new reference to the data described by the source frame.
 *
 * Copy frame properties from src to dst and create a new reference for each
 * AVBufferRef from src.
 *
 * If src is not reference counted, new buffers are allocated and the data is
 * copied.
 *
 * \warning: dst MUST have been either unreferenced with av_frame_unref(dst),
 *           or newly allocated with av_frame_alloc() before calling this
 *           function, or undefined behavior will occur.
 *
 * @return 0 on success, a negative AVERROR on error
 */
@NoException public static native int av_frame_ref(AVFrame dst, @Const AVFrame src);

/**
 * Create a new frame that references the same data as src.
 *
 * This is a shortcut for av_frame_alloc()+av_frame_ref().
 *
 * @return newly created AVFrame on success, NULL on error.
 */
@NoException public static native AVFrame av_frame_clone(@Const AVFrame src);

/**
 * Unreference all the buffers referenced by frame and reset the frame fields.
 */
@NoException public static native void av_frame_unref(AVFrame frame);

/**
 * Move everything contained in src to dst and reset src.
 *
 * \warning: dst is not unreferenced, but directly overwritten without reading
 *           or deallocating its contents. Call av_frame_unref(dst) manually
 *           before calling this function to ensure that no memory is leaked.
 */
@NoException public static native void av_frame_move_ref(AVFrame dst, AVFrame src);

/**
 * Allocate new buffer(s) for audio or video data.
 *
 * The following fields must be set on frame before calling this function:
 * - format (pixel format for video, sample format for audio)
 * - width and height for video
 * - nb_samples and channel_layout for audio
 *
 * This function will fill AVFrame.data and AVFrame.buf arrays and, if
 * necessary, allocate and fill AVFrame.extended_data and AVFrame.extended_buf.
 * For planar formats, one buffer will be allocated for each plane.
 *
 * \warning: if frame already has been allocated, calling this function will
 *           leak memory. In addition, undefined behavior can occur in certain
 *           cases.
 *
 * @param frame frame in which to store the new buffers.
 * @param align Required buffer size alignment. If equal to 0, alignment will be
 *              chosen automatically for the current CPU. It is highly
 *              recommended to pass 0 here unless you know what you are doing.
 *
 * @return 0 on success, a negative AVERROR on error.
 */
@NoException public static native int av_frame_get_buffer(AVFrame frame, int align);

/**
 * Check if the frame data is writable.
 *
 * @return A positive value if the frame data is writable (which is true if and
 * only if each of the underlying buffers has only one reference, namely the one
 * stored in this frame). Return 0 otherwise.
 *
 * If 1 is returned the answer is valid until av_buffer_ref() is called on any
 * of the underlying AVBufferRefs (e.g. through av_frame_ref() or directly).
 *
 * @see av_frame_make_writable(), av_buffer_is_writable()
 */
@NoException public static native int av_frame_is_writable(AVFrame frame);

/**
 * Ensure that the frame data is writable, avoiding data copy if possible.
 *
 * Do nothing if the frame is writable, allocate new buffers and copy the data
 * if it is not.
 *
 * @return 0 on success, a negative AVERROR on error.
 *
 * @see av_frame_is_writable(), av_buffer_is_writable(),
 * av_buffer_make_writable()
 */
@NoException public static native int av_frame_make_writable(AVFrame frame);

/**
 * Copy the frame data from src to dst.
 *
 * This function does not allocate anything, dst must be already initialized and
 * allocated with the same parameters as src.
 *
 * This function only copies the frame data (i.e. the contents of the data /
 * extended data arrays), not any other properties.
 *
 * @return >= 0 on success, a negative AVERROR on error.
 */
@NoException public static native int av_frame_copy(AVFrame dst, @Const AVFrame src);

/**
 * Copy only "metadata" fields from src to dst.
 *
 * Metadata for the purpose of this function are those fields that do not affect
 * the data layout in the buffers.  E.g. pts, sample rate (for audio) or sample
 * aspect ratio (for video), but not width/height or channel layout.
 * Side data is also copied.
 */
@NoException public static native int av_frame_copy_props(AVFrame dst, @Const AVFrame src);

/**
 * Get the buffer reference a given data plane is stored in.
 *
 * @param plane index of the data plane of interest in frame->extended_data.
 *
 * @return the buffer reference that contains the plane or NULL if the input
 * frame is not valid.
 */
@NoException public static native AVBufferRef av_frame_get_plane_buffer(AVFrame frame, int plane);

/**
 * Add a new side data to a frame.
 *
 * @param frame a frame to which the side data should be added
 * @param type type of the added side data
 * @param size size of the side data
 *
 * @return newly added side data on success, NULL on error
 */
@NoException public static native AVFrameSideData av_frame_new_side_data(AVFrame frame,
                                        @Cast("AVFrameSideDataType") int type,
                                        int size);

/**
 * Add a new side data to a frame from an existing AVBufferRef
 *
 * @param frame a frame to which the side data should be added
 * @param type  the type of the added side data
 * @param buf   an AVBufferRef to add as side data. The ownership of
 *              the reference is transferred to the frame.
 *
 * @return newly added side data on success, NULL on error. On failure
 *         the frame is unchanged and the AVBufferRef remains owned by
 *         the caller.
 */
@NoException public static native AVFrameSideData av_frame_new_side_data_from_buf(AVFrame frame,
                                                 @Cast("AVFrameSideDataType") int type,
                                                 AVBufferRef buf);

/**
 * @return a pointer to the side data of a given type on success, NULL if there
 * is no side data with such type in this frame.
 */
@NoException public static native AVFrameSideData av_frame_get_side_data(@Const AVFrame frame,
                                        @Cast("AVFrameSideDataType") int type);

/**
 * Remove and free all side data instances of the given type.
 */
@NoException public static native void av_frame_remove_side_data(AVFrame frame, @Cast("AVFrameSideDataType") int type);


/**
 * Flags for frame cropping.
 */
/** enum  */
public static final int
    /**
     * Apply the maximum possible cropping, even if it requires setting the
     * AVFrame.data[] entries to unaligned pointers. Passing unaligned data
     * to FFmpeg API is generally not allowed, and causes undefined behavior
     * (such as crashes). You can pass unaligned data only to FFmpeg APIs that
     * are explicitly documented to accept it. Use this flag only if you
     * absolutely know what you are doing.
     */
    AV_FRAME_CROP_UNALIGNED     = 1 << 0;

/**
 * Crop the given video AVFrame according to its crop_left/crop_top/crop_right/
 * crop_bottom fields. If cropping is successful, the function will adjust the
 * data pointers and the width/height fields, and set the crop fields to 0.
 *
 * In all cases, the cropping boundaries will be rounded to the inherent
 * alignment of the pixel format. In some cases, such as for opaque hwaccel
 * formats, the left/top cropping is ignored. The crop fields are set to 0 even
 * if the cropping was rounded or ignored.
 *
 * @param frame the frame which should be cropped
 * @param flags Some combination of AV_FRAME_CROP_* flags, or 0.
 *
 * @return >= 0 on success, a negative AVERROR on error. If the cropping fields
 * were invalid, AVERROR(ERANGE) is returned, and nothing is changed.
 */
@NoException public static native int av_frame_apply_cropping(AVFrame frame, int flags);

/**
 * @return a string identifying the side data type
 */
@NoException public static native @Cast("const char*") BytePointer av_frame_side_data_name(@Cast("AVFrameSideDataType") int type);

/**
 * \}
 */

// #endif /* AVUTIL_FRAME_H */


// Parsed from <libavutil/samplefmt.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_SAMPLEFMT_H
// #define AVUTIL_SAMPLEFMT_H

// #include <stdint.h>

// #include "avutil.h"
// #include "attributes.h"

/**
 * \addtogroup lavu_audio
 * \{
 *
 * \defgroup lavu_sampfmts Audio sample formats
 *
 * Audio sample format enumeration and related convenience functions.
 * \{
 */

/**
 * Audio sample formats
 *
 * - The data described by the sample format is always in native-endian order.
 *   Sample values can be expressed by native C types, hence the lack of a signed
 *   24-bit sample format even though it is a common raw audio data format.
 *
 * - The floating-point formats are based on full volume being in the range
 *   [-1.0, 1.0]. Any values outside this range are beyond full volume level.
 *
 * - The data layout as used in av_samples_fill_arrays() and elsewhere in FFmpeg
 *   (such as AVFrame in libavcodec) is as follows:
 *
 * \par
 * For planar sample formats, each audio channel is in a separate data plane,
 * and linesize is the buffer size, in bytes, for a single plane. All data
 * planes must be the same size. For packed sample formats, only the first data
 * plane is used, and samples for each channel are interleaved. In this case,
 * linesize is the buffer size, in bytes, for the 1 plane.
 *
 */
/** enum AVSampleFormat */
public static final int
    AV_SAMPLE_FMT_NONE = -1,
    /** unsigned 8 bits */
    AV_SAMPLE_FMT_U8 = 0,
    /** signed 16 bits */
    AV_SAMPLE_FMT_S16 = 1,
    /** signed 32 bits */
    AV_SAMPLE_FMT_S32 = 2,
    /** float */
    AV_SAMPLE_FMT_FLT = 3,
    /** double */
    AV_SAMPLE_FMT_DBL = 4,

    /** unsigned 8 bits, planar */
    AV_SAMPLE_FMT_U8P = 5,
    /** signed 16 bits, planar */
    AV_SAMPLE_FMT_S16P = 6,
    /** signed 32 bits, planar */
    AV_SAMPLE_FMT_S32P = 7,
    /** float, planar */
    AV_SAMPLE_FMT_FLTP = 8,
    /** double, planar */
    AV_SAMPLE_FMT_DBLP = 9,
    /** signed 64 bits */
    AV_SAMPLE_FMT_S64 = 10,
    /** signed 64 bits, planar */
    AV_SAMPLE_FMT_S64P = 11,

    /** Number of sample formats. DO NOT USE if linking dynamically */
    AV_SAMPLE_FMT_NB = 12;

/**
 * Return the name of sample_fmt, or NULL if sample_fmt is not
 * recognized.
 */
@NoException public static native @Cast("const char*") BytePointer av_get_sample_fmt_name(@Cast("AVSampleFormat") int sample_fmt);

/**
 * Return a sample format corresponding to name, or AV_SAMPLE_FMT_NONE
 * on error.
 */
@NoException public static native @Cast("AVSampleFormat") int av_get_sample_fmt(@Cast("const char*") BytePointer name);
@NoException public static native @Cast("AVSampleFormat") int av_get_sample_fmt(String name);

/**
 * Return the planar<->packed alternative form of the given sample format, or
 * AV_SAMPLE_FMT_NONE on error. If the passed sample_fmt is already in the
 * requested planar/packed format, the format returned is the same as the
 * input.
 */
@NoException public static native @Cast("AVSampleFormat") int av_get_alt_sample_fmt(@Cast("AVSampleFormat") int sample_fmt, int planar);

/**
 * Get the packed alternative form of the given sample format.
 *
 * If the passed sample_fmt is already in packed format, the format returned is
 * the same as the input.
 *
 * @return  the packed alternative form of the given sample format or
            AV_SAMPLE_FMT_NONE on error.
 */
@NoException public static native @Cast("AVSampleFormat") int av_get_packed_sample_fmt(@Cast("AVSampleFormat") int sample_fmt);

/**
 * Get the planar alternative form of the given sample format.
 *
 * If the passed sample_fmt is already in planar format, the format returned is
 * the same as the input.
 *
 * @return  the planar alternative form of the given sample format or
            AV_SAMPLE_FMT_NONE on error.
 */
@NoException public static native @Cast("AVSampleFormat") int av_get_planar_sample_fmt(@Cast("AVSampleFormat") int sample_fmt);

/**
 * Generate a string corresponding to the sample format with
 * sample_fmt, or a header if sample_fmt is negative.
 *
 * @param buf the buffer where to write the string
 * @param buf_size the size of buf
 * @param sample_fmt the number of the sample format to print the
 * corresponding info string, or a negative value to print the
 * corresponding header.
 * @return the pointer to the filled buffer or NULL if sample_fmt is
 * unknown or in case of other errors
 */
@NoException public static native @Cast("char*") BytePointer av_get_sample_fmt_string(@Cast("char*") BytePointer buf, int buf_size, @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native @Cast("char*") ByteBuffer av_get_sample_fmt_string(@Cast("char*") ByteBuffer buf, int buf_size, @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native @Cast("char*") byte[] av_get_sample_fmt_string(@Cast("char*") byte[] buf, int buf_size, @Cast("AVSampleFormat") int sample_fmt);

/**
 * Return number of bytes per sample.
 *
 * @param sample_fmt the sample format
 * @return number of bytes per sample or zero if unknown for the given
 * sample format
 */
@NoException public static native int av_get_bytes_per_sample(@Cast("AVSampleFormat") int sample_fmt);

/**
 * Check if the sample format is planar.
 *
 * @param sample_fmt the sample format to inspect
 * @return 1 if the sample format is planar, 0 if it is interleaved
 */
@NoException public static native int av_sample_fmt_is_planar(@Cast("AVSampleFormat") int sample_fmt);

/**
 * Get the required buffer size for the given audio parameters.
 *
 * @param linesize [out] calculated linesize, may be NULL
 * @param nb_channels   the number of channels
 * @param nb_samples    the number of samples in a single channel
 * @param sample_fmt    the sample format
 * @param align         buffer size alignment (0 = default, 1 = no alignment)
 * @return              required buffer size, or negative error code on failure
 */
@NoException public static native int av_samples_get_buffer_size(IntPointer linesize, int nb_channels, int nb_samples,
                               @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_get_buffer_size(IntBuffer linesize, int nb_channels, int nb_samples,
                               @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_get_buffer_size(int[] linesize, int nb_channels, int nb_samples,
                               @Cast("AVSampleFormat") int sample_fmt, int align);

/**
 * \}
 *
 * \defgroup lavu_sampmanip Samples manipulation
 *
 * Functions that manipulate audio samples
 * \{
 */

/**
 * Fill plane data pointers and linesize for samples with sample
 * format sample_fmt.
 *
 * The audio_data array is filled with the pointers to the samples data planes:
 * for planar, set the start point of each channel's data within the buffer,
 * for packed, set the start point of the entire buffer only.
 *
 * The value pointed to by linesize is set to the aligned size of each
 * channel's data buffer for planar layout, or to the aligned size of the
 * buffer for all channels for packed layout.
 *
 * The buffer in buf must be big enough to contain all the samples
 * (use av_samples_get_buffer_size() to compute its minimum size),
 * otherwise the audio_data pointers will point to invalid data.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param audio_data [out]  array to be filled with the pointer for each channel
 * @param linesize [out]    calculated linesize, may be NULL
 * @param buf              the pointer to a buffer containing the samples
 * @param nb_channels      the number of channels
 * @param nb_samples       the number of samples in a single channel
 * @param sample_fmt       the sample format
 * @param align            buffer size alignment (0 = default, 1 = no alignment)
 * @return                 >=0 on success or a negative error code on failure
 * \todo return minimum size in bytes required for the buffer in case
 * of success at the next bump
 */
@NoException public static native int av_samples_fill_arrays(@Cast("uint8_t**") PointerPointer audio_data, IntPointer linesize,
                           @Cast("const uint8_t*") BytePointer buf,
                           int nb_channels, int nb_samples,
                           @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_fill_arrays(@Cast("uint8_t**") @ByPtrPtr BytePointer audio_data, IntPointer linesize,
                           @Cast("const uint8_t*") BytePointer buf,
                           int nb_channels, int nb_samples,
                           @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_fill_arrays(@Cast("uint8_t**") @ByPtrPtr ByteBuffer audio_data, IntBuffer linesize,
                           @Cast("const uint8_t*") ByteBuffer buf,
                           int nb_channels, int nb_samples,
                           @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_fill_arrays(@Cast("uint8_t**") @ByPtrPtr byte[] audio_data, int[] linesize,
                           @Cast("const uint8_t*") byte[] buf,
                           int nb_channels, int nb_samples,
                           @Cast("AVSampleFormat") int sample_fmt, int align);

/**
 * Allocate a samples buffer for nb_samples samples, and fill data pointers and
 * linesize accordingly.
 * The allocated samples buffer can be freed by using av_freep(&audio_data[0])
 * Allocated data will be initialized to silence.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param audio_data [out]  array to be filled with the pointer for each channel
 * @param linesize [out]    aligned size for audio buffer(s), may be NULL
 * @param nb_channels      number of audio channels
 * @param nb_samples       number of samples per channel
 * @param align            buffer size alignment (0 = default, 1 = no alignment)
 * @return                 >=0 on success or a negative error code on failure
 * \todo return the size of the allocated buffer in case of success at the next bump
 * @see av_samples_fill_arrays()
 * @see av_samples_alloc_array_and_samples()
 */
@NoException public static native int av_samples_alloc(@Cast("uint8_t**") PointerPointer audio_data, IntPointer linesize, int nb_channels,
                     int nb_samples, @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_alloc(@Cast("uint8_t**") @ByPtrPtr BytePointer audio_data, IntPointer linesize, int nb_channels,
                     int nb_samples, @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_alloc(@Cast("uint8_t**") @ByPtrPtr ByteBuffer audio_data, IntBuffer linesize, int nb_channels,
                     int nb_samples, @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_alloc(@Cast("uint8_t**") @ByPtrPtr byte[] audio_data, int[] linesize, int nb_channels,
                     int nb_samples, @Cast("AVSampleFormat") int sample_fmt, int align);

/**
 * Allocate a data pointers array, samples buffer for nb_samples
 * samples, and fill data pointers and linesize accordingly.
 *
 * This is the same as av_samples_alloc(), but also allocates the data
 * pointers array.
 *
 * @see av_samples_alloc()
 */
@NoException public static native int av_samples_alloc_array_and_samples(@Cast("uint8_t***") @ByPtrPtr PointerPointer audio_data, IntPointer linesize, int nb_channels,
                                       int nb_samples, @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_alloc_array_and_samples(@Cast("uint8_t***") @ByPtrPtr PointerPointer audio_data, IntBuffer linesize, int nb_channels,
                                       int nb_samples, @Cast("AVSampleFormat") int sample_fmt, int align);
@NoException public static native int av_samples_alloc_array_and_samples(@Cast("uint8_t***") @ByPtrPtr PointerPointer audio_data, int[] linesize, int nb_channels,
                                       int nb_samples, @Cast("AVSampleFormat") int sample_fmt, int align);

/**
 * Copy samples from src to dst.
 *
 * @param dst destination array of pointers to data planes
 * @param src source array of pointers to data planes
 * @param dst_offset offset in samples at which the data will be written to dst
 * @param src_offset offset in samples at which the data will be read from src
 * @param nb_samples number of samples to be copied
 * @param nb_channels number of audio channels
 * @param sample_fmt audio sample format
 */
@NoException public static native int av_samples_copy(@Cast("uint8_t**") PointerPointer dst, @Cast("uint8_t*const*") PointerPointer src, int dst_offset,
                    int src_offset, int nb_samples, int nb_channels,
                    @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native int av_samples_copy(@Cast("uint8_t**") @ByPtrPtr BytePointer dst, @Cast("uint8_t*const*") @ByPtrPtr BytePointer src, int dst_offset,
                    int src_offset, int nb_samples, int nb_channels,
                    @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native int av_samples_copy(@Cast("uint8_t**") @ByPtrPtr ByteBuffer dst, @Cast("uint8_t*const*") @ByPtrPtr ByteBuffer src, int dst_offset,
                    int src_offset, int nb_samples, int nb_channels,
                    @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native int av_samples_copy(@Cast("uint8_t**") @ByPtrPtr byte[] dst, @Cast("uint8_t*const*") @ByPtrPtr byte[] src, int dst_offset,
                    int src_offset, int nb_samples, int nb_channels,
                    @Cast("AVSampleFormat") int sample_fmt);

/**
 * Fill an audio buffer with silence.
 *
 * @param audio_data  array of pointers to data planes
 * @param offset      offset in samples at which to start filling
 * @param nb_samples  number of samples to fill
 * @param nb_channels number of audio channels
 * @param sample_fmt  audio sample format
 */
@NoException public static native int av_samples_set_silence(@Cast("uint8_t**") PointerPointer audio_data, int offset, int nb_samples,
                           int nb_channels, @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native int av_samples_set_silence(@Cast("uint8_t**") @ByPtrPtr BytePointer audio_data, int offset, int nb_samples,
                           int nb_channels, @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native int av_samples_set_silence(@Cast("uint8_t**") @ByPtrPtr ByteBuffer audio_data, int offset, int nb_samples,
                           int nb_channels, @Cast("AVSampleFormat") int sample_fmt);
@NoException public static native int av_samples_set_silence(@Cast("uint8_t**") @ByPtrPtr byte[] audio_data, int offset, int nb_samples,
                           int nb_channels, @Cast("AVSampleFormat") int sample_fmt);

/**
 * \}
 * \}
 */
// #endif /* AVUTIL_SAMPLEFMT_H */


// Parsed from <libavutil/channel_layout.h>

/*
 * Copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 * Copyright (c) 2008 Peter Ross
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_CHANNEL_LAYOUT_H
// #define AVUTIL_CHANNEL_LAYOUT_H

// #include <stdint.h>

/**
 * \file
 * audio channel layout utility functions
 */

/**
 * \addtogroup lavu_audio
 * \{
 */

/**
 * \defgroup channel_masks Audio channel masks
 *
 * A channel layout is a 64-bits integer with a bit set for every channel.
 * The number of bits set must be equal to the number of channels.
 * The value 0 means that the channel layout is not known.
 * \note this data structure is not powerful enough to handle channels
 * combinations that have the same channel multiple times, such as
 * dual-mono.
 *
 * \{
 */
public static final long AV_CH_FRONT_LEFT =             0x00000001;
public static final long AV_CH_FRONT_RIGHT =            0x00000002;
public static final long AV_CH_FRONT_CENTER =           0x00000004;
public static final long AV_CH_LOW_FREQUENCY =          0x00000008;
public static final long AV_CH_BACK_LEFT =              0x00000010;
public static final long AV_CH_BACK_RIGHT =             0x00000020;
public static final long AV_CH_FRONT_LEFT_OF_CENTER =   0x00000040;
public static final long AV_CH_FRONT_RIGHT_OF_CENTER =  0x00000080;
public static final long AV_CH_BACK_CENTER =            0x00000100;
public static final long AV_CH_SIDE_LEFT =              0x00000200;
public static final long AV_CH_SIDE_RIGHT =             0x00000400;
public static final long AV_CH_TOP_CENTER =             0x00000800;
public static final long AV_CH_TOP_FRONT_LEFT =         0x00001000;
public static final long AV_CH_TOP_FRONT_CENTER =       0x00002000;
public static final long AV_CH_TOP_FRONT_RIGHT =        0x00004000;
public static final long AV_CH_TOP_BACK_LEFT =          0x00008000;
public static final long AV_CH_TOP_BACK_CENTER =        0x00010000;
public static final long AV_CH_TOP_BACK_RIGHT =         0x00020000;
/** Stereo downmix. */
public static final long AV_CH_STEREO_LEFT =            0x20000000;
/** See AV_CH_STEREO_LEFT. */
public static final long AV_CH_STEREO_RIGHT =           0x40000000;
public static final long AV_CH_WIDE_LEFT =              0x0000000080000000L;
public static final long AV_CH_WIDE_RIGHT =             0x0000000100000000L;
public static final long AV_CH_SURROUND_DIRECT_LEFT =   0x0000000200000000L;
public static final long AV_CH_SURROUND_DIRECT_RIGHT =  0x0000000400000000L;
public static final long AV_CH_LOW_FREQUENCY_2 =        0x0000000800000000L;

/** Channel mask value used for AVCodecContext.request_channel_layout
    to indicate that the user requests the channel order of the decoder output
    to be the native codec channel order. */
public static final long AV_CH_LAYOUT_NATIVE =          0x8000000000000000L;

/**
 * \}
 * \defgroup channel_mask_c Audio channel layouts
 * \{
 * */
public static final long AV_CH_LAYOUT_MONO =              (AV_CH_FRONT_CENTER);
public static final long AV_CH_LAYOUT_STEREO =            (AV_CH_FRONT_LEFT|AV_CH_FRONT_RIGHT);
public static final long AV_CH_LAYOUT_2POINT1 =           (AV_CH_LAYOUT_STEREO|AV_CH_LOW_FREQUENCY);
public static final long AV_CH_LAYOUT_2_1 =               (AV_CH_LAYOUT_STEREO|AV_CH_BACK_CENTER);
public static final long AV_CH_LAYOUT_SURROUND =          (AV_CH_LAYOUT_STEREO|AV_CH_FRONT_CENTER);
public static final long AV_CH_LAYOUT_3POINT1 =           (AV_CH_LAYOUT_SURROUND|AV_CH_LOW_FREQUENCY);
public static final long AV_CH_LAYOUT_4POINT0 =           (AV_CH_LAYOUT_SURROUND|AV_CH_BACK_CENTER);
public static final long AV_CH_LAYOUT_4POINT1 =           (AV_CH_LAYOUT_4POINT0|AV_CH_LOW_FREQUENCY);
public static final long AV_CH_LAYOUT_2_2 =               (AV_CH_LAYOUT_STEREO|AV_CH_SIDE_LEFT|AV_CH_SIDE_RIGHT);
public static final long AV_CH_LAYOUT_QUAD =              (AV_CH_LAYOUT_STEREO|AV_CH_BACK_LEFT|AV_CH_BACK_RIGHT);
public static final long AV_CH_LAYOUT_5POINT0 =           (AV_CH_LAYOUT_SURROUND|AV_CH_SIDE_LEFT|AV_CH_SIDE_RIGHT);
public static final long AV_CH_LAYOUT_5POINT1 =           (AV_CH_LAYOUT_5POINT0|AV_CH_LOW_FREQUENCY);
public static final long AV_CH_LAYOUT_5POINT0_BACK =      (AV_CH_LAYOUT_SURROUND|AV_CH_BACK_LEFT|AV_CH_BACK_RIGHT);
public static final long AV_CH_LAYOUT_5POINT1_BACK =      (AV_CH_LAYOUT_5POINT0_BACK|AV_CH_LOW_FREQUENCY);
public static final long AV_CH_LAYOUT_6POINT0 =           (AV_CH_LAYOUT_5POINT0|AV_CH_BACK_CENTER);
public static final long AV_CH_LAYOUT_6POINT0_FRONT =     (AV_CH_LAYOUT_2_2|AV_CH_FRONT_LEFT_OF_CENTER|AV_CH_FRONT_RIGHT_OF_CENTER);
public static final long AV_CH_LAYOUT_HEXAGONAL =         (AV_CH_LAYOUT_5POINT0_BACK|AV_CH_BACK_CENTER);
public static final long AV_CH_LAYOUT_6POINT1 =           (AV_CH_LAYOUT_5POINT1|AV_CH_BACK_CENTER);
public static final long AV_CH_LAYOUT_6POINT1_BACK =      (AV_CH_LAYOUT_5POINT1_BACK|AV_CH_BACK_CENTER);
public static final long AV_CH_LAYOUT_6POINT1_FRONT =     (AV_CH_LAYOUT_6POINT0_FRONT|AV_CH_LOW_FREQUENCY);
public static final long AV_CH_LAYOUT_7POINT0 =           (AV_CH_LAYOUT_5POINT0|AV_CH_BACK_LEFT|AV_CH_BACK_RIGHT);
public static final long AV_CH_LAYOUT_7POINT0_FRONT =     (AV_CH_LAYOUT_5POINT0|AV_CH_FRONT_LEFT_OF_CENTER|AV_CH_FRONT_RIGHT_OF_CENTER);
public static final long AV_CH_LAYOUT_7POINT1 =           (AV_CH_LAYOUT_5POINT1|AV_CH_BACK_LEFT|AV_CH_BACK_RIGHT);
public static final long AV_CH_LAYOUT_7POINT1_WIDE =      (AV_CH_LAYOUT_5POINT1|AV_CH_FRONT_LEFT_OF_CENTER|AV_CH_FRONT_RIGHT_OF_CENTER);
public static final long AV_CH_LAYOUT_7POINT1_WIDE_BACK = (AV_CH_LAYOUT_5POINT1_BACK|AV_CH_FRONT_LEFT_OF_CENTER|AV_CH_FRONT_RIGHT_OF_CENTER);
public static final long AV_CH_LAYOUT_OCTAGONAL =         (AV_CH_LAYOUT_5POINT0|AV_CH_BACK_LEFT|AV_CH_BACK_CENTER|AV_CH_BACK_RIGHT);
public static final long AV_CH_LAYOUT_HEXADECAGONAL =     (AV_CH_LAYOUT_OCTAGONAL|AV_CH_WIDE_LEFT|AV_CH_WIDE_RIGHT|AV_CH_TOP_BACK_LEFT|AV_CH_TOP_BACK_RIGHT|AV_CH_TOP_BACK_CENTER|AV_CH_TOP_FRONT_CENTER|AV_CH_TOP_FRONT_LEFT|AV_CH_TOP_FRONT_RIGHT);
public static final long AV_CH_LAYOUT_STEREO_DOWNMIX =    (AV_CH_STEREO_LEFT|AV_CH_STEREO_RIGHT);

/** enum AVMatrixEncoding */
public static final int
    AV_MATRIX_ENCODING_NONE = 0,
    AV_MATRIX_ENCODING_DOLBY = 1,
    AV_MATRIX_ENCODING_DPLII = 2,
    AV_MATRIX_ENCODING_DPLIIX = 3,
    AV_MATRIX_ENCODING_DPLIIZ = 4,
    AV_MATRIX_ENCODING_DOLBYEX = 5,
    AV_MATRIX_ENCODING_DOLBYHEADPHONE = 6,
    AV_MATRIX_ENCODING_NB = 7;

/**
 * Return a channel layout id that matches name, or 0 if no match is found.
 *
 * name can be one or several of the following notations,
 * separated by '+' or '|':
 * - the name of an usual channel layout (mono, stereo, 4.0, quad, 5.0,
 *   5.0(side), 5.1, 5.1(side), 7.1, 7.1(wide), downmix);
 * - the name of a single channel (FL, FR, FC, LFE, BL, BR, FLC, FRC, BC,
 *   SL, SR, TC, TFL, TFC, TFR, TBL, TBC, TBR, DL, DR);
 * - a number of channels, in decimal, followed by 'c', yielding
 *   the default channel layout for that number of channels (@see
 *   av_get_default_channel_layout);
 * - a channel layout mask, in hexadecimal starting with "0x" (see the
 *   AV_CH_* macros).
 *
 * Example: "stereo+FC" = "2c+FC" = "2c+1c" = "0x7"
 */
@NoException public static native @Cast("uint64_t") long av_get_channel_layout(@Cast("const char*") BytePointer name);
@NoException public static native @Cast("uint64_t") long av_get_channel_layout(String name);

/**
 * Return a channel layout and the number of channels based on the specified name.
 *
 * This function is similar to (@see av_get_channel_layout), but can also parse
 * unknown channel layout specifications.
 *
 * @param name [in]             channel layout specification string
 * @param channel_layout [out]   parsed channel layout (0 if unknown)
 * @param nb_channels [out]      number of channels
 *
 * @return 0 on success, AVERROR(EINVAL) if the parsing fails.
 */
@NoException public static native int av_get_extended_channel_layout(@Cast("const char*") BytePointer name, @Cast("uint64_t*") LongPointer channel_layout, IntPointer nb_channels);
@NoException public static native int av_get_extended_channel_layout(String name, @Cast("uint64_t*") LongBuffer channel_layout, IntBuffer nb_channels);
@NoException public static native int av_get_extended_channel_layout(@Cast("const char*") BytePointer name, @Cast("uint64_t*") long[] channel_layout, int[] nb_channels);
@NoException public static native int av_get_extended_channel_layout(String name, @Cast("uint64_t*") LongPointer channel_layout, IntPointer nb_channels);
@NoException public static native int av_get_extended_channel_layout(@Cast("const char*") BytePointer name, @Cast("uint64_t*") LongBuffer channel_layout, IntBuffer nb_channels);
@NoException public static native int av_get_extended_channel_layout(String name, @Cast("uint64_t*") long[] channel_layout, int[] nb_channels);

/**
 * Return a description of a channel layout.
 * If nb_channels is <= 0, it is guessed from the channel_layout.
 *
 * @param buf put here the string containing the channel layout
 * @param buf_size size in bytes of the buffer
 */
@NoException public static native void av_get_channel_layout_string(@Cast("char*") BytePointer buf, int buf_size, int nb_channels, @Cast("uint64_t") long channel_layout);
@NoException public static native void av_get_channel_layout_string(@Cast("char*") ByteBuffer buf, int buf_size, int nb_channels, @Cast("uint64_t") long channel_layout);
@NoException public static native void av_get_channel_layout_string(@Cast("char*") byte[] buf, int buf_size, int nb_channels, @Cast("uint64_t") long channel_layout);
/**
 * Append a description of a channel layout to a bprint buffer.
 */
@NoException public static native void av_bprint_channel_layout(AVBPrint bp, int nb_channels, @Cast("uint64_t") long channel_layout);

/**
 * Return the number of channels in the channel layout.
 */
@NoException public static native int av_get_channel_layout_nb_channels(@Cast("uint64_t") long channel_layout);

/**
 * Return default channel layout for a given number of channels.
 */
@NoException public static native @Cast("int64_t") long av_get_default_channel_layout(int nb_channels);

/**
 * Get the index of a channel in channel_layout.
 *
 * @param channel a channel layout describing exactly one channel which must be
 *                present in channel_layout.
 *
 * @return index of channel in channel_layout on success, a negative AVERROR
 *         on error.
 */
@NoException public static native int av_get_channel_layout_channel_index(@Cast("uint64_t") long channel_layout,
                                        @Cast("uint64_t") long channel);

/**
 * Get the channel with the given index in channel_layout.
 */
@NoException public static native @Cast("uint64_t") long av_channel_layout_extract_channel(@Cast("uint64_t") long channel_layout, int index);

/**
 * Get the name of a given channel.
 *
 * @return channel name on success, NULL on error.
 */
@NoException public static native @Cast("const char*") BytePointer av_get_channel_name(@Cast("uint64_t") long channel);

/**
 * Get the description of a given channel.
 *
 * @param channel  a channel layout with a single channel
 * @return  channel description on success, NULL on error
 */
@NoException public static native @Cast("const char*") BytePointer av_get_channel_description(@Cast("uint64_t") long channel);

/**
 * Get the value and name of a standard channel layout.
 *
 * @param index [in]   index in an internal list, starting at 0
 * @param layout [out]  channel layout mask
 * @param name [out]    name of the layout
 * @return  0  if the layout exists,
 *          <0 if index is beyond the limits
 */
@NoException public static native int av_get_standard_channel_layout(@Cast("unsigned") int index, @Cast("uint64_t*") LongPointer layout,
                                   @Cast("const char**") PointerPointer name);
@NoException public static native int av_get_standard_channel_layout(@Cast("unsigned") int index, @Cast("uint64_t*") LongPointer layout,
                                   @Cast("const char**") @ByPtrPtr BytePointer name);
@NoException public static native int av_get_standard_channel_layout(@Cast("unsigned") int index, @Cast("uint64_t*") LongBuffer layout,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer name);
@NoException public static native int av_get_standard_channel_layout(@Cast("unsigned") int index, @Cast("uint64_t*") long[] layout,
                                   @Cast("const char**") @ByPtrPtr byte[] name);

/**
 * \}
 * \}
 */

// #endif /* AVUTIL_CHANNEL_LAYOUT_H */


// Parsed from <libavutil/cpu.h>

/*
 * Copyright (c) 2000, 2001, 2002 Fabrice Bellard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_CPU_H
// #define AVUTIL_CPU_H

// #include <stddef.h>

// #include "attributes.h"

public static final int AV_CPU_FLAG_FORCE =    0x80000000; /* force usage of selected flags (OR) */

    /* lower 16 bits - CPU features */
/** standard MMX */
public static final int AV_CPU_FLAG_MMX =          0x0001;
/** SSE integer functions or AMD MMX ext */
public static final int AV_CPU_FLAG_MMXEXT =       0x0002;
/** SSE integer functions or AMD MMX ext */
public static final int AV_CPU_FLAG_MMX2 =         0x0002;
/** AMD 3DNOW */
public static final int AV_CPU_FLAG_3DNOW =        0x0004;
/** SSE functions */
public static final int AV_CPU_FLAG_SSE =          0x0008;
/** PIV SSE2 functions */
public static final int AV_CPU_FLAG_SSE2 =         0x0010;
/** SSE2 supported, but usually not faster
 *  than regular MMX/SSE (e.g. Core1) */
public static final int AV_CPU_FLAG_SSE2SLOW = 0x40000000;
/** AMD 3DNowExt */
public static final int AV_CPU_FLAG_3DNOWEXT =     0x0020;
/** Prescott SSE3 functions */
public static final int AV_CPU_FLAG_SSE3 =         0x0040;
/** SSE3 supported, but usually not faster
 *  than regular MMX/SSE (e.g. Core1) */
public static final int AV_CPU_FLAG_SSE3SLOW = 0x20000000;
/** Conroe SSSE3 functions */
public static final int AV_CPU_FLAG_SSSE3 =        0x0080;
/** SSSE3 supported, but usually not faster */
public static final int AV_CPU_FLAG_SSSE3SLOW = 0x4000000;
/** Atom processor, some SSSE3 instructions are slower */
public static final int AV_CPU_FLAG_ATOM =     0x10000000;
/** Penryn SSE4.1 functions */
public static final int AV_CPU_FLAG_SSE4 =         0x0100;
/** Nehalem SSE4.2 functions */
public static final int AV_CPU_FLAG_SSE42 =        0x0200;
/** Advanced Encryption Standard functions */
public static final int AV_CPU_FLAG_AESNI =       0x80000;
/** AVX functions: requires OS support even if YMM registers aren't used */
public static final int AV_CPU_FLAG_AVX =          0x4000;
/** AVX supported, but slow when using YMM registers (e.g. Bulldozer) */
public static final int AV_CPU_FLAG_AVXSLOW =   0x8000000;
/** Bulldozer XOP functions */
public static final int AV_CPU_FLAG_XOP =          0x0400;
/** Bulldozer FMA4 functions */
public static final int AV_CPU_FLAG_FMA4 =         0x0800;
/** supports cmov instruction */
public static final int AV_CPU_FLAG_CMOV =         0x1000;
/** AVX2 functions: requires OS support even if YMM registers aren't used */
public static final int AV_CPU_FLAG_AVX2 =         0x8000;
/** Haswell FMA3 functions */
public static final int AV_CPU_FLAG_FMA3 =        0x10000;
/** Bit Manipulation Instruction Set 1 */
public static final int AV_CPU_FLAG_BMI1 =        0x20000;
/** Bit Manipulation Instruction Set 2 */
public static final int AV_CPU_FLAG_BMI2 =        0x40000;
/** AVX-512 functions: requires OS support even if YMM/ZMM registers aren't used */
public static final int AV_CPU_FLAG_AVX512 =     0x100000;

/** standard */
public static final int AV_CPU_FLAG_ALTIVEC =      0x0001;
/** ISA 2.06 */
public static final int AV_CPU_FLAG_VSX =          0x0002;
/** ISA 2.07 */
public static final int AV_CPU_FLAG_POWER8 =       0x0004;

public static final int AV_CPU_FLAG_ARMV5TE =      (1 << 0);
public static final int AV_CPU_FLAG_ARMV6 =        (1 << 1);
public static final int AV_CPU_FLAG_ARMV6T2 =      (1 << 2);
public static final int AV_CPU_FLAG_VFP =          (1 << 3);
public static final int AV_CPU_FLAG_VFPV3 =        (1 << 4);
public static final int AV_CPU_FLAG_NEON =         (1 << 5);
public static final int AV_CPU_FLAG_ARMV8 =        (1 << 6);
/** VFPv2 vector mode, deprecated in ARMv7-A and unavailable in various CPUs implementations */
public static final int AV_CPU_FLAG_VFP_VM =       (1 << 7);
public static final int AV_CPU_FLAG_SETEND =       (1 <<16);

/**
 * Return the flags which specify extensions supported by the CPU.
 * The returned value is affected by av_force_cpu_flags() if that was used
 * before. So av_get_cpu_flags() can easily be used in an application to
 * detect the enabled cpu flags.
 */
@NoException public static native int av_get_cpu_flags();

/**
 * Disables cpu detection and forces the specified flags.
 * -1 is a special case that disables forcing of specific flags.
 */
@NoException public static native void av_force_cpu_flags(int flags);

/**
 * Set a mask on flags returned by av_get_cpu_flags().
 * This function is mainly useful for testing.
 * Please use av_force_cpu_flags() and av_get_cpu_flags() instead which are more flexible
 */
@NoException public static native @Deprecated void av_set_cpu_flags_mask(int mask);

/**
 * Parse CPU flags from a string.
 *
 * The returned flags contain the specified flags as well as related unspecified flags.
 *
 * This function exists only for compatibility with libav.
 * Please use av_parse_cpu_caps() when possible.
 * @return a combination of AV_CPU_* flags, negative on error.
 */
@NoException public static native @Deprecated int av_parse_cpu_flags(@Cast("const char*") BytePointer s);
@NoException public static native @Deprecated int av_parse_cpu_flags(String s);

/**
 * Parse CPU caps from a string and update the given AV_CPU_* flags based on that.
 *
 * @return negative on error.
 */
@NoException public static native int av_parse_cpu_caps(@Cast("unsigned*") IntPointer flags, @Cast("const char*") BytePointer s);
@NoException public static native int av_parse_cpu_caps(@Cast("unsigned*") IntBuffer flags, String s);
@NoException public static native int av_parse_cpu_caps(@Cast("unsigned*") int[] flags, @Cast("const char*") BytePointer s);
@NoException public static native int av_parse_cpu_caps(@Cast("unsigned*") IntPointer flags, String s);
@NoException public static native int av_parse_cpu_caps(@Cast("unsigned*") IntBuffer flags, @Cast("const char*") BytePointer s);
@NoException public static native int av_parse_cpu_caps(@Cast("unsigned*") int[] flags, String s);

/**
 * @return the number of logical CPU cores present.
 */
@NoException public static native int av_cpu_count();

/**
 * Get the maximum data alignment that may be required by FFmpeg.
 *
 * Note that this is affected by the build configuration and the CPU flags mask,
 * so e.g. if the CPU supports AVX, but libavutil has been built with
 * --disable-avx or the AV_CPU_FLAG_AVX flag has been disabled through
 *  av_set_cpu_flags_mask(), then this function will behave as if AVX is not
 *  present.
 */
@NoException public static native @Cast("size_t") long av_cpu_max_align();

// #endif /* AVUTIL_CPU_H */


// Parsed from <libavutil/dict.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * Public dictionary API.
 * @deprecated
 *  AVDictionary is provided for compatibility with libav. It is both in
 *  implementation as well as API inefficient. It does not scale and is
 *  extremely slow with large dictionaries.
 *  It is recommended that new code uses our tree container from tree.c/h
 *  where applicable, which uses AVL trees to achieve O(log n) performance.
 */

// #ifndef AVUTIL_DICT_H
// #define AVUTIL_DICT_H

// #include <stdint.h>

// #include "version.h"

/**
 * \addtogroup lavu_dict AVDictionary
 * \ingroup lavu_data
 *
 * \brief Simple key:value store
 *
 * \{
 * Dictionaries are used for storing key:value pairs. To create
 * an AVDictionary, simply pass an address of a NULL pointer to
 * av_dict_set(). NULL can be used as an empty dictionary wherever
 * a pointer to an AVDictionary is required.
 * Use av_dict_get() to retrieve an entry or iterate over all
 * entries and finally av_dict_free() to free the dictionary
 * and all its contents.
 *
 <pre>{@code
   AVDictionary *d = NULL;           // "create" an empty dictionary
   AVDictionaryEntry *t = NULL;

   av_dict_set(&d, "foo", "bar", 0); // add an entry

   char *k = av_strdup("key");       // if your strings are already allocated,
   char *v = av_strdup("value");     // you can avoid copying them like this
   av_dict_set(&d, k, v, AV_DICT_DONT_STRDUP_KEY | AV_DICT_DONT_STRDUP_VAL);

   while (t = av_dict_get(d, "", t, AV_DICT_IGNORE_SUFFIX)) {
       <....>                             // iterate over all entries in d
   }
   av_dict_free(&d);
 }</pre>
 */

/** Only get an entry with exact-case key match. Only relevant in av_dict_get(). */
public static final int AV_DICT_MATCH_CASE =      1;
/** Return first entry in a dictionary whose first part corresponds to the search key,
                                         ignoring the suffix of the found key string. Only relevant in av_dict_get(). */
public static final int AV_DICT_IGNORE_SUFFIX =   2;
/** Take ownership of a key that's been
                                         allocated with av_malloc() or another memory allocation function. */
public static final int AV_DICT_DONT_STRDUP_KEY = 4;
/** Take ownership of a value that's been
                                         allocated with av_malloc() or another memory allocation function. */
public static final int AV_DICT_DONT_STRDUP_VAL = 8;
/** Don't overwrite existing entries. */
public static final int AV_DICT_DONT_OVERWRITE = 16;
/** If the entry already exists, append to it.  Note that no
                                      delimiter is added, the strings are simply concatenated. */
public static final int AV_DICT_APPEND =         32;
/** Allow to store several equal keys in the dictionary */
public static final int AV_DICT_MULTIKEY =       64;
// Targeting ..\avutil\AVDictionaryEntry.java


// Targeting ..\avutil\AVDictionary.java



/**
 * Get a dictionary entry with matching key.
 *
 * The returned entry key or value must not be changed, or it will
 * cause undefined behavior.
 *
 * To iterate through all the dictionary entries, you can set the matching key
 * to the null string "" and set the AV_DICT_IGNORE_SUFFIX flag.
 *
 * @param prev Set to the previous matching element to find the next.
 *             If set to NULL the first matching element is returned.
 * @param key matching key
 * @param flags a collection of AV_DICT_* flags controlling how the entry is retrieved
 * @return found entry or NULL in case no matching entry was found in the dictionary
 */
@NoException public static native AVDictionaryEntry av_dict_get(@Const AVDictionary m, @Cast("const char*") BytePointer key,
                               @Const AVDictionaryEntry prev, int flags);
@NoException public static native AVDictionaryEntry av_dict_get(@Const AVDictionary m, String key,
                               @Const AVDictionaryEntry prev, int flags);

/**
 * Get number of entries in dictionary.
 *
 * @param m dictionary
 * @return  number of entries in dictionary
 */
@NoException public static native int av_dict_count(@Const AVDictionary m);

/**
 * Set the given entry in *pm, overwriting an existing entry.
 *
 * Note: If AV_DICT_DONT_STRDUP_KEY or AV_DICT_DONT_STRDUP_VAL is set,
 * these arguments will be freed on error.
 *
 * Warning: Adding a new entry to a dictionary invalidates all existing entries
 * previously returned with av_dict_get.
 *
 * @param pm pointer to a pointer to a dictionary struct. If *pm is NULL
 * a dictionary struct is allocated and put in *pm.
 * @param key entry key to add to *pm (will either be av_strduped or added as a new key depending on flags)
 * @param value entry value to add to *pm (will be av_strduped or added as a new key depending on flags).
 *        Passing a NULL value will cause an existing entry to be deleted.
 * @return >= 0 on success otherwise an error code <0
 */
@NoException public static native int av_dict_set(@Cast("AVDictionary**") PointerPointer pm, @Cast("const char*") BytePointer key, @Cast("const char*") BytePointer value, int flags);
@NoException public static native int av_dict_set(@ByPtrPtr AVDictionary pm, @Cast("const char*") BytePointer key, @Cast("const char*") BytePointer value, int flags);
@NoException public static native int av_dict_set(@ByPtrPtr AVDictionary pm, String key, String value, int flags);

/**
 * Convenience wrapper for av_dict_set that converts the value to a string
 * and stores it.
 *
 * Note: If AV_DICT_DONT_STRDUP_KEY is set, key will be freed on error.
 */
@NoException public static native int av_dict_set_int(@Cast("AVDictionary**") PointerPointer pm, @Cast("const char*") BytePointer key, @Cast("int64_t") long value, int flags);
@NoException public static native int av_dict_set_int(@ByPtrPtr AVDictionary pm, @Cast("const char*") BytePointer key, @Cast("int64_t") long value, int flags);
@NoException public static native int av_dict_set_int(@ByPtrPtr AVDictionary pm, String key, @Cast("int64_t") long value, int flags);

/**
 * Parse the key/value pairs list and add the parsed entries to a dictionary.
 *
 * In case of failure, all the successfully set entries are stored in
 * *pm. You may need to manually free the created dictionary.
 *
 * @param key_val_sep  a 0-terminated list of characters used to separate
 *                     key from value
 * @param pairs_sep    a 0-terminated list of characters used to separate
 *                     two pairs from each other
 * @param flags        flags to use when adding to dictionary.
 *                     AV_DICT_DONT_STRDUP_KEY and AV_DICT_DONT_STRDUP_VAL
 *                     are ignored since the key/value tokens will always
 *                     be duplicated.
 * @return             0 on success, negative AVERROR code on failure
 */
@NoException public static native int av_dict_parse_string(@Cast("AVDictionary**") PointerPointer pm, @Cast("const char*") BytePointer str,
                         @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep,
                         int flags);
@NoException public static native int av_dict_parse_string(@ByPtrPtr AVDictionary pm, @Cast("const char*") BytePointer str,
                         @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep,
                         int flags);
@NoException public static native int av_dict_parse_string(@ByPtrPtr AVDictionary pm, String str,
                         String key_val_sep, String pairs_sep,
                         int flags);

/**
 * Copy entries from one AVDictionary struct into another.
 * @param dst pointer to a pointer to a AVDictionary struct. If *dst is NULL,
 *            this function will allocate a struct for you and put it in *dst
 * @param src pointer to source AVDictionary struct
 * @param flags flags to use when setting entries in *dst
 * \note metadata is read using the AV_DICT_IGNORE_SUFFIX flag
 * @return 0 on success, negative AVERROR code on failure. If dst was allocated
 *           by this function, callers should free the associated memory.
 */
@NoException public static native int av_dict_copy(@Cast("AVDictionary**") PointerPointer dst, @Const AVDictionary src, int flags);
@NoException public static native int av_dict_copy(@ByPtrPtr AVDictionary dst, @Const AVDictionary src, int flags);

/**
 * Free all the memory allocated for an AVDictionary struct
 * and all keys and values.
 */
@NoException public static native void av_dict_free(@Cast("AVDictionary**") PointerPointer m);
@NoException public static native void av_dict_free(@ByPtrPtr AVDictionary m);

/**
 * Get dictionary entries as a string.
 *
 * Create a string containing dictionary's entries.
 * Such string may be passed back to av_dict_parse_string().
 * \note String is escaped with backslashes ('\').
 *
 * @param m [in]             dictionary
 * @param buffer [out]        Pointer to buffer that will be allocated with string containg entries.
 *                           Buffer must be freed by the caller when is no longer needed.
 * @param key_val_sep [in]   character used to separate key from value
 * @param pairs_sep [in]     character used to separate two pairs from each other
 * @return                   >= 0 on success, negative on error
 * \warning Separators cannot be neither '\' nor '\0'. They also cannot be the same.
 */
@NoException public static native int av_dict_get_string(@Const AVDictionary m, @Cast("char**") PointerPointer buffer,
                       byte key_val_sep, byte pairs_sep);
@NoException public static native int av_dict_get_string(@Const AVDictionary m, @Cast("char**") @ByPtrPtr BytePointer buffer,
                       byte key_val_sep, byte pairs_sep);
@NoException public static native int av_dict_get_string(@Const AVDictionary m, @Cast("char**") @ByPtrPtr ByteBuffer buffer,
                       byte key_val_sep, byte pairs_sep);
@NoException public static native int av_dict_get_string(@Const AVDictionary m, @Cast("char**") @ByPtrPtr byte[] buffer,
                       byte key_val_sep, byte pairs_sep);

/**
 * \}
 */

// #endif /* AVUTIL_DICT_H */


// Parsed from <libavutil/opt.h>

/*
 * AVOptions
 * copyright (c) 2005 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_OPT_H
// #define AVUTIL_OPT_H

/**
 * \file
 * AVOptions
 */

// #include "rational.h"
// #include "avutil.h"
// #include "dict.h"
// #include "log.h"
// #include "pixfmt.h"
// #include "samplefmt.h"
// #include "version.h"

/**
 * \defgroup avoptions AVOptions
 * \ingroup lavu_data
 * \{
 * AVOptions provide a generic system to declare options on arbitrary structs
 * ("objects"). An option can have a help text, a type and a range of possible
 * values. Options may then be enumerated, read and written to.
 *
 * \section avoptions_implement Implementing AVOptions
 * This section describes how to add AVOptions capabilities to a struct.
 *
 * All AVOptions-related information is stored in an AVClass. Therefore
 * the first member of the struct should be a pointer to an AVClass describing it.
 * The option field of the AVClass must be set to a NULL-terminated static array
 * of AVOptions. Each AVOption must have a non-empty name, a type, a default
 * value and for number-type AVOptions also a range of allowed values. It must
 * also declare an offset in bytes from the start of the struct, where the field
 * associated with this AVOption is located. Other fields in the AVOption struct
 * should also be set when applicable, but are not required.
 *
 * The following example illustrates an AVOptions-enabled struct:
 * <pre>{@code
 * typedef struct test_struct {
 *     const AVClass *class;
 *     int      int_opt;
 *     char    *str_opt;
 *     uint8_t *bin_opt;
 *     int      bin_len;
 * } test_struct;
 *
 * static const AVOption test_options[] = {
 *   { "test_int", "This is a test option of int type.", offsetof(test_struct, int_opt),
 *     AV_OPT_TYPE_INT, { .i64 = -1 }, INT_MIN, INT_MAX },
 *   { "test_str", "This is a test option of string type.", offsetof(test_struct, str_opt),
 *     AV_OPT_TYPE_STRING },
 *   { "test_bin", "This is a test option of binary type.", offsetof(test_struct, bin_opt),
 *     AV_OPT_TYPE_BINARY },
 *   { NULL },
 * };
 *
 * static const AVClass test_class = {
 *     .class_name = "test class",
 *     .item_name  = av_default_item_name,
 *     .option     = test_options,
 *     .version    = LIBAVUTIL_VERSION_INT,
 * };
 * }</pre>
 *
 * Next, when allocating your struct, you must ensure that the AVClass pointer
 * is set to the correct value. Then, av_opt_set_defaults() can be called to
 * initialize defaults. After that the struct is ready to be used with the
 * AVOptions API.
 *
 * When cleaning up, you may use the av_opt_free() function to automatically
 * free all the allocated string and binary options.
 *
 * Continuing with the above example:
 *
 * <pre>{@code
 * test_struct *alloc_test_struct(void)
 * {
 *     test_struct *ret = av_mallocz(sizeof(*ret));
 *     ret->class = &test_class;
 *     av_opt_set_defaults(ret);
 *     return ret;
 * }
 * void free_test_struct(test_struct **foo)
 * {
 *     av_opt_free(*foo);
 *     av_freep(foo);
 * }
 * }</pre>
 *
 * \subsection avoptions_implement_nesting Nesting
 *      It may happen that an AVOptions-enabled struct contains another
 *      AVOptions-enabled struct as a member (e.g. AVCodecContext in
 *      libavcodec exports generic options, while its priv_data field exports
 *      codec-specific options). In such a case, it is possible to set up the
 *      parent struct to export a child's options. To do that, simply
 *      implement AVClass.child_next() and AVClass.child_class_next() in the
 *      parent struct's AVClass.
 *      Assuming that the test_struct from above now also contains a
 *      child_struct field:
 *
 *      <pre>{@code
 *      typedef struct child_struct {
 *          AVClass *class;
 *          int flags_opt;
 *      } child_struct;
 *      static const AVOption child_opts[] = {
 *          { "test_flags", "This is a test option of flags type.",
 *            offsetof(child_struct, flags_opt), AV_OPT_TYPE_FLAGS, { .i64 = 0 }, INT_MIN, INT_MAX },
 *          { NULL },
 *      };
 *      static const AVClass child_class = {
 *          .class_name = "child class",
 *          .item_name  = av_default_item_name,
 *          .option     = child_opts,
 *          .version    = LIBAVUTIL_VERSION_INT,
 *      };
 *
 *      void *child_next(void *obj, void *prev)
 *      {
 *          test_struct *t = obj;
 *          if (!prev && t->child_struct)
 *              return t->child_struct;
 *          return NULL
 *      }
 *      const AVClass child_class_next(const AVClass *prev)
 *      {
 *          return prev ? NULL : &child_class;
 *      }
 *      }</pre>
 *      Putting child_next() and child_class_next() as defined above into
 *      test_class will now make child_struct's options accessible through
 *      test_struct (again, proper setup as described above needs to be done on
 *      child_struct right after it is created).
 *
 *      From the above example it might not be clear why both child_next()
 *      and child_class_next() are needed. The distinction is that child_next()
 *      iterates over actually existing objects, while child_class_next()
 *      iterates over all possible child classes. E.g. if an AVCodecContext
 *      was initialized to use a codec which has private options, then its
 *      child_next() will return AVCodecContext.priv_data and finish
 *      iterating. OTOH child_class_next() on AVCodecContext.av_class will
 *      iterate over all available codecs with private options.
 *
 * \subsection avoptions_implement_named_constants Named constants
 *      It is possible to create named constants for options. Simply set the unit
 *      field of the option the constants should apply to a string and
 *      create the constants themselves as options of type AV_OPT_TYPE_CONST
 *      with their unit field set to the same string.
 *      Their default_val field should contain the value of the named
 *      constant.
 *      For example, to add some named constants for the test_flags option
 *      above, put the following into the child_opts array:
 *      <pre>{@code
 *      { "test_flags", "This is a test option of flags type.",
 *        offsetof(child_struct, flags_opt), AV_OPT_TYPE_FLAGS, { .i64 = 0 }, INT_MIN, INT_MAX, "test_unit" },
 *      { "flag1", "This is a flag with value 16", 0, AV_OPT_TYPE_CONST, { .i64 = 16 }, 0, 0, "test_unit" },
 *      }</pre>
 *
 * \section avoptions_use Using AVOptions
 * This section deals with accessing options in an AVOptions-enabled struct.
 * Such structs in FFmpeg are e.g. AVCodecContext in libavcodec or
 * AVFormatContext in libavformat.
 *
 * \subsection avoptions_use_examine Examining AVOptions
 * The basic functions for examining options are av_opt_next(), which iterates
 * over all options defined for one object, and av_opt_find(), which searches
 * for an option with the given name.
 *
 * The situation is more complicated with nesting. An AVOptions-enabled struct
 * may have AVOptions-enabled children. Passing the AV_OPT_SEARCH_CHILDREN flag
 * to av_opt_find() will make the function search children recursively.
 *
 * For enumerating there are basically two cases. The first is when you want to
 * get all options that may potentially exist on the struct and its children
 * (e.g.  when constructing documentation). In that case you should call
 * av_opt_child_class_next() recursively on the parent struct's AVClass.  The
 * second case is when you have an already initialized struct with all its
 * children and you want to get all options that can be actually written or read
 * from it. In that case you should call av_opt_child_next() recursively (and
 * av_opt_next() on each result).
 *
 * \subsection avoptions_use_get_set Reading and writing AVOptions
 * When setting options, you often have a string read directly from the
 * user. In such a case, simply passing it to av_opt_set() is enough. For
 * non-string type options, av_opt_set() will parse the string according to the
 * option type.
 *
 * Similarly av_opt_get() will read any option type and convert it to a string
 * which will be returned. Do not forget that the string is allocated, so you
 * have to free it with av_free().
 *
 * In some cases it may be more convenient to put all options into an
 * AVDictionary and call av_opt_set_dict() on it. A specific case of this
 * are the format/codec open functions in lavf/lavc which take a dictionary
 * filled with option as a parameter. This makes it possible to set some options
 * that cannot be set otherwise, since e.g. the input file format is not known
 * before the file is actually opened.
 */

/** enum AVOptionType */
public static final int
    AV_OPT_TYPE_FLAGS = 0,
    AV_OPT_TYPE_INT = 1,
    AV_OPT_TYPE_INT64 = 2,
    AV_OPT_TYPE_DOUBLE = 3,
    AV_OPT_TYPE_FLOAT = 4,
    AV_OPT_TYPE_STRING = 5,
    AV_OPT_TYPE_RATIONAL = 6,
    /** offset must point to a pointer immediately followed by an int for the length */
    AV_OPT_TYPE_BINARY = 7,
    AV_OPT_TYPE_DICT = 8,
    AV_OPT_TYPE_UINT64 = 9,
    AV_OPT_TYPE_CONST = 10,
    /** offset must point to two consecutive integers */
    AV_OPT_TYPE_IMAGE_SIZE = 11,
    AV_OPT_TYPE_PIXEL_FMT = 12,
    AV_OPT_TYPE_SAMPLE_FMT = 13,
    /** offset must point to AVRational */
    AV_OPT_TYPE_VIDEO_RATE = 14,
    AV_OPT_TYPE_DURATION = 15,
    AV_OPT_TYPE_COLOR = 16,
    AV_OPT_TYPE_CHANNEL_LAYOUT = 17,
    AV_OPT_TYPE_BOOL = 18;
// Targeting ..\avutil\AVOption.java


// Targeting ..\avutil\AVOptionRange.java


// Targeting ..\avutil\AVOptionRanges.java



/**
 * Show the obj options.
 *
 * @param req_flags requested flags for the options to show. Show only the
 * options for which it is opt->flags & req_flags.
 * @param rej_flags rejected flags for the options to show. Show only the
 * options for which it is !(opt->flags & req_flags).
 * @param av_log_obj log context to use for showing the options
 */
@NoException public static native int av_opt_show2(Pointer obj, Pointer av_log_obj, int req_flags, int rej_flags);

/**
 * Set the values of all AVOption fields to their default values.
 *
 * @param s an AVOption-enabled struct (its first member must be a pointer to AVClass)
 */
@NoException public static native void av_opt_set_defaults(Pointer s);

/**
 * Set the values of all AVOption fields to their default values. Only these
 * AVOption fields for which (opt->flags & mask) == flags will have their
 * default applied to s.
 *
 * @param s an AVOption-enabled struct (its first member must be a pointer to AVClass)
 * @param mask combination of AV_OPT_FLAG_*
 * @param flags combination of AV_OPT_FLAG_*
 */
@NoException public static native void av_opt_set_defaults2(Pointer s, int mask, int flags);

/**
 * Parse the key/value pairs list in opts. For each key/value pair
 * found, stores the value in the field in ctx that is named like the
 * key. ctx must be an AVClass context, storing is done using
 * AVOptions.
 *
 * @param opts options string to parse, may be NULL
 * @param key_val_sep a 0-terminated list of characters used to
 * separate key from value
 * @param pairs_sep a 0-terminated list of characters used to separate
 * two pairs from each other
 * @return the number of successfully set key/value pairs, or a negative
 * value corresponding to an AVERROR code in case of error:
 * AVERROR(EINVAL) if opts cannot be parsed,
 * the error code issued by av_opt_set() if a key/value pair
 * cannot be set
 */
@NoException public static native int av_set_options_string(Pointer ctx, @Cast("const char*") BytePointer opts,
                          @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep);
@NoException public static native int av_set_options_string(Pointer ctx, String opts,
                          String key_val_sep, String pairs_sep);

/**
 * Parse the key-value pairs list in opts. For each key=value pair found,
 * set the value of the corresponding option in ctx.
 *
 * @param ctx          the AVClass object to set options on
 * @param opts         the options string, key-value pairs separated by a
 *                     delimiter
 * @param shorthand    a NULL-terminated array of options names for shorthand
 *                     notation: if the first field in opts has no key part,
 *                     the key is taken from the first element of shorthand;
 *                     then again for the second, etc., until either opts is
 *                     finished, shorthand is finished or a named option is
 *                     found; after that, all options must be named
 * @param key_val_sep  a 0-terminated list of characters used to separate
 *                     key from value, for example '='
 * @param pairs_sep    a 0-terminated list of characters used to separate
 *                     two pairs from each other, for example ':' or ','
 * @return  the number of successfully set key=value pairs, or a negative
 *          value corresponding to an AVERROR code in case of error:
 *          AVERROR(EINVAL) if opts cannot be parsed,
 *          the error code issued by av_set_string3() if a key/value pair
 *          cannot be set
 *
 * Options names must use only the following characters: a-z A-Z 0-9 - . / _
 * Separators must use characters distinct from option names and from each
 * other.
 */
@NoException public static native int av_opt_set_from_string(Pointer ctx, @Cast("const char*") BytePointer opts,
                           @Cast("const char*const*") PointerPointer shorthand,
                           @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep);
@NoException public static native int av_opt_set_from_string(Pointer ctx, @Cast("const char*") BytePointer opts,
                           @Cast("const char*const*") @ByPtrPtr BytePointer shorthand,
                           @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep);
@NoException public static native int av_opt_set_from_string(Pointer ctx, String opts,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer shorthand,
                           String key_val_sep, String pairs_sep);
@NoException public static native int av_opt_set_from_string(Pointer ctx, @Cast("const char*") BytePointer opts,
                           @Cast("const char*const*") @ByPtrPtr byte[] shorthand,
                           @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep);
@NoException public static native int av_opt_set_from_string(Pointer ctx, String opts,
                           @Cast("const char*const*") @ByPtrPtr BytePointer shorthand,
                           String key_val_sep, String pairs_sep);
@NoException public static native int av_opt_set_from_string(Pointer ctx, @Cast("const char*") BytePointer opts,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer shorthand,
                           @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep);
@NoException public static native int av_opt_set_from_string(Pointer ctx, String opts,
                           @Cast("const char*const*") @ByPtrPtr byte[] shorthand,
                           String key_val_sep, String pairs_sep);
/**
 * Free all allocated objects in obj.
 */
@NoException public static native void av_opt_free(Pointer obj);

/**
 * Check whether a particular flag is set in a flags field.
 *
 * @param field_name the name of the flag field option
 * @param flag_name the name of the flag to check
 * @return non-zero if the flag is set, zero if the flag isn't set,
 *         isn't of the right type, or the flags field doesn't exist.
 */
@NoException public static native int av_opt_flag_is_set(Pointer obj, @Cast("const char*") BytePointer field_name, @Cast("const char*") BytePointer flag_name);
@NoException public static native int av_opt_flag_is_set(Pointer obj, String field_name, String flag_name);

/**
 * Set all the options from a given dictionary on an object.
 *
 * @param obj a struct whose first element is a pointer to AVClass
 * @param options options to process. This dictionary will be freed and replaced
 *                by a new one containing all options not found in obj.
 *                Of course this new dictionary needs to be freed by caller
 *                with av_dict_free().
 *
 * @return 0 on success, a negative AVERROR if some option was found in obj,
 *         but could not be set.
 *
 * @see av_dict_copy()
 */
@NoException public static native int av_opt_set_dict(Pointer obj, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int av_opt_set_dict(Pointer obj, @ByPtrPtr AVDictionary options);


/**
 * Set all the options from a given dictionary on an object.
 *
 * @param obj a struct whose first element is a pointer to AVClass
 * @param options options to process. This dictionary will be freed and replaced
 *                by a new one containing all options not found in obj.
 *                Of course this new dictionary needs to be freed by caller
 *                with av_dict_free().
 * @param search_flags A combination of AV_OPT_SEARCH_*.
 *
 * @return 0 on success, a negative AVERROR if some option was found in obj,
 *         but could not be set.
 *
 * @see av_dict_copy()
 */
@NoException public static native int av_opt_set_dict2(Pointer obj, @Cast("AVDictionary**") PointerPointer options, int search_flags);
@NoException public static native int av_opt_set_dict2(Pointer obj, @ByPtrPtr AVDictionary options, int search_flags);

/**
 * Extract a key-value pair from the beginning of a string.
 *
 * @param ropts        pointer to the options string, will be updated to
 *                     point to the rest of the string (one of the pairs_sep
 *                     or the final NUL)
 * @param key_val_sep  a 0-terminated list of characters used to separate
 *                     key from value, for example '='
 * @param pairs_sep    a 0-terminated list of characters used to separate
 *                     two pairs from each other, for example ':' or ','
 * @param flags        flags; see the AV_OPT_FLAG_* values below
 * @param rkey         parsed key; must be freed using av_free()
 * @param rval         parsed value; must be freed using av_free()
 *
 * @return  >=0 for success, or a negative value corresponding to an
 *          AVERROR code in case of error; in particular:
 *          AVERROR(EINVAL) if no key is present
 *
 */
@NoException public static native int av_opt_get_key_value(@Cast("const char**") PointerPointer ropts,
                         @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep,
                         @Cast("unsigned") int flags,
                         @Cast("char**") PointerPointer rkey, @Cast("char**") PointerPointer rval);
@NoException public static native int av_opt_get_key_value(@Cast("const char**") @ByPtrPtr BytePointer ropts,
                         @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep,
                         @Cast("unsigned") int flags,
                         @Cast("char**") @ByPtrPtr BytePointer rkey, @Cast("char**") @ByPtrPtr BytePointer rval);
@NoException public static native int av_opt_get_key_value(@Cast("const char**") @ByPtrPtr ByteBuffer ropts,
                         String key_val_sep, String pairs_sep,
                         @Cast("unsigned") int flags,
                         @Cast("char**") @ByPtrPtr ByteBuffer rkey, @Cast("char**") @ByPtrPtr ByteBuffer rval);
@NoException public static native int av_opt_get_key_value(@Cast("const char**") @ByPtrPtr byte[] ropts,
                         @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep,
                         @Cast("unsigned") int flags,
                         @Cast("char**") @ByPtrPtr byte[] rkey, @Cast("char**") @ByPtrPtr byte[] rval);
@NoException public static native int av_opt_get_key_value(@Cast("const char**") @ByPtrPtr BytePointer ropts,
                         String key_val_sep, String pairs_sep,
                         @Cast("unsigned") int flags,
                         @Cast("char**") @ByPtrPtr BytePointer rkey, @Cast("char**") @ByPtrPtr BytePointer rval);
@NoException public static native int av_opt_get_key_value(@Cast("const char**") @ByPtrPtr ByteBuffer ropts,
                         @Cast("const char*") BytePointer key_val_sep, @Cast("const char*") BytePointer pairs_sep,
                         @Cast("unsigned") int flags,
                         @Cast("char**") @ByPtrPtr ByteBuffer rkey, @Cast("char**") @ByPtrPtr ByteBuffer rval);
@NoException public static native int av_opt_get_key_value(@Cast("const char**") @ByPtrPtr byte[] ropts,
                         String key_val_sep, String pairs_sep,
                         @Cast("unsigned") int flags,
                         @Cast("char**") @ByPtrPtr byte[] rkey, @Cast("char**") @ByPtrPtr byte[] rval);

/** enum  */
public static final int

    /**
     * Accept to parse a value without a key; the key will then be returned
     * as NULL.
     */
    AV_OPT_FLAG_IMPLICIT_KEY = 1;

/**
 * \defgroup opt_eval_funcs Evaluating option strings
 * \{
 * This group of functions can be used to evaluate option strings
 * and get numbers out of them. They do the same thing as av_opt_set(),
 * except the result is written into the caller-supplied pointer.
 *
 * @param obj a struct whose first element is a pointer to AVClass.
 * @param o an option for which the string is to be evaluated.
 * @param val string to be evaluated.
 * @param *_out value of the string will be written here.
 *
 * @return 0 on success, a negative number on failure.
 */
@NoException public static native int av_opt_eval_flags(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, IntPointer flags_out);
@NoException public static native int av_opt_eval_flags(Pointer obj, @Const AVOption o, String val, IntBuffer flags_out);
@NoException public static native int av_opt_eval_flags(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, int[] flags_out);
@NoException public static native int av_opt_eval_flags(Pointer obj, @Const AVOption o, String val, IntPointer flags_out);
@NoException public static native int av_opt_eval_flags(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, IntBuffer flags_out);
@NoException public static native int av_opt_eval_flags(Pointer obj, @Const AVOption o, String val, int[] flags_out);
@NoException public static native int av_opt_eval_int(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, IntPointer int_out);
@NoException public static native int av_opt_eval_int(Pointer obj, @Const AVOption o, String val, IntBuffer int_out);
@NoException public static native int av_opt_eval_int(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, int[] int_out);
@NoException public static native int av_opt_eval_int(Pointer obj, @Const AVOption o, String val, IntPointer int_out);
@NoException public static native int av_opt_eval_int(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, IntBuffer int_out);
@NoException public static native int av_opt_eval_int(Pointer obj, @Const AVOption o, String val, int[] int_out);
@NoException public static native int av_opt_eval_int64(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, @Cast("int64_t*") LongPointer int64_out);
@NoException public static native int av_opt_eval_int64(Pointer obj, @Const AVOption o, String val, @Cast("int64_t*") LongBuffer int64_out);
@NoException public static native int av_opt_eval_int64(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, @Cast("int64_t*") long[] int64_out);
@NoException public static native int av_opt_eval_int64(Pointer obj, @Const AVOption o, String val, @Cast("int64_t*") LongPointer int64_out);
@NoException public static native int av_opt_eval_int64(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, @Cast("int64_t*") LongBuffer int64_out);
@NoException public static native int av_opt_eval_int64(Pointer obj, @Const AVOption o, String val, @Cast("int64_t*") long[] int64_out);
@NoException public static native int av_opt_eval_float(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, FloatPointer float_out);
@NoException public static native int av_opt_eval_float(Pointer obj, @Const AVOption o, String val, FloatBuffer float_out);
@NoException public static native int av_opt_eval_float(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, float[] float_out);
@NoException public static native int av_opt_eval_float(Pointer obj, @Const AVOption o, String val, FloatPointer float_out);
@NoException public static native int av_opt_eval_float(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, FloatBuffer float_out);
@NoException public static native int av_opt_eval_float(Pointer obj, @Const AVOption o, String val, float[] float_out);
@NoException public static native int av_opt_eval_double(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, DoublePointer double_out);
@NoException public static native int av_opt_eval_double(Pointer obj, @Const AVOption o, String val, DoubleBuffer double_out);
@NoException public static native int av_opt_eval_double(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, double[] double_out);
@NoException public static native int av_opt_eval_double(Pointer obj, @Const AVOption o, String val, DoublePointer double_out);
@NoException public static native int av_opt_eval_double(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, DoubleBuffer double_out);
@NoException public static native int av_opt_eval_double(Pointer obj, @Const AVOption o, String val, double[] double_out);
@NoException public static native int av_opt_eval_q(Pointer obj, @Const AVOption o, @Cast("const char*") BytePointer val, AVRational q_out);
@NoException public static native int av_opt_eval_q(Pointer obj, @Const AVOption o, String val, AVRational q_out);
/**
 * \}
 */

/** Search in possible children of the
                                               given object first. */
public static final int AV_OPT_SEARCH_CHILDREN =   (1 << 0);
/**
 *  The obj passed to av_opt_find() is fake -- only a double pointer to AVClass
 *  instead of a required pointer to a struct containing AVClass. This is
 *  useful for searching for options without needing to allocate the corresponding
 *  object.
 */
public static final int AV_OPT_SEARCH_FAKE_OBJ =   (1 << 1);

/**
 *  In av_opt_get, return NULL if the option has a pointer type and is set to NULL,
 *  rather than returning an empty string.
 */
public static final int AV_OPT_ALLOW_NULL = (1 << 2);

/**
 *  Allows av_opt_query_ranges and av_opt_query_ranges_default to return more than
 *  one component for certain option types.
 *  @see AVOptionRanges for details.
 */
public static final int AV_OPT_MULTI_COMPONENT_RANGE = (1 << 12);

/**
 * Look for an option in an object. Consider only options which
 * have all the specified flags set.
 *
 * @param obj [in] A pointer to a struct whose first element is a
 *                pointer to an AVClass.
 *                Alternatively a double pointer to an AVClass, if
 *                AV_OPT_SEARCH_FAKE_OBJ search flag is set.
 * @param name [in] The name of the option to look for.
 * @param unit [in] When searching for named constants, name of the unit
 *                 it belongs to.
 * @param opt_flags Find only options with all the specified flags set (AV_OPT_FLAG).
 * @param search_flags A combination of AV_OPT_SEARCH_*.
 *
 * @return A pointer to the option found, or NULL if no option
 *         was found.
 *
 * \note Options found with AV_OPT_SEARCH_CHILDREN flag may not be settable
 * directly with av_opt_set(). Use special calls which take an options
 * AVDictionary (e.g. avformat_open_input()) to set options found with this
 * flag.
 */
@NoException public static native @Const AVOption av_opt_find(Pointer obj, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer unit,
                            int opt_flags, int search_flags);
@NoException public static native @Const AVOption av_opt_find(Pointer obj, String name, String unit,
                            int opt_flags, int search_flags);

/**
 * Look for an option in an object. Consider only options which
 * have all the specified flags set.
 *
 * @param obj [in] A pointer to a struct whose first element is a
 *                pointer to an AVClass.
 *                Alternatively a double pointer to an AVClass, if
 *                AV_OPT_SEARCH_FAKE_OBJ search flag is set.
 * @param name [in] The name of the option to look for.
 * @param unit [in] When searching for named constants, name of the unit
 *                 it belongs to.
 * @param opt_flags Find only options with all the specified flags set (AV_OPT_FLAG).
 * @param search_flags A combination of AV_OPT_SEARCH_*.
 * @param target_obj [out] if non-NULL, an object to which the option belongs will be
 * written here. It may be different from obj if AV_OPT_SEARCH_CHILDREN is present
 * in search_flags. This parameter is ignored if search_flags contain
 * AV_OPT_SEARCH_FAKE_OBJ.
 *
 * @return A pointer to the option found, or NULL if no option
 *         was found.
 */
@NoException public static native @Const AVOption av_opt_find2(Pointer obj, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer unit,
                             int opt_flags, int search_flags, @Cast("void**") PointerPointer target_obj);
@NoException public static native @Const AVOption av_opt_find2(Pointer obj, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer unit,
                             int opt_flags, int search_flags, @Cast("void**") @ByPtrPtr Pointer target_obj);
@NoException public static native @Const AVOption av_opt_find2(Pointer obj, String name, String unit,
                             int opt_flags, int search_flags, @Cast("void**") @ByPtrPtr Pointer target_obj);

/**
 * Iterate over all AVOptions belonging to obj.
 *
 * @param obj an AVOptions-enabled struct or a double pointer to an
 *            AVClass describing it.
 * @param prev result of the previous call to av_opt_next() on this object
 *             or NULL
 * @return next AVOption or NULL
 */
@NoException public static native @Const AVOption av_opt_next(@Const Pointer obj, @Const AVOption prev);

/**
 * Iterate over AVOptions-enabled children of obj.
 *
 * @param prev result of a previous call to this function or NULL
 * @return next AVOptions-enabled child or NULL
 */
@NoException public static native Pointer av_opt_child_next(Pointer obj, Pointer prev);

/**
 * Iterate over potential AVOptions-enabled children of parent.
 *
 * @param prev result of a previous call to this function or NULL
 * @return AVClass corresponding to next potential child or NULL
 */
@NoException public static native @Const AVClass av_opt_child_class_next(@Const AVClass parent, @Const AVClass prev);

/**
 * \defgroup opt_set_funcs Option setting functions
 * \{
 * Those functions set the field of obj with the given name to value.
 *
 * @param obj [in] A struct whose first element is a pointer to an AVClass.
 * @param name [in] the name of the field to set
 * @param val [in] The value to set. In case of av_opt_set() if the field is not
 * of a string type, then the given string is parsed.
 * SI postfixes and some named scalars are supported.
 * If the field is of a numeric type, it has to be a numeric or named
 * scalar. Behavior with more than one scalar and +- infix operators
 * is undefined.
 * If the field is of a flags type, it has to be a sequence of numeric
 * scalars or named flags separated by '+' or '-'. Prefixing a flag
 * with '+' causes it to be set without affecting the other flags;
 * similarly, '-' unsets a flag.
 * If the field is of a dictionary type, it has to be a ':' separated list of
 * key=value parameters. Values containing ':' special characters must be
 * escaped.
 * @param search_flags flags passed to av_opt_find2. I.e. if AV_OPT_SEARCH_CHILDREN
 * is passed here, then the option may be set on a child of obj.
 *
 * @return 0 if the value has been set, or an AVERROR code in case of
 * error:
 * AVERROR_OPTION_NOT_FOUND if no matching option exists
 * AVERROR(ERANGE) if the value is out of range
 * AVERROR(EINVAL) if the value is not valid
 */
@NoException public static native int av_opt_set(Pointer obj, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer val, int search_flags);
@NoException public static native int av_opt_set(Pointer obj, String name, String val, int search_flags);
@NoException public static native int av_opt_set_int(Pointer obj, @Cast("const char*") BytePointer name, @Cast("int64_t") long val, int search_flags);
@NoException public static native int av_opt_set_int(Pointer obj, String name, @Cast("int64_t") long val, int search_flags);
@NoException public static native int av_opt_set_double(Pointer obj, @Cast("const char*") BytePointer name, double val, int search_flags);
@NoException public static native int av_opt_set_double(Pointer obj, String name, double val, int search_flags);
@NoException public static native int av_opt_set_q(Pointer obj, @Cast("const char*") BytePointer name, @ByVal AVRational val, int search_flags);
@NoException public static native int av_opt_set_q(Pointer obj, String name, @ByVal AVRational val, int search_flags);
@NoException public static native int av_opt_set_bin(Pointer obj, @Cast("const char*") BytePointer name, @Cast("const uint8_t*") BytePointer val, int size, int search_flags);
@NoException public static native int av_opt_set_bin(Pointer obj, String name, @Cast("const uint8_t*") ByteBuffer val, int size, int search_flags);
@NoException public static native int av_opt_set_bin(Pointer obj, @Cast("const char*") BytePointer name, @Cast("const uint8_t*") byte[] val, int size, int search_flags);
@NoException public static native int av_opt_set_bin(Pointer obj, String name, @Cast("const uint8_t*") BytePointer val, int size, int search_flags);
@NoException public static native int av_opt_set_bin(Pointer obj, @Cast("const char*") BytePointer name, @Cast("const uint8_t*") ByteBuffer val, int size, int search_flags);
@NoException public static native int av_opt_set_bin(Pointer obj, String name, @Cast("const uint8_t*") byte[] val, int size, int search_flags);
@NoException public static native int av_opt_set_image_size(Pointer obj, @Cast("const char*") BytePointer name, int w, int h, int search_flags);
@NoException public static native int av_opt_set_image_size(Pointer obj, String name, int w, int h, int search_flags);
@NoException public static native int av_opt_set_pixel_fmt(Pointer obj, @Cast("const char*") BytePointer name, @Cast("AVPixelFormat") int fmt, int search_flags);
@NoException public static native int av_opt_set_pixel_fmt(Pointer obj, String name, @Cast("AVPixelFormat") int fmt, int search_flags);
@NoException public static native int av_opt_set_sample_fmt(Pointer obj, @Cast("const char*") BytePointer name, @Cast("AVSampleFormat") int fmt, int search_flags);
@NoException public static native int av_opt_set_sample_fmt(Pointer obj, String name, @Cast("AVSampleFormat") int fmt, int search_flags);
@NoException public static native int av_opt_set_video_rate(Pointer obj, @Cast("const char*") BytePointer name, @ByVal AVRational val, int search_flags);
@NoException public static native int av_opt_set_video_rate(Pointer obj, String name, @ByVal AVRational val, int search_flags);
@NoException public static native int av_opt_set_channel_layout(Pointer obj, @Cast("const char*") BytePointer name, @Cast("int64_t") long ch_layout, int search_flags);
@NoException public static native int av_opt_set_channel_layout(Pointer obj, String name, @Cast("int64_t") long ch_layout, int search_flags);
/**
 * \note Any old dictionary present is discarded and replaced with a copy of the new one. The
 * caller still owns val is and responsible for freeing it.
 */
@NoException public static native int av_opt_set_dict_val(Pointer obj, @Cast("const char*") BytePointer name, @Const AVDictionary val, int search_flags);
@NoException public static native int av_opt_set_dict_val(Pointer obj, String name, @Const AVDictionary val, int search_flags);

/**
 * Set a binary option to an integer list.
 *
 * @param obj    AVClass object to set options on
 * @param name   name of the binary option
 * @param val    pointer to an integer list (must have the correct type with
 *               regard to the contents of the list)
 * @param term   list terminator (usually 0 or -1)
 * @param flags  search flags
 */
// #define av_opt_set_int_list(obj, name, val, term, flags)
//     (av_int_list_length(val, term) > INT_MAX / sizeof(*(val)) ?
//      AVERROR(EINVAL) :
//      av_opt_set_bin(obj, name, (const uint8_t *)(val),
//                     av_int_list_length(val, term) * sizeof(*(val)), flags))

/**
 * \}
 */

/**
 * \defgroup opt_get_funcs Option getting functions
 * \{
 * Those functions get a value of the option with the given name from an object.
 *
 * @param obj [in] a struct whose first element is a pointer to an AVClass.
 * @param name [in] name of the option to get.
 * @param search_flags [in] flags passed to av_opt_find2. I.e. if AV_OPT_SEARCH_CHILDREN
 * is passed here, then the option may be found in a child of obj.
 * @param out_val [out] value of the option will be written here
 * @return >=0 on success, a negative error code otherwise
 */
/**
 * \note the returned string will be av_malloc()ed and must be av_free()ed by the caller
 *
 * \note if AV_OPT_ALLOW_NULL is set in search_flags in av_opt_get, and the
 * option is of type AV_OPT_TYPE_STRING, AV_OPT_TYPE_BINARY or AV_OPT_TYPE_DICT
 * and is set to NULL, *out_val will be set to NULL instead of an allocated
 * empty string.
 */
@NoException public static native int av_opt_get(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("uint8_t**") PointerPointer out_val);
@NoException public static native int av_opt_get(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("uint8_t**") @ByPtrPtr BytePointer out_val);
@NoException public static native int av_opt_get(Pointer obj, String name, int search_flags, @Cast("uint8_t**") @ByPtrPtr ByteBuffer out_val);
@NoException public static native int av_opt_get(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("uint8_t**") @ByPtrPtr byte[] out_val);
@NoException public static native int av_opt_get(Pointer obj, String name, int search_flags, @Cast("uint8_t**") @ByPtrPtr BytePointer out_val);
@NoException public static native int av_opt_get(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("uint8_t**") @ByPtrPtr ByteBuffer out_val);
@NoException public static native int av_opt_get(Pointer obj, String name, int search_flags, @Cast("uint8_t**") @ByPtrPtr byte[] out_val);
@NoException public static native int av_opt_get_int(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("int64_t*") LongPointer out_val);
@NoException public static native int av_opt_get_int(Pointer obj, String name, int search_flags, @Cast("int64_t*") LongBuffer out_val);
@NoException public static native int av_opt_get_int(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("int64_t*") long[] out_val);
@NoException public static native int av_opt_get_int(Pointer obj, String name, int search_flags, @Cast("int64_t*") LongPointer out_val);
@NoException public static native int av_opt_get_int(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("int64_t*") LongBuffer out_val);
@NoException public static native int av_opt_get_int(Pointer obj, String name, int search_flags, @Cast("int64_t*") long[] out_val);
@NoException public static native int av_opt_get_double(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, DoublePointer out_val);
@NoException public static native int av_opt_get_double(Pointer obj, String name, int search_flags, DoubleBuffer out_val);
@NoException public static native int av_opt_get_double(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, double[] out_val);
@NoException public static native int av_opt_get_double(Pointer obj, String name, int search_flags, DoublePointer out_val);
@NoException public static native int av_opt_get_double(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, DoubleBuffer out_val);
@NoException public static native int av_opt_get_double(Pointer obj, String name, int search_flags, double[] out_val);
@NoException public static native int av_opt_get_q(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, AVRational out_val);
@NoException public static native int av_opt_get_q(Pointer obj, String name, int search_flags, AVRational out_val);
@NoException public static native int av_opt_get_image_size(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, IntPointer w_out, IntPointer h_out);
@NoException public static native int av_opt_get_image_size(Pointer obj, String name, int search_flags, IntBuffer w_out, IntBuffer h_out);
@NoException public static native int av_opt_get_image_size(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, int[] w_out, int[] h_out);
@NoException public static native int av_opt_get_image_size(Pointer obj, String name, int search_flags, IntPointer w_out, IntPointer h_out);
@NoException public static native int av_opt_get_image_size(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, IntBuffer w_out, IntBuffer h_out);
@NoException public static native int av_opt_get_image_size(Pointer obj, String name, int search_flags, int[] w_out, int[] h_out);
@NoException public static native int av_opt_get_pixel_fmt(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("AVPixelFormat*") IntPointer out_fmt);
@NoException public static native int av_opt_get_pixel_fmt(Pointer obj, String name, int search_flags, @Cast("AVPixelFormat*") IntBuffer out_fmt);
@NoException public static native int av_opt_get_pixel_fmt(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("AVPixelFormat*") int[] out_fmt);
@NoException public static native int av_opt_get_pixel_fmt(Pointer obj, String name, int search_flags, @Cast("AVPixelFormat*") IntPointer out_fmt);
@NoException public static native int av_opt_get_pixel_fmt(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("AVPixelFormat*") IntBuffer out_fmt);
@NoException public static native int av_opt_get_pixel_fmt(Pointer obj, String name, int search_flags, @Cast("AVPixelFormat*") int[] out_fmt);
@NoException public static native int av_opt_get_sample_fmt(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("AVSampleFormat*") IntPointer out_fmt);
@NoException public static native int av_opt_get_sample_fmt(Pointer obj, String name, int search_flags, @Cast("AVSampleFormat*") IntBuffer out_fmt);
@NoException public static native int av_opt_get_sample_fmt(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("AVSampleFormat*") int[] out_fmt);
@NoException public static native int av_opt_get_sample_fmt(Pointer obj, String name, int search_flags, @Cast("AVSampleFormat*") IntPointer out_fmt);
@NoException public static native int av_opt_get_sample_fmt(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("AVSampleFormat*") IntBuffer out_fmt);
@NoException public static native int av_opt_get_sample_fmt(Pointer obj, String name, int search_flags, @Cast("AVSampleFormat*") int[] out_fmt);
@NoException public static native int av_opt_get_video_rate(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, AVRational out_val);
@NoException public static native int av_opt_get_video_rate(Pointer obj, String name, int search_flags, AVRational out_val);
@NoException public static native int av_opt_get_channel_layout(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("int64_t*") LongPointer ch_layout);
@NoException public static native int av_opt_get_channel_layout(Pointer obj, String name, int search_flags, @Cast("int64_t*") LongBuffer ch_layout);
@NoException public static native int av_opt_get_channel_layout(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("int64_t*") long[] ch_layout);
@NoException public static native int av_opt_get_channel_layout(Pointer obj, String name, int search_flags, @Cast("int64_t*") LongPointer ch_layout);
@NoException public static native int av_opt_get_channel_layout(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("int64_t*") LongBuffer ch_layout);
@NoException public static native int av_opt_get_channel_layout(Pointer obj, String name, int search_flags, @Cast("int64_t*") long[] ch_layout);
/**
 * @param out_val [out] The returned dictionary is a copy of the actual value and must
 * be freed with av_dict_free() by the caller
 */
@NoException public static native int av_opt_get_dict_val(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @Cast("AVDictionary**") PointerPointer out_val);
@NoException public static native int av_opt_get_dict_val(Pointer obj, @Cast("const char*") BytePointer name, int search_flags, @ByPtrPtr AVDictionary out_val);
@NoException public static native int av_opt_get_dict_val(Pointer obj, String name, int search_flags, @ByPtrPtr AVDictionary out_val);
/**
 * \}
 */
/**
 * Gets a pointer to the requested field in a struct.
 * This function allows accessing a struct even when its fields are moved or
 * renamed since the application making the access has been compiled,
 *
 * @return a pointer to the field, it can be cast to the correct type and read
 *          or written to.
 */
@NoException public static native Pointer av_opt_ptr(@Const AVClass avclass, Pointer obj, @Cast("const char*") BytePointer name);
@NoException public static native Pointer av_opt_ptr(@Const AVClass avclass, Pointer obj, String name);

/**
 * Free an AVOptionRanges struct and set it to NULL.
 */
@NoException public static native void av_opt_freep_ranges(@Cast("AVOptionRanges**") PointerPointer ranges);
@NoException public static native void av_opt_freep_ranges(@ByPtrPtr AVOptionRanges ranges);

/**
 * Get a list of allowed ranges for the given option.
 *
 * The returned list may depend on other fields in obj like for example profile.
 *
 * @param flags is a bitmask of flags, undefined flags should not be set and should be ignored
 *              AV_OPT_SEARCH_FAKE_OBJ indicates that the obj is a double pointer to a AVClass instead of a full instance
 *              AV_OPT_MULTI_COMPONENT_RANGE indicates that function may return more than one component, @see AVOptionRanges
 *
 * The result must be freed with av_opt_freep_ranges.
 *
 * @return number of compontents returned on success, a negative errro code otherwise
 */
@NoException public static native int av_opt_query_ranges(@Cast("AVOptionRanges**") PointerPointer arg0, Pointer obj, @Cast("const char*") BytePointer key, int flags);
@NoException public static native int av_opt_query_ranges(@ByPtrPtr AVOptionRanges arg0, Pointer obj, @Cast("const char*") BytePointer key, int flags);
@NoException public static native int av_opt_query_ranges(@ByPtrPtr AVOptionRanges arg0, Pointer obj, String key, int flags);

/**
 * Copy options from src object into dest object.
 *
 * Options that require memory allocation (e.g. string or binary) are malloc'ed in dest object.
 * Original memory allocated for such options is freed unless both src and dest options points to the same memory.
 *
 * @param dest Object to copy from
 * @param src  Object to copy into
 * @return 0 on success, negative on error
 */
@NoException public static native int av_opt_copy(Pointer dest, @Const Pointer src);

/**
 * Get a default list of allowed ranges for the given option.
 *
 * This list is constructed without using the AVClass.query_ranges() callback
 * and can be used as fallback from within the callback.
 *
 * @param flags is a bitmask of flags, undefined flags should not be set and should be ignored
 *              AV_OPT_SEARCH_FAKE_OBJ indicates that the obj is a double pointer to a AVClass instead of a full instance
 *              AV_OPT_MULTI_COMPONENT_RANGE indicates that function may return more than one component, @see AVOptionRanges
 *
 * The result must be freed with av_opt_free_ranges.
 *
 * @return number of compontents returned on success, a negative errro code otherwise
 */
@NoException public static native int av_opt_query_ranges_default(@Cast("AVOptionRanges**") PointerPointer arg0, Pointer obj, @Cast("const char*") BytePointer key, int flags);
@NoException public static native int av_opt_query_ranges_default(@ByPtrPtr AVOptionRanges arg0, Pointer obj, @Cast("const char*") BytePointer key, int flags);
@NoException public static native int av_opt_query_ranges_default(@ByPtrPtr AVOptionRanges arg0, Pointer obj, String key, int flags);

/**
 * Check if given option is set to its default value.
 *
 * Options o must belong to the obj. This function must not be called to check child's options state.
 * @see av_opt_is_set_to_default_by_name().
 *
 * @param obj  AVClass object to check option on
 * @param o    option to be checked
 * @return     >0 when option is set to its default,
 *              0 when option is not set its default,
 *             <0 on error
 */
@NoException public static native int av_opt_is_set_to_default(Pointer obj, @Const AVOption o);

/**
 * Check if given option is set to its default value.
 *
 * @param obj          AVClass object to check option on
 * @param name         option name
 * @param search_flags combination of AV_OPT_SEARCH_*
 * @return             >0 when option is set to its default,
 *                     0 when option is not set its default,
 *                     <0 on error
 */
@NoException public static native int av_opt_is_set_to_default_by_name(Pointer obj, @Cast("const char*") BytePointer name, int search_flags);
@NoException public static native int av_opt_is_set_to_default_by_name(Pointer obj, String name, int search_flags);


/** Serialize options that are not set to default values only. */
public static final int AV_OPT_SERIALIZE_SKIP_DEFAULTS =              0x00000001;
/** Serialize options that exactly match opt_flags only. */
public static final int AV_OPT_SERIALIZE_OPT_FLAGS_EXACT =            0x00000002;

/**
 * Serialize object's options.
 *
 * Create a string containing object's serialized options.
 * Such string may be passed back to av_opt_set_from_string() in order to restore option values.
 * A key/value or pairs separator occurring in the serialized value or
 * name string are escaped through the av_escape() function.
 *
 * @param obj [in]           AVClass object to serialize
 * @param opt_flags [in]     serialize options with all the specified flags set (AV_OPT_FLAG)
 * @param flags [in]         combination of AV_OPT_SERIALIZE_* flags
 * @param buffer [out]        Pointer to buffer that will be allocated with string containg serialized options.
 *                           Buffer must be freed by the caller when is no longer needed.
 * @param key_val_sep [in]   character used to separate key from value
 * @param pairs_sep [in]     character used to separate two pairs from each other
 * @return                   >= 0 on success, negative on error
 * \warning Separators cannot be neither '\' nor '\0'. They also cannot be the same.
 */
@NoException public static native int av_opt_serialize(Pointer obj, int opt_flags, int flags, @Cast("char**") PointerPointer buffer,
                     byte key_val_sep, byte pairs_sep);
@NoException public static native int av_opt_serialize(Pointer obj, int opt_flags, int flags, @Cast("char**") @ByPtrPtr BytePointer buffer,
                     byte key_val_sep, byte pairs_sep);
@NoException public static native int av_opt_serialize(Pointer obj, int opt_flags, int flags, @Cast("char**") @ByPtrPtr ByteBuffer buffer,
                     byte key_val_sep, byte pairs_sep);
@NoException public static native int av_opt_serialize(Pointer obj, int opt_flags, int flags, @Cast("char**") @ByPtrPtr byte[] buffer,
                     byte key_val_sep, byte pairs_sep);
/**
 * \}
 */

// #endif /* AVUTIL_OPT_H */


// Parsed from <libavutil/pixdesc.h>

/*
 * pixel format descriptor
 * Copyright (c) 2009 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_PIXDESC_H
// #define AVUTIL_PIXDESC_H

// #include <inttypes.h>

// #include "attributes.h"
// #include "pixfmt.h"
// #include "version.h"
// Targeting ..\avutil\AVComponentDescriptor.java


// Targeting ..\avutil\AVPixFmtDescriptor.java



/**
 * Pixel format is big-endian.
 */
public static final int AV_PIX_FMT_FLAG_BE =           (1 << 0);
/**
 * Pixel format has a palette in data[1], values are indexes in this palette.
 */
public static final int AV_PIX_FMT_FLAG_PAL =          (1 << 1);
/**
 * All values of a component are bit-wise packed end to end.
 */
public static final int AV_PIX_FMT_FLAG_BITSTREAM =    (1 << 2);
/**
 * Pixel format is an HW accelerated format.
 */
public static final int AV_PIX_FMT_FLAG_HWACCEL =      (1 << 3);
/**
 * At least one pixel component is not in the first data plane.
 */
public static final int AV_PIX_FMT_FLAG_PLANAR =       (1 << 4);
/**
 * The pixel format contains RGB-like data (as opposed to YUV/grayscale).
 */
public static final int AV_PIX_FMT_FLAG_RGB =          (1 << 5);

/**
 * The pixel format is "pseudo-paletted". This means that it contains a
 * fixed palette in the 2nd plane but the palette is fixed/constant for each
 * PIX_FMT. This allows interpreting the data as if it was PAL8, which can
 * in some cases be simpler. Or the data can be interpreted purely based on
 * the pixel format without using the palette.
 * An example of a pseudo-paletted format is AV_PIX_FMT_GRAY8
 *
 * @deprecated This flag is deprecated, and will be removed. When it is removed,
 * the extra palette allocation in AVFrame.data[1] is removed as well. Only
 * actual paletted formats (as indicated by AV_PIX_FMT_FLAG_PAL) will have a
 * palette. Starting with FFmpeg versions which have this flag deprecated, the
 * extra "pseudo" palette is already ignored, and API users are not required to
 * allocate a palette for AV_PIX_FMT_FLAG_PSEUDOPAL formats (it was required
 * before the deprecation, though).
 */
public static final int AV_PIX_FMT_FLAG_PSEUDOPAL =    (1 << 6);

/**
 * The pixel format has an alpha channel. This is set on all formats that
 * support alpha in some way, including AV_PIX_FMT_PAL8. The alpha is always
 * straight, never pre-multiplied.
 *
 * If a codec or a filter does not support alpha, it should set all alpha to
 * opaque, or use the equivalent pixel formats without alpha component, e.g.
 * AV_PIX_FMT_RGB0 (or AV_PIX_FMT_RGB24 etc.) instead of AV_PIX_FMT_RGBA.
 */
public static final int AV_PIX_FMT_FLAG_ALPHA =        (1 << 7);

/**
 * The pixel format is following a Bayer pattern
 */
public static final int AV_PIX_FMT_FLAG_BAYER =        (1 << 8);

/**
 * The pixel format contains IEEE-754 floating point values. Precision (double,
 * single, or half) should be determined by the pixel size (64, 32, or 16 bits).
 */
public static final int AV_PIX_FMT_FLAG_FLOAT =        (1 << 9);

/**
 * Return the number of bits per pixel used by the pixel format
 * described by pixdesc. Note that this is not the same as the number
 * of bits per sample.
 *
 * The returned number of bits refers to the number of bits actually
 * used for storing the pixel information, that is padding bits are
 * not counted.
 */
@NoException public static native int av_get_bits_per_pixel(@Const AVPixFmtDescriptor pixdesc);

/**
 * Return the number of bits per pixel for the pixel format
 * described by pixdesc, including any padding or unused bits.
 */
@NoException public static native int av_get_padded_bits_per_pixel(@Const AVPixFmtDescriptor pixdesc);

/**
 * @return a pixel format descriptor for provided pixel format or NULL if
 * this pixel format is unknown.
 */
@NoException public static native @Const AVPixFmtDescriptor av_pix_fmt_desc_get(@Cast("AVPixelFormat") int pix_fmt);

/**
 * Iterate over all pixel format descriptors known to libavutil.
 *
 * @param prev previous descriptor. NULL to get the first descriptor.
 *
 * @return next descriptor or NULL after the last descriptor
 */
@NoException public static native @Const AVPixFmtDescriptor av_pix_fmt_desc_next(@Const AVPixFmtDescriptor prev);

/**
 * @return an AVPixelFormat id described by desc, or AV_PIX_FMT_NONE if desc
 * is not a valid pointer to a pixel format descriptor.
 */
@NoException public static native @Cast("AVPixelFormat") int av_pix_fmt_desc_get_id(@Const AVPixFmtDescriptor desc);

/**
 * Utility function to access log2_chroma_w log2_chroma_h from
 * the pixel format AVPixFmtDescriptor.
 *
 * @param pix_fmt [in] the pixel format
 * @param h_shift [out] store log2_chroma_w (horizontal/width shift)
 * @param v_shift [out] store log2_chroma_h (vertical/height shift)
 *
 * @return 0 on success, AVERROR(ENOSYS) on invalid or unknown pixel format
 */
@NoException public static native int av_pix_fmt_get_chroma_sub_sample(@Cast("AVPixelFormat") int pix_fmt,
                                     IntPointer h_shift, IntPointer v_shift);
@NoException public static native int av_pix_fmt_get_chroma_sub_sample(@Cast("AVPixelFormat") int pix_fmt,
                                     IntBuffer h_shift, IntBuffer v_shift);
@NoException public static native int av_pix_fmt_get_chroma_sub_sample(@Cast("AVPixelFormat") int pix_fmt,
                                     int[] h_shift, int[] v_shift);

/**
 * @return number of planes in pix_fmt, a negative AVERROR if pix_fmt is not a
 * valid pixel format.
 */
@NoException public static native int av_pix_fmt_count_planes(@Cast("AVPixelFormat") int pix_fmt);

/**
 * @return the name for provided color range or NULL if unknown.
 */
@NoException public static native @Cast("const char*") BytePointer av_color_range_name(@Cast("AVColorRange") int range);

/**
 * @return the AVColorRange value for name or an AVError if not found.
 */
@NoException public static native int av_color_range_from_name(@Cast("const char*") BytePointer name);
@NoException public static native int av_color_range_from_name(String name);

/**
 * @return the name for provided color primaries or NULL if unknown.
 */
@NoException public static native @Cast("const char*") BytePointer av_color_primaries_name(@Cast("AVColorPrimaries") int primaries);

/**
 * @return the AVColorPrimaries value for name or an AVError if not found.
 */
@NoException public static native int av_color_primaries_from_name(@Cast("const char*") BytePointer name);
@NoException public static native int av_color_primaries_from_name(String name);

/**
 * @return the name for provided color transfer or NULL if unknown.
 */
@NoException public static native @Cast("const char*") BytePointer av_color_transfer_name(@Cast("AVColorTransferCharacteristic") int transfer);

/**
 * @return the AVColorTransferCharacteristic value for name or an AVError if not found.
 */
@NoException public static native int av_color_transfer_from_name(@Cast("const char*") BytePointer name);
@NoException public static native int av_color_transfer_from_name(String name);

/**
 * @return the name for provided color space or NULL if unknown.
 */
@NoException public static native @Cast("const char*") BytePointer av_color_space_name(@Cast("AVColorSpace") int space);

/**
 * @return the AVColorSpace value for name or an AVError if not found.
 */
@NoException public static native int av_color_space_from_name(@Cast("const char*") BytePointer name);
@NoException public static native int av_color_space_from_name(String name);

/**
 * @return the name for provided chroma location or NULL if unknown.
 */
@NoException public static native @Cast("const char*") BytePointer av_chroma_location_name(@Cast("AVChromaLocation") int location);

/**
 * @return the AVChromaLocation value for name or an AVError if not found.
 */
@NoException public static native int av_chroma_location_from_name(@Cast("const char*") BytePointer name);
@NoException public static native int av_chroma_location_from_name(String name);

/**
 * Return the pixel format corresponding to name.
 *
 * If there is no pixel format with name name, then looks for a
 * pixel format with the name corresponding to the native endian
 * format of name.
 * For example in a little-endian system, first looks for "gray16",
 * then for "gray16le".
 *
 * Finally if no pixel format has been found, returns AV_PIX_FMT_NONE.
 */
@NoException public static native @Cast("AVPixelFormat") int av_get_pix_fmt(@Cast("const char*") BytePointer name);
@NoException public static native @Cast("AVPixelFormat") int av_get_pix_fmt(String name);

/**
 * Return the short name for a pixel format, NULL in case pix_fmt is
 * unknown.
 *
 * @see av_get_pix_fmt(), av_get_pix_fmt_string()
 */
@NoException public static native @Cast("const char*") BytePointer av_get_pix_fmt_name(@Cast("AVPixelFormat") int pix_fmt);

/**
 * Print in buf the string corresponding to the pixel format with
 * number pix_fmt, or a header if pix_fmt is negative.
 *
 * @param buf the buffer where to write the string
 * @param buf_size the size of buf
 * @param pix_fmt the number of the pixel format to print the
 * corresponding info string, or a negative value to print the
 * corresponding header.
 */
@NoException public static native @Cast("char*") BytePointer av_get_pix_fmt_string(@Cast("char*") BytePointer buf, int buf_size,
                            @Cast("AVPixelFormat") int pix_fmt);
@NoException public static native @Cast("char*") ByteBuffer av_get_pix_fmt_string(@Cast("char*") ByteBuffer buf, int buf_size,
                            @Cast("AVPixelFormat") int pix_fmt);
@NoException public static native @Cast("char*") byte[] av_get_pix_fmt_string(@Cast("char*") byte[] buf, int buf_size,
                            @Cast("AVPixelFormat") int pix_fmt);

/**
 * Read a line from an image, and write the values of the
 * pixel format component c to dst.
 *
 * @param data the array containing the pointers to the planes of the image
 * @param linesize the array containing the linesizes of the image
 * @param desc the pixel format descriptor for the image
 * @param x the horizontal coordinate of the first pixel to read
 * @param y the vertical coordinate of the first pixel to read
 * @param w the width of the line to read, that is the number of
 * values to write to dst
 * @param read_pal_component if not zero and the format is a paletted
 * format writes the values corresponding to the palette
 * component c in data[1] to dst, rather than the palette indexes in
 * data[0]. The behavior is undefined if the format is not paletted.
 * @param dst_element_size size of elements in dst array (2 or 4 byte)
 */
@NoException public static native void av_read_image_line2(Pointer dst, @Cast("const uint8_t**") PointerPointer data,
                        @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component,
                        int dst_element_size);
@NoException public static native void av_read_image_line2(Pointer dst, @Cast("const uint8_t**") @ByPtrPtr BytePointer data,
                        @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component,
                        int dst_element_size);
@NoException public static native void av_read_image_line2(Pointer dst, @Cast("const uint8_t**") @ByPtrPtr ByteBuffer data,
                        @Const IntBuffer linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component,
                        int dst_element_size);
@NoException public static native void av_read_image_line2(Pointer dst, @Cast("const uint8_t**") @ByPtrPtr byte[] data,
                        @Const int[] linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component,
                        int dst_element_size);

@NoException public static native void av_read_image_line(@Cast("uint16_t*") ShortPointer dst, @Cast("const uint8_t**") PointerPointer data,
                        @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component);
@NoException public static native void av_read_image_line(@Cast("uint16_t*") ShortPointer dst, @Cast("const uint8_t**") @ByPtrPtr BytePointer data,
                        @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component);
@NoException public static native void av_read_image_line(@Cast("uint16_t*") ShortBuffer dst, @Cast("const uint8_t**") @ByPtrPtr ByteBuffer data,
                        @Const IntBuffer linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component);
@NoException public static native void av_read_image_line(@Cast("uint16_t*") short[] dst, @Cast("const uint8_t**") @ByPtrPtr byte[] data,
                        @Const int[] linesize, @Const AVPixFmtDescriptor desc,
                        int x, int y, int c, int w, int read_pal_component);

/**
 * Write the values from src to the pixel format component c of an
 * image line.
 *
 * @param src array containing the values to write
 * @param data the array containing the pointers to the planes of the
 * image to write into. It is supposed to be zeroed.
 * @param linesize the array containing the linesizes of the image
 * @param desc the pixel format descriptor for the image
 * @param x the horizontal coordinate of the first pixel to write
 * @param y the vertical coordinate of the first pixel to write
 * @param w the width of the line to write, that is the number of
 * values to write to the image line
 * @param src_element_size size of elements in src array (2 or 4 byte)
 */
@NoException public static native void av_write_image_line2(@Const Pointer src, @Cast("uint8_t**") PointerPointer data,
                         @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w, int src_element_size);
@NoException public static native void av_write_image_line2(@Const Pointer src, @Cast("uint8_t**") @ByPtrPtr BytePointer data,
                         @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w, int src_element_size);
@NoException public static native void av_write_image_line2(@Const Pointer src, @Cast("uint8_t**") @ByPtrPtr ByteBuffer data,
                         @Const IntBuffer linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w, int src_element_size);
@NoException public static native void av_write_image_line2(@Const Pointer src, @Cast("uint8_t**") @ByPtrPtr byte[] data,
                         @Const int[] linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w, int src_element_size);

@NoException public static native void av_write_image_line(@Cast("const uint16_t*") ShortPointer src, @Cast("uint8_t**") PointerPointer data,
                         @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w);
@NoException public static native void av_write_image_line(@Cast("const uint16_t*") ShortPointer src, @Cast("uint8_t**") @ByPtrPtr BytePointer data,
                         @Const IntPointer linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w);
@NoException public static native void av_write_image_line(@Cast("const uint16_t*") ShortBuffer src, @Cast("uint8_t**") @ByPtrPtr ByteBuffer data,
                         @Const IntBuffer linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w);
@NoException public static native void av_write_image_line(@Cast("const uint16_t*") short[] src, @Cast("uint8_t**") @ByPtrPtr byte[] data,
                         @Const int[] linesize, @Const AVPixFmtDescriptor desc,
                         int x, int y, int c, int w);

/**
 * Utility function to swap the endianness of a pixel format.
 *
 * @param pix_fmt [in] the pixel format
 *
 * @return pixel format with swapped endianness if it exists,
 * otherwise AV_PIX_FMT_NONE
 */
@NoException public static native @Cast("AVPixelFormat") int av_pix_fmt_swap_endianness(@Cast("AVPixelFormat") int pix_fmt);

/** loss due to resolution change */
public static final int FF_LOSS_RESOLUTION =  0x0001;
/** loss due to color depth change */
public static final int FF_LOSS_DEPTH =       0x0002;
/** loss due to color space conversion */
public static final int FF_LOSS_COLORSPACE =  0x0004;
/** loss of alpha bits */
public static final int FF_LOSS_ALPHA =       0x0008;
/** loss due to color quantization */
public static final int FF_LOSS_COLORQUANT =  0x0010;
/** loss of chroma (e.g. RGB to gray conversion) */
public static final int FF_LOSS_CHROMA =      0x0020;

/**
 * Compute what kind of losses will occur when converting from one specific
 * pixel format to another.
 * When converting from one pixel format to another, information loss may occur.
 * For example, when converting from RGB24 to GRAY, the color information will
 * be lost. Similarly, other losses occur when converting from some formats to
 * other formats. These losses can involve loss of chroma, but also loss of
 * resolution, loss of color depth, loss due to the color space conversion, loss
 * of the alpha bits or loss due to color quantization.
 * av_get_fix_fmt_loss() informs you about the various types of losses
 * which will occur when converting from one pixel format to another.
 *
 * @param dst_pix_fmt [in] destination pixel format
 * @param src_pix_fmt [in] source pixel format
 * @param has_alpha [in] Whether the source pixel format alpha channel is used.
 * @return Combination of flags informing you what kind of losses will occur
 * (maximum loss for an invalid dst_pix_fmt).
 */
@NoException public static native int av_get_pix_fmt_loss(@Cast("AVPixelFormat") int dst_pix_fmt,
                        @Cast("AVPixelFormat") int src_pix_fmt,
                        int has_alpha);

/**
 * Compute what kind of losses will occur when converting from one specific
 * pixel format to another.
 * When converting from one pixel format to another, information loss may occur.
 * For example, when converting from RGB24 to GRAY, the color information will
 * be lost. Similarly, other losses occur when converting from some formats to
 * other formats. These losses can involve loss of chroma, but also loss of
 * resolution, loss of color depth, loss due to the color space conversion, loss
 * of the alpha bits or loss due to color quantization.
 * av_get_fix_fmt_loss() informs you about the various types of losses
 * which will occur when converting from one pixel format to another.
 *
 * @param dst_pix_fmt [in] destination pixel format
 * @param src_pix_fmt [in] source pixel format
 * @param has_alpha [in] Whether the source pixel format alpha channel is used.
 * @return Combination of flags informing you what kind of losses will occur
 * (maximum loss for an invalid dst_pix_fmt).
 */
@NoException public static native @Cast("AVPixelFormat") int av_find_best_pix_fmt_of_2(@Cast("AVPixelFormat") int dst_pix_fmt1, @Cast("AVPixelFormat") int dst_pix_fmt2,
                                             @Cast("AVPixelFormat") int src_pix_fmt, int has_alpha, IntPointer loss_ptr);
@NoException public static native @Cast("AVPixelFormat") int av_find_best_pix_fmt_of_2(@Cast("AVPixelFormat") int dst_pix_fmt1, @Cast("AVPixelFormat") int dst_pix_fmt2,
                                             @Cast("AVPixelFormat") int src_pix_fmt, int has_alpha, IntBuffer loss_ptr);
@NoException public static native @Cast("AVPixelFormat") int av_find_best_pix_fmt_of_2(@Cast("AVPixelFormat") int dst_pix_fmt1, @Cast("AVPixelFormat") int dst_pix_fmt2,
                                             @Cast("AVPixelFormat") int src_pix_fmt, int has_alpha, int[] loss_ptr);

// #endif /* AVUTIL_PIXDESC_H */


// Parsed from <libavutil/imgutils.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_IMGUTILS_H
// #define AVUTIL_IMGUTILS_H

/**
 * \file
 * misc image utilities
 *
 * \addtogroup lavu_picture
 * \{
 */

// #include "avutil.h"
// #include "pixdesc.h"
// #include "rational.h"

/**
 * Compute the max pixel step for each plane of an image with a
 * format described by pixdesc.
 *
 * The pixel step is the distance in bytes between the first byte of
 * the group of bytes which describe a pixel component and the first
 * byte of the successive group in the same plane for the same
 * component.
 *
 * @param max_pixsteps an array which is filled with the max pixel step
 * for each plane. Since a plane may contain different pixel
 * components, the computed max_pixsteps[plane] is relative to the
 * component in the plane with the max pixel step.
 * @param max_pixstep_comps an array which is filled with the component
 * for each plane which has the max pixel step. May be NULL.
 */
@NoException public static native void av_image_fill_max_pixsteps(IntPointer max_pixsteps, IntPointer max_pixstep_comps,
                                @Const AVPixFmtDescriptor pixdesc);
@NoException public static native void av_image_fill_max_pixsteps(IntBuffer max_pixsteps, IntBuffer max_pixstep_comps,
                                @Const AVPixFmtDescriptor pixdesc);
@NoException public static native void av_image_fill_max_pixsteps(int[] max_pixsteps, int[] max_pixstep_comps,
                                @Const AVPixFmtDescriptor pixdesc);

/**
 * Compute the size of an image line with format pix_fmt and width
 * width for the plane plane.
 *
 * @return the computed size in bytes
 */
@NoException public static native int av_image_get_linesize(@Cast("AVPixelFormat") int pix_fmt, int width, int plane);

/**
 * Fill plane linesizes for an image with pixel format pix_fmt and
 * width width.
 *
 * @param linesizes array to be filled with the linesize for each plane
 * @return >= 0 in case of success, a negative error code otherwise
 */
@NoException public static native int av_image_fill_linesizes(IntPointer linesizes, @Cast("AVPixelFormat") int pix_fmt, int width);
@NoException public static native int av_image_fill_linesizes(IntBuffer linesizes, @Cast("AVPixelFormat") int pix_fmt, int width);
@NoException public static native int av_image_fill_linesizes(int[] linesizes, @Cast("AVPixelFormat") int pix_fmt, int width);

/**
 * Fill plane data pointers for an image with pixel format pix_fmt and
 * height height.
 *
 * @param data pointers array to be filled with the pointer for each image plane
 * @param ptr the pointer to a buffer which will contain the image
 * @param linesizes the array containing the linesize for each
 * plane, should be filled by av_image_fill_linesizes()
 * @return the size in bytes required for the image buffer, a negative
 * error code in case of failure
 */
@NoException public static native int av_image_fill_pointers(@Cast("uint8_t**") PointerPointer data, @Cast("AVPixelFormat") int pix_fmt, int height,
                           @Cast("uint8_t*") BytePointer ptr, @Const IntPointer linesizes);
@NoException public static native int av_image_fill_pointers(@Cast("uint8_t**") @ByPtrPtr BytePointer data, @Cast("AVPixelFormat") int pix_fmt, int height,
                           @Cast("uint8_t*") BytePointer ptr, @Const IntPointer linesizes);
@NoException public static native int av_image_fill_pointers(@Cast("uint8_t**") @ByPtrPtr ByteBuffer data, @Cast("AVPixelFormat") int pix_fmt, int height,
                           @Cast("uint8_t*") ByteBuffer ptr, @Const IntBuffer linesizes);
@NoException public static native int av_image_fill_pointers(@Cast("uint8_t**") @ByPtrPtr byte[] data, @Cast("AVPixelFormat") int pix_fmt, int height,
                           @Cast("uint8_t*") byte[] ptr, @Const int[] linesizes);

/**
 * Allocate an image with size w and h and pixel format pix_fmt, and
 * fill pointers and linesizes accordingly.
 * The allocated image buffer has to be freed by using
 * av_freep(&pointers[0]).
 *
 * @param align the value to use for buffer size alignment
 * @return the size in bytes required for the image buffer, a negative
 * error code in case of failure
 */
@NoException public static native int av_image_alloc(@Cast("uint8_t**") PointerPointer pointers, IntPointer linesizes,
                   int w, int h, @Cast("AVPixelFormat") int pix_fmt, int align);
@NoException public static native int av_image_alloc(@Cast("uint8_t**") @ByPtrPtr BytePointer pointers, IntPointer linesizes,
                   int w, int h, @Cast("AVPixelFormat") int pix_fmt, int align);
@NoException public static native int av_image_alloc(@Cast("uint8_t**") @ByPtrPtr ByteBuffer pointers, IntBuffer linesizes,
                   int w, int h, @Cast("AVPixelFormat") int pix_fmt, int align);
@NoException public static native int av_image_alloc(@Cast("uint8_t**") @ByPtrPtr byte[] pointers, int[] linesizes,
                   int w, int h, @Cast("AVPixelFormat") int pix_fmt, int align);

/**
 * Copy image plane from src to dst.
 * That is, copy "height" number of lines of "bytewidth" bytes each.
 * The first byte of each successive line is separated by *_linesize
 * bytes.
 *
 * bytewidth must be contained by both absolute values of dst_linesize
 * and src_linesize, otherwise the function behavior is undefined.
 *
 * @param dst_linesize linesize for the image plane in dst
 * @param src_linesize linesize for the image plane in src
 */
@NoException public static native void av_image_copy_plane(@Cast("uint8_t*") BytePointer dst, int dst_linesize,
                         @Cast("const uint8_t*") BytePointer src, int src_linesize,
                         int bytewidth, int height);
@NoException public static native void av_image_copy_plane(@Cast("uint8_t*") ByteBuffer dst, int dst_linesize,
                         @Cast("const uint8_t*") ByteBuffer src, int src_linesize,
                         int bytewidth, int height);
@NoException public static native void av_image_copy_plane(@Cast("uint8_t*") byte[] dst, int dst_linesize,
                         @Cast("const uint8_t*") byte[] src, int src_linesize,
                         int bytewidth, int height);

/**
 * Copy image in src_data to dst_data.
 *
 * @param dst_linesizes linesizes for the image in dst_data
 * @param src_linesizes linesizes for the image in src_data
 */
@NoException public static native void av_image_copy(@Cast("uint8_t**") PointerPointer dst_data, IntPointer dst_linesizes,
                   @Cast("const uint8_t**") PointerPointer src_data, @Const IntPointer src_linesizes,
                   @Cast("AVPixelFormat") int pix_fmt, int width, int height);
@NoException public static native void av_image_copy(@Cast("uint8_t**") @ByPtrPtr BytePointer dst_data, IntPointer dst_linesizes,
                   @Cast("const uint8_t**") @ByPtrPtr BytePointer src_data, @Const IntPointer src_linesizes,
                   @Cast("AVPixelFormat") int pix_fmt, int width, int height);
@NoException public static native void av_image_copy(@Cast("uint8_t**") @ByPtrPtr ByteBuffer dst_data, IntBuffer dst_linesizes,
                   @Cast("const uint8_t**") @ByPtrPtr ByteBuffer src_data, @Const IntBuffer src_linesizes,
                   @Cast("AVPixelFormat") int pix_fmt, int width, int height);
@NoException public static native void av_image_copy(@Cast("uint8_t**") @ByPtrPtr byte[] dst_data, int[] dst_linesizes,
                   @Cast("const uint8_t**") @ByPtrPtr byte[] src_data, @Const int[] src_linesizes,
                   @Cast("AVPixelFormat") int pix_fmt, int width, int height);

/**
 * Copy image data located in uncacheable (e.g. GPU mapped) memory. Where
 * available, this function will use special functionality for reading from such
 * memory, which may result in greatly improved performance compared to plain
 * av_image_copy().
 *
 * The data pointers and the linesizes must be aligned to the maximum required
 * by the CPU architecture.
 *
 * \note The linesize parameters have the type ptrdiff_t here, while they are
 *       int for av_image_copy().
 * \note On x86, the linesizes currently need to be aligned to the cacheline
 *       size (i.e. 64) to get improved performance.
 */
@NoException public static native void av_image_copy_uc_from(@Cast("uint8_t**") PointerPointer dst_data,       @Cast("const ptrdiff_t*") SizeTPointer dst_linesizes,
                           @Cast("const uint8_t**") PointerPointer src_data, @Cast("const ptrdiff_t*") SizeTPointer src_linesizes,
                           @Cast("AVPixelFormat") int pix_fmt, int width, int height);
@NoException public static native void av_image_copy_uc_from(@Cast("uint8_t**") @ByPtrPtr BytePointer dst_data,       @Cast("const ptrdiff_t*") SizeTPointer dst_linesizes,
                           @Cast("const uint8_t**") @ByPtrPtr BytePointer src_data, @Cast("const ptrdiff_t*") SizeTPointer src_linesizes,
                           @Cast("AVPixelFormat") int pix_fmt, int width, int height);
@NoException public static native void av_image_copy_uc_from(@Cast("uint8_t**") @ByPtrPtr ByteBuffer dst_data,       @Cast("const ptrdiff_t*") SizeTPointer dst_linesizes,
                           @Cast("const uint8_t**") @ByPtrPtr ByteBuffer src_data, @Cast("const ptrdiff_t*") SizeTPointer src_linesizes,
                           @Cast("AVPixelFormat") int pix_fmt, int width, int height);
@NoException public static native void av_image_copy_uc_from(@Cast("uint8_t**") @ByPtrPtr byte[] dst_data,       @Cast("const ptrdiff_t*") SizeTPointer dst_linesizes,
                           @Cast("const uint8_t**") @ByPtrPtr byte[] src_data, @Cast("const ptrdiff_t*") SizeTPointer src_linesizes,
                           @Cast("AVPixelFormat") int pix_fmt, int width, int height);

/**
 * Setup the data pointers and linesizes based on the specified image
 * parameters and the provided array.
 *
 * The fields of the given image are filled in by using the src
 * address which points to the image data buffer. Depending on the
 * specified pixel format, one or multiple image data pointers and
 * line sizes will be set.  If a planar format is specified, several
 * pointers will be set pointing to the different picture planes and
 * the line sizes of the different planes will be stored in the
 * lines_sizes array. Call with src == NULL to get the required
 * size for the src buffer.
 *
 * To allocate the buffer and fill in the dst_data and dst_linesize in
 * one call, use av_image_alloc().
 *
 * @param dst_data      data pointers to be filled in
 * @param dst_linesize  linesizes for the image in dst_data to be filled in
 * @param src           buffer which will contain or contains the actual image data, can be NULL
 * @param pix_fmt       the pixel format of the image
 * @param width         the width of the image in pixels
 * @param height        the height of the image in pixels
 * @param align         the value used in src for linesize alignment
 * @return the size in bytes required for src, a negative error code
 * in case of failure
 */
@NoException public static native int av_image_fill_arrays(@Cast("uint8_t**") PointerPointer dst_data, IntPointer dst_linesize,
                         @Cast("const uint8_t*") BytePointer src,
                         @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);
@NoException public static native int av_image_fill_arrays(@Cast("uint8_t**") @ByPtrPtr BytePointer dst_data, IntPointer dst_linesize,
                         @Cast("const uint8_t*") BytePointer src,
                         @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);
@NoException public static native int av_image_fill_arrays(@Cast("uint8_t**") @ByPtrPtr ByteBuffer dst_data, IntBuffer dst_linesize,
                         @Cast("const uint8_t*") ByteBuffer src,
                         @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);
@NoException public static native int av_image_fill_arrays(@Cast("uint8_t**") @ByPtrPtr byte[] dst_data, int[] dst_linesize,
                         @Cast("const uint8_t*") byte[] src,
                         @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);

/**
 * Return the size in bytes of the amount of data required to store an
 * image with the given parameters.
 *
 * @param pix_fmt  the pixel format of the image
 * @param width    the width of the image in pixels
 * @param height   the height of the image in pixels
 * @param align    the assumed linesize alignment
 * @return the buffer size in bytes, a negative error code in case of failure
 */
@NoException public static native int av_image_get_buffer_size(@Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);

/**
 * Copy image data from an image into a buffer.
 *
 * av_image_get_buffer_size() can be used to compute the required size
 * for the buffer to fill.
 *
 * @param dst           a buffer into which picture data will be copied
 * @param dst_size      the size in bytes of dst
 * @param src_data      pointers containing the source image data
 * @param src_linesize  linesizes for the image in src_data
 * @param pix_fmt       the pixel format of the source image
 * @param width         the width of the source image in pixels
 * @param height        the height of the source image in pixels
 * @param align         the assumed linesize alignment for dst
 * @return the number of bytes written to dst, or a negative value
 * (error code) on error
 */
@NoException public static native int av_image_copy_to_buffer(@Cast("uint8_t*") BytePointer dst, int dst_size,
                            @Cast("const uint8_t*const*") PointerPointer src_data, @Const IntPointer src_linesize,
                            @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);
@NoException public static native int av_image_copy_to_buffer(@Cast("uint8_t*") BytePointer dst, int dst_size,
                            @Cast("const uint8_t*const*") @ByPtrPtr BytePointer src_data, @Const IntPointer src_linesize,
                            @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);
@NoException public static native int av_image_copy_to_buffer(@Cast("uint8_t*") ByteBuffer dst, int dst_size,
                            @Cast("const uint8_t*const*") @ByPtrPtr ByteBuffer src_data, @Const IntBuffer src_linesize,
                            @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);
@NoException public static native int av_image_copy_to_buffer(@Cast("uint8_t*") byte[] dst, int dst_size,
                            @Cast("const uint8_t*const*") @ByPtrPtr byte[] src_data, @Const int[] src_linesize,
                            @Cast("AVPixelFormat") int pix_fmt, int width, int height, int align);

/**
 * Check if the given dimension of an image is valid, meaning that all
 * bytes of the image can be addressed with a signed int.
 *
 * @param w the width of the picture
 * @param h the height of the picture
 * @param log_offset the offset to sum to the log level for logging with log_ctx
 * @param log_ctx the parent logging context, it may be NULL
 * @return >= 0 if valid, a negative error code otherwise
 */
@NoException public static native int av_image_check_size(@Cast("unsigned int") int w, @Cast("unsigned int") int h, int log_offset, Pointer log_ctx);

/**
 * Check if the given dimension of an image is valid, meaning that all
 * bytes of a plane of an image with the specified pix_fmt can be addressed
 * with a signed int.
 *
 * @param w the width of the picture
 * @param h the height of the picture
 * @param max_pixels the maximum number of pixels the user wants to accept
 * @param pix_fmt the pixel format, can be AV_PIX_FMT_NONE if unknown.
 * @param log_offset the offset to sum to the log level for logging with log_ctx
 * @param log_ctx the parent logging context, it may be NULL
 * @return >= 0 if valid, a negative error code otherwise
 */
@NoException public static native int av_image_check_size2(@Cast("unsigned int") int w, @Cast("unsigned int") int h, @Cast("int64_t") long max_pixels, @Cast("AVPixelFormat") int pix_fmt, int log_offset, Pointer log_ctx);

/**
 * Check if the given sample aspect ratio of an image is valid.
 *
 * It is considered invalid if the denominator is 0 or if applying the ratio
 * to the image size would make the smaller dimension less than 1. If the
 * sar numerator is 0, it is considered unknown and will return as valid.
 *
 * @param w width of the image
 * @param h height of the image
 * @param sar sample aspect ratio of the image
 * @return 0 if valid, a negative AVERROR code otherwise
 */
@NoException public static native int av_image_check_sar(@Cast("unsigned int") int w, @Cast("unsigned int") int h, @ByVal AVRational sar);

/**
 * Overwrite the image data with black. This is suitable for filling a
 * sub-rectangle of an image, meaning the padding between the right most pixel
 * and the left most pixel on the next line will not be overwritten. For some
 * formats, the image size might be rounded up due to inherent alignment.
 *
 * If the pixel format has alpha, the alpha is cleared to opaque.
 *
 * This can return an error if the pixel format is not supported. Normally, all
 * non-hwaccel pixel formats should be supported.
 *
 * Passing NULL for dst_data is allowed. Then the function returns whether the
 * operation would have succeeded. (It can return an error if the pix_fmt is
 * not supported.)
 *
 * @param dst_data      data pointers to destination image
 * @param dst_linesize  linesizes for the destination image
 * @param pix_fmt       the pixel format of the image
 * @param range         the color range of the image (important for colorspaces such as YUV)
 * @param width         the width of the image in pixels
 * @param height        the height of the image in pixels
 * @return 0 if the image data was cleared, a negative AVERROR code otherwise
 */
@NoException public static native int av_image_fill_black(@Cast("uint8_t**") PointerPointer dst_data, @Cast("const ptrdiff_t*") SizeTPointer dst_linesize,
                        @Cast("AVPixelFormat") int pix_fmt, @Cast("AVColorRange") int range,
                        int width, int height);
@NoException public static native int av_image_fill_black(@Cast("uint8_t**") @ByPtrPtr BytePointer dst_data, @Cast("const ptrdiff_t*") SizeTPointer dst_linesize,
                        @Cast("AVPixelFormat") int pix_fmt, @Cast("AVColorRange") int range,
                        int width, int height);
@NoException public static native int av_image_fill_black(@Cast("uint8_t**") @ByPtrPtr ByteBuffer dst_data, @Cast("const ptrdiff_t*") SizeTPointer dst_linesize,
                        @Cast("AVPixelFormat") int pix_fmt, @Cast("AVColorRange") int range,
                        int width, int height);
@NoException public static native int av_image_fill_black(@Cast("uint8_t**") @ByPtrPtr byte[] dst_data, @Cast("const ptrdiff_t*") SizeTPointer dst_linesize,
                        @Cast("AVPixelFormat") int pix_fmt, @Cast("AVColorRange") int range,
                        int width, int height);

/**
 * \}
 */


// #endif /* AVUTIL_IMGUTILS_H */


// Parsed from <libavutil/downmix_info.h>

/*
 * Copyright (c) 2014 Tim Walker <tdskywalker@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_DOWNMIX_INFO_H
// #define AVUTIL_DOWNMIX_INFO_H

// #include "frame.h"

/**
 * \file
 * audio downmix medatata
 */

/**
 * \addtogroup lavu_audio
 * \{
 */

/**
 * \defgroup downmix_info Audio downmix metadata
 * \{
 */

/**
 * Possible downmix types.
 */
/** enum AVDownmixType */
public static final int
    /** Not indicated. */
    AV_DOWNMIX_TYPE_UNKNOWN = 0,
    /** Lo/Ro 2-channel downmix (Stereo). */
    AV_DOWNMIX_TYPE_LORO = 1,
    /** Lt/Rt 2-channel downmix, Dolby Surround compatible. */
    AV_DOWNMIX_TYPE_LTRT = 2,
    /** Lt/Rt 2-channel downmix, Dolby Pro Logic II compatible. */
    AV_DOWNMIX_TYPE_DPLII = 3,
    /** Number of downmix types. Not part of ABI. */
    AV_DOWNMIX_TYPE_NB = 4;
// Targeting ..\avutil\AVDownmixInfo.java



/**
 * Get a frame's AV_FRAME_DATA_DOWNMIX_INFO side data for editing.
 *
 * If the side data is absent, it is created and added to the frame.
 *
 * @param frame the frame for which the side data is to be obtained or created
 *
 * @return the AVDownmixInfo structure to be edited by the caller, or NULL if
 *         the structure cannot be allocated.
 */
@NoException public static native AVDownmixInfo av_downmix_info_update_side_data(AVFrame frame);

/**
 * \}
 */

/**
 * \}
 */

// #endif /* AVUTIL_DOWNMIX_INFO_H */


// Parsed from <libavutil/stereo3d.h>

/*
 * Copyright (c) 2013 Vittorio Giovara <vittorio.giovara@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * Stereoscopic video
 */

// #ifndef AVUTIL_STEREO3D_H
// #define AVUTIL_STEREO3D_H

// #include <stdint.h>

// #include "frame.h"

/**
 * \addtogroup lavu_video
 * \{
 *
 * \defgroup lavu_video_stereo3d Stereo3D types and functions
 * \{
 */

/**
 * \addtogroup lavu_video_stereo3d
 * A stereoscopic video file consists in multiple views embedded in a single
 * frame, usually describing two views of a scene. This file describes all
 * possible codec-independent view arrangements.
 * */

/**
 * List of possible 3D Types
 */
/** enum AVStereo3DType */
public static final int
    /**
     * Video is not stereoscopic (and metadata has to be there).
     */
    AV_STEREO3D_2D = 0,

    /**
     * Views are next to each other.
     *
     * <pre>{@code {.unparsed}
     *    LLLLRRRR
     *    LLLLRRRR
     *    LLLLRRRR
     *    ...
     * }</pre>
     */
    AV_STEREO3D_SIDEBYSIDE = 1,

    /**
     * Views are on top of each other.
     *
     * <pre>{@code {.unparsed}
     *    LLLLLLLL
     *    LLLLLLLL
     *    RRRRRRRR
     *    RRRRRRRR
     * }</pre>
     */
    AV_STEREO3D_TOPBOTTOM = 2,

    /**
     * Views are alternated temporally.
     *
     * <pre>{@code {.unparsed}
     *     frame0   frame1   frame2   ...
     *    LLLLLLLL RRRRRRRR LLLLLLLL
     *    LLLLLLLL RRRRRRRR LLLLLLLL
     *    LLLLLLLL RRRRRRRR LLLLLLLL
     *    ...      ...      ...
     * }</pre>
     */
    AV_STEREO3D_FRAMESEQUENCE = 3,

    /**
     * Views are packed in a checkerboard-like structure per pixel.
     *
     * <pre>{@code {.unparsed}
     *    LRLRLRLR
     *    RLRLRLRL
     *    LRLRLRLR
     *    ...
     * }</pre>
     */
    AV_STEREO3D_CHECKERBOARD = 4,

    /**
     * Views are next to each other, but when upscaling
     * apply a checkerboard pattern.
     *
     * <pre>{@code {.unparsed}
     *     LLLLRRRR          L L L L    R R R R
     *     LLLLRRRR    =>     L L L L  R R R R
     *     LLLLRRRR          L L L L    R R R R
     *     LLLLRRRR           L L L L  R R R R
     * }</pre>
     */
    AV_STEREO3D_SIDEBYSIDE_QUINCUNX = 5,

    /**
     * Views are packed per line, as if interlaced.
     *
     * <pre>{@code {.unparsed}
     *    LLLLLLLL
     *    RRRRRRRR
     *    LLLLLLLL
     *    ...
     * }</pre>
     */
    AV_STEREO3D_LINES = 6,

    /**
     * Views are packed per column.
     *
     * <pre>{@code {.unparsed}
     *    LRLRLRLR
     *    LRLRLRLR
     *    LRLRLRLR
     *    ...
     * }</pre>
     */
    AV_STEREO3D_COLUMNS = 7;

/**
 * List of possible view types.
 */
/** enum AVStereo3DView */
public static final int
    /**
     * Frame contains two packed views.
     */
    AV_STEREO3D_VIEW_PACKED = 0,

    /**
     * Frame contains only the left view.
     */
    AV_STEREO3D_VIEW_LEFT = 1,

    /**
     * Frame contains only the right view.
     */
    AV_STEREO3D_VIEW_RIGHT = 2;

/**
 * Inverted views, Right/Bottom represents the left view.
 */
public static final int AV_STEREO3D_FLAG_INVERT =     (1 << 0);
// Targeting ..\avutil\AVStereo3D.java



/**
 * Allocate an AVStereo3D structure and set its fields to default values.
 * The resulting struct can be freed using av_freep().
 *
 * @return An AVStereo3D filled with default values or NULL on failure.
 */
@NoException public static native AVStereo3D av_stereo3d_alloc();

/**
 * Allocate a complete AVFrameSideData and add it to the frame.
 *
 * @param frame The frame which side data is added to.
 *
 * @return The AVStereo3D structure to be filled by caller.
 */
@NoException public static native AVStereo3D av_stereo3d_create_side_data(AVFrame frame);

/**
 * Provide a human-readable name of a given stereo3d type.
 *
 * @param type The input stereo3d type value.
 *
 * @return The name of the stereo3d value, or "unknown".
 */
@NoException public static native @Cast("const char*") BytePointer av_stereo3d_type_name(@Cast("unsigned int") int type);

/**
 * Get the AVStereo3DType form a human-readable name.
 *
 * @param name The input string.
 *
 * @return The AVStereo3DType value, or -1 if not found.
 */
@NoException public static native int av_stereo3d_from_name(@Cast("const char*") BytePointer name);
@NoException public static native int av_stereo3d_from_name(String name);

/**
 * \}
 * \}
 */

// #endif /* AVUTIL_STEREO3D_H */


// Parsed from <libavutil/ffversion.h>

/* Automatically generated by version.sh, do not manually edit! */
// #ifndef AVUTIL_FFVERSION_H
// #define AVUTIL_FFVERSION_H
public static final String FFMPEG_VERSION = "4.3.1";
// #endif /* AVUTIL_FFVERSION_H */


// Parsed from <libavutil/motion_vector.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_MOTION_VECTOR_H
// #define AVUTIL_MOTION_VECTOR_H

// #include <stdint.h>
// Targeting ..\avutil\AVMotionVector.java



// #endif /* AVUTIL_MOTION_VECTOR_H */


// Parsed from <libavutil/fifo.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * a very simple circular buffer FIFO implementation
 */

// #ifndef AVUTIL_FIFO_H
// #define AVUTIL_FIFO_H

// #include <stdint.h>
// #include "avutil.h"
// #include "attributes.h"
// Targeting ..\avutil\AVFifoBuffer.java



/**
 * Initialize an AVFifoBuffer.
 * @param size of FIFO
 * @return AVFifoBuffer or NULL in case of memory allocation failure
 */
@NoException public static native AVFifoBuffer av_fifo_alloc(@Cast("unsigned int") int size);

/**
 * Initialize an AVFifoBuffer.
 * @param nmemb number of elements
 * @param size  size of the single element
 * @return AVFifoBuffer or NULL in case of memory allocation failure
 */
@NoException public static native AVFifoBuffer av_fifo_alloc_array(@Cast("size_t") long nmemb, @Cast("size_t") long size);

/**
 * Free an AVFifoBuffer.
 * @param f AVFifoBuffer to free
 */
@NoException public static native void av_fifo_free(AVFifoBuffer f);

/**
 * Free an AVFifoBuffer and reset pointer to NULL.
 * @param f AVFifoBuffer to free
 */
@NoException public static native void av_fifo_freep(@Cast("AVFifoBuffer**") PointerPointer f);
@NoException public static native void av_fifo_freep(@ByPtrPtr AVFifoBuffer f);

/**
 * Reset the AVFifoBuffer to the state right after av_fifo_alloc, in particular it is emptied.
 * @param f AVFifoBuffer to reset
 */
@NoException public static native void av_fifo_reset(AVFifoBuffer f);

/**
 * Return the amount of data in bytes in the AVFifoBuffer, that is the
 * amount of data you can read from it.
 * @param f AVFifoBuffer to read from
 * @return size
 */
@NoException public static native int av_fifo_size(@Const AVFifoBuffer f);

/**
 * Return the amount of space in bytes in the AVFifoBuffer, that is the
 * amount of data you can write into it.
 * @param f AVFifoBuffer to write into
 * @return size
 */
@NoException public static native int av_fifo_space(@Const AVFifoBuffer f);
// Targeting ..\avutil\Func_Pointer_Pointer_int.java


@NoException public static native int av_fifo_generic_peek_at(AVFifoBuffer f, Pointer dest, int offset, int buf_size, Func_Pointer_Pointer_int func);

/**
 * Feed data from an AVFifoBuffer to a user-supplied callback.
 * Similar as av_fifo_gereric_read but without discarding data.
 * @param f AVFifoBuffer to read from
 * @param buf_size number of bytes to read
 * @param func generic read function
 * @param dest data destination
 */
@NoException public static native int av_fifo_generic_peek(AVFifoBuffer f, Pointer dest, int buf_size, Func_Pointer_Pointer_int func);

/**
 * Feed data from an AVFifoBuffer to a user-supplied callback.
 * @param f AVFifoBuffer to read from
 * @param buf_size number of bytes to read
 * @param func generic read function
 * @param dest data destination
 */
@NoException public static native int av_fifo_generic_read(AVFifoBuffer f, Pointer dest, int buf_size, Func_Pointer_Pointer_int func);
// Targeting ..\avutil\Int_func_Pointer_Pointer_int.java


@NoException public static native int av_fifo_generic_write(AVFifoBuffer f, Pointer src, int size, Int_func_Pointer_Pointer_int func);

/**
 * Resize an AVFifoBuffer.
 * In case of reallocation failure, the old FIFO is kept unchanged.
 *
 * @param f AVFifoBuffer to resize
 * @param size new AVFifoBuffer size in bytes
 * @return <0 for failure, >=0 otherwise
 */
@NoException public static native int av_fifo_realloc2(AVFifoBuffer f, @Cast("unsigned int") int size);

/**
 * Enlarge an AVFifoBuffer.
 * In case of reallocation failure, the old FIFO is kept unchanged.
 * The new fifo size may be larger than the requested size.
 *
 * @param f AVFifoBuffer to resize
 * @param additional_space the amount of space in bytes to allocate in addition to av_fifo_size()
 * @return <0 for failure, >=0 otherwise
 */
@NoException public static native int av_fifo_grow(AVFifoBuffer f, @Cast("unsigned int") int additional_space);

/**
 * Read and discard the specified amount of data from an AVFifoBuffer.
 * @param f AVFifoBuffer to read from
 * @param size amount of data to read in bytes
 */
@NoException public static native void av_fifo_drain(AVFifoBuffer f, int size);

/**
 * Return a pointer to the data stored in a FIFO buffer at a certain offset.
 * The FIFO buffer is not modified.
 *
 * @param f    AVFifoBuffer to peek at, f must be non-NULL
 * @param offs an offset in bytes, its absolute value must be less
 *             than the used buffer size or the returned pointer will
 *             point outside to the buffer data.
 *             The used buffer size can be checked with av_fifo_size().
 */
@NoException public static native @Cast("uint8_t*") BytePointer av_fifo_peek2(@Const AVFifoBuffer f, int offs);

// #endif /* AVUTIL_FIFO_H */


// Parsed from <libavutil/audio_fifo.h>

/*
 * Audio FIFO
 * Copyright (c) 2012 Justin Ruggles <justin.ruggles@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * Audio FIFO Buffer
 */

// #ifndef AVUTIL_AUDIO_FIFO_H
// #define AVUTIL_AUDIO_FIFO_H

// #include "avutil.h"
// #include "fifo.h"
// #include "samplefmt.h"
// Targeting ..\avutil\AVAudioFifo.java



/**
 * Free an AVAudioFifo.
 *
 * @param af  AVAudioFifo to free
 */
@NoException public static native void av_audio_fifo_free(AVAudioFifo af);

/**
 * Allocate an AVAudioFifo.
 *
 * @param sample_fmt  sample format
 * @param channels    number of channels
 * @param nb_samples  initial allocation size, in samples
 * @return            newly allocated AVAudioFifo, or NULL on error
 */
@NoException public static native AVAudioFifo av_audio_fifo_alloc(@Cast("AVSampleFormat") int sample_fmt, int channels,
                                 int nb_samples);

/**
 * Reallocate an AVAudioFifo.
 *
 * @param af          AVAudioFifo to reallocate
 * @param nb_samples  new allocation size, in samples
 * @return            0 if OK, or negative AVERROR code on failure
 */
@NoException public static native int av_audio_fifo_realloc(AVAudioFifo af, int nb_samples);

/**
 * Write data to an AVAudioFifo.
 *
 * The AVAudioFifo will be reallocated automatically if the available space
 * is less than nb_samples.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to write to
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to write
 * @return            number of samples actually written, or negative AVERROR
 *                    code on failure. If successful, the number of samples
 *                    actually written will always be nb_samples.
 */
@NoException public static native int av_audio_fifo_write(AVAudioFifo af, @Cast("void**") PointerPointer data, int nb_samples);
@NoException public static native int av_audio_fifo_write(AVAudioFifo af, @Cast("void**") @ByPtrPtr Pointer data, int nb_samples);

/**
 * Peek data from an AVAudioFifo.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to read from
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to peek
 * @return            number of samples actually peek, or negative AVERROR code
 *                    on failure. The number of samples actually peek will not
 *                    be greater than nb_samples, and will only be less than
 *                    nb_samples if av_audio_fifo_size is less than nb_samples.
 */
@NoException public static native int av_audio_fifo_peek(AVAudioFifo af, @Cast("void**") PointerPointer data, int nb_samples);
@NoException public static native int av_audio_fifo_peek(AVAudioFifo af, @Cast("void**") @ByPtrPtr Pointer data, int nb_samples);

/**
 * Peek data from an AVAudioFifo.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to read from
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to peek
 * @param offset      offset from current read position
 * @return            number of samples actually peek, or negative AVERROR code
 *                    on failure. The number of samples actually peek will not
 *                    be greater than nb_samples, and will only be less than
 *                    nb_samples if av_audio_fifo_size is less than nb_samples.
 */
@NoException public static native int av_audio_fifo_peek_at(AVAudioFifo af, @Cast("void**") PointerPointer data, int nb_samples, int offset);
@NoException public static native int av_audio_fifo_peek_at(AVAudioFifo af, @Cast("void**") @ByPtrPtr Pointer data, int nb_samples, int offset);

/**
 * Read data from an AVAudioFifo.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to read from
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to read
 * @return            number of samples actually read, or negative AVERROR code
 *                    on failure. The number of samples actually read will not
 *                    be greater than nb_samples, and will only be less than
 *                    nb_samples if av_audio_fifo_size is less than nb_samples.
 */
@NoException public static native int av_audio_fifo_read(AVAudioFifo af, @Cast("void**") PointerPointer data, int nb_samples);
@NoException public static native int av_audio_fifo_read(AVAudioFifo af, @Cast("void**") @ByPtrPtr Pointer data, int nb_samples);

/**
 * Drain data from an AVAudioFifo.
 *
 * Removes the data without reading it.
 *
 * @param af          AVAudioFifo to drain
 * @param nb_samples  number of samples to drain
 * @return            0 if OK, or negative AVERROR code on failure
 */
@NoException public static native int av_audio_fifo_drain(AVAudioFifo af, int nb_samples);

/**
 * Reset the AVAudioFifo buffer.
 *
 * This empties all data in the buffer.
 *
 * @param af  AVAudioFifo to reset
 */
@NoException public static native void av_audio_fifo_reset(AVAudioFifo af);

/**
 * Get the current number of samples in the AVAudioFifo available for reading.
 *
 * @param af  the AVAudioFifo to query
 * @return    number of samples available for reading
 */
@NoException public static native int av_audio_fifo_size(AVAudioFifo af);

/**
 * Get the current number of samples in the AVAudioFifo available for writing.
 *
 * @param af  the AVAudioFifo to query
 * @return    number of samples available for writing
 */
@NoException public static native int av_audio_fifo_space(AVAudioFifo af);

/**
 * \}
 * \}
 */

// #endif /* AVUTIL_AUDIO_FIFO_H */


// Parsed from <libavutil/hwcontext.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_HWCONTEXT_H
// #define AVUTIL_HWCONTEXT_H

// #include "buffer.h"
// #include "frame.h"
// #include "log.h"
// #include "pixfmt.h"

/** enum AVHWDeviceType */
public static final int
    AV_HWDEVICE_TYPE_NONE = 0,
    AV_HWDEVICE_TYPE_VDPAU = 1,
    AV_HWDEVICE_TYPE_CUDA = 2,
    AV_HWDEVICE_TYPE_VAAPI = 3,
    AV_HWDEVICE_TYPE_DXVA2 = 4,
    AV_HWDEVICE_TYPE_QSV = 5,
    AV_HWDEVICE_TYPE_VIDEOTOOLBOX = 6,
    AV_HWDEVICE_TYPE_D3D11VA = 7,
    AV_HWDEVICE_TYPE_DRM = 8,
    AV_HWDEVICE_TYPE_OPENCL = 9,
    AV_HWDEVICE_TYPE_MEDIACODEC = 10,
    AV_HWDEVICE_TYPE_VULKAN = 11;
// Targeting ..\avutil\AVHWDeviceInternal.java


// Targeting ..\avutil\AVHWDeviceContext.java


// Targeting ..\avutil\AVHWFramesInternal.java


// Targeting ..\avutil\AVHWFramesContext.java



/**
 * Look up an AVHWDeviceType by name.
 *
 * @param name String name of the device type (case-insensitive).
 * @return The type from enum AVHWDeviceType, or AV_HWDEVICE_TYPE_NONE if
 *         not found.
 */
@NoException public static native @Cast("AVHWDeviceType") int av_hwdevice_find_type_by_name(@Cast("const char*") BytePointer name);
@NoException public static native @Cast("AVHWDeviceType") int av_hwdevice_find_type_by_name(String name);

/** Get the string name of an AVHWDeviceType.
 *
 * @param type Type from enum AVHWDeviceType.
 * @return Pointer to a static string containing the name, or NULL if the type
 *         is not valid.
 */
@NoException public static native @Cast("const char*") BytePointer av_hwdevice_get_type_name(@Cast("AVHWDeviceType") int type);

/**
 * Iterate over supported device types.
 *
 * @param type AV_HWDEVICE_TYPE_NONE initially, then the previous type
 *             returned by this function in subsequent iterations.
 * @return The next usable device type from enum AVHWDeviceType, or
 *         AV_HWDEVICE_TYPE_NONE if there are no more.
 */
@NoException public static native @Cast("AVHWDeviceType") int av_hwdevice_iterate_types(@Cast("AVHWDeviceType") int prev);

/**
 * Allocate an AVHWDeviceContext for a given hardware type.
 *
 * @param type the type of the hardware device to allocate.
 * @return a reference to the newly created AVHWDeviceContext on success or NULL
 *         on failure.
 */
@NoException public static native AVBufferRef av_hwdevice_ctx_alloc(@Cast("AVHWDeviceType") int type);

/**
 * Finalize the device context before use. This function must be called after
 * the context is filled with all the required information and before it is
 * used in any way.
 *
 * @param ref a reference to the AVHWDeviceContext
 * @return 0 on success, a negative AVERROR code on failure
 */
@NoException public static native int av_hwdevice_ctx_init(AVBufferRef ref);

/**
 * Open a device of the specified type and create an AVHWDeviceContext for it.
 *
 * This is a convenience function intended to cover the simple cases. Callers
 * who need to fine-tune device creation/management should open the device
 * manually and then wrap it in an AVHWDeviceContext using
 * av_hwdevice_ctx_alloc()/av_hwdevice_ctx_init().
 *
 * The returned context is already initialized and ready for use, the caller
 * should not call av_hwdevice_ctx_init() on it. The user_opaque/free fields of
 * the created AVHWDeviceContext are set by this function and should not be
 * touched by the caller.
 *
 * @param device_ctx On success, a reference to the newly-created device context
 *                   will be written here. The reference is owned by the caller
 *                   and must be released with av_buffer_unref() when no longer
 *                   needed. On failure, NULL will be written to this pointer.
 * @param type The type of the device to create.
 * @param device A type-specific string identifying the device to open.
 * @param opts A dictionary of additional (type-specific) options to use in
 *             opening the device. The dictionary remains owned by the caller.
 * @param flags currently unused
 *
 * @return 0 on success, a negative AVERROR code on failure.
 */
@NoException public static native int av_hwdevice_ctx_create(@Cast("AVBufferRef**") PointerPointer device_ctx, @Cast("AVHWDeviceType") int type,
                           @Cast("const char*") BytePointer device, AVDictionary opts, int flags);
@NoException public static native int av_hwdevice_ctx_create(@ByPtrPtr AVBufferRef device_ctx, @Cast("AVHWDeviceType") int type,
                           @Cast("const char*") BytePointer device, AVDictionary opts, int flags);
@NoException public static native int av_hwdevice_ctx_create(@ByPtrPtr AVBufferRef device_ctx, @Cast("AVHWDeviceType") int type,
                           String device, AVDictionary opts, int flags);

/**
 * Create a new device of the specified type from an existing device.
 *
 * If the source device is a device of the target type or was originally
 * derived from such a device (possibly through one or more intermediate
 * devices of other types), then this will return a reference to the
 * existing device of the same type as is requested.
 *
 * Otherwise, it will attempt to derive a new device from the given source
 * device.  If direct derivation to the new type is not implemented, it will
 * attempt the same derivation from each ancestor of the source device in
 * turn looking for an implemented derivation method.
 *
 * @param dst_ctx On success, a reference to the newly-created
 *                AVHWDeviceContext.
 * @param type    The type of the new device to create.
 * @param src_ctx A reference to an existing AVHWDeviceContext which will be
 *                used to create the new device.
 * @param flags   Currently unused; should be set to zero.
 * @return        Zero on success, a negative AVERROR code on failure.
 */
@NoException public static native int av_hwdevice_ctx_create_derived(@Cast("AVBufferRef**") PointerPointer dst_ctx,
                                   @Cast("AVHWDeviceType") int type,
                                   AVBufferRef src_ctx, int flags);
@NoException public static native int av_hwdevice_ctx_create_derived(@ByPtrPtr AVBufferRef dst_ctx,
                                   @Cast("AVHWDeviceType") int type,
                                   AVBufferRef src_ctx, int flags);

/**
 * Create a new device of the specified type from an existing device.
 *
 * This function performs the same action as av_hwdevice_ctx_create_derived,
 * however, it is able to set options for the new device to be derived.
 *
 * @param dst_ctx On success, a reference to the newly-created
 *                AVHWDeviceContext.
 * @param type    The type of the new device to create.
 * @param src_ctx A reference to an existing AVHWDeviceContext which will be
 *                used to create the new device.
 * @param options Options for the new device to create, same format as in
 *                av_hwdevice_ctx_create.
 * @param flags   Currently unused; should be set to zero.
 * @return        Zero on success, a negative AVERROR code on failure.
 */
@NoException public static native int av_hwdevice_ctx_create_derived_opts(@Cast("AVBufferRef**") PointerPointer dst_ctx,
                                        @Cast("AVHWDeviceType") int type,
                                        AVBufferRef src_ctx,
                                        AVDictionary options, int flags);
@NoException public static native int av_hwdevice_ctx_create_derived_opts(@ByPtrPtr AVBufferRef dst_ctx,
                                        @Cast("AVHWDeviceType") int type,
                                        AVBufferRef src_ctx,
                                        AVDictionary options, int flags);

/**
 * Allocate an AVHWFramesContext tied to a given device context.
 *
 * @param device_ctx a reference to a AVHWDeviceContext. This function will make
 *                   a new reference for internal use, the one passed to the
 *                   function remains owned by the caller.
 * @return a reference to the newly created AVHWFramesContext on success or NULL
 *         on failure.
 */
@NoException public static native AVBufferRef av_hwframe_ctx_alloc(AVBufferRef device_ctx);

/**
 * Finalize the context before use. This function must be called after the
 * context is filled with all the required information and before it is attached
 * to any frames.
 *
 * @param ref a reference to the AVHWFramesContext
 * @return 0 on success, a negative AVERROR code on failure
 */
@NoException public static native int av_hwframe_ctx_init(AVBufferRef ref);

/**
 * Allocate a new frame attached to the given AVHWFramesContext.
 *
 * @param hwframe_ctx a reference to an AVHWFramesContext
 * @param frame an empty (freshly allocated or unreffed) frame to be filled with
 *              newly allocated buffers.
 * @param flags currently unused, should be set to zero
 * @return 0 on success, a negative AVERROR code on failure
 */
@NoException public static native int av_hwframe_get_buffer(AVBufferRef hwframe_ctx, AVFrame frame, int flags);

/**
 * Copy data to or from a hw surface. At least one of dst/src must have an
 * AVHWFramesContext attached.
 *
 * If src has an AVHWFramesContext attached, then the format of dst (if set)
 * must use one of the formats returned by av_hwframe_transfer_get_formats(src,
 * AV_HWFRAME_TRANSFER_DIRECTION_FROM).
 * If dst has an AVHWFramesContext attached, then the format of src must use one
 * of the formats returned by av_hwframe_transfer_get_formats(dst,
 * AV_HWFRAME_TRANSFER_DIRECTION_TO)
 *
 * dst may be "clean" (i.e. with data/buf pointers unset), in which case the
 * data buffers will be allocated by this function using av_frame_get_buffer().
 * If dst->format is set, then this format will be used, otherwise (when
 * dst->format is AV_PIX_FMT_NONE) the first acceptable format will be chosen.
 *
 * The two frames must have matching allocated dimensions (i.e. equal to
 * AVHWFramesContext.width/height), since not all device types support
 * transferring a sub-rectangle of the whole surface. The display dimensions
 * (i.e. AVFrame.width/height) may be smaller than the allocated dimensions, but
 * also have to be equal for both frames. When the display dimensions are
 * smaller than the allocated dimensions, the content of the padding in the
 * destination frame is unspecified.
 *
 * @param dst the destination frame. dst is not touched on failure.
 * @param src the source frame.
 * @param flags currently unused, should be set to zero
 * @return 0 on success, a negative AVERROR error code on failure.
 */
@NoException public static native int av_hwframe_transfer_data(AVFrame dst, @Const AVFrame src, int flags);

/** enum AVHWFrameTransferDirection */
public static final int
    /**
     * Transfer the data from the queried hw frame.
     */
    AV_HWFRAME_TRANSFER_DIRECTION_FROM = 0,

    /**
     * Transfer the data to the queried hw frame.
     */
    AV_HWFRAME_TRANSFER_DIRECTION_TO = 1;

/**
 * Get a list of possible source or target formats usable in
 * av_hwframe_transfer_data().
 *
 * @param hwframe_ctx the frame context to obtain the information for
 * @param dir the direction of the transfer
 * @param formats the pointer to the output format list will be written here.
 *                The list is terminated with AV_PIX_FMT_NONE and must be freed
 *                by the caller when no longer needed using av_free().
 *                If this function returns successfully, the format list will
 *                have at least one item (not counting the terminator).
 *                On failure, the contents of this pointer are unspecified.
 * @param flags currently unused, should be set to zero
 * @return 0 on success, a negative AVERROR code on failure.
 */
@NoException public static native int av_hwframe_transfer_get_formats(AVBufferRef hwframe_ctx,
                                    @Cast("AVHWFrameTransferDirection") int dir,
                                    @Cast("AVPixelFormat**") PointerPointer formats, int flags);
@NoException public static native int av_hwframe_transfer_get_formats(AVBufferRef hwframe_ctx,
                                    @Cast("AVHWFrameTransferDirection") int dir,
                                    @Cast("AVPixelFormat**") @ByPtrPtr IntPointer formats, int flags);
@NoException public static native int av_hwframe_transfer_get_formats(AVBufferRef hwframe_ctx,
                                    @Cast("AVHWFrameTransferDirection") int dir,
                                    @Cast("AVPixelFormat**") @ByPtrPtr IntBuffer formats, int flags);
@NoException public static native int av_hwframe_transfer_get_formats(AVBufferRef hwframe_ctx,
                                    @Cast("AVHWFrameTransferDirection") int dir,
                                    @Cast("AVPixelFormat**") @ByPtrPtr int[] formats, int flags);
// Targeting ..\avutil\AVHWFramesConstraints.java



/**
 * Allocate a HW-specific configuration structure for a given HW device.
 * After use, the user must free all members as required by the specific
 * hardware structure being used, then free the structure itself with
 * av_free().
 *
 * @param device_ctx a reference to the associated AVHWDeviceContext.
 * @return The newly created HW-specific configuration structure on
 *         success or NULL on failure.
 */
@NoException public static native Pointer av_hwdevice_hwconfig_alloc(AVBufferRef device_ctx);

/**
 * Get the constraints on HW frames given a device and the HW-specific
 * configuration to be used with that device.  If no HW-specific
 * configuration is provided, returns the maximum possible capabilities
 * of the device.
 *
 * @param ref a reference to the associated AVHWDeviceContext.
 * @param hwconfig a filled HW-specific configuration structure, or NULL
 *        to return the maximum possible capabilities of the device.
 * @return AVHWFramesConstraints structure describing the constraints
 *         on the device, or NULL if not available.
 */
@NoException public static native AVHWFramesConstraints av_hwdevice_get_hwframe_constraints(AVBufferRef ref,
                                                           @Const Pointer hwconfig);

/**
 * Free an AVHWFrameConstraints structure.
 *
 * @param constraints The (filled or unfilled) AVHWFrameConstraints structure.
 */
@NoException public static native void av_hwframe_constraints_free(@Cast("AVHWFramesConstraints**") PointerPointer constraints);
@NoException public static native void av_hwframe_constraints_free(@ByPtrPtr AVHWFramesConstraints constraints);


/**
 * Flags to apply to frame mappings.
 */
/** enum  */
public static final int
    /**
     * The mapping must be readable.
     */
    AV_HWFRAME_MAP_READ      = 1 << 0,
    /**
     * The mapping must be writeable.
     */
    AV_HWFRAME_MAP_WRITE     = 1 << 1,
    /**
     * The mapped frame will be overwritten completely in subsequent
     * operations, so the current frame data need not be loaded.  Any values
     * which are not overwritten are unspecified.
     */
    AV_HWFRAME_MAP_OVERWRITE = 1 << 2,
    /**
     * The mapping must be direct.  That is, there must not be any copying in
     * the map or unmap steps.  Note that performance of direct mappings may
     * be much lower than normal memory.
     */
    AV_HWFRAME_MAP_DIRECT    = 1 << 3;

/**
 * Map a hardware frame.
 *
 * This has a number of different possible effects, depending on the format
 * and origin of the src and dst frames.  On input, src should be a usable
 * frame with valid buffers and dst should be blank (typically as just created
 * by av_frame_alloc()).  src should have an associated hwframe context, and
 * dst may optionally have a format and associated hwframe context.
 *
 * If src was created by mapping a frame from the hwframe context of dst,
 * then this function undoes the mapping - dst is replaced by a reference to
 * the frame that src was originally mapped from.
 *
 * If both src and dst have an associated hwframe context, then this function
 * attempts to map the src frame from its hardware context to that of dst and
 * then fill dst with appropriate data to be usable there.  This will only be
 * possible if the hwframe contexts and associated devices are compatible -
 * given compatible devices, av_hwframe_ctx_create_derived() can be used to
 * create a hwframe context for dst in which mapping should be possible.
 *
 * If src has a hwframe context but dst does not, then the src frame is
 * mapped to normal memory and should thereafter be usable as a normal frame.
 * If the format is set on dst, then the mapping will attempt to create dst
 * with that format and fail if it is not possible.  If format is unset (is
 * AV_PIX_FMT_NONE) then dst will be mapped with whatever the most appropriate
 * format to use is (probably the sw_format of the src hwframe context).
 *
 * A return value of AVERROR(ENOSYS) indicates that the mapping is not
 * possible with the given arguments and hwframe setup, while other return
 * values indicate that it failed somehow.
 *
 * @param dst Destination frame, to contain the mapping.
 * @param src Source frame, to be mapped.
 * @param flags Some combination of AV_HWFRAME_MAP_* flags.
 * @return Zero on success, negative AVERROR code on failure.
 */
@NoException public static native int av_hwframe_map(AVFrame dst, @Const AVFrame src, int flags);


/**
 * Create and initialise an AVHWFramesContext as a mapping of another existing
 * AVHWFramesContext on a different device.
 *
 * av_hwframe_ctx_init() should not be called after this.
 *
 * @param derived_frame_ctx  On success, a reference to the newly created
 *                           AVHWFramesContext.
 * @param derived_device_ctx A reference to the device to create the new
 *                           AVHWFramesContext on.
 * @param source_frame_ctx   A reference to an existing AVHWFramesContext
 *                           which will be mapped to the derived context.
 * @param flags  Some combination of AV_HWFRAME_MAP_* flags, defining the
 *               mapping parameters to apply to frames which are allocated
 *               in the derived device.
 * @return       Zero on success, negative AVERROR code on failure.
 */
@NoException public static native int av_hwframe_ctx_create_derived(@Cast("AVBufferRef**") PointerPointer derived_frame_ctx,
                                  @Cast("AVPixelFormat") int format,
                                  AVBufferRef derived_device_ctx,
                                  AVBufferRef source_frame_ctx,
                                  int flags);
@NoException public static native int av_hwframe_ctx_create_derived(@ByPtrPtr AVBufferRef derived_frame_ctx,
                                  @Cast("AVPixelFormat") int format,
                                  AVBufferRef derived_device_ctx,
                                  AVBufferRef source_frame_ctx,
                                  int flags);

// #endif /* AVUTIL_HWCONTEXT_H */


// Parsed from <libavutil/adler32.h>

/*
 * copyright (c) 2006 Mans Rullgard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_adler32
 * Public header for Adler-32 hash function implementation.
 */

// #ifndef AVUTIL_ADLER32_H
// #define AVUTIL_ADLER32_H

// #include <stdint.h>
// #include "attributes.h"

/**
 * \defgroup lavu_adler32 Adler-32
 * \ingroup lavu_hash
 * Adler-32 hash function implementation.
 *
 * \{
 */

/**
 * Calculate the Adler32 checksum of a buffer.
 *
 * Passing the return value to a subsequent av_adler32_update() call
 * allows the checksum of multiple buffers to be calculated as though
 * they were concatenated.
 *
 * @param adler initial checksum value
 * @param buf   pointer to input buffer
 * @param len   size of input buffer
 * @return      updated checksum
 */
@NoException public static native @Cast("unsigned long") long av_adler32_update(@Cast("unsigned long") long adler, @Cast("const uint8_t*") BytePointer buf,
                                @Cast("unsigned int") int len);
@NoException public static native @Cast("unsigned long") long av_adler32_update(@Cast("unsigned long") long adler, @Cast("const uint8_t*") ByteBuffer buf,
                                @Cast("unsigned int") int len);
@NoException public static native @Cast("unsigned long") long av_adler32_update(@Cast("unsigned long") long adler, @Cast("const uint8_t*") byte[] buf,
                                @Cast("unsigned int") int len);

/**
 * \}
 */

// #endif /* AVUTIL_ADLER32_H */


// Parsed from <libavutil/aes.h>

/*
 * copyright (c) 2007 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_AES_H
// #define AVUTIL_AES_H

// #include <stdint.h>

// #include "attributes.h"
// #include "version.h"

/**
 * \defgroup lavu_aes AES
 * \ingroup lavu_crypto
 * \{
 */

@MemberGetter public static native int av_aes_size();
// Targeting ..\avutil\AVAES.java



/**
 * Allocate an AVAES context.
 */
@NoException public static native AVAES av_aes_alloc();

/**
 * Initialize an AVAES context.
 * @param key_bits 128, 192 or 256
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native int av_aes_init(AVAES a, @Cast("const uint8_t*") BytePointer key, int key_bits, int decrypt);
@NoException public static native int av_aes_init(AVAES a, @Cast("const uint8_t*") ByteBuffer key, int key_bits, int decrypt);
@NoException public static native int av_aes_init(AVAES a, @Cast("const uint8_t*") byte[] key, int key_bits, int decrypt);

/**
 * Encrypt or decrypt a buffer using a previously initialized context.
 * @param count number of 16 byte blocks
 * @param dst destination array, can be equal to src
 * @param src source array, can be equal to dst
 * @param iv initialization vector for CBC mode, if NULL then ECB will be used
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_aes_crypt(AVAES a, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_aes_crypt(AVAES a, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_aes_crypt(AVAES a, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \}
 */

// #endif /* AVUTIL_AES_H */


// Parsed from <libavutil/aes_ctr.h>

/*
 * AES-CTR cipher
 * Copyright (c) 2015 Eran Kornblau <erankor at gmail dot com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_AES_CTR_H
// #define AVUTIL_AES_CTR_H

// #include <stdint.h>

// #include "attributes.h"
// #include "version.h"

public static final int AES_CTR_KEY_SIZE = (16);
public static final int AES_CTR_IV_SIZE = (8);
// Targeting ..\avutil\AVAESCTR.java



/**
 * Allocate an AVAESCTR context.
 */
@NoException public static native AVAESCTR av_aes_ctr_alloc();

/**
 * Initialize an AVAESCTR context.
 * @param key encryption key, must have a length of AES_CTR_KEY_SIZE
 */
@NoException public static native int av_aes_ctr_init(AVAESCTR a, @Cast("const uint8_t*") BytePointer key);
@NoException public static native int av_aes_ctr_init(AVAESCTR a, @Cast("const uint8_t*") ByteBuffer key);
@NoException public static native int av_aes_ctr_init(AVAESCTR a, @Cast("const uint8_t*") byte[] key);

/**
 * Release an AVAESCTR context.
 */
@NoException public static native void av_aes_ctr_free(AVAESCTR a);

/**
 * Process a buffer using a previously initialized context.
 * @param dst destination array, can be equal to src
 * @param src source array, can be equal to dst
 * @param size the size of src and dst
 */
@NoException public static native void av_aes_ctr_crypt(AVAESCTR a, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int size);
@NoException public static native void av_aes_ctr_crypt(AVAESCTR a, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int size);
@NoException public static native void av_aes_ctr_crypt(AVAESCTR a, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int size);

/**
 * Get the current iv
 */
@NoException public static native @Cast("const uint8_t*") BytePointer av_aes_ctr_get_iv(AVAESCTR a);

/**
 * Generate a random iv
 */
@NoException public static native void av_aes_ctr_set_random_iv(AVAESCTR a);

/**
 * Forcefully change the 8-byte iv
 */
@NoException public static native void av_aes_ctr_set_iv(AVAESCTR a, @Cast("const uint8_t*") BytePointer iv);
@NoException public static native void av_aes_ctr_set_iv(AVAESCTR a, @Cast("const uint8_t*") ByteBuffer iv);
@NoException public static native void av_aes_ctr_set_iv(AVAESCTR a, @Cast("const uint8_t*") byte[] iv);

/**
 * Forcefully change the "full" 16-byte iv, including the counter
 */
@NoException public static native void av_aes_ctr_set_full_iv(AVAESCTR a, @Cast("const uint8_t*") BytePointer iv);
@NoException public static native void av_aes_ctr_set_full_iv(AVAESCTR a, @Cast("const uint8_t*") ByteBuffer iv);
@NoException public static native void av_aes_ctr_set_full_iv(AVAESCTR a, @Cast("const uint8_t*") byte[] iv);

/**
 * Increment the top 64 bit of the iv (performed after each frame)
 */
@NoException public static native void av_aes_ctr_increment_iv(AVAESCTR a);

/**
 * \}
 */

// #endif /* AVUTIL_AES_CTR_H */


// Parsed from <libavutil/base64.h>

/*
 * Copyright (c) 2006 Ryan Martell. (rdm4@martellventures.com)
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_BASE64_H
// #define AVUTIL_BASE64_H

// #include <stdint.h>

/**
 * \defgroup lavu_base64 Base64
 * \ingroup lavu_crypto
 * \{
 */

/**
 * Decode a base64-encoded string.
 *
 * @param out      buffer for decoded data
 * @param in       null-terminated input string
 * @param out_size size in bytes of the out buffer, must be at
 *                 least 3/4 of the length of in, that is AV_BASE64_DECODE_SIZE(strlen(in))
 * @return         number of bytes written, or a negative value in case of
 *                 invalid input
 */
@NoException public static native int av_base64_decode(@Cast("uint8_t*") BytePointer out, @Cast("const char*") BytePointer in, int out_size);
@NoException public static native int av_base64_decode(@Cast("uint8_t*") ByteBuffer out, String in, int out_size);
@NoException public static native int av_base64_decode(@Cast("uint8_t*") byte[] out, @Cast("const char*") BytePointer in, int out_size);
@NoException public static native int av_base64_decode(@Cast("uint8_t*") BytePointer out, String in, int out_size);
@NoException public static native int av_base64_decode(@Cast("uint8_t*") ByteBuffer out, @Cast("const char*") BytePointer in, int out_size);
@NoException public static native int av_base64_decode(@Cast("uint8_t*") byte[] out, String in, int out_size);

/**
 * Calculate the output size in bytes needed to decode a base64 string
 * with length x to a data buffer.
 */
// #define AV_BASE64_DECODE_SIZE(x) ((x) * 3L / 4)

/**
 * Encode data to base64 and null-terminate.
 *
 * @param out      buffer for encoded data
 * @param out_size size in bytes of the out buffer (including the
 *                 null terminator), must be at least AV_BASE64_SIZE(in_size)
 * @param in       input buffer containing the data to encode
 * @param in_size  size in bytes of the in buffer
 * @return         out or NULL in case of error
 */
@NoException public static native @Cast("char*") BytePointer av_base64_encode(@Cast("char*") BytePointer out, int out_size, @Cast("const uint8_t*") BytePointer in, int in_size);
@NoException public static native @Cast("char*") ByteBuffer av_base64_encode(@Cast("char*") ByteBuffer out, int out_size, @Cast("const uint8_t*") ByteBuffer in, int in_size);
@NoException public static native @Cast("char*") byte[] av_base64_encode(@Cast("char*") byte[] out, int out_size, @Cast("const uint8_t*") byte[] in, int in_size);

/**
 * Calculate the output size needed to base64-encode x bytes to a
 * null-terminated string.
 */
// #define AV_BASE64_SIZE(x)  (((x)+2) / 3 * 4 + 1)

 /**
  * \}
  */

// #endif /* AVUTIL_BASE64_H */


// Parsed from <libavutil/blowfish.h>

/*
 * Blowfish algorithm
 * Copyright (c) 2012 Samuel Pitoiset
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_BLOWFISH_H
// #define AVUTIL_BLOWFISH_H

// #include <stdint.h>

/**
 * \defgroup lavu_blowfish Blowfish
 * \ingroup lavu_crypto
 * \{
 */

public static final int AV_BF_ROUNDS = 16;
// Targeting ..\avutil\AVBlowfish.java



/**
 * Allocate an AVBlowfish context.
 */
@NoException public static native AVBlowfish av_blowfish_alloc();

/**
 * Initialize an AVBlowfish context.
 *
 * @param ctx an AVBlowfish context
 * @param key a key
 * @param key_len length of the key
 */
@NoException public static native void av_blowfish_init(AVBlowfish ctx, @Cast("const uint8_t*") BytePointer key, int key_len);
@NoException public static native void av_blowfish_init(AVBlowfish ctx, @Cast("const uint8_t*") ByteBuffer key, int key_len);
@NoException public static native void av_blowfish_init(AVBlowfish ctx, @Cast("const uint8_t*") byte[] key, int key_len);

/**
 * Encrypt or decrypt a buffer using a previously initialized context.
 *
 * @param ctx an AVBlowfish context
 * @param xl left four bytes halves of input to be encrypted
 * @param xr right four bytes halves of input to be encrypted
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_blowfish_crypt_ecb(AVBlowfish ctx, @Cast("uint32_t*") IntPointer xl, @Cast("uint32_t*") IntPointer xr,
                           int decrypt);
@NoException public static native void av_blowfish_crypt_ecb(AVBlowfish ctx, @Cast("uint32_t*") IntBuffer xl, @Cast("uint32_t*") IntBuffer xr,
                           int decrypt);
@NoException public static native void av_blowfish_crypt_ecb(AVBlowfish ctx, @Cast("uint32_t*") int[] xl, @Cast("uint32_t*") int[] xr,
                           int decrypt);

/**
 * Encrypt or decrypt a buffer using a previously initialized context.
 *
 * @param ctx an AVBlowfish context
 * @param dst destination array, can be equal to src
 * @param src source array, can be equal to dst
 * @param count number of 8 byte blocks
 * @param iv initialization vector for CBC mode, if NULL ECB will be used
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_blowfish_crypt(AVBlowfish ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src,
                       int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_blowfish_crypt(AVBlowfish ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src,
                       int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_blowfish_crypt(AVBlowfish ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src,
                       int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \}
 */

// #endif /* AVUTIL_BLOWFISH_H */


// Parsed from <libavutil/cast5.h>

/*
 * An implementation of the CAST128 algorithm as mentioned in RFC2144
 * Copyright (c) 2014 Supraja Meedinti
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_CAST5_H
// #define AVUTIL_CAST5_H

// #include <stdint.h>


/**
  * \file
  * \brief Public header for libavutil CAST5 algorithm
  * \defgroup lavu_cast5 CAST5
  * \ingroup lavu_crypto
  * \{
  */

@MemberGetter public static native int av_cast5_size();
// Targeting ..\avutil\AVCAST5.java



/**
  * Allocate an AVCAST5 context
  * To free the struct: av_free(ptr)
  */
@NoException public static native AVCAST5 av_cast5_alloc();
/**
  * Initialize an AVCAST5 context.
  *
  * @param ctx an AVCAST5 context
  * @param key a key of 5,6,...16 bytes used for encryption/decryption
  * @param key_bits number of keybits: possible are 40,48,...,128
  * @return 0 on success, less than 0 on failure
 */
@NoException public static native int av_cast5_init(AVCAST5 ctx, @Cast("const uint8_t*") BytePointer key, int key_bits);
@NoException public static native int av_cast5_init(AVCAST5 ctx, @Cast("const uint8_t*") ByteBuffer key, int key_bits);
@NoException public static native int av_cast5_init(AVCAST5 ctx, @Cast("const uint8_t*") byte[] key, int key_bits);

/**
  * Encrypt or decrypt a buffer using a previously initialized context, ECB mode only
  *
  * @param ctx an AVCAST5 context
  * @param dst destination array, can be equal to src
  * @param src source array, can be equal to dst
  * @param count number of 8 byte blocks
  * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_cast5_crypt(AVCAST5 ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count, int decrypt);
@NoException public static native void av_cast5_crypt(AVCAST5 ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count, int decrypt);
@NoException public static native void av_cast5_crypt(AVCAST5 ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count, int decrypt);

/**
  * Encrypt or decrypt a buffer using a previously initialized context
  *
  * @param ctx an AVCAST5 context
  * @param dst destination array, can be equal to src
  * @param src source array, can be equal to dst
  * @param count number of 8 byte blocks
  * @param iv initialization vector for CBC mode, NULL for ECB mode
  * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_cast5_crypt2(AVCAST5 ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_cast5_crypt2(AVCAST5 ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_cast5_crypt2(AVCAST5 ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count, @Cast("uint8_t*") byte[] iv, int decrypt);
/**
 * \}
 */
// #endif /* AVUTIL_CAST5_H */


// Parsed from <libavutil/camellia.h>

/*
 * An implementation of the CAMELLIA algorithm as mentioned in RFC3713
 * Copyright (c) 2014 Supraja Meedinti
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_CAMELLIA_H
// #define AVUTIL_CAMELLIA_H

// #include <stdint.h>


/**
  * \file
  * \brief Public header for libavutil CAMELLIA algorithm
  * \defgroup lavu_camellia CAMELLIA
  * \ingroup lavu_crypto
  * \{
  */

@MemberGetter public static native int av_camellia_size();
// Targeting ..\avutil\AVCAMELLIA.java



/**
  * Allocate an AVCAMELLIA context
  * To free the struct: av_free(ptr)
  */
@NoException public static native AVCAMELLIA av_camellia_alloc();

/**
  * Initialize an AVCAMELLIA context.
  *
  * @param ctx an AVCAMELLIA context
  * @param key a key of 16, 24, 32 bytes used for encryption/decryption
  * @param key_bits number of keybits: possible are 128, 192, 256
 */
@NoException public static native int av_camellia_init(AVCAMELLIA ctx, @Cast("const uint8_t*") BytePointer key, int key_bits);
@NoException public static native int av_camellia_init(AVCAMELLIA ctx, @Cast("const uint8_t*") ByteBuffer key, int key_bits);
@NoException public static native int av_camellia_init(AVCAMELLIA ctx, @Cast("const uint8_t*") byte[] key, int key_bits);

/**
  * Encrypt or decrypt a buffer using a previously initialized context
  *
  * @param ctx an AVCAMELLIA context
  * @param dst destination array, can be equal to src
  * @param src source array, can be equal to dst
  * @param count number of 16 byte blocks
  * \paran iv initialization vector for CBC mode, NULL for ECB mode
  * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_camellia_crypt(AVCAMELLIA ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_camellia_crypt(AVCAMELLIA ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_camellia_crypt(AVCAMELLIA ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \}
 */
// #endif /* AVUTIL_CAMELLIA_H */


// Parsed from <libavutil/crc.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_crc32
 * Public header for CRC hash function implementation.
 */

// #ifndef AVUTIL_CRC_H
// #define AVUTIL_CRC_H

// #include <stdint.h>
// #include <stddef.h>
// #include "attributes.h"
// #include "version.h"

/**
 * \defgroup lavu_crc32 CRC
 * \ingroup lavu_hash
 * CRC (Cyclic Redundancy Check) hash function implementation.
 *
 * This module supports numerous CRC polynomials, in addition to the most
 * widely used CRC-32-IEEE. See \ref AVCRCId for a list of available
 * polynomials.
 *
 * \{
 */

/** enum AVCRCId */
public static final int
    AV_CRC_8_ATM = 0,
    AV_CRC_16_ANSI = 1,
    AV_CRC_16_CCITT = 2,
    AV_CRC_32_IEEE = 3,
    AV_CRC_32_IEEE_LE = 4,  /*< reversed bitorder version of AV_CRC_32_IEEE */
    AV_CRC_16_ANSI_LE = 5,  /*< reversed bitorder version of AV_CRC_16_ANSI */
    AV_CRC_24_IEEE = 6,
    AV_CRC_8_EBU = 7,
    AV_CRC_MAX = 8;         /*< Not part of public API! Do not use outside libavutil. */

/**
 * Initialize a CRC table.
 * @param ctx must be an array of size sizeof(AVCRC)*257 or sizeof(AVCRC)*1024
 * @param le If 1, the lowest bit represents the coefficient for the highest
 *           exponent of the corresponding polynomial (both for poly and
 *           actual CRC).
 *           If 0, you must swap the CRC parameter and the result of av_crc
 *           if you need the standard representation (can be simplified in
 *           most cases to e.g. bswap16):
 *           av_bswap32(crc << (32-bits))
 * @param bits number of bits for the CRC
 * @param poly generator polynomial without the x**bits coefficient, in the
 *             representation as specified by le
 * @param ctx_size size of ctx in bytes
 * @return <0 on failure
 */
@NoException public static native int av_crc_init(@Cast("AVCRC*") IntPointer ctx, int le, int bits, @Cast("uint32_t") int poly, int ctx_size);
@NoException public static native int av_crc_init(@Cast("AVCRC*") IntBuffer ctx, int le, int bits, @Cast("uint32_t") int poly, int ctx_size);
@NoException public static native int av_crc_init(@Cast("AVCRC*") int[] ctx, int le, int bits, @Cast("uint32_t") int poly, int ctx_size);

/**
 * Get an initialized standard CRC table.
 * @param crc_id ID of a standard CRC
 * @return a pointer to the CRC table or NULL on failure
 */
@NoException public static native @Cast("const AVCRC*") IntPointer av_crc_get_table(@Cast("AVCRCId") int crc_id);

/**
 * Calculate the CRC of a block.
 * @param crc CRC of previous blocks if any or initial value for CRC
 * @return CRC updated with the data from the given block
 *
 * @see av_crc_init() "le" parameter
 */
@NoException public static native @Cast("uint32_t") int av_crc(@Cast("const AVCRC*") IntPointer ctx, @Cast("uint32_t") int crc,
                @Cast("const uint8_t*") BytePointer buffer, @Cast("size_t") long length);
@NoException public static native @Cast("uint32_t") int av_crc(@Cast("const AVCRC*") IntBuffer ctx, @Cast("uint32_t") int crc,
                @Cast("const uint8_t*") ByteBuffer buffer, @Cast("size_t") long length);
@NoException public static native @Cast("uint32_t") int av_crc(@Cast("const AVCRC*") int[] ctx, @Cast("uint32_t") int crc,
                @Cast("const uint8_t*") byte[] buffer, @Cast("size_t") long length);

/**
 * \}
 */

// #endif /* AVUTIL_CRC_H */


// Parsed from <libavutil/des.h>

/*
 * DES encryption/decryption
 * Copyright (c) 2007 Reimar Doeffinger
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_DES_H
// #define AVUTIL_DES_H

// #include <stdint.h>
// Targeting ..\avutil\AVDES.java



/**
 * Allocate an AVDES context.
 */
@NoException public static native AVDES av_des_alloc();

/**
 * \brief Initializes an AVDES context.
 *
 * @param key_bits must be 64 or 192
 * @param decrypt 0 for encryption/CBC-MAC, 1 for decryption
 * @return zero on success, negative value otherwise
 */
@NoException public static native int av_des_init(AVDES d, @Cast("const uint8_t*") BytePointer key, int key_bits, int decrypt);
@NoException public static native int av_des_init(AVDES d, @Cast("const uint8_t*") ByteBuffer key, int key_bits, int decrypt);
@NoException public static native int av_des_init(AVDES d, @Cast("const uint8_t*") byte[] key, int key_bits, int decrypt);

/**
 * \brief Encrypts / decrypts using the DES algorithm.
 *
 * @param count number of 8 byte blocks
 * @param dst destination array, can be equal to src, must be 8-byte aligned
 * @param src source array, can be equal to dst, must be 8-byte aligned, may be NULL
 * @param iv initialization vector for CBC mode, if NULL then ECB will be used,
 *           must be 8-byte aligned
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_des_crypt(AVDES d, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_des_crypt(AVDES d, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_des_crypt(AVDES d, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \brief Calculates CBC-MAC using the DES algorithm.
 *
 * @param count number of 8 byte blocks
 * @param dst destination array, can be equal to src, must be 8-byte aligned
 * @param src source array, can be equal to dst, must be 8-byte aligned, may be NULL
 */
@NoException public static native void av_des_mac(AVDES d, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count);
@NoException public static native void av_des_mac(AVDES d, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count);
@NoException public static native void av_des_mac(AVDES d, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count);

/**
 * \}
 */

// #endif /* AVUTIL_DES_H */


// Parsed from <libavutil/lfg.h>

/*
 * Lagged Fibonacci PRNG
 * Copyright (c) 2008 Michael Niedermayer
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_LFG_H
// #define AVUTIL_LFG_H

// #include <stdint.h>
// Targeting ..\avutil\AVLFG.java



@NoException public static native void av_lfg_init(AVLFG c, @Cast("unsigned int") int seed);

/**
 * Seed the state of the ALFG using binary data.
 *
 * Return value: 0 on success, negative value (AVERROR) on failure.
 */
@NoException public static native int av_lfg_init_from_data(AVLFG c, @Cast("const uint8_t*") BytePointer data, @Cast("unsigned int") int length);
@NoException public static native int av_lfg_init_from_data(AVLFG c, @Cast("const uint8_t*") ByteBuffer data, @Cast("unsigned int") int length);
@NoException public static native int av_lfg_init_from_data(AVLFG c, @Cast("const uint8_t*") byte[] data, @Cast("unsigned int") int length);

/**
 * Get the next random unsigned 32-bit number using an ALFG.
 *
 * Please also consider a simple LCG like state= state*1664525+1013904223,
 * it may be good enough and faster for your specific use case.
 */
@NoException public static native @Cast("unsigned int") int av_lfg_get(AVLFG c);

/**
 * Get the next random unsigned 32-bit number using a MLFG.
 *
 * Please also consider av_lfg_get() above, it is faster.
 */
@NoException public static native @Cast("unsigned int") int av_mlfg_get(AVLFG c);

/**
 * Get the next two numbers generated by a Box-Muller Gaussian
 * generator using the random numbers issued by lfg.
 *
 * @param out array where the two generated numbers are placed
 */
@NoException public static native void av_bmg_get(AVLFG lfg, DoublePointer out);
@NoException public static native void av_bmg_get(AVLFG lfg, DoubleBuffer out);
@NoException public static native void av_bmg_get(AVLFG lfg, double[] out);

// #endif /* AVUTIL_LFG_H */


// Parsed from <libavutil/hmac.h>

/*
 * Copyright (C) 2012 Martin Storsjo
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_HMAC_H
// #define AVUTIL_HMAC_H

// #include <stdint.h>

// #include "version.h"
/**
 * \defgroup lavu_hmac HMAC
 * \ingroup lavu_crypto
 * \{
 */

/** enum AVHMACType */
public static final int
    AV_HMAC_MD5 = 0,
    AV_HMAC_SHA1 = 1,
    AV_HMAC_SHA224 = 2,
    AV_HMAC_SHA256 = 3,
    AV_HMAC_SHA384 = 4,
    AV_HMAC_SHA512 = 5;
// Targeting ..\avutil\AVHMAC.java



/**
 * Allocate an AVHMAC context.
 * @param type The hash function used for the HMAC.
 */
@NoException public static native AVHMAC av_hmac_alloc(@Cast("AVHMACType") int type);

/**
 * Free an AVHMAC context.
 * @param ctx The context to free, may be NULL
 */
@NoException public static native void av_hmac_free(AVHMAC ctx);

/**
 * Initialize an AVHMAC context with an authentication key.
 * @param ctx    The HMAC context
 * @param key    The authentication key
 * @param keylen The length of the key, in bytes
 */
@NoException public static native void av_hmac_init(AVHMAC ctx, @Cast("const uint8_t*") BytePointer key, @Cast("unsigned int") int keylen);
@NoException public static native void av_hmac_init(AVHMAC ctx, @Cast("const uint8_t*") ByteBuffer key, @Cast("unsigned int") int keylen);
@NoException public static native void av_hmac_init(AVHMAC ctx, @Cast("const uint8_t*") byte[] key, @Cast("unsigned int") int keylen);

/**
 * Hash data with the HMAC.
 * @param ctx  The HMAC context
 * @param data The data to hash
 * @param len  The length of the data, in bytes
 */
@NoException public static native void av_hmac_update(AVHMAC ctx, @Cast("const uint8_t*") BytePointer data, @Cast("unsigned int") int len);
@NoException public static native void av_hmac_update(AVHMAC ctx, @Cast("const uint8_t*") ByteBuffer data, @Cast("unsigned int") int len);
@NoException public static native void av_hmac_update(AVHMAC ctx, @Cast("const uint8_t*") byte[] data, @Cast("unsigned int") int len);

/**
 * Finish hashing and output the HMAC digest.
 * @param ctx    The HMAC context
 * @param out    The output buffer to write the digest into
 * @param outlen The length of the out buffer, in bytes
 * @return       The number of bytes written to out, or a negative error code.
 */
@NoException public static native int av_hmac_final(AVHMAC ctx, @Cast("uint8_t*") BytePointer out, @Cast("unsigned int") int outlen);
@NoException public static native int av_hmac_final(AVHMAC ctx, @Cast("uint8_t*") ByteBuffer out, @Cast("unsigned int") int outlen);
@NoException public static native int av_hmac_final(AVHMAC ctx, @Cast("uint8_t*") byte[] out, @Cast("unsigned int") int outlen);

/**
 * Hash an array of data with a key.
 * @param ctx    The HMAC context
 * @param data   The data to hash
 * @param len    The length of the data, in bytes
 * @param key    The authentication key
 * @param keylen The length of the key, in bytes
 * @param out    The output buffer to write the digest into
 * @param outlen The length of the out buffer, in bytes
 * @return       The number of bytes written to out, or a negative error code.
 */
@NoException public static native int av_hmac_calc(AVHMAC ctx, @Cast("const uint8_t*") BytePointer data, @Cast("unsigned int") int len,
                 @Cast("const uint8_t*") BytePointer key, @Cast("unsigned int") int keylen,
                 @Cast("uint8_t*") BytePointer out, @Cast("unsigned int") int outlen);
@NoException public static native int av_hmac_calc(AVHMAC ctx, @Cast("const uint8_t*") ByteBuffer data, @Cast("unsigned int") int len,
                 @Cast("const uint8_t*") ByteBuffer key, @Cast("unsigned int") int keylen,
                 @Cast("uint8_t*") ByteBuffer out, @Cast("unsigned int") int outlen);
@NoException public static native int av_hmac_calc(AVHMAC ctx, @Cast("const uint8_t*") byte[] data, @Cast("unsigned int") int len,
                 @Cast("const uint8_t*") byte[] key, @Cast("unsigned int") int keylen,
                 @Cast("uint8_t*") byte[] out, @Cast("unsigned int") int outlen);

/**
 * \}
 */

// #endif /* AVUTIL_HMAC_H */


// Parsed from <libavutil/md5.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_md5
 * Public header for MD5 hash function implementation.
 */

// #ifndef AVUTIL_MD5_H
// #define AVUTIL_MD5_H

// #include <stddef.h>
// #include <stdint.h>

// #include "attributes.h"
// #include "version.h"

/**
 * \defgroup lavu_md5 MD5
 * \ingroup lavu_hash
 * MD5 hash function implementation.
 *
 * \{
 */

@MemberGetter public static native int av_md5_size();
// Targeting ..\avutil\AVMD5.java



/**
 * Allocate an AVMD5 context.
 */
@NoException public static native AVMD5 av_md5_alloc();

/**
 * Initialize MD5 hashing.
 *
 * @param ctx pointer to the function context (of size av_md5_size)
 */
@NoException public static native void av_md5_init(AVMD5 ctx);

/**
 * Update hash value.
 *
 * @param ctx hash function context
 * @param src input data to update hash with
 * @param len input data length
 */
// #if FF_API_CRYPTO_SIZE_T
@NoException public static native void av_md5_update(AVMD5 ctx, @Cast("const uint8_t*") BytePointer src, int len);
@NoException public static native void av_md5_update(AVMD5 ctx, @Cast("const uint8_t*") ByteBuffer src, int len);
@NoException public static native void av_md5_update(AVMD5 ctx, @Cast("const uint8_t*") byte[] src, int len);
// #else
@NoException public static native void av_md5_update(AVMD5 ctx, @Cast("const uint8_t*") BytePointer src, @Cast("size_t") long len);
@NoException public static native void av_md5_update(AVMD5 ctx, @Cast("const uint8_t*") ByteBuffer src, @Cast("size_t") long len);
@NoException public static native void av_md5_update(AVMD5 ctx, @Cast("const uint8_t*") byte[] src, @Cast("size_t") long len);
// #endif

/**
 * Finish hashing and output digest value.
 *
 * @param ctx hash function context
 * @param dst buffer where output digest value is stored
 */
@NoException public static native void av_md5_final(AVMD5 ctx, @Cast("uint8_t*") BytePointer dst);
@NoException public static native void av_md5_final(AVMD5 ctx, @Cast("uint8_t*") ByteBuffer dst);
@NoException public static native void av_md5_final(AVMD5 ctx, @Cast("uint8_t*") byte[] dst);

/**
 * Hash an array of data.
 *
 * @param dst The output buffer to write the digest into
 * @param src The data to hash
 * @param len The length of the data, in bytes
 */
// #if FF_API_CRYPTO_SIZE_T
@NoException public static native void av_md5_sum(@Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int len);
@NoException public static native void av_md5_sum(@Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int len);
@NoException public static native void av_md5_sum(@Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int len);
// #else
@NoException public static native void av_md5_sum(@Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, @Cast("size_t") long len);
@NoException public static native void av_md5_sum(@Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, @Cast("size_t") long len);
@NoException public static native void av_md5_sum(@Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, @Cast("size_t") long len);
// #endif

/**
 * \}
 */

// #endif /* AVUTIL_MD5_H */


// Parsed from <libavutil/rc4.h>

/*
 * RC4 encryption/decryption/pseudo-random number generator
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_RC4_H
// #define AVUTIL_RC4_H

// #include <stdint.h>
// Targeting ..\avutil\AVRC4.java



/**
 * Allocate an AVRC4 context.
 */
@NoException public static native AVRC4 av_rc4_alloc();

/**
 * \brief Initializes an AVRC4 context.
 *
 * @param key_bits must be a multiple of 8
 * @param decrypt 0 for encryption, 1 for decryption, currently has no effect
 * @return zero on success, negative value otherwise
 */
@NoException public static native int av_rc4_init(AVRC4 d, @Cast("const uint8_t*") BytePointer key, int key_bits, int decrypt);
@NoException public static native int av_rc4_init(AVRC4 d, @Cast("const uint8_t*") ByteBuffer key, int key_bits, int decrypt);
@NoException public static native int av_rc4_init(AVRC4 d, @Cast("const uint8_t*") byte[] key, int key_bits, int decrypt);

/**
 * \brief Encrypts / decrypts using the RC4 algorithm.
 *
 * @param count number of bytes
 * @param dst destination array, can be equal to src
 * @param src source array, can be equal to dst, may be NULL
 * @param iv not (yet) used for RC4, should be NULL
 * @param decrypt 0 for encryption, 1 for decryption, not (yet) used
 */
@NoException public static native void av_rc4_crypt(AVRC4 d, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_rc4_crypt(AVRC4 d, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_rc4_crypt(AVRC4 d, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \}
 */

// #endif /* AVUTIL_RC4_H */


// Parsed from <libavutil/ripemd.h>

/*
 * Copyright (C) 2007 Michael Niedermayer <michaelni@gmx.at>
 * Copyright (C) 2013 James Almer <jamrial@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_ripemd
 * Public header for RIPEMD hash function implementation.
 */

// #ifndef AVUTIL_RIPEMD_H
// #define AVUTIL_RIPEMD_H

// #include <stdint.h>

// #include "attributes.h"
// #include "version.h"

/**
 * \defgroup lavu_ripemd RIPEMD
 * \ingroup lavu_hash
 * RIPEMD hash function implementation.
 *
 * \{
 */

@MemberGetter public static native int av_ripemd_size();
// Targeting ..\avutil\AVRIPEMD.java



/**
 * Allocate an AVRIPEMD context.
 */
@NoException public static native AVRIPEMD av_ripemd_alloc();

/**
 * Initialize RIPEMD hashing.
 *
 * @param context pointer to the function context (of size av_ripemd_size)
 * @param bits    number of bits in digest (128, 160, 256 or 320 bits)
 * @return        zero if initialization succeeded, -1 otherwise
 */
@NoException public static native int av_ripemd_init(AVRIPEMD context, int bits);

/**
 * Update hash value.
 *
 * @param context hash function context
 * @param data    input data to update hash with
 * @param len     input data length
 */
// #if FF_API_CRYPTO_SIZE_T
@NoException public static native void av_ripemd_update(AVRIPEMD context, @Cast("const uint8_t*") BytePointer data, @Cast("unsigned int") int len);
@NoException public static native void av_ripemd_update(AVRIPEMD context, @Cast("const uint8_t*") ByteBuffer data, @Cast("unsigned int") int len);
@NoException public static native void av_ripemd_update(AVRIPEMD context, @Cast("const uint8_t*") byte[] data, @Cast("unsigned int") int len);
// #else
@NoException public static native void av_ripemd_update(AVRIPEMD context, @Cast("const uint8_t*") BytePointer data, @Cast("size_t") long len);
@NoException public static native void av_ripemd_update(AVRIPEMD context, @Cast("const uint8_t*") ByteBuffer data, @Cast("size_t") long len);
@NoException public static native void av_ripemd_update(AVRIPEMD context, @Cast("const uint8_t*") byte[] data, @Cast("size_t") long len);
// #endif

/**
 * Finish hashing and output digest value.
 *
 * @param context hash function context
 * @param digest  buffer where output digest value is stored
 */
@NoException public static native void av_ripemd_final(AVRIPEMD context, @Cast("uint8_t*") BytePointer digest);
@NoException public static native void av_ripemd_final(AVRIPEMD context, @Cast("uint8_t*") ByteBuffer digest);
@NoException public static native void av_ripemd_final(AVRIPEMD context, @Cast("uint8_t*") byte[] digest);

/**
 * \}
 */

// #endif /* AVUTIL_RIPEMD_H */


// Parsed from <libavutil/tea.h>

/*
 * A 32-bit implementation of the TEA algorithm
 * Copyright (c) 2015 Vesselin Bontchev
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_TEA_H
// #define AVUTIL_TEA_H

// #include <stdint.h>

/**
 * \file
 * \brief Public header for libavutil TEA algorithm
 * \defgroup lavu_tea TEA
 * \ingroup lavu_crypto
 * \{
 */

@MemberGetter public static native int av_tea_size();
// Targeting ..\avutil\AVTEA.java



/**
  * Allocate an AVTEA context
  * To free the struct: av_free(ptr)
  */
@NoException public static native AVTEA av_tea_alloc();

/**
 * Initialize an AVTEA context.
 *
 * @param ctx an AVTEA context
 * @param key a key of 16 bytes used for encryption/decryption
 * @param rounds the number of rounds in TEA (64 is the "standard")
 */
@NoException public static native void av_tea_init(AVTEA ctx, @Cast("const uint8_t*") BytePointer key, int rounds);
@NoException public static native void av_tea_init(AVTEA ctx, @Cast("const uint8_t*") ByteBuffer key, int rounds);
@NoException public static native void av_tea_init(AVTEA ctx, @Cast("const uint8_t*") byte[] key, int rounds);

/**
 * Encrypt or decrypt a buffer using a previously initialized context.
 *
 * @param ctx an AVTEA context
 * @param dst destination array, can be equal to src
 * @param src source array, can be equal to dst
 * @param count number of 8 byte blocks
 * @param iv initialization vector for CBC mode, if NULL then ECB will be used
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_tea_crypt(AVTEA ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src,
                  int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_tea_crypt(AVTEA ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src,
                  int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_tea_crypt(AVTEA ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src,
                  int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \}
 */

// #endif /* AVUTIL_TEA_H */


// Parsed from <libavutil/twofish.h>

/*
 * An implementation of the TwoFish algorithm
 * Copyright (c) 2015 Supraja Meedinti
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_TWOFISH_H
// #define AVUTIL_TWOFISH_H

// #include <stdint.h>


/**
  * \file
  * \brief Public header for libavutil TWOFISH algorithm
  * \defgroup lavu_twofish TWOFISH
  * \ingroup lavu_crypto
  * \{
  */

@MemberGetter public static native int av_twofish_size();
// Targeting ..\avutil\AVTWOFISH.java



/**
  * Allocate an AVTWOFISH context
  * To free the struct: av_free(ptr)
  */
@NoException public static native AVTWOFISH av_twofish_alloc();

/**
  * Initialize an AVTWOFISH context.
  *
  * @param ctx an AVTWOFISH context
  * @param key a key of size ranging from 1 to 32 bytes used for encryption/decryption
  * @param key_bits number of keybits: 128, 192, 256 If less than the required, padded with zeroes to nearest valid value; return value is 0 if key_bits is 128/192/256, -1 if less than 0, 1 otherwise
 */
@NoException public static native int av_twofish_init(AVTWOFISH ctx, @Cast("const uint8_t*") BytePointer key, int key_bits);
@NoException public static native int av_twofish_init(AVTWOFISH ctx, @Cast("const uint8_t*") ByteBuffer key, int key_bits);
@NoException public static native int av_twofish_init(AVTWOFISH ctx, @Cast("const uint8_t*") byte[] key, int key_bits);

/**
  * Encrypt or decrypt a buffer using a previously initialized context
  *
  * @param ctx an AVTWOFISH context
  * @param dst destination array, can be equal to src
  * @param src source array, can be equal to dst
  * @param count number of 16 byte blocks
  * \paran iv initialization vector for CBC mode, NULL for ECB mode
  * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_twofish_crypt(AVTWOFISH ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src, int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_twofish_crypt(AVTWOFISH ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src, int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_twofish_crypt(AVTWOFISH ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src, int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \}
 */
// #endif /* AVUTIL_TWOFISH_H */


// Parsed from <libavutil/sha.h>

/*
 * Copyright (C) 2007 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_sha
 * Public header for SHA-1 & SHA-256 hash function implementations.
 */

// #ifndef AVUTIL_SHA_H
// #define AVUTIL_SHA_H

// #include <stddef.h>
// #include <stdint.h>

// #include "attributes.h"
// #include "version.h"

/**
 * \defgroup lavu_sha SHA
 * \ingroup lavu_hash
 * SHA-1 and SHA-256 (Secure Hash Algorithm) hash function implementations.
 *
 * This module supports the following SHA hash functions:
 *
 * - SHA-1: 160 bits
 * - SHA-224: 224 bits, as a variant of SHA-2
 * - SHA-256: 256 bits, as a variant of SHA-2
 *
 * @see For SHA-384, SHA-512, and variants thereof, see \ref lavu_sha512.
 *
 * \{
 */

@MemberGetter public static native int av_sha_size();
// Targeting ..\avutil\AVSHA.java



/**
 * Allocate an AVSHA context.
 */
@NoException public static native AVSHA av_sha_alloc();

/**
 * Initialize SHA-1 or SHA-2 hashing.
 *
 * @param context pointer to the function context (of size av_sha_size)
 * @param bits    number of bits in digest (SHA-1 - 160 bits, SHA-2 224 or 256 bits)
 * @return        zero if initialization succeeded, -1 otherwise
 */
@NoException public static native int av_sha_init(AVSHA context, int bits);

/**
 * Update hash value.
 *
 * @param ctx     hash function context
 * @param data    input data to update hash with
 * @param len     input data length
 */
// #if FF_API_CRYPTO_SIZE_T
@NoException public static native void av_sha_update(AVSHA ctx, @Cast("const uint8_t*") BytePointer data, @Cast("unsigned int") int len);
@NoException public static native void av_sha_update(AVSHA ctx, @Cast("const uint8_t*") ByteBuffer data, @Cast("unsigned int") int len);
@NoException public static native void av_sha_update(AVSHA ctx, @Cast("const uint8_t*") byte[] data, @Cast("unsigned int") int len);
// #else
@NoException public static native void av_sha_update(AVSHA ctx, @Cast("const uint8_t*") BytePointer data, @Cast("size_t") long len);
@NoException public static native void av_sha_update(AVSHA ctx, @Cast("const uint8_t*") ByteBuffer data, @Cast("size_t") long len);
@NoException public static native void av_sha_update(AVSHA ctx, @Cast("const uint8_t*") byte[] data, @Cast("size_t") long len);
// #endif

/**
 * Finish hashing and output digest value.
 *
 * @param context hash function context
 * @param digest  buffer where output digest value is stored
 */
@NoException public static native void av_sha_final(AVSHA context, @Cast("uint8_t*") BytePointer digest);
@NoException public static native void av_sha_final(AVSHA context, @Cast("uint8_t*") ByteBuffer digest);
@NoException public static native void av_sha_final(AVSHA context, @Cast("uint8_t*") byte[] digest);

/**
 * \}
 */

// #endif /* AVUTIL_SHA_H */


// Parsed from <libavutil/sha512.h>

/*
 * Copyright (C) 2007 Michael Niedermayer <michaelni@gmx.at>
 * Copyright (C) 2013 James Almer <jamrial@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_sha512
 * Public header for SHA-512 implementation.
 */

// #ifndef AVUTIL_SHA512_H
// #define AVUTIL_SHA512_H

// #include <stddef.h>
// #include <stdint.h>

// #include "attributes.h"
// #include "version.h"

/**
 * \defgroup lavu_sha512 SHA-512
 * \ingroup lavu_hash
 * SHA-512 (Secure Hash Algorithm) hash function implementations.
 *
 * This module supports the following SHA-2 hash functions:
 *
 * - SHA-512/224: 224 bits
 * - SHA-512/256: 256 bits
 * - SHA-384: 384 bits
 * - SHA-512: 512 bits
 *
 * @see For SHA-1, SHA-256, and variants thereof, see \ref lavu_sha.
 *
 * \{
 */

@MemberGetter public static native int av_sha512_size();
// Targeting ..\avutil\AVSHA512.java



/**
 * Allocate an AVSHA512 context.
 */
@NoException public static native AVSHA512 av_sha512_alloc();

/**
 * Initialize SHA-2 512 hashing.
 *
 * @param context pointer to the function context (of size av_sha512_size)
 * @param bits    number of bits in digest (224, 256, 384 or 512 bits)
 * @return        zero if initialization succeeded, -1 otherwise
 */
@NoException public static native int av_sha512_init(AVSHA512 context, int bits);

/**
 * Update hash value.
 *
 * @param context hash function context
 * @param data    input data to update hash with
 * @param len     input data length
 */
// #if FF_API_CRYPTO_SIZE_T
@NoException public static native void av_sha512_update(AVSHA512 context, @Cast("const uint8_t*") BytePointer data, @Cast("unsigned int") int len);
@NoException public static native void av_sha512_update(AVSHA512 context, @Cast("const uint8_t*") ByteBuffer data, @Cast("unsigned int") int len);
@NoException public static native void av_sha512_update(AVSHA512 context, @Cast("const uint8_t*") byte[] data, @Cast("unsigned int") int len);
// #else
@NoException public static native void av_sha512_update(AVSHA512 context, @Cast("const uint8_t*") BytePointer data, @Cast("size_t") long len);
@NoException public static native void av_sha512_update(AVSHA512 context, @Cast("const uint8_t*") ByteBuffer data, @Cast("size_t") long len);
@NoException public static native void av_sha512_update(AVSHA512 context, @Cast("const uint8_t*") byte[] data, @Cast("size_t") long len);
// #endif

/**
 * Finish hashing and output digest value.
 *
 * @param context hash function context
 * @param digest  buffer where output digest value is stored
 */
@NoException public static native void av_sha512_final(AVSHA512 context, @Cast("uint8_t*") BytePointer digest);
@NoException public static native void av_sha512_final(AVSHA512 context, @Cast("uint8_t*") ByteBuffer digest);
@NoException public static native void av_sha512_final(AVSHA512 context, @Cast("uint8_t*") byte[] digest);

/**
 * \}
 */

// #endif /* AVUTIL_SHA512_H */


// Parsed from <libavutil/xtea.h>

/*
 * A 32-bit implementation of the XTEA algorithm
 * Copyright (c) 2012 Samuel Pitoiset
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_XTEA_H
// #define AVUTIL_XTEA_H

// #include <stdint.h>
// Targeting ..\avutil\AVXTEA.java



/**
 * Allocate an AVXTEA context.
 */
@NoException public static native AVXTEA av_xtea_alloc();

/**
 * Initialize an AVXTEA context.
 *
 * @param ctx an AVXTEA context
 * @param key a key of 16 bytes used for encryption/decryption,
 *            interpreted as big endian 32 bit numbers
 */
@NoException public static native void av_xtea_init(AVXTEA ctx, @Cast("const uint8_t*") BytePointer key);
@NoException public static native void av_xtea_init(AVXTEA ctx, @Cast("const uint8_t*") ByteBuffer key);
@NoException public static native void av_xtea_init(AVXTEA ctx, @Cast("const uint8_t*") byte[] key);

/**
 * Initialize an AVXTEA context.
 *
 * @param ctx an AVXTEA context
 * @param key a key of 16 bytes used for encryption/decryption,
 *            interpreted as little endian 32 bit numbers
 */
@NoException public static native void av_xtea_le_init(AVXTEA ctx, @Cast("const uint8_t*") BytePointer key);
@NoException public static native void av_xtea_le_init(AVXTEA ctx, @Cast("const uint8_t*") ByteBuffer key);
@NoException public static native void av_xtea_le_init(AVXTEA ctx, @Cast("const uint8_t*") byte[] key);

/**
 * Encrypt or decrypt a buffer using a previously initialized context,
 * in big endian format.
 *
 * @param ctx an AVXTEA context
 * @param dst destination array, can be equal to src
 * @param src source array, can be equal to dst
 * @param count number of 8 byte blocks
 * @param iv initialization vector for CBC mode, if NULL then ECB will be used
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_xtea_crypt(AVXTEA ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src,
                   int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_xtea_crypt(AVXTEA ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src,
                   int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_xtea_crypt(AVXTEA ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src,
                   int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * Encrypt or decrypt a buffer using a previously initialized context,
 * in little endian format.
 *
 * @param ctx an AVXTEA context
 * @param dst destination array, can be equal to src
 * @param src source array, can be equal to dst
 * @param count number of 8 byte blocks
 * @param iv initialization vector for CBC mode, if NULL then ECB will be used
 * @param decrypt 0 for encryption, 1 for decryption
 */
@NoException public static native void av_xtea_le_crypt(AVXTEA ctx, @Cast("uint8_t*") BytePointer dst, @Cast("const uint8_t*") BytePointer src,
                      int count, @Cast("uint8_t*") BytePointer iv, int decrypt);
@NoException public static native void av_xtea_le_crypt(AVXTEA ctx, @Cast("uint8_t*") ByteBuffer dst, @Cast("const uint8_t*") ByteBuffer src,
                      int count, @Cast("uint8_t*") ByteBuffer iv, int decrypt);
@NoException public static native void av_xtea_le_crypt(AVXTEA ctx, @Cast("uint8_t*") byte[] dst, @Cast("const uint8_t*") byte[] src,
                      int count, @Cast("uint8_t*") byte[] iv, int decrypt);

/**
 * \}
 */

// #endif /* AVUTIL_XTEA_H */


// Parsed from <libavutil/avstring.h>

/*
 * Copyright (c) 2007 Mans Rullgard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_AVSTRING_H
// #define AVUTIL_AVSTRING_H

// #include <stddef.h>
// #include <stdint.h>
// #include "attributes.h"

/**
 * \addtogroup lavu_string
 * \{
 */

/**
 * Return non-zero if pfx is a prefix of str. If it is, *ptr is set to
 * the address of the first character in str after the prefix.
 *
 * @param str input string
 * @param pfx prefix to test
 * @param ptr updated if the prefix is matched inside str
 * @return non-zero if the prefix matches, zero otherwise
 */
@NoException public static native int av_strstart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") PointerPointer ptr);
@NoException public static native int av_strstart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") @ByPtrPtr BytePointer ptr);
@NoException public static native int av_strstart(String str, String pfx, @Cast("const char**") @ByPtrPtr ByteBuffer ptr);
@NoException public static native int av_strstart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") @ByPtrPtr byte[] ptr);
@NoException public static native int av_strstart(String str, String pfx, @Cast("const char**") @ByPtrPtr BytePointer ptr);
@NoException public static native int av_strstart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") @ByPtrPtr ByteBuffer ptr);
@NoException public static native int av_strstart(String str, String pfx, @Cast("const char**") @ByPtrPtr byte[] ptr);

/**
 * Return non-zero if pfx is a prefix of str independent of case. If
 * it is, *ptr is set to the address of the first character in str
 * after the prefix.
 *
 * @param str input string
 * @param pfx prefix to test
 * @param ptr updated if the prefix is matched inside str
 * @return non-zero if the prefix matches, zero otherwise
 */
@NoException public static native int av_stristart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") PointerPointer ptr);
@NoException public static native int av_stristart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") @ByPtrPtr BytePointer ptr);
@NoException public static native int av_stristart(String str, String pfx, @Cast("const char**") @ByPtrPtr ByteBuffer ptr);
@NoException public static native int av_stristart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") @ByPtrPtr byte[] ptr);
@NoException public static native int av_stristart(String str, String pfx, @Cast("const char**") @ByPtrPtr BytePointer ptr);
@NoException public static native int av_stristart(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer pfx, @Cast("const char**") @ByPtrPtr ByteBuffer ptr);
@NoException public static native int av_stristart(String str, String pfx, @Cast("const char**") @ByPtrPtr byte[] ptr);

/**
 * Locate the first case-independent occurrence in the string haystack
 * of the string needle.  A zero-length string needle is considered to
 * match at the start of haystack.
 *
 * This function is a case-insensitive version of the standard strstr().
 *
 * @param haystack string to search in
 * @param needle   string to search for
 * @return         pointer to the located match within haystack
 *                 or a null pointer if no match
 */
@NoException public static native @Cast("char*") BytePointer av_stristr(@Cast("const char*") BytePointer haystack, @Cast("const char*") BytePointer needle);
@NoException public static native @Cast("char*") ByteBuffer av_stristr(String haystack, String needle);

/**
 * Locate the first occurrence of the string needle in the string haystack
 * where not more than hay_length characters are searched. A zero-length
 * string needle is considered to match at the start of haystack.
 *
 * This function is a length-limited version of the standard strstr().
 *
 * @param haystack   string to search in
 * @param needle     string to search for
 * @param hay_length length of string to search in
 * @return           pointer to the located match within haystack
 *                   or a null pointer if no match
 */
@NoException public static native @Cast("char*") BytePointer av_strnstr(@Cast("const char*") BytePointer haystack, @Cast("const char*") BytePointer needle, @Cast("size_t") long hay_length);
@NoException public static native @Cast("char*") ByteBuffer av_strnstr(String haystack, String needle, @Cast("size_t") long hay_length);

/**
 * Copy the string src to dst, but no more than size - 1 bytes, and
 * null-terminate dst.
 *
 * This function is the same as BSD strlcpy().
 *
 * @param dst destination buffer
 * @param src source string
 * @param size size of destination buffer
 * @return the length of src
 *
 * \warning since the return value is the length of src, src absolutely
 * _must_ be a properly 0-terminated string, otherwise this will read beyond
 * the end of the buffer and possibly crash.
 */
@NoException public static native @Cast("size_t") long av_strlcpy(@Cast("char*") BytePointer dst, @Cast("const char*") BytePointer src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcpy(@Cast("char*") ByteBuffer dst, String src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcpy(@Cast("char*") byte[] dst, @Cast("const char*") BytePointer src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcpy(@Cast("char*") BytePointer dst, String src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcpy(@Cast("char*") ByteBuffer dst, @Cast("const char*") BytePointer src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcpy(@Cast("char*") byte[] dst, String src, @Cast("size_t") long size);

/**
 * Append the string src to the string dst, but to a total length of
 * no more than size - 1 bytes, and null-terminate dst.
 *
 * This function is similar to BSD strlcat(), but differs when
 * size <= strlen(dst).
 *
 * @param dst destination buffer
 * @param src source string
 * @param size size of destination buffer
 * @return the total length of src and dst
 *
 * \warning since the return value use the length of src and dst, these
 * absolutely _must_ be a properly 0-terminated strings, otherwise this
 * will read beyond the end of the buffer and possibly crash.
 */
@NoException public static native @Cast("size_t") long av_strlcat(@Cast("char*") BytePointer dst, @Cast("const char*") BytePointer src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcat(@Cast("char*") ByteBuffer dst, String src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcat(@Cast("char*") byte[] dst, @Cast("const char*") BytePointer src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcat(@Cast("char*") BytePointer dst, String src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcat(@Cast("char*") ByteBuffer dst, @Cast("const char*") BytePointer src, @Cast("size_t") long size);
@NoException public static native @Cast("size_t") long av_strlcat(@Cast("char*") byte[] dst, String src, @Cast("size_t") long size);

/**
 * Append output to a string, according to a format. Never write out of
 * the destination buffer, and always put a terminating 0 within
 * the buffer.
 * @param dst destination buffer (string to which the output is
 *  appended)
 * @param size total size of the destination buffer
 * @param fmt printf-compatible format string, specifying how the
 *  following parameters are used
 * @return the length of the string that would have been generated
 *  if enough space had been available
 */
@NoException public static native @Cast("size_t") long av_strlcatf(@Cast("char*") BytePointer dst, @Cast("size_t") long size, @Cast("const char*") BytePointer fmt);
@NoException public static native @Cast("size_t") long av_strlcatf(@Cast("char*") ByteBuffer dst, @Cast("size_t") long size, String fmt);
@NoException public static native @Cast("size_t") long av_strlcatf(@Cast("char*") byte[] dst, @Cast("size_t") long size, @Cast("const char*") BytePointer fmt);
@NoException public static native @Cast("size_t") long av_strlcatf(@Cast("char*") BytePointer dst, @Cast("size_t") long size, String fmt);
@NoException public static native @Cast("size_t") long av_strlcatf(@Cast("char*") ByteBuffer dst, @Cast("size_t") long size, @Cast("const char*") BytePointer fmt);
@NoException public static native @Cast("size_t") long av_strlcatf(@Cast("char*") byte[] dst, @Cast("size_t") long size, String fmt);

/**
 * Get the count of continuous non zero chars starting from the beginning.
 *
 * @param len maximum number of characters to check in the string, that
 *            is the maximum value which is returned by the function
 */
@NoException public static native @Cast("size_t") long av_strnlen(@Cast("const char*") BytePointer s, @Cast("size_t") long len);
@NoException public static native @Cast("size_t") long av_strnlen(String s, @Cast("size_t") long len);

/**
 * Print arguments following specified format into a large enough auto
 * allocated buffer. It is similar to GNU asprintf().
 * @param fmt printf-compatible format string, specifying how the
 *            following parameters are used.
 * @return the allocated string
 * \note You have to free the string yourself with av_free().
 */
@NoException public static native @Cast("char*") BytePointer av_asprintf(@Cast("const char*") BytePointer fmt);
@NoException public static native @Cast("char*") ByteBuffer av_asprintf(String fmt);

/**
 * Convert a number to an av_malloced string.
 */
@NoException public static native @Cast("char*") BytePointer av_d2str(double d);

/**
 * Unescape the given string until a non escaped terminating char,
 * and return the token corresponding to the unescaped string.
 *
 * The normal \ and ' escaping is supported. Leading and trailing
 * whitespaces are removed, unless they are escaped with '\' or are
 * enclosed between ''.
 *
 * @param buf the buffer to parse, buf will be updated to point to the
 * terminating char
 * @param term a 0-terminated list of terminating chars
 * @return the malloced unescaped string, which must be av_freed by
 * the user, NULL in case of allocation failure
 */
@NoException public static native @Cast("char*") BytePointer av_get_token(@Cast("const char**") PointerPointer buf, @Cast("const char*") BytePointer term);
@NoException public static native @Cast("char*") BytePointer av_get_token(@Cast("const char**") @ByPtrPtr BytePointer buf, @Cast("const char*") BytePointer term);
@NoException public static native @Cast("char*") ByteBuffer av_get_token(@Cast("const char**") @ByPtrPtr ByteBuffer buf, String term);
@NoException public static native @Cast("char*") byte[] av_get_token(@Cast("const char**") @ByPtrPtr byte[] buf, @Cast("const char*") BytePointer term);
@NoException public static native @Cast("char*") BytePointer av_get_token(@Cast("const char**") @ByPtrPtr BytePointer buf, String term);
@NoException public static native @Cast("char*") ByteBuffer av_get_token(@Cast("const char**") @ByPtrPtr ByteBuffer buf, @Cast("const char*") BytePointer term);
@NoException public static native @Cast("char*") byte[] av_get_token(@Cast("const char**") @ByPtrPtr byte[] buf, String term);

/**
 * Split the string into several tokens which can be accessed by
 * successive calls to av_strtok().
 *
 * A token is defined as a sequence of characters not belonging to the
 * set specified in delim.
 *
 * On the first call to av_strtok(), s should point to the string to
 * parse, and the value of saveptr is ignored. In subsequent calls, s
 * should be NULL, and saveptr should be unchanged since the previous
 * call.
 *
 * This function is similar to strtok_r() defined in POSIX.1.
 *
 * @param s the string to parse, may be NULL
 * @param delim 0-terminated list of token delimiters, must be non-NULL
 * @param saveptr user-provided pointer which points to stored
 * information necessary for av_strtok() to continue scanning the same
 * string. saveptr is updated to point to the next character after the
 * first delimiter found, or to NULL if the string was terminated
 * @return the found token, or NULL when no token is found
 */
@NoException public static native @Cast("char*") BytePointer av_strtok(@Cast("char*") BytePointer s, @Cast("const char*") BytePointer delim, @Cast("char**") PointerPointer saveptr);
@NoException public static native @Cast("char*") BytePointer av_strtok(@Cast("char*") BytePointer s, @Cast("const char*") BytePointer delim, @Cast("char**") @ByPtrPtr BytePointer saveptr);
@NoException public static native @Cast("char*") ByteBuffer av_strtok(@Cast("char*") ByteBuffer s, String delim, @Cast("char**") @ByPtrPtr ByteBuffer saveptr);
@NoException public static native @Cast("char*") byte[] av_strtok(@Cast("char*") byte[] s, @Cast("const char*") BytePointer delim, @Cast("char**") @ByPtrPtr byte[] saveptr);
@NoException public static native @Cast("char*") BytePointer av_strtok(@Cast("char*") BytePointer s, String delim, @Cast("char**") @ByPtrPtr BytePointer saveptr);
@NoException public static native @Cast("char*") ByteBuffer av_strtok(@Cast("char*") ByteBuffer s, @Cast("const char*") BytePointer delim, @Cast("char**") @ByPtrPtr ByteBuffer saveptr);
@NoException public static native @Cast("char*") byte[] av_strtok(@Cast("char*") byte[] s, String delim, @Cast("char**") @ByPtrPtr byte[] saveptr);

/**
 * Locale-independent conversion of ASCII isdigit.
 */
@NoException public static native @Const int av_isdigit(int c);

/**
 * Locale-independent conversion of ASCII isgraph.
 */
@NoException public static native @Const int av_isgraph(int c);

/**
 * Locale-independent conversion of ASCII isspace.
 */
@NoException public static native @Const int av_isspace(int c);

/**
 * Locale-independent conversion of ASCII characters to uppercase.
 */
@NoException public static native @Const int av_toupper(int c);

/**
 * Locale-independent conversion of ASCII characters to lowercase.
 */
@NoException public static native @Const int av_tolower(int c);

/**
 * Locale-independent conversion of ASCII isxdigit.
 */
@NoException public static native @Const int av_isxdigit(int c);

/**
 * Locale-independent case-insensitive compare.
 * \note This means only ASCII-range characters are case-insensitive
 */
@NoException public static native int av_strcasecmp(@Cast("const char*") BytePointer a, @Cast("const char*") BytePointer b);
@NoException public static native int av_strcasecmp(String a, String b);

/**
 * Locale-independent case-insensitive compare.
 * \note This means only ASCII-range characters are case-insensitive
 */
@NoException public static native int av_strncasecmp(@Cast("const char*") BytePointer a, @Cast("const char*") BytePointer b, @Cast("size_t") long n);
@NoException public static native int av_strncasecmp(String a, String b, @Cast("size_t") long n);

/**
 * Locale-independent strings replace.
 * \note This means only ASCII-range characters are replace
 */
@NoException public static native @Cast("char*") BytePointer av_strireplace(@Cast("const char*") BytePointer str, @Cast("const char*") BytePointer from, @Cast("const char*") BytePointer to);
@NoException public static native @Cast("char*") ByteBuffer av_strireplace(String str, String from, String to);

/**
 * Thread safe basename.
 * @param path the string to parse, on DOS both \ and / are considered separators.
 * @return pointer to the basename substring.
 * If path does not contain a slash, the function returns a copy of path.
 * If path is a NULL pointer or points to an empty string, a pointer
 * to a string "." is returned.
 */
@NoException public static native @Cast("const char*") BytePointer av_basename(@Cast("const char*") BytePointer path);
@NoException public static native String av_basename(String path);

/**
 * Thread safe dirname.
 * @param path the string to parse, on DOS both \ and / are considered separators.
 * @return A pointer to a string that's the parent directory of path.
 * If path is a NULL pointer or points to an empty string, a pointer
 * to a string "." is returned.
 * \note the function may modify the contents of the path, so copies should be passed.
 */
@NoException public static native @Cast("const char*") BytePointer av_dirname(@Cast("char*") BytePointer path);
@NoException public static native String av_dirname(@Cast("char*") ByteBuffer path);
@NoException public static native @Cast("const char*") BytePointer av_dirname(@Cast("char*") byte[] path);

/**
 * Match instances of a name in a comma-separated list of names.
 * List entries are checked from the start to the end of the names list,
 * the first match ends further processing. If an entry prefixed with '-'
 * matches, then 0 is returned. The "ALL" list entry is considered to
 * match all names.
 *
 * @param name  Name to look for.
 * @param names List of names.
 * @return 1 on match, 0 otherwise.
 */
@NoException public static native int av_match_name(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer names);
@NoException public static native int av_match_name(String name, String names);

/**
 * Append path component to the existing path.
 * Path separator '/' is placed between when needed.
 * Resulting string have to be freed with av_free().
 * @param path      base path
 * @param component component to be appended
 * @return new path or NULL on error.
 */
@NoException public static native @Cast("char*") BytePointer av_append_path_component(@Cast("const char*") BytePointer path, @Cast("const char*") BytePointer component);
@NoException public static native @Cast("char*") ByteBuffer av_append_path_component(String path, String component);

/** enum AVEscapeMode */
public static final int
    /** Use auto-selected escaping mode. */
    AV_ESCAPE_MODE_AUTO = 0,
    /** Use backslash escaping. */
    AV_ESCAPE_MODE_BACKSLASH = 1,
    /** Use single-quote escaping. */
    AV_ESCAPE_MODE_QUOTE = 2;

/**
 * Consider spaces special and escape them even in the middle of the
 * string.
 *
 * This is equivalent to adding the whitespace characters to the special
 * characters lists, except it is guaranteed to use the exact same list
 * of whitespace characters as the rest of libavutil.
 */
public static final int AV_ESCAPE_FLAG_WHITESPACE = (1 << 0);

/**
 * Escape only specified special characters.
 * Without this flag, escape also any characters that may be considered
 * special by av_get_token(), such as the single quote.
 */
public static final int AV_ESCAPE_FLAG_STRICT = (1 << 1);

/**
 * Escape string in src, and put the escaped string in an allocated
 * string in *dst, which must be freed with av_free().
 *
 * @param dst           pointer where an allocated string is put
 * @param src           string to escape, must be non-NULL
 * @param special_chars string containing the special characters which
 *                      need to be escaped, can be NULL
 * @param mode          escape mode to employ, see AV_ESCAPE_MODE_* macros.
 *                      Any unknown value for mode will be considered equivalent to
 *                      AV_ESCAPE_MODE_BACKSLASH, but this behaviour can change without
 *                      notice.
 * @param flags         flags which control how to escape, see AV_ESCAPE_FLAG_ macros
 * @return the length of the allocated string, or a negative error code in case of error
 * @see av_bprint_escape()
 */
@NoException public static native int av_escape(@Cast("char**") PointerPointer dst, @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer special_chars,
              @Cast("AVEscapeMode") int mode, int flags);
@NoException public static native int av_escape(@Cast("char**") @ByPtrPtr BytePointer dst, @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer special_chars,
              @Cast("AVEscapeMode") int mode, int flags);
@NoException public static native int av_escape(@Cast("char**") @ByPtrPtr ByteBuffer dst, String src, String special_chars,
              @Cast("AVEscapeMode") int mode, int flags);
@NoException public static native int av_escape(@Cast("char**") @ByPtrPtr byte[] dst, @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer special_chars,
              @Cast("AVEscapeMode") int mode, int flags);
@NoException public static native int av_escape(@Cast("char**") @ByPtrPtr BytePointer dst, String src, String special_chars,
              @Cast("AVEscapeMode") int mode, int flags);
@NoException public static native int av_escape(@Cast("char**") @ByPtrPtr ByteBuffer dst, @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer special_chars,
              @Cast("AVEscapeMode") int mode, int flags);
@NoException public static native int av_escape(@Cast("char**") @ByPtrPtr byte[] dst, String src, String special_chars,
              @Cast("AVEscapeMode") int mode, int flags);

/** accept codepoints over 0x10FFFF */
public static final int AV_UTF8_FLAG_ACCEPT_INVALID_BIG_CODES =          1;
/** accept non-characters - 0xFFFE and 0xFFFF */
public static final int AV_UTF8_FLAG_ACCEPT_NON_CHARACTERS =             2;
/** accept UTF-16 surrogates codes */
public static final int AV_UTF8_FLAG_ACCEPT_SURROGATES =                 4;
/** exclude control codes not accepted by XML */
public static final int AV_UTF8_FLAG_EXCLUDE_XML_INVALID_CONTROL_CODES = 8;

public static final int AV_UTF8_FLAG_ACCEPT_ALL = 
    AV_UTF8_FLAG_ACCEPT_INVALID_BIG_CODES|AV_UTF8_FLAG_ACCEPT_NON_CHARACTERS|AV_UTF8_FLAG_ACCEPT_SURROGATES;

/**
 * Read and decode a single UTF-8 code point (character) from the
 * buffer in *buf, and update *buf to point to the next byte to
 * decode.
 *
 * In case of an invalid byte sequence, the pointer will be updated to
 * the next byte after the invalid sequence and the function will
 * return an error code.
 *
 * Depending on the specified flags, the function will also fail in
 * case the decoded code point does not belong to a valid range.
 *
 * \note For speed-relevant code a carefully implemented use of
 * GET_UTF8() may be preferred.
 *
 * @param codep   pointer used to return the parsed code in case of success.
 *                The value in *codep is set even in case the range check fails.
 * @param bufp    pointer to the address the first byte of the sequence
 *                to decode, updated by the function to point to the
 *                byte next after the decoded sequence
 * @param buf_end pointer to the end of the buffer, points to the next
 *                byte past the last in the buffer. This is used to
 *                avoid buffer overreads (in case of an unfinished
 *                UTF-8 sequence towards the end of the buffer).
 * @param flags   a collection of AV_UTF8_FLAG_* flags
 * @return >= 0 in case a sequence was successfully read, a negative
 * value in case of invalid sequence
 */
@NoException public static native int av_utf8_decode(IntPointer codep, @Cast("const uint8_t**") PointerPointer bufp, @Cast("const uint8_t*") BytePointer buf_end,
                   @Cast("unsigned int") int flags);
@NoException public static native int av_utf8_decode(IntPointer codep, @Cast("const uint8_t**") @ByPtrPtr BytePointer bufp, @Cast("const uint8_t*") BytePointer buf_end,
                   @Cast("unsigned int") int flags);
@NoException public static native int av_utf8_decode(IntBuffer codep, @Cast("const uint8_t**") @ByPtrPtr ByteBuffer bufp, @Cast("const uint8_t*") ByteBuffer buf_end,
                   @Cast("unsigned int") int flags);
@NoException public static native int av_utf8_decode(int[] codep, @Cast("const uint8_t**") @ByPtrPtr byte[] bufp, @Cast("const uint8_t*") byte[] buf_end,
                   @Cast("unsigned int") int flags);

/**
 * Check if a name is in a list.
 * @return 0 if not found, or the 1 based index where it has been found in the
 *            list.
 */
@NoException public static native int av_match_list(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer list, @Cast("char") byte separator);
@NoException public static native int av_match_list(String name, String list, @Cast("char") byte separator);

/**
 * See libc sscanf manual for more information.
 * Locale-independent sscanf implementation.
 */
@NoException public static native int av_sscanf(@Cast("const char*") BytePointer string, @Cast("const char*") BytePointer format);
@NoException public static native int av_sscanf(String string, String format);

/**
 * \}
 */

// #endif /* AVUTIL_AVSTRING_H */


// Parsed from <libavutil/bprint.h>

/*
 * Copyright (c) 2012 Nicolas George
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_BPRINT_H
// #define AVUTIL_BPRINT_H

// #include <stdarg.h>

// #include "attributes.h"
// #include "avstring.h"

/**
 * Define a structure with extra padding to a fixed size
 * This helps ensuring binary compatibility with future versions.
 */

// #define FF_PAD_STRUCTURE(name, size, ...)
// struct ff_pad_helper_##name { __VA_ARGS__ };
// typedef struct name {
//     __VA_ARGS__
//     char reserved_padding[size - sizeof(struct ff_pad_helper_##name)];
// } name;
// Targeting ..\avutil\ff_pad_helper_AVBPrint.java


// Targeting ..\avutil\AVBPrint.java



/**
 * Convenience macros for special values for av_bprint_init() size_max
 * parameter.
 */
public static final int AV_BPRINT_SIZE_UNLIMITED =  ((int)-1);
public static final int AV_BPRINT_SIZE_AUTOMATIC =  1;
public static final int AV_BPRINT_SIZE_COUNT_ONLY = 0;

/**
 * Init a print buffer.
 *
 * @param buf        buffer to init
 * @param size_init  initial size (including the final 0)
 * @param size_max   maximum size;
 *                   0 means do not write anything, just count the length;
 *                   1 is replaced by the maximum value for automatic storage;
 *                   any large value means that the internal buffer will be
 *                   reallocated as needed up to that limit; -1 is converted to
 *                   UINT_MAX, the largest limit possible.
 *                   Check also AV_BPRINT_SIZE_* macros.
 */
@NoException public static native void av_bprint_init(AVBPrint buf, @Cast("unsigned") int size_init, @Cast("unsigned") int size_max);

/**
 * Init a print buffer using a pre-existing buffer.
 *
 * The buffer will not be reallocated.
 *
 * @param buf     buffer structure to init
 * @param buffer  byte buffer to use for the string data
 * @param size    size of buffer
 */
@NoException public static native void av_bprint_init_for_buffer(AVBPrint buf, @Cast("char*") BytePointer buffer, @Cast("unsigned") int size);
@NoException public static native void av_bprint_init_for_buffer(AVBPrint buf, @Cast("char*") ByteBuffer buffer, @Cast("unsigned") int size);
@NoException public static native void av_bprint_init_for_buffer(AVBPrint buf, @Cast("char*") byte[] buffer, @Cast("unsigned") int size);

/**
 * Append a formatted string to a print buffer.
 */
@NoException public static native void av_bprintf(AVBPrint buf, @Cast("const char*") BytePointer fmt);
@NoException public static native void av_bprintf(AVBPrint buf, String fmt);

/**
 * Append a formatted string to a print buffer.
 */
@NoException public static native void av_vbprintf(AVBPrint buf, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl_arg);
@NoException public static native void av_vbprintf(AVBPrint buf, String fmt, @ByVal @Cast("va_list*") Pointer vl_arg);

/**
 * Append char c n times to a print buffer.
 */
@NoException public static native void av_bprint_chars(AVBPrint buf, @Cast("char") byte c, @Cast("unsigned") int n);

/**
 * Append data to a print buffer.
 *
 * param buf  bprint buffer to use
 * param data pointer to data
 * param size size of data
 */
@NoException public static native void av_bprint_append_data(AVBPrint buf, @Cast("const char*") BytePointer data, @Cast("unsigned") int size);
@NoException public static native void av_bprint_append_data(AVBPrint buf, String data, @Cast("unsigned") int size);
// Targeting ..\avutil\tm.java


/**
 * Append a formatted date and time to a print buffer.
 *
 * param buf  bprint buffer to use
 * param fmt  date and time format string, see strftime()
 * param tm   broken-down time structure to translate
 *
 * \note due to poor design of the standard strftime function, it may
 * produce poor results if the format string expands to a very long text and
 * the bprint buffer is near the limit stated by the size_max option.
 */
@NoException public static native void av_bprint_strftime(AVBPrint buf, @Cast("const char*") BytePointer fmt, @Const tm tm);
@NoException public static native void av_bprint_strftime(AVBPrint buf, String fmt, @Const tm tm);

/**
 * Allocate bytes in the buffer for external use.
 *
 * @param buf [in]          buffer structure
 * @param size [in]         required size
 * @param mem [out]          pointer to the memory area
 * @param actual_size [out]  size of the memory area after allocation;
 *                          can be larger or smaller than size
 */
@NoException public static native void av_bprint_get_buffer(AVBPrint buf, @Cast("unsigned") int size,
                          @Cast("unsigned char**") PointerPointer mem, @Cast("unsigned*") IntPointer actual_size);
@NoException public static native void av_bprint_get_buffer(AVBPrint buf, @Cast("unsigned") int size,
                          @Cast("unsigned char**") @ByPtrPtr BytePointer mem, @Cast("unsigned*") IntPointer actual_size);
@NoException public static native void av_bprint_get_buffer(AVBPrint buf, @Cast("unsigned") int size,
                          @Cast("unsigned char**") @ByPtrPtr ByteBuffer mem, @Cast("unsigned*") IntBuffer actual_size);
@NoException public static native void av_bprint_get_buffer(AVBPrint buf, @Cast("unsigned") int size,
                          @Cast("unsigned char**") @ByPtrPtr byte[] mem, @Cast("unsigned*") int[] actual_size);

/**
 * Reset the string to "" but keep internal allocated data.
 */
@NoException public static native void av_bprint_clear(AVBPrint buf);

/**
 * Test if the print buffer is complete (not truncated).
 *
 * It may have been truncated due to a memory allocation failure
 * or the size_max limit (compare size and size_max if necessary).
 */
@NoException public static native int av_bprint_is_complete(@Const AVBPrint buf);

/**
 * Finalize a print buffer.
 *
 * The print buffer can no longer be used afterwards,
 * but the len and size fields are still valid.
 *
 * \arg[out] ret_str  if not NULL, used to return a permanent copy of the
 *                    buffer contents, or NULL if memory allocation fails;
 *                    if NULL, the buffer is discarded and freed
 * @return  0 for success or error code (probably AVERROR(ENOMEM))
 */
@NoException public static native int av_bprint_finalize(AVBPrint buf, @Cast("char**") PointerPointer ret_str);
@NoException public static native int av_bprint_finalize(AVBPrint buf, @Cast("char**") @ByPtrPtr BytePointer ret_str);
@NoException public static native int av_bprint_finalize(AVBPrint buf, @Cast("char**") @ByPtrPtr ByteBuffer ret_str);
@NoException public static native int av_bprint_finalize(AVBPrint buf, @Cast("char**") @ByPtrPtr byte[] ret_str);

/**
 * Escape the content in src and append it to dstbuf.
 *
 * @param dstbuf        already inited destination bprint buffer
 * @param src           string containing the text to escape
 * @param special_chars string containing the special characters which
 *                      need to be escaped, can be NULL
 * @param mode          escape mode to employ, see AV_ESCAPE_MODE_* macros.
 *                      Any unknown value for mode will be considered equivalent to
 *                      AV_ESCAPE_MODE_BACKSLASH, but this behaviour can change without
 *                      notice.
 * @param flags         flags which control how to escape, see AV_ESCAPE_FLAG_* macros
 */
@NoException public static native void av_bprint_escape(AVBPrint dstbuf, @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer special_chars,
                      @Cast("AVEscapeMode") int mode, int flags);
@NoException public static native void av_bprint_escape(AVBPrint dstbuf, String src, String special_chars,
                      @Cast("AVEscapeMode") int mode, int flags);

// #endif /* AVUTIL_BPRINT_H */


// Parsed from <libavutil/common.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * common internal and external API header
 */

// #ifndef AVUTIL_COMMON_H
// #define AVUTIL_COMMON_H

// #if defined(__cplusplus) && !defined(__STDC_CONSTANT_MACROS) && !defined(UINT64_C)
// #error missing -D__STDC_CONSTANT_MACROS / #define __STDC_CONSTANT_MACROS
// #endif

// #include <errno.h>
// #include <inttypes.h>
// #include <limits.h>
// #include <math.h>
// #include <stdint.h>
// #include <stdio.h>
// #include <stdlib.h>
// #include <string.h>

// #include "attributes.h"
// #include "macros.h"
// #include "version.h"
// #include "libavutil/avconfig.h"

// #if AV_HAVE_BIGENDIAN
// #   define AV_NE(be, le) (be)
// #else
// #   define AV_NE(be, le) (le)
// #endif

//rounded division & shift
// #define RSHIFT(a,b) ((a) > 0 ? ((a) + ((1<<(b))>>1))>>(b) : ((a) + ((1<<(b))>>1)-1)>>(b))
/* assume b>0 */
// #define ROUNDED_DIV(a,b) (((a)>=0 ? (a) + ((b)>>1) : (a) - ((b)>>1))/(b))
/* Fast a/(1<<b) rounded toward +inf. Assume a>=0 and b>=0 */
// #define AV_CEIL_RSHIFT(a,b) (!av_builtin_constant_p(b) ? -((-(a)) >> (b))
//                                                        : ((a) + (1<<(b)) - 1) >> (b))
/* Backwards compat. */
// #define FF_CEIL_RSHIFT AV_CEIL_RSHIFT

// #define FFUDIV(a,b) (((a)>0 ?(a):(a)-(b)+1) / (b))
// #define FFUMOD(a,b) ((a)-(b)*FFUDIV(a,b))

/**
 * Absolute value, Note, INT_MIN / INT64_MIN result in undefined behavior as they
 * are not representable as absolute values of their type. This is the same
 * as with *abs()
 * @see FFNABS()
 */
// #define FFABS(a) ((a) >= 0 ? (a) : (-(a)))
// #define FFSIGN(a) ((a) > 0 ? 1 : -1)

/**
 * Negative Absolute value.
 * this works for all integers of all types.
 * As with many macros, this evaluates its argument twice, it thus must not have
 * a sideeffect, that is FFNABS(x++) has undefined behavior.
 */
// #define FFNABS(a) ((a) <= 0 ? (a) : (-(a)))

/**
 * Comparator.
 * For two numerical expressions x and y, gives 1 if x > y, -1 if x < y, and 0
 * if x == y. This is useful for instance in a qsort comparator callback.
 * Furthermore, compilers are able to optimize this to branchless code, and
 * there is no risk of overflow with signed types.
 * As with many macros, this evaluates its argument multiple times, it thus
 * must not have a side-effect.
 */
// #define FFDIFFSIGN(x,y) (((x)>(y)) - ((x)<(y)))

// #define FFMAX(a,b) ((a) > (b) ? (a) : (b))
// #define FFMAX3(a,b,c) FFMAX(FFMAX(a,b),c)
// #define FFMIN(a,b) ((a) > (b) ? (b) : (a))
// #define FFMIN3(a,b,c) FFMIN(FFMIN(a,b),c)

// #define FFSWAP(type,a,b) do{type SWAP_tmp= b; b= a; a= SWAP_tmp;}while(0)
// #define FF_ARRAY_ELEMS(a) (sizeof(a) / sizeof((a)[0]))

/* misc math functions */

// #ifdef HAVE_AV_CONFIG_H
// #   include "config.h"
// #   include "intmath.h"
// #endif

/* Pull in unguarded fallback defines at the end of this file. */
// #include "common.h"

// #ifndef av_log2
@NoException public static native @Const int av_log2(@Cast("unsigned") int v);
// #endif

// #ifndef av_log2_16bit
@NoException public static native @Const int av_log2_16bit(@Cast("unsigned") int v);
// #endif

/**
 * Clip a signed integer value into the amin-amax range.
 * @param a value to clip
 * @param amin minimum value of the clip range
 * @param amax maximum value of the clip range
 * @return clipped value
 */
@NoException public static native @Const int av_clip_c(int a, int amin, int amax);

/**
 * Clip a signed 64bit integer value into the amin-amax range.
 * @param a value to clip
 * @param amin minimum value of the clip range
 * @param amax maximum value of the clip range
 * @return clipped value
 */
@NoException public static native @Cast("int64_t") @Const long av_clip64_c(@Cast("int64_t") long a, @Cast("int64_t") long amin, @Cast("int64_t") long amax);

/**
 * Clip a signed integer value into the 0-255 range.
 * @param a value to clip
 * @return clipped value
 */
@NoException public static native @Cast("uint8_t") @Const byte av_clip_uint8_c(int a);

/**
 * Clip a signed integer value into the -128,127 range.
 * @param a value to clip
 * @return clipped value
 */
@NoException public static native @Const byte av_clip_int8_c(int a);

/**
 * Clip a signed integer value into the 0-65535 range.
 * @param a value to clip
 * @return clipped value
 */
@NoException public static native @Cast("uint16_t") @Const short av_clip_uint16_c(int a);

/**
 * Clip a signed integer value into the -32768,32767 range.
 * @param a value to clip
 * @return clipped value
 */
@NoException public static native @Const short av_clip_int16_c(int a);

/**
 * Clip a signed 64-bit integer value into the -2147483648,2147483647 range.
 * @param a value to clip
 * @return clipped value
 */
@NoException public static native @Const int av_clipl_int32_c(@Cast("int64_t") long a);

/**
 * Clip a signed integer into the -(2^p),(2^p-1) range.
 * @param  a value to clip
 * @param  p bit position to clip at
 * @return clipped value
 */
@NoException public static native @Const int av_clip_intp2_c(int a, int p);

/**
 * Clip a signed integer to an unsigned power of two range.
 * @param  a value to clip
 * @param  p bit position to clip at
 * @return clipped value
 */
@NoException public static native @Cast("unsigned") @Const int av_clip_uintp2_c(int a, int p);

/**
 * Clear high bits from an unsigned integer starting with specific bit position
 * @param  a value to clip
 * @param  p bit position to clip at
 * @return clipped value
 */
@NoException public static native @Cast("unsigned") @Const int av_mod_uintp2_c(@Cast("unsigned") int a, @Cast("unsigned") int p);

/**
 * Add two signed 32-bit values with saturation.
 *
 * @param  a one value
 * @param  b another value
 * @return sum with signed saturation
 */
@NoException public static native int av_sat_add32_c(int a, int b);

/**
 * Add a doubled value to another value with saturation at both stages.
 *
 * @param  a first value
 * @param  b value doubled and added to a
 * @return sum sat(a + sat(2*b)) with signed saturation
 */
@NoException public static native int av_sat_dadd32_c(int a, int b);

/**
 * Subtract two signed 32-bit values with saturation.
 *
 * @param  a one value
 * @param  b another value
 * @return difference with signed saturation
 */
@NoException public static native int av_sat_sub32_c(int a, int b);

/**
 * Subtract a doubled value from another value with saturation at both stages.
 *
 * @param  a first value
 * @param  b value doubled and subtracted from a
 * @return difference sat(a - sat(2*b)) with signed saturation
 */
@NoException public static native int av_sat_dsub32_c(int a, int b);

/**
 * Add two signed 64-bit values with saturation.
 *
 * @param  a one value
 * @param  b another value
 * @return sum with signed saturation
 */
@NoException public static native @Cast("int64_t") long av_sat_add64_c(@Cast("int64_t") long a, @Cast("int64_t") long b);

/**
 * Subtract two signed 64-bit values with saturation.
 *
 * @param  a one value
 * @param  b another value
 * @return difference with signed saturation
 */
@NoException public static native @Cast("int64_t") long av_sat_sub64_c(@Cast("int64_t") long a, @Cast("int64_t") long b);

/**
 * Clip a float value into the amin-amax range.
 * @param a value to clip
 * @param amin minimum value of the clip range
 * @param amax maximum value of the clip range
 * @return clipped value
 */
@NoException public static native @Const float av_clipf_c(float a, float amin, float amax);

/**
 * Clip a double value into the amin-amax range.
 * @param a value to clip
 * @param amin minimum value of the clip range
 * @param amax maximum value of the clip range
 * @return clipped value
 */
@NoException public static native @Const double av_clipd_c(double a, double amin, double amax);

/** Compute ceil(log2(x)).
 * @param x value used to compute ceil(log2(x))
 * @return computed ceiling of log2(x)
 */
@NoException public static native @Const int av_ceil_log2_c(int x);

/**
 * Count number of bits set to one in x
 * @param x value to count bits of
 * @return the number of bits set to one in x
 */
@NoException public static native @Const int av_popcount_c(@Cast("uint32_t") int x);

/**
 * Count number of bits set to one in x
 * @param x value to count bits of
 * @return the number of bits set to one in x
 */
@NoException public static native @Const int av_popcount64_c(@Cast("uint64_t") long x);

@NoException public static native @Const int av_parity_c(@Cast("uint32_t") int v);

public static native int MKTAG(@Cast("char") byte a, @Cast("char") byte b, @Cast("char") byte c, @Cast("char") byte d);
public static native int MKBETAG(@Cast("char") byte a, @Cast("char") byte b, @Cast("char") byte c, @Cast("char") byte d);

/**
 * Convert a UTF-8 character (up to 4 bytes) to its 32-bit UCS-4 encoded form.
 *
 * @param val      Output value, must be an lvalue of type uint32_t.
 * @param GET_BYTE Expression reading one byte from the input.
 *                 Evaluated up to 7 times (4 for the currently
 *                 assigned Unicode range).  With a memory buffer
 *                 input, this could be *ptr++, or if you want to make sure
 *                 that *ptr stops at the end of a NULL terminated string then
 *                 *ptr ? *ptr++ : 0
 * @param ERROR    Expression to be evaluated on invalid input,
 *                 typically a goto statement.
 *
 * \warning ERROR should not contain a loop control statement which
 * could interact with the internal while loop, and should force an
 * exit from the macro code (e.g. through a goto or a return) in order
 * to prevent undefined results.
 */
// #define GET_UTF8(val, GET_BYTE, ERROR)
//     val= (GET_BYTE);
//     {
//         uint32_t top = (val & 128) >> 1;
//         if ((val & 0xc0) == 0x80 || val >= 0xFE)
//             {ERROR}
//         while (val & top) {
//             unsigned int tmp = (GET_BYTE) - 128;
//             if(tmp>>6)
//                 {ERROR}
//             val= (val<<6) + tmp;
//             top <<= 5;
//         }
//         val &= (top << 1) - 1;
//     }

/**
 * Convert a UTF-16 character (2 or 4 bytes) to its 32-bit UCS-4 encoded form.
 *
 * @param val       Output value, must be an lvalue of type uint32_t.
 * @param GET_16BIT Expression returning two bytes of UTF-16 data converted
 *                  to native byte order.  Evaluated one or two times.
 * @param ERROR     Expression to be evaluated on invalid input,
 *                  typically a goto statement.
 */
// #define GET_UTF16(val, GET_16BIT, ERROR)
//     val = (GET_16BIT);
//     {
//         unsigned int hi = val - 0xD800;
//         if (hi < 0x800) {
//             val = (GET_16BIT) - 0xDC00;
//             if (val > 0x3FF || hi > 0x3FF)
//                 {ERROR}
//             val += (hi<<10) + 0x10000;
//         }
//     }

/**
 * \def PUT_UTF8(val, tmp, PUT_BYTE)
 * Convert a 32-bit Unicode character to its UTF-8 encoded form (up to 4 bytes long).
 * @param val is an input-only argument and should be of type uint32_t. It holds
 * a UCS-4 encoded Unicode character that is to be converted to UTF-8. If
 * val is given as a function it is executed only once.
 * @param tmp is a temporary variable and should be of type uint8_t. It
 * represents an intermediate value during conversion that is to be
 * output by PUT_BYTE.
 * @param PUT_BYTE writes the converted UTF-8 bytes to any proper destination.
 * It could be a function or a statement, and uses tmp as the input byte.
 * For example, PUT_BYTE could be "*output++ = tmp;" PUT_BYTE will be
 * executed up to 4 times for values in the valid UTF-8 range and up to
 * 7 times in the general case, depending on the length of the converted
 * Unicode character.
 */
// #define PUT_UTF8(val, tmp, PUT_BYTE)
//     {
//         int bytes, shift;
//         uint32_t in = val;
//         if (in < 0x80) {
//             tmp = in;
//             PUT_BYTE
//         } else {
//             bytes = (av_log2(in) + 4) / 5;
//             shift = (bytes - 1) * 6;
//             tmp = (256 - (256 >> bytes)) | (in >> shift);
//             PUT_BYTE
//             while (shift >= 6) {
//                 shift -= 6;
//                 tmp = 0x80 | ((in >> shift) & 0x3f);
//                 PUT_BYTE
//             }
//         }
//     }

/**
 * \def PUT_UTF16(val, tmp, PUT_16BIT)
 * Convert a 32-bit Unicode character to its UTF-16 encoded form (2 or 4 bytes).
 * @param val is an input-only argument and should be of type uint32_t. It holds
 * a UCS-4 encoded Unicode character that is to be converted to UTF-16. If
 * val is given as a function it is executed only once.
 * @param tmp is a temporary variable and should be of type uint16_t. It
 * represents an intermediate value during conversion that is to be
 * output by PUT_16BIT.
 * @param PUT_16BIT writes the converted UTF-16 data to any proper destination
 * in desired endianness. It could be a function or a statement, and uses tmp
 * as the input byte.  For example, PUT_BYTE could be "*output++ = tmp;"
 * PUT_BYTE will be executed 1 or 2 times depending on input character.
 */
// #define PUT_UTF16(val, tmp, PUT_16BIT)
//     {
//         uint32_t in = val;
//         if (in < 0x10000) {
//             tmp = in;
//             PUT_16BIT
//         } else {
//             tmp = 0xD800 | ((in - 0x10000) >> 10);
//             PUT_16BIT
//             tmp = 0xDC00 | ((in - 0x10000) & 0x3FF);
//             PUT_16BIT
//         }
//     }



// #include "mem.h"

// #ifdef HAVE_AV_CONFIG_H
// #    include "internal.h"
// #endif /* HAVE_AV_CONFIG_H */

// #endif /* AVUTIL_COMMON_H */

/*
 * The following definitions are outside the multiple inclusion guard
 * to ensure they are immediately available in intmath.h.
 */

// #ifndef av_ceil_log2
// #   define av_ceil_log2     av_ceil_log2_c
// #endif
// #ifndef av_clip
// #   define av_clip          av_clip_c
// #endif
// #ifndef av_clip64
// #   define av_clip64        av_clip64_c
// #endif
// #ifndef av_clip_uint8
// #   define av_clip_uint8    av_clip_uint8_c
// #endif
// #ifndef av_clip_int8
// #   define av_clip_int8     av_clip_int8_c
// #endif
// #ifndef av_clip_uint16
// #   define av_clip_uint16   av_clip_uint16_c
// #endif
// #ifndef av_clip_int16
// #   define av_clip_int16    av_clip_int16_c
// #endif
// #ifndef av_clipl_int32
// #   define av_clipl_int32   av_clipl_int32_c
// #endif
// #ifndef av_clip_intp2
// #   define av_clip_intp2    av_clip_intp2_c
// #endif
// #ifndef av_clip_uintp2
// #   define av_clip_uintp2   av_clip_uintp2_c
// #endif
// #ifndef av_mod_uintp2
// #   define av_mod_uintp2    av_mod_uintp2_c
// #endif
// #ifndef av_sat_add32
// #   define av_sat_add32     av_sat_add32_c
// #endif
// #ifndef av_sat_dadd32
// #   define av_sat_dadd32    av_sat_dadd32_c
// #endif
// #ifndef av_sat_sub32
// #   define av_sat_sub32     av_sat_sub32_c
// #endif
// #ifndef av_sat_dsub32
// #   define av_sat_dsub32    av_sat_dsub32_c
// #endif
// #ifndef av_sat_add64
// #   define av_sat_add64     av_sat_add64_c
// #endif
// #ifndef av_sat_sub64
// #   define av_sat_sub64     av_sat_sub64_c
// #endif
// #ifndef av_clipf
// #   define av_clipf         av_clipf_c
// #endif
// #ifndef av_clipd
// #   define av_clipd         av_clipd_c
// #endif
// #ifndef av_popcount
// #   define av_popcount      av_popcount_c
// #endif
// #ifndef av_popcount64
// #   define av_popcount64    av_popcount64_c
// #endif
// #ifndef av_parity
// #   define av_parity        av_parity_c
// #endif


// Parsed from <libavutil/display.h>

/*
 * Copyright (c) 2014 Vittorio Giovara <vittorio.giovara@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * Display matrix
 */

// #ifndef AVUTIL_DISPLAY_H
// #define AVUTIL_DISPLAY_H

// #include <stdint.h>
// #include "common.h"

/**
 * \addtogroup lavu_video
 * \{
 *
 * \defgroup lavu_video_display Display transformation matrix functions
 * \{
 */

/**
 * \addtogroup lavu_video_display
 * The display transformation matrix specifies an affine transformation that
 * should be applied to video frames for correct presentation. It is compatible
 * with the matrices stored in the ISO/IEC 14496-12 container format.
 *
 * The data is a 3x3 matrix represented as a 9-element array:
 *
 * <pre>{@code {.unparsed}
 *                                  | a b u |
 *   (a, b, u, c, d, v, x, y, w) -> | c d v |
 *                                  | x y w |
 * }</pre>
 *
 * All numbers are stored in native endianness, as 16.16 fixed-point values,
 * except for u, v and w, which are stored as 2.30 fixed-point values.
 *
 * The transformation maps a point (p, q) in the source (pre-transformation)
 * frame to the point (p', q') in the destination (post-transformation) frame as
 * follows:
 *
 * <pre>{@code {.unparsed}
 *               | a b u |
 *   (p, q, 1) . | c d v | = z * (p', q', 1)
 *               | x y w |
 * }</pre>
 *
 * The transformation can also be more explicitly written in components as
 * follows:
 *
 * <pre>{@code {.unparsed}
 *   p' = (a * p + c * q + x) / z;
 *   q' = (b * p + d * q + y) / z;
 *   z  =  u * p + v * q + w
 * }</pre>
 */

/**
 * Extract the rotation component of the transformation matrix.
 *
 * @param matrix the transformation matrix
 * @return the angle (in degrees) by which the transformation rotates the frame
 *         counterclockwise. The angle will be in range [-180.0, 180.0],
 *         or NaN if the matrix is singular.
 *
 * \note floating point numbers are inherently inexact, so callers are
 *       recommended to round the return value to nearest integer before use.
 */
@NoException public static native double av_display_rotation_get(@Const IntPointer matrix);
@NoException public static native double av_display_rotation_get(@Const IntBuffer matrix);
@NoException public static native double av_display_rotation_get(@Const int[] matrix);

/**
 * Initialize a transformation matrix describing a pure counterclockwise
 * rotation by the specified angle (in degrees).
 *
 * @param matrix an allocated transformation matrix (will be fully overwritten
 *               by this function)
 * @param angle rotation angle in degrees.
 */
@NoException public static native void av_display_rotation_set(IntPointer matrix, double angle);
@NoException public static native void av_display_rotation_set(IntBuffer matrix, double angle);
@NoException public static native void av_display_rotation_set(int[] matrix, double angle);

/**
 * Flip the input matrix horizontally and/or vertically.
 *
 * @param matrix an allocated transformation matrix
 * @param hflip whether the matrix should be flipped horizontally
 * @param vflip whether the matrix should be flipped vertically
 */
@NoException public static native void av_display_matrix_flip(IntPointer matrix, int hflip, int vflip);
@NoException public static native void av_display_matrix_flip(IntBuffer matrix, int hflip, int vflip);
@NoException public static native void av_display_matrix_flip(int[] matrix, int hflip, int vflip);

/**
 * \}
 * \}
 */

// #endif /* AVUTIL_DISPLAY_H */


// Parsed from <libavutil/eval.h>

/*
 * Copyright (c) 2002 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * simple arithmetic expression evaluator
 */

// #ifndef AVUTIL_EVAL_H
// #define AVUTIL_EVAL_H

// #include "avutil.h"
// Targeting ..\avutil\AVExpr.java


// Targeting ..\avutil\Funcs1_Pointer_double.java


// Targeting ..\avutil\Funcs2_Pointer_double_double.java


@NoException public static native int av_expr_parse_and_eval(DoublePointer res, @Cast("const char*") BytePointer s,
                           @Cast("const char*const*") PointerPointer const_names, @Const DoublePointer const_values,
                           @Cast("const char*const*") PointerPointer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                           @Cast("const char*const*") PointerPointer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                           Pointer opaque, int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse_and_eval(DoublePointer res, @Cast("const char*") BytePointer s,
                           @Cast("const char*const*") @ByPtrPtr BytePointer const_names, @Const DoublePointer const_values,
                           @Cast("const char*const*") @ByPtrPtr BytePointer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                           @Cast("const char*const*") @ByPtrPtr BytePointer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                           Pointer opaque, int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse_and_eval(DoubleBuffer res, String s,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer const_names, @Const DoubleBuffer const_values,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                           Pointer opaque, int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse_and_eval(double[] res, @Cast("const char*") BytePointer s,
                           @Cast("const char*const*") @ByPtrPtr byte[] const_names, @Const double[] const_values,
                           @Cast("const char*const*") @ByPtrPtr byte[] func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                           @Cast("const char*const*") @ByPtrPtr byte[] func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                           Pointer opaque, int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse_and_eval(DoublePointer res, String s,
                           @Cast("const char*const*") @ByPtrPtr BytePointer const_names, @Const DoublePointer const_values,
                           @Cast("const char*const*") @ByPtrPtr BytePointer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                           @Cast("const char*const*") @ByPtrPtr BytePointer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                           Pointer opaque, int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse_and_eval(DoubleBuffer res, @Cast("const char*") BytePointer s,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer const_names, @Const DoubleBuffer const_values,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                           @Cast("const char*const*") @ByPtrPtr ByteBuffer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                           Pointer opaque, int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse_and_eval(double[] res, String s,
                           @Cast("const char*const*") @ByPtrPtr byte[] const_names, @Const double[] const_values,
                           @Cast("const char*const*") @ByPtrPtr byte[] func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                           @Cast("const char*const*") @ByPtrPtr byte[] func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                           Pointer opaque, int log_offset, Pointer log_ctx);

/**
 * Parse an expression.
 *
 * @param expr a pointer where is put an AVExpr containing the parsed
 * value in case of successful parsing, or NULL otherwise.
 * The pointed to AVExpr must be freed with av_expr_free() by the user
 * when it is not needed anymore.
 * @param s expression as a zero terminated string, for example "1+2^3+5*5+sin(2/3)"
 * @param const_names NULL terminated array of zero terminated strings of constant identifiers, for example {"PI", "E", 0}
 * @param func1_names NULL terminated array of zero terminated strings of funcs1 identifiers
 * @param funcs1 NULL terminated array of function pointers for functions which take 1 argument
 * @param func2_names NULL terminated array of zero terminated strings of funcs2 identifiers
 * @param funcs2 NULL terminated array of function pointers for functions which take 2 arguments
 * @param log_ctx parent logging context
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code otherwise
 */
@NoException public static native int av_expr_parse(@Cast("AVExpr**") PointerPointer expr, @Cast("const char*") BytePointer s,
                  @Cast("const char*const*") PointerPointer const_names,
                  @Cast("const char*const*") PointerPointer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                  @Cast("const char*const*") PointerPointer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                  int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse(@ByPtrPtr AVExpr expr, @Cast("const char*") BytePointer s,
                  @Cast("const char*const*") @ByPtrPtr BytePointer const_names,
                  @Cast("const char*const*") @ByPtrPtr BytePointer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                  @Cast("const char*const*") @ByPtrPtr BytePointer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                  int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse(@ByPtrPtr AVExpr expr, String s,
                  @Cast("const char*const*") @ByPtrPtr ByteBuffer const_names,
                  @Cast("const char*const*") @ByPtrPtr ByteBuffer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                  @Cast("const char*const*") @ByPtrPtr ByteBuffer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                  int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse(@ByPtrPtr AVExpr expr, @Cast("const char*") BytePointer s,
                  @Cast("const char*const*") @ByPtrPtr byte[] const_names,
                  @Cast("const char*const*") @ByPtrPtr byte[] func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                  @Cast("const char*const*") @ByPtrPtr byte[] func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                  int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse(@ByPtrPtr AVExpr expr, String s,
                  @Cast("const char*const*") @ByPtrPtr BytePointer const_names,
                  @Cast("const char*const*") @ByPtrPtr BytePointer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                  @Cast("const char*const*") @ByPtrPtr BytePointer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                  int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse(@ByPtrPtr AVExpr expr, @Cast("const char*") BytePointer s,
                  @Cast("const char*const*") @ByPtrPtr ByteBuffer const_names,
                  @Cast("const char*const*") @ByPtrPtr ByteBuffer func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                  @Cast("const char*const*") @ByPtrPtr ByteBuffer func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                  int log_offset, Pointer log_ctx);
@NoException public static native int av_expr_parse(@ByPtrPtr AVExpr expr, String s,
                  @Cast("const char*const*") @ByPtrPtr byte[] const_names,
                  @Cast("const char*const*") @ByPtrPtr byte[] func1_names, @Cast("double (**)(void*, double)") PointerPointer funcs1,
                  @Cast("const char*const*") @ByPtrPtr byte[] func2_names, @Cast("double (**)(void*, double, double)") PointerPointer funcs2,
                  int log_offset, Pointer log_ctx);

/**
 * Evaluate a previously parsed expression.
 *
 * @param const_values a zero terminated array of values for the identifiers from av_expr_parse() const_names
 * @param opaque a pointer which will be passed to all functions from funcs1 and funcs2
 * @return the value of the expression
 */
@NoException public static native double av_expr_eval(AVExpr e, @Const DoublePointer const_values, Pointer opaque);
@NoException public static native double av_expr_eval(AVExpr e, @Const DoubleBuffer const_values, Pointer opaque);
@NoException public static native double av_expr_eval(AVExpr e, @Const double[] const_values, Pointer opaque);

/**
 * Track the presence of variables and their number of occurrences in a parsed expression
 *
 * @param counter a zero-initialized array where the count of each variable will be stored
 * @param size size of array
 * @return 0 on success, a negative value indicates that no expression or array was passed
 * or size was zero
 */
@NoException public static native int av_expr_count_vars(AVExpr e, @Cast("unsigned*") IntPointer counter, int size);
@NoException public static native int av_expr_count_vars(AVExpr e, @Cast("unsigned*") IntBuffer counter, int size);
@NoException public static native int av_expr_count_vars(AVExpr e, @Cast("unsigned*") int[] counter, int size);

/**
 * Track the presence of user provided functions and their number of occurrences
 * in a parsed expression.
 *
 * @param counter a zero-initialized array where the count of each function will be stored
 *                if you passed 5 functions with 2 arguments to av_expr_parse()
 *                then for arg=2 this will use upto 5 entries.
 * @param size size of array
 * @param arg number of arguments the counted functions have
 * @return 0 on success, a negative value indicates that no expression or array was passed
 * or size was zero
 */
@NoException public static native int av_expr_count_func(AVExpr e, @Cast("unsigned*") IntPointer counter, int size, int arg);
@NoException public static native int av_expr_count_func(AVExpr e, @Cast("unsigned*") IntBuffer counter, int size, int arg);
@NoException public static native int av_expr_count_func(AVExpr e, @Cast("unsigned*") int[] counter, int size, int arg);

/**
 * Free a parsed expression previously created with av_expr_parse().
 */
@NoException public static native void av_expr_free(AVExpr e);

/**
 * Parse the string in numstr and return its value as a double. If
 * the string is empty, contains only whitespaces, or does not contain
 * an initial substring that has the expected syntax for a
 * floating-point number, no conversion is performed. In this case,
 * returns a value of zero and the value returned in tail is the value
 * of numstr.
 *
 * @param numstr a string representing a number, may contain one of
 * the International System number postfixes, for example 'K', 'M',
 * 'G'. If 'i' is appended after the postfix, powers of 2 are used
 * instead of powers of 10. The 'B' postfix multiplies the value by
 * 8, and can be appended after another postfix or used alone. This
 * allows using for example 'KB', 'MiB', 'G' and 'B' as postfix.
 * @param tail if non-NULL puts here the pointer to the char next
 * after the last parsed character
 */
@NoException public static native double av_strtod(@Cast("const char*") BytePointer numstr, @Cast("char**") PointerPointer tail);
@NoException public static native double av_strtod(@Cast("const char*") BytePointer numstr, @Cast("char**") @ByPtrPtr BytePointer tail);
@NoException public static native double av_strtod(String numstr, @Cast("char**") @ByPtrPtr ByteBuffer tail);
@NoException public static native double av_strtod(@Cast("const char*") BytePointer numstr, @Cast("char**") @ByPtrPtr byte[] tail);
@NoException public static native double av_strtod(String numstr, @Cast("char**") @ByPtrPtr BytePointer tail);
@NoException public static native double av_strtod(@Cast("const char*") BytePointer numstr, @Cast("char**") @ByPtrPtr ByteBuffer tail);
@NoException public static native double av_strtod(String numstr, @Cast("char**") @ByPtrPtr byte[] tail);

// #endif /* AVUTIL_EVAL_H */


// Parsed from <libavutil/encryption_info.h>

/**
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_ENCRYPTION_INFO_H
// #define AVUTIL_ENCRYPTION_INFO_H

// #include <stddef.h>
// #include <stdint.h>
// Targeting ..\avutil\AVSubsampleEncryptionInfo.java


// Targeting ..\avutil\AVEncryptionInfo.java


// Targeting ..\avutil\AVEncryptionInitInfo.java



/**
 * Allocates an AVEncryptionInfo structure and sub-pointers to hold the given
 * number of subsamples.  This will allocate pointers for the key ID, IV,
 * and subsample entries, set the size members, and zero-initialize the rest.
 *
 * @param subsample_count The number of subsamples.
 * @param key_id_size The number of bytes in the key ID, should be 16.
 * @param iv_size The number of bytes in the IV, should be 16.
 *
 * @return The new AVEncryptionInfo structure, or NULL on error.
 */
@NoException public static native AVEncryptionInfo av_encryption_info_alloc(@Cast("uint32_t") int subsample_count, @Cast("uint32_t") int key_id_size, @Cast("uint32_t") int iv_size);

/**
 * Allocates an AVEncryptionInfo structure with a copy of the given data.
 * @return The new AVEncryptionInfo structure, or NULL on error.
 */
@NoException public static native AVEncryptionInfo av_encryption_info_clone(@Const AVEncryptionInfo info);

/**
 * Frees the given encryption info object.  This MUST NOT be used to free the
 * side-data data pointer, that should use normal side-data methods.
 */
@NoException public static native void av_encryption_info_free(AVEncryptionInfo info);

/**
 * Creates a copy of the AVEncryptionInfo that is contained in the given side
 * data.  The resulting object should be passed to av_encryption_info_free()
 * when done.
 *
 * @return The new AVEncryptionInfo structure, or NULL on error.
 */
@NoException public static native AVEncryptionInfo av_encryption_info_get_side_data(@Cast("const uint8_t*") BytePointer side_data, @Cast("size_t") long side_data_size);
@NoException public static native AVEncryptionInfo av_encryption_info_get_side_data(@Cast("const uint8_t*") ByteBuffer side_data, @Cast("size_t") long side_data_size);
@NoException public static native AVEncryptionInfo av_encryption_info_get_side_data(@Cast("const uint8_t*") byte[] side_data, @Cast("size_t") long side_data_size);

/**
 * Allocates and initializes side data that holds a copy of the given encryption
 * info.  The resulting pointer should be either freed using av_free or given
 * to av_packet_add_side_data().
 *
 * @return The new side-data pointer, or NULL.
 */
@NoException public static native @Cast("uint8_t*") BytePointer av_encryption_info_add_side_data(
      @Const AVEncryptionInfo info, @Cast("size_t*") SizeTPointer side_data_size);


/**
 * Allocates an AVEncryptionInitInfo structure and sub-pointers to hold the
 * given sizes.  This will allocate pointers and set all the fields.
 *
 * @return The new AVEncryptionInitInfo structure, or NULL on error.
 */
@NoException public static native AVEncryptionInitInfo av_encryption_init_info_alloc(
    @Cast("uint32_t") int system_id_size, @Cast("uint32_t") int num_key_ids, @Cast("uint32_t") int key_id_size, @Cast("uint32_t") int data_size);

/**
 * Frees the given encryption init info object.  This MUST NOT be used to free
 * the side-data data pointer, that should use normal side-data methods.
 */
@NoException public static native void av_encryption_init_info_free(AVEncryptionInitInfo info);

/**
 * Creates a copy of the AVEncryptionInitInfo that is contained in the given
 * side data.  The resulting object should be passed to
 * av_encryption_init_info_free() when done.
 *
 * @return The new AVEncryptionInitInfo structure, or NULL on error.
 */
@NoException public static native AVEncryptionInitInfo av_encryption_init_info_get_side_data(
    @Cast("const uint8_t*") BytePointer side_data, @Cast("size_t") long side_data_size);
@NoException public static native AVEncryptionInitInfo av_encryption_init_info_get_side_data(
    @Cast("const uint8_t*") ByteBuffer side_data, @Cast("size_t") long side_data_size);
@NoException public static native AVEncryptionInitInfo av_encryption_init_info_get_side_data(
    @Cast("const uint8_t*") byte[] side_data, @Cast("size_t") long side_data_size);

/**
 * Allocates and initializes side data that holds a copy of the given encryption
 * init info.  The resulting pointer should be either freed using av_free or
 * given to av_packet_add_side_data().
 *
 * @return The new side-data pointer, or NULL.
 */
@NoException public static native @Cast("uint8_t*") BytePointer av_encryption_init_info_add_side_data(
    @Const AVEncryptionInitInfo info, @Cast("size_t*") SizeTPointer side_data_size);

// #endif /* AVUTIL_ENCRYPTION_INFO_H */


// Parsed from <libavutil/file.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_FILE_H
// #define AVUTIL_FILE_H

// #include <stdint.h>

// #include "avutil.h"

/**
 * \file
 * Misc file utilities.
 */

/**
 * Read the file with name filename, and put its content in a newly
 * allocated buffer or map it with mmap() when available.
 * In case of success set *bufptr to the read or mmapped buffer, and
 * *size to the size in bytes of the buffer in *bufptr.
 * Unlike mmap this function succeeds with zero sized files, in this
 * case *bufptr will be set to NULL and *size will be set to 0.
 * The returned buffer must be released with av_file_unmap().
 *
 * @param log_offset loglevel offset used for logging
 * @param log_ctx context used for logging
 * @return a non negative number in case of success, a negative value
 * corresponding to an AVERROR error code in case of failure
 */
@NoException public static native int av_file_map(@Cast("const char*") BytePointer filename, @Cast("uint8_t**") PointerPointer bufptr, @Cast("size_t*") SizeTPointer size,
                int log_offset, Pointer log_ctx);
@NoException public static native int av_file_map(@Cast("const char*") BytePointer filename, @Cast("uint8_t**") @ByPtrPtr BytePointer bufptr, @Cast("size_t*") SizeTPointer size,
                int log_offset, Pointer log_ctx);
@NoException public static native int av_file_map(String filename, @Cast("uint8_t**") @ByPtrPtr ByteBuffer bufptr, @Cast("size_t*") SizeTPointer size,
                int log_offset, Pointer log_ctx);
@NoException public static native int av_file_map(@Cast("const char*") BytePointer filename, @Cast("uint8_t**") @ByPtrPtr byte[] bufptr, @Cast("size_t*") SizeTPointer size,
                int log_offset, Pointer log_ctx);
@NoException public static native int av_file_map(String filename, @Cast("uint8_t**") @ByPtrPtr BytePointer bufptr, @Cast("size_t*") SizeTPointer size,
                int log_offset, Pointer log_ctx);
@NoException public static native int av_file_map(@Cast("const char*") BytePointer filename, @Cast("uint8_t**") @ByPtrPtr ByteBuffer bufptr, @Cast("size_t*") SizeTPointer size,
                int log_offset, Pointer log_ctx);
@NoException public static native int av_file_map(String filename, @Cast("uint8_t**") @ByPtrPtr byte[] bufptr, @Cast("size_t*") SizeTPointer size,
                int log_offset, Pointer log_ctx);

/**
 * Unmap or free the buffer bufptr created by av_file_map().
 *
 * @param size size in bytes of bufptr, must be the same as returned
 * by av_file_map()
 */
@NoException public static native void av_file_unmap(@Cast("uint8_t*") BytePointer bufptr, @Cast("size_t") long size);
@NoException public static native void av_file_unmap(@Cast("uint8_t*") ByteBuffer bufptr, @Cast("size_t") long size);
@NoException public static native void av_file_unmap(@Cast("uint8_t*") byte[] bufptr, @Cast("size_t") long size);

/**
 * Wrapper to work around the lack of mkstemp() on mingw.
 * Also, tries to create file in /tmp first, if possible.
 * *prefix can be a character constant; *filename will be allocated internally.
 * @return file descriptor of opened file (or negative value corresponding to an
 * AVERROR code on error)
 * and opened file name in **filename.
 * \note On very old libcs it is necessary to set a secure umask before
 *       calling this, av_tempfile() can't call umask itself as it is used in
 *       libraries and could interfere with the calling application.
 * @deprecated as fd numbers cannot be passed saftely between libs on some platforms
 */
@NoException public static native int av_tempfile(@Cast("const char*") BytePointer prefix, @Cast("char**") PointerPointer filename, int log_offset, Pointer log_ctx);
@NoException public static native int av_tempfile(@Cast("const char*") BytePointer prefix, @Cast("char**") @ByPtrPtr BytePointer filename, int log_offset, Pointer log_ctx);
@NoException public static native int av_tempfile(String prefix, @Cast("char**") @ByPtrPtr ByteBuffer filename, int log_offset, Pointer log_ctx);
@NoException public static native int av_tempfile(@Cast("const char*") BytePointer prefix, @Cast("char**") @ByPtrPtr byte[] filename, int log_offset, Pointer log_ctx);
@NoException public static native int av_tempfile(String prefix, @Cast("char**") @ByPtrPtr BytePointer filename, int log_offset, Pointer log_ctx);
@NoException public static native int av_tempfile(@Cast("const char*") BytePointer prefix, @Cast("char**") @ByPtrPtr ByteBuffer filename, int log_offset, Pointer log_ctx);
@NoException public static native int av_tempfile(String prefix, @Cast("char**") @ByPtrPtr byte[] filename, int log_offset, Pointer log_ctx);

// #endif /* AVUTIL_FILE_H */


// Parsed from <libavutil/hash.h>

/*
 * Copyright (C) 2013 Reimar Döffinger <Reimar.Doeffinger@gmx.de>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_hash_generic
 * Generic hashing API
 */

// #ifndef AVUTIL_HASH_H
// #define AVUTIL_HASH_H

// #include <stdint.h>

// #include "version.h"
// Targeting ..\avutil\AVHashContext.java



/**
 * Allocate a hash context for the algorithm specified by name.
 *
 * @return  >= 0 for success, a negative error code for failure
 *
 * \note The context is not initialized after a call to this function; you must
 * call av_hash_init() to do so.
 */
@NoException public static native int av_hash_alloc(@Cast("AVHashContext**") PointerPointer ctx, @Cast("const char*") BytePointer name);
@NoException public static native int av_hash_alloc(@ByPtrPtr AVHashContext ctx, @Cast("const char*") BytePointer name);
@NoException public static native int av_hash_alloc(@ByPtrPtr AVHashContext ctx, String name);

/**
 * Get the names of available hash algorithms.
 *
 * This function can be used to enumerate the algorithms.
 *
 * @param i [in]  Index of the hash algorithm, starting from 0
 * @return       Pointer to a static string or {@code NULL} if {@code i} is out of range
 */
@NoException public static native @Cast("const char*") BytePointer av_hash_names(int i);

/**
 * Get the name of the algorithm corresponding to the given hash context.
 */
@NoException public static native @Cast("const char*") BytePointer av_hash_get_name(@Const AVHashContext ctx);

/**
 * Maximum value that av_hash_get_size() will currently return.
 *
 * You can use this if you absolutely want or need to use static allocation for
 * the output buffer and are fine with not supporting hashes newly added to
 * libavutil without recompilation.
 *
 * \warning
 * Adding new hashes with larger sizes, and increasing the macro while doing
 * so, will not be considered an ABI change. To prevent your code from
 * overflowing a buffer, either dynamically allocate the output buffer with
 * av_hash_get_size(), or limit your use of the Hashing API to hashes that are
 * already in FFmpeg during the time of compilation.
 */
public static final int AV_HASH_MAX_SIZE = 64;

/**
 * Get the size of the resulting hash value in bytes.
 *
 * The maximum value this function will currently return is available as macro
 * #AV_HASH_MAX_SIZE.
 *
 * @param ctx [in] Hash context
 * @return            Size of the hash value in bytes
 */
@NoException public static native int av_hash_get_size(@Const AVHashContext ctx);

/**
 * Initialize or reset a hash context.
 *
 * @param ctx [in,out] Hash context
 */
@NoException public static native void av_hash_init(AVHashContext ctx);

/**
 * Update a hash context with additional data.
 *
 * @param ctx [in,out] Hash context
 * @param src [in] Data to be added to the hash context
 * @param len [in] Size of the additional data
 */
// #if FF_API_CRYPTO_SIZE_T
@NoException public static native void av_hash_update(AVHashContext ctx, @Cast("const uint8_t*") BytePointer src, int len);
@NoException public static native void av_hash_update(AVHashContext ctx, @Cast("const uint8_t*") ByteBuffer src, int len);
@NoException public static native void av_hash_update(AVHashContext ctx, @Cast("const uint8_t*") byte[] src, int len);
// #else
@NoException public static native void av_hash_update(AVHashContext ctx, @Cast("const uint8_t*") BytePointer src, @Cast("size_t") long len);
@NoException public static native void av_hash_update(AVHashContext ctx, @Cast("const uint8_t*") ByteBuffer src, @Cast("size_t") long len);
@NoException public static native void av_hash_update(AVHashContext ctx, @Cast("const uint8_t*") byte[] src, @Cast("size_t") long len);
// #endif

/**
 * Finalize a hash context and compute the actual hash value.
 *
 * The minimum size of {@code dst} buffer is given by av_hash_get_size() or
 * #AV_HASH_MAX_SIZE. The use of the latter macro is discouraged.
 *
 * It is not safe to update or finalize a hash context again, if it has already
 * been finalized.
 *
 * @param ctx [in,out] Hash context
 * @param dst [out] Where the final hash value will be stored
 *
 * @see av_hash_final_bin() provides an alternative API
 */
@NoException public static native void av_hash_final(AVHashContext ctx, @Cast("uint8_t*") BytePointer dst);
@NoException public static native void av_hash_final(AVHashContext ctx, @Cast("uint8_t*") ByteBuffer dst);
@NoException public static native void av_hash_final(AVHashContext ctx, @Cast("uint8_t*") byte[] dst);

/**
 * Finalize a hash context and store the actual hash value in a buffer.
 *
 * It is not safe to update or finalize a hash context again, if it has already
 * been finalized.
 *
 * If {@code size} is smaller than the hash size (given by av_hash_get_size()), the
 * hash is truncated; if size is larger, the buffer is padded with 0.
 *
 * @param ctx [in,out]  Hash context
 * @param dst [out]  Where the final hash value will be stored
 * @param size [in] Number of bytes to write to {@code dst}
 */
@NoException public static native void av_hash_final_bin(AVHashContext ctx, @Cast("uint8_t*") BytePointer dst, int size);
@NoException public static native void av_hash_final_bin(AVHashContext ctx, @Cast("uint8_t*") ByteBuffer dst, int size);
@NoException public static native void av_hash_final_bin(AVHashContext ctx, @Cast("uint8_t*") byte[] dst, int size);

/**
 * Finalize a hash context and store the hexadecimal representation of the
 * actual hash value as a string.
 *
 * It is not safe to update or finalize a hash context again, if it has already
 * been finalized.
 *
 * The string is always 0-terminated.
 *
 * If {@code size} is smaller than {@code 2 * hash_size + 1}, where {@code hash_size} is the
 * value returned by av_hash_get_size(), the string will be truncated.
 *
 * @param ctx [in,out]  Hash context
 * @param dst [out]  Where the string will be stored
 * @param size [in] Maximum number of bytes to write to {@code dst}
 */
@NoException public static native void av_hash_final_hex(AVHashContext ctx, @Cast("uint8_t*") BytePointer dst, int size);
@NoException public static native void av_hash_final_hex(AVHashContext ctx, @Cast("uint8_t*") ByteBuffer dst, int size);
@NoException public static native void av_hash_final_hex(AVHashContext ctx, @Cast("uint8_t*") byte[] dst, int size);

/**
 * Finalize a hash context and store the Base64 representation of the
 * actual hash value as a string.
 *
 * It is not safe to update or finalize a hash context again, if it has already
 * been finalized.
 *
 * The string is always 0-terminated.
 *
 * If {@code size} is smaller than AV_BASE64_SIZE(hash_size), where {@code hash_size} is
 * the value returned by av_hash_get_size(), the string will be truncated.
 *
 * @param ctx [in,out]  Hash context
 * @param dst [out]  Where the final hash value will be stored
 * @param size [in] Maximum number of bytes to write to {@code dst}
 */
@NoException public static native void av_hash_final_b64(AVHashContext ctx, @Cast("uint8_t*") BytePointer dst, int size);
@NoException public static native void av_hash_final_b64(AVHashContext ctx, @Cast("uint8_t*") ByteBuffer dst, int size);
@NoException public static native void av_hash_final_b64(AVHashContext ctx, @Cast("uint8_t*") byte[] dst, int size);

/**
 * Free hash context and set hash context pointer to {@code NULL}.
 *
 * @param ctx [in,out]  Pointer to hash context
 */
@NoException public static native void av_hash_freep(@Cast("AVHashContext**") PointerPointer ctx);
@NoException public static native void av_hash_freep(@ByPtrPtr AVHashContext ctx);

/**
 * \}
 * \}
 */

// #endif /* AVUTIL_HASH_H */


// Parsed from <libavutil/hdr_dynamic_metadata.h>

/*
 * Copyright (c) 2018 Mohammad Izadi <moh.izadi at gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_HDR_DYNAMIC_METADATA_H
// #define AVUTIL_HDR_DYNAMIC_METADATA_H

// #include "frame.h"
// #include "rational.h"

/**
 * Option for overlapping elliptical pixel selectors in an image.
 */
/** enum AVHDRPlusOverlapProcessOption */
public static final int
    AV_HDR_PLUS_OVERLAP_PROCESS_WEIGHTED_AVERAGING = 0,
    AV_HDR_PLUS_OVERLAP_PROCESS_LAYERING = 1;
// Targeting ..\avutil\AVHDRPlusPercentile.java


// Targeting ..\avutil\AVHDRPlusColorTransformParams.java


// Targeting ..\avutil\AVDynamicHDRPlus.java



/**
 * Allocate an AVDynamicHDRPlus structure and set its fields to
 * default values. The resulting struct can be freed using av_freep().
 *
 * @return An AVDynamicHDRPlus filled with default values or NULL
 *         on failure.
 */
@NoException public static native AVDynamicHDRPlus av_dynamic_hdr_plus_alloc(@Cast("size_t*") SizeTPointer size);

/**
 * Allocate a complete AVDynamicHDRPlus and add it to the frame.
 * @param frame The frame which side data is added to.
 *
 * @return The AVDynamicHDRPlus structure to be filled by caller or NULL
 *         on failure.
 */
@NoException public static native AVDynamicHDRPlus av_dynamic_hdr_plus_create_side_data(AVFrame frame);

// #endif /* AVUTIL_HDR_DYNAMIC_METADATA_H */


// Parsed from <libavutil/intfloat.h>

/*
 * Copyright (c) 2011 Mans Rullgard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_INTFLOAT_H
// #define AVUTIL_INTFLOAT_H

// #include <stdint.h>
// #include "attributes.h"
// Targeting ..\avutil\av_intfloat32.java


// Targeting ..\avutil\av_intfloat64.java



/**
 * Reinterpret a 32-bit integer as a float.
 */
@NoException public static native float av_int2float(@Cast("uint32_t") int i);

/**
 * Reinterpret a float as a 32-bit integer.
 */
@NoException public static native @Cast("uint32_t") int av_float2int(float f);

/**
 * Reinterpret a 64-bit integer as a double.
 */
@NoException public static native double av_int2double(@Cast("uint64_t") long i);

/**
 * Reinterpret a double as a 64-bit integer.
 */
@NoException public static native @Cast("uint64_t") long av_double2int(double f);

// #endif /* AVUTIL_INTFLOAT_H */


// Parsed from <libavutil/intreadwrite.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_INTREADWRITE_H
// #define AVUTIL_INTREADWRITE_H

// #include <stdint.h>
// #include "libavutil/avconfig.h"
// #include "attributes.h"
// #include "bswap.h"
// Targeting ..\avutil\av_alias64.java


// Targeting ..\avutil\av_alias32.java


// Targeting ..\avutil\av_alias16.java



/*
 * Arch-specific headers can provide any combination of
 * AV_[RW][BLN](16|24|32|48|64) and AV_(COPY|SWAP|ZERO)(64|128) macros.
 * Preprocessor symbols must be defined, even if these are implemented
 * as inline functions.
 *
 * R/W means read/write, B/L/N means big/little/native endianness.
 * The following macros require aligned access, compared to their
 * unaligned variants: AV_(COPY|SWAP|ZERO)(64|128), AV_[RW]N[8-64]A.
 * Incorrect usage may range from abysmal performance to crash
 * depending on the platform.
 *
 * The unaligned variants are AV_[RW][BLN][8-64] and AV_COPY*U.
 */

// #ifdef HAVE_AV_CONFIG_H

// #include "config.h"

// #if   ARCH_ARM
// #   include "arm/intreadwrite.h"
// #elif ARCH_AVR32
// #   include "avr32/intreadwrite.h"
// #elif ARCH_MIPS
// #   include "mips/intreadwrite.h"
// #elif ARCH_PPC
// #   include "ppc/intreadwrite.h"
// #elif ARCH_TOMI
// #   include "tomi/intreadwrite.h"
// #elif ARCH_X86
// #   include "x86/intreadwrite.h"
// #endif

// #endif /* HAVE_AV_CONFIG_H */

/*
 * Map AV_RNXX <-> AV_R[BL]XX for all variants provided by per-arch headers.
 */

// #if AV_HAVE_BIGENDIAN

// #   if    defined(AV_RN16) && !defined(AV_RB16)
// #       define AV_RB16(p) AV_RN16(p)
// #   elif !defined(AV_RN16) &&  defined(AV_RB16)
// #       define AV_RN16(p) AV_RB16(p)
// #   endif

// #   if    defined(AV_WN16) && !defined(AV_WB16)
// #       define AV_WB16(p, v) AV_WN16(p, v)
// #   elif !defined(AV_WN16) &&  defined(AV_WB16)
// #       define AV_WN16(p, v) AV_WB16(p, v)
// #   endif

// #   if    defined(AV_RN24) && !defined(AV_RB24)
// #       define AV_RB24(p) AV_RN24(p)
// #   elif !defined(AV_RN24) &&  defined(AV_RB24)
// #       define AV_RN24(p) AV_RB24(p)
// #   endif

// #   if    defined(AV_WN24) && !defined(AV_WB24)
// #       define AV_WB24(p, v) AV_WN24(p, v)
// #   elif !defined(AV_WN24) &&  defined(AV_WB24)
// #       define AV_WN24(p, v) AV_WB24(p, v)
// #   endif

// #   if    defined(AV_RN32) && !defined(AV_RB32)
// #       define AV_RB32(p) AV_RN32(p)
// #   elif !defined(AV_RN32) &&  defined(AV_RB32)
// #       define AV_RN32(p) AV_RB32(p)
// #   endif

// #   if    defined(AV_WN32) && !defined(AV_WB32)
// #       define AV_WB32(p, v) AV_WN32(p, v)
// #   elif !defined(AV_WN32) &&  defined(AV_WB32)
// #       define AV_WN32(p, v) AV_WB32(p, v)
// #   endif

// #   if    defined(AV_RN48) && !defined(AV_RB48)
// #       define AV_RB48(p) AV_RN48(p)
// #   elif !defined(AV_RN48) &&  defined(AV_RB48)
// #       define AV_RN48(p) AV_RB48(p)
// #   endif

// #   if    defined(AV_WN48) && !defined(AV_WB48)
// #       define AV_WB48(p, v) AV_WN48(p, v)
// #   elif !defined(AV_WN48) &&  defined(AV_WB48)
// #       define AV_WN48(p, v) AV_WB48(p, v)
// #   endif

// #   if    defined(AV_RN64) && !defined(AV_RB64)
// #       define AV_RB64(p) AV_RN64(p)
// #   elif !defined(AV_RN64) &&  defined(AV_RB64)
// #       define AV_RN64(p) AV_RB64(p)
// #   endif

// #   if    defined(AV_WN64) && !defined(AV_WB64)
// #       define AV_WB64(p, v) AV_WN64(p, v)
// #   elif !defined(AV_WN64) &&  defined(AV_WB64)
// #       define AV_WN64(p, v) AV_WB64(p, v)
// #   endif

// #else /* AV_HAVE_BIGENDIAN */

// #   if    defined(AV_RN16) && !defined(AV_RL16)
// #       define AV_RL16(p) AV_RN16(p)
// #   elif !defined(AV_RN16) &&  defined(AV_RL16)
// #       define AV_RN16(p) AV_RL16(p)
// #   endif

// #   if    defined(AV_WN16) && !defined(AV_WL16)
// #       define AV_WL16(p, v) AV_WN16(p, v)
// #   elif !defined(AV_WN16) &&  defined(AV_WL16)
// #       define AV_WN16(p, v) AV_WL16(p, v)
// #   endif

// #   if    defined(AV_RN24) && !defined(AV_RL24)
// #       define AV_RL24(p) AV_RN24(p)
// #   elif !defined(AV_RN24) &&  defined(AV_RL24)
// #       define AV_RN24(p) AV_RL24(p)
// #   endif

// #   if    defined(AV_WN24) && !defined(AV_WL24)
// #       define AV_WL24(p, v) AV_WN24(p, v)
// #   elif !defined(AV_WN24) &&  defined(AV_WL24)
// #       define AV_WN24(p, v) AV_WL24(p, v)
// #   endif

// #   if    defined(AV_RN32) && !defined(AV_RL32)
// #       define AV_RL32(p) AV_RN32(p)
// #   elif !defined(AV_RN32) &&  defined(AV_RL32)
// #       define AV_RN32(p) AV_RL32(p)
// #   endif

// #   if    defined(AV_WN32) && !defined(AV_WL32)
// #       define AV_WL32(p, v) AV_WN32(p, v)
// #   elif !defined(AV_WN32) &&  defined(AV_WL32)
// #       define AV_WN32(p, v) AV_WL32(p, v)
// #   endif

// #   if    defined(AV_RN48) && !defined(AV_RL48)
// #       define AV_RL48(p) AV_RN48(p)
// #   elif !defined(AV_RN48) &&  defined(AV_RL48)
// #       define AV_RN48(p) AV_RL48(p)
// #   endif

// #   if    defined(AV_WN48) && !defined(AV_WL48)
// #       define AV_WL48(p, v) AV_WN48(p, v)
// #   elif !defined(AV_WN48) &&  defined(AV_WL48)
// #       define AV_WN48(p, v) AV_WL48(p, v)
// #   endif

// #   if    defined(AV_RN64) && !defined(AV_RL64)
// #       define AV_RL64(p) AV_RN64(p)
// #   elif !defined(AV_RN64) &&  defined(AV_RL64)
// #       define AV_RN64(p) AV_RL64(p)
// #   endif

// #   if    defined(AV_WN64) && !defined(AV_WL64)
// #       define AV_WL64(p, v) AV_WN64(p, v)
// #   elif !defined(AV_WN64) &&  defined(AV_WL64)
// #       define AV_WN64(p, v) AV_WL64(p, v)
// Targeting ..\avutil\u005Cunaligned_64.java


// Targeting ..\avutil\u005Cunaligned_32.java


// Targeting ..\avutil\u005Cunaligned_16.java



// #   define AV_RN(s, p) (((const union unaligned_##s *) (p))->l)
// #   define AV_WN(s, p, v) ((((union unaligned_##s *) (p))->l) = (v))

// #elif defined(_MSC_VER) && (defined(_M_ARM) || defined(_M_X64) || defined(_M_ARM64)) && AV_HAVE_FAST_UNALIGNED

// #   define AV_RN(s, p) (*((const __unaligned uint##s##_t*)(p)))
// #   define AV_WN(s, p, v) (*((__unaligned uint##s##_t*)(p)) = (v))

// #elif AV_HAVE_FAST_UNALIGNED

// #   define AV_RN(s, p) (((const av_alias##s*)(p))->u##s)
// #   define AV_WN(s, p, v) (((av_alias##s*)(p))->u##s = (v))

// #else

// #ifndef AV_RB16
// #   define AV_RB16(x)
//     ((((const uint8_t*)(x))[0] << 8) |
//       ((const uint8_t*)(x))[1])
// #endif
// #ifndef AV_WB16
// #   define AV_WB16(p, val) do {
//         uint16_t d = (val);
//         ((uint8_t*)(p))[1] = (d);
//         ((uint8_t*)(p))[0] = (d)>>8;
//     } while(0)
// #endif

// #ifndef AV_RL16
// #   define AV_RL16(x)
//     ((((const uint8_t*)(x))[1] << 8) |
//       ((const uint8_t*)(x))[0])
// #endif
// #ifndef AV_WL16
// #   define AV_WL16(p, val) do {
//         uint16_t d = (val);
//         ((uint8_t*)(p))[0] = (d);
//         ((uint8_t*)(p))[1] = (d)>>8;
//     } while(0)
// #endif

// #ifndef AV_RB32
// #   define AV_RB32(x)
//     (((uint32_t)((const uint8_t*)(x))[0] << 24) |
//                (((const uint8_t*)(x))[1] << 16) |
//                (((const uint8_t*)(x))[2] <<  8) |
//                 ((const uint8_t*)(x))[3])
// #endif
// #ifndef AV_WB32
// #   define AV_WB32(p, val) do {
//         uint32_t d = (val);
//         ((uint8_t*)(p))[3] = (d);
//         ((uint8_t*)(p))[2] = (d)>>8;
//         ((uint8_t*)(p))[1] = (d)>>16;
//         ((uint8_t*)(p))[0] = (d)>>24;
//     } while(0)
// #endif

// #ifndef AV_RL32
// #   define AV_RL32(x)
//     (((uint32_t)((const uint8_t*)(x))[3] << 24) |
//                (((const uint8_t*)(x))[2] << 16) |
//                (((const uint8_t*)(x))[1] <<  8) |
//                 ((const uint8_t*)(x))[0])
// #endif
// #ifndef AV_WL32
// #   define AV_WL32(p, val) do {
//         uint32_t d = (val);
//         ((uint8_t*)(p))[0] = (d);
//         ((uint8_t*)(p))[1] = (d)>>8;
//         ((uint8_t*)(p))[2] = (d)>>16;
//         ((uint8_t*)(p))[3] = (d)>>24;
//     } while(0)
// #endif

// #ifndef AV_RB64
// #   define AV_RB64(x)
//     (((uint64_t)((const uint8_t*)(x))[0] << 56) |
//      ((uint64_t)((const uint8_t*)(x))[1] << 48) |
//      ((uint64_t)((const uint8_t*)(x))[2] << 40) |
//      ((uint64_t)((const uint8_t*)(x))[3] << 32) |
//      ((uint64_t)((const uint8_t*)(x))[4] << 24) |
//      ((uint64_t)((const uint8_t*)(x))[5] << 16) |
//      ((uint64_t)((const uint8_t*)(x))[6] <<  8) |
//       (uint64_t)((const uint8_t*)(x))[7])
// #endif
// #ifndef AV_WB64
// #   define AV_WB64(p, val) do {
//         uint64_t d = (val);
//         ((uint8_t*)(p))[7] = (d);
//         ((uint8_t*)(p))[6] = (d)>>8;
//         ((uint8_t*)(p))[5] = (d)>>16;
//         ((uint8_t*)(p))[4] = (d)>>24;
//         ((uint8_t*)(p))[3] = (d)>>32;
//         ((uint8_t*)(p))[2] = (d)>>40;
//         ((uint8_t*)(p))[1] = (d)>>48;
//         ((uint8_t*)(p))[0] = (d)>>56;
//     } while(0)
// #endif

// #ifndef AV_RL64
// #   define AV_RL64(x)
//     (((uint64_t)((const uint8_t*)(x))[7] << 56) |
//      ((uint64_t)((const uint8_t*)(x))[6] << 48) |
//      ((uint64_t)((const uint8_t*)(x))[5] << 40) |
//      ((uint64_t)((const uint8_t*)(x))[4] << 32) |
//      ((uint64_t)((const uint8_t*)(x))[3] << 24) |
//      ((uint64_t)((const uint8_t*)(x))[2] << 16) |
//      ((uint64_t)((const uint8_t*)(x))[1] <<  8) |
//       (uint64_t)((const uint8_t*)(x))[0])
// #endif
// #ifndef AV_WL64
// #   define AV_WL64(p, val) do {
//         uint64_t d = (val);
//         ((uint8_t*)(p))[0] = (d);
//         ((uint8_t*)(p))[1] = (d)>>8;
//         ((uint8_t*)(p))[2] = (d)>>16;
//         ((uint8_t*)(p))[3] = (d)>>24;
//         ((uint8_t*)(p))[4] = (d)>>32;
//         ((uint8_t*)(p))[5] = (d)>>40;
//         ((uint8_t*)(p))[6] = (d)>>48;
//         ((uint8_t*)(p))[7] = (d)>>56;
//     } while(0)
// #endif

// #if AV_HAVE_BIGENDIAN
// #   define AV_RN(s, p)    AV_RB##s(p)
// #   define AV_WN(s, p, v) AV_WB##s(p, v)
// #else
// #   define AV_RN(s, p)    AV_RL##s(p)
// #   define AV_WN(s, p, v) AV_WL##s(p, v)
// #endif

// #endif /* HAVE_FAST_UNALIGNED */

// #ifndef AV_RN16
// #   define AV_RN16(p) AV_RN(16, p)
// #endif

// #ifndef AV_RN32
// #   define AV_RN32(p) AV_RN(32, p)
// #endif

// #ifndef AV_RN64
// #   define AV_RN64(p) AV_RN(64, p)
// #endif

// #ifndef AV_WN16
// #   define AV_WN16(p, v) AV_WN(16, p, v)
// #endif

// #ifndef AV_WN32
// #   define AV_WN32(p, v) AV_WN(32, p, v)
// #endif

// #ifndef AV_WN64
// #   define AV_WN64(p, v) AV_WN(64, p, v)
// #endif

// #if AV_HAVE_BIGENDIAN
// #   define AV_RB(s, p)    AV_RN##s(p)
// #   define AV_WB(s, p, v) AV_WN##s(p, v)
// #   define AV_RL(s, p)    av_bswap##s(AV_RN##s(p))
// #   define AV_WL(s, p, v) AV_WN##s(p, av_bswap##s(v))
// #else
// #   define AV_RB(s, p)    av_bswap##s(AV_RN##s(p))
// #   define AV_WB(s, p, v) AV_WN##s(p, av_bswap##s(v))
// #   define AV_RL(s, p)    AV_RN##s(p)
// #   define AV_WL(s, p, v) AV_WN##s(p, v)
// #endif

// #define AV_RB8(x)     (((const uint8_t*)(x))[0])
// #define AV_WB8(p, d)  do { ((uint8_t*)(p))[0] = (d); } while(0)

// #define AV_RL8(x)     AV_RB8(x)
// #define AV_WL8(p, d)  AV_WB8(p, d)

// #ifndef AV_RB16
// #   define AV_RB16(p)    AV_RB(16, p)
// #endif
// #ifndef AV_WB16
// #   define AV_WB16(p, v) AV_WB(16, p, v)
// #endif

// #ifndef AV_RL16
// #   define AV_RL16(p)    AV_RL(16, p)
// #endif
// #ifndef AV_WL16
// #   define AV_WL16(p, v) AV_WL(16, p, v)
// #endif

// #ifndef AV_RB32
// #   define AV_RB32(p)    AV_RB(32, p)
// #endif
// #ifndef AV_WB32
// #   define AV_WB32(p, v) AV_WB(32, p, v)
// #endif

// #ifndef AV_RL32
// #   define AV_RL32(p)    AV_RL(32, p)
// #endif
// #ifndef AV_WL32
// #   define AV_WL32(p, v) AV_WL(32, p, v)
// #endif

// #ifndef AV_RB64
// #   define AV_RB64(p)    AV_RB(64, p)
// #endif
// #ifndef AV_WB64
// #   define AV_WB64(p, v) AV_WB(64, p, v)
// #endif

// #ifndef AV_RL64
// #   define AV_RL64(p)    AV_RL(64, p)
// #endif
// #ifndef AV_WL64
// #   define AV_WL64(p, v) AV_WL(64, p, v)
// #endif

// #ifndef AV_RB24
// #   define AV_RB24(x)
//     ((((const uint8_t*)(x))[0] << 16) |
//      (((const uint8_t*)(x))[1] <<  8) |
//       ((const uint8_t*)(x))[2])
// #endif
// #ifndef AV_WB24
// #   define AV_WB24(p, d) do {
//         ((uint8_t*)(p))[2] = (d);
//         ((uint8_t*)(p))[1] = (d)>>8;
//         ((uint8_t*)(p))[0] = (d)>>16;
//     } while(0)
// #endif

// #ifndef AV_RL24
// #   define AV_RL24(x)
//     ((((const uint8_t*)(x))[2] << 16) |
//      (((const uint8_t*)(x))[1] <<  8) |
//       ((const uint8_t*)(x))[0])
// #endif
// #ifndef AV_WL24
// #   define AV_WL24(p, d) do {
//         ((uint8_t*)(p))[0] = (d);
//         ((uint8_t*)(p))[1] = (d)>>8;
//         ((uint8_t*)(p))[2] = (d)>>16;
//     } while(0)
// #endif

// #ifndef AV_RB48
// #   define AV_RB48(x)
//     (((uint64_t)((const uint8_t*)(x))[0] << 40) |
//      ((uint64_t)((const uint8_t*)(x))[1] << 32) |
//      ((uint64_t)((const uint8_t*)(x))[2] << 24) |
//      ((uint64_t)((const uint8_t*)(x))[3] << 16) |
//      ((uint64_t)((const uint8_t*)(x))[4] <<  8) |
//       (uint64_t)((const uint8_t*)(x))[5])
// #endif
// #ifndef AV_WB48
// #   define AV_WB48(p, darg) do {
//         uint64_t d = (darg);
//         ((uint8_t*)(p))[5] = (d);
//         ((uint8_t*)(p))[4] = (d)>>8;
//         ((uint8_t*)(p))[3] = (d)>>16;
//         ((uint8_t*)(p))[2] = (d)>>24;
//         ((uint8_t*)(p))[1] = (d)>>32;
//         ((uint8_t*)(p))[0] = (d)>>40;
//     } while(0)
// #endif

// #ifndef AV_RL48
// #   define AV_RL48(x)
//     (((uint64_t)((const uint8_t*)(x))[5] << 40) |
//      ((uint64_t)((const uint8_t*)(x))[4] << 32) |
//      ((uint64_t)((const uint8_t*)(x))[3] << 24) |
//      ((uint64_t)((const uint8_t*)(x))[2] << 16) |
//      ((uint64_t)((const uint8_t*)(x))[1] <<  8) |
//       (uint64_t)((const uint8_t*)(x))[0])
// #endif
// #ifndef AV_WL48
// #   define AV_WL48(p, darg) do {
//         uint64_t d = (darg);
//         ((uint8_t*)(p))[0] = (d);
//         ((uint8_t*)(p))[1] = (d)>>8;
//         ((uint8_t*)(p))[2] = (d)>>16;
//         ((uint8_t*)(p))[3] = (d)>>24;
//         ((uint8_t*)(p))[4] = (d)>>32;
//         ((uint8_t*)(p))[5] = (d)>>40;
//     } while(0)
// #endif

/*
 * The AV_[RW]NA macros access naturally aligned data
 * in a type-safe way.
 */

// #define AV_RNA(s, p)    (((const av_alias##s*)(p))->u##s)
// #define AV_WNA(s, p, v) (((av_alias##s*)(p))->u##s = (v))

// #ifndef AV_RN16A
// #   define AV_RN16A(p) AV_RNA(16, p)
// #endif

// #ifndef AV_RN32A
// #   define AV_RN32A(p) AV_RNA(32, p)
// #endif

// #ifndef AV_RN64A
// #   define AV_RN64A(p) AV_RNA(64, p)
// #endif

// #ifndef AV_WN16A
// #   define AV_WN16A(p, v) AV_WNA(16, p, v)
// #endif

// #ifndef AV_WN32A
// #   define AV_WN32A(p, v) AV_WNA(32, p, v)
// #endif

// #ifndef AV_WN64A
// #   define AV_WN64A(p, v) AV_WNA(64, p, v)
// #endif

// #if AV_HAVE_BIGENDIAN
// #   define AV_RLA(s, p)    av_bswap##s(AV_RN##s##A(p))
// #   define AV_WLA(s, p, v) AV_WN##s##A(p, av_bswap##s(v))
// #else
// #   define AV_RLA(s, p)    AV_RN##s##A(p)
// #   define AV_WLA(s, p, v) AV_WN##s##A(p, v)
// #endif

// #ifndef AV_RL64A
// #   define AV_RL64A(p) AV_RLA(64, p)
// #endif
// #ifndef AV_WL64A
// #   define AV_WL64A(p, v) AV_WLA(64, p, v)
// #endif

/*
 * The AV_COPYxxU macros are suitable for copying data to/from unaligned
 * memory locations.
 */

// #define AV_COPYU(n, d, s) AV_WN##n(d, AV_RN##n(s));

// #ifndef AV_COPY16U
// #   define AV_COPY16U(d, s) AV_COPYU(16, d, s)
// #endif

// #ifndef AV_COPY32U
// #   define AV_COPY32U(d, s) AV_COPYU(32, d, s)
// #endif

// #ifndef AV_COPY64U
// #   define AV_COPY64U(d, s) AV_COPYU(64, d, s)
// #endif

// #ifndef AV_COPY128U
// #   define AV_COPY128U(d, s)
//     do {
//         AV_COPY64U(d, s);
//         AV_COPY64U((char *)(d) + 8, (const char *)(s) + 8);
//     } while(0)
// #endif

/* Parameters for AV_COPY*, AV_SWAP*, AV_ZERO* must be
 * naturally aligned. They may be implemented using MMX,
 * so emms_c() must be called before using any float code
 * afterwards.
 */

// #define AV_COPY(n, d, s)
//     (((av_alias##n*)(d))->u##n = ((const av_alias##n*)(s))->u##n)

// #ifndef AV_COPY16
// #   define AV_COPY16(d, s) AV_COPY(16, d, s)
// #endif

// #ifndef AV_COPY32
// #   define AV_COPY32(d, s) AV_COPY(32, d, s)
// #endif

// #ifndef AV_COPY64
// #   define AV_COPY64(d, s) AV_COPY(64, d, s)
// #endif

// #ifndef AV_COPY128
// #   define AV_COPY128(d, s)
//     do {
//         AV_COPY64(d, s);
//         AV_COPY64((char*)(d)+8, (char*)(s)+8);
//     } while(0)
// #endif

// #define AV_SWAP(n, a, b) FFSWAP(av_alias##n, *(av_alias##n*)(a), *(av_alias##n*)(b))

// #ifndef AV_SWAP64
// #   define AV_SWAP64(a, b) AV_SWAP(64, a, b)
// #endif

// #define AV_ZERO(n, d) (((av_alias##n*)(d))->u##n = 0)

// #ifndef AV_ZERO16
// #   define AV_ZERO16(d) AV_ZERO(16, d)
// #endif

// #ifndef AV_ZERO32
// #   define AV_ZERO32(d) AV_ZERO(32, d)
// #endif

// #ifndef AV_ZERO64
// #   define AV_ZERO64(d) AV_ZERO(64, d)
// #endif

// #ifndef AV_ZERO128
// #   define AV_ZERO128(d)
//     do {
//         AV_ZERO64(d);
//         AV_ZERO64((char*)(d)+8);
//     } while(0)
// #endif

// #endif /* AVUTIL_INTREADWRITE_H */


// Parsed from <libavutil/mastering_display_metadata.h>

/*
 * Copyright (c) 2016 Neil Birkbeck <neil.birkbeck@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_MASTERING_DISPLAY_METADATA_H
// #define AVUTIL_MASTERING_DISPLAY_METADATA_H

// #include "frame.h"
// #include "rational.h"
// Targeting ..\avutil\AVMasteringDisplayMetadata.java



/**
 * Allocate an AVMasteringDisplayMetadata structure and set its fields to
 * default values. The resulting struct can be freed using av_freep().
 *
 * @return An AVMasteringDisplayMetadata filled with default values or NULL
 *         on failure.
 */
@NoException public static native AVMasteringDisplayMetadata av_mastering_display_metadata_alloc();

/**
 * Allocate a complete AVMasteringDisplayMetadata and add it to the frame.
 *
 * @param frame The frame which side data is added to.
 *
 * @return The AVMasteringDisplayMetadata structure to be filled by caller.
 */
@NoException public static native AVMasteringDisplayMetadata av_mastering_display_metadata_create_side_data(AVFrame frame);
// Targeting ..\avutil\AVContentLightMetadata.java



/**
 * Allocate an AVContentLightMetadata structure and set its fields to
 * default values. The resulting struct can be freed using av_freep().
 *
 * @return An AVContentLightMetadata filled with default values or NULL
 *         on failure.
 */
@NoException public static native AVContentLightMetadata av_content_light_metadata_alloc(@Cast("size_t*") SizeTPointer size);

/**
 * Allocate a complete AVContentLightMetadata and add it to the frame.
 *
 * @param frame The frame which side data is added to.
 *
 * @return The AVContentLightMetadata structure to be filled by caller.
 */
@NoException public static native AVContentLightMetadata av_content_light_metadata_create_side_data(AVFrame frame);

// #endif /* AVUTIL_MASTERING_DISPLAY_METADATA_H */


// Parsed from <libavutil/murmur3.h>

/*
 * Copyright (C) 2013 Reimar Döffinger <Reimar.Doeffinger@gmx.de>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * \ingroup lavu_murmur3
 * Public header for MurmurHash3 hash function implementation.
 */

// #ifndef AVUTIL_MURMUR3_H
// #define AVUTIL_MURMUR3_H

// #include <stdint.h>

// #include "version.h"

/**
 * \defgroup lavu_murmur3 Murmur3
 * \ingroup lavu_hash
 * MurmurHash3 hash function implementation.
 *
 * MurmurHash3 is a non-cryptographic hash function, of which three
 * incompatible versions were created by its inventor Austin Appleby:
 *
 * - 32-bit output
 * - 128-bit output for 32-bit platforms
 * - 128-bit output for 64-bit platforms
 *
 * FFmpeg only implements the last variant: 128-bit output designed for 64-bit
 * platforms. Even though the hash function was designed for 64-bit platforms,
 * the function in reality works on 32-bit systems too, only with reduced
 * performance.
 *
 * \anchor lavu_murmur3_seedinfo
 * By design, MurmurHash3 requires a seed to operate. In response to this,
 * libavutil provides two functions for hash initiation, one that requires a
 * seed (av_murmur3_init_seeded()) and one that uses a fixed arbitrary integer
 * as the seed, and therefore does not (av_murmur3_init()).
 *
 * To make hashes comparable, you should provide the same seed for all calls to
 * this hash function -- if you are supplying one yourself, that is.
 *
 * \{
 */

/**
 * Allocate an AVMurMur3 hash context.
 *
 * @return Uninitialized hash context or {@code NULL} in case of error
 */
@NoException public static native @Cast("AVMurMur3*") Pointer av_murmur3_alloc();

/**
 * Initialize or reinitialize an AVMurMur3 hash context with a seed.
 *
 * @param c [out]    Hash context
 * @param seed [in] Random seed
 *
 * @see av_murmur3_init()
 * @see \ref lavu_murmur3_seedinfo "Detailed description" on a discussion of
 * seeds for MurmurHash3.
 */
@NoException public static native void av_murmur3_init_seeded(@Cast("AVMurMur3*") Pointer c, @Cast("uint64_t") long seed);

/**
 * Initialize or reinitialize an AVMurMur3 hash context.
 *
 * Equivalent to av_murmur3_init_seeded() with a built-in seed.
 *
 * @param c [out]    Hash context
 *
 * @see av_murmur3_init_seeded()
 * @see \ref lavu_murmur3_seedinfo "Detailed description" on a discussion of
 * seeds for MurmurHash3.
 */
@NoException public static native void av_murmur3_init(@Cast("AVMurMur3*") Pointer c);

/**
 * Update hash context with new data.
 *
 * @param c [out]    Hash context
 * @param src [in]  Input data to update hash with
 * @param len [in]  Number of bytes to read from {@code src}
 */
// #if FF_API_CRYPTO_SIZE_T
@NoException public static native void av_murmur3_update(@Cast("AVMurMur3*") Pointer c, @Cast("const uint8_t*") BytePointer src, int len);
@NoException public static native void av_murmur3_update(@Cast("AVMurMur3*") Pointer c, @Cast("const uint8_t*") ByteBuffer src, int len);
@NoException public static native void av_murmur3_update(@Cast("AVMurMur3*") Pointer c, @Cast("const uint8_t*") byte[] src, int len);
// #else
@NoException public static native void av_murmur3_update(@Cast("AVMurMur3*") Pointer c, @Cast("const uint8_t*") BytePointer src, @Cast("size_t") long len);
@NoException public static native void av_murmur3_update(@Cast("AVMurMur3*") Pointer c, @Cast("const uint8_t*") ByteBuffer src, @Cast("size_t") long len);
@NoException public static native void av_murmur3_update(@Cast("AVMurMur3*") Pointer c, @Cast("const uint8_t*") byte[] src, @Cast("size_t") long len);
// #endif

/**
 * Finish hashing and output digest value.
 *
 * @param c [in,out]    Hash context
 * @param dst [out]  Buffer where output digest value is stored
 */
@NoException public static native void av_murmur3_final(@Cast("AVMurMur3*") Pointer c, @Cast("uint8_t*") BytePointer dst);
@NoException public static native void av_murmur3_final(@Cast("AVMurMur3*") Pointer c, @Cast("uint8_t*") ByteBuffer dst);
@NoException public static native void av_murmur3_final(@Cast("AVMurMur3*") Pointer c, @Cast("uint8_t*") byte[] dst);

/**
 * \}
 */

// #endif /* AVUTIL_MURMUR3_H */


// Parsed from <libavutil/parseutils.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_PARSEUTILS_H
// #define AVUTIL_PARSEUTILS_H

// #include <time.h>

// #include "rational.h"

/**
 * \file
 * misc parsing utilities
 */

/**
 * Parse str and store the parsed ratio in q.
 *
 * Note that a ratio with infinite (1/0) or negative value is
 * considered valid, so you should check on the returned value if you
 * want to exclude those values.
 *
 * The undefined value can be expressed using the "0:0" string.
 *
 * @param q [in,out] pointer to the AVRational which will contain the ratio
 * @param str [in] the string to parse: it has to be a string in the format
 * num:den, a float number or an expression
 * @param max [in] the maximum allowed numerator and denominator
 * @param log_offset [in] log level offset which is applied to the log
 * level of log_ctx
 * @param log_ctx [in] parent logging context
 * @return >= 0 on success, a negative error code otherwise
 */
@NoException public static native int av_parse_ratio(AVRational q, @Cast("const char*") BytePointer str, int max,
                   int log_offset, Pointer log_ctx);
@NoException public static native int av_parse_ratio(AVRational q, String str, int max,
                   int log_offset, Pointer log_ctx);

// #define av_parse_ratio_quiet(rate, str, max)
//     av_parse_ratio(rate, str, max, AV_LOG_MAX_OFFSET, NULL)

/**
 * Parse str and put in width_ptr and height_ptr the detected values.
 *
 * @param width_ptr [in,out] pointer to the variable which will contain the detected
 * width value
 * @param height_ptr [in,out] pointer to the variable which will contain the detected
 * height value
 * @param str [in] the string to parse: it has to be a string in the format
 * width x height or a valid video size abbreviation.
 * @return >= 0 on success, a negative error code otherwise
 */
@NoException public static native int av_parse_video_size(IntPointer width_ptr, IntPointer height_ptr, @Cast("const char*") BytePointer str);
@NoException public static native int av_parse_video_size(IntBuffer width_ptr, IntBuffer height_ptr, String str);
@NoException public static native int av_parse_video_size(int[] width_ptr, int[] height_ptr, @Cast("const char*") BytePointer str);
@NoException public static native int av_parse_video_size(IntPointer width_ptr, IntPointer height_ptr, String str);
@NoException public static native int av_parse_video_size(IntBuffer width_ptr, IntBuffer height_ptr, @Cast("const char*") BytePointer str);
@NoException public static native int av_parse_video_size(int[] width_ptr, int[] height_ptr, String str);

/**
 * Parse str and store the detected values in *rate.
 *
 * @param rate [in,out] pointer to the AVRational which will contain the detected
 * frame rate
 * @param str [in] the string to parse: it has to be a string in the format
 * rate_num / rate_den, a float number or a valid video rate abbreviation
 * @return >= 0 on success, a negative error code otherwise
 */
@NoException public static native int av_parse_video_rate(AVRational rate, @Cast("const char*") BytePointer str);
@NoException public static native int av_parse_video_rate(AVRational rate, String str);

/**
 * Put the RGBA values that correspond to color_string in rgba_color.
 *
 * @param color_string a string specifying a color. It can be the name of
 * a color (case insensitive match) or a [0x|#]RRGGBB[AA] sequence,
 * possibly followed by "\" and a string representing the alpha
 * component.
 * The alpha component may be a string composed by "0x" followed by an
 * hexadecimal number or a decimal number between 0.0 and 1.0, which
 * represents the opacity value (0x00/0.0 means completely transparent,
 * 0xff/1.0 completely opaque).
 * If the alpha component is not specified then 0xff is assumed.
 * The string "random" will result in a random color.
 * @param slen length of the initial part of color_string containing the
 * color. It can be set to -1 if color_string is a null terminated string
 * containing nothing else than the color.
 * @return >= 0 in case of success, a negative value in case of
 * failure (for example if color_string cannot be parsed).
 */
@NoException public static native int av_parse_color(@Cast("uint8_t*") BytePointer rgba_color, @Cast("const char*") BytePointer color_string, int slen,
                   Pointer log_ctx);
@NoException public static native int av_parse_color(@Cast("uint8_t*") ByteBuffer rgba_color, String color_string, int slen,
                   Pointer log_ctx);
@NoException public static native int av_parse_color(@Cast("uint8_t*") byte[] rgba_color, @Cast("const char*") BytePointer color_string, int slen,
                   Pointer log_ctx);
@NoException public static native int av_parse_color(@Cast("uint8_t*") BytePointer rgba_color, String color_string, int slen,
                   Pointer log_ctx);
@NoException public static native int av_parse_color(@Cast("uint8_t*") ByteBuffer rgba_color, @Cast("const char*") BytePointer color_string, int slen,
                   Pointer log_ctx);
@NoException public static native int av_parse_color(@Cast("uint8_t*") byte[] rgba_color, String color_string, int slen,
                   Pointer log_ctx);

/**
 * Get the name of a color from the internal table of hard-coded named
 * colors.
 *
 * This function is meant to enumerate the color names recognized by
 * av_parse_color().
 *
 * @param color_idx index of the requested color, starting from 0
 * @param rgbp      if not NULL, will point to a 3-elements array with the color value in RGB
 * @return the color name string or NULL if color_idx is not in the array
 */
@NoException public static native @Cast("const char*") BytePointer av_get_known_color_name(int color_idx, @Cast("const uint8_t**") PointerPointer rgb);
@NoException public static native @Cast("const char*") BytePointer av_get_known_color_name(int color_idx, @Cast("const uint8_t**") @ByPtrPtr BytePointer rgb);
@NoException public static native String av_get_known_color_name(int color_idx, @Cast("const uint8_t**") @ByPtrPtr ByteBuffer rgb);
@NoException public static native @Cast("const char*") BytePointer av_get_known_color_name(int color_idx, @Cast("const uint8_t**") @ByPtrPtr byte[] rgb);

/**
 * Parse timestr and return in *time a corresponding number of
 * microseconds.
 *
 * @param timeval puts here the number of microseconds corresponding
 * to the string in timestr. If the string represents a duration, it
 * is the number of microseconds contained in the time interval.  If
 * the string is a date, is the number of microseconds since 1st of
 * January, 1970 up to the time of the parsed date.  If timestr cannot
 * be successfully parsed, set *time to INT64_MIN.
 <p>
 * @param timestr a string representing a date or a duration.
 * - If a date the syntax is:
 * <pre>{@code
 * [{YYYY-MM-DD|YYYYMMDD}[T|t| ]]{{HH:MM:SS[.m...]]]}|{HHMMSS[.m...]]]}}[Z]
 * now
 * }</pre>
 * If the value is "now" it takes the current time.
 * Time is local time unless Z is appended, in which case it is
 * interpreted as UTC.
 * If the year-month-day part is not specified it takes the current
 * year-month-day.
 * - If a duration the syntax is:
 * <pre>{@code
 * [-][HH:]MM:SS[.m...]
 * [-]S+[.m...]
 * }</pre>
 * @param duration flag which tells how to interpret timestr, if not
 * zero timestr is interpreted as a duration, otherwise as a date
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code otherwise
 */
@NoException public static native int av_parse_time(@Cast("int64_t*") LongPointer timeval, @Cast("const char*") BytePointer timestr, int duration);
@NoException public static native int av_parse_time(@Cast("int64_t*") LongBuffer timeval, String timestr, int duration);
@NoException public static native int av_parse_time(@Cast("int64_t*") long[] timeval, @Cast("const char*") BytePointer timestr, int duration);
@NoException public static native int av_parse_time(@Cast("int64_t*") LongPointer timeval, String timestr, int duration);
@NoException public static native int av_parse_time(@Cast("int64_t*") LongBuffer timeval, @Cast("const char*") BytePointer timestr, int duration);
@NoException public static native int av_parse_time(@Cast("int64_t*") long[] timeval, String timestr, int duration);

/**
 * Attempt to find a specific tag in a URL.
 *
 * syntax: '?tag1=val1&tag2=val2...'. Little URL decoding is done.
 * Return 1 if found.
 */
@NoException public static native int av_find_info_tag(@Cast("char*") BytePointer arg, int arg_size, @Cast("const char*") BytePointer tag1, @Cast("const char*") BytePointer info);
@NoException public static native int av_find_info_tag(@Cast("char*") ByteBuffer arg, int arg_size, String tag1, String info);
@NoException public static native int av_find_info_tag(@Cast("char*") byte[] arg, int arg_size, @Cast("const char*") BytePointer tag1, @Cast("const char*") BytePointer info);
@NoException public static native int av_find_info_tag(@Cast("char*") BytePointer arg, int arg_size, String tag1, String info);
@NoException public static native int av_find_info_tag(@Cast("char*") ByteBuffer arg, int arg_size, @Cast("const char*") BytePointer tag1, @Cast("const char*") BytePointer info);
@NoException public static native int av_find_info_tag(@Cast("char*") byte[] arg, int arg_size, String tag1, String info);

/**
 * Simplified version of strptime
 *
 * Parse the input string p according to the format string fmt and
 * store its results in the structure dt.
 * This implementation supports only a subset of the formats supported
 * by the standard strptime().
 *
 * The supported input field descriptors are listed below.
 * - %H: the hour as a decimal number, using a 24-hour clock, in the
 *   range '00' through '23'
 * - %J: hours as a decimal number, in the range '0' through INT_MAX
 * - %M: the minute as a decimal number, using a 24-hour clock, in the
 *   range '00' through '59'
 * - %S: the second as a decimal number, using a 24-hour clock, in the
 *   range '00' through '59'
 * - %Y: the year as a decimal number, using the Gregorian calendar
 * - %m: the month as a decimal number, in the range '1' through '12'
 * - %d: the day of the month as a decimal number, in the range '1'
 *   through '31'
 * - %T: alias for '%H:%M:%S'
 * - %%: a literal '%'
 *
 * @return a pointer to the first character not processed in this function
 *         call. In case the input string contains more characters than
 *         required by the format string the return value points right after
 *         the last consumed input character. In case the whole input string
 *         is consumed the return value points to the null byte at the end of
 *         the string. On failure NULL is returned.
 */
@NoException public static native @Cast("char*") BytePointer av_small_strptime(@Cast("const char*") BytePointer p, @Cast("const char*") BytePointer fmt, tm dt);
@NoException public static native @Cast("char*") ByteBuffer av_small_strptime(String p, String fmt, tm dt);

/**
 * Convert the decomposed UTC time in tm to a time_t value.
 */
@NoException public static native @ByVal @Cast("time_t*") Pointer av_timegm(tm tm);

// #endif /* AVUTIL_PARSEUTILS_H */


// Parsed from <libavutil/pixelutils.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_PIXELUTILS_H
// #define AVUTIL_PIXELUTILS_H

// #include <stddef.h>
// #include <stdint.h>
// #include "common.h"
// Targeting ..\avutil\av_pixelutils_sad_fn.java



/**
 * Get a potentially optimized pointer to a Sum-of-absolute-differences
 * function (see the av_pixelutils_sad_fn prototype).
 *
 * @param w_bits  1<<w_bits is the requested width of the block size
 * @param h_bits  1<<h_bits is the requested height of the block size
 * @param aligned If set to 2, the returned sad function will assume src1 and
 *                src2 addresses are aligned on the block size.
 *                If set to 1, the returned sad function will assume src1 is
 *                aligned on the block size.
 *                If set to 0, the returned sad function assume no particular
 *                alignment.
 * @param log_ctx context used for logging, can be NULL
 *
 * @return a pointer to the SAD function or NULL in case of error (because of
 *         invalid parameters)
 */
@NoException public static native av_pixelutils_sad_fn av_pixelutils_get_sad_fn(int w_bits, int h_bits,
                                              int aligned, Pointer log_ctx);

// #endif /* AVUTIL_PIXELUTILS_H */


// Parsed from <libavutil/random_seed.h>

/*
 * Copyright (c) 2009 Baptiste Coudurier <baptiste.coudurier@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_RANDOM_SEED_H
// #define AVUTIL_RANDOM_SEED_H

// #include <stdint.h>
/**
 * \addtogroup lavu_crypto
 * \{
 */

/**
 * Get a seed to use in conjunction with random functions.
 * This function tries to provide a good seed at a best effort bases.
 * Its possible to call this function multiple times if more bits are needed.
 * It can be quite slow, which is why it should only be used as seed for a faster
 * PRNG. The quality of the seed depends on the platform.
 */
@NoException public static native @Cast("uint32_t") int av_get_random_seed();

/**
 * \}
 */

// #endif /* AVUTIL_RANDOM_SEED_H */


// Parsed from <libavutil/replaygain.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_REPLAYGAIN_H
// #define AVUTIL_REPLAYGAIN_H

// #include <stdint.h>
// Targeting ..\avutil\AVReplayGain.java



// #endif /* AVUTIL_REPLAYGAIN_H */


// Parsed from <libavutil/spherical.h>

/*
 * Copyright (c) 2016 Vittorio Giovara <vittorio.giovara@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * Spherical video
 */

// #ifndef AVUTIL_SPHERICAL_H
// #define AVUTIL_SPHERICAL_H

// #include <stddef.h>
// #include <stdint.h>

/**
 * \addtogroup lavu_video
 * \{
 *
 * \defgroup lavu_video_spherical Spherical video mapping
 * \{
 */

/**
 * \addtogroup lavu_video_spherical
 * A spherical video file contains surfaces that need to be mapped onto a
 * sphere. Depending on how the frame was converted, a different distortion
 * transformation or surface recomposition function needs to be applied before
 * the video should be mapped and displayed.
 */

/**
 * Projection of the video surface(s) on a sphere.
 */
/** enum AVSphericalProjection */
public static final int
    /**
     * Video represents a sphere mapped on a flat surface using
     * equirectangular projection.
     */
    AV_SPHERICAL_EQUIRECTANGULAR = 0,

    /**
     * Video frame is split into 6 faces of a cube, and arranged on a
     * 3x2 layout. Faces are oriented upwards for the front, left, right,
     * and back faces. The up face is oriented so the top of the face is
     * forwards and the down face is oriented so the top of the face is
     * to the back.
     */
    AV_SPHERICAL_CUBEMAP = 1,

    /**
     * Video represents a portion of a sphere mapped on a flat surface
     * using equirectangular projection. The \ref bounding fields indicate
     * the position of the current video in a larger surface.
     */
    AV_SPHERICAL_EQUIRECTANGULAR_TILE = 2;
// Targeting ..\avutil\AVSphericalMapping.java



/**
 * Allocate a AVSphericalVideo structure and initialize its fields to default
 * values.
 *
 * @return the newly allocated struct or NULL on failure
 */
@NoException public static native AVSphericalMapping av_spherical_alloc(@Cast("size_t*") SizeTPointer size);

/**
 * Convert the \ref bounding fields from an AVSphericalVideo
 * from 0.32 fixed point to pixels.
 *
 * @param map    The AVSphericalVideo map to read bound values from.
 * @param width  Width of the current frame or stream.
 * @param height Height of the current frame or stream.
 * @param left   Pixels from the left edge.
 * @param top    Pixels from the top edge.
 * @param right  Pixels from the right edge.
 * @param bottom Pixels from the bottom edge.
 */
@NoException public static native void av_spherical_tile_bounds(@Const AVSphericalMapping map,
                              @Cast("size_t") long width, @Cast("size_t") long height,
                              @Cast("size_t*") SizeTPointer left, @Cast("size_t*") SizeTPointer top,
                              @Cast("size_t*") SizeTPointer right, @Cast("size_t*") SizeTPointer bottom);

/**
 * Provide a human-readable name of a given AVSphericalProjection.
 *
 * @param projection The input AVSphericalProjection.
 *
 * @return The name of the AVSphericalProjection, or "unknown".
 */
@NoException public static native @Cast("const char*") BytePointer av_spherical_projection_name(@Cast("AVSphericalProjection") int projection);

/**
 * Get the AVSphericalProjection form a human-readable name.
 *
 * @param name The input string.
 *
 * @return The AVSphericalProjection value, or -1 if not found.
 */
@NoException public static native int av_spherical_from_name(@Cast("const char*") BytePointer name);
@NoException public static native int av_spherical_from_name(String name);
/**
 * \}
 * \}
 */

// #endif /* AVUTIL_SPHERICAL_H */


// Parsed from <libavutil/threadmessage.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with FFmpeg; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_THREADMESSAGE_H
// #define AVUTIL_THREADMESSAGE_H
// Targeting ..\avutil\AVThreadMessageQueue.java



/** enum AVThreadMessageFlags */
public static final int

    /**
     * Perform non-blocking operation.
     * If this flag is set, send and recv operations are non-blocking and
     * return AVERROR(EAGAIN) immediately if they can not proceed.
     */
    AV_THREAD_MESSAGE_NONBLOCK = 1;

/**
 * Allocate a new message queue.
 *
 * @param mq      pointer to the message queue
 * @param nelem   maximum number of elements in the queue
 * @param elsize  size of each element in the queue
 * @return  >=0 for success; <0 for error, in particular AVERROR(ENOSYS) if
 *          lavu was built without thread support
 */
@NoException public static native int av_thread_message_queue_alloc(@Cast("AVThreadMessageQueue**") PointerPointer mq,
                                  @Cast("unsigned") int nelem,
                                  @Cast("unsigned") int elsize);
@NoException public static native int av_thread_message_queue_alloc(@ByPtrPtr AVThreadMessageQueue mq,
                                  @Cast("unsigned") int nelem,
                                  @Cast("unsigned") int elsize);

/**
 * Free a message queue.
 *
 * The message queue must no longer be in use by another thread.
 */
@NoException public static native void av_thread_message_queue_free(@Cast("AVThreadMessageQueue**") PointerPointer mq);
@NoException public static native void av_thread_message_queue_free(@ByPtrPtr AVThreadMessageQueue mq);

/**
 * Send a message on the queue.
 */
@NoException public static native int av_thread_message_queue_send(AVThreadMessageQueue mq,
                                 Pointer msg,
                                 @Cast("unsigned") int flags);

/**
 * Receive a message from the queue.
 */
@NoException public static native int av_thread_message_queue_recv(AVThreadMessageQueue mq,
                                 Pointer msg,
                                 @Cast("unsigned") int flags);

/**
 * Set the sending error code.
 *
 * If the error code is set to non-zero, av_thread_message_queue_send() will
 * return it immediately. Conventional values, such as AVERROR_EOF or
 * AVERROR(EAGAIN), can be used to cause the sending thread to stop or
 * suspend its operation.
 */
@NoException public static native void av_thread_message_queue_set_err_send(AVThreadMessageQueue mq,
                                          int err);

/**
 * Set the receiving error code.
 *
 * If the error code is set to non-zero, av_thread_message_queue_recv() will
 * return it immediately when there are no longer available messages.
 * Conventional values, such as AVERROR_EOF or AVERROR(EAGAIN), can be used
 * to cause the receiving thread to stop or suspend its operation.
 */
@NoException public static native void av_thread_message_queue_set_err_recv(AVThreadMessageQueue mq,
                                          int err);
// Targeting ..\avutil\Free_func_Pointer.java


@NoException public static native void av_thread_message_queue_set_free_func(AVThreadMessageQueue mq,
                                           Free_func_Pointer free_func);

/**
 * Return the current number of messages in the queue.
 *
 * @return the current number of messages or AVERROR(ENOSYS) if lavu was built
 *         without thread support
 */
@NoException public static native int av_thread_message_queue_nb_elems(AVThreadMessageQueue mq);

/**
 * Flush the message queue
 *
 * This function is mostly equivalent to reading and free-ing every message
 * except that it will be done in a single operation (no lock/unlock between
 * reads).
 */
@NoException public static native void av_thread_message_flush(AVThreadMessageQueue mq);

// #endif /* AVUTIL_THREADMESSAGE_H */


// Parsed from <libavutil/timecode.h>

/*
 * Copyright (c) 2006 Smartjog S.A.S, Baptiste Coudurier <baptiste.coudurier@gmail.com>
 * Copyright (c) 2011-2012 Smartjog S.A.S, Clément Bœsch <clement.boesch@smartjog.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * Timecode helpers header
 */

// #ifndef AVUTIL_TIMECODE_H
// #define AVUTIL_TIMECODE_H

// #include <stdint.h>
// #include "rational.h"

public static final int AV_TIMECODE_STR_SIZE = 23;

/** enum AVTimecodeFlag */
public static final int
    /** timecode is drop frame */
    AV_TIMECODE_FLAG_DROPFRAME      = 1<<0,
    /** timecode wraps after 24 hours */
    AV_TIMECODE_FLAG_24HOURSMAX     = 1<<1,
    /** negative time values are allowed */
    AV_TIMECODE_FLAG_ALLOWNEGATIVE  = 1<<2;
// Targeting ..\avutil\AVTimecode.java



/**
 * Adjust frame number for NTSC drop frame time code.
 *
 * @param framenum frame number to adjust
 * @param fps      frame per second, 30 or 60
 * @return         adjusted frame number
 * \warning        adjustment is only valid in NTSC 29.97 and 59.94
 */
@NoException public static native int av_timecode_adjust_ntsc_framenum2(int framenum, int fps);

/**
 * Convert frame number to SMPTE 12M binary representation.
 *
 * @param tc       timecode data correctly initialized
 * @param framenum frame number
 * @return         the SMPTE binary representation
 *
 * \note Frame number adjustment is automatically done in case of drop timecode,
 *       you do NOT have to call av_timecode_adjust_ntsc_framenum2().
 * \note The frame number is relative to tc->start.
 * \note Color frame (CF), binary group flags (BGF) and biphase mark polarity
 *       correction (PC) bits are set to zero.
 */
@NoException public static native @Cast("uint32_t") int av_timecode_get_smpte_from_framenum(@Const AVTimecode tc, int framenum);

/**
 * Load timecode string in buf.
 *
 * @param buf      destination buffer, must be at least AV_TIMECODE_STR_SIZE long
 * @param tc       timecode data correctly initialized
 * @param framenum frame number
 * @return         the buf parameter
 *
 * \note Timecode representation can be a negative timecode and have more than
 *       24 hours, but will only be honored if the flags are correctly set.
 * \note The frame number is relative to tc->start.
 */
@NoException public static native @Cast("char*") BytePointer av_timecode_make_string(@Const AVTimecode tc, @Cast("char*") BytePointer buf, int framenum);
@NoException public static native @Cast("char*") ByteBuffer av_timecode_make_string(@Const AVTimecode tc, @Cast("char*") ByteBuffer buf, int framenum);
@NoException public static native @Cast("char*") byte[] av_timecode_make_string(@Const AVTimecode tc, @Cast("char*") byte[] buf, int framenum);

/**
 * Get the timecode string from the SMPTE timecode format.
 *
 * @param buf        destination buffer, must be at least AV_TIMECODE_STR_SIZE long
 * @param tcsmpte    the 32-bit SMPTE timecode
 * @param prevent_df prevent the use of a drop flag when it is known the DF bit
 *                   is arbitrary
 * @return           the buf parameter
 */
@NoException public static native @Cast("char*") BytePointer av_timecode_make_smpte_tc_string(@Cast("char*") BytePointer buf, @Cast("uint32_t") int tcsmpte, int prevent_df);
@NoException public static native @Cast("char*") ByteBuffer av_timecode_make_smpte_tc_string(@Cast("char*") ByteBuffer buf, @Cast("uint32_t") int tcsmpte, int prevent_df);
@NoException public static native @Cast("char*") byte[] av_timecode_make_smpte_tc_string(@Cast("char*") byte[] buf, @Cast("uint32_t") int tcsmpte, int prevent_df);

/**
 * Get the timecode string from the 25-bit timecode format (MPEG GOP format).
 *
 * @param buf     destination buffer, must be at least AV_TIMECODE_STR_SIZE long
 * @param tc25bit the 25-bits timecode
 * @return        the buf parameter
 */
@NoException public static native @Cast("char*") BytePointer av_timecode_make_mpeg_tc_string(@Cast("char*") BytePointer buf, @Cast("uint32_t") int tc25bit);
@NoException public static native @Cast("char*") ByteBuffer av_timecode_make_mpeg_tc_string(@Cast("char*") ByteBuffer buf, @Cast("uint32_t") int tc25bit);
@NoException public static native @Cast("char*") byte[] av_timecode_make_mpeg_tc_string(@Cast("char*") byte[] buf, @Cast("uint32_t") int tc25bit);

/**
 * Init a timecode struct with the passed parameters.
 *
 * @param log_ctx     a pointer to an arbitrary struct of which the first field
 *                    is a pointer to an AVClass struct (used for av_log)
 * @param tc          pointer to an allocated AVTimecode
 * @param rate        frame rate in rational form
 * @param flags       miscellaneous flags such as drop frame, +24 hours, ...
 *                    (see AVTimecodeFlag)
 * @param frame_start the first frame number
 * @return            0 on success, AVERROR otherwise
 */
@NoException public static native int av_timecode_init(AVTimecode tc, @ByVal AVRational rate, int flags, int frame_start, Pointer log_ctx);

/**
 * Parse timecode representation (hh:mm:ss[:;.]ff).
 *
 * @param log_ctx a pointer to an arbitrary struct of which the first field is a
 *                pointer to an AVClass struct (used for av_log).
 * @param tc      pointer to an allocated AVTimecode
 * @param rate    frame rate in rational form
 * @param str     timecode string which will determine the frame start
 * @return        0 on success, AVERROR otherwise
 */
@NoException public static native int av_timecode_init_from_string(AVTimecode tc, @ByVal AVRational rate, @Cast("const char*") BytePointer str, Pointer log_ctx);
@NoException public static native int av_timecode_init_from_string(AVTimecode tc, @ByVal AVRational rate, String str, Pointer log_ctx);

/**
 * Check if the timecode feature is available for the given frame rate
 *
 * @return 0 if supported, <0 otherwise
 */
@NoException public static native int av_timecode_check_frame_rate(@ByVal AVRational rate);

// #endif /* AVUTIL_TIMECODE_H */


// Parsed from <libavutil/timestamp.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * timestamp utils, mostly useful for debugging/logging purposes
 */

// #ifndef AVUTIL_TIMESTAMP_H
// #define AVUTIL_TIMESTAMP_H

// #include "common.h"

// #if defined(__cplusplus) && !defined(__STDC_FORMAT_MACROS) && !defined(PRId64)
// #error missing -D__STDC_FORMAT_MACROS / #define __STDC_FORMAT_MACROS
// #endif

public static final int AV_TS_MAX_STRING_SIZE = 32;

/**
 * Fill the provided buffer with a string containing a timestamp
 * representation.
 *
 * @param buf a buffer with size in bytes of at least AV_TS_MAX_STRING_SIZE
 * @param ts the timestamp to represent
 * @return the buffer in input
 */
@NoException public static native @Cast("char*") BytePointer av_ts_make_string(@Cast("char*") BytePointer buf, @Cast("int64_t") long ts);
@NoException public static native @Cast("char*") ByteBuffer av_ts_make_string(@Cast("char*") ByteBuffer buf, @Cast("int64_t") long ts);
@NoException public static native @Cast("char*") byte[] av_ts_make_string(@Cast("char*") byte[] buf, @Cast("int64_t") long ts);

/**
 * Convenience macro, the return value should be used only directly in
 * function arguments but never stand-alone.
 */
// #define av_ts2str(ts) av_ts_make_string((char[AV_TS_MAX_STRING_SIZE]){0}, ts)

/**
 * Fill the provided buffer with a string containing a timestamp time
 * representation.
 *
 * @param buf a buffer with size in bytes of at least AV_TS_MAX_STRING_SIZE
 * @param ts the timestamp to represent
 * @param tb the timebase of the timestamp
 * @return the buffer in input
 */
@NoException public static native @Cast("char*") BytePointer av_ts_make_time_string(@Cast("char*") BytePointer buf, @Cast("int64_t") long ts, AVRational tb);
@NoException public static native @Cast("char*") ByteBuffer av_ts_make_time_string(@Cast("char*") ByteBuffer buf, @Cast("int64_t") long ts, AVRational tb);
@NoException public static native @Cast("char*") byte[] av_ts_make_time_string(@Cast("char*") byte[] buf, @Cast("int64_t") long ts, AVRational tb);

/**
 * Convenience macro, the return value should be used only directly in
 * function arguments but never stand-alone.
 */
// #define av_ts2timestr(ts, tb) av_ts_make_time_string((char[AV_TS_MAX_STRING_SIZE]){0}, ts, tb)

// #endif /* AVUTIL_TIMESTAMP_H */


// Parsed from <libavutil/tree.h>

/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * \file
 * A tree container.
 * @author Michael Niedermayer <michaelni\gmx.at>
 */

// #ifndef AVUTIL_TREE_H
// #define AVUTIL_TREE_H

// #include "attributes.h"
// #include "version.h"
// Targeting ..\avutil\AVTreeNode.java


@MemberGetter public static native int av_tree_node_size();

/**
 * Allocate an AVTreeNode.
 */
@NoException public static native AVTreeNode av_tree_node_alloc();
// Targeting ..\avutil\Cmp_Const_Pointer_Const_Pointer.java


@NoException public static native Pointer av_tree_find(@Const AVTreeNode root, Pointer key,
                   @Cast("int (*)(const void*, const void*)") Cmp_Const_Pointer_Const_Pointer cmp, @Cast("void**") PointerPointer next);
@NoException public static native Pointer av_tree_find(@Const AVTreeNode root, Pointer key,
                   @Cast("int (*)(const void*, const void*)") Cmp_Const_Pointer_Const_Pointer cmp, @Cast("void**") @ByPtrPtr Pointer next);

/**
 * Insert or remove an element.
 *
 * If *next is NULL, then the supplied element will be removed if it exists.
 * If *next is non-NULL, then the supplied element will be inserted, unless
 * it already exists in the tree.
 *
 * @param rootp A pointer to a pointer to the root node of the tree; note that
 *              the root node can change during insertions, this is required
 *              to keep the tree balanced.
 * @param key  pointer to the element key to insert in the tree
 * @param next Used to allocate and free AVTreeNodes. For insertion the user
 *             must set it to an allocated and zeroed object of at least
 *             av_tree_node_size bytes size. av_tree_insert() will set it to
 *             NULL if it has been consumed.
 *             For deleting elements *next is set to NULL by the user and
 *             av_tree_insert() will set it to the AVTreeNode which was
 *             used for the removed element.
 *             This allows the use of flat arrays, which have
 *             lower overhead compared to many malloced elements.
 *             You might want to define a function like:
 *             <pre>{@code
 *             void *tree_insert(struct AVTreeNode **rootp, void *key,
 *                               int (*cmp)(void *key, const void *b),
 *                               AVTreeNode **next)
 *             {
 *                 if (!*next)
 *                     *next = av_mallocz(av_tree_node_size);
 *                 return av_tree_insert(rootp, key, cmp, next);
 *             }
 *             void *tree_remove(struct AVTreeNode **rootp, void *key,
 *                               int (*cmp)(void *key, const void *b, AVTreeNode **next))
 *             {
 *                 av_freep(next);
 *                 return av_tree_insert(rootp, key, cmp, next);
 *             }
 *             }</pre>
 * @param cmp compare function used to compare elements in the tree, API identical
 *            to that of Standard C's qsort
 * @return If no insertion happened, the found element; if an insertion or
 *         removal happened, then either key or NULL will be returned.
 *         Which one it is depends on the tree state and the implementation. You
 *         should make no assumptions that it's one or the other in the code.
 */
@NoException public static native Pointer av_tree_insert(@Cast("AVTreeNode**") PointerPointer rootp, Pointer key,
                     @Cast("int (*)(const void*, const void*)") Cmp_Const_Pointer_Const_Pointer cmp,
                     @Cast("AVTreeNode**") PointerPointer next);
@NoException public static native Pointer av_tree_insert(@ByPtrPtr AVTreeNode rootp, Pointer key,
                     @Cast("int (*)(const void*, const void*)") Cmp_Const_Pointer_Const_Pointer cmp,
                     @ByPtrPtr AVTreeNode next);

@NoException public static native void av_tree_destroy(AVTreeNode t);
// Targeting ..\avutil\Cmp_Pointer_Pointer.java


// Targeting ..\avutil\Enu_Pointer_Pointer.java


@NoException public static native void av_tree_enumerate(AVTreeNode t, Pointer opaque,
                       Cmp_Pointer_Pointer cmp,
                       Enu_Pointer_Pointer enu);

/**
 * \}
 */

// #endif /* AVUTIL_TREE_H */


// Parsed from <libavutil/tx.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVUTIL_TX_H
// #define AVUTIL_TX_H

// #include <stdint.h>
// #include <stddef.h>
// Targeting ..\avutil\AVTXContext.java


// Targeting ..\avutil\AVComplexFloat.java


// Targeting ..\avutil\AVComplexDouble.java


// Targeting ..\avutil\AVComplexInt32.java



/** enum AVTXType */
public static final int
    /**
     * Standard complex to complex FFT with sample data type AVComplexFloat.
     * Output is not 1/len normalized. Scaling currently unsupported.
     * The stride parameter is ignored.
     */
    AV_TX_FLOAT_FFT = 0,
    /**
     * Standard MDCT with sample data type of float and a scale type of
     * float. Length is the frame size, not the window size (which is 2x frame)
     * For forward transforms, the stride specifies the spacing between each
     * sample in the output array in bytes. The input must be a flat array.
     * For inverse transforms, the stride specifies the spacing between each
     * sample in the input array in bytes. The output will be a flat array.
     * Stride must be a non-zero multiple of sizeof(float).
     */
    AV_TX_FLOAT_MDCT = 1,
    /**
     * Same as AV_TX_FLOAT_FFT with a data type of AVComplexDouble.
     */
    AV_TX_DOUBLE_FFT = 2,
    /**
     * Same as AV_TX_FLOAT_MDCT with data and scale type of double.
     * Stride must be a non-zero multiple of sizeof(double).
     */
    AV_TX_DOUBLE_MDCT = 3,
    /**
     * Same as AV_TX_FLOAT_FFT with a data type of AVComplexInt32.
     */
    AV_TX_INT32_FFT = 4,
    /**
     * Same as AV_TX_FLOAT_MDCT with data type of int32_t and scale type of float.
     * Only scale values less than or equal to 1.0 are supported.
     * Stride must be a non-zero multiple of sizeof(int32_t).
     */
    AV_TX_INT32_MDCT = 5;
// Targeting ..\avutil\av_tx_fn.java



/**
 * Initialize a transform context with the given configuration
 * Currently power of two lengths from 2 to 131072 are supported, along with
 * any length decomposable to a power of two and either 3, 5 or 15.
 *
 * @param ctx the context to allocate, will be NULL on error
 * @param tx pointer to the transform function pointer to set
 * @param type type the type of transform
 * @param inv whether to do an inverse or a forward transform
 * @param len the size of the transform in samples
 * @param scale pointer to the value to scale the output if supported by type
 * @param flags currently unused
 *
 * @return 0 on success, negative error code on failure
 */
@NoException public static native int av_tx_init(@Cast("AVTXContext**") PointerPointer ctx, @ByPtrPtr av_tx_fn tx, @Cast("AVTXType") int type,
               int inv, int len, @Const Pointer scale, @Cast("uint64_t") long flags);
@NoException public static native int av_tx_init(@ByPtrPtr AVTXContext ctx, @ByPtrPtr av_tx_fn tx, @Cast("AVTXType") int type,
               int inv, int len, @Const Pointer scale, @Cast("uint64_t") long flags);

/**
 * Frees a context and sets ctx to NULL, does nothing when ctx == NULL
 */
@NoException public static native void av_tx_uninit(@Cast("AVTXContext**") PointerPointer ctx);
@NoException public static native void av_tx_uninit(@ByPtrPtr AVTXContext ctx);

// #endif /* AVUTIL_TX_H */


// Parsed from log_callback.h

/*
 * Copyright (C) 2015 Samuel Audet
 *
 * Licensed either under the Apache License, Version 2.0, or (at your option)
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation (subject to the "Classpath" exception),
 * either version 2, or any later version (collectively, the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     http://www.gnu.org/licenses/
 *     http://www.gnu.org/software/classpath/license.html
 *
 * or as provided in the LICENSE.txt file that accompanied this code.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #include <libavutil/log.h>
// Targeting ..\avutil\LogCallback.java



public static native LogCallback logCallback(); public static native void logCallback(LogCallback setter);

@NoException public static native void log_callback(Pointer ptr, int level, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer vl);
@NoException public static native void log_callback(Pointer ptr, int level, String fmt, @ByVal @Cast("va_list*") Pointer vl);

@NoException public static native void setLogCallback(LogCallback lc);


}
