/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    protected PolynomialGF2mSmallM[] sqMatrix;
    protected PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField field, PolynomialGF2mSmallM p) {
        this.field = field;
        this.p = p;
        this.computeSquaringMatrix();
        this.computeSquareRootMatrix();
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }

    private void computeSquaringMatrix() {
        int[] monomCoeffs;
        int i;
        int numColumns = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[numColumns];
        for (i = 0; i < numColumns >> 1; ++i) {
            monomCoeffs = new int[(i << 1) + 1];
            monomCoeffs[i << 1] = 1;
            this.sqMatrix[i] = new PolynomialGF2mSmallM(this.field, monomCoeffs);
        }
        for (i = numColumns >> 1; i < numColumns; ++i) {
            monomCoeffs = new int[(i << 1) + 1];
            monomCoeffs[i << 1] = 1;
            PolynomialGF2mSmallM monomial = new PolynomialGF2mSmallM(this.field, monomCoeffs);
            this.sqMatrix[i] = monomial.mod(this.p);
        }
    }

    private void computeSquareRootMatrix() {
        int i;
        int numColumns = this.p.getDegree();
        PolynomialGF2mSmallM[] tmpMatrix = new PolynomialGF2mSmallM[numColumns];
        for (i = numColumns - 1; i >= 0; --i) {
            tmpMatrix[i] = new PolynomialGF2mSmallM(this.sqMatrix[i]);
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[numColumns];
        for (i = numColumns - 1; i >= 0; --i) {
            this.sqRootMatrix[i] = new PolynomialGF2mSmallM(this.field, i);
        }
        for (i = 0; i < numColumns; ++i) {
            if (tmpMatrix[i].getCoefficient(i) == 0) {
                boolean foundNonZero = false;
                for (int j = i + 1; j < numColumns; ++j) {
                    if (tmpMatrix[j].getCoefficient(i) == 0) continue;
                    foundNonZero = true;
                    PolynomialRingGF2m.swapColumns(tmpMatrix, i, j);
                    PolynomialRingGF2m.swapColumns(this.sqRootMatrix, i, j);
                    j = numColumns;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            int coef = tmpMatrix[i].getCoefficient(i);
            int invCoef = this.field.inverse(coef);
            tmpMatrix[i].multThisWithElement(invCoef);
            this.sqRootMatrix[i].multThisWithElement(invCoef);
            for (int j = 0; j < numColumns; ++j) {
                if (j == i || (coef = tmpMatrix[j].getCoefficient(i)) == 0) continue;
                PolynomialGF2mSmallM tmpSqColumn = tmpMatrix[i].multWithElement(coef);
                PolynomialGF2mSmallM tmpInvColumn = this.sqRootMatrix[i].multWithElement(coef);
                tmpMatrix[j].addToThis(tmpSqColumn);
                this.sqRootMatrix[j].addToThis(tmpInvColumn);
            }
        }
    }

    private static void swapColumns(PolynomialGF2mSmallM[] matrix, int first, int second) {
        PolynomialGF2mSmallM tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }
}

