/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.derivative;

import boofcv.abst.filter.ImageFunctionSparse;
import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.filter.derivative.LaplacianEdge;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.factory.filter.convolve.FactoryConvolveSparse;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;

public class FactoryDerivativeSparse {
    public static <T extends ImageSingleBand> ImageFunctionSparse<T> createLaplacian(Class<T> imageType, ImageBorder<T> border) {
        if (border == null) {
            border = FactoryImageBorder.general(imageType, BorderType.EXTENDED);
        }
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            ImageConvolveSparse<ImageFloat32, Kernel2D_F32> r = FactoryConvolveSparse.create(ImageFloat32.class, LaplacianEdge.kernel_F32);
            r.setImageBorder((ImageBorder_F32)border);
            return r;
        }
        ImageConvolveSparse<ImageInteger, Kernel2D_I32> r = FactoryConvolveSparse.create(ImageInteger.class, LaplacianEdge.kernel_I32);
        r.setImageBorder((ImageBorder_I32)border);
        return r;
    }
}

