/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class ImplConvertMsToSingle {
    public static void average(MultiSpectral<ImageUInt8> from, ImageUInt8 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageUInt8 band0 = from.getBand(0);
            ImageUInt8 band1 = from.getBand(1);
            ImageUInt8 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom] & 0xFF;
                    sum += band1.data[indexFrom] & 0xFF;
                    to.data[indexTo++] = (byte)((sum += band2.data[indexFrom] & 0xFF) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageUInt8[])from.bands)[b].data[indexFrom] & 0xFF;
                    }
                    to.data[indexTo++] = (byte)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(MultiSpectral<ImageSInt8> from, ImageSInt8 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageSInt8 band0 = from.getBand(0);
            ImageSInt8 band1 = from.getBand(1);
            ImageSInt8 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (byte)((sum += band2.data[indexFrom]) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageSInt8[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = (byte)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(MultiSpectral<ImageUInt16> from, ImageUInt16 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageUInt16 band0 = from.getBand(0);
            ImageUInt16 band1 = from.getBand(1);
            ImageUInt16 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom] & 0xFFFF;
                    sum += band1.data[indexFrom] & 0xFFFF;
                    to.data[indexTo++] = (short)((sum += band2.data[indexFrom] & 0xFFFF) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageUInt16[])from.bands)[b].data[indexFrom] & 0xFFFF;
                    }
                    to.data[indexTo++] = (short)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(MultiSpectral<ImageSInt16> from, ImageSInt16 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageSInt16 band0 = from.getBand(0);
            ImageSInt16 band1 = from.getBand(1);
            ImageSInt16 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (short)((sum += band2.data[indexFrom]) / 3);
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageSInt16[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = (short)(sum / numBands);
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(MultiSpectral<ImageSInt32> from, ImageSInt32 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageSInt32 band0 = from.getBand(0);
            ImageSInt32 band1 = from.getBand(1);
            ImageSInt32 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    int sum = 0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageSInt32[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(MultiSpectral<ImageSInt64> from, ImageSInt64 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageSInt64 band0 = from.getBand(0);
            ImageSInt64 band1 = from.getBand(1);
            ImageSInt64 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    long sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3L;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    long sum = 0L;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageSInt64[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / (long)numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(MultiSpectral<ImageFloat32> from, ImageFloat32 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageFloat32 band0 = from.getBand(0);
            ImageFloat32 band1 = from.getBand(1);
            ImageFloat32 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    float sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3.0f;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    float sum = 0.0f;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageFloat32[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / (float)numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }

    public static void average(MultiSpectral<ImageFloat64> from, ImageFloat64 to) {
        int numBands = from.getNumBands();
        if (numBands == 1) {
            to.setTo(from.getBand(0));
        } else if (numBands == 3) {
            ImageFloat64 band0 = from.getBand(0);
            ImageFloat64 band1 = from.getBand(1);
            ImageFloat64 band2 = from.getBand(2);
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    double sum = band0.data[indexFrom];
                    sum += band1.data[indexFrom];
                    to.data[indexTo++] = (sum += band2.data[indexFrom]) / 3.0;
                    ++x;
                    ++indexFrom;
                }
            }
        } else {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                int x = 0;
                while (x < from.width) {
                    double sum = 0.0;
                    for (int b = 0; b < numBands; ++b) {
                        sum += ((ImageFloat64[])from.bands)[b].data[indexFrom];
                    }
                    to.data[indexTo++] = sum / (double)numBands;
                    ++x;
                    ++indexFrom;
                }
            }
        }
    }
}

