/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.border;

import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_F64;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.core.image.border.ImageBorder_I64;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSingleBand;

public class ImageBorderValue {
    public static ImageBorder wrap(ImageSingleBand image, double value) {
        if (image.getDataType().isInteger()) {
            if (image.getDataType().getNumBits() <= 32) {
                return ImageBorderValue.wrap((ImageInteger)image, (int)value);
            }
            return ImageBorderValue.wrap((ImageSInt64)image, (long)value);
        }
        if (image.getDataType().getDataType() == Float.TYPE) {
            return ImageBorderValue.wrap((ImageFloat32)image, (float)value);
        }
        return ImageBorderValue.wrap((ImageFloat64)image, value);
    }

    public static ImageBorder_I64 wrap(ImageSInt64 image, long value) {
        return new Value_I64(image, value);
    }

    public static ImageBorder_F64 wrap(ImageFloat64 image, double value) {
        return new Value_F64(image, value);
    }

    public static ImageBorder_F32 wrap(ImageFloat32 image, float value) {
        return new Value_F32(image, value);
    }

    public static ImageBorder_I32 wrap(ImageInteger image, int value) {
        return new Value_I(image, value);
    }

    public static class Value_I
    extends ImageBorder_I32 {
        int value;

        public Value_I(ImageInteger image, int value) {
            super(image);
            this.value = value;
        }

        public Value_I(int value) {
            this.value = value;
        }

        @Override
        public int getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, int value) {
        }
    }

    public static class Value_F32
    extends ImageBorder_F32 {
        float value;

        public Value_F32(ImageFloat32 image, float value) {
            super(image);
            this.value = value;
        }

        public Value_F32(float value) {
            this.value = value;
        }

        @Override
        public float getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, float val) {
        }
    }

    public static class Value_F64
    extends ImageBorder_F64 {
        double value;

        public Value_F64(ImageFloat64 image, double value) {
            super(image);
            this.value = value;
        }

        public Value_F64(double value) {
            this.value = value;
        }

        @Override
        public double getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, double val) {
        }
    }

    public static class Value_I64
    extends ImageBorder_I64 {
        long value;

        public Value_I64(ImageSInt64 image, long value) {
            super(image);
            this.value = value;
        }

        public Value_I64(long value) {
            this.value = value;
        }

        @Override
        public long getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, long val) {
        }
    }
}

