/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii;

import boofcv.alg.transform.ii.IntegralImageOps;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class GIntegralImageOps {
    public static <I extends ImageSingleBand, II extends ImageSingleBand> Class<II> getIntegralType(Class<I> inputType) {
        if (inputType == ImageFloat32.class) {
            return ImageFloat32.class;
        }
        if (inputType == ImageUInt8.class) {
            return ImageSInt32.class;
        }
        if (inputType == ImageSInt32.class) {
            return ImageSInt32.class;
        }
        throw new IllegalArgumentException("Unknown input image type: " + inputType.getSimpleName());
    }

    public static <I extends ImageSingleBand, T extends ImageSingleBand> T transform(I input, T transformed) {
        if (input instanceof ImageFloat32) {
            return (T)IntegralImageOps.transform((ImageFloat32)input, (ImageFloat32)transformed);
        }
        if (input instanceof ImageFloat64) {
            return (T)IntegralImageOps.transform((ImageFloat64)input, (ImageFloat64)transformed);
        }
        if (input instanceof ImageUInt8) {
            return (T)IntegralImageOps.transform((ImageUInt8)input, (ImageSInt32)transformed);
        }
        if (input instanceof ImageSInt32) {
            return (T)IntegralImageOps.transform((ImageSInt32)input, (ImageSInt32)transformed);
        }
        if (input instanceof ImageSInt64) {
            return (T)IntegralImageOps.transform((ImageSInt64)input, (ImageSInt64)transformed);
        }
        throw new IllegalArgumentException("Unknown input type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageSingleBand> T convolve(T integral, IntegralKernel kernel, T output) {
        if (integral instanceof ImageFloat32) {
            return (T)IntegralImageOps.convolve((ImageFloat32)integral, kernel, (ImageFloat32)output);
        }
        if (integral instanceof ImageFloat64) {
            return (T)IntegralImageOps.convolve((ImageFloat64)integral, kernel, (ImageFloat64)output);
        }
        if (integral instanceof ImageSInt32) {
            return (T)IntegralImageOps.convolve((ImageSInt32)integral, kernel, (ImageSInt32)output);
        }
        if (integral instanceof ImageSInt64) {
            return (T)IntegralImageOps.convolve((ImageSInt64)integral, kernel, (ImageSInt64)output);
        }
        throw new IllegalArgumentException("Unknown input type: " + integral.getClass().getSimpleName());
    }

    public static <T extends ImageSingleBand> T convolveBorder(T integral, IntegralKernel kernel, T output, int borderX, int borderY) {
        if (integral instanceof ImageFloat32) {
            return (T)IntegralImageOps.convolveBorder((ImageFloat32)integral, kernel, (ImageFloat32)output, borderX, borderY);
        }
        if (integral instanceof ImageFloat64) {
            return (T)IntegralImageOps.convolveBorder((ImageFloat64)integral, kernel, (ImageFloat64)output, borderX, borderY);
        }
        if (integral instanceof ImageSInt32) {
            return (T)IntegralImageOps.convolveBorder((ImageSInt32)integral, kernel, (ImageSInt32)output, borderX, borderY);
        }
        if (integral instanceof ImageSInt64) {
            return (T)IntegralImageOps.convolveBorder((ImageSInt64)integral, kernel, (ImageSInt64)output, borderX, borderY);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageSingleBand> double convolveSparse(T integral, IntegralKernel kernel, int x, int y) {
        if (integral instanceof ImageFloat32) {
            return IntegralImageOps.convolveSparse((ImageFloat32)integral, kernel, x, y);
        }
        if (integral instanceof ImageFloat64) {
            return IntegralImageOps.convolveSparse((ImageFloat64)integral, kernel, x, y);
        }
        if (integral instanceof ImageSInt32) {
            return IntegralImageOps.convolveSparse((ImageSInt32)integral, kernel, x, y);
        }
        if (integral instanceof ImageSInt64) {
            return IntegralImageOps.convolveSparse((ImageSInt64)integral, kernel, x, y);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageSingleBand> double block_zero(T integral, int x0, int y0, int x1, int y1) {
        if (integral instanceof ImageFloat32) {
            return IntegralImageOps.block_zero((ImageFloat32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof ImageFloat64) {
            return IntegralImageOps.block_zero((ImageFloat64)integral, x0, y0, x1, y1);
        }
        if (integral instanceof ImageSInt32) {
            return IntegralImageOps.block_zero((ImageSInt32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof ImageSInt64) {
            return IntegralImageOps.block_zero((ImageSInt64)integral, x0, y0, x1, y1);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageSingleBand> double block_unsafe(T integral, int x0, int y0, int x1, int y1) {
        if (integral instanceof ImageFloat32) {
            return IntegralImageOps.block_unsafe((ImageFloat32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof ImageFloat64) {
            return IntegralImageOps.block_unsafe((ImageFloat64)integral, x0, y0, x1, y1);
        }
        if (integral instanceof ImageSInt32) {
            return IntegralImageOps.block_unsafe((ImageSInt32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof ImageSInt64) {
            return IntegralImageOps.block_unsafe((ImageSInt64)integral, x0, y0, x1, y1);
        }
        throw new IllegalArgumentException("Unknown input type");
    }
}

