/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.NearestNeighborPixel;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt16;

public class NearestNeighborPixel_U16
extends NearestNeighborPixel<ImageUInt16> {
    private short[] data;

    public NearestNeighborPixel_U16() {
    }

    public NearestNeighborPixel_U16(ImageUInt16 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(ImageUInt16 image) {
        this.orig = image;
        this.data = ((ImageUInt16)this.orig).data;
        this.stride = ((ImageUInt16)this.orig).getStride();
        this.width = ((ImageUInt16)this.orig).getWidth();
        this.height = ((ImageUInt16)this.orig).getHeight();
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((ImageUInt16)this.orig).startIndex + (int)y * this.stride + (int)x] & 0xFFFF;
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image");
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((ImageUInt16)this.orig).startIndex + yy * this.stride + xx] & 0xFFFF;
    }

    @Override
    public ImageType<ImageUInt16> getImageType() {
        return ImageType.single(ImageUInt16.class);
    }
}

