/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.array;

public class PolynomialNevilleFixed_F32 {
    private int size;
    private float[] y;
    float[] c;
    float[] d;

    public PolynomialNevilleFixed_F32(int maxDegree) {
        this.c = new float[maxDegree];
        this.d = new float[maxDegree];
    }

    public PolynomialNevilleFixed_F32(int maxDegree, float[] y, int size) {
        this(maxDegree);
        this.setInput(y, size);
    }

    public void setInput(float[] y, int size) {
        this.size = size;
        this.y = y;
    }

    public float process(float sample, int i0, int i1) {
        int closestIndex;
        if (i1 < i0 || i1 - i0 + 1 > this.c.length || i1 >= this.size) {
            throw new IllegalArgumentException("Bad arguments");
        }
        int M = i1 - i0 + 1;
        int n = closestIndex = sample % 1.0f <= 0.5f ? (int)sample : (int)sample + 1;
        if (closestIndex > i1) {
            closestIndex = i1;
        } else if (closestIndex < i0) {
            closestIndex = i0;
        }
        closestIndex -= i0;
        for (int i = 0; i < M; ++i) {
            float valY;
            this.c[i] = valY = this.y[i + i0];
            this.d[i] = valY;
        }
        float estimate = this.y[i0 + closestIndex--];
        for (int m = 1; m < M; ++m) {
            for (int i = 0; i < M - m; ++i) {
                float ho = (float)(i0 + i) - sample;
                float hp = (float)(i0 + i + m) - sample;
                float w = this.c[i + 1] - this.d[i];
                float den = ho - hp;
                if ((double)den == 0.0) {
                    throw new RuntimeException("Two x's are identical");
                }
                den = w / den;
                this.d[i] = hp * den;
                this.c[i] = ho * den;
            }
            if (2 * (closestIndex + 1) < M - m) {
                estimate += this.c[closestIndex + 1];
                continue;
            }
            estimate += this.d[closestIndex];
            --closestIndex;
        }
        return estimate;
    }
}

