/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.JavaBinaryNames;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;

public class NdMethodId
extends NdNode {
    public static final FieldSearchKey<JavaIndex> METHOD_NAME;
    public static final FieldOneToMany<NdMethod> METHODS;
    public static final FieldOneToMany<NdType> DECLARED_TYPES;
    public static final StructDef<NdMethodId> type;

    static {
        type = StructDef.create(NdMethodId.class, NdNode.type);
        METHOD_NAME = FieldSearchKey.create(type, JavaIndex.METHODS);
        METHODS = FieldOneToMany.create(type, NdMethod.METHOD_ID, 2);
        DECLARED_TYPES = FieldOneToMany.create(type, NdType.DECLARING_METHOD);
        type.useStandardRefCounting().done();
    }

    public NdMethodId(Nd nd, long address) {
        super(nd, address);
    }

    public NdMethodId(Nd nd, char[] methodIdentifier) {
        super(nd);
        METHOD_NAME.put(nd, this.address, methodIdentifier);
    }

    public List<NdType> getDeclaredTypes() {
        return DECLARED_TYPES.asList(this.getNd(), this.address);
    }

    public IString getMethodName() {
        return METHOD_NAME.get(this.getNd(), this.address);
    }

    public char[] getSelector() {
        int selectorStart;
        char[] name = this.getMethodName().getChars();
        int selectorEnd = CharArrayUtils.indexOf('(', name, selectorStart = CharArrayUtils.indexOf('#', name) + 1, name.length);
        if (selectorEnd == -1) {
            selectorEnd = name.length;
        }
        return CharArrayUtils.subarray(name, selectorStart, selectorEnd);
    }

    public boolean isConstructor() {
        return JavaBinaryNames.isConstructor(this.getSelector());
    }

    public char[] getMethodDescriptor() {
        char[] name = this.getMethodName().getChars();
        int descriptorStart = CharArrayUtils.indexOf('(', name, 0, name.length);
        return CharArrayUtils.subarray(name, descriptorStart, name.length);
    }

    public boolean isClInit() {
        return JavaBinaryNames.isClinit(this.getSelector());
    }

    public String toString() {
        try {
            return new String(this.getSelector());
        }
        catch (RuntimeException e) {
            return super.toString();
        }
    }
}

