/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.apereo.cas.web.view.json.CasJsonServiceResponse;
import org.apereo.cas.web.view.json.CasJsonServiceResponseAuthenticationFailure;
import org.apereo.cas.web.view.json.CasJsonServiceResponseAuthenticationSuccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class Cas30JsonResponseView
extends Cas30ResponseView {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Cas30JsonResponseView.class);
    public static final String ATTRIBUTE_NAME_MODEL_SERVICE_RESPONSE = "serviceResponse";

    public Cas30JsonResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, View delegatedView, boolean releaseProtocolAttributes, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CasProtocolAttributesRenderer attributesRenderer) {
        super(successResponse, protocolAttributeEncoder, servicesManager, authenticationContextAttribute, delegatedView, releaseProtocolAttributes, authenticationAttributeReleasePolicy, serviceSelectionStrategy, attributesRenderer);
    }

    public Cas30JsonResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, boolean releaseProtocolAttributes, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CasProtocolAttributesRenderer attributesRenderer) {
        this(successResponse, protocolAttributeEncoder, servicesManager, authenticationContextAttribute, (View)Cas30JsonResponseView.createDelegatedView(), releaseProtocolAttributes, authenticationAttributeReleasePolicy, serviceSelectionStrategy, attributesRenderer);
    }

    private static MappingJackson2JsonView createDelegatedView() {
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setPrettyPrint(true);
        view.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).findAndRegisterModules();
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        CasJsonServiceResponse casResponse = new CasJsonServiceResponse();
        try {
            super.prepareMergedOutputModel(model, request, response);
            if (this.getAssertionFrom(model) != null) {
                CasJsonServiceResponseAuthenticationSuccess success = this.createAuthenticationSuccess(model);
                casResponse.setAuthenticationSuccess(success);
            } else {
                CasJsonServiceResponseAuthenticationFailure failure = this.createAuthenticationFailure(model);
                casResponse.setAuthenticationFailure(failure);
            }
        }
        catch (Exception e) {
            CasJsonServiceResponseAuthenticationFailure failure = this.createAuthenticationFailure(model);
            casResponse.setAuthenticationFailure(failure);
        }
        finally {
            HashMap<String, CasJsonServiceResponse> casModel = new HashMap<String, CasJsonServiceResponse>();
            casModel.put(ATTRIBUTE_NAME_MODEL_SERVICE_RESPONSE, casResponse);
            model.clear();
            model.putAll(casModel);
        }
    }

    private CasJsonServiceResponseAuthenticationFailure createAuthenticationFailure(Map<String, Object> model) {
        CasJsonServiceResponseAuthenticationFailure failure = new CasJsonServiceResponseAuthenticationFailure();
        failure.setCode(this.getErrorCodeFrom(model));
        failure.setDescription(this.getErrorDescriptionFrom(model));
        return failure;
    }

    private CasJsonServiceResponseAuthenticationSuccess createAuthenticationSuccess(Map<String, Object> model) {
        CasJsonServiceResponseAuthenticationSuccess success = new CasJsonServiceResponseAuthenticationSuccess();
        success.setAttributes(this.getModelAttributes(model));
        Principal principal = this.getPrincipal(model);
        success.setUser(principal.getId());
        success.setProxyGrantingTicket(this.getProxyGrantingTicketIou(model));
        Collection chainedAuthentications = this.getChainedAuthentications(model);
        if (chainedAuthentications != null && !chainedAuthentications.isEmpty()) {
            List proxies = chainedAuthentications.stream().map(authn -> authn.getPrincipal().getId()).collect(Collectors.toList());
            success.setProxies(proxies);
        }
        return success;
    }

    @Generated
    public String toString() {
        return "Cas30JsonResponseView()";
    }
}

