/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class Cas30ResponseView
extends Cas20ResponseView {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Cas30ResponseView.class);
    private final CasProtocolAttributesRenderer attributesRenderer;
    private final boolean releaseProtocolAttributes;

    public Cas30ResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, View view, boolean releaseProtocolAttributes, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CasProtocolAttributesRenderer attributesRenderer) {
        super(successResponse, protocolAttributeEncoder, servicesManager, authenticationContextAttribute, view, authenticationAttributeReleasePolicy, serviceSelectionStrategy);
        this.releaseProtocolAttributes = releaseProtocolAttributes;
        this.attributesRenderer = attributesRenderer;
    }

    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.prepareMergedOutputModel(model, request, response);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService(this.getServiceFrom(model));
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        Map<String, Object> principalAttributes = this.getCasPrincipalAttributes(model, registeredService);
        HashMap<String, Object> attributes = new HashMap<String, Object>(principalAttributes);
        LOGGER.debug("Processed principal attributes from the output model to be [{}]", principalAttributes.keySet());
        if (this.releaseProtocolAttributes) {
            LOGGER.debug("CAS is configured to release protocol-level attributes. Processing...");
            Map<String, Object> protocolAttributes = this.getCasProtocolAuthenticationAttributes(model, registeredService);
            attributes.putAll(protocolAttributes);
            LOGGER.debug("Processed protocol/authentication attributes from the output model to be [{}]", protocolAttributes.keySet());
        }
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributes, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributes, model, registeredService);
        LOGGER.debug("Final collection of attributes for the response are [{}].", attributes.keySet());
        this.putCasResponseAttributesIntoModel(model, attributes, registeredService);
    }

    protected Map<String, Object> getCasProtocolAuthenticationAttributes(Map<String, Object> model, RegisteredService registeredService) {
        if (!registeredService.getAttributeReleasePolicy().isAuthorizedToReleaseAuthenticationAttributes()) {
            LOGGER.debug("Attribute release policy for service [{}] is configured to never release any attributes", (Object)registeredService);
            return new LinkedHashMap<String, Object>(0);
        }
        Map filteredAuthenticationAttributes = this.authenticationAttributeReleasePolicy.getAuthenticationAttributesForRelease(this.getPrimaryAuthenticationFrom(model));
        this.filterCasProtocolAttributes(model, filteredAuthenticationAttributes);
        String contextProvider = this.getSatisfiedMultifactorAuthenticationProviderId(model);
        if (StringUtils.isNotBlank((CharSequence)contextProvider) && StringUtils.isNotBlank((CharSequence)this.authenticationContextAttribute)) {
            filteredAuthenticationAttributes.put(this.authenticationContextAttribute, CollectionUtils.wrap((Object)contextProvider));
        }
        return filteredAuthenticationAttributes;
    }

    private void filterCasProtocolAttributes(Map<String, Object> model, Map<String, Object> filteredAuthenticationAttributes) {
        filteredAuthenticationAttributes.put("authenticationDate", CollectionUtils.wrap((Object)this.getAuthenticationDate(model)));
        filteredAuthenticationAttributes.put("isFromNewLogin", CollectionUtils.wrap((Object)this.isAssertionBackedByNewLogin(model)));
        filteredAuthenticationAttributes.put("longTermAuthenticationRequestTokenUsed", CollectionUtils.wrap((Object)this.isRememberMeAuthentication(model)));
    }

    protected Map<String, Object> getCasPrincipalAttributes(Map<String, Object> model, RegisteredService registeredService) {
        return super.getPrincipalAttributesAsMultiValuedAttributes(model);
    }

    protected void putCasResponseAttributesIntoModel(Map<String, Object> model, Map<String, Object> attributes, RegisteredService registeredService) {
        LOGGER.debug("Beginning to encode attributes for the response");
        Map encodedAttributes = this.protocolAttributeEncoder.encodeAttributes(attributes, registeredService);
        LOGGER.debug("Encoded attributes for the response are [{}]", (Object)encodedAttributes);
        super.putIntoModel(model, "attributes", (Object)encodedAttributes);
        Collection formattedAttributes = this.attributesRenderer.render(encodedAttributes);
        super.putIntoModel(model, "formattedAttributes", (Object)formattedAttributes);
    }
}

