/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.throttle.ThrottledRequestExecutor;
import org.apereo.cas.throttle.ThrottledRequestResponseHandler;
import org.apereo.cas.web.support.AbstractInspektrAuditHandlerInterceptorAdapter;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcThrottledSubmissionHandlerInterceptorAdapter
extends AbstractInspektrAuditHandlerInterceptorAdapter {
    private final String sqlQueryAudit;
    private final JdbcTemplate jdbcTemplate;

    public JdbcThrottledSubmissionHandlerInterceptorAdapter(int failureThreshold, int failureRangeInSeconds, String usernameParameter, AuditTrailExecutionPlan auditTrailManager, DataSource dataSource, String applicationCode, String sqlQueryAudit, String authenticationFailureCode, ThrottledRequestResponseHandler throttledRequestResponseHandler, ThrottledRequestExecutor throttledRequestExecutor) {
        super(failureThreshold, failureRangeInSeconds, usernameParameter, authenticationFailureCode, auditTrailManager, applicationCode, throttledRequestResponseHandler, throttledRequestExecutor);
        this.sqlQueryAudit = sqlQueryAudit;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public boolean exceedsThreshold(HttpServletRequest request) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        String remoteAddress = clientInfo.getClientIpAddress();
        List failuresInAudits = this.jdbcTemplate.query(this.sqlQueryAudit, new Object[]{remoteAddress, this.getUsernameParameterFromRequest(request), this.getAuthenticationFailureCode(), this.getApplicationCode(), this.getFailureInRangeCutOffDate()}, new int[]{12, 12, 12, 12, 93}, (resultSet, i) -> resultSet.getTimestamp(1));
        List failures = failuresInAudits.stream().map(t -> new Date(t.getTime())).collect(Collectors.toList());
        return this.calculateFailureThresholdRateAndCompare(failures);
    }

    public String getName() {
        return "InspektrIpAddressUsernameThrottle";
    }
}

