/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.sql.DataSource;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.config.CasThrottlingConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.throttle.ThrottleProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.throttle.ThrottledRequestExecutor;
import org.apereo.cas.throttle.ThrottledRequestResponseHandler;
import org.apereo.cas.web.support.JdbcThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casJdbcThrottlingConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureAfter(value={CasThrottlingConfiguration.class})
public class CasJdbcThrottlingConfiguration {
    @Autowired
    @Qualifier(value="auditTrailExecutionPlan")
    private ObjectProvider<AuditTrailExecutionPlan> auditTrailManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="throttledRequestResponseHandler")
    private ObjectProvider<ThrottledRequestResponseHandler> throttledRequestResponseHandler;
    @Autowired
    @Qualifier(value="throttledRequestExecutor")
    private ObjectProvider<ThrottledRequestExecutor> throttledRequestExecutor;

    @RefreshScope
    @Bean
    public DataSource inspektrThrottleDataSource() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getAuthn().getThrottle().getJdbc());
    }

    @Bean
    @RefreshScope
    public ThrottledSubmissionHandlerInterceptor authenticationThrottle() {
        ThrottleProperties throttle = this.casProperties.getAuthn().getThrottle();
        ThrottleProperties.Failure failure = throttle.getFailure();
        return new JdbcThrottledSubmissionHandlerInterceptorAdapter(failure.getThreshold(), failure.getRangeSeconds(), throttle.getUsernameParameter(), (AuditTrailExecutionPlan)this.auditTrailManager.getIfAvailable(), this.inspektrThrottleDataSource(), throttle.getAppCode(), throttle.getJdbc().getAuditQuery(), failure.getCode(), (ThrottledRequestResponseHandler)this.throttledRequestResponseHandler.getIfAvailable(), (ThrottledRequestExecutor)this.throttledRequestExecutor.getIfAvailable());
    }
}

