/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NameParserImpl;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.StringManager;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;

public abstract class BaseDirContext
implements DirContext {
    private static final Log log = LogFactory.getLog(BaseDirContext.class);
    protected String docBase = null;
    protected Hashtable<String, Object> env;
    protected static final StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected final NameParser nameParser = new NameParserImpl();
    protected boolean cached = true;
    protected int cacheTTL = 5000;
    protected int cacheMaxSize = 10240;
    protected int cacheObjectMaxSize = 512;
    protected Map<String, BaseDirContext> aliases = new HashMap<String, BaseDirContext>();
    protected List<DirContext> altDirContexts = new ArrayList<DirContext>();

    public BaseDirContext() {
        this.env = new Hashtable();
    }

    public BaseDirContext(Hashtable<String, Object> env) {
        this.env = env;
    }

    public void addResourcesJar(URL url) {
        try {
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            JarFile jarFile = conn.getJarFile();
            ZipEntry entry = jarFile.getEntry("/");
            WARDirContext warDirContext = new WARDirContext(jarFile, new WARDirContext.Entry("/", entry));
            warDirContext.loadEntries();
            this.altDirContexts.add(warDirContext);
        }
        catch (IOException ioe) {
            log.warn((Object)sm.getString("resources.addResourcesJarFail", url), (Throwable)ioe);
        }
    }

    public void addAltDirContext(DirContext altDirContext) {
        this.altDirContexts.add(altDirContext);
    }

    public void addAlias(String path, BaseDirContext dirContext) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("resources.invalidAliasPath", path));
        }
        this.aliases.put(path, dirContext);
    }

    public void removeAlias(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("resources.invalidAliasPath", path));
        }
        this.aliases.remove(path);
    }

    public String getAliases() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, BaseDirContext>> iter = this.aliases.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            Map.Entry<String, BaseDirContext> entry = iter.next();
            result.append(entry.getKey());
            result.append('=');
            result.append(entry.getValue().getDocBase());
        }
        return result.toString();
    }

    public void setAliases(String theAliases) {
        String[] kvps;
        this.aliases.clear();
        if (theAliases == null || theAliases.length() == 0) {
            return;
        }
        for (String kvp : kvps = theAliases.split(",")) {
            BaseDirContext context;
            if (0 == (kvp = kvp.trim()).length()) continue;
            String[] kv = kvp.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasMapping", kvp));
            }
            kv[0] = kv[0].trim();
            kv[1] = kv[1].trim();
            if (kv[0].length() == 0 || kv[1].length() == 0) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasMapping", kvp));
            }
            if (kv[0].equals("/")) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasNotAllowed", kv[0]));
            }
            File aliasLoc = new File(kv[1]);
            if (!aliasLoc.exists()) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasNotExist", kv[1]));
            }
            if (kv[1].endsWith(".war") && !aliasLoc.isDirectory()) {
                context = new WARDirContext();
            } else if (aliasLoc.isDirectory()) {
                context = new FileDirContext();
            } else {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasFile", kv[1]));
            }
            context.setDocBase(kv[1]);
            this.addAlias(kv[0], context);
        }
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }
        this.docBase = docBase;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheObjectMaxSize() {
        return this.cacheObjectMaxSize;
    }

    public void setCacheObjectMaxSize(int cacheObjectMaxSize) {
        this.cacheObjectMaxSize = cacheObjectMaxSize;
    }

    public void allocate() {
    }

    public void release() {
        for (BaseDirContext bcontext : this.aliases.values()) {
            bcontext.release();
        }
        this.aliases.clear();
        for (DirContext dcontext : this.altDirContexts) {
            if (!(dcontext instanceof BaseDirContext)) continue;
            ((BaseDirContext)dcontext).release();
        }
        this.altDirContexts.clear();
    }

    public String getRealPath(String name) {
        String path;
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.doGetRealPath(result.aliasName);
            }
        }
        if ((path = this.doGetRealPath(name)) != null) {
            return path;
        }
        String resourceName = "/META-INF/resources" + name;
        for (DirContext altDirContext : this.altDirContexts) {
            if (!(altDirContext instanceof BaseDirContext) || (path = ((BaseDirContext)altDirContext).getRealPath(resourceName)) == null) continue;
            return path;
        }
        return null;
    }

    @Override
    public final Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public final Object lookup(String name) throws NamingException {
        Object obj = this.doLookupWithoutNNFE(name);
        if (obj != null) {
            return obj;
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", name));
    }

    private Object doLookupWithoutNNFE(String name) throws NamingException {
        Object obj;
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.lookup(result.aliasName);
            }
        }
        if ((obj = this.doLookup(name)) != null) {
            return obj;
        }
        String resourceName = "/META-INF/resources" + name;
        for (DirContext altDirContext : this.altDirContexts) {
            if (altDirContext instanceof BaseDirContext) {
                obj = ((BaseDirContext)altDirContext).doLookupWithoutNNFE(resourceName);
            } else {
                try {
                    obj = altDirContext.lookup(resourceName);
                }
                catch (NamingException ex) {
                    // empty catch block
                }
            }
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(name, obj, null);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(name, obj, null);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public abstract void unbind(String var1) throws NamingException;

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public abstract void rename(String var1, String var2) throws NamingException;

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.list(result.aliasName);
            }
        }
        List<NamingEntry> bindings = this.doListBindings(name);
        List<NamingEntry> altBindings = null;
        String resourceName = "/META-INF/resources" + name;
        for (DirContext altDirContext : this.altDirContexts) {
            if (altDirContext instanceof BaseDirContext) {
                altBindings = ((BaseDirContext)altDirContext).doListBindings(resourceName);
            }
            if (altBindings == null) continue;
            if (bindings == null) {
                bindings = altBindings;
                continue;
            }
            bindings.addAll(altBindings);
        }
        if (bindings != null) {
            return new NamingContextEnumeration(bindings.iterator());
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", name));
    }

    @Override
    public final NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public final NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.listBindings(result.aliasName);
            }
        }
        List<NamingEntry> bindings = this.doListBindings(name);
        List<NamingEntry> altBindings = null;
        String resourceName = "/META-INF/resources" + name;
        for (DirContext altDirContext : this.altDirContexts) {
            if (altDirContext instanceof BaseDirContext) {
                altBindings = ((BaseDirContext)altDirContext).doListBindings(resourceName);
            }
            if (altBindings == null) continue;
            if (bindings == null) {
                bindings = altBindings;
                continue;
            }
            bindings.addAll(altBindings);
        }
        if (bindings != null) {
            return new NamingContextBindingsEnumeration(bindings.iterator(), this);
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public abstract void destroySubcontext(String var1) throws NamingException;

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public abstract Object lookupLink(String var1) throws NamingException;

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParserImpl();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParserImpl();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name clone = (Name)prefix.clone();
        return clone.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public void close() throws NamingException {
        this.env.clear();
    }

    @Override
    public abstract String getNameInNamespace() throws NamingException;

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    @Override
    public final Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        Attributes attrs;
        if (!this.aliases.isEmpty()) {
            AliasResult result = this.findAlias(name);
            if (result.dirContext != null) {
                return result.dirContext.getAttributes(result.aliasName, attrIds);
            }
        }
        if ((attrs = this.doGetAttributes(name, attrIds)) != null) {
            return attrs;
        }
        String resourceName = "/META-INF/resources" + name;
        for (DirContext altDirContext : this.altDirContexts) {
            if (altDirContext instanceof BaseDirContext) {
                attrs = ((BaseDirContext)altDirContext).doGetAttributes(resourceName, attrIds);
            } else {
                try {
                    attrs = altDirContext.getAttributes(name, attrIds);
                }
                catch (NamingException ne) {
                    // empty catch block
                }
            }
            if (attrs == null) continue;
            return attrs;
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", name));
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    @Override
    public abstract void modifyAttributes(String var1, int var2, Attributes var3) throws NamingException;

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }

    @Override
    public abstract void modifyAttributes(String var1, ModificationItem[] var2) throws NamingException;

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.bind(name.toString(), obj, attrs);
    }

    @Override
    public abstract void bind(String var1, Object var2, Attributes var3) throws NamingException;

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(name.toString(), obj, attrs);
    }

    @Override
    public abstract void rebind(String var1, Object var2, Attributes var3) throws NamingException;

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    @Override
    public abstract DirContext createSubcontext(String var1, Attributes var2) throws NamingException;

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.getSchema(name.toString());
    }

    @Override
    public abstract DirContext getSchema(String var1) throws NamingException;

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    @Override
    public abstract DirContext getSchemaClassDefinition(String var1) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(name.toString(), matchingAttributes, attributesToReturn);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, Attributes var2, String[] var3) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name.toString(), matchingAttributes);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, Attributes var2) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filter, cons);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, String var2, SearchControls var3) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filterExpr, filterArgs, cons);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, String var2, Object[] var3, SearchControls var4) throws NamingException;

    protected abstract Attributes doGetAttributes(String var1, String[] var2) throws NamingException;

    protected abstract Object doLookup(String var1);

    protected abstract List<NamingEntry> doListBindings(String var1) throws NamingException;

    protected abstract String doGetRealPath(String var1);

    private AliasResult findAlias(String name) {
        int slash;
        boolean slashAppended;
        String searchName;
        AliasResult result = new AliasResult();
        if (name.length() == 0) {
            searchName = "/";
            slashAppended = true;
        } else if (name.charAt(0) == '/') {
            searchName = name;
            slashAppended = false;
        } else {
            searchName = "/" + name;
            slashAppended = true;
        }
        result.dirContext = this.aliases.get(searchName);
        while (result.dirContext == null && (slash = searchName.lastIndexOf(47)) >= 0) {
            searchName = searchName.substring(0, slash);
            result.dirContext = this.aliases.get(searchName);
        }
        if (result.dirContext != null) {
            result.aliasName = slashAppended ? name.substring(searchName.length() - 1) : name.substring(searchName.length());
        }
        return result;
    }

    private static class AliasResult {
        BaseDirContext dirContext;
        String aliasName;

        private AliasResult() {
        }
    }
}

