/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public final class IdAllocator {
    private static final String SEPARATOR = "_";
    private final Map<String, NameGenerator> generatorMap;
    private final String namespace;

    public IdAllocator() {
        this("");
    }

    public IdAllocator(String namespace) {
        this(namespace, new HashMap<String, NameGenerator>());
    }

    private IdAllocator(String namespace, Map<String, NameGenerator> generatorMap) {
        this.namespace = namespace;
        this.generatorMap = generatorMap;
    }

    public List<String> getAllocatedIds() {
        return InternalUtils.sortedKeys(this.generatorMap);
    }

    public IdAllocator clone() {
        IdentityHashMap<NameGenerator, NameGenerator> transformMap = new IdentityHashMap<NameGenerator, NameGenerator>();
        for (NameGenerator original : this.generatorMap.values()) {
            NameGenerator copy = original.clone();
            transformMap.put(original, copy);
        }
        Map mapCopy = CollectionFactory.newMap();
        for (Map.Entry<String, NameGenerator> entry : this.generatorMap.entrySet()) {
            NameGenerator copy = (NameGenerator)transformMap.get(entry.getValue());
            mapCopy.put(entry.getKey(), copy);
        }
        return new IdAllocator(this.namespace, mapCopy);
    }

    public String allocateId(String name) {
        String result;
        String key = name + this.namespace;
        NameGenerator g = this.generatorMap.get(key);
        if (g == null) {
            g = new NameGenerator(key);
            result = key;
        } else {
            result = g.nextId();
        }
        while (this.generatorMap.containsKey(result)) {
            result = g.nextId();
        }
        this.generatorMap.put(result, g);
        return result;
    }

    public boolean isAllocated(String name) {
        return this.generatorMap.containsKey(name);
    }

    public void clear() {
        this.generatorMap.clear();
    }

    private static class NameGenerator
    implements Cloneable {
        private final String baseId;
        private int index;

        NameGenerator(String baseId) {
            this.baseId = baseId + IdAllocator.SEPARATOR;
        }

        public String nextId() {
            return this.baseId + this.index++;
        }

        public NameGenerator clone() {
            try {
                return (NameGenerator)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

