/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.kafka010.CompactedKafkaRDDIterator;
import org.apache.spark.streaming.kafka010.HasOffsetRanges;
import org.apache.spark.streaming.kafka010.KafkaRDDIterator;
import org.apache.spark.streaming.kafka010.KafkaRDDPartition;
import org.apache.spark.streaming.kafka010.OffsetRange;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-b!B\u0001\u0003\u0001\u0019a!\u0001C&bM.\f'\u000b\u0012#\u000b\u0005\r!\u0011\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WcA\u0007!]M!\u0001A\u0004\u00197!\ry!\u0003F\u0007\u0002!)\u0011\u0011CB\u0001\u0004e\u0012$\u0017BA\n\u0011\u0005\r\u0011F\t\u0012\t\u0005+qqR&D\u0001\u0017\u0015\t9\u0002$\u0001\u0005d_:\u001cX/\\3s\u0015\tI\"$A\u0004dY&,g\u000e^:\u000b\u0005mA\u0011!B6bM.\f\u0017BA\u000f\u0017\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004\"a\b\u0011\r\u0001\u0011)\u0011\u0005\u0001b\u0001G\t\t1j\u0001\u0001\u0012\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002(pi\"Lgn\u001a\t\u0003K-J!\u0001\f\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002 ]\u0011)q\u0006\u0001b\u0001G\t\ta\u000b\u0005\u00022i5\t!G\u0003\u00024\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0007CA\u001c9\u001b\u0005\u0011\u0011BA\u001d\u0003\u0005=A\u0015m](gMN,GOU1oO\u0016\u001c\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0005M\u001c\u0007CA\u001f?\u001b\u00051\u0011BA \u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015aC6bM.\f\u0007+\u0019:b[N,\u0012a\u0011\t\u0005\t&[%+D\u0001F\u0015\t1u)\u0001\u0003vi&d'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u00131!T1q!\tauJ\u0004\u0002&\u001b&\u0011aJJ\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002OMA\u00111KV\u0007\u0002)*\u0011QkR\u0001\u0005Y\u0006tw-\u0003\u0002X)\n1qJ\u00196fGRD\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IaQ\u0001\rW\u000647.\u0019)be\u0006l7\u000f\t\u0005\t7\u0002\u0011)\u0019!C\u00019\u0006aqN\u001a4tKR\u0014\u0016M\\4fgV\tQ\fE\u0002&=\u0002L!a\u0018\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u0005]\n\u0017B\u00012\u0003\u0005-yeMZ:fiJ\u000bgnZ3\t\u0011\u0011\u0004!\u0011!Q\u0001\nu\u000bQb\u001c4gg\u0016$(+\u00198hKN\u0004\u0003\u0002\u00034\u0001\u0005\u000b\u0007I\u0011A4\u0002\u001dA\u0014XMZ3se\u0016$\u0007j\\:ugV\t\u0001\u000e\u0005\u0003E\u0013&\\\u0005C\u00016n\u001b\u0005Y'B\u00017\u001b\u0003\u0019\u0019w.\\7p]&\u0011an\u001b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\u0001\bA!A!\u0002\u0013A\u0017a\u00049sK\u001a,'O]3e\u0011>\u001cHo\u001d\u0011\t\u0011I\u0004!\u0011!Q\u0001\nM\f\u0001#^:f\u0007>t7/^7fe\u000e\u000b7\r[3\u0011\u0005\u0015\"\u0018BA;'\u0005\u001d\u0011un\u001c7fC:DQa\u001e\u0001\u0005\u0002a\fa\u0001P5oSRtDCB={wrlh\u0010\u0005\u00038\u0001yi\u0003\"B\u001ew\u0001\u0004a\u0004\"B!w\u0001\u0004\u0019\u0005\"B.w\u0001\u0004i\u0006\"\u00024w\u0001\u0004A\u0007\"\u0002:w\u0001\u0004\u0019\b\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0003-\u0001x\u000e\u001c7US6,w.\u001e;\u0016\u0005\u0005\u0015\u0001cA\u0013\u0002\b%\u0019\u0011\u0011\u0002\u0014\u0003\t1{gn\u001a\u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\u0006\u0005a\u0001o\u001c7m)&lWm\\;uA!I\u0011\u0011\u0003\u0001C\u0002\u0013%\u00111C\u0001\u0015G\u0006\u001c\u0007.Z%oSRL\u0017\r\\\"ba\u0006\u001c\u0017\u000e^=\u0016\u0005\u0005U\u0001cA\u0013\u0002\u0018%\u0019\u0011\u0011\u0004\u0014\u0003\u0007%sG\u000f\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u000b\u0003U\u0019\u0017m\u00195f\u0013:LG/[1m\u0007\u0006\u0004\u0018mY5us\u0002B\u0011\"!\t\u0001\u0005\u0004%I!a\u0005\u0002!\r\f7\r[3NCb\u001c\u0015\r]1dSRL\b\u0002CA\u0013\u0001\u0001\u0006I!!\u0006\u0002#\r\f7\r[3NCb\u001c\u0015\r]1dSRL\b\u0005C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,\u0005y1-Y2iK2{\u0017\r\u001a$bGR|'/\u0006\u0002\u0002.A\u0019Q%a\f\n\u0007\u0005EbEA\u0003GY>\fG\u000f\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0017\u0003A\u0019\u0017m\u00195f\u0019>\fGMR1di>\u0014\b\u0005C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<\u0005I1m\\7qC\u000e$X\rZ\u000b\u0002g\"9\u0011q\b\u0001!\u0002\u0013\u0019\u0018AC2p[B\f7\r^3eA!9\u00111\t\u0001\u0005B\u0005\u0015\u0013a\u00029feNL7\u000f\u001e\u000b\u0005\u0003\u000f\nI%D\u0001\u0001\u0011!\tY%!\u0011A\u0002\u00055\u0013\u0001\u00038fo2+g/\u001a7\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\u0016\u0002R\ta1\u000b^8sC\u001e,G*\u001a<fY\"9\u00111\f\u0001\u0005B\u0005u\u0013!D4fiB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002`A!QEXA1!\ri\u00141M\u0005\u0004\u0003K2!!\u0003)beRLG/[8o\u0011\u001d\tI\u0007\u0001C!\u0003W\nQaY8v]R$\"!!\u0002\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r\u0005Y1m\\;oi\u0006\u0003\bO]8y)\u0019\t\u0019(!\"\u0002\nB1\u0011QOA>\u0003\u007fj!!a\u001e\u000b\u0007\u0005ed!A\u0004qCJ$\u0018.\u00197\n\t\u0005u\u0014q\u000f\u0002\u000e!\u0006\u0014H/[1m%\u0016\u001cX\u000f\u001c;\u0011\t\u0005U\u0014\u0011Q\u0005\u0005\u0003\u0007\u000b9HA\u0007C_VtG-\u001a3E_V\u0014G.\u001a\u0005\t\u0003\u000f\u000bi\u00071\u0001\u0002\u0006\u00059A/[7f_V$\bBCAF\u0003[\u0002\n\u00111\u0001\u0002\u000e\u0006Q1m\u001c8gS\u0012,gnY3\u0011\u0007\u0015\ny)C\u0002\u0002\u0012\u001a\u0012a\u0001R8vE2,\u0007bBAK\u0001\u0011\u0005\u0013qS\u0001\bSN,U\u000e\u001d;z)\u0005\u0019\bbBAN\u0001\u0011\u0005\u0013QT\u0001\u0005i\u0006\\W\r\u0006\u0003\u0002 \u0006\u0005\u0006cA\u0013_)!A\u00111UAM\u0001\u0004\t)\"A\u0002ok6Dq!a*\u0001\t\u0013\tI+A\u0005fq\u0016\u001cW\u000f^8sgR\u0011\u00111\u0016\t\u0005Ky\u000bi\u000b\u0005\u0003\u00020\u0006UVBAAY\u0015\r\t\u0019LB\u0001\ng\u000eDW\rZ;mKJLA!a.\u00022\nIR\t_3dkR|'oQ1dQ\u0016$\u0016m]6M_\u000e\fG/[8o\u0011!\tY\f\u0001C\t\u0005\u0005u\u0016\u0001E2p[B\f'/Z#yK\u000e,Ho\u001c:t)\u0015\u0019\u0018qXAb\u0011!\t\t-!/A\u0002\u00055\u0016!A1\t\u0011\u0005\u0015\u0017\u0011\u0018a\u0001\u0003[\u000b\u0011A\u0019\u0005\b\u0003\u0013\u0004A\u0011IAf\u0003U9W\r\u001e)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N$B!!4\u0002fB)\u0011qZAp\u0017:!\u0011\u0011[An\u001d\u0011\t\u0019.!7\u000e\u0005\u0005U'bAAlE\u00051AH]8pizJ\u0011aJ\u0005\u0004\u0003;4\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003C\f\u0019OA\u0002TKFT1!!8'\u0011!\t9/a2A\u0002\u0005\u0005\u0014a\u0002;iKB\u000b'\u000f\u001e\u0005\b\u0003W\u0004A\u0011BAw\u0003A)'O\u001d\"fO&t\u0017I\u001a;fe\u0016sG\rF\u0002L\u0003_D\u0001\"!=\u0002j\u0002\u0007\u00111_\u0001\u0005a\u0006\u0014H\u000fE\u00028\u0003kL1!a>\u0003\u0005EY\u0015MZ6b%\u0012#\u0005+\u0019:uSRLwN\u001c\u0005\b\u0003w\u0004A\u0011IA\u007f\u0003\u001d\u0019w.\u001c9vi\u0016$b!a@\u0003\u0006\t\u001d\u0001#BAh\u0005\u0003!\u0012\u0002\u0002B\u0002\u0003G\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\t\u0003O\fI\u00101\u0001\u0002b!A!\u0011BA}\u0001\u0004\u0011Y!A\u0004d_:$X\r\u001f;\u0011\u0007u\u0012i!C\u0002\u0003\u0010\u0019\u00111\u0002V1tW\u000e{g\u000e^3yi\"I!1\u0003\u0001\u0012\u0002\u0013\u0005#QC\u0001\u0016G>,h\u000e^!qaJ|\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119B\u000b\u0003\u0002\u000e\ne1F\u0001B\u000e!\u0011\u0011iBa\n\u000e\u0005\t}!\u0002\u0002B\u0011\u0005G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015b%\u0001\u0006b]:|G/\u0019;j_:LAA!\u000b\u0003 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class KafkaRDD<K, V>
extends RDD<ConsumerRecord<K, V>>
implements HasOffsetRanges {
    private final Map<String, Object> kafkaParams;
    private final OffsetRange[] offsetRanges;
    private final Map<TopicPartition, String> preferredHosts;
    private final boolean useConsumerCache;
    private final long pollTimeout;
    private final int cacheInitialCapacity;
    private final int cacheMaxCapacity;
    private final float cacheLoadFactor;
    private final boolean compacted;

    public Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    @Override
    public OffsetRange[] offsetRanges() {
        return this.offsetRanges;
    }

    public Map<TopicPartition, String> preferredHosts() {
        return this.preferredHosts;
    }

    private long pollTimeout() {
        return this.pollTimeout;
    }

    private int cacheInitialCapacity() {
        return this.cacheInitialCapacity;
    }

    private int cacheMaxCapacity() {
        return this.cacheMaxCapacity;
    }

    private float cacheLoadFactor() {
        return this.cacheLoadFactor;
    }

    private boolean compacted() {
        return this.compacted;
    }

    public KafkaRDD<K, V> persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return (KafkaRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaRDDPartition apply(Tuple2<OffsetRange, Object> x0$1) {
                Tuple2<OffsetRange, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    OffsetRange o = (OffsetRange)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    KafkaRDDPartition kafkaRDDPartition = new KafkaRDDPartition(i, o.topic(), o.partition(), o.fromOffset(), o.untilOffset());
                    return kafkaRDDPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class)))).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return this.compacted() ? super.count() : BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetRange x$1) {
                return x$1.count();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        PartialResult partialResult;
        if (this.compacted()) {
            partialResult = super.countApprox(timeout, confidence);
        } else {
            long c = this.count();
            partialResult = new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
        }
        return partialResult;
    }

    public double countApprox$default$2() {
        return 0.95;
    }

    public boolean isEmpty() {
        return this.compacted() ? super.isEmpty() : this.count() == 0L;
    }

    public ConsumerRecord<K, V>[] take(int num) {
        ConsumerRecord[] consumerRecordArray;
        if (this.compacted()) {
            consumerRecordArray = (ConsumerRecord[])super.take(num);
        } else if (num < 1) {
            consumerRecordArray = (ConsumerRecord[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ConsumerRecord.class));
        } else {
            KafkaRDDPartition[] nonEmptyPartitions = (KafkaRDDPartition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.partitions()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final KafkaRDDPartition apply(Partition x$2) {
                    return (KafkaRDDPartition)x$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class)))).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaRDDPartition x$3) {
                    return x$3.count() > 0L;
                }
            });
            if (Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).isEmpty()) {
                consumerRecordArray = (ConsumerRecord[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ConsumerRecord.class));
            } else {
                scala.collection.immutable.Map parts = (scala.collection.immutable.Map)Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this, num){
                    public static final long serialVersionUID = 0L;
                    private final int num$1;

                    public final scala.collection.immutable.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> result, KafkaRDDPartition part) {
                        scala.collection.immutable.Map map;
                        int remain = this.num$1 - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                        if (remain > 0) {
                            long taken = Math.min((long)remain, part.count());
                            map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                        } else {
                            map = result;
                        }
                        return map;
                    }
                    {
                        this.num$1 = num$1;
                    }
                });
                consumerRecordArray = (ConsumerRecord[])Predef$.MODULE$.refArrayOps((Object[])this.context().runJob((RDD)this, (Function2)new Serializable(this, parts){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map parts$1;

                    public final ConsumerRecord<K, V>[] apply(TaskContext tc, Iterator<ConsumerRecord<K, V>> it) {
                        return (ConsumerRecord[])it.take(BoxesRunTime.unboxToInt((Object)this.parts$1.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class));
                    }
                    {
                        this.parts$1 = parts$1;
                    }
                }, (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ConsumerRecord.class)))).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<ConsumerRecord<K, V>> apply(ConsumerRecord<K, V>[] xs) {
                        return Predef$.MODULE$.wrapRefArray((Object[])xs);
                    }
                }, ClassTag$.MODULE$.apply(ConsumerRecord.class));
            }
        }
        return consumerRecordArray;
    }

    private ExecutorCacheTaskLocation[] executors() {
        BlockManager bm = this.sparkContext().env().blockManager();
        return (ExecutorCacheTaskLocation[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ExecutorCacheTaskLocation apply(BlockManagerId x) {
                return new ExecutorCacheTaskLocation(x.host(), x.executorId());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class)))).sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRDD $outer;

            public final boolean apply(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
                return this.$outer.compareExecutors(a, b);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean compareExecutors(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public Seq<String> getPreferredLocations(Partition thePart) {
        Seq seq;
        ExecutorCacheTaskLocation[] execs;
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        ExecutorCacheTaskLocation[] allExecs = this.executors();
        TopicPartition tp = part.topicPartition();
        String prefHost = this.preferredHosts().get(tp);
        ExecutorCacheTaskLocation[] prefExecs = prefHost == null ? allExecs : (ExecutorCacheTaskLocation[])Predef$.MODULE$.refArrayOps((Object[])allExecs).filter((Function1)new Serializable(this, prefHost){
            public static final long serialVersionUID = 0L;
            private final String prefHost$1;

            public final boolean apply(ExecutorCacheTaskLocation x$4) {
                String string = x$4.host();
                String string2 = this.prefHost$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.prefHost$1 = prefHost$1;
            }
        });
        ExecutorCacheTaskLocation[] executorCacheTaskLocationArray = execs = Predef$.MODULE$.refArrayOps((Object[])prefExecs).isEmpty() ? allExecs : prefExecs;
        if (Predef$.MODULE$.refArrayOps((Object[])execs).isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            int index = Math.floorMod(tp.hashCode(), execs.length);
            ExecutorCacheTaskLocation chosen = execs[index];
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{chosen.toString()}));
        }
        return seq;
    }

    public String org$apache$spark$streaming$kafka010$KafkaRDD$$errBeginAfterEnd(KafkaRDDPartition part) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is after the ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.fromOffset()), BoxesRunTime.boxToLong((long)part.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{part.topic(), BoxesRunTime.boxToInteger((int)part.partition())}))).append((Object)"You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
    }

    public Iterator<ConsumerRecord<K, V>> compute(Partition thePart, TaskContext context) {
        Iterator iterator;
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        Predef$.MODULE$.require(part.fromOffset() <= part.untilOffset(), (Function0)new Serializable(this, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRDD $outer;
            private final KafkaRDDPartition part$1;

            public final String apply() {
                return this.$outer.org$apache$spark$streaming$kafka010$KafkaRDD$$errBeginAfterEnd(this.part$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.part$1 = part$1;
            }
        });
        if (part.fromOffset() == part.untilOffset()) {
            this.logInfo((Function0)new Serializable(this, part){
                public static final long serialVersionUID = 0L;
                private final KafkaRDDPartition part$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is the same as ending offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.part$1.fromOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.part$1.topic(), BoxesRunTime.boxToInteger((int)this.part$1.partition())}))).toString();
                }
                {
                    this.part$1 = part$1;
                }
            });
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            this.logInfo((Function0)new Serializable(this, part){
                public static final long serialVersionUID = 0L;
                private final KafkaRDDPartition part$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Computing topic ", ", partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.part$1.topic(), BoxesRunTime.boxToInteger((int)this.part$1.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.part$1.fromOffset()), BoxesRunTime.boxToLong((long)this.part$1.untilOffset())}))).toString();
                }
                {
                    this.part$1 = part$1;
                }
            });
            iterator = this.compacted() ? new CompactedKafkaRDDIterator(part, context, this.kafkaParams(), this.useConsumerCache, this.pollTimeout(), this.cacheInitialCapacity(), this.cacheMaxCapacity(), this.cacheLoadFactor()) : new KafkaRDDIterator(part, context, this.kafkaParams(), this.useConsumerCache, this.pollTimeout(), this.cacheInitialCapacity(), this.cacheMaxCapacity(), this.cacheLoadFactor());
        }
        return iterator;
    }

    public KafkaRDD(SparkContext sc, Map<String, Object> kafkaParams, OffsetRange[] offsetRanges, Map<TopicPartition, String> preferredHosts, boolean useConsumerCache) {
        this.kafkaParams = kafkaParams;
        this.offsetRanges = offsetRanges;
        this.preferredHosts = preferredHosts;
        this.useConsumerCache = useConsumerCache;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        Predef$.MODULE$.require("none".equals((String)kafkaParams.get("auto.offset.reset")), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "auto.offset.reset must be set to none for executor kafka params, else messages may not match offsetRange";
            }
        });
        Predef$.MODULE$.require(false == BoxesRunTime.unboxToBoolean((Object)kafkaParams.get("enable.auto.commit")), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "enable.auto.commit must be set to false for executor kafka params, else offsets may commit before processing";
            }
        });
        this.pollTimeout = this.conf().getLong("spark.streaming.kafka.consumer.poll.ms", this.conf().getTimeAsMs("spark.network.timeout", "120s"));
        this.cacheInitialCapacity = this.conf().getInt("spark.streaming.kafka.consumer.cache.initialCapacity", 16);
        this.cacheMaxCapacity = this.conf().getInt("spark.streaming.kafka.consumer.cache.maxCapacity", 64);
        this.cacheLoadFactor = (float)this.conf().getDouble("spark.streaming.kafka.consumer.cache.loadFactor", 0.75);
        this.compacted = this.conf().getBoolean("spark.streaming.kafka.allowNonConsecutiveOffsets", false);
    }
}

