/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.RateStreamOffset;
import org.apache.spark.sql.execution.streaming.ValueRunTimeMsPair;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousInputPartition;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamPartitionOffset;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.sources.v2.reader.streaming.PartitionOffset;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001E\u0011!DU1uKN#(/Z1n\u0007>tG/\u001b8v_V\u001c(+Z1eKJT!a\u0001\u0003\u0002\u0015\r|g\u000e^5ok>,8O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\"\u0004\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!A.\u00198h\u0015\u00059\u0012\u0001\u00026bm\u0006L!!\u0007\u000b\u0003\r=\u0013'.Z2u!\tY2%D\u0001\u001d\u0015\t)QD\u0003\u0002\u001f?\u00051!/Z1eKJT!\u0001I\u0011\u0002\u0005Y\u0014$B\u0001\u0012\t\u0003\u001d\u0019x.\u001e:dKNL!\u0001\n\u000f\u0003!\r{g\u000e^5ok>,8OU3bI\u0016\u0014\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000f=\u0004H/[8ogB\u0011\u0001&K\u0007\u0002?%\u0011!f\b\u0002\u0012\t\u0006$\u0018mU8ve\u000e,w\n\u001d;j_:\u001c\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\b\u0006\u0002/aA\u0011q\u0006A\u0007\u0002\u0005!)ae\u000ba\u0001O!9!\u0007\u0001b\u0001\n\u0007\u0019\u0014A\u00043fM\u0006,H\u000e\u001e$pe6\fGo]\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011qGD\u0001\u0007UN|g\u000eN:\n\u0005e2$A\u0004#fM\u0006,H\u000e\u001e$pe6\fGo\u001d\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u001f\u0011,g-Y;mi\u001a{'/\\1ug\u0002Bq!\u0010\u0001C\u0002\u0013\u0005a(\u0001\u0007de\u0016\fG/[8o)&lW-F\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0011auN\\4\t\r\u0019\u0003\u0001\u0015!\u0003@\u00035\u0019'/Z1uS>tG+[7fA!9\u0001\n\u0001b\u0001\n\u0003I\u0015!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001K!\t\u00015*\u0003\u0002M\u0003\n\u0019\u0011J\u001c;\t\r9\u0003\u0001\u0015!\u0003K\u00039qW/\u001c)beRLG/[8og\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005a(A\u0007s_^\u001c\b+\u001a:TK\u000e|g\u000e\u001a\u0005\u0007%\u0002\u0001\u000b\u0011B \u0002\u001dI|wo\u001d)feN+7m\u001c8eA!9A\u000b\u0001b\u0001\n\u0003)\u0016\u0001\u00059feB\u000b'\u000f^5uS>t'+\u0019;f+\u00051\u0006C\u0001!X\u0013\tA\u0016I\u0001\u0004E_V\u0014G.\u001a\u0005\u00075\u0002\u0001\u000b\u0011\u0002,\u0002#A,'\u000fU1si&$\u0018n\u001c8SCR,\u0007\u0005C\u0003]\u0001\u0011\u0005S,\u0001\u0007nKJ<Wm\u00144gg\u0016$8\u000f\u0006\u0002_CB\u00111dX\u0005\u0003Ar\u0011aa\u00144gg\u0016$\b\"\u00022\\\u0001\u0004\u0019\u0017aB8gMN,Go\u001d\t\u0004\u0001\u00124\u0017BA3B\u0005\u0015\t%O]1z!\tYr-\u0003\u0002i9\ty\u0001+\u0019:uSRLwN\\(gMN,G\u000fC\u0003k\u0001\u0011\u00053.A\teKN,'/[1mSj,wJ\u001a4tKR$\"A\u00187\t\u000b5L\u0007\u0019\u00018\u0002\t)\u001cxN\u001c\t\u0003_Zt!\u0001\u001d;\u0011\u0005E\fU\"\u0001:\u000b\u0005M\u0004\u0012A\u0002\u001fs_>$h(\u0003\u0002v\u0003\u00061\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)\u0018\tC\u0003{\u0001\u0011\u000530\u0001\u0006sK\u0006$7k\u00195f[\u0006$\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}D\u0011!\u0002;za\u0016\u001c\u0018bAA\u0002}\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013%\u0011\u0011B\u0001\u0007_\u001a47/\u001a;\u0016\u0003yC1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010\u0005QqN\u001a4tKR|F%Z9\u0015\t\u0005E\u0011q\u0003\t\u0004\u0001\u0006M\u0011bAA\u000b\u0003\n!QK\\5u\u0011%\tI\"a\u0003\u0002\u0002\u0003\u0007a,A\u0002yIEB!\"!\b\u0001\u0001\u0004\u0005\t\u0015)\u0003_\u0003\u001dygMZ:fi\u0002Bq!!\t\u0001\t\u0003\n\u0019#\u0001\btKR\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\t\u0005E\u0011Q\u0005\u0005\t\u0003\u000f\ty\u00021\u0001\u0002(A)\u0011\u0011FA\u0018=6\u0011\u00111\u0006\u0006\u0004\u0003[1\u0012\u0001B;uS2LA!!\r\u0002,\tAq\n\u001d;j_:\fG\u000eC\u0004\u00026\u0001!\t%a\u000e\u0002\u001d\u001d,Go\u0015;beR|eMZ:fiR\ta\fC\u0004\u0002<\u0001!\t%!\u0010\u0002'Ad\u0017M\\%oaV$\b+\u0019:uSRLwN\\:\u0015\u0005\u0005}\u0002CBA\u0015\u0003\u0003\n)%\u0003\u0003\u0002D\u0005-\"\u0001\u0002'jgR\u0004b!a\u0012\u0002J\u00055S\"A\u000f\n\u0007\u0005-SD\u0001\bJ]B,H\u000fU1si&$\u0018n\u001c8\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\t\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA,\u0003#\u00121\"\u00138uKJt\u0017\r\u001c*po\"9\u00111\f\u0001\u0005B\u0005u\u0013AB2p[6LG\u000f\u0006\u0003\u0002\u0012\u0005}\u0003bBA1\u00033\u0002\rAX\u0001\u0004K:$\u0007bBA3\u0001\u0011\u0005\u0013qM\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002\u0012!9\u00111\u000e\u0001\u0005\n\u00055\u0014aE2sK\u0006$X-\u00138ji&\fGn\u00144gg\u0016$HCBA8\u0003o\nI\b\u0005\u0003\u0002r\u0005MT\"\u0001\u0003\n\u0007\u0005UDA\u0001\tSCR,7\u000b\u001e:fC6|eMZ:fi\"1\u0001*!\u001bA\u0002)Cq!a\u001f\u0002j\u0001\u0007q(\u0001\bde\u0016\fG/[8o)&lW-T:")
public class RateStreamContinuousReader
implements ContinuousReader {
    private final DefaultFormats defaultFormats = DefaultFormats$.MODULE$;
    private final long creationTime = System.currentTimeMillis();
    private final int numPartitions;
    private final long rowsPerSecond;
    private final double perPartitionRate;
    private Offset offset;

    @Override
    public boolean needsReconfiguration() {
        return ContinuousReader.super.needsReconfiguration();
    }

    public DefaultFormats defaultFormats() {
        return this.defaultFormats;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public long rowsPerSecond() {
        return this.rowsPerSecond;
    }

    public double perPartitionRate() {
        return this.perPartitionRate;
    }

    @Override
    public Offset mergeOffsets(PartitionOffset[] offsets) {
        Predef$.MODULE$.assert(offsets.length == this.numPartitions());
        Tuple2[] tuples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsets)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionOffset partitionOffset = x0$1;
            if (!(partitionOffset instanceof RateStreamPartitionOffset)) {
                throw new MatchError((Object)partitionOffset);
            }
            RateStreamPartitionOffset rateStreamPartitionOffset = (RateStreamPartitionOffset)partitionOffset;
            int i = rateStreamPartitionOffset.partition();
            long currVal = rateStreamPartitionOffset.currentValue();
            long nextRead = rateStreamPartitionOffset.currentTimeMs();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ValueRunTimeMsPair(currVal, nextRead));
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuples))));
    }

    @Override
    public Offset deserializeOffset(String json) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Serialization$.MODULE$.read(json, (Formats)this.defaultFormats(), ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ValueRunTimeMsPair.class)})))));
    }

    @Override
    public StructType readSchema() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    private Offset offset() {
        return this.offset;
    }

    private void offset_$eq(Offset x$1) {
        this.offset = x$1;
    }

    @Override
    public void setStartOffset(Optional<Offset> offset) {
        this.offset_$eq(offset.orElse(this.createInitialOffset(this.numPartitions(), this.creationTime())));
    }

    @Override
    public Offset getStartOffset() {
        return this.offset();
    }

    @Override
    public List<InputPartition<InternalRow>> planInputPartitions() {
        Offset offset = this.offset();
        if (!(offset instanceof RateStreamOffset)) {
            throw new IllegalArgumentException(new StringBuilder(45).append("invalid offset type ").append(offset.getClass()).append(" for ContinuousRateSource").toString());
        }
        RateStreamOffset rateStreamOffset = (RateStreamOffset)offset;
        Map<Object, ValueRunTimeMsPair> map = rateStreamOffset.partitionToValueAndRunTimeMs();
        Map<Object, ValueRunTimeMsPair> partitionStartMap = map;
        if (partitionStartMap.keySet().size() != this.numPartitions()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("The previous run contained ").append(partitionStartMap.keySet().size()).append(" partitions, but").append(new StringBuilder(63).append(" ").append(this.numPartitions()).append(" partitions are currently configured. The numPartitions option").toString()).append(" cannot be changed.").toString());
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Range().apply(0, this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> RateStreamContinuousReader.$anonfun$planInputPartitions$1(this, partitionStartMap, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    private RateStreamOffset createInitialOffset(int numPartitions, long creationTimeMs) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((TraversableOnce)package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable & scala.Serializable)i -> RateStreamContinuousReader.$anonfun$createInitialOffset$1(numPartitions, creationTimeMs, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ InputPartition $anonfun$planInputPartitions$1(RateStreamContinuousReader $this, Map partitionStartMap$1, int i) {
        ValueRunTimeMsPair start = (ValueRunTimeMsPair)partitionStartMap$1.apply((Object)BoxesRunTime.boxToInteger((int)i));
        return new RateStreamContinuousInputPartition(start.value(), start.runTimeMs(), i, $this.numPartitions(), $this.perPartitionRate());
    }

    public static final /* synthetic */ Tuple2 $anonfun$createInitialOffset$1(int numPartitions$1, long creationTimeMs$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ValueRunTimeMsPair(i - numPartitions$1, creationTimeMs$1));
    }

    public RateStreamContinuousReader(DataSourceOptions options) {
        this.numPartitions = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse("5"))).toInt();
        this.rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).orElse("6"))).toLong();
        this.perPartitionRate = (double)this.rowsPerSecond() / (double)this.numPartitions();
    }
}

