/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=wAB\u0001\u0003\u0011\u0003#\u0001#A\tSk:dUM\\4uQ\u0016s7m\u001c3j]\u001eT!a\u0001\u0003\u0002\u0017\r|W\u000e\u001d:fgNLwN\u001c\u0006\u0003\u000b\u0019\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014x\r\u0005\u0002\u0012%5\t!A\u0002\u0004\u0014\u0005!\u0005E\u0001\u0006\u0002\u0012%VtG*\u001a8hi\",enY8eS:<7#\u0002\n\u00167y\t\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u00129%\u0011QD\u0001\u0002\u0012\u0007>l\u0007O]3tg&|gnU2iK6,\u0007C\u0001\f \u0013\t\u0001sCA\u0004Qe>$Wo\u0019;\u0011\u0005Y\u0011\u0013BA\u0012\u0018\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015)#\u0003\"\u0001(\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\t\t\u000f%\u0012\"\u0019!C!U\u00051A/\u001f9f\u0013\u0012,\u0012a\u000b\t\u0003-1J!!L\f\u0003\u0007%sG\u000f\u0003\u00040%\u0001\u0006IaK\u0001\bif\u0004X-\u00133!\u0011\u0015\t$\u0003\"\u00113\u0003\u001d)gnY8eKJ,2aMA\u001d)\r!\u00141\b\t\u0005kY\n9$D\u0001\u0013\r\u00119$\u0003\u0001\u001d\u0003\u000f\u0015s7m\u001c3feV\u0011\u0011HP\n\u0004mUQ\u0004cA\t<y%\u0011qG\u0001\t\u0003{yb\u0001\u0001B\u0003@m\t\u0007\u0001IA\u0001U#\t\tE\t\u0005\u0002\u0017\u0005&\u00111i\u0006\u0002\b\u001d>$\b.\u001b8h!\t)\u0005*D\u0001G\u0015\t9\u0005\"A\u0003usB,7/\u0003\u0002J\r\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\t\u0011-3$\u0011!Q\u0001\n1\u000b!bY8mk6tG+\u001f9f!\rie\nP\u0007\u0002\t%\u0011q\n\u0002\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016DQ!\n\u001c\u0005\u0002E#\"AU*\u0011\u0007U2D\bC\u0003L!\u0002\u0007A\nC\u0004Vm\u0001\u0007I\u0011\u0002\u0016\u0002#}+hnY8naJ,7o]3e'&TX\rC\u0004Xm\u0001\u0007I\u0011\u0002-\u0002+}+hnY8naJ,7o]3e'&TXm\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003-iK!aW\f\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001,\u0003\rAH%\r\u0005\u0007?Z\u0002\u000b\u0015B\u0016\u0002%}+hnY8naJ,7o]3e'&TX\r\t\u0005\bCZ\u0002\r\u0011\"\u0003+\u0003=y6m\\7qe\u0016\u001c8/\u001a3TSj,\u0007bB27\u0001\u0004%I\u0001Z\u0001\u0014?\u000e|W\u000e\u001d:fgN,GmU5{K~#S-\u001d\u000b\u00033\u0016Dq!\u00182\u0002\u0002\u0003\u00071\u0006\u0003\u0004hm\u0001\u0006KaK\u0001\u0011?\u000e|W\u000e\u001d:fgN,GmU5{K\u0002Bq!\u001b\u001cC\u0002\u0013%!.A\u0005mCN$h+\u00197vKV\t1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\b\"\u0001\u0005dCR\fG._:u\u0013\t\u0011XNA\nTa\u0016\u001c\u0017NZ5d\u0013:$XM\u001d8bYJ{w\u000f\u0003\u0004um\u0001\u0006Ia[\u0001\u000bY\u0006\u001cHOV1mk\u0016\u0004\u0003b\u0002<7\u0001\u0004%IAK\u0001\bY\u0006\u001cHOU;o\u0011\u001dAh\u00071A\u0005\ne\f1\u0002\\1tiJ+hn\u0018\u0013fcR\u0011\u0011L\u001f\u0005\b;^\f\t\u00111\u0001,\u0011\u0019ah\u0007)Q\u0005W\u0005AA.Y:u%Vt\u0007\u0005C\u0003\u007fm\u0011\u0005#&\u0001\tv]\u000e|W\u000e\u001d:fgN,GmU5{K\"1\u0011\u0011\u0001\u001c\u0005B)\nabY8naJ,7o]3e'&TX\rC\u0004\u0002\u0006Y\"\t%a\u0002\u00025\u001d\fG\u000f[3s\u0007>l\u0007O]3tg&\u0014\u0017\u000e\\5usN#\u0018\r^:\u0015\u000be\u000bI!!\u0006\t\u0011\u0005-\u00111\u0001a\u0001\u0003\u001b\t1A]8x!\u0011\ty!!\u0005\u000e\u0003=L1!a\u0005p\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005]\u00111\u0001a\u0001W\u00059qN\u001d3j]\u0006d\u0007bBA\u000em\u0011\u0005\u0013QD\u0001\tG>l\u0007O]3tgR1\u0011qDA\u0018\u0003g\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0002oS>T!!!\u000b\u0002\t)\fg/Y\u0005\u0005\u0003[\t\u0019C\u0001\u0006CsR,')\u001e4gKJD\u0001\"!\r\u0002\u001a\u0001\u0007\u0011qD\u0001\u0005MJ|W\u000e\u0003\u0005\u00026\u0005e\u0001\u0019AA\u0010\u0003\t!x\u000eE\u0002>\u0003s!Qa\u0010\u0019C\u0002\u0001Caa\u0013\u0019A\u0002\u0005u\u0002\u0003B'O\u0003oAq!!\u0011\u0013\t\u0003\n\u0019%A\u0004eK\u000e|G-\u001a:\u0016\t\u0005\u0015#\u0011\f\u000b\u0007\u0003\u000f\u0012YF!\u0018\u0011\u000bU\nIEa\u0016\u0007\r\u0005-#\u0003AA'\u0005\u001d!UmY8eKJ,B!a\u0014\u0002XM)\u0011\u0011J\u000b\u0002RA)\u0011#a\u0015\u0002V%\u0019\u00111\n\u0002\u0011\u0007u\n9\u0006\u0002\u0004@\u0003\u0013\u0012\r\u0001\u0011\u0005\f\u00037\nIE!A!\u0002\u0013\ty\"\u0001\u0004ck\u001a4WM\u001d\u0005\u000b\u0017\u0006%#\u0011!Q\u0001\n\u0005}\u0003\u0003B'O\u0003+Bq!JA%\t\u0003\t\u0019\u0007\u0006\u0004\u0002f\u0005\u001d\u0014\u0011\u000e\t\u0006k\u0005%\u0013Q\u000b\u0005\t\u00037\n\t\u00071\u0001\u0002 !91*!\u0019A\u0002\u0005}\u0003\"CA7\u0003\u0013\u0002\r\u0011\"\u0003+\u0003\r\u0011XO\u001c\u0005\u000b\u0003c\nI\u00051A\u0005\n\u0005M\u0014a\u0002:v]~#S-\u001d\u000b\u00043\u0006U\u0004\u0002C/\u0002p\u0005\u0005\t\u0019A\u0016\t\u0011\u0005e\u0014\u0011\nQ!\n-\nAA];oA!I\u0011QPA%\u0001\u0004%IAK\u0001\u000bm\u0006dW/Z\"pk:$\bBCAA\u0003\u0013\u0002\r\u0011\"\u0003\u0002\u0004\u0006qa/\u00197vK\u000e{WO\u001c;`I\u0015\fHcA-\u0002\u0006\"AQ,a \u0002\u0002\u0003\u00071\u0006\u0003\u0005\u0002\n\u0006%\u0003\u0015)\u0003,\u0003-1\u0018\r\\;f\u0007>,h\u000e\u001e\u0011\t\u0019\u00055\u0015\u0011\na\u0001\u0002\u0004%I!a$\u0002\u0019\r,(O]3oiZ\u000bG.^3\u0016\u0005\u0005E\u0005\u0003BA+\u0003'K1!!&I\u00051Ie\u000e^3s]\u0006dG+\u001f9f\u00111\tI*!\u0013A\u0002\u0003\u0007I\u0011BAN\u0003A\u0019WO\u001d:f]R4\u0016\r\\;f?\u0012*\u0017\u000fF\u0002Z\u0003;C\u0011\"XAL\u0003\u0003\u0005\r!!%\t\u0019\u0005\u0005\u0016\u0011\na\u0001\u0002\u0003\u0006K!!%\u0002\u001b\r,(O]3oiZ\u000bG.^3!\u0011!\t)+!\u0013\u0005B\u0005\u001d\u0016\u0001\u00028fqR$R!WAU\u0003WC\u0001\"a\u0003\u0002$\u0002\u0007\u0011Q\u0002\u0005\b\u0003/\t\u0019\u000b1\u0001,\u0011!\ty+!\u0013\u0005B\u0005E\u0016a\u00025bg:+\u0007\u0010^\u000b\u0003\u0003g\u00032AFA[\u0013\r\t9l\u0006\u0002\b\u0005>|G.Z1o\u0011!\tY,!\u0013\u0005\n\u0005u\u0016A\u00039vi\n{w\u000e\\3b]R9\u0011,a0\u0002P\u0006M\u0007\u0002CAa\u0003s\u0003\r!a1\u0002\u0019\r|G.^7o-\u0016\u001cGo\u001c:\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fT1!!3\u0007\u0003)1Xm\u0019;pe&TX\rZ\u0005\u0005\u0003\u001b\f9M\u0001\u000bXe&$\u0018M\u00197f\u0007>dW/\u001c8WK\u000e$xN\u001d\u0005\b\u0003#\fI\f1\u0001,\u0003\r\u0001xn\u001d\u0005\t\u0003+\fI\f1\u0001\u0002X\u0006)a/\u00197vKB\u0019a#!7\n\u0007\u0005mwC\u0001\u0003M_:<\u0007\u0002CAp\u0003\u0013\"I!!9\u0002\u000f\u001d,GOQ=uKR!\u0011q[Ar\u0011!\tY&!8A\u0002\u0005}\u0001\u0002CAt\u0003\u0013\"I!!;\u0002\u000fA,HOQ=uKR9\u0011,a;\u0002n\u0006=\b\u0002CAa\u0003K\u0004\r!a1\t\u000f\u0005E\u0017Q\u001da\u0001W!A\u0011Q[As\u0001\u0004\t9\u000e\u0003\u0005\u0002t\u0006%C\u0011BA{\u0003!9W\r^*i_J$H\u0003BAl\u0003oD\u0001\"a\u0017\u0002r\u0002\u0007\u0011q\u0004\u0005\t\u0003w\fI\u0005\"\u0003\u0002~\u0006A\u0001/\u001e;TQ>\u0014H\u000fF\u0004Z\u0003\u007f\u0014\tAa\u0001\t\u0011\u0005\u0005\u0017\u0011 a\u0001\u0003\u0007Dq!!5\u0002z\u0002\u00071\u0006\u0003\u0005\u0002V\u0006e\b\u0019AAl\u0011!\u00119!!\u0013\u0005\n\t%\u0011AB4fi&sG\u000f\u0006\u0003\u0002X\n-\u0001\u0002CA.\u0005\u000b\u0001\r!a\b\t\u0011\t=\u0011\u0011\nC\u0005\u0005#\ta\u0001];u\u0013:$HcB-\u0003\u0014\tU!q\u0003\u0005\t\u0003\u0003\u0014i\u00011\u0001\u0002D\"9\u0011\u0011\u001bB\u0007\u0001\u0004Y\u0003\u0002CAk\u0005\u001b\u0001\r!a6\t\u0011\tm\u0011\u0011\nC\u0005\u0005;\tqaZ3u\u0019>tw\r\u0006\u0003\u0002X\n}\u0001\u0002CA.\u00053\u0001\r!a\b\t\u0011\t\r\u0012\u0011\nC\u0005\u0005K\tq\u0001];u\u0019>tw\rF\u0004Z\u0005O\u0011ICa\u000b\t\u0011\u0005\u0005'\u0011\u0005a\u0001\u0003\u0007Dq!!5\u0003\"\u0001\u00071\u0006\u0003\u0005\u0002V\n\u0005\u0002\u0019AAl\u0011!\u0011y#!\u0013\u0005\n\tE\u0012a\u00033fG>l\u0007O]3tgB\"\u0012\"\u0017B\u001a\u0005k\u0011IDa\u0011\t\u0011\u0005\u0005'Q\u0006a\u0001\u0003\u0007DqAa\u000e\u0003.\u0001\u00071&\u0001\u0005dCB\f7-\u001b;z\u0011!\u0011YD!\fA\u0002\tu\u0012aC4fi\u001a+hn\u0019;j_:\u0004rA\u0006B \u0003?\t9.C\u0002\u0003B]\u0011\u0011BR;oGRLwN\\\u0019\t\u0011\t\u0015#Q\u0006a\u0001\u0005\u000f\n1\u0002];u\rVt7\r^5p]BIaC!\u0013\u0002D.\n9.W\u0005\u0004\u0005\u0017:\"!\u0003$v]\u000e$\u0018n\u001c84\u0011!\u0011y%!\u0013\u0005B\tE\u0013A\u00033fG>l\u0007O]3tgR)\u0011La\u0015\u0003V!A\u0011\u0011\u0019B'\u0001\u0004\t\u0019\rC\u0004\u00038\t5\u0003\u0019A\u0016\u0011\u0007u\u0012I\u0006\u0002\u0004@\u0003\u007f\u0011\r\u0001\u0011\u0005\t\u00037\ny\u00041\u0001\u0002 !91*a\u0010A\u0002\t}\u0003\u0003B'O\u0005/BqAa\u0019\u0013\t\u0003\u0012)'\u0001\u0005tkB\u0004xN\u001d;t)\u0011\t\u0019La\u001a\t\u000f-\u0013\t\u00071\u0001\u0003jA\"!1\u000eB:!\u0015i%Q\u000eB9\u0013\r\u0011y\u0007\u0002\u0002\u000b\u0007>dW/\u001c8UsB,\u0007cA\u001f\u0003t\u0011a!Q\u000fB4\u0003\u0003\u0005\tQ!\u0001\u0003x\t\u0019q\f\n\u001a\u0012\u0007\u0005\u0013I\bE\u0002\u0017\u0005wJ1A! \u0018\u0005\r\te.\u001f\u0005\n\u0005\u0003\u0013\u0012\u0011!C!\u0005\u0007\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001BC!\u0011\u00119I!$\u000e\u0005\t%%\u0002\u0002BF\u0003O\tA\u0001\\1oO&!!q\u0012BE\u0005\u0019\u0019FO]5oO\"A!1\u0013\n\u0002\u0002\u0013\u0005!&\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0003\u0018J\t\t\u0011\"\u0001\u0003\u001a\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B=\u00057C\u0001\"\u0018BK\u0003\u0003\u0005\ra\u000b\u0005\n\u0005?\u0013\u0012\u0011!C!\u0005C\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005G\u0003bA!*\u0003,\neTB\u0001BT\u0015\r\u0011IkF\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BW\u0005O\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0005c\u0013\u0012\u0011!C\u0001\u0005g\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003g\u0013)\fC\u0005^\u0005_\u000b\t\u00111\u0001\u0003z!I!\u0011\u0018\n\u0002\u0002\u0013\u0005#1X\u0001\tQ\u0006\u001c\bnQ8eKR\t1\u0006C\u0005\u0003@J\t\t\u0011\"\u0011\u0003B\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\u0006\"I!Q\u0019\n\u0002\u0002\u0013%!qY\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003JB!!q\u0011Bf\u0013\u0011\u0011iM!#\u0003\r=\u0013'.Z2u\u0001")
public final class RunLengthEncoding {
    public static /* bridge */ org.apache.spark.sql.execution.columnar.compression.Decoder decoder(ByteBuffer byteBuffer, NativeColumnType nativeColumnType) {
        return RunLengthEncoding$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static /* bridge */ org.apache.spark.sql.execution.columnar.compression.Encoder encoder(NativeColumnType nativeColumnType) {
        return RunLengthEncoding$.MODULE$.encoder(nativeColumnType);
    }

    public static String toString() {
        return RunLengthEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return RunLengthEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return RunLengthEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return RunLengthEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return RunLengthEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return RunLengthEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return RunLengthEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return RunLengthEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static int typeId() {
        return RunLengthEncoding$.MODULE$.typeId();
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private int run;
        private int valueCount;
        private Object currentValue;

        private int run() {
            return this.run;
        }

        private void run_$eq(int x$1) {
            this.run = x$1;
        }

        private int valueCount() {
            return this.valueCount;
        }

        private void valueCount_$eq(int x$1) {
            this.valueCount = x$1;
        }

        private Object currentValue() {
            return this.currentValue;
        }

        private void currentValue_$eq(Object x$1) {
            this.currentValue = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            if (this.valueCount() == this.run()) {
                this.currentValue_$eq(this.columnType.extract(this.buffer));
                this.run_$eq(ByteBufferHelper$.MODULE$.getInt(this.buffer));
                this.valueCount_$eq(1);
            } else {
                this.valueCount_$eq(this.valueCount() + 1);
            }
            this.columnType.setField(row, ordinal, this.currentValue());
        }

        @Override
        public boolean hasNext() {
            return this.valueCount() < this.run() || this.buffer.hasRemaining();
        }

        private void putBoolean(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putBoolean(pos, value == 1L);
        }

        private long getByte(ByteBuffer buffer) {
            return buffer.get();
        }

        private void putByte(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putByte(pos, (byte)value);
        }

        private long getShort(ByteBuffer buffer) {
            return buffer.getShort();
        }

        private void putShort(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putShort(pos, (short)value);
        }

        private long getInt(ByteBuffer buffer) {
            return buffer.getInt();
        }

        private void putInt(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putInt(pos, (int)value);
        }

        private long getLong(ByteBuffer buffer) {
            return buffer.getLong();
        }

        private void putLong(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putLong(pos, value);
        }

        private void decompress0(WritableColumnVector columnVector, int capacity, Function1<ByteBuffer, Object> getFunction, Function3<WritableColumnVector, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            int runLocal = 0;
            int valueCountLocal = 0;
            long currentValueLocal = 0L;
            for (int pos = 0; valueCountLocal < runLocal || pos < capacity; ++pos) {
                Object object;
                if (pos != nextNullIndex) {
                    if (valueCountLocal == runLocal) {
                        currentValueLocal = BoxesRunTime.unboxToLong((Object)getFunction.apply((Object)this.buffer));
                        runLocal = ByteBufferHelper$.MODULE$.getInt(this.buffer);
                        valueCountLocal = 1;
                    } else {
                        ++valueCountLocal;
                    }
                    object = putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)pos), (Object)BoxesRunTime.boxToLong((long)currentValueLocal));
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
                object = BoxedUnit.UNIT;
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int capacity) {
            T t = this.columnType.dataType();
            if (t instanceof BooleanType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putBoolean(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ByteType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putByte(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ShortType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getShort(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putShort(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof IntegerType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getInt(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putInt(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getLong(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putLong(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in RunLengthEncoding.");
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.run = 0;
            this.valueCount = 0;
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private int _compressedSize;
        private final SpecificInternalRow lastValue;
        private int lastRun;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private int _compressedSize() {
            return this._compressedSize;
        }

        private void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        private SpecificInternalRow lastValue() {
            return this.lastValue;
        }

        private int lastRun() {
            return this.lastRun;
        }

        private void lastRun_$eq(int x$1) {
            this.lastRun = x$1;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Object value = this.columnType.getField(row, ordinal);
            int actualSize = this.columnType.actualSize(row, ordinal);
            this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
            if (this.lastValue().isNullAt(0)) {
                this.columnType.copyField(row, ordinal, (InternalRow)this.lastValue(), 0);
                this.lastRun_$eq(1);
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
            } else if (BoxesRunTime.equals(this.columnType.getField((InternalRow)this.lastValue(), 0), value)) {
                this.lastRun_$eq(this.lastRun() + 1);
            } else {
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
                this.columnType.copyField(row, ordinal, (InternalRow)this.lastValue(), 0);
                this.lastRun_$eq(1);
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            Object object;
            to.putInt(RunLengthEncoding$.MODULE$.typeId());
            if (from.hasRemaining()) {
                SpecificInternalRow currentValue = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{this.columnType.dataType()})));
                int currentRun = 1;
                SpecificInternalRow value = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{this.columnType.dataType()})));
                this.columnType.extract(from, (InternalRow)currentValue, 0);
                while (from.hasRemaining()) {
                    this.columnType.extract(from, (InternalRow)value, 0);
                    if (BoxesRunTime.equals((Object)value.get(0, this.columnType.dataType()), (Object)currentValue.get(0, this.columnType.dataType()))) {
                        ++currentRun;
                        continue;
                    }
                    this.columnType.append((InternalRow)currentValue, 0, to);
                    to.putInt(currentRun);
                    this.columnType.copyField((InternalRow)value, 0, (InternalRow)currentValue, 0);
                    currentRun = 1;
                }
                this.columnType.append((InternalRow)currentValue, 0, to);
                object = to.putInt(currentRun);
            } else {
                object = BoxedUnit.UNIT;
            }
            to.rewind();
            return to;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this._compressedSize = 0;
            this.lastValue = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{columnType.dataType()})));
            this.lastRun = 0;
        }
    }
}

