/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StringType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tMuAB\u0001\u0003\u0011\u0003#\u0001#\u0001\nES\u000e$\u0018n\u001c8bef,enY8eS:<'BA\u0002\u0005\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011\u0001C2pYVlg.\u0019:\u000b\u0005\u001dA\u0011!C3yK\u000e,H/[8o\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'o\u001a\t\u0003#Ii\u0011A\u0001\u0004\u0007'\tA\t\t\u0002\u000b\u0003%\u0011K7\r^5p]\u0006\u0014\u00180\u00128d_\u0012LgnZ\n\u0006%UYb$\t\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Ea\u0012BA\u000f\u0003\u0005E\u0019u.\u001c9sKN\u001c\u0018n\u001c8TG\",W.\u001a\t\u0003-}I!\u0001I\f\u0003\u000fA\u0013x\u000eZ;diB\u0011aCI\u0005\u0003G]\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ!\n\n\u0005\u0002\u001d\na\u0001P5oSRt4\u0001\u0001\u000b\u0002!!9\u0011F\u0005b\u0001\n\u0003R\u0013A\u0002;za\u0016LE-F\u0001,!\t1B&\u0003\u0002./\t\u0019\u0011J\u001c;\t\r=\u0012\u0002\u0015!\u0003,\u0003\u001d!\u0018\u0010]3JI\u0002Bq!\r\nC\u0002\u0013\u0005!'A\u0007N\u0003b{F)S\"U?NK%,R\u000b\u0002gA\u0011a\u0003N\u0005\u0003k]\u0011Qa\u00155peRDaa\u000e\n!\u0002\u0013\u0019\u0014AD'B1~#\u0015j\u0011+`'&SV\t\t\u0005\u0006sI!\tEO\u0001\bI\u0016\u001cw\u000eZ3s+\rY\u0014Q\r\u000b\u0006y\u0005\u001d\u0014\u0011\u000e\t\u0005{y\n\u0019'D\u0001\u0013\r\u0011y$\u0003\u0001!\u0003\u000f\u0011+7m\u001c3feV\u0011\u0011IR\n\u0004}U\u0011\u0005cA\tD\t&\u0011qH\u0001\t\u0003\u000b\u001ac\u0001\u0001B\u0003H}\t\u0007\u0001JA\u0001U#\tIE\n\u0005\u0002\u0017\u0015&\u00111j\u0006\u0002\b\u001d>$\b.\u001b8h!\ti\u0005+D\u0001O\u0015\ty\u0005\"A\u0003usB,7/\u0003\u0002R\u001d\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\t\u0011Ms$\u0011!Q\u0001\nQ\u000baAY;gM\u0016\u0014\bCA+[\u001b\u00051&BA,Y\u0003\rq\u0017n\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0006CsR,')\u001e4gKJD\u0001\"\u0018 \u0003\u0002\u0003\u0006IAX\u0001\u000bG>dW/\u001c8UsB,\u0007cA0a\t6\tA!\u0003\u0002b\t\t\u0001b*\u0019;jm\u0016\u001cu\u000e\\;n]RK\b/\u001a\u0005\u0006Ky\"\ta\u0019\u000b\u0004I\u00164\u0007cA\u001f?\t\")1K\u0019a\u0001)\")QL\u0019a\u0001=\"9\u0001N\u0010b\u0001\n\u0003Q\u0013AC3mK6,g\u000e\u001e(v[\"1!N\u0010Q\u0001\n-\n1\"\u001a7f[\u0016tGOT;nA!9AN\u0010b\u0001\n\u0013i\u0017A\u00033jGRLwN\\1ssV\ta\u000eE\u0002\u0017_FL!\u0001]\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Y\u0011\u0018BA:\u0018\u0005\r\te.\u001f\u0005\u0007kz\u0002\u000b\u0011\u00028\u0002\u0017\u0011L7\r^5p]\u0006\u0014\u0018\u0010\t\u0005\boz\u0002\r\u0011\"\u0003y\u00035Ig\u000e\u001e#jGRLwN\\1ssV\t\u0011\u0010E\u0002\u0017_.Bqa\u001f A\u0002\u0013%A0A\tj]R$\u0015n\u0019;j_:\f'/_0%KF$2!`A\u0001!\t1b0\u0003\u0002\u0000/\t!QK\\5u\u0011!\t\u0019A_A\u0001\u0002\u0004I\u0018a\u0001=%c!9\u0011q\u0001 !B\u0013I\u0018AD5oi\u0012K7\r^5p]\u0006\u0014\u0018\u0010\t\u0005\n\u0003\u0017q\u0004\u0019!C\u0005\u0003\u001b\ta\u0002\\8oO\u0012K7\r^5p]\u0006\u0014\u00180\u0006\u0002\u0002\u0010A!ac\\A\t!\r1\u00121C\u0005\u0004\u0003+9\"\u0001\u0002'p]\u001eD\u0011\"!\u0007?\u0001\u0004%I!a\u0007\u0002%1|gn\u001a#jGRLwN\\1ss~#S-\u001d\u000b\u0004{\u0006u\u0001BCA\u0002\u0003/\t\t\u00111\u0001\u0002\u0010!A\u0011\u0011\u0005 !B\u0013\ty!A\bm_:<G)[2uS>t\u0017M]=!\u0011\u001d\t)C\u0010C!\u0003O\tAA\\3yiR)Q0!\u000b\u0002:!A\u00111FA\u0012\u0001\u0004\ti#A\u0002s_^\u0004B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gA\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005]\u0012\u0011\u0007\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002<\u0005\r\u0002\u0019A\u0016\u0002\u000f=\u0014H-\u001b8bY\"9\u0011q\b \u0005B\u0005\u0005\u0013a\u00025bg:+\u0007\u0010^\u000b\u0003\u0003\u0007\u00022AFA#\u0013\r\t9e\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\tYE\u0010C!\u0003\u001b\n!\u0002Z3d_6\u0004(/Z:t)\u0015i\u0018qJA0\u0011!\t\t&!\u0013A\u0002\u0005M\u0013\u0001D2pYVlgNV3di>\u0014\b\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005ec!\u0001\u0006wK\u000e$xN]5{K\u0012LA!!\u0018\u0002X\t!rK]5uC\ndWmQ8mk6tg+Z2u_JDq!!\u0019\u0002J\u0001\u00071&\u0001\u0005dCB\f7-\u001b;z!\r)\u0015Q\r\u0003\u0006\u000fb\u0012\r\u0001\u0013\u0005\u0006'b\u0002\r\u0001\u0016\u0005\u0007;b\u0002\r!a\u001b\u0011\t}\u0003\u00171\r\u0005\b\u0003_\u0012B\u0011IA9\u0003\u001d)gnY8eKJ,B!a\u001d\u0003*Q!\u0011Q\u000fB\u0016!\u0015i\u0014q\u000fB\u0014\r\u0019\tIH\u0005\u0001\u0002|\t9QI\\2pI\u0016\u0014X\u0003BA?\u0003\u000b\u001bR!a\u001e\u0016\u0003\u007f\u0002R!EAA\u0003\u0007K1!!\u001f\u0003!\r)\u0015Q\u0011\u0003\u0007\u000f\u0006]$\u0019\u0001%\t\u0015u\u000b9H!A!\u0002\u0013\tI\t\u0005\u0003`A\u0006\r\u0005bB\u0013\u0002x\u0011\u0005\u0011Q\u0012\u000b\u0005\u0003\u001f\u000b\t\nE\u0003>\u0003o\n\u0019\tC\u0004^\u0003\u0017\u0003\r!!#\t\u0013\u0005U\u0015q\u000fa\u0001\n\u0013Q\u0013!E0v]\u000e|W\u000e\u001d:fgN,GmU5{K\"Q\u0011\u0011TA<\u0001\u0004%I!a'\u0002+}+hnY8naJ,7o]3e'&TXm\u0018\u0013fcR\u0019Q0!(\t\u0013\u0005\r\u0011qSA\u0001\u0002\u0004Y\u0003\u0002CAQ\u0003o\u0002\u000b\u0015B\u0016\u0002%}+hnY8naJ,7o]3e'&TX\r\t\u0005\u000b\u0003K\u000b9\b1A\u0005\n\u0005\u0005\u0013\u0001C8wKJ4Gn\\<\t\u0015\u0005%\u0016q\u000fa\u0001\n\u0013\tY+\u0001\u0007pm\u0016\u0014h\r\\8x?\u0012*\u0017\u000fF\u0002~\u0003[C!\"a\u0001\u0002(\u0006\u0005\t\u0019AA\"\u0011%\t\t,a\u001e!B\u0013\t\u0019%A\u0005pm\u0016\u0014h\r\\8xA!I\u0011QWA<\u0001\u0004%IAK\u0001\u0006G>,h\u000e\u001e\u0005\u000b\u0003s\u000b9\b1A\u0005\n\u0005m\u0016!C2pk:$x\fJ3r)\ri\u0018Q\u0018\u0005\n\u0003\u0007\t9,!AA\u0002-B\u0001\"!1\u0002x\u0001\u0006KaK\u0001\u0007G>,h\u000e\u001e\u0011\t\u0015\u0005\u0015\u0017q\u000fa\u0001\n\u0013\t9-\u0001\u0004wC2,Xm]\u000b\u0003\u0003\u0013\u0004b!a3\u0002V\u0006eWBAAg\u0015\u0011\ty-!5\u0002\u000f5,H/\u00192mK*\u0019\u00111[\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u00065'aC!se\u0006L()\u001e4gKJ\u0004B!a!\u0002\\&\u0019\u0011Q\u001c)\u0003\u0019%sG/\u001a:oC2$\u0016\u0010]3\t\u0015\u0005\u0005\u0018q\u000fa\u0001\n\u0013\t\u0019/\u0001\u0006wC2,Xm]0%KF$2!`As\u0011)\t\u0019!a8\u0002\u0002\u0003\u0007\u0011\u0011\u001a\u0005\n\u0003S\f9\b)Q\u0005\u0003\u0013\fqA^1mk\u0016\u001c\b\u0005C\u0005m\u0003o\u0012\r\u0011\"\u0003\u0002nV\u0011\u0011q\u001e\t\u0007\u0003\u0017\f\t0]\u001a\n\t\u0005M\u0018Q\u001a\u0002\b\u0011\u0006\u001c\b.T1q\u0011!)\u0018q\u000fQ\u0001\n\u0005=\b\"CA}\u0003o\u0002\r\u0011\"\u0003+\u00039!\u0017n\u0019;j_:\f'/_*ju\u0016D!\"!@\u0002x\u0001\u0007I\u0011BA\u0000\u0003I!\u0017n\u0019;j_:\f'/_*ju\u0016|F%Z9\u0015\u0007u\u0014\t\u0001C\u0005\u0002\u0004\u0005m\u0018\u0011!a\u0001W!A!QAA<A\u0003&1&A\beS\u000e$\u0018n\u001c8bef\u001c\u0016N_3!\u0011!\u0011I!a\u001e\u0005B\t-\u0011AG4bi\",'oQ8naJ,7o]5cS2LG/_*uCR\u001cH#B?\u0003\u000e\t=\u0001\u0002CA\u0016\u0005\u000f\u0001\r!!\f\t\u000f\u0005m\"q\u0001a\u0001W!A!1CA<\t\u0003\u0012)\"\u0001\u0005d_6\u0004(/Z:t)\u0015!&q\u0003B\u000e\u0011\u001d\u0011IB!\u0005A\u0002Q\u000bAA\u001a:p[\"9!Q\u0004B\t\u0001\u0004!\u0016A\u0001;p\u0011\u001d\u0011\t#a\u001e\u0005B)\n\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\t\u000f\t\u0015\u0012q\u000fC!U\u0005q1m\\7qe\u0016\u001c8/\u001a3TSj,\u0007cA#\u0003*\u00111q)!\u001cC\u0002!Cq!XA7\u0001\u0004\u0011i\u0003\u0005\u0003`A\n\u001d\u0002b\u0002B\u0019%\u0011\u0005#1G\u0001\tgV\u0004\bo\u001c:ugR!\u00111\tB\u001b\u0011\u001di&q\u0006a\u0001\u0005o\u0001DA!\u000f\u0003BA)qLa\u000f\u0003@%\u0019!Q\b\u0003\u0003\u0015\r{G.^7o)f\u0004X\rE\u0002F\u0005\u0003\"ABa\u0011\u00036\u0005\u0005\t\u0011!B\u0001\u0005\u000b\u00121a\u0018\u00134#\tI\u0015\u000fC\u0005\u0003JI\t\t\u0011\"\u0011\u0003L\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0014\u0011\t\t=#QK\u0007\u0003\u0005#R1Aa\u0015Y\u0003\u0011a\u0017M\\4\n\t\t]#\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\t\u0011\tm##!A\u0005\u0002)\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011Ba\u0018\u0013\u0003\u0003%\tA!\u0019\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0011Oa\u0019\t\u0013\u0005\r!QLA\u0001\u0002\u0004Y\u0003\"\u0003B4%\u0005\u0005I\u0011\tB5\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B6!\u0015\u0011iGa\u001cr\u001b\t\t\t.\u0003\u0003\u0003r\u0005E'\u0001C%uKJ\fGo\u001c:\t\u0013\tU$#!A\u0005\u0002\t]\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r#\u0011\u0010\u0005\n\u0003\u0007\u0011\u0019(!AA\u0002ED\u0011B! \u0013\u0003\u0003%\tEa \u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u000b\u0005\n\u0005\u0007\u0013\u0012\u0011!C!\u0005\u000b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u001bB\u0011B!#\u0013\u0003\u0003%IAa#\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u001b\u0003BAa\u0014\u0003\u0010&!!\u0011\u0013B)\u0005\u0019y%M[3di\u0002")
public final class DictionaryEncoding {
    public static /* bridge */ org.apache.spark.sql.execution.columnar.compression.Encoder encoder(NativeColumnType nativeColumnType) {
        return DictionaryEncoding$.MODULE$.encoder(nativeColumnType);
    }

    public static /* bridge */ org.apache.spark.sql.execution.columnar.compression.Decoder decoder(ByteBuffer byteBuffer, NativeColumnType nativeColumnType) {
        return DictionaryEncoding$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static String toString() {
        return DictionaryEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return DictionaryEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return DictionaryEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return DictionaryEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return DictionaryEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return DictionaryEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return DictionaryEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return DictionaryEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static short MAX_DICT_SIZE() {
        return DictionaryEncoding$.MODULE$.MAX_DICT_SIZE();
    }

    public static int typeId() {
        return DictionaryEncoding$.MODULE$.typeId();
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private final int elementNum;
        private final Object[] dictionary;
        private int[] intDictionary;
        private long[] longDictionary;

        public int elementNum() {
            return this.elementNum;
        }

        private Object[] dictionary() {
            return this.dictionary;
        }

        private int[] intDictionary() {
            return this.intDictionary;
        }

        private void intDictionary_$eq(int[] x$1) {
            this.intDictionary = x$1;
        }

        private long[] longDictionary() {
            return this.longDictionary;
        }

        private void longDictionary_$eq(long[] x$1) {
            this.longDictionary = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.setField(row, ordinal, this.dictionary()[this.buffer.getShort()]);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int pos;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            T t = this.columnType.dataType();
            if (t instanceof IntegerType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.intDictionary()));
                for (pos = 0; pos < capacity; ++pos) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                        continue;
                    }
                    if (++seenNulls < nullCount) {
                        nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                    }
                    columnVector.putNull(pos);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.longDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in DictionaryEncoding.");
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.elementNum = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.dictionary = new Object[this.elementNum()];
            this.intDictionary = null;
            this.longDictionary = null;
            T t = columnType.dataType();
            if (t instanceof IntegerType) {
                this.intDictionary_$eq(new int[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    int v;
                    $this.intDictionary()[i] = v = BoxesRunTime.unboxToInt($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToInteger((int)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.longDictionary_$eq(new long[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    long v;
                    $this.longDictionary()[i] = v = BoxesRunTime.unboxToLong($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToLong((long)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof StringType) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Object v = $this.columnType.extract($this.buffer);
                    $this.dictionary()[i] = v;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(t);
            }
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private boolean overflow;
        private int count;
        private ArrayBuffer<Object> values;
        private final HashMap<Object, Object> dictionary;
        private int dictionarySize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private boolean overflow() {
            return this.overflow;
        }

        private void overflow_$eq(boolean x$1) {
            this.overflow = x$1;
        }

        private int count() {
            return this.count;
        }

        private void count_$eq(int x$1) {
            this.count = x$1;
        }

        private ArrayBuffer<Object> values() {
            return this.values;
        }

        private void values_$eq(ArrayBuffer<Object> x$1) {
            this.values = x$1;
        }

        private HashMap<Object, Object> dictionary() {
            return this.dictionary;
        }

        private int dictionarySize() {
            return this.dictionarySize;
        }

        private void dictionarySize_$eq(int x$1) {
            this.dictionarySize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            block3: {
                Object value = this.columnType.getField(row, ordinal);
                if (this.overflow()) break block3;
                int actualSize = this.columnType.actualSize(row, ordinal);
                this.count_$eq(this.count() + 1);
                this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
                if (!this.dictionary().contains(value)) {
                    if (this.dictionary().size() < DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                        Object clone = this.columnType.clone(value);
                        this.values().$plus$eq(clone);
                        this.dictionarySize_$eq(this.dictionarySize() + actualSize);
                        this.dictionary().update(clone, (Object)BoxesRunTime.boxToShort((short)((short)this.dictionary().size())));
                    } else {
                        this.overflow_$eq(true);
                        this.values().clear();
                        this.dictionary().clear();
                    }
                }
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            if (this.overflow()) {
                throw new IllegalStateException("Dictionary encoding should not be used because of dictionary overflow.");
            }
            to.putInt(DictionaryEncoding$.MODULE$.typeId()).putInt(this.dictionary().size());
            for (int i = 0; i < this.values().length(); ++i) {
                this.columnType.append(this.values().apply(i), to);
            }
            while (from.hasRemaining()) {
                to.putShort(BoxesRunTime.unboxToShort((Object)this.dictionary().apply(this.columnType.extract(from))));
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this.overflow() ? Integer.MAX_VALUE : this.dictionarySize() + this.count() * 2;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this.overflow = false;
            this.count = 0;
            this.values = new ArrayBuffer(1024);
            this.dictionary = HashMap$.MODULE$.empty();
            this.dictionarySize = 4;
        }
    }
}

