/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0001\u0003\u00015\u0011AbQ1dQ\u0016l\u0015M\\1hKJT!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oO\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003)\u0019\u0017m\u00195fI\u0012\u000bG/Y\u000b\u0002EA\u00191\u0005\u000b\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0006MS:\\W\r\u001a'jgR\u0004\"AH\u0016\n\u00051\u0012!AC\"bG\",G\rR1uC\"1a\u0006\u0001Q\u0001\n\t\n1bY1dQ\u0016$G)\u0019;bA!\u0012Q\u0006\r\t\u0003\u001fEJ!A\r\t\u0003\u0013Q\u0014\u0018M\\:jK:$\bb\u0002\u001b\u0001\u0005\u0004%I!N\u0001\nG\u0006\u001c\u0007.\u001a'pG.,\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nQ\u0001\\8dWNT!a\u000f\u0013\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002>q\t1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7\u000e\u0003\u0004@\u0001\u0001\u0006IAN\u0001\u000bG\u0006\u001c\u0007.\u001a'pG.\u0004\u0003F\u0001 1\u0011\u0015\u0011\u0005\u0001\"\u0003D\u0003!\u0011X-\u00193M_\u000e\\WC\u0001#H)\t)\u0005\u000b\u0005\u0002G\u000f2\u0001A!\u0002%B\u0005\u0004I%!A!\u0012\u0005)k\u0005CA\bL\u0013\ta\u0005CA\u0004O_RD\u0017N\\4\u0011\u0005=q\u0015BA(\u0011\u0005\r\te.\u001f\u0005\u0007#\u0006#\t\u0019\u0001*\u0002\u0003\u0019\u00042aD*F\u0013\t!\u0006C\u0001\u0005=Eft\u0017-\\3?\u0011\u00151\u0006\u0001\"\u0003X\u0003%9(/\u001b;f\u0019>\u001c7.\u0006\u0002Y5R\u0011\u0011l\u0017\t\u0003\rj#Q\u0001S+C\u0002%Ca!U+\u0005\u0002\u0004a\u0006cA\bT3\")a\f\u0001C\u0001?\u0006Q1\r\\3be\u000e\u000b7\r[3\u0015\u0003\u0001\u0004\"aD1\n\u0005\t\u0004\"\u0001B+oSRDQ\u0001\u001a\u0001\u0005\u0002\u0015\fq![:F[B$\u00180F\u0001g!\tyq-\u0003\u0002i!\t9!i\\8mK\u0006t\u0007\"\u00026\u0001\t\u0003Y\u0017AC2bG\",\u0017+^3ssR)\u0001\r\u001c<\u0002\u000e!)Q.\u001ba\u0001]\u0006)\u0011/^3ssB\u0012q\u000e\u001e\t\u0004aF\u001cX\"\u0001\u0003\n\u0005I$!a\u0002#bi\u0006\u001cX\r\u001e\t\u0003\rR$\u0011\"\u001e7\u0002\u0002\u0003\u0005)\u0011A%\u0003\u0007}#\u0013\u0007C\u0004xSB\u0005\t\u0019\u0001=\u0002\u0013Q\f'\r\\3OC6,\u0007cA\bzw&\u0011!\u0010\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007q\f9AD\u0002~\u0003\u0007\u0001\"A \t\u000e\u0003}T1!!\u0001\r\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0001\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\u0003\u0003\rM#(/\u001b8h\u0015\r\t)\u0001\u0005\u0005\n\u0003\u001fI\u0007\u0013!a\u0001\u0003#\tAb\u001d;pe\u0006<W\rT3wK2\u0004B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/1\u0011aB:u_J\fw-Z\u0005\u0005\u00037\t)B\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0004\u0002 \u0001!\t!!\t\u0002\u0019Ut7-Y2iKF+XM]=\u0015\u000f\u0001\f\u0019#a\f\u00024!9Q.!\bA\u0002\u0005\u0015\u0002\u0007BA\u0014\u0003W\u0001B\u0001]9\u0002*A\u0019a)a\u000b\u0005\u0017\u00055\u00121EA\u0001\u0002\u0003\u0015\t!\u0013\u0002\u0004?\u0012\u0012\u0004bBA\u0019\u0003;\u0001\rAZ\u0001\bG\u0006\u001c8-\u00193f\u0011%\t)$!\b\u0011\u0002\u0003\u0007a-\u0001\u0005cY>\u001c7.\u001b8h\u0011\u001d\ty\u0002\u0001C\u0001\u0003s!\u0012\u0002YA\u001e\u0003\u0007\nY&!\u0018\t\u000f\u001d\t9\u00041\u0001\u0002>A\u0019\u0001/a\u0010\n\u0007\u0005\u0005CA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0003\u0005\u0002F\u0005]\u0002\u0019AA$\u0003\u0011\u0001H.\u00198\u0011\t\u0005%\u0013qK\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u00059An\\4jG\u0006d'\u0002BA)\u0003'\nQ\u0001\u001d7b]NT1!!\u0016\u0005\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA-\u0003\u0017\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\"9\u0011\u0011GA\u001c\u0001\u00041\u0007bBA\u001b\u0003o\u0001\rA\u001a\u0005\b\u0003C\u0002A\u0011AA2\u00035\u0011XmY1dQ\u0016\u0014\u0015\u0010\u00157b]R)\u0001-!\u001a\u0002h!9q!a\u0018A\u0002\u0005u\u0002\u0002CA#\u0003?\u0002\r!a\u0012\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n\u0005\u0011\"/Z2bG\",')_\"p]\u0012LG/[8o)\u001d\u0001\u0017qNA9\u0003wBqaBA5\u0001\u0004\ti\u0004\u0003\u0005\u0002t\u0005%\u0004\u0019AA;\u0003%\u0019wN\u001c3ji&|g\u000e\u0005\u0004\u0010\u0003o\n9EZ\u0005\u0004\u0003s\u0002\"!\u0003$v]\u000e$\u0018n\u001c82\u0011!q\u0016\u0011\u000eI\u0001\u0002\u00041\u0007bBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u0011Y>|7.\u001e9DC\u000eDW\r\u001a#bi\u0006$B!a!\u0002\u0006B\u0019q\"\u001f\u0016\t\u000f5\fi\b1\u0001\u0002\bB\"\u0011\u0011RAG!\u0011\u0001\u0018/a#\u0011\u0007\u0019\u000bi\tB\u0006\u0002\u0010\u0006\u0015\u0015\u0011!A\u0001\u0006\u0003I%aA0%g!9\u0011q\u0010\u0001\u0005\u0002\u0005ME\u0003BAB\u0003+C\u0001\"!\u0012\u0002\u0012\u0002\u0007\u0011q\t\u0005\b\u00033\u0003A\u0011AAN\u00035)8/Z\"bG\",G\rR1uCR!\u0011qIAO\u0011!\t)%a&A\u0002\u0005\u001d\u0003bBAQ\u0001\u0011\u0005\u00111U\u0001\u000ee\u0016\u001c\u0017m\u00195f\u0005f\u0004\u0016\r\u001e5\u0015\u000b\u0001\f)+a*\t\u000f\u001d\ty\n1\u0001\u0002>!9\u0011\u0011VAP\u0001\u0004Y\u0018\u0001\u0004:fg>,(oY3QCRD\u0007bBAW\u0001\u0011%\u0011qV\u0001\u0011Y>|7.\u001e9B]\u0012\u0014VM\u001a:fg\"$rAZAY\u0003g\u000b)\r\u0003\u0005\u0002F\u0005-\u0006\u0019AA$\u0011!\t),a+A\u0002\u0005]\u0016A\u00014t!\u0011\tI,!1\u000e\u0005\u0005m&\u0002BA[\u0003{S1!a0\t\u0003\u0019A\u0017\rZ8pa&!\u00111YA^\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\t\u0003\u000f\fY\u000b1\u0001\u0002J\u0006i\u0011/^1mS\u001aLW\r\u001a)bi\"\u0004B!!/\u0002L&!\u0011QZA^\u0005\u0011\u0001\u0016\r\u001e5\t\u0013\u0005E\u0007!%A\u0005\u0002\u0005M\u0017\u0001F2bG\",\u0017+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0002V*\u001a\u00010a6,\u0005\u0005e\u0007\u0003BAn\u0003Kl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a9\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\fiNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a;\u0001#\u0003%\t!!<\u0002)\r\f7\r[3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyO\u000b\u0003\u0002\u0012\u0005]\u0007\"CAz\u0001E\u0005I\u0011AA{\u0003Y)hnY1dQ\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u001aTCAA|U\r1\u0017q\u001b\u0005\n\u0003w\u0004\u0011\u0013!C\u0005\u0003k\fAD]3dC\u000eDWMQ=D_:$\u0017\u000e^5p]\u0012\"WMZ1vYR$3\u0007")
public class CacheManager
implements Logging {
    private final transient LinkedList<CachedData> cachedData;
    private final transient ReentrantReadWriteLock cacheLock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedList<CachedData> cachedData() {
        return this.cachedData;
    }

    private ReentrantReadWriteLock cacheLock() {
        return this.cacheLock;
    }

    private <A> A readLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.ReadLock lock = this.cacheLock().readLock();
        lock.lock();
        try {
            object = f.apply();
        }
        finally {
            lock.unlock();
        }
        return (A)object;
    }

    private <A> A writeLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.WriteLock lock = this.cacheLock().writeLock();
        lock.lock();
        try {
            object = f.apply();
        }
        finally {
            lock.unlock();
        }
        return (A)object;
    }

    public void clearCache() {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.cachedData()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                CacheManager.$anonfun$clearCache$2(x$1);
                return BoxedUnit.UNIT;
            });
            this.cachedData().clear();
        });
    }

    public boolean isEmpty() {
        return BoxesRunTime.unboxToBoolean(this.readLock((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cachedData().isEmpty()));
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.writeLock((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            LogicalPlan planToCache = query.logicalPlan();
            if (this.lookupCachedData(planToCache).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
                object = BoxedUnit.UNIT;
            } else {
                SparkSession sparkSession = query.sparkSession();
                InMemoryRelation inMemoryRelation = InMemoryRelation$.MODULE$.apply(sparkSession.sessionState().conf().useCompression(), sparkSession.sessionState().conf().columnBatchSize(), storageLevel, sparkSession.sessionState().executePlan(planToCache).executedPlan(), tableName, planToCache);
                object = BoxesRunTime.boxToBoolean((boolean)this.cachedData().add(new CachedData(planToCache, inMemoryRelation)));
            }
            return object;
        });
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, blocking));
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$3(plan, x$2)) : (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan));
                Iterator it = this.cachedData().iterator();
                while (it.hasNext()) {
                    CachedData cd = (CachedData)it.next();
                    if (!BoxesRunTime.unboxToBoolean((Object)shouldRemove.apply((Object)cd.plan()))) continue;
                    cd.cachedRepresentation().cacheBuilder().clearCache(blocking);
                    it.remove();
                }
                if (cascade) break block1;
                this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(plan, x$5)), false);
            }
        });
    }

    public boolean uncacheQuery$default$3() {
        return true;
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$2(plan, x$7)), this.recacheByCondition$default$3()));
    }

    private void recacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> condition, boolean clearCache) {
        Iterator it = this.cachedData().iterator();
        ArrayBuffer needToRecache = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (it.hasNext()) {
            BoxedUnit boxedUnit;
            CachedData cd = (CachedData)it.next();
            if (BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)cd.plan()))) {
                InMemoryRelation newCache;
                if (clearCache) {
                    cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
                }
                it.remove();
                SparkPlan plan = spark.sessionState().executePlan(cd.plan()).executedPlan();
                InMemoryRelation x$15 = newCache = InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder().withCachedPlan(plan), cd.plan());
                LogicalPlan x$16 = cd.copy$default$1();
                boxedUnit = needToRecache.$plus$eq((Object)cd.copy(x$16, x$15));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        needToRecache.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$1(this, x$1)));
    }

    private boolean recacheByCondition$default$3() {
        return true;
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return (Option)this.readLock((Function0 & Serializable & scala.Serializable)() -> this.lookupCachedData(query.logicalPlan()));
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return (Option)this.readLock((Function0 & Serializable & scala.Serializable)() -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.cachedData()).asScala()).find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan()))));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ResolvedHint resolvedHint;
                A1 A1 = x1;
                Object object = A1 instanceof ResolvedHint ? (resolvedHint = (ResolvedHint)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.cachedRepresentation().withOutput((Seq<Attribute>)A1.output())).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof ResolvedHint ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path path = new Path(resourcePath);
            FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
            Tuple2 tuple2 = new Tuple2((Object)fs, (Object)fs.makeQualified(path));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FileSystem fs2 = (FileSystem)tuple2._1();
            Path qualifiedPath = (Path)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)fs2, (Object)qualifiedPath);
            Tuple2 tuple23 = tuple22;
            FileSystem fs3 = (FileSystem)tuple23._1();
            Path qualifiedPath2 = (Path)tuple23._2();
            this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$2(this, fs3, qualifiedPath2, x$11)), this.recacheByCondition$default$3());
        });
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                String prefixToInvalidate = qualifiedPath.toString();
                boolean invalidate = ((IterableLike)hadoopFsRelation.location().rootPaths().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.startsWith(prefixToInvalidate)));
                if (invalidate) {
                    hadoopFsRelation.location().refresh();
                }
                bl2 = invalidate;
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$clearCache$2(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$3(LogicalPlan plan$2, LogicalPlan x$2) {
        return x$2.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(LogicalPlan plan$2, LogicalPlan x$5) {
        return x$5.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$2(LogicalPlan plan$3, LogicalPlan x$7) {
        return x$7.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameResult((QueryPlan)plan$3))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$1(CacheManager $this, CachedData x$1) {
        return $this.cachedData().add(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$2(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, LogicalPlan x$11) {
        return x$11.find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$12, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        this.cachedData = new LinkedList();
        this.cacheLock = new ReentrantReadWriteLock();
    }
}

