/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0018)\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!\u0001D*qCJ\\7+Z:tS>t\u0007BB\u0010\u0001\t\u0003\u0011\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"a\u0007\u0001\t\u000beq\u0002\u0019\u0001\u000e\t\u000b\u0011\u0002A\u0011A\u0013\u0002\r\u0019|'/\\1u)\t\tc\u0005C\u0003(G\u0001\u0007\u0001&\u0001\u0004t_V\u00148-\u001a\t\u0003SAr!A\u000b\u0018\u0011\u0005-rQ\"\u0001\u0017\u000b\u00055R\u0011A\u0002\u001fs_>$h(\u0003\u00020\u001d\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tyc\u0002C\u00035\u0001\u0011\u0005Q'\u0001\u0004tG\",W.\u0019\u000b\u0003CYBQ\u0001N\u001aA\u0002]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0002\u0002\u000bQL\b/Z:\n\u0005qJ$AC*ueV\u001cG\u000fV=qK\")A\u0007\u0001C\u0001}Q\u0011\u0011e\u0010\u0005\u0006\u0001v\u0002\r\u0001K\u0001\rg\u000eDW-\\1TiJLgn\u001a\u0005\u0006\u0005\u0002!\taQ\u0001\u0007_B$\u0018n\u001c8\u0015\u0007\u0005\"e\tC\u0003F\u0003\u0002\u0007\u0001&A\u0002lKfDQaR!A\u0002!\nQA^1mk\u0016DQA\u0011\u0001\u0005\u0002%#2!\t&L\u0011\u0015)\u0005\n1\u0001)\u0011\u00159\u0005\n1\u0001M!\tiQ*\u0003\u0002O\u001d\t9!i\\8mK\u0006t\u0007\"\u0002\"\u0001\t\u0003\u0001FcA\u0011R%\")Qi\u0014a\u0001Q!)qi\u0014a\u0001'B\u0011Q\u0002V\u0005\u0003+:\u0011A\u0001T8oO\")!\t\u0001C\u0001/R\u0019\u0011\u0005W-\t\u000b\u00153\u0006\u0019\u0001\u0015\t\u000b\u001d3\u0006\u0019\u0001.\u0011\u00055Y\u0016B\u0001/\u000f\u0005\u0019!u.\u001e2mK\")a\f\u0001C\u0001?\u00069q\u000e\u001d;j_:\u001cHCA\u0011a\u0011\u0015qV\f1\u0001b!\u0011\u0011W\r\u000b\u0015\u000e\u0003\rT!\u0001\u001a\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002gG\n\u0019Q*\u00199\t\u000by\u0003A\u0011\u00015\u0015\u0005\u0005J\u0007\"\u00020h\u0001\u0004Q\u0007\u0003B6qQ!j\u0011\u0001\u001c\u0006\u0003[:\fA!\u001e;jY*\tq.\u0001\u0003kCZ\f\u0017B\u00014m\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0011aw.\u00193\u0015\u0003Q\u0004\"!\u001e=\u000f\u0005m1\u0018BA<\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA<\u0003\u0011\u0015\u0011\b\u0001\"\u0001})\t!X\u0010C\u0003\u007fw\u0002\u0007\u0001&\u0001\u0003qCRD\u0007B\u0002:\u0001\t\u0003\t\t\u0001F\u0002u\u0003\u0007Aq!!\u0002\u0000\u0001\u0004\t9!A\u0003qCRD7\u000f\u0005\u0003\u000e\u0003\u0013A\u0013bAA\u0006\u001d\tQAH]3qK\u0006$X\r\u001a )\u0007}\fy\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003'\u0011qA^1sCJ<7\u000fC\u0004\u0002\u001e\u0001!I!a\b\u0002\u00191|\u0017\r\u001a,2'>,(oY3\u0015\u0007Q\f\t\u0003\u0003\u0005\u0002\u0006\u0005m\u0001\u0019AA\u0004\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tAA\u001b3cGR9A/!\u000b\u0002.\u0005E\u0002bBA\u0016\u0003G\u0001\r\u0001K\u0001\u0004kJd\u0007bBA\u0018\u0003G\u0001\r\u0001K\u0001\u0006i\u0006\u0014G.\u001a\u0005\t\u0003g\t\u0019\u00031\u0001\u00026\u0005Q\u0001O]8qKJ$\u0018.Z:\u0011\u0007-\f9$C\u0002\u0002:1\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t)\u0003\u0001C\u0001\u0003{!r\u0002^A \u0003\u0003\n\u0019%a\u0012\u0002L\u0005=\u0013\u0011\f\u0005\b\u0003W\tY\u00041\u0001)\u0011\u001d\ty#a\u000fA\u0002!Bq!!\u0012\u0002<\u0001\u0007\u0001&\u0001\u0006d_2,XN\u001c(b[\u0016Dq!!\u0013\u0002<\u0001\u00071+\u0001\u0006m_^,'OQ8v]\u0012Dq!!\u0014\u0002<\u0001\u00071+\u0001\u0006vaB,'OQ8v]\u0012D\u0001\"!\u0015\u0002<\u0001\u0007\u00111K\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0011\u00075\t)&C\u0002\u0002X9\u00111!\u00138u\u0011!\tY&a\u000fA\u0002\u0005U\u0012\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000fC\u0004\u0002&\u0001!\t!a\u0018\u0015\u0013Q\f\t'a\u0019\u0002f\u0005=\u0004bBA\u0016\u0003;\u0002\r\u0001\u000b\u0005\b\u0003_\ti\u00061\u0001)\u0011!\t9'!\u0018A\u0002\u0005%\u0014A\u00039sK\u0012L7-\u0019;fgB!Q\"a\u001b)\u0013\r\tiG\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u00037\ni\u00061\u0001\u00026!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0014\u0001\u00026t_:$2\u0001^A<\u0011\u0019q\u0018\u0011\u000fa\u0001Q!9\u00111\u000f\u0001\u0005\u0002\u0005mDc\u0001;\u0002~!A\u0011QAA=\u0001\u0004\t9\u0001\u000b\u0003\u0002z\u0005=\u0001bBA:\u0001\u0011\u0005\u00111\u0011\u000b\u0004i\u0006\u0015\u0005\u0002CAD\u0003\u0003\u0003\r!!#\u0002\u000f)\u001cxN\u001c*E\tB)\u00111RAJQ5\u0011\u0011Q\u0012\u0006\u0004_\u0006=%bAAI\t\u0005\u0019\u0011\r]5\n\t\u0005U\u0015Q\u0012\u0002\b\u0015\u00064\u0018M\u0015#EQ!\t\t)!'\u0002 \u0006\r\u0006cA\u0007\u0002\u001c&\u0019\u0011Q\u0014\b\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002\"\u0006\u0011Sk]3!UN|g\u000e\u000b#bi\u0006\u001cX\r^.TiJLgnZ/*A%t7\u000f^3bI:\n#!!*\u0002\u000bIr#G\f\u0019\t\u000f\u0005M\u0004\u0001\"\u0001\u0002*R\u0019A/a+\t\u0011\u0005\u001d\u0015q\u0015a\u0001\u0003[\u0003R!a,\u00026\"j!!!-\u000b\u0007\u0005MF!A\u0002sI\u0012LA!a.\u00022\n\u0019!\u000b\u0012#)\u0011\u0005\u001d\u0016\u0011TAP\u0003GCq!a\u001d\u0001\t\u0003\ti\fF\u0002u\u0003\u007fC\u0001\"!1\u0002<\u0002\u0007\u00111Y\u0001\fUN|g\u000eR1uCN,G\u000f\u0005\u0003\u001c\u0003\u000bD\u0013bAAd\u0005\t9A)\u0019;bg\u0016$\bbBAf\u0001\u0011\u0005\u0011QZ\u0001\u0004GN4Hc\u0001;\u0002P\"1a0!3A\u0002!Bq!a3\u0001\t\u0003\t\u0019\u000eF\u0002u\u0003+D\u0001\"a6\u0002R\u0002\u0007\u00111Y\u0001\u000bGN4H)\u0019;bg\u0016$\bbBAf\u0001\u0011\u0005\u00111\u001c\u000b\u0004i\u0006u\u0007\u0002CA\u0003\u00033\u0004\r!a\u0002)\t\u0005e\u0017q\u0002\u0005\b\u0003G\u0004A\u0011AAs\u0003\u001d\u0001\u0018M]9vKR$2\u0001^At\u0011\u0019q\u0018\u0011\u001da\u0001Q!9\u00111\u001d\u0001\u0005\u0002\u0005-Hc\u0001;\u0002n\"A\u0011QAAu\u0001\u0004\t9\u0001\u000b\u0003\u0002j\u0006=\u0001bBAz\u0001\u0011\u0005\u0011Q_\u0001\u0004_J\u001cGc\u0001;\u0002x\"1a0!=A\u0002!Bq!a=\u0001\t\u0003\tY\u0010F\u0002u\u0003{D\u0001\"!\u0002\u0002z\u0002\u0007\u0011q\u0001\u0015\u0005\u0003s\fy\u0001C\u0004\u00020\u0001!\tAa\u0001\u0015\u0007Q\u0014)\u0001C\u0004\u0003\b\t\u0005\u0001\u0019\u0001\u0015\u0002\u0013Q\f'\r\\3OC6,\u0007b\u0002B\u0006\u0001\u0011\u0005!QB\u0001\u0005i\u0016DH\u000fF\u0002u\u0005\u001fAaA B\u0005\u0001\u0004A\u0003b\u0002B\u0006\u0001\u0011\u0005!1\u0003\u000b\u0004i\nU\u0001\u0002CA\u0003\u0005#\u0001\r!a\u0002)\t\tE\u0011q\u0002\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0003!!X\r\u001f;GS2,G\u0003BAb\u0005?AaA B\r\u0001\u0004A\u0003b\u0002B\u000e\u0001\u0011\u0005!1\u0005\u000b\u0005\u0003\u0007\u0014)\u0003\u0003\u0005\u0002\u0006\t\u0005\u0002\u0019AA\u0004Q\u0011\u0011\t#a\u0004\t\u000f\t-\u0002\u0001\"\u0003\u0003.\u00059\u0012m]:feRtun\u00159fG&4\u0017.\u001a3TG\",W.\u0019\u000b\u0005\u0005_\u0011)\u0004E\u0002\u000e\u0005cI1Aa\r\u000f\u0005\u0011)f.\u001b;\t\u000f\t]\"\u0011\u0006a\u0001Q\u0005Iq\u000e]3sCRLwN\u001c\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0003}1XM]5gs\u000e{G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000f\u001a\u000b\u0007\u0005_\u0011yD!\u0011\t\rQ\u0012I\u00041\u00018\u0011\u001d\u0011\u0019E!\u000fA\u0002!\n\u0011dY8mk6tg*Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sI\"Aq\u0005\u0001a\u0001\n\u0013\u00119%F\u0001)\u0011%\u0011Y\u0005\u0001a\u0001\n\u0013\u0011i%\u0001\u0006t_V\u00148-Z0%KF$BAa\f\u0003P!I!\u0011\u000bB%\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0004b\u0002B+\u0001\u0001\u0006K\u0001K\u0001\bg>,(oY3!\u0011%\u0011I\u0006\u0001a\u0001\n\u0013\u0011Y&A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0003^A!QBa\u00188\u0013\r\u0011\tG\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\t\u0015\u0004\u00011A\u0005\n\t\u001d\u0014aF;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fw\fJ3r)\u0011\u0011yC!\u001b\t\u0015\tE#1MA\u0001\u0002\u0004\u0011i\u0006\u0003\u0005\u0003n\u0001\u0001\u000b\u0015\u0002B/\u0003Q)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bA!I!\u0011\u000f\u0001C\u0002\u0013%!1O\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0005k\u0002bAa\u001e\u0003~!BSB\u0001B=\u0015\r\u0011YhY\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011yH!\u001f\u0003\u000f!\u000b7\u000f['ba\"A!1\u0011\u0001!\u0002\u0013\u0011)(A\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\t\u0015\u0004\u0001\t\u001d\u0005\u0003\u0002BE\u0005'sAAa#\u0003\u00106\u0011!Q\u0012\u0006\u0004\u0003+!\u0011\u0002\u0002BI\u0005\u001b\u000b!#\u00138uKJ4\u0017mY3Ti\u0006\u0014\u0017\u000e\\5us&!!Q\u0013BL\u0005\u0019\u0019F/\u00192mK*!!\u0011\u0013BG\u0001")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private final HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString)));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(Seq<String> paths) {
        Dataset<Row> dataset;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sessionState().conf());
        if (DataSourceV2.class.isAssignableFrom(cls)) {
            DataSourceV2 ds = (DataSourceV2)cls.newInstance();
            if (ds instanceof ReadSupport) {
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(ds, this.sparkSession.sessionState().conf());
                ObjectMapper objectMapper = new ObjectMapper();
                Tuple2 pathsOption = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)objectMapper.writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class))));
                DataSourceV2 x$4 = ds;
                scala.collection.immutable.Map x$5 = sessionOptions.$plus$plus((GenTraversableOnce)this.extraOptions().toMap(Predef$.MODULE$.$conforms())).$plus(pathsOption);
                Option<StructType> x$6 = this.userSpecifiedSchema();
                Option<TableIdentifier> x$7 = DataSourceV2Relation$.MODULE$.create$default$3();
                dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(x$4, (scala.collection.immutable.Map<String, String>)x$5, x$7, x$6));
            } else {
                dataset = this.loadV1Source(paths);
            }
        } else {
            dataset = this.loadV1Source(paths);
        }
        return dataset;
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        SparkSession x$8 = this.sparkSession;
        Seq<String> x$9 = paths;
        Option<StructType> x$10 = this.userSpecifiedSchema();
        String x$11 = this.source();
        scala.collection.immutable.Map x$12 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$13 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$14 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$15 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$8, x$11, x$9, x$10, x$13, x$14, (scala.collection.immutable.Map<String, String>)x$12, x$15);
        boolean x$16 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$16));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())})));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        scala.collection.immutable.Map params = this.extraOptions().toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()).toMap(Predef$.MODULE$.$conforms()));
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String part = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            JDBCPartition jDBCPartition = new JDBCPartition(part, i);
            return jDBCPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$2(parsedOptions, x$1))));
        Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord(), parsedOptions.multiLine());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        RDD rDD;
        CSVOptions parsedOptions = new CSVOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$4());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        Option maybeFirstLine = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))).headOption();
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset, (Option<String>)maybeFirstLine, parsedOptions));
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$2(parsedOptions, x$2))));
        if (parsedOptions.headerFlag() && maybeFirstLine.isDefined()) {
            String firstLine = (String)maybeFirstLine.get();
            CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
            String[] columnNames = parser.parseLine(firstLine);
            CSVDataSource$.MODULE$.checkHeaderColumnNames(actualSchema, columnNames, csvDataset.getClass().getCanonicalName(), parsedOptions.enforceSchema(), this.sparkSession.sessionState().conf().caseSensitiveAnalysis());
            rDD = filteredLines.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)x$3 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$3, firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        } else {
            rDD = filteredLines.rdd();
        }
        RDD linesWithoutHeader = rDD;
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{rawParser.parse((String)input)})), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord(), parsedOptions.multiLine());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        return this.sparkSession.table(tableName);
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException(new StringBuilder(43).append("User specified schema not supported with `").append(operation).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    public static final /* synthetic */ boolean $anonfun$json$2(JSONOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$csv$2(CSVOptions parsedOptions$2, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

