/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.NoSuchElementException;
import org.apache.spark.SparkException;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.feature.VectorAssembler$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.DefaultParamsReadable$class;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class VectorAssembler$
implements DefaultParamsReadable<VectorAssembler>,
Serializable {
    public static final VectorAssembler$ MODULE$;
    private final String SKIP_INVALID;
    private final String ERROR_INVALID;
    private final String KEEP_INVALID;
    private final String[] supportedHandleInvalids;

    static {
        new VectorAssembler$();
    }

    @Override
    public MLReader<VectorAssembler> read() {
        return DefaultParamsReadable$class.read(this);
    }

    public String SKIP_INVALID() {
        return this.SKIP_INVALID;
    }

    public String ERROR_INVALID() {
        return this.ERROR_INVALID;
    }

    public String KEEP_INVALID() {
        return this.KEEP_INVALID;
    }

    public String[] supportedHandleInvalids() {
        return this.supportedHandleInvalids;
    }

    public Map<String, Object> getVectorLengthsFromFirstRow(Dataset<?> dataset, Seq<String> columns) {
        try {
            Row first_row = (Row)dataset.toDF().select((Seq)columns.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(String colName) {
                    return functions$.MODULE$.col(colName);
                }
            }, Seq$.MODULE$.canBuildFrom())).first();
            return ((TraversableOnce)((TraversableLike)columns.zip((GenIterable)first_row.toSeq(), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String c = (String)tuple2._1();
                        Object x = tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c), (Object)BoxesRunTime.boxToInteger((int)((Vector)x).size()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered empty dataframe while inferring lengths from the first row. Consider using\n           |VectorSizeHint to add metadata for columns: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns.mkString("[", ", ", "]")})))).stripMargin().replaceAll("\n", " ")).append((Object)noSuchElementException.toString()).toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered null value while inferring lengths from the first row. Consider using\n           |VectorSizeHint to add metadata for columns: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns.mkString("[", ", ", "]")})))).stripMargin().replaceAll("\n", " ")).append((Object)nullPointerException.toString()).toString());
        }
    }

    public Map<String, Object> getLengths(Dataset<?> dataset, Seq<String> columns, String handleInvalid) {
        Tuple2 tuple2;
        block9: {
            Map<String, Object> map;
            Map groupSizes;
            block7: {
                block8: {
                    Seq missingColumns;
                    block6: {
                        groupSizes = ((TraversableOnce)columns.map((Function1)new Serializable(dataset){
                            public static final long serialVersionUID = 0L;
                            private final Dataset dataset$2;

                            public final Tuple2<String, Object> apply(String c) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c), (Object)BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(this.dataset$2.schema().apply(c)).size()));
                            }
                            {
                                this.dataset$2 = dataset$2;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        missingColumns = ((MapLike)groupSizes.filter((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, Object> x$2) {
                                return x$2._2$mcI$sp() == -1;
                            }
                        })).keys().toSeq();
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)missingColumns.nonEmpty()), (Object)handleInvalid);
                        if (tuple2 == null) break block6;
                        boolean bl = tuple2._1$mcZ$sp();
                        String string = (String)tuple2._2();
                        if (!bl) break block6;
                        String string2 = this.ERROR_INVALID();
                        String string3 = string;
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block6;
                        map = this.getVectorLengthsFromFirstRow(dataset, (Seq<String>)missingColumns);
                        break block7;
                    }
                    if (tuple2 == null) break block8;
                    boolean bl = tuple2._1$mcZ$sp();
                    String string = (String)tuple2._2();
                    if (!bl) break block8;
                    String string4 = this.SKIP_INVALID();
                    String string5 = string;
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block8;
                    map = this.getVectorLengthsFromFirstRow(dataset.na().drop(missingColumns), (Seq<String>)missingColumns);
                    break block7;
                }
                if (tuple2 != null) {
                    boolean bl = tuple2._1$mcZ$sp();
                    String string = (String)tuple2._2();
                    if (bl) {
                        String string6 = this.KEEP_INVALID();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not infer column lengths with handleInvalid = \"keep\". Consider using VectorSizeHint\n           |to add metadata for columns: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns.mkString("[", ", ", "]")})))).stripMargin().replaceAll("\n", " "));
                        }
                    }
                }
                if (tuple2 == null) break block9;
                map = Predef$.MODULE$.Map().empty();
            }
            Map<String, Object> firstSizes = map;
            return groupSizes.$plus$plus((GenTraversableOnce)firstSizes);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public VectorAssembler load(String path) {
        return (VectorAssembler)MLReadable$class.load(this, path);
    }

    public Vector assemble(int[] lengths, boolean keepInvalid, Seq<Object> vv) {
        ArrayBuilder indices = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        ArrayBuilder values = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        IntRef featureIndex = IntRef.create((int)0);
        IntRef inputColumnIndex = IntRef.create((int)0);
        vv.foreach((Function1)new Serializable(lengths, keepInvalid, indices, values, featureIndex, inputColumnIndex){
            public static final long serialVersionUID = 0L;
            private final int[] lengths$2;
            private final boolean keepInvalid$2;
            public final ArrayBuilder indices$1;
            public final ArrayBuilder values$1;
            public final IntRef featureIndex$1;
            private final IntRef inputColumnIndex$1;

            public final void apply(Object x0$3) {
                Object object;
                block9: {
                    block10: {
                        block7: {
                            block8: {
                                block6: {
                                    BoxedUnit boxedUnit;
                                    object = x0$3;
                                    if (!(object instanceof Double)) break block6;
                                    double d = BoxesRunTime.unboxToDouble((Object)object);
                                    if (Predef$.MODULE$.double2Double(d).isNaN() && !this.keepInvalid$2) {
                                        throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered NaN while assembling a row with handleInvalid = \"error\". Consider\n               |removing NaNs from dataset or using handleInvalid = \"keep\" or \"skip\"."})).s((Seq)Nil$.MODULE$))).stripMargin());
                                    }
                                    if (d != 0.0) {
                                        this.indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.featureIndex$1.elem));
                                        boxedUnit = this.values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)d));
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    ++this.inputColumnIndex$1.elem;
                                    ++this.featureIndex$1.elem;
                                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                    break block7;
                                }
                                if (!(object instanceof Vector)) break block8;
                                Vector vector = (Vector)object;
                                vector.foreachActive((Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.assemble.1 $outer;

                                    public final void apply(int x0$4, double x1$1) {
                                        this.apply$mcVID$sp(x0$4, x1$1);
                                    }

                                    public void apply$mcVID$sp(int x0$4, double x1$1) {
                                        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$4, x1$1);
                                        if (sp2 != null) {
                                            BoxedUnit boxedUnit;
                                            int i = sp2._1$mcI$sp();
                                            double v = sp2._2$mcD$sp();
                                            if (v != 0.0) {
                                                this.$outer.indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(this.$outer.featureIndex$1.elem + i)));
                                                this.$outer.values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit2 = boxedUnit;
                                            return;
                                        }
                                        throw new MatchError((Object)sp2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                ++this.inputColumnIndex$1.elem;
                                this.featureIndex$1.elem += vector.size();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block7;
                            }
                            if (object != null) break block9;
                            if (!this.keepInvalid$2) break block10;
                            int length = this.lengths$2[this.inputColumnIndex$1.elem];
                            Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, length)).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.assemble.1 $outer;

                                public final ArrayBuilder<Object> apply(int i) {
                                    this.$outer.indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(this.$outer.featureIndex$1.elem + i)));
                                    return (ArrayBuilder)this.$outer.values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            ++this.inputColumnIndex$1.elem;
                            this.featureIndex$1.elem += length;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered null while assembling a row with handleInvalid = \"keep\". Consider\n               |removing nulls from dataset or using handleInvalid = \"keep\" or \"skip\"."})).s((Seq)Nil$.MODULE$))).stripMargin());
                }
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of type ", " is not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object, object.getClass().getName()})));
            }
            {
                this.lengths$2 = lengths$2;
                this.keepInvalid$2 = keepInvalid$2;
                this.indices$1 = indices$1;
                this.values$1 = values$1;
                this.featureIndex$1 = featureIndex$1;
                this.inputColumnIndex$1 = inputColumnIndex$1;
            }
        });
        return Vectors$.MODULE$.sparse(featureIndex.elem, (int[])indices.result(), (double[])values.result()).compressed();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private VectorAssembler$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
        DefaultParamsReadable$class.$init$(this);
        this.SKIP_INVALID = "skip";
        this.ERROR_INVALID = "error";
        this.KEEP_INVALID = "keep";
        this.supportedHandleInvalids = (String[])((Object[])new String[]{this.SKIP_INVALID(), this.ERROR_INVALID(), this.KEEP_INVALID()});
    }
}

