/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.launcher.ChildProcAppHandle;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.LauncherConnection;
import org.apache.spark.launcher.LauncherProtocol;
import org.apache.spark.launcher.LauncherServer;
import org.apache.spark.launcher.SparkAppHandle;

abstract class AbstractAppHandle
implements SparkAppHandle {
    private static final Logger LOG = Logger.getLogger(ChildProcAppHandle.class.getName());
    private final LauncherServer server;
    private LauncherServer.ServerConnection connection;
    private List<SparkAppHandle.Listener> listeners;
    private AtomicReference<SparkAppHandle.State> state;
    private String appId;
    private volatile boolean disposed;

    protected AbstractAppHandle(LauncherServer server) {
        this.server = server;
        this.state = new AtomicReference<SparkAppHandle.State>(SparkAppHandle.State.UNKNOWN);
    }

    @Override
    public synchronized void addListener(SparkAppHandle.Listener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<SparkAppHandle.Listener>();
        }
        this.listeners.add(l);
    }

    @Override
    public SparkAppHandle.State getState() {
        return this.state.get();
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public void stop() {
        CommandBuilderUtils.checkState(this.connection != null, "Application is still not connected.", new Object[0]);
        try {
            this.connection.send(new LauncherProtocol.Stop());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public synchronized void disconnect() {
        if (!this.isDisposed()) {
            if (this.connection != null) {
                try {
                    this.connection.closeAndWait();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.dispose();
        }
    }

    void setConnection(LauncherServer.ServerConnection connection) {
        this.connection = connection;
    }

    LauncherConnection getConnection() {
        return this.connection;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    synchronized void dispose() {
        if (!this.isDisposed()) {
            this.server.unregister(this);
            this.setState(SparkAppHandle.State.LOST, false);
            this.disposed = true;
        }
    }

    void setState(SparkAppHandle.State s) {
        this.setState(s, false);
    }

    void setState(SparkAppHandle.State s, boolean force) {
        if (force) {
            this.state.set(s);
            this.fireEvent(false);
            return;
        }
        SparkAppHandle.State current = this.state.get();
        while (!current.isFinal()) {
            if (this.state.compareAndSet(current, s)) {
                this.fireEvent(false);
                return;
            }
            current = this.state.get();
        }
        LOG.log(Level.WARNING, "Backend requested transition from final state {0} to {1}.", new Object[]{current, s});
    }

    synchronized void setAppId(String appId) {
        this.appId = appId;
        this.fireEvent(true);
    }

    private void fireEvent(boolean isInfoChanged) {
        if (this.listeners != null) {
            for (SparkAppHandle.Listener l : this.listeners) {
                if (isInfoChanged) {
                    l.infoChanged(this);
                    continue;
                }
                l.stateChanged(this);
            }
        }
    }
}

