/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.LegacyTypeStringParser$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@Stable
public final class StructType$
extends AbstractDataType
implements Serializable {
    public static final StructType$ MODULE$ = new StructType$();

    @Override
    public DataType defaultConcreteType() {
        return new StructType();
    }

    @Override
    public boolean acceptsType(DataType other) {
        return other instanceof StructType;
    }

    @Override
    public String simpleString() {
        return "struct";
    }

    public StructType fromString(String raw) {
        StructType structType;
        DataType dataType = (DataType)Try$.MODULE$.apply((Function0 & Serializable)() -> DataType$.MODULE$.fromJson(raw)).getOrElse((Function0 & Serializable)() -> LegacyTypeStringParser$.MODULE$.parseString(raw));
        if (!(dataType instanceof StructType)) {
            throw QueryExecutionErrors$.MODULE$.failedParsingStructTypeError(raw);
        }
        StructType structType2 = structType = (StructType)dataType;
        return structType2;
    }

    public StructType fromDDL(String ddl) {
        return CatalystSqlParser$.MODULE$.parseTableSchema(ddl);
    }

    public StructType apply(Seq<StructField> fields) {
        return new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public StructType apply(List<StructField> fields) {
        return this.apply((Seq<StructField>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).toSeq());
    }

    public StructType fromAttributes(Seq<Attribute> attributes) {
        return this.apply((Seq<StructField>)((Seq)attributes.map((Function1 & Serializable)a -> new StructField(a.name(), a.dataType(), a.nullable(), a.metadata()))));
    }

    public DataType removeMetadata(String key, DataType dt) {
        DataType dataType;
        DataType dataType2 = dt;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> {
                MetadataBuilder mb = new MetadataBuilder();
                DataType x$1 = MODULE$.removeMetadata(key, f.dataType());
                Metadata x$2 = mb.withMetadata(f.metadata()).remove(key).build();
                String x$3 = f.copy$default$1();
                boolean x$4 = f.copy$default$3();
                return f.copy(x$3, x$1, x$4, x$2);
            }, ClassTag$.MODULE$.apply(StructField.class));
            dataType = new StructType(newFields);
        } else {
            dataType = dt;
        }
        return dataType;
    }

    public DataType unionLikeMerge(DataType left, DataType right) {
        return this.mergeInternal(left, right, (Function2<StructType, StructType, StructType>)(Function2 & Serializable)(s1, s2) -> {
            StructField[] leftFields = s1.fields();
            StructField[] rightFields = s2.fields();
            Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])leftFields)) == ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])rightFields)), (Function0 & Serializable)() -> "To merge nullability, two structs must have same number of fields.");
            Seq newFields = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])leftFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])rightFields))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField leftField = (StructField)tuple2._1();
                StructField rightField = (StructField)tuple2._2();
                DataType x$1 = MODULE$.unionLikeMerge(leftField.dataType(), rightField.dataType());
                boolean x$2 = leftField.nullable() || rightField.nullable();
                String x$3 = leftField.copy$default$1();
                Metadata x$4 = leftField.copy$default$4();
                StructField structField = leftField.copy(x$3, x$1, x$2, x$4);
                return structField;
            }, ClassTag$.MODULE$.apply(StructField.class))));
            return MODULE$.apply((Seq<StructField>)newFields);
        });
    }

    public DataType merge(DataType left, DataType right) {
        return this.mergeInternal(left, right, (Function2<StructType, StructType, StructType>)(Function2 & Serializable)(s1, s2) -> {
            StructField[] leftFields = s1.fields();
            StructField[] rightFields = s2.fields();
            ArrayBuffer newFields = ArrayBuffer$.MODULE$.empty();
            Map<String, StructField> rightMapped = MODULE$.fieldsMap(rightFields);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])leftFields), (Function1 & Serializable)x0$1 -> {
                StructType$.$anonfun$merge$2(rightMapped, newFields, x0$1);
                return BoxedUnit.UNIT;
            });
            Map<String, StructField> leftMapped = MODULE$.fieldsMap(leftFields);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])rightFields), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StructType$.$anonfun$merge$6(leftMapped, f)))), (Function1 & Serializable)f -> (ArrayBuffer)newFields.$plus$eq(f));
            return MODULE$.apply((Seq<StructField>)newFields.toSeq());
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataType mergeInternal(DataType left, DataType right, Function2<StructType, StructType, StructType> mergeStruct) {
        Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType leftElementType = arrayType.elementType();
                boolean leftContainsNull = arrayType.containsNull();
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType rightElementType = arrayType2.elementType();
                    boolean rightContainsNull = arrayType2.containsNull();
                    return new ArrayType(this.mergeInternal(leftElementType, rightElementType, mergeStruct), leftContainsNull || rightContainsNull);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftContainsNull = mapType.valueContainsNull();
                if (dataType3 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType3;
                    DataType rightKeyType = mapType2.keyType();
                    DataType rightValueType = mapType2.valueType();
                    boolean rightContainsNull = mapType2.valueContainsNull();
                    return new MapType(this.mergeInternal(leftKeyType, rightKeyType, mergeStruct), this.mergeInternal(leftValueType, rightValueType, mergeStruct), leftContainsNull || rightContainsNull);
                }
            }
        }
        if (tuple2 != null) {
            DataType s1 = (DataType)tuple2._1();
            DataType s2 = (DataType)tuple2._2();
            if (s1 instanceof StructType) {
                StructType structType = (StructType)s1;
                if (s2 instanceof StructType) {
                    StructType structType2 = (StructType)s2;
                    return (DataType)mergeStruct.apply((Object)structType, (Object)structType2);
                }
            }
        }
        if (tuple2 != null) {
            DecimalType decimalType;
            Option<Tuple2<Object, Object>> option;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                DecimalType decimalType2;
                Option<Tuple2<Object, Object>> option2;
                int leftPrecision = ((Tuple2)option.get())._1$mcI$sp();
                int leftScale = ((Tuple2)option.get())._2$mcI$sp();
                if (dataType4 instanceof DecimalType && !(option2 = DecimalType$Fixed$.MODULE$.unapply(decimalType2 = (DecimalType)dataType4)).isEmpty()) {
                    int rightPrecision = ((Tuple2)option2.get())._1$mcI$sp();
                    int rightScale = ((Tuple2)option2.get())._2$mcI$sp();
                    if (leftScale != rightScale) throw QueryExecutionErrors$.MODULE$.cannotMergeDecimalTypesWithIncompatibleScaleError(leftScale, rightScale);
                    return new DecimalType(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(leftPrecision), rightPrecision), leftScale);
                }
            }
        }
        if (tuple2 != null) {
            DataType leftUdt = (DataType)tuple2._1();
            DataType rightUdt = (DataType)tuple2._2();
            if (leftUdt instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)leftUdt;
                if (rightUdt instanceof UserDefinedType) {
                    UserDefinedType userDefinedType2 = (UserDefinedType)rightUdt;
                    Class clazz = userDefinedType.userClass();
                    Class clazz2 = userDefinedType2.userClass();
                    if (clazz == null) {
                        if (clazz2 == null) return userDefinedType;
                    } else if (clazz.equals(clazz2)) {
                        return userDefinedType;
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                byte lstart = yearMonthIntervalType.startField();
                byte lend = yearMonthIntervalType.endField();
                if (dataType5 instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType2 = (YearMonthIntervalType)dataType5;
                    byte rstart = yearMonthIntervalType2.startField();
                    byte rend = yearMonthIntervalType2.endField();
                    return new YearMonthIntervalType((byte)Math.min(lstart, rstart), (byte)Math.max(lend, rend));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType6 = (DataType)tuple2._2();
            if (dataType instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                byte lstart = dayTimeIntervalType.startField();
                byte lend = dayTimeIntervalType.endField();
                if (dataType6 instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType2 = (DayTimeIntervalType)dataType6;
                    byte rstart = dayTimeIntervalType2.startField();
                    byte rend = dayTimeIntervalType2.endField();
                    return new DayTimeIntervalType((byte)Math.min(lstart, rstart), (byte)Math.max(lend, rend));
                }
            }
        }
        if (tuple2 == null) throw QueryExecutionErrors$.MODULE$.cannotMergeIncompatibleDataTypesError(left, right);
        DataType leftType = (DataType)tuple2._1();
        DataType rightType = (DataType)tuple2._2();
        DataType dataType = leftType;
        DataType dataType7 = rightType;
        if (dataType != null) {
            if (!dataType.equals(dataType7)) throw QueryExecutionErrors$.MODULE$.cannotMergeIncompatibleDataTypesError(left, right);
            return leftType;
        }
        if (dataType7 == null) return leftType;
        throw QueryExecutionErrors$.MODULE$.cannotMergeIncompatibleDataTypesError(left, right);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, StructField> fieldsMap(StructField[] fields) {
        void var2_2;
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        map.sizeHint(fields.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)s -> map.put((Object)s.name(), s));
        return var2_2;
    }

    public Option<StructType> findMissingFields(StructType source, StructType target, Function2<String, String, Object> resolver) {
        ArrayBuffer newFields = ArrayBuffer$.MODULE$.empty();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])target.fields()), (Function1 & Serializable)field -> {
            Option found = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])source.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StructType$.$anonfun$findMissingFields$2(resolver, field, f)));
            return found.isEmpty() ? newFields.$plus$eq(field) : (StructType$.bothStructType$1(((StructField)found.get()).dataType(), field.dataType()) && !((StructField)found.get()).dataType().sameType(field.dataType()) ? MODULE$.findMissingFields((StructType)((StructField)found.get()).dataType(), (StructType)field.dataType(), resolver).map((Function1 & Serializable)missingType -> {
                StructField qual$1 = (StructField)found.get();
                StructType x$1 = missingType;
                String x$2 = qual$1.copy$default$1();
                boolean x$3 = qual$1.copy$default$3();
                Metadata x$4 = qual$1.copy$default$4();
                return (ArrayBuffer)newFields.$plus$eq((Object)qual$1.copy(x$2, x$1, x$3, x$4));
            }) : BoxedUnit.UNIT);
        });
        return newFields.isEmpty() ? None$.MODULE$ : new Some((Object)this.apply((Seq<StructField>)newFields.toSeq()));
    }

    public StructType apply(StructField[] fields) {
        return new StructType(fields);
    }

    public Option<StructField[]> unapply(StructType x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.fields());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StructType$.class);
    }

    public static final /* synthetic */ void $anonfun$merge$2(Map rightMapped$1, ArrayBuffer newFields$1, StructField x0$1) {
        StructField structField = x0$1;
        if (structField == null) {
            throw new MatchError((Object)structField);
        }
        String leftName = structField.name();
        DataType leftType = structField.dataType();
        boolean leftNullable = structField.nullable();
        rightMapped$1.get((Object)leftName).map((Function1 & Serializable)x0$2 -> {
            StructField structField;
            StructField structField2 = x0$2;
            if (structField2 != null) {
                String rightName = structField2.name();
                DataType rightType = structField2.dataType();
                boolean rightNullable = structField2.nullable();
                try {
                    DataType x$1 = MODULE$.merge(leftType, rightType);
                    boolean x$2 = leftNullable || rightNullable;
                    String x$3 = structField.copy$default$1();
                    Metadata x$4 = structField.copy$default$4();
                    structField = structField.copy(x$3, x$1, x$2, x$4);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        throw QueryExecutionErrors$.MODULE$.failedMergingFieldsError(leftName, rightName, e);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError((Object)structField2);
            }
            StructField structField3 = structField;
            return structField3;
        }).orElse((Function0 & Serializable)() -> new Some((Object)structField)).foreach((Function1 & Serializable)x$10 -> (ArrayBuffer)newFields$1.$plus$eq(x$10));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$merge$6(Map leftMapped$1, StructField f) {
        return leftMapped$1.get((Object)f.name()).nonEmpty();
    }

    private static final boolean bothStructType$1(DataType dt1, DataType dt2) {
        return dt1 instanceof StructType && dt2 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$findMissingFields$2(Function2 resolver$2, StructField field$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)field$1.name(), (Object)f.name()));
    }

    private StructType$() {
    }
}

