/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DoubleExactNumeric$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import sun.util.calendar.ZoneInfo;

public final class DateTimeUtils$ {
    public static final DateTimeUtils$ MODULE$ = new DateTimeUtils$();
    private static final TimeZone TimeZoneUTC = TimeZone.getTimeZone("UTC");
    private static final String TIMEZONE_OPTION = "timeZone";
    private static final UTF8String gmtUtf8 = UTF8String.fromString((String)"GMT");
    private static final long MIN_SECONDS = Math.floorDiv(Long.MIN_VALUE, 1000000L);
    private static final int SUNDAY = 3;
    private static final int MONDAY = 4;
    private static final int TUESDAY = 5;
    private static final int WEDNESDAY = 6;
    private static final int THURSDAY = 0;
    private static final int FRIDAY = 1;
    private static final int SATURDAY = 2;
    private static final int TRUNC_INVALID = -1;
    private static final int TRUNC_TO_MICROSECOND = 0;
    private static final int MIN_LEVEL_OF_TIMESTAMP_TRUNC = MODULE$.TRUNC_TO_MICROSECOND();
    private static final int TRUNC_TO_MILLISECOND = 1;
    private static final int TRUNC_TO_SECOND = 2;
    private static final int TRUNC_TO_MINUTE = 3;
    private static final int TRUNC_TO_HOUR = 4;
    private static final int TRUNC_TO_DAY = 5;
    private static final int TRUNC_TO_WEEK = 6;
    private static final int MIN_LEVEL_OF_DATE_TRUNC = MODULE$.TRUNC_TO_WEEK();
    private static final int TRUNC_TO_MONTH = 7;
    private static final int TRUNC_TO_QUARTER = 8;
    private static final int TRUNC_TO_YEAR = 9;
    private static final Regex specialValueRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\p{Alpha}+)\\p{Blank}*(.*)"));
    private static final Map<String, Function2<Temporal, Temporal, Object>> timestampDiffMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MICROSECOND"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MICROS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MILLISECOND"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MILLIS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SECOND"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.SECONDS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MINUTE"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MINUTES.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOUR"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.HOURS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DAY"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.DAYS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WEEK"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.WEEKS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MONTH"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MONTHS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUARTER"), (Function2 & Serializable)(startTs, endTs) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.$anonfun$timestampDiffMap$9(startTs, endTs))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"YEAR"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.YEARS.between(x$1, x$2)))}));

    public final int JULIAN_DAY_OF_EPOCH() {
        return 2440588;
    }

    public final TimeZone TimeZoneUTC() {
        return TimeZoneUTC;
    }

    public String TIMEZONE_OPTION() {
        return TIMEZONE_OPTION;
    }

    public ZoneId getZoneId(String timeZoneId) {
        String formattedZoneId = timeZoneId.replaceFirst("(\\+|\\-)(\\d):", "$10$2:").replaceFirst("(\\+|\\-)(\\d\\d):(\\d)$", "$1$2:0$3");
        return ZoneId.of(formattedZoneId, ZoneId.SHORT_IDS);
    }

    public TimeZone getTimeZone(String timeZoneId) {
        return TimeZone.getTimeZone(this.getZoneId(timeZoneId));
    }

    public int microsToDays(long micros, ZoneId zoneId) {
        return this.localDateToDays(this.getLocalDateTime(micros, zoneId).toLocalDate());
    }

    public long daysToMicros(int days, ZoneId zoneId) {
        Instant instant = this.daysToLocalDate(days).atStartOfDay(zoneId).toInstant();
        return this.instantToMicros(instant);
    }

    public LocalDateTime microsToLocalDateTime(long micros) {
        return this.getLocalDateTime(micros, ZoneOffset.UTC);
    }

    public long localDateTimeToMicros(LocalDateTime localDateTime) {
        return this.instantToMicros(localDateTime.toInstant(ZoneOffset.UTC));
    }

    public int fromJavaDate(Date date) {
        long millisUtc = date.getTime();
        long millisLocal = millisUtc + (long)TimeZone.getDefault().getOffset(millisUtc);
        int julianDays = Math.toIntExact(Math.floorDiv(millisLocal, 86400000L));
        return RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(julianDays);
    }

    public int anyToDays(Object obj) {
        int n;
        Object object = obj;
        if (object instanceof Date) {
            Date date = (Date)object;
            n = this.fromJavaDate(date);
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            n = this.localDateToDays(localDate);
        } else {
            throw new MatchError(object);
        }
        return n;
    }

    public Date toJavaDate(int days) {
        int n;
        int rebasedDays = RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
        long localMillis = Math.multiplyExact((long)rebasedDays, 86400000L);
        TimeZone timeZone = TimeZone.getDefault();
        if (timeZone instanceof ZoneInfo) {
            ZoneInfo zoneInfo = (ZoneInfo)timeZone;
            n = zoneInfo.getOffsetsByWall(localMillis, null);
        } else if (timeZone != null) {
            TimeZone timeZone2 = timeZone;
            n = timeZone2.getOffset(localMillis - (long)timeZone2.getRawOffset());
        } else {
            throw new MatchError((Object)timeZone);
        }
        int timeZoneOffset = n;
        return new Date(localMillis - (long)timeZoneOffset);
    }

    public Timestamp toJavaTimestamp(long micros) {
        long rebasedMicros = RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(micros);
        long seconds = Math.floorDiv(rebasedMicros, 1000000L);
        Timestamp ts = new Timestamp(seconds * 1000L);
        long nanos = (rebasedMicros - seconds * 1000000L) * 1000L;
        ts.setNanos((int)nanos);
        return ts;
    }

    public long fromJavaTimestamp(Timestamp t) {
        long micros = this.millisToMicros(t.getTime()) + (long)t.getNanos() / 1000L % 1000L;
        return RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(micros);
    }

    public long anyToMicros(Object obj) {
        long l;
        Object object = obj;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            l = this.fromJavaTimestamp(timestamp);
        } else if (object instanceof Instant) {
            Instant instant = (Instant)object;
            l = this.instantToMicros(instant);
        } else {
            throw new MatchError(object);
        }
        return l;
    }

    public long fromJulianDay(int days, long nanos) {
        return (long)(days - 2440588) * 86400000000L + nanos / 1000L;
    }

    public Tuple2<Object, Object> toJulianDay(long micros) {
        long julianUs = micros + 210866803200000000L;
        long days = julianUs / 86400000000L;
        long us = julianUs % 86400000000L;
        return new Tuple2.mcIJ.sp((int)days, TimeUnit.MICROSECONDS.toNanos(us));
    }

    public long microsToMillis(long micros) {
        return Math.floorDiv(micros, 1000L);
    }

    public long millisToMicros(long millis) {
        return Math.multiplyExact(millis, 1000L);
    }

    private final UTF8String gmtUtf8() {
        return gmtUtf8;
    }

    public UTF8String cleanLegacyTimestampStr(UTF8String s) {
        return s.replace(this.gmtUtf8(), UTF8String.EMPTY_UTF8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple3<int[], Option<ZoneId>, Object> parseTimestampString(UTF8String s) {
        if (s == null || s.trimAll().numBytes() == 0) {
            return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        None$ tz = None$.MODULE$;
        int[] segments = new int[]{1, 1, 1, 0, 0, 0, 0, 0, 0};
        int i = 0;
        int currentSegmentValue = 0;
        int currentSegmentDigits = 0;
        byte[] bytes = s.trimAll().getBytes();
        int j = 0;
        int digitsMilli = 0;
        boolean justTime = false;
        None$ yearSign = None$.MODULE$;
        if (bytes[j] == 45 || bytes[j] == 43) {
            yearSign = bytes[j] == 45 ? new Some((Object)BoxesRunTime.boxToInteger((int)-1)) : new Some((Object)BoxesRunTime.boxToInteger((int)1));
            ++j;
        }
        while (j < bytes.length) {
            byte b = bytes[j];
            int parsedValue = b - (byte)48;
            if (parsedValue < 0 || parsedValue > 9) {
                if (j == 0 && b == 84) {
                    justTime = true;
                    i += 3;
                } else if (i < 2) {
                    if (b == 45) {
                        if (!DateTimeUtils$.isValidDigits$1(i, currentSegmentDigits)) {
                            return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        }
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        currentSegmentDigits = 0;
                        ++i;
                    } else {
                        if (i != 0 || b != 58 || !yearSign.isEmpty()) return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        justTime = true;
                        if (!DateTimeUtils$.isValidDigits$1(3, currentSegmentDigits)) {
                            return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        }
                        segments[3] = currentSegmentValue;
                        currentSegmentValue = 0;
                        currentSegmentDigits = 0;
                        i = 4;
                    }
                } else if (i == 2) {
                    if (b != 32 && b != 84) return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    if (!DateTimeUtils$.isValidDigits$1(i, currentSegmentDigits)) {
                        return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    segments[i] = currentSegmentValue;
                    currentSegmentValue = 0;
                    currentSegmentDigits = 0;
                    ++i;
                } else if (i == 3 || i == 4) {
                    if (b != 58) return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    if (!DateTimeUtils$.isValidDigits$1(i, currentSegmentDigits)) {
                        return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    segments[i] = currentSegmentValue;
                    currentSegmentValue = 0;
                    currentSegmentDigits = 0;
                    ++i;
                } else if (i == 5 || i == 6) {
                    if (b == 46 && i == 5) {
                        if (!DateTimeUtils$.isValidDigits$1(i, currentSegmentDigits)) {
                            return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        }
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        currentSegmentDigits = 0;
                        ++i;
                    } else {
                        if (!DateTimeUtils$.isValidDigits$1(i, currentSegmentDigits)) {
                            return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        }
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        currentSegmentDigits = 0;
                        ++i;
                        tz = new Some((Object)new String(bytes, j, bytes.length - j));
                        j = bytes.length - 1;
                    }
                    if (i == 6 && b != 46) {
                        ++i;
                    }
                } else {
                    if (i >= segments.length || b != 58 && b != 32) return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    if (!DateTimeUtils$.isValidDigits$1(i, currentSegmentDigits)) {
                        return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    segments[i] = currentSegmentValue;
                    currentSegmentValue = 0;
                    currentSegmentDigits = 0;
                    ++i;
                }
            } else {
                if (i == 6) {
                    ++digitsMilli;
                }
                if (i != 6 || currentSegmentDigits < 6) {
                    currentSegmentValue = currentSegmentValue * 10 + parsedValue;
                }
                ++currentSegmentDigits;
            }
            ++j;
        }
        if (!DateTimeUtils$.isValidDigits$1(i, currentSegmentDigits)) {
            return new Tuple3(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        segments[i] = currentSegmentValue;
        while (digitsMilli < 6) {
            segments[6] = segments[6] * 10;
            ++digitsMilli;
        }
        Option zoneId = tz.map((Function1 & Serializable)zoneName -> MODULE$.getZoneId(zoneName.trim()));
        segments[0] = segments[0] * BoxesRunTime.unboxToInt((Object)yearSign.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        return new Tuple3((Object)segments, (Object)zoneId, (Object)BoxesRunTime.boxToBoolean((boolean)justTime));
    }

    public Option<Object> stringToTimestamp(UTF8String s, ZoneId timeZoneId) {
        None$ none$;
        try {
            Tuple3<int[], Option<ZoneId>, Object> tuple3 = this.parseTimestampString(s);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int[] segments = (int[])tuple3._1();
            Option parsedZoneId = (Option)tuple3._2();
            boolean justTime = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)segments, (Object)parsedZoneId, (Object)BoxesRunTime.boxToBoolean((boolean)justTime));
            Tuple3 tuple33 = tuple32;
            int[] segments2 = (int[])tuple33._1();
            Option parsedZoneId2 = (Option)tuple33._2();
            boolean justTime2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.intArrayOps(segments2))) {
                return None$.MODULE$;
            }
            ZoneId zoneId = (ZoneId)parsedZoneId2.getOrElse((Function0 & Serializable)() -> timeZoneId);
            long nanoseconds = TimeUnit.MICROSECONDS.toNanos(segments2[6]);
            LocalTime localTime = LocalTime.of(segments2[3], segments2[4], segments2[5], (int)nanoseconds);
            LocalDate localDate = justTime2 ? LocalDate.now(zoneId) : LocalDate.of(segments2[0], segments2[1], segments2[2]);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId);
            Instant instant = Instant.from(zonedDateTime);
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)this.instantToMicros(instant)));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public long stringToTimestampAnsi(UTF8String s, ZoneId timeZoneId, String errorContext) {
        return BoxesRunTime.unboxToLong((Object)this.stringToTimestamp(s, timeZoneId).getOrElse((Function0 & Serializable)() -> {
            throw QueryExecutionErrors$.MODULE$.invalidInputInCastToDatetimeError(s, StringType$.MODULE$, TimestampType$.MODULE$, errorContext);
        }));
    }

    public String stringToTimestampAnsi$default$3() {
        return "";
    }

    public long doubleToTimestampAnsi(double d, String errorContext) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw QueryExecutionErrors$.MODULE$.invalidInputInCastToDatetimeError(BoxesRunTime.boxToDouble((double)d), DoubleType$.MODULE$, TimestampType$.MODULE$, errorContext);
        }
        return DoubleExactNumeric$.MODULE$.toLong(d * (double)1000000L);
    }

    public Option<Object> stringToTimestampWithoutTimeZone(UTF8String s, boolean allowTimeZone) {
        None$ none$;
        try {
            Tuple3<int[], Option<ZoneId>, Object> tuple3 = this.parseTimestampString(s);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int[] segments = (int[])tuple3._1();
            Option zoneIdOpt = (Option)tuple3._2();
            boolean justTime = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)segments, (Object)zoneIdOpt, (Object)BoxesRunTime.boxToBoolean((boolean)justTime));
            Tuple3 tuple33 = tuple32;
            int[] segments2 = (int[])tuple33._1();
            Option zoneIdOpt2 = (Option)tuple33._2();
            boolean justTime2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.intArrayOps(segments2)) || justTime2 || !allowTimeZone && zoneIdOpt2.isDefined()) {
                return None$.MODULE$;
            }
            long nanoseconds = TimeUnit.MICROSECONDS.toNanos(segments2[6]);
            LocalTime localTime = LocalTime.of(segments2[3], segments2[4], segments2[5], (int)nanoseconds);
            LocalDate localDate = LocalDate.of(segments2[0], segments2[1], segments2[2]);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)this.localDateTimeToMicros(localDateTime)));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public Option<Object> stringToTimestampWithoutTimeZone(UTF8String s) {
        return this.stringToTimestampWithoutTimeZone(s, true);
    }

    public long stringToTimestampWithoutTimeZoneAnsi(UTF8String s, String errorContext) {
        return BoxesRunTime.unboxToLong((Object)this.stringToTimestampWithoutTimeZone(s, true).getOrElse((Function0 & Serializable)() -> {
            throw QueryExecutionErrors$.MODULE$.invalidInputInCastToDatetimeError(s, StringType$.MODULE$, TimestampNTZType$.MODULE$, errorContext);
        }));
    }

    private long MIN_SECONDS() {
        return MIN_SECONDS;
    }

    public long instantToMicros(Instant instant) {
        long l;
        long secs = instant.getEpochSecond();
        if (secs == this.MIN_SECONDS()) {
            long us = Math.multiplyExact(secs + 1L, 1000000L);
            l = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()) - 1000000L);
        } else {
            long us = Math.multiplyExact(secs, 1000000L);
            l = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
        }
        return l;
    }

    public Instant microsToInstant(long micros) {
        long secs = Math.floorDiv(micros, 1000000L);
        long mos = micros - secs * 1000000L;
        return Instant.ofEpochSecond(secs, mos * 1000L);
    }

    public int localDateToDays(LocalDate localDate) {
        return Math.toIntExact(localDate.toEpochDay());
    }

    public LocalDate daysToLocalDate(int days) {
        return LocalDate.ofEpochDay(days);
    }

    public Option<Object> stringToDate(UTF8String s) {
        Some some;
        int j;
        if (s == null || s.trimAll().numBytes() == 0) {
            return None$.MODULE$;
        }
        int[] segments = new int[]{1, 1, 1};
        int sign = 1;
        int i = 0;
        int currentSegmentValue = 0;
        int currentSegmentDigits = 0;
        byte[] bytes = s.trimAll().getBytes();
        if (bytes[j = 0] == 45 || bytes[j] == 43) {
            sign = bytes[j] == 45 ? -1 : 1;
            ++j;
        }
        while (j < bytes.length && i < 3 && bytes[j] != 32 && bytes[j] != 84) {
            byte b = bytes[j];
            if (i < 2 && b == 45) {
                if (!DateTimeUtils$.isValidDigits$2(i, currentSegmentDigits)) {
                    return None$.MODULE$;
                }
                segments[i] = currentSegmentValue;
                currentSegmentValue = 0;
                currentSegmentDigits = 0;
                ++i;
            } else {
                int parsedValue = b - (byte)48;
                if (parsedValue < 0 || parsedValue > 9) {
                    return None$.MODULE$;
                }
                currentSegmentValue = currentSegmentValue * 10 + parsedValue;
                ++currentSegmentDigits;
            }
            ++j;
        }
        if (!DateTimeUtils$.isValidDigits$2(i, currentSegmentDigits)) {
            return None$.MODULE$;
        }
        if (i < 2 && j < bytes.length) {
            return None$.MODULE$;
        }
        segments[i] = currentSegmentValue;
        try {
            LocalDate localDate = LocalDate.of(sign * segments[0], segments[1], segments[2]);
            some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localDateToDays(localDate)));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public int stringToDateAnsi(UTF8String s, String errorContext) {
        return BoxesRunTime.unboxToInt((Object)this.stringToDate(s).getOrElse((Function0 & Serializable)() -> {
            throw QueryExecutionErrors$.MODULE$.invalidInputInCastToDatetimeError(s, StringType$.MODULE$, DateType$.MODULE$, errorContext);
        }));
    }

    public String stringToDateAnsi$default$2() {
        return "";
    }

    private LocalDateTime getLocalDateTime(long micros, ZoneId zoneId) {
        return this.microsToInstant(micros).atZone(zoneId).toLocalDateTime();
    }

    public int getHours(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getHour();
    }

    public int getMinutes(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getMinute();
    }

    public int getSeconds(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getSecond();
    }

    public Decimal getSecondsWithFraction(long micros, ZoneId zoneId) {
        return Decimal$.MODULE$.apply(this.getMicroseconds(micros, zoneId), 8, 6);
    }

    public int getMicroseconds(long micros, ZoneId zoneId) {
        LocalDateTime lt = this.getLocalDateTime(micros, zoneId);
        return (int)(lt.getLong(ChronoField.MICRO_OF_SECOND) + (long)lt.getSecond() * 1000000L);
    }

    public int getDayInYear(int days) {
        return this.daysToLocalDate(days).getDayOfYear();
    }

    public int getYear(int days) {
        return this.daysToLocalDate(days).getYear();
    }

    public int getWeekBasedYear(int days) {
        return this.daysToLocalDate(days).get(IsoFields.WEEK_BASED_YEAR);
    }

    public int getQuarter(int days) {
        return this.daysToLocalDate(days).get(IsoFields.QUARTER_OF_YEAR);
    }

    public int getMonth(int days) {
        return this.daysToLocalDate(days).getMonthValue();
    }

    public int getDayOfMonth(int days) {
        return this.daysToLocalDate(days).getDayOfMonth();
    }

    public int getDayOfWeek(int days) {
        return LocalDate.ofEpochDay(days).getDayOfWeek().plus(1L).getValue();
    }

    public int getWeekDay(int days) {
        return LocalDate.ofEpochDay(days).getDayOfWeek().ordinal();
    }

    public int getWeekOfYear(int days) {
        return LocalDate.ofEpochDay(days).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
    }

    public int dateAddMonths(int days, int months) {
        return this.localDateToDays(this.daysToLocalDate(days).plusMonths(months));
    }

    public long timestampAddMonths(long micros, int months, ZoneId zoneId) {
        return this.instantToMicros(this.microsToInstant(micros).atZone(zoneId).plusMonths(months).toInstant());
    }

    public long timestampAddDayTime(long micros, long dayTime, ZoneId zoneId) {
        long days = dayTime / 86400000000L;
        long microseconds = dayTime - days * 86400000000L;
        ZonedDateTime resultTimestamp = this.microsToInstant(micros).atZone(zoneId).plusDays(days).plus(microseconds, ChronoUnit.MICROS);
        return this.instantToMicros(resultTimestamp.toInstant());
    }

    public long timestampAddInterval(long start, int months, int days, long microseconds, ZoneId zoneId) {
        ZonedDateTime resultTimestamp = this.microsToInstant(start).atZone(zoneId).plusMonths(months).plusDays(days).plus(microseconds, ChronoUnit.MICROS);
        return this.instantToMicros(resultTimestamp.toInstant());
    }

    public long timestampNTZAddInterval(long start, int months, int days, long microseconds, ZoneId zoneId) {
        LocalDateTime localDateTime = this.microsToLocalDateTime(start).plusMonths(months).plusDays(days).plus(microseconds, ChronoUnit.MICROS);
        return this.localDateTimeToMicros(localDateTime);
    }

    public int dateAddInterval(int start, CalendarInterval interval) {
        if (interval.microseconds != 0L) {
            throw QueryExecutionErrors$.MODULE$.ansiIllegalArgumentError("Cannot add hours, minutes or seconds, milliseconds, microseconds to a date");
        }
        LocalDate ld = this.daysToLocalDate(start).plusMonths(interval.months).plusDays(interval.days);
        return this.localDateToDays(ld);
    }

    private Tuple4<Object, Object, Object, Object> splitDate(int days) {
        LocalDate ld = this.daysToLocalDate(days);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)ld.getYear()), (Object)BoxesRunTime.boxToInteger((int)ld.getMonthValue()), (Object)BoxesRunTime.boxToInteger((int)ld.getDayOfMonth()), (Object)BoxesRunTime.boxToInteger((int)(ld.lengthOfMonth() - ld.getDayOfMonth())));
    }

    public double monthsBetween(long micros1, long micros2, boolean roundOff, ZoneId zoneId) {
        int date1 = this.microsToDays(micros1, zoneId);
        int date2 = this.microsToDays(micros2, zoneId);
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date1);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int year1 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int monthInYear1 = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int dayInMonth1 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int daysToMonthEnd1 = BoxesRunTime.unboxToInt((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year1), (Object)BoxesRunTime.boxToInteger((int)monthInYear1), (Object)BoxesRunTime.boxToInteger((int)dayInMonth1), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd1));
        Tuple4 tuple43 = tuple42;
        int year12 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int monthInYear12 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int dayInMonth12 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int daysToMonthEnd12 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        Tuple4<Object, Object, Object, Object> tuple44 = this.splitDate(date2);
        if (tuple44 == null) {
            throw new MatchError(tuple44);
        }
        int year2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
        int dayInMonth2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
        int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
        Tuple4 tuple45 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)monthInYear2), (Object)BoxesRunTime.boxToInteger((int)dayInMonth2), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd2));
        Tuple4 tuple46 = tuple45;
        int year22 = BoxesRunTime.unboxToInt((Object)tuple46._1());
        int monthInYear22 = BoxesRunTime.unboxToInt((Object)tuple46._2());
        int dayInMonth22 = BoxesRunTime.unboxToInt((Object)tuple46._3());
        int daysToMonthEnd22 = BoxesRunTime.unboxToInt((Object)tuple46._4());
        int months1 = year12 * 12 + monthInYear12;
        int months2 = year22 * 12 + monthInYear22;
        double monthDiff = months1 - months2;
        if (dayInMonth12 == dayInMonth22 || daysToMonthEnd12 == 0 && daysToMonthEnd22 == 0) {
            return monthDiff;
        }
        long secondsInDay1 = TimeUnit.MICROSECONDS.toSeconds(micros1 - this.daysToMicros(date1, zoneId));
        long secondsInDay2 = TimeUnit.MICROSECONDS.toSeconds(micros2 - this.daysToMicros(date2, zoneId));
        long secondsDiff = (long)(dayInMonth12 - dayInMonth22) * 86400L + secondsInDay1 - secondsInDay2;
        long secondsInMonth = TimeUnit.DAYS.toSeconds(31L);
        double diff = monthDiff + (double)secondsDiff / (double)secondsInMonth;
        return roundOff ? (double)package$.MODULE$.round(diff * 1.0E8) / 1.0E8 : diff;
    }

    private int SUNDAY() {
        return SUNDAY;
    }

    private int MONDAY() {
        return MONDAY;
    }

    private int TUESDAY() {
        return TUESDAY;
    }

    private int WEDNESDAY() {
        return WEDNESDAY;
    }

    private int THURSDAY() {
        return THURSDAY;
    }

    private int FRIDAY() {
        return FRIDAY;
    }

    private int SATURDAY() {
        return SATURDAY;
    }

    public int getDayOfWeekFromString(UTF8String string) {
        int n;
        block33: {
            block26: {
                block29: {
                    block32: {
                        block28: {
                            block31: {
                                block30: {
                                    block27: {
                                        String dowString = string.toString().toUpperCase(Locale.ROOT);
                                        String string2 = dowString;
                                        switch (string2 == null ? 0 : string2.hashCode()) {
                                            case -2015173360: {
                                                if (!"MONDAY".equals(string2)) break block26;
                                                break block27;
                                            }
                                            case -1940284966: {
                                                if (!"THURSDAY".equals(string2)) break block26;
                                                break block28;
                                            }
                                            case -1837857328: {
                                                if ("SUNDAY".equals(string2)) {
                                                    break;
                                                }
                                                break block26;
                                            }
                                            case -1331574855: {
                                                if (!"SATURDAY".equals(string2)) break block26;
                                                break block29;
                                            }
                                            case -259361235: {
                                                if (!"TUESDAY".equals(string2)) break block26;
                                                break block30;
                                            }
                                            case -114841802: {
                                                if (!"WEDNESDAY".equals(string2)) break block26;
                                                break block31;
                                            }
                                            case 2252: {
                                                if (!"FR".equals(string2)) break block26;
                                                break block32;
                                            }
                                            case 2466: {
                                                if (!"MO".equals(string2)) break block26;
                                                break block27;
                                            }
                                            case 2638: {
                                                if (!"SA".equals(string2)) break block26;
                                                break block29;
                                            }
                                            case 2658: {
                                                if ("SU".equals(string2)) {
                                                    break;
                                                }
                                                break block26;
                                            }
                                            case 2676: {
                                                if (!"TH".equals(string2)) break block26;
                                                break block28;
                                            }
                                            case 2689: {
                                                if (!"TU".equals(string2)) break block26;
                                                break block30;
                                            }
                                            case 2766: {
                                                if (!"WE".equals(string2)) break block26;
                                                break block31;
                                            }
                                            case 69885: {
                                                if (!"FRI".equals(string2)) break block26;
                                                break block32;
                                            }
                                            case 76524: {
                                                if (!"MON".equals(string2)) break block26;
                                                break block27;
                                            }
                                            case 81862: {
                                                if (!"SAT".equals(string2)) break block26;
                                                break block29;
                                            }
                                            case 82476: {
                                                if ("SUN".equals(string2)) {
                                                    break;
                                                }
                                                break block26;
                                            }
                                            case 83041: {
                                                if (!"THU".equals(string2)) break block26;
                                                break block28;
                                            }
                                            case 83428: {
                                                if (!"TUE".equals(string2)) break block26;
                                                break block30;
                                            }
                                            case 85814: {
                                                if (!"WED".equals(string2)) break block26;
                                                break block31;
                                            }
                                            case 2082011487: {
                                                if (!"FRIDAY".equals(string2)) break block26;
                                                break block32;
                                            }
                                            default: {
                                                break block26;
                                            }
                                        }
                                        n = this.SUNDAY();
                                        break block33;
                                    }
                                    n = this.MONDAY();
                                    break block33;
                                }
                                n = this.TUESDAY();
                                break block33;
                            }
                            n = this.WEDNESDAY();
                            break block33;
                        }
                        n = this.THURSDAY();
                        break block33;
                    }
                    n = this.FRIDAY();
                    break block33;
                }
                n = this.SATURDAY();
                break block33;
            }
            throw new IllegalArgumentException(new StringBuilder(31).append("Illegal input for day of week: ").append(string).toString());
        }
        return n;
    }

    public int getNextDateForDayOfWeek(int startDay, int dayOfWeek) {
        return startDay + 1 + ((dayOfWeek - 1 - startDay) % 7 + 7) % 7;
    }

    public int getLastDayOfMonth(int days) {
        LocalDate localDate = this.daysToLocalDate(days);
        return days - localDate.getDayOfMonth() + localDate.lengthOfMonth();
    }

    public int TRUNC_INVALID() {
        return TRUNC_INVALID;
    }

    public int TRUNC_TO_MICROSECOND() {
        return TRUNC_TO_MICROSECOND;
    }

    public int MIN_LEVEL_OF_TIMESTAMP_TRUNC() {
        return MIN_LEVEL_OF_TIMESTAMP_TRUNC;
    }

    public int TRUNC_TO_MILLISECOND() {
        return TRUNC_TO_MILLISECOND;
    }

    public int TRUNC_TO_SECOND() {
        return TRUNC_TO_SECOND;
    }

    public int TRUNC_TO_MINUTE() {
        return TRUNC_TO_MINUTE;
    }

    public int TRUNC_TO_HOUR() {
        return TRUNC_TO_HOUR;
    }

    public int TRUNC_TO_DAY() {
        return TRUNC_TO_DAY;
    }

    public int TRUNC_TO_WEEK() {
        return TRUNC_TO_WEEK;
    }

    public int MIN_LEVEL_OF_DATE_TRUNC() {
        return MIN_LEVEL_OF_DATE_TRUNC;
    }

    public int TRUNC_TO_MONTH() {
        return TRUNC_TO_MONTH;
    }

    public int TRUNC_TO_QUARTER() {
        return TRUNC_TO_QUARTER;
    }

    public int TRUNC_TO_YEAR() {
        return TRUNC_TO_YEAR;
    }

    public int truncDate(int days, int level) {
        int n;
        int n2 = level;
        if (this.TRUNC_TO_WEEK() == n2) {
            n = this.getNextDateForDayOfWeek(days - 7, this.MONDAY());
        } else if (this.TRUNC_TO_MONTH() == n2) {
            n = days - this.getDayOfMonth(days) + 1;
        } else if (this.TRUNC_TO_QUARTER() == n2) {
            n = this.localDateToDays(this.daysToLocalDate(days).with(IsoFields.DAY_OF_QUARTER, 1L));
        } else if (this.TRUNC_TO_YEAR() == n2) {
            n = days - this.getDayInYear(days) + 1;
        } else {
            throw QueryExecutionErrors$.MODULE$.unreachableError(new StringBuilder(23).append(": Invalid trunc level: ").append(level).toString());
        }
        return n;
    }

    private long truncToUnit(long micros, ZoneId zoneId, ChronoUnit unit) {
        ZonedDateTime truncated = this.microsToInstant(micros).atZone(zoneId).truncatedTo(unit);
        return this.instantToMicros(truncated.toInstant());
    }

    public long truncTimestamp(long micros, int level, ZoneId zoneId) {
        long l;
        int n = level;
        if (this.TRUNC_TO_MICROSECOND() == n) {
            l = micros;
        } else if (this.TRUNC_TO_MILLISECOND() == n) {
            l = micros - Math.floorMod(micros, 1000L);
        } else if (this.TRUNC_TO_SECOND() == n) {
            l = micros - Math.floorMod(micros, 1000000L);
        } else if (this.TRUNC_TO_MINUTE() == n) {
            l = this.truncToUnit(micros, zoneId, ChronoUnit.MINUTES);
        } else if (this.TRUNC_TO_HOUR() == n) {
            l = this.truncToUnit(micros, zoneId, ChronoUnit.HOURS);
        } else if (this.TRUNC_TO_DAY() == n) {
            l = this.truncToUnit(micros, zoneId, ChronoUnit.DAYS);
        } else {
            int dDays = this.microsToDays(micros, zoneId);
            l = this.daysToMicros(this.truncDate(dDays, level), zoneId);
        }
        return l;
    }

    public int parseTruncLevel(UTF8String format) {
        int n;
        block20: {
            int n2;
            block22: {
                block21: {
                    block24: {
                        block23: {
                            block19: {
                                if (format != null) break block19;
                                n = this.TRUNC_INVALID();
                                break block20;
                            }
                            String string = format.toString().toUpperCase(Locale.ROOT);
                            switch (string == null ? 0 : string.hashCode()) {
                                case -2020697580: {
                                    if (!"MINUTE".equals(string)) break block21;
                                    n2 = this.TRUNC_TO_MINUTE();
                                    break block22;
                                }
                                case -1852950412: {
                                    if (!"SECOND".equals(string)) break block21;
                                    n2 = this.TRUNC_TO_SECOND();
                                    break block22;
                                }
                                case -199595423: {
                                    if (!"MILLISECOND".equals(string)) break block21;
                                    n2 = this.TRUNC_TO_MILLISECOND();
                                    break block22;
                                }
                                case 2176: {
                                    if ("DD".equals(string)) {
                                        break;
                                    }
                                    break block21;
                                }
                                case 2464: {
                                    if (!"MM".equals(string)) break block21;
                                    break block23;
                                }
                                case 2848: {
                                    if (!"YY".equals(string)) break block21;
                                    break block24;
                                }
                                case 67452: {
                                    if ("DAY".equals(string)) {
                                        break;
                                    }
                                    break block21;
                                }
                                case 76524: {
                                    if (!"MON".equals(string)) break block21;
                                    break block23;
                                }
                                case 2223588: {
                                    if (!"HOUR".equals(string)) break block21;
                                    n2 = this.TRUNC_TO_HOUR();
                                    break block22;
                                }
                                case 2660340: {
                                    if (!"WEEK".equals(string)) break block21;
                                    n2 = this.TRUNC_TO_WEEK();
                                    break block22;
                                }
                                case 2719805: {
                                    if (!"YEAR".equals(string)) break block21;
                                    break block24;
                                }
                                case 2739776: {
                                    if (!"YYYY".equals(string)) break block21;
                                    break block24;
                                }
                                case 73542240: {
                                    if (!"MONTH".equals(string)) break block21;
                                    break block23;
                                }
                                case 1369386636: {
                                    if (!"QUARTER".equals(string)) break block21;
                                    n2 = this.TRUNC_TO_QUARTER();
                                    break block22;
                                }
                                case 1784607768: {
                                    if (!"MICROSECOND".equals(string)) break block21;
                                    n2 = this.TRUNC_TO_MICROSECOND();
                                    break block22;
                                }
                                default: {
                                    break block21;
                                }
                            }
                            n2 = this.TRUNC_TO_DAY();
                            break block22;
                        }
                        n2 = this.TRUNC_TO_MONTH();
                        break block22;
                    }
                    n2 = this.TRUNC_TO_YEAR();
                    break block22;
                }
                n2 = this.TRUNC_INVALID();
            }
            n = n2;
        }
        return n;
    }

    public long convertTz(long micros, ZoneId fromZone, ZoneId toZone) {
        ZonedDateTime rebasedDateTime = this.getLocalDateTime(micros, toZone).atZone(fromZone);
        return this.instantToMicros(rebasedDateTime.toInstant());
    }

    public long convertTimestampNtzToAnotherTz(String sourceTz, String targetTz, long micros) {
        LocalDateTime ldt = this.microsToLocalDateTime(micros).atZone(this.getZoneId(sourceTz)).withZoneSameInstant(this.getZoneId(targetTz)).toLocalDateTime();
        return this.localDateTimeToMicros(ldt);
    }

    public long fromUTCTime(long micros, String timeZone) {
        return this.convertTz(micros, ZoneOffset.UTC, this.getZoneId(timeZone));
    }

    public long toUTCTime(long micros, String timeZone) {
        return this.convertTz(micros, this.getZoneId(timeZone), ZoneOffset.UTC);
    }

    public long currentTimestamp() {
        return this.instantToMicros(Instant.now());
    }

    public int currentDate(ZoneId zoneId) {
        return this.localDateToDays(LocalDate.now(zoneId));
    }

    private ZonedDateTime today(ZoneId zoneId) {
        return Instant.now().atZone(zoneId).with(LocalTime.MIDNIGHT);
    }

    private Regex specialValueRe() {
        return specialValueRe;
    }

    private Option<String> extractSpecialValue(String input) {
        String z;
        String v;
        Option option;
        Predef$.MODULE$.assert(input.trim().length() == input.length());
        if (input.length() < 3 || !RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), 0)))) {
            return None$.MODULE$;
        }
        String string = input;
        Object object = string != null && !(option = this.specialValueRe().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0 && this.isValid$1(v = (String)((LinearSeqOps)option.get()).apply(0), z = (String)((LinearSeqOps)option.get()).apply(1)) ? new Some((Object)v.toLowerCase(Locale.US)) : None$.MODULE$;
        return object;
    }

    public Option<Object> convertSpecialTimestamp(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input.trim()).flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            block7: {
                String string = x0$1;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1621979774: {
                        if (!"yesterday".equals(string)) break;
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).minusDays(1L).toInstant())));
                        break block7;
                    }
                    case -1037172987: {
                        if (!"tomorrow".equals(string)) break;
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).plusDays(1L).toInstant())));
                        break block7;
                    }
                    case 109270: {
                        if (!"now".equals(string)) break;
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.currentTimestamp()));
                        break block7;
                    }
                    case 96722057: {
                        if (!"epoch".equals(string)) break;
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                        break block7;
                    }
                    case 110534465: {
                        if (!"today".equals(string)) break;
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).toInstant())));
                        break block7;
                    }
                }
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public Option<Object> convertSpecialTimestampNTZ(String input, ZoneId zoneId) {
        Option localDateTime2 = this.extractSpecialValue(input.trim()).flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            block7: {
                String string = x0$1;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1621979774: {
                        if (!"yesterday".equals(string)) break;
                        none$ = new Some((Object)LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT).minusDays(1L));
                        break block7;
                    }
                    case -1037172987: {
                        if (!"tomorrow".equals(string)) break;
                        none$ = new Some((Object)LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT).plusDays(1L));
                        break block7;
                    }
                    case 109270: {
                        if (!"now".equals(string)) break;
                        none$ = new Some((Object)LocalDateTime.now(zoneId));
                        break block7;
                    }
                    case 96722057: {
                        if (!"epoch".equals(string)) break;
                        none$ = new Some((Object)LocalDateTime.of(1970, 1, 1, 0, 0));
                        break block7;
                    }
                    case 110534465: {
                        if (!"today".equals(string)) break;
                        none$ = new Some((Object)LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT));
                        break block7;
                    }
                }
                none$ = None$.MODULE$;
            }
            return none$;
        });
        return localDateTime2.map((Function1 & Serializable)localDateTime -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime)));
    }

    public Option<Object> convertSpecialDate(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input.trim()).flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            block10: {
                block9: {
                    String string = x0$1;
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1621979774: {
                            if (!"yesterday".equals(string)) break block9;
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)Math.subtractExact(MODULE$.currentDate(zoneId), 1)));
                            break block10;
                        }
                        case -1037172987: {
                            if (!"tomorrow".equals(string)) break block9;
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)Math.addExact(MODULE$.currentDate(zoneId), 1)));
                            break block10;
                        }
                        case 109270: {
                            if ("now".equals(string)) {
                                break;
                            }
                            break block9;
                        }
                        case 96722057: {
                            if (!"epoch".equals(string)) break block9;
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                            break block10;
                        }
                        case 110534465: {
                            if ("today".equals(string)) {
                                break;
                            }
                            break block9;
                        }
                        default: {
                            break block9;
                        }
                    }
                    none$ = new Some((Object)BoxesRunTime.boxToInteger((int)MODULE$.currentDate(zoneId)));
                    break block10;
                }
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public CalendarInterval subtractDates(int endDay, int startDay) {
        Period period = Period.between(this.daysToLocalDate(startDay), this.daysToLocalDate(endDay));
        int months = Math.toIntExact(period.toTotalMonths());
        int days = period.getDays();
        return new CalendarInterval(months, days, 0L);
    }

    public long subtractTimestamps(long endMicros, long startMicros, ZoneId zoneId) {
        LocalDateTime localEndTs = this.getLocalDateTime(endMicros, zoneId);
        LocalDateTime localStartTs = this.getLocalDateTime(startMicros, zoneId);
        return ChronoUnit.MICROS.between(localStartTs, localEndTs);
    }

    public long timestampAdd(String unit, int quantity, long micros, ZoneId zoneId) {
        long l;
        try {
            long l2;
            block21: {
                String string;
                block20: {
                    string = unit.toUpperCase(Locale.ROOT);
                    switch (string == null ? 0 : string.hashCode()) {
                        case -2020697580: {
                            if (!"MINUTE".equals(string)) break block20;
                            l2 = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 60000000L), zoneId);
                            break block21;
                        }
                        case -1852950412: {
                            if (!"SECOND".equals(string)) break block20;
                            l2 = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 1000000L), zoneId);
                            break block21;
                        }
                        case -1321778928: {
                            if ("DAYOFYEAR".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case -199595423: {
                            if (!"MILLISECOND".equals(string)) break block20;
                            l2 = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 1000L), zoneId);
                            break block21;
                        }
                        case 67452: {
                            if ("DAY".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 2223588: {
                            if (!"HOUR".equals(string)) break block20;
                            l2 = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 3600000000L), zoneId);
                            break block21;
                        }
                        case 2660340: {
                            if (!"WEEK".equals(string)) break block20;
                            l2 = this.timestampAddInterval(micros, 0, Math.multiplyExact(quantity, 7), 0L, zoneId);
                            break block21;
                        }
                        case 2719805: {
                            if (!"YEAR".equals(string)) break block20;
                            l2 = this.timestampAddMonths(micros, Math.multiplyExact(quantity, 12), zoneId);
                            break block21;
                        }
                        case 73542240: {
                            if (!"MONTH".equals(string)) break block20;
                            l2 = this.timestampAddMonths(micros, quantity, zoneId);
                            break block21;
                        }
                        case 1369386636: {
                            if (!"QUARTER".equals(string)) break block20;
                            l2 = this.timestampAddMonths(micros, Math.multiplyExact(quantity, 3), zoneId);
                            break block21;
                        }
                        case 1784607768: {
                            if (!"MICROSECOND".equals(string)) break block20;
                            l2 = this.timestampAddInterval(micros, 0, 0, quantity, zoneId);
                            break block21;
                        }
                        default: {
                            break block20;
                        }
                    }
                    l2 = this.timestampAddInterval(micros, 0, quantity, 0L, zoneId);
                    break block21;
                }
                throw new MatchError((Object)string);
            }
            l = l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof MatchError) {
                throw new IllegalStateException(new StringBuilder(27).append("Got the unexpected unit '").append(unit).append("'.").toString());
            }
            boolean bl = throwable2 instanceof ArithmeticException ? true : throwable2 instanceof DateTimeException;
            if (bl) {
                throw QueryExecutionErrors$.MODULE$.timestampAddOverflowError(micros, quantity, unit);
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw new IllegalStateException(new StringBuilder(27).append("Failure of 'timestampAdd': ").append(throwable3.getMessage()).toString());
            }
            throw throwable;
        }
        return l;
    }

    private Map<String, Function2<Temporal, Temporal, Object>> timestampDiffMap() {
        return timestampDiffMap;
    }

    public long timestampDiff(String unit, long startTs, long endTs, ZoneId zoneId) {
        String unitInUpperCase = unit.toUpperCase(Locale.ROOT);
        if (!this.timestampDiffMap().contains((Object)unitInUpperCase)) {
            throw new IllegalStateException(new StringBuilder(27).append("Got the unexpected unit '").append(unit).append("'.").toString());
        }
        LocalDateTime startLocalTs = this.getLocalDateTime(startTs, zoneId);
        LocalDateTime endLocalTs = this.getLocalDateTime(endTs, zoneId);
        return BoxesRunTime.unboxToLong((Object)((Function2)this.timestampDiffMap().apply((Object)unitInUpperCase)).apply((Object)startLocalTs, (Object)endLocalTs));
    }

    private static final boolean isValidDigits$1(int segment, int digits) {
        int maxDigitsYear = 6;
        return segment == 6 || segment == 0 && digits >= 4 && digits <= maxDigitsYear || segment == 7 && digits <= 2 || segment != 0 && segment != 6 && segment != 7 && digits > 0 && digits <= 2;
    }

    private static final boolean isValidDigits$2(int segment, int digits) {
        int maxDigitsYear = 7;
        return segment == 0 && digits >= 4 && digits <= maxDigitsYear || segment != 0 && digits > 0 && digits <= 2;
    }

    private final boolean isValid$1(String value, String timeZoneId) {
        boolean bl;
        if (timeZoneId.isEmpty()) {
            return true;
        }
        if (value.compareToIgnoreCase("now") == 0) {
            return false;
        }
        try {
            this.getZoneId(timeZoneId);
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public static final /* synthetic */ long $anonfun$timestampDiffMap$9(Temporal startTs, Temporal endTs) {
        return ChronoUnit.MONTHS.between(startTs, endTs) / 3L;
    }

    private DateTimeUtils$() {
    }
}

