/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.QuaternaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(col, eps, confidence, seed) - Returns a count-min sketch of a column with the given esp,\n      confidence and seed. The result is an array of bytes, which can be deserialized to a\n      `CountMinSketch` before usage. Count-min sketch is a probabilistic data structure used for\n      cardinality estimation using sub-linear space.\n  ", examples="\n    Examples:\n      > SELECT hex(_FUNC_(col, 0.5d, 0.5d, 1)) FROM VALUES (1), (2), (1) AS tab(col);\n       0000000100000000000000030000000100000004000000005D8D6AB90000000000000000000000000000000200000000000000010000000000000000\n  ", group="agg_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005h\u0001\u0002\u001e<\u0001*C\u0001B\u001e\u0001\u0003\u0016\u0004%\ta\u001e\u0005\tq\u0002\u0011\t\u0012)A\u0005C\"A\u0011\u0010\u0001BK\u0002\u0013\u0005q\u000f\u0003\u0005{\u0001\tE\t\u0015!\u0003b\u0011!Y\bA!f\u0001\n\u00039\b\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011B1\t\u0011u\u0004!Q3A\u0005\u0002]D\u0001B \u0001\u0003\u0012\u0003\u0006I!\u0019\u0005\n\u007f\u0002\u0011)\u001a!C!\u0003\u0003A!\"!\u0003\u0001\u0005#\u0005\u000b\u0011BA\u0002\u0011)\tY\u0001\u0001BK\u0002\u0013\u0005\u0013\u0011\u0001\u0005\u000b\u0003\u001b\u0001!\u0011#Q\u0001\n\u0005\r\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u001f\u0001A\u0011AA\u0011\u0011)\tY\u0003\u0001EC\u0002\u0013%\u0011Q\u0006\u0005\u000b\u0003k\u0001\u0001R1A\u0005\n\u00055\u0002BCA\u001c\u0001!\u0015\r\u0011\"\u0003\u0002\u0002!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t\t\u0007\u0001C!\u0003GBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAL\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003?\u0003A\u0011IAQ\u0011\u001d\t)\f\u0001C!\u0003oCq!a0\u0001\t\u0003\n\t\rC\u0004\u0002J\u0002!\t%a3\t\u000f\u0005e\u0007\u0001\"\u0011\u0002\\\"1\u0011Q\u001e\u0001\u0005B]Da!a<\u0001\t\u0003:\bBBAy\u0001\u0011\u0005s\u000f\u0003\u0004\u0002t\u0002!\te\u001e\u0005\b\u0003k\u0004A\u0011KA|\u0011%\u0011\t\u0001AA\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003\u0012\u0001\t\n\u0011\"\u0001\u0003\u0014!I!\u0011\u0006\u0001\u0012\u0002\u0013\u0005!1\u0003\u0005\n\u0005W\u0001\u0011\u0013!C\u0001\u0005'A\u0011B!\f\u0001#\u0003%\tAa\u0005\t\u0013\t=\u0002!%A\u0005\u0002\tE\u0002\"\u0003B\u001b\u0001E\u0005I\u0011\u0001B\u0019\u0011%\u00119\u0004AA\u0001\n\u0003\u0012I\u0004C\u0005\u0003J\u0001\t\t\u0011\"\u0001\u0002\u0002!I!1\n\u0001\u0002\u0002\u0013\u0005!Q\n\u0005\n\u0005'\u0002\u0011\u0011!C!\u0005+B\u0011Ba\u0019\u0001\u0003\u0003%\tA!\u001a\t\u0013\t%\u0004!!A\u0005B\t-\u0004\"\u0003B8\u0001\u0005\u0005I\u0011\tB9\u000f%\u0011)jOA\u0001\u0012\u0003\u00119J\u0002\u0005;w\u0005\u0005\t\u0012\u0001BM\u0011\u001d\ty\u0001\u000eC\u0001\u0005cC\u0011Ba-5\u0003\u0003%)E!.\t\u0013\t]F'!A\u0005\u0002\ne\u0006\"\u0003Bdi\u0005\u0005I\u0011\u0011Be\u0011%\u00119\u000eNA\u0001\n\u0013\u0011INA\tD_VtG/T5o'.,Go\u00195BO\u001eT!\u0001P\u001f\u0002\u0013\u0005<wM]3hCR,'B\u0001 @\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0001\u000b\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001b\u0015aA:rY*\u0011A)R\u0001\u0006gB\f'o\u001b\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001Yuk\u00173k!\raUjT\u0007\u0002w%\u0011aj\u000f\u0002\u0019)f\u0004X\rZ%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0019\u00198.\u001a;dQ*\u0011AkQ\u0001\u0005kRLG.\u0003\u0002W#\nq1i\\;oi6KgnU6fi\u000eD\u0007C\u0001-Z\u001b\u0005i\u0014B\u0001.>\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u00049~\u000bW\"A/\u000b\u0005y{\u0014!\u0002;sK\u0016\u001c\u0018B\u00011^\u00059\tV/\u0019;fe:\f'/\u001f'jW\u0016\u0004\"\u0001\u00172\n\u0005\rl$AC#yaJ,7o]5p]B\u0011Q\r[\u0007\u0002M*\tq-A\u0003tG\u0006d\u0017-\u0003\u0002jM\n9\u0001K]8ek\u000e$\bCA6t\u001d\ta\u0017O\u0004\u0002na6\taN\u0003\u0002p\u0013\u00061AH]8pizJ\u0011aZ\u0005\u0003e\u001a\fq\u0001]1dW\u0006<W-\u0003\u0002uk\na1+\u001a:jC2L'0\u00192mK*\u0011!OZ\u0001\u0006G\"LG\u000eZ\u000b\u0002C\u000611\r[5mI\u0002\nQ\"\u001a9t\u000bb\u0004(/Z:tS>t\u0017AD3qg\u0016C\bO]3tg&|g\u000eI\u0001\u0015G>tg-\u001b3f]\u000e,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002+\r|gNZ5eK:\u001cW-\u0012=qe\u0016\u001c8/[8oA\u0005q1/Z3e\u000bb\u0004(/Z:tS>t\u0017aD:fK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\"!a\u0001\u0011\u0007\u0015\f)!C\u0002\u0002\b\u0019\u00141!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}Qq\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001C\u0001'\u0001\u0011\u00151X\u00021\u0001b\u0011\u0015IX\u00021\u0001b\u0011\u0015YX\u00021\u0001b\u0011\u0015iX\u00021\u0001b\u0011\u0019yX\u00021\u0001\u0002\u0004!9\u00111B\u0007A\u0002\u0005\rACCA\n\u0003G\t)#a\n\u0002*!)aO\u0004a\u0001C\")\u0011P\u0004a\u0001C\")1P\u0004a\u0001C\")QP\u0004a\u0001C\u0006\u0019Q\r]:\u0016\u0005\u0005=\u0002cA3\u00022%\u0019\u00111\u00074\u0003\r\u0011{WO\u00197f\u0003)\u0019wN\u001c4jI\u0016t7-Z\u0001\u0005g\u0016,G-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002>A!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D}\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u000f\n\tEA\bUsB,7\t[3dWJ+7/\u001e7u\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001P\u0003\u0019)\b\u000fZ1uKR)q*!\u0015\u0002V!1\u00111\u000b\u000bA\u0002=\u000baAY;gM\u0016\u0014\bbBA,)\u0001\u0007\u0011\u0011L\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u00037\ni&D\u0001@\u0013\r\tyf\u0010\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003nKJ<W\rF\u0003P\u0003K\n9\u0007\u0003\u0004\u0002TU\u0001\ra\u0014\u0005\u0007\u0003/*\u0002\u0019A(\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003[\n\u0019\bE\u0002f\u0003_J1!!\u001dg\u0005\r\te.\u001f\u0005\u0007\u0003'2\u0002\u0019A(\u0002\u0013M,'/[1mSj,G\u0003BA=\u0003\u000b\u0003R!ZA>\u0003\u007fJ1!! g\u0005\u0015\t%O]1z!\r)\u0017\u0011Q\u0005\u0004\u0003\u00073'\u0001\u0002\"zi\u0016Da!a\u0015\u0018\u0001\u0004y\u0015a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2aTAF\u0011\u001d\ti\t\u0007a\u0001\u0003s\nQb\u001d;pe\u0006<WMR8s[\u0006$\u0018!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005M\u00111\u0013\u0005\b\u0003+K\u0002\u0019AA\u0002\u0003eqWm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\t\u0019\"a'\t\u000f\u0005u%\u00041\u0001\u0002\u0004\u00059b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAR!\u0015Y\u0017QUAU\u0013\r\t9+\u001e\u0002\u0004'\u0016\f\b\u0003BAV\u0003ck!!!,\u000b\u0007\u0005=\u0016)A\u0003usB,7/\u0003\u0003\u00024\u00065&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,WCAA]!\r)\u00171X\u0005\u0004\u0003{3'a\u0002\"p_2,\u0017M\\\u0001\tI\u0006$\u0018\rV=qKV\u0011\u00111\u0019\t\u0005\u0003W\u000b)-\u0003\u0003\u0002H\u00065&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u001b\u0011,g-Y;miJ+7/\u001e7u+\t\ti\rE\u0003f\u0003\u001f\f\u0019.C\u0002\u0002R\u001a\u0014aa\u00149uS>t\u0007c\u0001-\u0002V&\u0019\u0011q[\u001f\u0003\u000f1KG/\u001a:bY\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005u\u0007\u0003BAp\u0003OtA!!9\u0002dB\u0011QNZ\u0005\u0004\u0003K4\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0006-(AB*ue&twMC\u0002\u0002f\u001a\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017A\u00024pkJ$\b.A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYRQ\u00111CA}\u0003w\fi0a@\t\r\u00055H\u00051\u0001b\u0011\u0019\ty\u000f\na\u0001C\"1\u0011\u0011\u001f\u0013A\u0002\u0005Da!a=%\u0001\u0004\t\u0017\u0001B2paf$b\"a\u0005\u0003\u0006\t\u001d!\u0011\u0002B\u0006\u0005\u001b\u0011y\u0001C\u0004wKA\u0005\t\u0019A1\t\u000fe,\u0003\u0013!a\u0001C\"910\nI\u0001\u0002\u0004\t\u0007bB?&!\u0003\u0005\r!\u0019\u0005\t\u007f\u0016\u0002\n\u00111\u0001\u0002\u0004!I\u00111B\u0013\u0011\u0002\u0003\u0007\u00111A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)BK\u0002b\u0005/Y#A!\u0007\u0011\t\tm!QE\u0007\u0003\u0005;QAAa\b\u0003\"\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005G1\u0017AC1o]>$\u0018\r^5p]&!!q\u0005B\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tM\"\u0006BA\u0002\u0005/\tabY8qs\u0012\"WMZ1vYR$c'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005w\u0001BA!\u0010\u0003H5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%\u0001\u0003mC:<'B\u0001B#\u0003\u0011Q\u0017M^1\n\t\u0005%(qH\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tiGa\u0014\t\u0013\tEc&!AA\u0002\u0005\r\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003XA1!\u0011\fB0\u0003[j!Aa\u0017\u000b\u0007\tuc-\u0001\u0006d_2dWm\u0019;j_:LAA!\u0019\u0003\\\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tILa\u001a\t\u0013\tE\u0003'!AA\u0002\u00055\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa\u000f\u0003n!I!\u0011K\u0019\u0002\u0002\u0003\u0007\u00111A\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e&1\u000f\u0005\n\u0005#\u0012\u0014\u0011!a\u0001\u0003[B3\u0003\u0001B<\u0005{\u0012yHa!\u0003\u0006\n%%1\u0012BH\u0005#\u00032\u0001\u0017B=\u0013\r\u0011Y(\u0010\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011\t)\u0001BY\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002S\r]:-A\r|gNZ5eK:\u001cW\r\f\u0011tK\u0016$\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043m\\;oi6j\u0017N\u001c\u0011tW\u0016$8\r\u001b\u0011pM\u0002\n\u0007eY8mk6t\u0007e^5uQ\u0002\"\b.\u001a\u0011hSZ,g\u000eI3ta2R\u0001\u0005\t\u0011!A\u0001\u001awN\u001c4jI\u0016t7-\u001a\u0011b]\u0012\u00043/Z3e]\u0001\"\u0006.\u001a\u0011sKN,H\u000e\u001e\u0011jg\u0002\ng\u000eI1se\u0006L\be\u001c4!Ef$Xm\u001d\u0017!o\"L7\r\u001b\u0011dC:\u0004#-\u001a\u0011eKN,'/[1mSj,G\r\t;pA\u0005T\u0001\u0005\t\u0011!A\u0001\u00027i\\;oi6KgnU6fi\u000eD\u0007\r\t2fM>\u0014X\rI;tC\u001e,g\u0006I\"pk:$X&\\5oAM\\W\r^2iA%\u001c\b%\u0019\u0011qe>\u0014\u0017MY5mSN$\u0018n\u0019\u0011eCR\f\u0007e\u001d;sk\u000e$XO]3!kN,G\r\t4pe*\u0001\u0003\u0005\t\u0011!A\r\f'\u000fZ5oC2LG/\u001f\u0011fgRLW.\u0019;j_:\u0004So]5oO\u0002\u001aXOY\u0017mS:,\u0017M\u001d\u0011ta\u0006\u001cWM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\b\u0006\tyM\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011iKbDsLR+O\u0007~C3m\u001c7-AArS\u0007\u001a\u0017!a9*D\r\f\u00112S%\u0002cIU(NAY\u000bE*V#TA!\n\u0014\u0006\f\u0011)e%b\u0003\u0005K\u0019*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!aA\u0002\u0004\u0007\r\u00191cA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u001a\u0004\u0007\r\u00191aA\u0002\u0014\u0007\r\u00191aA\u0002\u0004\u0007\u000e\u00191aA\u0002\u0004\u0007\r\u00196\tb\"e'\u0011\":aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002$\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007M\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191a)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003\u000e\u0006I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005'\u000bQA\r\u00183]A\n\u0011cQ8v]Rl\u0015N\\*lKR\u001c\u0007.Q4h!\taEgE\u00035\u00057\u00139\u000b\u0005\b\u0003\u001e\n\r\u0016-Y1b\u0003\u0007\t\u0019!a\u0005\u000e\u0005\t}%b\u0001BQM\u00069!/\u001e8uS6,\u0017\u0002\u0002BS\u0005?\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87!\u0011\u0011IKa,\u000e\u0005\t-&\u0002\u0002BW\u0005\u0007\n!![8\n\u0007Q\u0014Y\u000b\u0006\u0002\u0003\u0018\u0006AAo\\*ue&tw\r\u0006\u0002\u0003<\u0005)\u0011\r\u001d9msRq\u00111\u0003B^\u0005{\u0013yL!1\u0003D\n\u0015\u0007\"\u0002<8\u0001\u0004\t\u0007\"B=8\u0001\u0004\t\u0007\"B>8\u0001\u0004\t\u0007\"B?8\u0001\u0004\t\u0007BB@8\u0001\u0004\t\u0019\u0001C\u0004\u0002\f]\u0002\r!a\u0001\u0002\u000fUt\u0017\r\u001d9msR!!1\u001aBj!\u0015)\u0017q\u001aBg!-)'qZ1bC\u0006\f\u0019!a\u0001\n\u0007\tEgM\u0001\u0004UkBdWM\u000e\u0005\n\u0005+D\u0014\u0011!a\u0001\u0003'\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\u000e\u0005\u0003\u0003>\tu\u0017\u0002\u0002Bp\u0005\u007f\u0011aa\u00142kK\u000e$\b")
public class CountMinSketchAgg
extends TypedImperativeAggregate<CountMinSketch>
implements ExpectsInputTypes,
QuaternaryLike<Expression>,
Serializable {
    private double eps;
    private double confidence;
    private int seed;
    private final Expression child;
    private final Expression epsExpression;
    private final Expression confidenceExpression;
    private final Expression seedExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Object, Object>> unapply(CountMinSketchAgg x$0) {
        return CountMinSketchAgg$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Object, Object>, CountMinSketchAgg> tupled() {
        return CountMinSketchAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, CountMinSketchAgg>>>>>> curried() {
        return CountMinSketchAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return QuaternaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return QuaternaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if (!this.bitmap$trans$0) {
                this.children = QuaternaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression epsExpression() {
        return this.epsExpression;
    }

    public Expression confidenceExpression() {
        return this.confidenceExpression;
    }

    public Expression seedExpression() {
        return this.seedExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private double eps$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eps = BoxesRunTime.unboxToDouble((Object)this.epsExpression().eval(this.epsExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.eps;
    }

    private double eps() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eps$lzycompute() : this.eps;
    }

    private double confidence$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.confidence = BoxesRunTime.unboxToDouble((Object)this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.confidence;
    }

    private double confidence() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.confidence$lzycompute() : this.confidence;
    }

    private int seed$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.seed = BoxesRunTime.unboxToInt((Object)this.seedExpression().eval(this.seedExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.seed;
    }

    private int seed() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.seed$lzycompute() : this.seed;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.epsExpression().foldable() || !this.confidenceExpression().foldable() || !this.seedExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided must be a literal or foldable") : (this.epsExpression().eval(this.epsExpression().eval$default$1()) == null || this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()) == null || this.seedExpression().eval(this.seedExpression().eval$default$1()) == null ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided should not be null") : (this.eps() <= 0.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Relative error must be positive (current value = ").append(this.eps()).append(")").toString()) : (this.confidence() <= 0.0 || this.confidence() >= 1.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(61).append("Confidence must be within range (0.0, 1.0) (current value = ").append(this.confidence()).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public CountMinSketch createAggregationBuffer() {
        return CountMinSketch.create((double)this.eps(), (double)this.confidence(), (int)this.seed());
    }

    @Override
    public CountMinSketch update(CountMinSketch buffer, InternalRow input) {
        block2: {
            Object value = this.child().eval(input);
            if (value == null) break block2;
            DataType dataType = this.child().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                buffer.addBinary(((UTF8String)value).getBytes());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                buffer.add(value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return buffer;
    }

    @Override
    public CountMinSketch merge(CountMinSketch buffer, CountMinSketch input) {
        buffer.mergeInPlace(input);
        return buffer;
    }

    @Override
    public Object eval(CountMinSketch buffer) {
        return this.serialize(buffer);
    }

    @Override
    public byte[] serialize(CountMinSketch buffer) {
        return buffer.toByteArray();
    }

    @Override
    public CountMinSketch deserialize(byte[] storageFormat) {
        return CountMinSketch.readFrom((byte[])storageFormat);
    }

    @Override
    public CountMinSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public CountMinSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$})), DoubleType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.create(this.eval(this.createAggregationBuffer()), this.dataType()));
    }

    @Override
    public String prettyName() {
        return "count_min_sketch";
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.epsExpression();
    }

    @Override
    public Expression third() {
        return this.confidenceExpression();
    }

    @Override
    public Expression fourth() {
        return this.seedExpression();
    }

    @Override
    public CountMinSketchAgg withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth, this.copy$default$5(), this.copy$default$6());
    }

    public CountMinSketchAgg copy(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CountMinSketchAgg(child, epsExpression, confidenceExpression, seedExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.epsExpression();
    }

    public Expression copy$default$3() {
        return this.confidenceExpression();
    }

    public Expression copy$default$4() {
        return this.seedExpression();
    }

    public int copy$default$5() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$6() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CountMinSketchAgg";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.epsExpression();
                break;
            }
            case 2: {
                object = this.confidenceExpression();
                break;
            }
            case 3: {
                object = this.seedExpression();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CountMinSketchAgg;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "epsExpression";
                break;
            }
            case 2: {
                string = "confidenceExpression";
                break;
            }
            case 3: {
                string = "seedExpression";
                break;
            }
            case 4: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 5: {
                string = "inputAggBufferOffset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CountMinSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        CountMinSketchAgg countMinSketchAgg = (CountMinSketchAgg)x$1;
        if (this.mutableAggBufferOffset() != countMinSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != countMinSketchAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = countMinSketchAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.epsExpression();
        Expression expression4 = countMinSketchAgg.epsExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.confidenceExpression();
        Expression expression6 = countMinSketchAgg.confidenceExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.seedExpression();
        Expression expression8 = countMinSketchAgg.seedExpression();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!countMinSketchAgg.canEqual(this)) return false;
        return true;
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.epsExpression = epsExpression;
        this.confidenceExpression = confidenceExpression;
        this.seedExpression = seedExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        QuaternaryLike.$init$(this);
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression) {
        this(child, epsExpression, confidenceExpression, seedExpression, 0, 0);
    }
}

