/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectList$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a list of non-unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2,1]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\tea\u0001B\u0014)\u0001^B\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t?\u0002\u0011\t\u0012)A\u00057\"A\u0001\r\u0001BK\u0002\u0013\u0005\u0011\r\u0003\u0005f\u0001\tE\t\u0015!\u0003c\u0011!1\u0007A!f\u0001\n\u0003\t\u0007\u0002C4\u0001\u0005#\u0005\u000b\u0011\u00022\t\u000b!\u0004A\u0011A5\t\u000b!\u0004A\u0011\u00018\t\u0011A\u0004\u0001R1A\u0005BEDQ\u0001\u001f\u0001\u0005BeDQ\u0001 \u0001\u0005BuDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0018\u0001\u0011E\u0013\u0011\u0007\u0005\n\u0003o\u0001\u0011\u0011!C\u0001\u0003sA\u0011\"!\u0011\u0001#\u0003%\t!a\u0011\t\u0013\u0005e\u0003!%A\u0005\u0002\u0005m\u0003\"CA0\u0001E\u0005I\u0011AA.\u0011%\t\t\u0007AA\u0001\n\u0003\n\u0019\u0007\u0003\u0005\u0002t\u0001\t\t\u0011\"\u0001b\u0011%\t)\bAA\u0001\n\u0003\t9\bC\u0005\u0002~\u0001\t\t\u0011\"\u0011\u0002\u0000!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/C\u0011\"a'\u0001\u0003\u0003%\t%!(\b\u0013\u0005\u001d\u0007&!A\t\u0002\u0005%g\u0001C\u0014)\u0003\u0003E\t!a3\t\r!lB\u0011AAr\u0011%\t)/HA\u0001\n\u000b\n9\u000fC\u0005\u0002jv\t\t\u0011\"!\u0002l\"I\u00111_\u000f\u0012\u0002\u0013\u0005\u00111\f\u0005\n\u0003kl\u0012\u0013!C\u0001\u00037B\u0011\"a>\u001e\u0003\u0003%\t)!?\t\u0013\t-Q$%A\u0005\u0002\u0005m\u0003\"\u0003B\u0007;E\u0005I\u0011AA.\u0011%\u0011y!HA\u0001\n\u0013\u0011\tBA\u0006D_2dWm\u0019;MSN$(BA\u0015+\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002,Y\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tic&\u0001\u0005dCR\fG._:u\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001HS'\u0011\u0007eRD(D\u0001)\u0013\tY\u0004FA\u0004D_2dWm\u0019;\u0011\u0007u\"e)D\u0001?\u0015\ty\u0004)A\u0004nkR\f'\r\\3\u000b\u0005\u0005\u0013\u0015AC2pY2,7\r^5p]*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F}\tY\u0011I\u001d:bs\n+hMZ3s!\t9\u0005*D\u0001C\u0013\tI%IA\u0002B]f\u0004\"aR&\n\u00051\u0013%a\u0002)s_\u0012,8\r\u001e\t\u0003\u001dZs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005I3\u0014A\u0002\u001fs_>$h(C\u0001D\u0013\t)&)A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&\u0001D*fe&\fG.\u001b>bE2,'BA+C\u0003\u0015\u0019\u0007.\u001b7e+\u0005Y\u0006C\u0001/^\u001b\u0005Q\u0013B\u00010+\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012A\u0019\t\u0003\u000f\u000eL!\u0001\u001a\"\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005U.dW\u000e\u0005\u0002:\u0001!)\u0011l\u0002a\u00017\"9\u0001m\u0002I\u0001\u0002\u0004\u0011\u0007b\u00024\b!\u0003\u0005\rA\u0019\u000b\u0003U>DQ!\u0017\u0005A\u0002m\u000b\u0011CY;gM\u0016\u0014X\t\\3nK:$H+\u001f9f+\u0005\u0011\bCA:w\u001b\u0005!(BA;/\u0003\u0015!\u0018\u0010]3t\u0013\t9HO\u0001\u0005ECR\fG+\u001f9f\u0003Y\u0019wN\u001c<feR$vNQ;gM\u0016\u0014X\t\\3nK:$HC\u0001${\u0011\u0015Y(\u00021\u0001G\u0003\u00151\u0018\r\\;f\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$Hc\u0001@\u0002\u0004A\u0011\u0011h`\u0005\u0004\u0003\u0003A#aE%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007BBA\u0003\u0017\u0001\u0007!-A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fF\u0002\u007f\u0003\u0017Aa!!\u0004\r\u0001\u0004\u0011\u0017a\u00068fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001=\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003/\u0001B!!\u0007\u0002\"9!\u00111DA\u000f!\t\u0001&)C\u0002\u0002 \t\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010\u0005\u0006!QM^1m)\r1\u00151\u0006\u0005\u0007\u0003[y\u0001\u0019\u0001\u001f\u0002\r\t,hMZ3s\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019!.a\r\t\r\u0005U\u0002\u00031\u0001\\\u0003!qWm^\"iS2$\u0017\u0001B2paf$rA[A\u001e\u0003{\ty\u0004C\u0004Z#A\u0005\t\u0019A.\t\u000f\u0001\f\u0002\u0013!a\u0001E\"9a-\u0005I\u0001\u0002\u0004\u0011\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bR3aWA$W\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA*\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003;R3AYA$\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nA\u0001\\1oO*\u0011\u0011qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002$\u0005%\u0014\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\r\u0006e\u0004\u0002CA>/\u0005\u0005\t\u0019\u00012\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\tE\u0003\u0002\u0004\u0006\u0015e)D\u0001A\u0013\r\t9\t\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u000e\u0006M\u0005cA$\u0002\u0010&\u0019\u0011\u0011\u0013\"\u0003\u000f\t{w\u000e\\3b]\"A\u00111P\r\u0002\u0002\u0003\u0007a)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA3\u00033C\u0001\"a\u001f\u001b\u0003\u0003\u0005\rAY\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u0015q\u0014\u0005\t\u0003wZ\u0012\u0011!a\u0001\r\":\u0002!a)\u0002*\u0006-\u0016qVAY\u0003k\u000b9,a/\u0002>\u0006\u0005\u00171\u0019\t\u00049\u0006\u0015\u0016bAATU\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAW\u0003\t{f)\u0016(D?\"*\u0007\u0010\u001d:*A5\u00023i\u001c7mK\u000e$8\u000fI1oI\u0002\u0012X\r^;s]N\u0004\u0013\r\t7jgR\u0004sN\u001a\u0011o_:lSO\\5rk\u0016\u0004S\r\\3nK:$8OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111W\u0001c\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\\\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152S1\u0002\u0003FM\u0015-A!\n\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-e1\nTL\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005e\u0016!a\u0013\u000bA\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004\u0013n\u001d\u0011o_:lC-\u001a;fe6Lg.[:uS\u000e\u0004#-Z2bkN,\u0007\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u00043m\u001c7mK\u000e$X\r\u001a\u0011sKN,H\u000e^:!I\u0016\u0004XM\u001c3t\u0015\u0001\u0002\u0003\u0005I8oAQDW\rI8sI\u0016\u0014\be\u001c4!i\",\u0007E]8xg\u0002:\b.[2iA5\f\u0017\u0010\t2fA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\rI1gi\u0016\u0014\b%\u0019\u0011tQV4g\r\\3/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAA`\u0003%\twmZ0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002F\u0006)!G\f\u0019/a\u0005Y1i\u001c7mK\u000e$H*[:u!\tITdE\u0003\u001e\u0003\u001b\fI\u000e\u0005\u0005\u0002P\u0006U7L\u00192k\u001b\t\t\tNC\u0002\u0002T\n\u000bqA];oi&lW-\u0003\u0003\u0002X\u0006E'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u00111\\Aq\u001b\t\tiN\u0003\u0003\u0002`\u00065\u0014AA5p\u0013\r9\u0016Q\u001c\u000b\u0003\u0003\u0013\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003K\nQ!\u00199qYf$rA[Aw\u0003_\f\t\u0010C\u0003ZA\u0001\u00071\fC\u0004aAA\u0005\t\u0019\u00012\t\u000f\u0019\u0004\u0003\u0013!a\u0001E\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$B!a?\u0003\bA)q)!@\u0003\u0002%\u0019\u0011q \"\u0003\r=\u0003H/[8o!\u00199%1A.cE&\u0019!Q\u0001\"\u0003\rQ+\b\u000f\\34\u0011!\u0011IaIA\u0001\u0002\u0004Q\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\n!\u0011\t9G!\u0006\n\t\t]\u0011\u0011\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class CollectList
extends Collect<ArrayBuffer<Object>>
implements Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return CollectList$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectList x$0) {
        return CollectList$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return CollectList$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectList$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectList> tupled() {
        return CollectList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectList>>> curried() {
        return CollectList$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectList collectList = this;
        synchronized (collectList) {
            if (!this.bitmap$0) {
                this.bufferElementType = this.child().dataType();
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        return !this.bitmap$0 ? this.bufferElementType$lzycompute() : this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public ArrayBuffer<Object> createAggregationBuffer() {
        return ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public String prettyName() {
        return "collect_list";
    }

    @Override
    public Object eval(ArrayBuffer<Object> buffer) {
        return new GenericArrayData((Object[])buffer.toArray(ClassTag$.MODULE$.Any()));
    }

    @Override
    public CollectList withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectList copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectList(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectList";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectList;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 2: {
                string = "inputAggBufferOffset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectList)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectList collectList = (CollectList)x$1;
        if (this.mutableAggBufferOffset() != collectList.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectList.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = collectList.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collectList.canEqual(this)) return false;
        return true;
    }

    public CollectList(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public CollectList(Expression child) {
        this(child, 0, 0);
    }
}

