/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate `percentile` of the numeric or\n      ansi interval column `col` which is the smallest value in the ordered `col` values (sorted\n      from least to greatest) such that no more than `percentage` of `col` values is less than\n      the value or equal to that value. The value of percentage must be between 0.0 and 1.0.\n      The `accuracy` parameter (default: 10000) is a positive numeric literal which controls\n      approximation accuracy at the cost of memory. Higher value of `accuracy` yields better\n      accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col, array(0.5, 0.4, 0.1), 100) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [1,1,0]\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (0), (6), (7), (9), (10) AS tab(col);\n       7\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '1' MONTH), (INTERVAL '2' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-1\n      > SELECT _FUNC_(col, array(0.5, 0.7), 100) FROM VALUES (INTERVAL '0' SECOND), (INTERVAL '1' SECOND), (INTERVAL '2' SECOND), (INTERVAL '10' SECOND) AS tab(col);\n       [0 00:00:01.000000000,0 00:00:02.000000000]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0005\rmd\u0001\u0002'N\u0001rC!\"a2\u0001\u0005+\u0007I\u0011\u0001B\u0011\u0011)\u0011\u0019\u0003\u0001B\tB\u0003%\u0011\u0011\u001a\u0005\u000b\u0003'\u0004!Q3A\u0005\u0002\t\u0005\u0002B\u0003B\u0013\u0001\tE\t\u0015!\u0003\u0002J\"Q\u0011q\u001b\u0001\u0003\u0016\u0004%\tA!\t\t\u0015\t\u001d\u0002A!E!\u0002\u0013\tI\r\u0003\u0006\u0002\\\u0002\u0011)\u001a!C!\u0003#A!B!\u000b\u0001\u0005#\u0005\u000b\u0011BA\n\u0011)\ty\u000e\u0001BK\u0002\u0013\u0005\u0013\u0011\u0003\u0005\u000b\u0005W\u0001!\u0011#Q\u0001\n\u0005M\u0001bBA\u0006\u0001\u0011\u0005!Q\u0006\u0005\b\u0003\u0017\u0001A\u0011\u0001B\u001d\u0011\u001d\tY\u0001\u0001C\u0001\u0005\u0003B!Ba\u0012\u0001\u0011\u000b\u0007I\u0011\u0002B%\u0011\u001d\u0011\t\u0006\u0001C!\u0005'BA\"a\u000f\u0001!\u0003E9\u0019)C\u0005\u0005GB!Ba\u001b\u0001\u0011\u000b\u0007I\u0011BA+\u0011)\t9\t\u0001EC\u0002\u0013%!Q\u000e\u0005\b\u0005_\u0002A\u0011\tB9\u0011\u001d\u0011y\b\u0001C!\u0005\u0003CqAa!\u0001\t\u0003\u0012)\tC\u0004\u0002h\u0001!\tEa&\t\u000f\tu\u0005\u0001\"\u0011\u0003 \"9!\u0011\u0016\u0001\u0005B\t-\u0006b\u0002BY\u0001\u0011\u0005#1\u0017\u0005\b\u0005o\u0003A\u0011\tB\u0011\u0011\u001d\u0011I\f\u0001C!\u0005CAqAa/\u0001\t\u0003\u0012\t\u0003C\u0004\u0003>\u0002!\t%!\u0016\t\u0015\t}\u0006\u0001#b\u0001\n\u0013\u0011\t\rC\u0004\u0003J\u0002!\tE!1\t\u000f\t-\u0007\u0001\"\u0011\u0003N\"9\u0011\u0011\u0015\u0001\u0005B\t}\u0007bBAY\u0001\u0011\u0005#1\u001d\u0005\b\u0005O\u0004A\u0011\u000bBu\u0011%\u00119\u0010AA\u0001\n\u0003\u0011I\u0010C\u0005\u0004\u0006\u0001\t\n\u0011\"\u0001\u0004\b!I1Q\u0004\u0001\u0012\u0002\u0013\u00051q\u0001\u0005\n\u0007?\u0001\u0011\u0013!C\u0001\u0007\u000fA\u0011b!\t\u0001#\u0003%\taa\t\t\u0013\r\u001d\u0002!%A\u0005\u0002\r\r\u0002\"CB\u0015\u0001\u0005\u0005I\u0011IB\u0016\u0011%\u0019\t\u0004AA\u0001\n\u0003\t\t\u0002C\u0005\u00044\u0001\t\t\u0011\"\u0001\u00046!I1\u0011\b\u0001\u0002\u0002\u0013\u000531\b\u0005\n\u0007\u0013\u0002\u0011\u0011!C\u0001\u0007\u0017B\u0011ba\u0014\u0001\u0003\u0003%\te!\u0015\t\u0013\rU\u0003!!A\u0005B\r]s!\u0002;N\u0011\u0003)h!\u0002'N\u0011\u00031\bbBA\u0006e\u0011\u0005\u0011Q\u0002\u0005\n\u0003\u001f\u0011$\u0019!C\u0001\u0003#A\u0001\"!\u00073A\u0003%\u00111\u0003\u0004\u0007\u00037\u0011\u0004!!\b\t\u0015\u0005}aG!a\u0001\n\u0013\t\t\u0003\u0003\u0006\u00020Y\u0012\t\u0019!C\u0005\u0003cA!\"!\u00107\u0005\u0003\u0005\u000b\u0015BA\u0012\u0011\u001d\tYA\u000eC\u0001\u0003\u007fAq!a\u00037\t\u0003\t9\u0005\u0003\u0005\u0002TY\"\taUA+\u0011\u001d\tiF\u000eC\u0001\u0003CAq!a\u00187\t\u0003\t\t\u0007C\u0004\u0002hY\"\t!!\u001b\t\u000f\u0005=d\u0007\"\u0001\u0002r!9\u0011q\u0012\u001c\u0005\u000e\u0005EeABAJe\u0001\t)\nC\u0004\u0002\f\t#\t!a&\t\u000f\u0005m%\t\"\u0004\u0002\u001e\"9\u0011\u0011\u0015\"\u0005\u0006\u0005\r\u0006bBAY\u0005\u0012\u0015\u00111\u0017\u0005\n\u0003s\u0013$\u0019!C\u0001\u0003wC\u0001\"!03A\u0003%\u0011\u0011\u0014\u0005\n\u0003\u007f\u0013\u0014\u0011!CA\u0003\u0003D\u0011\"!93\u0003\u0003%\t)a9\t\u0013\u0005U('!A\u0005\n\u0005](!F!qaJ|\u00070[7bi\u0016\u0004VM]2f]RLG.\u001a\u0006\u0003\u001d>\u000b\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005A\u000b\u0016aC3yaJ,7o]5p]NT!AU*\u0002\u0011\r\fG/\u00197zgRT!\u0001V+\u0002\u0007M\fHN\u0003\u0002W/\u0006)1\u000f]1sW*\u0011\u0001,W\u0001\u0007CB\f7\r[3\u000b\u0003i\u000b1a\u001c:h\u0007\u0001\u0019\"\u0002A/\u0003\u0006\t-!q\u0003B\u000f!\rqv,Y\u0007\u0002\u001b&\u0011\u0001-\u0014\u0002\u0019)f\u0004X\rZ%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007C\u000127\u001d\t\u0019\u0017G\u0004\u0002eg:\u0011QM\u001d\b\u0003MFt!a\u001a9\u000f\u0005!|gBA5o\u001d\tQW.D\u0001l\u0015\ta7,\u0001\u0004=e>|GOP\u0005\u00025&\u0011\u0001,W\u0005\u0003-^K!\u0001V+\n\u0005I\u001b\u0016B\u0001)R\u0013\tqu*A\u000bBaB\u0014x\u000e_5nCR,\u0007+\u001a:dK:$\u0018\u000e\\3\u0011\u0005y\u00134c\u0001\u001ax{B\u0011\u0001p_\u0007\u0002s*\t!0A\u0003tG\u0006d\u0017-\u0003\u0002}s\n1\u0011I\\=SK\u001a\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t!![8\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ/A\u000eE\u000b\u001a\u000bU\u000b\u0014+`!\u0016\u00136)\u0012(U\u00132+u,Q\"D+J\u000b5)W\u000b\u0003\u0003'\u00012\u0001_A\u000b\u0013\r\t9\"\u001f\u0002\u0004\u0013:$\u0018\u0001\b#F\r\u0006+F\nV0Q\u000bJ\u001bUI\u0014+J\u0019\u0016{\u0016iQ\"V%\u0006\u001b\u0015\f\t\u0002\u0011!\u0016\u00148-\u001a8uS2,G)[4fgR\u001c\"AN<\u0002\u0013M,X.\\1sS\u0016\u001cXCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015#\u0006!Q\u000f^5m\u0013\u0011\ti#a\n\u0003#E+\u0018M\u001c;jY\u0016\u001cV/\\7be&,7/A\u0007tk6l\u0017M]5fg~#S-\u001d\u000b\u0005\u0003g\tI\u0004E\u0002y\u0003kI1!a\u000ez\u0005\u0011)f.\u001b;\t\u0013\u0005m\u0002(!AA\u0002\u0005\r\u0012a\u0001=%c\u0005Q1/^7nCJLWm\u001d\u0011\u0015\t\u0005\u0005\u0013Q\t\t\u0004\u0003\u00072T\"\u0001\u001a\t\u000f\u0005}!\b1\u0001\u0002$Q!\u0011\u0011IA%\u0011\u001d\tYe\u000fa\u0001\u0003\u001b\nQB]3mCRLg/Z#se>\u0014\bc\u0001=\u0002P%\u0019\u0011\u0011K=\u0003\r\u0011{WO\u00197f\u00031I7oQ8naJ,7o]3e+\t\t9\u0006E\u0002y\u00033J1!a\u0017z\u0005\u001d\u0011un\u001c7fC:\f\u0011#];b]RLG.Z*v[6\f'/[3t\u0003\r\tG\r\u001a\u000b\u0005\u0003g\t\u0019\u0007C\u0004\u0002fy\u0002\r!!\u0014\u0002\u000bY\fG.^3\u0002\u000b5,'oZ3\u0015\t\u0005M\u00121\u000e\u0005\b\u0003[z\u0004\u0019AA!\u0003\u0015yG\u000f[3s\u000399W\r\u001e)fe\u000e,g\u000e^5mKN$B!a\u001d\u0002\u0006B1\u0011QOA@\u0003\u001brA!a\u001e\u0002|9\u0019!.!\u001f\n\u0003iL1!! z\u0003\u001d\u0001\u0018mY6bO\u0016LA!!!\u0002\u0004\n\u00191+Z9\u000b\u0007\u0005u\u0014\u0010C\u0004\u0002\b\u0002\u0003\r!!#\u0002\u0017A,'oY3oi\u0006<Wm\u001d\t\u0006q\u0006-\u0015QJ\u0005\u0004\u0003\u001bK(!B!se\u0006L\u0018\u0001C2p[B\u0014Xm]:\u0015\u0005\u0005M\"A\u0007)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\u0016\u0014\u0018.\u00197ju\u0016\u00148C\u0001\"x)\t\tI\nE\u0002\u0002D\t\u000ba\u0001\\3oORDG\u0003BA\n\u0003?Cq!a\bE\u0001\u0004\t\u0019#A\u0005tKJL\u0017\r\\5{KR!\u0011QUAW!\u0015A\u00181RAT!\rA\u0018\u0011V\u0005\u0004\u0003WK(\u0001\u0002\"zi\u0016Dq!a,F\u0001\u0004\t\t%A\u0002pE*\f1\u0002Z3tKJL\u0017\r\\5{KR!\u0011\u0011IA[\u0011\u001d\t9L\u0012a\u0001\u0003K\u000bQAY=uKN\f!b]3sS\u0006d\u0017N_3s+\t\tI*A\u0006tKJL\u0017\r\\5{KJ\u0004\u0013!B1qa2LH\u0003DAb\u0003\u000b\f\t.!6\u0002Z\u0006u\u0007C\u00010\u0001\u0011\u001d\t9-\u0013a\u0001\u0003\u0013\fQa\u00195jY\u0012\u0004B!a3\u0002N6\tq*C\u0002\u0002P>\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\t\u0019.\u0013a\u0001\u0003\u0013\fA\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0007bBAl\u0013\u0002\u0007\u0011\u0011Z\u0001\u0013C\u000e\u001cWO]1ds\u0016C\bO]3tg&|g\u000eC\u0004\u0002\\&\u0003\r!a\u0005\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRDq!a8J\u0001\u0004\t\u0019\"\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)/!=\u0011\u000ba\f9/a;\n\u0007\u0005%\u0018P\u0001\u0004PaRLwN\u001c\t\u000eq\u00065\u0018\u0011ZAe\u0003\u0013\f\u0019\"a\u0005\n\u0007\u0005=\u0018P\u0001\u0004UkBdW-\u000e\u0005\n\u0003gT\u0015\u0011!a\u0001\u0003\u0007\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tI\u0010\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\u0011\ty0a\u0001\u0002\t1\fgnZ\u0005\u0005\u0005\u0007\tiP\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u0017\u00149!C\u0002\u0003\n=\u0013a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0007\u0005\u001b\u0011\u0019\"!3\u000e\u0005\t=!b\u0001B\t#\u0006)AO]3fg&!!Q\u0003B\b\u0005-!VM\u001d8befd\u0015n[3\u0011\u0007a\u0014I\"C\u0002\u0003\u001ce\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002v\t}\u0011\u0002BA\u0005\u0003\u0007+\"!!3\u0002\r\rD\u0017\u000e\u001c3!\u0003U\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0002\n1#Y2dkJ\f7-_#yaJ,7o]5p]\u0002\nq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uAQa\u00111\u0019B\u0018\u0005c\u0011\u0019D!\u000e\u00038!9\u0011qY\u0006A\u0002\u0005%\u0007bBAj\u0017\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003/\\\u0001\u0019AAe\u0011\u001d\tYn\u0003a\u0001\u0003'Aq!a8\f\u0001\u0004\t\u0019\u0002\u0006\u0005\u0002D\nm\"Q\bB \u0011\u001d\t9\r\u0004a\u0001\u0003\u0013Dq!a5\r\u0001\u0004\tI\rC\u0004\u0002X2\u0001\r!!3\u0015\r\u0005\r'1\tB#\u0011\u001d\t9-\u0004a\u0001\u0003\u0013Dq!a5\u000e\u0001\u0004\tI-\u0001\u0005bG\u000e,(/Y2z+\t\u0011Y\u0005E\u0002y\u0005\u001bJ1Aa\u0014z\u0005\u0011auN\\4\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0003VA1\u0011QOA@\u0005/\u0002BA!\u0017\u0003`5\u0011!1\f\u0006\u0004\u0005;\u001a\u0016!\u0002;za\u0016\u001c\u0018\u0002\u0002B1\u00057\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0016\u0005\t\u0015\u0004c\u0002=\u0003h\u0005]\u0013\u0011R\u0005\u0004\u0005SJ(A\u0002+va2,''A\u000bsKR,(O\u001c)fe\u000e,g\u000e^5mK\u0006\u0013(/Y=\u0016\u0005\u0005%\u0015aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHC\u0001B:!\u0011\u0011)Ha\u001f\u000e\u0005\t]$b\u0001B=#\u0006A\u0011M\\1msNL7/\u0003\u0003\u0003~\t]$a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#A1\u0002\rU\u0004H-\u0019;f)\u0015\t'q\u0011BF\u0011\u0019\u0011I)\u0006a\u0001C\u00061!-\u001e4gKJDqA!$\u0016\u0001\u0004\u0011y)\u0001\u0005j]B,HOU8x!\u0011\u0011\tJa%\u000e\u0003EK1A!&R\u0005-Ie\u000e^3s]\u0006d'k\\<\u0015\u000b\u0005\u0014IJa'\t\r\t%e\u00031\u0001b\u0011\u0019\tiG\u0006a\u0001C\u0006!QM^1m)\u0011\u0011\tKa*\u0011\u0007a\u0014\u0019+C\u0002\u0003&f\u00141!\u00118z\u0011\u0019\u0011Ii\u0006a\u0001C\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002D\n5\u0006b\u0002BX1\u0001\u0007\u00111C\u0001\n]\u0016<xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BAb\u0005kCqAa,\u001a\u0001\u0004\t\u0019\"A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\t]VdG.\u00192mK\u0006\u0001\u0012N\u001c;fe:\fG\u000eR1uCRK\b/Z\u000b\u0003\u0005\u0007\u0004BA!\u0017\u0003F&!!q\u0019B.\u0005!!\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0003PB!!\u0011\u001bBm\u001d\u0011\u0011\u0019N!6\u0011\u0005)L\u0018b\u0001Bls\u00061\u0001K]3eK\u001aLAAa7\u0003^\n11\u000b\u001e:j]\u001eT1Aa6z)\u0011\t)K!9\t\r\u0005=\u0016\u00051\u0001b)\r\t'Q\u001d\u0005\b\u0003o\u0013\u0003\u0019AAS\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0005\u0002D\n-(q\u001eBz\u0011\u001d\u0011io\ta\u0001\u0003\u0013\f\u0001B\\3x\r&\u00148\u000f\u001e\u0005\b\u0005c\u001c\u0003\u0019AAe\u0003%qWm^*fG>tG\rC\u0004\u0003v\u000e\u0002\r!!3\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsRa\u00111\u0019B~\u0005{\u0014yp!\u0001\u0004\u0004!I\u0011q\u0019\u0013\u0011\u0002\u0003\u0007\u0011\u0011\u001a\u0005\n\u0003'$\u0003\u0013!a\u0001\u0003\u0013D\u0011\"a6%!\u0003\u0005\r!!3\t\u0013\u0005mG\u0005%AA\u0002\u0005M\u0001\"CApIA\u0005\t\u0019AA\n\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0003+\t\u0005%71B\u0016\u0003\u0007\u001b\u0001Baa\u0004\u0004\u001a5\u00111\u0011\u0003\u0006\u0005\u0007'\u0019)\"A\u0005v]\u000eDWmY6fI*\u00191qC=\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u001c\rE!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019)C\u000b\u0003\u0002\u0014\r-\u0011AD2paf$C-\u001a4bk2$H%N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r5\u0002\u0003BA~\u0007_IAAa7\u0002~\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BQ\u0007oA\u0011\"a\u000f-\u0003\u0003\u0005\r!a\u0005\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0010\u0011\r\r}2Q\tBQ\u001b\t\u0019\tEC\u0002\u0004De\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00199e!\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003/\u001ai\u0005C\u0005\u0002<9\n\t\u00111\u0001\u0003\"\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0019ica\u0015\t\u0013\u0005mr&!AA\u0002\u0005M\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002X\re\u0003\"CA\u001ea\u0005\u0005\t\u0019\u0001BQQM\u00011QLB2\u0007K\u001aIga\u001b\u0004p\rE4QOB<!\u0011\tYma\u0018\n\u0007\r\u0005tJA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\r\u001d\u0014A\"0\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006fY8mY\u0001\u0002XM]2f]R\fw-\u001a\u0011\\Y\u0001\n7mY;sC\u000eLX,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCR,\u0007\u0005\u00199fe\u000e,g\u000e^5mK\u0002\u0004sN\u001a\u0011uQ\u0016\u0004c.^7fe&\u001c\u0007e\u001c:\u000bA\u0001\u0002\u0003\u0005\t\u0011b]NL\u0007%\u001b8uKJ4\u0018\r\u001c\u0011d_2,XN\u001c\u0011aG>d\u0007\rI<iS\u000eD\u0007%[:!i\",\u0007e]7bY2,7\u000f\u001e\u0011wC2,X\rI5oAQDW\rI8sI\u0016\u0014X\r\u001a\u0011aG>d\u0007\r\t<bYV,7\u000f\t\u0015t_J$X\r\u001a\u0006!A\u0001\u0002\u0003\u0005\t4s_6\u0004C.Z1ti\u0002\"x\u000eI4sK\u0006$Xm\u001d;*AM,8\r\u001b\u0011uQ\u0006$\bE\\8![>\u0014X\r\t;iC:\u0004\u0003\r]3sG\u0016tG/Y4fA\u0002zg\r\t1d_2\u0004\u0007E^1mk\u0016\u001c\b%[:!Y\u0016\u001c8\u000f\t;iC:T\u0001\u0005\t\u0011!A\u0001\"\b.\u001a\u0011wC2,X\rI8sA\u0015\fX/\u00197!i>\u0004C\u000f[1uAY\fG.^3/AQCW\r\t<bYV,\u0007e\u001c4!a\u0016\u00148-\u001a8uC\u001e,\u0007%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0001\f7mY;sC\u000eL\b\r\t9be\u0006lW\r^3sA!\"WMZ1vYRT\u0004%\r\u00191aAJ\u0003%[:!C\u0002\u0002xn]5uSZ,\u0007E\\;nKJL7\r\t7ji\u0016\u0014\u0018\r\u001c\u0011xQ&\u001c\u0007\u000eI2p]R\u0014x\u000e\\:\u000bA\u0001\u0002\u0003\u0005\t\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0011bG\u000e,(/Y2zA\u0005$\b\u0005\u001e5fA\r|7\u000f\u001e\u0011pM\u0002jW-\\8ss:\u0002\u0003*[4iKJ\u0004c/\u00197vK\u0002zg\r\t1bG\u000e,(/Y2zA\u0002J\u0018.\u001a7eg\u0002\u0012W\r\u001e;fe*\u0001\u0003\u0005\t\u0011!A\u0005\u001c7-\u001e:bGfd\u0003\u0005Y\u0019/a=\n7mY;sC\u000eL\b\rI5tAQDW\r\t:fY\u0006$\u0018N^3!KJ\u0014xN\u001d\u0011pM\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007\u0005\u00199fe\u000e,g\u000e^1hK\u0002\u0004\u0013n\u001d\u0011b]\u0002\n'O]1zY\u0001*\u0017m\u00195!m\u0006dW/\u001a\u0011pM\u0002\"\b.\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9R\u0001\u0005\t\u0011!A\u0001Je\u000e\t;iSN\u00043-Y:fY\u0001\u0012X\r^;s]N\u0004C\u000f[3!CB\u0004(o\u001c=j[\u0006$X\r\t9fe\u000e,g\u000e^5mK\u0002\n'O]1zA=4\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]*\u0001\u0003\u0005\t\u0011!AA,'oY3oi\u0006<W\rI1se\u0006LhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAB7\u0003\u0011m&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152S1\u0002\u0003FM\u0015-A!\n\u0004'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YEb\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006\t\u0019/k1\u0002\u0013\u0007\r\u0019*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005\u000b\u001c*Y\u0001Bs'\u000b\u0017!QeJC\u0006\t\u00152a%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0003GL\u001b-AE\u0002\u0004'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K%O)\u0016\u0013f+\u0011'!OA:\u0003%T(O)\"KC\u0006\t\u0015J\u001dR+%KV!MA\u001d\nt\u0005I'P\u001dRC\u0015\u0006\f\u0011)\u0013:#VI\u0015,B\u0019\u0002:#g\n\u0011N\u001f:#\u0006*\u000b\u0017!Q%sE+\u0012*W\u00032\u0003s%\r\u0019(A5{e\n\u0016%*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a5\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9:\u0014\u0006\f\u00112aAJ\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001\u001aViQ(O\t&b\u0003\u0005K%O)\u0016\u0013f+\u0011'!OE:\u0003eU#D\u001f:#\u0015\u0006\f\u0011)\u0013:#VI\u0015,B\u0019\u0002:#g\n\u0011T\u000b\u000e{e\nR\u0015-A!Je\nV#S-\u0006c\u0005eJ\u00191O\u0001\u001aViQ(O\t&\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0006\u0007\t\u00191uA\u0002$\bM\u0019/aA\u0002\u0004\u0007\r\u00191aAb\u0003\u0007\t\u00191uA\u0002$\b\r\u001a/aA\u0002\u0004\u0007\r\u00191aAj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\rM\u0014!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0019I(A\u00033]Er\u0003\u0007")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
Serializable {
    private long accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private DataType internalDataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient scala.collection.immutable.Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile x$0) {
        return ApproximatePercentile$.MODULE$.unapply(x$0);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private scala.collection.immutable.Seq<Expression> children$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final scala.collection.immutable.Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private long accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = ((Number)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1())).longValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracy;
    }

    private long accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((scala.collection.immutable.Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), TypeCollection$.MODULE$.apply((scala.collection.immutable.Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, new ArrayType(DoubleType$.MODULE$, false)})), IntegralType$.MODULE$}));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), null);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                } else {
                    throw new MatchError(object);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                boolean returnPercentileArray = tuple22._1$mcZ$sp();
                double[] percentages = (double[])tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)returnPercentileArray), (Object)percentages);
                this.x$1 = tuple23;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() || !this.accuracyExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal") : (this.accuracy() <= 0L || this.accuracy() > Integer.MAX_VALUE ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(73).append("The accuracy provided must be a literal between (0, ").append(Integer.MAX_VALUE).append("]").toString()).append(new StringBuilder(19).append(" (current value = ").append(this.accuracy()).append(")").toString()).toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1)(JFunction1.mcZD.sp & Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append("All percentage values must be between 0.0 and 1.0 ").append(new StringBuilder(12).append("(current = ").append(Predef$.MODULE$.wrapDoubleArray(this.percentages()).mkString(", ")).append(")").toString()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            boolean bl = DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType;
            if (bl) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else {
                boolean bl2 = TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType);
                if (bl2) {
                    d = BoxesRunTime.unboxToLong((Object)value);
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    d = numericType.numeric().toDouble(value);
                } else {
                    if (dataType != null) {
                        DataType dataType2 = dataType;
                        throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
                    }
                    throw new MatchError((Object)dataType);
                }
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        scala.collection.immutable.Seq seq;
        scala.collection.immutable.Seq doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        boolean bl = DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType;
        if (bl) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable)x$2 -> (int)x$2);
        } else {
            boolean bl2 = TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType);
            if (bl2) {
                seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable)x$3 -> (long)x$3);
            } else if (ByteType$.MODULE$.equals(dataType)) {
                seq = (scala.collection.immutable.Seq)doubleResult.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$4))));
            } else if (ShortType$.MODULE$.equals(dataType)) {
                seq = (scala.collection.immutable.Seq)doubleResult.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$5))));
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable)x$6 -> (int)x$6);
            } else if (LongType$.MODULE$.equals(dataType)) {
                seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable)x$7 -> (long)x$7);
            } else if (FloatType$.MODULE$.equals(dataType)) {
                seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcFD.sp & Serializable)x$8 -> (float)x$8);
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                seq = doubleResult;
            } else if (dataType instanceof DecimalType) {
                seq = (scala.collection.immutable.Seq)doubleResult.map((Function1 & Serializable)x$9 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$9)));
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
                }
                throw new MatchError((Object)dataType);
            }
        }
        scala.collection.immutable.Seq result = seq;
        return result.length() == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData((Seq<Object>)result) : result.apply(0));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.accuracyExpression();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType internalDataType$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.internalDataType = this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.internalDataType$lzycompute() : this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "percentile_approx");
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    @Override
    public ApproximatePercentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5());
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "percentageExpression";
                break;
            }
            case 2: {
                string = "accuracyExpression";
                break;
            }
            case 3: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 4: {
                string = "inputAggBufferOffset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$5) {
        return (short)x$5;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        public scala.collection.immutable.Seq<Object> getPercentiles(double[] percentages) {
            if (!this.isCompressed()) {
                this.compress();
            }
            return this.summaries().count() == 0L || percentages.length == 0 ? Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)Array$.MODULE$.emptyDoubleArray()) : (scala.collection.immutable.Seq)this.summaries().query((scala.collection.immutable.Seq<Object>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)percentages)).get();
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, true));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

