/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.expressions.StringBinaryPredicateExpressionBuilderBase;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Returns a boolean. The value is True if left starts with right.\n    Returns NULL if either input expression is NULL. Otherwise, returns False.\n    Both left or right must be of STRING or BINARY type.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 'Spark');\n       true\n      > SELECT _FUNC_('Spark SQL', 'SQL');\n       false\n      > SELECT _FUNC_('Spark SQL', null);\n       NULL\n      > SELECT _FUNC_(x'537061726b2053514c', x'537061726b');\n       true\n      > SELECT _FUNC_(x'537061726b2053514c', x'53514c');\n       false\n  ", since="3.3.0", group="string_funcs")
public final class StartsWithExpressionBuilder$
implements StringBinaryPredicateExpressionBuilderBase {
    public static final StartsWithExpressionBuilder$ MODULE$ = new StartsWithExpressionBuilder$();

    static {
        StringBinaryPredicateExpressionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        return StringBinaryPredicateExpressionBuilderBase.build$(this, funcName, expressions);
    }

    @Override
    public Expression createStringPredicate(Expression left, Expression right) {
        return new StartsWith(left, right);
    }

    private StartsWithExpressionBuilder$() {
    }
}

