/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeDTInterval$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import scala.Function1;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([days[, hours[, mins[, secs]]]]) - Make DayTimeIntervalType duration from days, hours, mins and secs.", arguments="\n    Arguments:\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 12, 30, 01.001001);\n       1 12:30:01.001001000\n      > SELECT _FUNC_(2);\n       2 00:00:00.000000000\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n  ", since="3.2.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0005\tUc\u0001B\u0016-\u0001fB\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0012)A\u00057\"Aq\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005a\u0001\tE\t\u0015!\u0003\\\u0011!\t\u0007A!f\u0001\n\u0003Q\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B.\t\u0011\r\u0004!Q3A\u0005\u0002iC\u0001\u0002\u001a\u0001\u0003\u0012\u0003\u0006Ia\u0017\u0005\u0006K\u0002!\tA\u001a\u0005\u0006K\u0002!\t\u0001\u001c\u0005\u0006K\u0002!\t\u0001\u001d\u0005\u0006K\u0002!\ta\u001d\u0005\u0006K\u0002!\t!\u001e\u0005\u0006m\u0002!\tE\u0017\u0005\u0006o\u0002!\tE\u0017\u0005\u0006q\u0002!\tE\u0017\u0005\u0006s\u0002!\tE\u0017\u0005\u0006u\u0002!\te\u001f\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005\u0005\u0004\u0001\"\u0015\u0002d!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"!%\u0001#\u0003%\t!a\u001f\t\u0013\u0005M\u0005!%A\u0005\u0002\u0005m\u0004\"CAK\u0001E\u0005I\u0011AA>\u0011%\t9\nAA\u0001\n\u0003\nI\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003w\u0003\u0011\u0011!C!\u0003{C\u0011\"a3\u0001\u0003\u0003%\t!!4\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\"CAo\u0001\u0005\u0005I\u0011IAp\u000f%\u0011I\u0001LA\u0001\u0012\u0003\u0011YA\u0002\u0005,Y\u0005\u0005\t\u0012\u0001B\u0007\u0011\u0019)W\u0005\"\u0001\u0003&!I!qE\u0013\u0002\u0002\u0013\u0015#\u0011\u0006\u0005\n\u0005W)\u0013\u0011!CA\u0005[A\u0011Ba\u000e&\u0003\u0003%\tI!\u000f\t\u0013\t-S%!A\u0005\n\t5#AD'bW\u0016$E+\u00138uKJ4\u0018\r\u001c\u0006\u0003[9\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0006M\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011GM\u0001\u0004gFd'BA\u001a5\u0003\u0015\u0019\b/\u0019:l\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\u0004\u0001M1\u0001A\u000f B\u0011:\u0003\"a\u000f\u001f\u000e\u00031J!!\u0010\u0017\u0003)E+\u0018\r^3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYt(\u0003\u0002AY\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002C\u000b:\u00111hQ\u0005\u0003\t2\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001#-!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u0014,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*9\u0003\u0019a$o\\8u}%\t1*\u0003\u0002E\u0015&\u0011q\u000b\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\t*\u000bA\u0001Z1zgV\t1\f\u0005\u0002<9&\u0011Q\f\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00023bsN\u0004\u0013!\u00025pkJ\u001c\u0018A\u00025pkJ\u001c\b%\u0001\u0003nS:\u001c\u0018!B7j]N\u0004\u0013\u0001B:fGN\fQa]3dg\u0002\na\u0001P5oSRtD#B4iS*\\\u0007CA\u001e\u0001\u0011\u0015I\u0016\u00021\u0001\\\u0011\u0015y\u0016\u00021\u0001\\\u0011\u0015\t\u0017\u00021\u0001\\\u0011\u0015\u0019\u0017\u00021\u0001\\)\u00119WN\\8\t\u000beS\u0001\u0019A.\t\u000b}S\u0001\u0019A.\t\u000b\u0005T\u0001\u0019A.\u0015\u0007\u001d\f(\u000fC\u0003Z\u0017\u0001\u00071\fC\u0003`\u0017\u0001\u00071\f\u0006\u0002hi\")\u0011\f\u0004a\u00017R\tq-A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u0007M>,(\u000f\u001e5\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001}!\ryUp`\u0005\u0003}b\u00131aU3r!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003a\u0005)A/\u001f9fg&!\u0011\u0011BA\u0002\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\ty\u0001\u0005\u0003\u0002\u0002\u0005E\u0011\u0002BA\n\u0003\u0007\u0011\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u000b\u00033\ty\"a\t\u0002(\u0005-\u0002cA%\u0002\u001c%\u0019\u0011Q\u0004&\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\"Q\u0001\r!!\u0007\u0002\u0007\u0011\f\u0017\u0010C\u0004\u0002&Q\u0001\r!!\u0007\u0002\t!|WO\u001d\u0005\b\u0003S!\u0002\u0019AA\r\u0003\ri\u0017N\u001c\u0005\b\u0003[!\u0002\u0019AA\r\u0003\r\u0019XmY\u0001\nI><UM\\\"pI\u0016$b!a\r\u0002@\u0005%\u0003\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eB&A\u0004d_\u0012,w-\u001a8\n\t\u0005u\u0012q\u0007\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011I\u000bA\u0002\u0005\r\u0013aA2uqB!\u0011QGA#\u0013\u0011\t9%a\u000e\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111J\u000bA\u0002\u0005M\u0012AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003#\u0002B!a\u0015\u0002\\9!\u0011QKA,!\t\t&*C\u0002\u0002Z)\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA/\u0003?\u0012aa\u0015;sS:<'bAA-\u0015\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\nO\u0006\u0015\u0014qMA5\u0003WBQ!W\fA\u0002mCQaX\fA\u0002mCQ!Y\fA\u0002mCQaY\fA\u0002m\u000bAaY8qsRIq-!\u001d\u0002t\u0005U\u0014q\u000f\u0005\b3b\u0001\n\u00111\u0001\\\u0011\u001dy\u0006\u0004%AA\u0002mCq!\u0019\r\u0011\u0002\u0003\u00071\fC\u0004d1A\u0005\t\u0019A.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0010\u0016\u00047\u0006}4FAAA!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-%*\u0001\u0006b]:|G/\u0019;j_:LA!a$\u0002\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0005Y\u0006twM\u0003\u0002\u0002&\u0006!!.\u0019<b\u0013\u0011\ti&a(\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0006cA%\u00020&\u0019\u0011\u0011\u0017&\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0011q\u0017\u0005\n\u0003s{\u0012\u0011!a\u0001\u0003[\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA`!\u0019\t\t-a2\u0002\u001a5\u0011\u00111\u0019\u0006\u0004\u0003\u000bT\u0015AC2pY2,7\r^5p]&!\u0011\u0011ZAb\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0017Q\u001b\t\u0004\u0013\u0006E\u0017bAAj\u0015\n9!i\\8mK\u0006t\u0007\"CA]C\u0005\u0005\t\u0019AA\r\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u00151\u001c\u0005\n\u0003s\u0013\u0013\u0011!a\u0001\u0003[\u000ba!Z9vC2\u001cH\u0003BAh\u0003CD\u0011\"!/$\u0003\u0003\u0005\r!!\u0007)/\u0001\t)/a;\u0002n\u0006E\u00181_A|\u0003s\fi0a@\u0003\u0004\t\u0015\u0001cA\u001e\u0002h&\u0019\u0011\u0011\u001e\u0017\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011q^\u0001m?\u001a+fjQ0)7\u0012\f\u0017p].-A!|WO]:\\Y\u0001j\u0017N\\:\\Y\u0001\u001aXmY:^;vk\u0016\u0006I\u0017!\u001b\u0006\\W\r\t#bsRKW.Z%oi\u0016\u0014h/\u00197UsB,\u0007\u0005Z;sCRLwN\u001c\u0011ge>l\u0007\u0005Z1zg2\u0002\u0003n\\;sg2\u0002S.\u001b8tA\u0005tG\rI:fGNt\u0013!C1sOVlWM\u001c;tC\t\t)0\u0001B\u0018\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C-Y=tA5\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u0004C-Y=tY\u0001\u0002xn]5uSZ,\u0007e\u001c:!]\u0016<\u0017\r^5wK*\u0001\u0003\u0005\t\u0011!A)\u0002\u0003n\\;sg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007\u0005[8veNd\u0003\u0005]8tSRLg/\u001a\u0011pe\u0002rWmZ1uSZ,'\u0002\t\u0011!A\u0001\u0002#\u0006I7j]N\u0004S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\rI7j]V$Xm\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM,7m\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gAM,7m\u001c8eg\u0002:\u0018\u000e\u001e5!i\",\u0007E\u001a:bGRLwN\\1mAA\f'\u000f\u001e\u0011j]\u0002j\u0017n\u0019:pg\u0016\u001cwN\u001c3!aJ,7-[:j_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a?\u0002\u0003\u0007S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0017!cIb\u0003e\r\u0019-AA\nd\u0006\r\u00192aA\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112AE\u0012$h\r\u0019;aEr\u0003\u0007M\u00191aE\u0002\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)e%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00111ai\u0002\u0004G\u000f\u00191]A\u0002\u0004\u0007\r\u00191aA\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00191a1\u0002c.\u001e7mY\u0001\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t\u0005\u0011!B\u001a/e9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\u0004\u00039!\u0017\r^3uS6,wLZ;oGN\fa\"T1lK\u0012#\u0016J\u001c;feZ\fG\u000e\u0005\u0002<KM)QEa\u0004\u0003\u001cAI!\u0011\u0003B\f7n[6lZ\u0007\u0003\u0005'Q1A!\u0006K\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0007\u0003\u0014\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\tu!1E\u0007\u0003\u0005?QAA!\t\u0002$\u0006\u0011\u0011n\\\u0005\u0004/\n}AC\u0001B\u0006\u0003!!xn\u0015;sS:<GCAAN\u0003\u0015\t\u0007\u000f\u001d7z)%9'q\u0006B\u0019\u0005g\u0011)\u0004C\u0003ZQ\u0001\u00071\fC\u0003`Q\u0001\u00071\fC\u0003bQ\u0001\u00071\fC\u0003dQ\u0001\u00071,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tm\"q\t\t\u0006\u0013\nu\"\u0011I\u0005\u0004\u0005\u007fQ%AB(qi&|g\u000eE\u0004J\u0005\u0007Z6lW.\n\u0007\t\u0015#J\u0001\u0004UkBdW\r\u000e\u0005\t\u0005\u0013J\u0013\u0011!a\u0001O\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0003\u0003BAO\u0005#JAAa\u0015\u0002 \n1qJ\u00196fGR\u0004")
public class MakeDTInterval
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(MakeDTInterval x$0) {
        return MakeDTInterval$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Expression>, MakeDTInterval> tupled() {
        return MakeDTInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, MakeDTInterval>>>> curried() {
        return MakeDTInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    @Override
    public Expression first() {
        return this.days();
    }

    @Override
    public Expression second() {
        return this.hours();
    }

    @Override
    public Expression third() {
        return this.mins();
    }

    @Override
    public Expression fourth() {
        return this.secs();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)}));
    }

    @Override
    public DataType dataType() {
        return DayTimeIntervalType$.MODULE$.apply();
    }

    @Override
    public Object nullSafeEval(Object day, Object hour, Object min, Object sec) {
        return BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.makeDayTimeInterval(BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(day, hour, min, sec) -> {
            String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName()), "$");
            return new StringBuilder(28).append(iu).append(".makeDayTimeInterval(").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", ").append((String)sec).append(")").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_dt_interval";
    }

    @Override
    public MakeDTInterval withNewChildrenInternal(Expression days, Expression hours, Expression mins, Expression secs) {
        return this.copy(days, hours, mins, secs);
    }

    public MakeDTInterval copy(Expression days, Expression hours, Expression mins, Expression secs) {
        return new MakeDTInterval(days, hours, mins, secs);
    }

    public Expression copy$default$1() {
        return this.days();
    }

    public Expression copy$default$2() {
        return this.hours();
    }

    public Expression copy$default$3() {
        return this.mins();
    }

    public Expression copy$default$4() {
        return this.secs();
    }

    @Override
    public String productPrefix() {
        return "MakeDTInterval";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.days();
                break;
            }
            case 1: {
                object = this.hours();
                break;
            }
            case 2: {
                object = this.mins();
                break;
            }
            case 3: {
                object = this.secs();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDTInterval;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "days";
                break;
            }
            case 1: {
                string = "hours";
                break;
            }
            case 2: {
                string = "mins";
                break;
            }
            case 3: {
                string = "secs";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDTInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDTInterval makeDTInterval = (MakeDTInterval)x$1;
        Expression expression = this.days();
        Expression expression2 = makeDTInterval.days();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.hours();
        Expression expression4 = makeDTInterval.hours();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mins();
        Expression expression6 = makeDTInterval.mins();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.secs();
        Expression expression8 = makeDTInterval.secs();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!makeDTInterval.canEqual(this)) return false;
        return true;
    }

    public MakeDTInterval(Expression days, Expression hours, Expression mins, Expression secs) {
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        ExpectsInputTypes.$init$(this);
    }

    public MakeDTInterval(Expression days, Expression hours, Expression mins) {
        this(days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
    }

    public MakeDTInterval(Expression days, Expression hours) {
        this(days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeDTInterval(Expression days) {
        this(days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeDTInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

