/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u000f\u001f\u0001.B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0019\u0007\u0001\"\u0015e\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0006\u0001\t#\n9\u0002C\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$!I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003\u0003\u0002\u0011\u0013!C\u0001\u0003WA\u0011\"a\u0011\u0001\u0003\u0003%\t%!\u0012\t\u0013\u0005U\u0003!!A\u0005\u0002\u0005]\u0003\"CA0\u0001\u0005\u0005I\u0011AA1\u0011%\t9\u0007AA\u0001\n\u0003\nI\u0007C\u0005\u0002x\u0001\t\t\u0011\"\u0001\u0002z!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017;\u0011\"a,\u001f\u0003\u0003E\t!!-\u0007\u0011uq\u0012\u0011!E\u0001\u0003gCaaU\f\u0005\u0002\u0005-\u0007\"CAg/\u0005\u0005IQIAh\u0011%\t\tnFA\u0001\n\u0003\u000b\u0019\u000eC\u0005\u0002Z^\t\t\u0011\"!\u0002\\\"I\u0011Q^\f\u0002\u0002\u0013%\u0011q\u001e\u0002\n\r&tG-\u00138TKRT!a\b\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003C\t\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0007\u00011\u00024G\u000f!\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0013'\u0003\u00023=\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00025o9\u0011Q&N\u0005\u0003my\tq\u0001]1dW\u0006<W-\u0003\u00029s\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001\u001c\u001f!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0011%\u000f\u0005\t;eBA\"G\u001b\u0005!%BA#+\u0003\u0019a$o\\8u}%\tQ(\u0003\u00027y%\u0011\u0011J\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003mq\nA\u0001\\3giV\tQ\n\u0005\u0002.\u001d&\u0011qJ\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004+Z;\u0006CA\u0017\u0001\u0011\u0015YU\u00011\u0001N\u0011\u0015\tV\u00011\u0001N\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00025B\u0019\u0011iW/\n\u0005qS%aA*fcB\u0011a,Y\u0007\u0002?*\u0011\u0001MI\u0001\u0006if\u0004Xm]\u0005\u0003E~\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007\u0015D'\u000e\u0005\u0002<M&\u0011q\r\u0010\u0002\u0004\u0003:L\b\"B5\b\u0001\u0004)\u0017\u0001B<pe\u0012DQa[\u0004A\u0002\u0015\f1a]3u\u0003%!wnR3o\u0007>$W\rF\u0002oif\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0010\u0002\u000f\r|G-Z4f]&\u00111\u000f\u001d\u0002\t\u000bb\u0004(oQ8eK\")Q\u000f\u0003a\u0001m\u0006\u00191\r\u001e=\u0011\u0005=<\u0018B\u0001=q\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQA\u001f\u0005A\u00029\f!!\u001a<\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012! \t\u0003=zL!a`0\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\t)\u0001\u0005\u0003\u0002\b\u0005=a\u0002BA\u0005\u0003\u0017\u0001\"a\u0011\u001f\n\u0007\u00055A(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\t\u0019B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001ba\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015)\u0016\u0011DA\u000f\u0011\u0019\tYb\u0003a\u0001\u001b\u00069a.Z<MK\u001a$\bBBA\u0010\u0017\u0001\u0007Q*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000bU\u000b)#a\n\t\u000f-c\u0001\u0013!a\u0001\u001b\"9\u0011\u000b\u0004I\u0001\u0002\u0004i\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003[Q3!TA\u0018W\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001ey\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\u0011\t\t\"a\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0003cA\u001e\u0002\\%\u0019\u0011Q\f\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\u0015\f\u0019\u0007C\u0005\u0002fE\t\t\u00111\u0001\u0002Z\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001b\u0011\u000b\u00055\u00141O3\u000e\u0005\u0005=$bAA9y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0014q\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002|\u0005\u0005\u0005cA\u001e\u0002~%\u0019\u0011q\u0010\u001f\u0003\u000f\t{w\u000e\\3b]\"A\u0011QM\n\u0002\u0002\u0003\u0007Q-\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA$\u0003\u000fC\u0011\"!\u001a\u0015\u0003\u0003\u0005\r!!\u0017\u0002\r\u0015\fX/\u00197t)\u0011\tY(!$\t\u0011\u0005\u0015T#!AA\u0002\u0015D3\u0003AAI\u0003/\u000bI*!(\u0002 \u0006\r\u0016QUAU\u0003W\u00032!LAJ\u0013\r\t)J\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tY*AAb\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue2\u00023\u000f\u001e:`CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!S:$W\r\u001f\u0011)c5\u0012\u0017m]3eS\u0001zg\r\t;iK\u0002:\u0017N^3oAM$(/\u001b8hA!\u00027\u000f\u001e:aS\u0001Jg\u000e\t;iK\u0002\u001aw.\\7b[\u0011,G.[7ji\u0016$\u0007\u0005\\5ti\u0002B\u0003m\u001d;s?\u0006\u0014(/Y=aS9R\u0001\u0005\t\u0011!A\u0001\u0012V\r^;s]N\u0004\u0003\u0007\f\u0011jM\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0011xCN\u0004cn\u001c;!M>,h\u000e\u001a\u0011pe\u0002Jg\r\t;iK\u0002:\u0017N^3oAM$(/\u001b8hA!\u00027\u000f\u001e:aS\u0001\u001awN\u001c;bS:\u001c\b%\u0019\u0011d_6l\u0017M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\"\u0006A%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014bE\u001ebs%\u00192dY\td\u0013M\u0019\u0017dY\u0011,gmJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003O\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!,\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0013\u0019Kg\u000eZ%o'\u0016$\bCA\u0017\u0018'\u00159\u0012QWAa!\u001d\t9,!0N\u001bVk!!!/\u000b\u0007\u0005mF(A\u0004sk:$\u0018.\\3\n\t\u0005}\u0016\u0011\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAb\u0003\u0013l!!!2\u000b\t\u0005\u001d\u0017qJ\u0001\u0003S>L1!SAc)\t\t\t,\u0001\u0005u_N#(/\u001b8h)\t\t9%A\u0003baBd\u0017\u0010F\u0003V\u0003+\f9\u000eC\u0003L5\u0001\u0007Q\nC\u0003R5\u0001\u0007Q*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0017\u0011\u001e\t\u0006w\u0005}\u00171]\u0005\u0004\u0003Cd$AB(qi&|g\u000eE\u0003<\u0003KlU*C\u0002\u0002hr\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAv7\u0005\u0005\t\u0019A+\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002rB!\u0011\u0011JAz\u0013\u0011\t)0a\u0013\u0003\r=\u0013'.Z2u\u0001")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet x$0) {
        return FindInSet$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)((UTF8String)set).findInSet((UTF8String)word));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(word, set) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)set).append(".findInSet(").append((String)word).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    @Override
    public FindInSet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

