/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\r\u001b\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!Aa\b\u0001B\u0001B\u0003%q\bC\u0003D\u0001\u0011\u0005A\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\rY\u0003\u0001\u0015!\u0003L\u0011\u001d9\u0006A1A\u0005\naCa\u0001\u0018\u0001!\u0002\u0013IV\u0001B/\u0001\tyCqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004{\u0001\u0001\u0006I!\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\t9\u0001\u0001Q\u0001\nuD\u0001\"!\u0003\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003~\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\t\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA3\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003O\u0002A\u0011AA)\u0005I)f.\u001b<pG&$\u0018pR3oKJ\fGo\u001c:\u000b\u0005ma\u0012aA2tm*\u0011QDH\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rM\u001c\u0007.Z7b!\t\u00014'D\u00012\u0015\t\u0011d$A\u0003usB,7/\u0003\u00025c\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\r]\u0014\u0018\u000e^3s!\t9D(D\u00019\u0015\tI$(\u0001\u0002j_*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u00199&/\u001b;fe\u00069q\u000e\u001d;j_:\u001c\bC\u0001!B\u001b\u0005Q\u0012B\u0001\"\u001b\u0005)\u00195KV(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u00153u\t\u0013\t\u0003\u0001\u0002AQA\f\u0003A\u0002=BQ!\u000e\u0003A\u0002YBQA\u0010\u0003A\u0002}\nab\u001e:ji\u0016\u00148+\u001a;uS:<7/F\u0001L!\taE+D\u0001N\u0015\tYbJ\u0003\u0002P!\u00069\u0001/\u0019:tKJ\u001c(BA)S\u0003%)h.\u001b<pG&$\u0018PC\u0001T\u0003\r\u0019w.\\\u0005\u0003+6\u0013\u0011cQ:w/JLG/\u001a:TKR$\u0018N\\4t\u0003=9(/\u001b;feN+G\u000f^5oON\u0004\u0013aA4f]V\t\u0011\f\u0005\u0002M5&\u00111,\u0014\u0002\n\u0007N4xK]5uKJ\fAaZ3oA\tqa+\u00197vK\u000e{gN^3si\u0016\u0014\b#B\u0015`C\u0016D\u0017B\u00011+\u0005%1UO\\2uS>t'\u0007\u0005\u0002cG6\tA$\u0003\u0002e9\tY\u0011J\u001c;fe:\fGNU8x!\tIc-\u0003\u0002hU\t\u0019\u0011J\u001c;\u0011\u0005%\u0004hB\u00016o!\tY'&D\u0001m\u0015\tig%\u0001\u0004=e>|GOP\u0005\u0003_*\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011qNK\u0001\u0010m\u0006dW/Z\"p]Z,'\u000f^3sgV\tQ\u000fE\u0002*mbL!a\u001e\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005eLQ\"\u0001\u0001\u0002!Y\fG.^3D_:4XM\u001d;feN\u0004\u0013A\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005A$\u0001\u0003vi&d\u0017bAA\u0003\u007f\n\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003M!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:!\u0003U!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\fa\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'\u000fI\u0001\u000eI\u0006$XMR8s[\u0006$H/\u001a:\u0016\u0005\u0005E\u0001c\u0001@\u0002\u0014%\u0019\u0011QC@\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u00039!\u0017\r^3G_Jl\u0017\r\u001e;fe\u0002\nQ\"\\1lK\u000e{gN^3si\u0016\u0014Hc\u0001=\u0002\u001e!9\u0011q\u0004\nA\u0002\u0005\u0005\u0012\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007A\n\u0019#C\u0002\u0002&E\u0012\u0001\u0002R1uCRK\b/\u001a\u0015\u0004%\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\"&\u0001\u0006b]:|G/\u0019;j_:LA!a\r\u0002.\t9A/Y5me\u0016\u001c\u0017AC2p]Z,'\u000f\u001e*poR!\u0011\u0011HA&!\u0015\tY$!\u0012i\u001d\u0011\ti$!\u0011\u000f\u0007-\fy$C\u0001,\u0013\r\t\u0019EK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%!\u0013\u0003\u0007M+\u0017OC\u0002\u0002D)Ba!!\u0014\u0014\u0001\u0004\t\u0017a\u0001:po\u0006aqO]5uK\"+\u0017\rZ3sgR\u0011\u00111\u000b\t\u0004S\u0005U\u0013bAA,U\t!QK\\5u\u0003\u00159(/\u001b;f)\u0011\t\u0019&!\u0018\t\r\u00055S\u00031\u0001b\u000359(/\u001b;f)>\u001cFO]5oOR\u0019\u0001.a\u0019\t\r\u00055c\u00031\u0001b\u0003\u0015\u0019Gn\\:f\u0003\u00151G.^:i\u0001")
public class UnivocityGenerator {
    private final CSVOptions options;
    private final CsvWriterSettings writerSettings;
    private final CsvWriter gen;
    private final Function2<InternalRow, Object, String>[] valueConverters;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;

    private CsvWriterSettings writerSettings() {
        return this.writerSettings;
    }

    private CsvWriter gen() {
        return this.gen;
    }

    private Function2<InternalRow, Object, String>[] valueConverters() {
        return this.valueConverters;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private Function2<InternalRow, Object, String> makeConverter(DataType dataType) {
        Function2 & Serializable intersect;
        block8: {
            DataType dataType2;
            while (true) {
                if (DateType$.MODULE$.equals(dataType2 = dataType)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    break block8;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    break block8;
                }
                if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    break block8;
                }
                if (dataType2 instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
                    byte start = yearMonthIntervalType.startField();
                    byte end = yearMonthIntervalType.endField();
                    intersect = (Function2 & Serializable)(row, ordinal) -> IntervalUtils$.MODULE$.toYearMonthIntervalString(row.getInt(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
                    break block8;
                }
                if (dataType2 instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
                    byte start = dayTimeIntervalType.startField();
                    byte end = dayTimeIntervalType.endField();
                    intersect = (Function2 & Serializable)(row, ordinal) -> IntervalUtils$.MODULE$.toDayTimeIntervalString(row.getLong(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
                    break block8;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            if (dataType2 != null) {
                DataType dataType3 = dataType2;
                intersect = (Function2 & Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$6(dataType3, row, BoxesRunTime.unboxToInt((Object)ordinal));
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return intersect;
    }

    private Seq<String> convertRow(InternalRow row) {
        String[] values = new String[row.numFields()];
        for (int i = 0; i < row.numFields(); ++i) {
            if (!row.isNullAt(i)) {
                values[i] = (String)this.valueConverters()[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_NULL_VALUE_WRITTEN_AS_QUOTED_EMPTY_STRING_CSV()))) continue;
            values[i] = this.options.nullValue();
        }
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)values);
    }

    public void writeHeaders() {
        this.gen().writeHeaders();
    }

    public void write(InternalRow row) {
        this.gen().writeRow((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public String writeToString(InternalRow row) {
        return this.gen().writeRowToString((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$1(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.dateFormatter().format(row.getInt(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$2(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.timestampFormatter().format(row.getLong(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$3(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(row.getLong(ordinal)));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$6(DataType x8$1, InternalRow row, int ordinal) {
        return row.get(ordinal, x8$1).toString();
    }

    public UnivocityGenerator(StructType schema, Writer writer, CSVOptions options) {
        this.options = options;
        this.writerSettings = options.asWriterSettings();
        this.writerSettings().setHeaders(schema.fieldNames());
        this.gen = new CsvWriter(writer, this.writerSettings());
        this.valueConverters = (Function2[])((IterableOnceOps)((IterableOps)schema.map((Function1 & Serializable)x$1 -> x$1.dataType())).map((Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
    }
}

